//+------------------------------------------------------------------+
//|                                      PriceChannel_Stop_Digit.mq5 | 
//|                           Copyright  2005, TrendLaboratory Ltd. | 
//|                                       E-mail: igorad2004@list.ru | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, TrendLaboratory Ltd." 
//----    
#property link "E-mail: igorad2004@list.ru" 
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----        
#property indicator_buffers 6
//----     
#property indicator_plots   6
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_ARROW
//----        
#property indicator_color1  clrMagenta
//----    1  1
#property indicator_width1  1
//----    1
#property indicator_label1  "SellSignal"

//----   2   
#property indicator_type2   DRAW_ARROW
//----        
#property indicator_color2  clrMagenta
//----    2  1
#property indicator_width2  1
//----    2
#property indicator_label2 "SellStopSignal"

//----   3   
#property indicator_type3   DRAW_LINE
//----        
#property indicator_color3  clrMagenta
//----    3  1
#property indicator_width3  1
//----    3
#property indicator_label3 "SellStopLine"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//----   4   
#property indicator_type4   DRAW_ARROW
//----       - 
#property indicator_color4  clrLime
//----    4  1
#property indicator_width4  1
//----    4
#property indicator_label4  "BuySignal"

//----   5   
#property indicator_type5   DRAW_ARROW
//----       - 
#property indicator_color5  clrLime
//----    5  1
#property indicator_width5  1
//----    5
#property indicator_label5 "BuyStopSignal"

//----   6   
#property indicator_type6   DRAW_LINE
//----       - 
#property indicator_color6  clrLime
//----    6  1
#property indicator_width6  1
//----    6
#property indicator_label6 "BuyStopLine"

//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input string  SirName="PriceChannel_Stop_Digit";     //    
input int ChannelPeriod=5;
input double Risk=0.10;
input bool Signal=true;
input bool Line=true;
input uint Digit=2; //  
input bool ShowPrice=true; //  
//----   
input color  Price_color=clrBlue;
//+----------------------------------------------+

//----   ,    
//----      
double DownTrendSignal[];
double DownTrendBuffer[];
double DownTrendLine[];
double UpTrendSignal[];
double UpTrendBuffer[];
double UpTrendLine[];
//----
double PointPow10;
int StartBars;
//----     
string Price_name;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//----    
   StartBars=ChannelPeriod+1;
   PointPow10=_Point*MathPow(10,Digit);
//----  
   Price_name=SirName+"Price";
//----      
   SetIndexBuffer(0,DownTrendSignal,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,StartBars);
//---      DataWindow
   PlotIndexSetString(0,PLOT_LABEL,"SellSignal");
//----   
   PlotIndexSetInteger(0,PLOT_ARROW,108);
//----       
   ArraySetAsSeries(DownTrendSignal,true);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);

//----      
   SetIndexBuffer(1,DownTrendBuffer,INDICATOR_DATA);
//----       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,StartBars);
//---      DataWindow
   PlotIndexSetString(1,PLOT_LABEL,"SellStopSignal");
//----   
   PlotIndexSetInteger(1,PLOT_ARROW,159);
//----       
   ArraySetAsSeries(DownTrendBuffer,true);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);

//----      
   SetIndexBuffer(2,DownTrendLine,INDICATOR_DATA);
//----       3
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,StartBars);
//---      DataWindow
   PlotIndexSetString(2,PLOT_LABEL,"SellStopLine");
//----       
   ArraySetAsSeries(DownTrendLine,true);
//----      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0.0);

//----      
   SetIndexBuffer(3,UpTrendSignal,INDICATOR_DATA);
//----       4
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,StartBars);
//---      DataWindow
   PlotIndexSetString(3,PLOT_LABEL,"BuySignal");
//----   
   PlotIndexSetInteger(3,PLOT_ARROW,108);
//----       
   ArraySetAsSeries(UpTrendSignal,true);
//----      
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,0.0);

//----      
   SetIndexBuffer(4,UpTrendBuffer,INDICATOR_DATA);
//----       5
   PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,StartBars);
//---      DataWindow
   PlotIndexSetString(4,PLOT_LABEL,"BuyStopSignal");
//----   
   PlotIndexSetInteger(4,PLOT_ARROW,159);
//----       
   ArraySetAsSeries(UpTrendBuffer,true);
//----      
   PlotIndexSetDouble(4,PLOT_EMPTY_VALUE,0.0);

//----      
   SetIndexBuffer(5,UpTrendLine,INDICATOR_DATA);
//----       6
   PlotIndexSetInteger(5,PLOT_DRAW_BEGIN,StartBars);
//---      DataWindow
   PlotIndexSetString(5,PLOT_LABEL,"BuyStopLine");
//----       
   ArraySetAsSeries(UpTrendLine,true);
//----      
   PlotIndexSetDouble(5,PLOT_EMPTY_VALUE,0.0);
   
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----         
   string short_name="PriceChannel_Stop";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//----   
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+    
void OnDeinit(const int reason)
  {
//----
   ObjectDelete(0,Price_name);
//----
   ChartRedraw(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<StartBars) return(0);

//----    
   int limit,bar,iii,trend;
   double bsmax[],bsmin[],High,Low,Price,dPrice,stop=0.0;

//----     
   static int trend_;
   static double bsmax_,bsmin_;

//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-StartBars; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }

//----       
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);
   ArraySetAsSeries(time,true);

//----     
   if(ArrayResize(bsmax,limit+2)!=limit+2) return(0);
   if(ArrayResize(bsmin,limit+2)!=limit+2) return(0);

//----     
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      High=high[bar];
      Low =low [bar];
      iii=bar-1+ChannelPeriod;
      while(iii>=bar)
        {
         Price=high[iii];
         if(High<Price)High=Price;
         Price=low[iii];
         if(Low>Price) Low=Price;
         iii--;
        }
      dPrice=(High-Low)*Risk;
      bsmax[bar]=High-dPrice;
      bsmin[bar]=Low +dPrice;
     }

//----   
   bsmax[limit+1]=bsmax_;
   bsmin[limit+1]=bsmin_;
   trend=trend_;

//----    
   for(bar=limit; bar>=0; bar--)
     {
//----        
      if(rates_total!=prev_calculated && bar==0)
        {
         bsmax_=bsmax[1];
         bsmin_=bsmin[1];
         trend_=trend;
        }
//----        
      UpTrendBuffer  [bar]=0.0;
      DownTrendBuffer[bar]=0.0;
      UpTrendSignal  [bar]=0.0;
      DownTrendSignal[bar]=0.0;
      UpTrendLine    [bar]=0.0;
      DownTrendLine  [bar]=0.0;
//----
      if(close[bar]>bsmax[bar+1]) trend=+1;
      if(close[bar]<bsmin[bar+1]) trend=-1;
//----
      if(trend>0 && bsmin[bar]<bsmin[bar+1]) bsmin[bar]=bsmin[bar+1];
      if(trend<0 && bsmax[bar]>bsmax[bar+1]) bsmax[bar]=bsmax[bar+1];
//----
      if(trend>0)
        {
         Price=bsmin[bar];
         stop=PointPow10*MathRound(Price/PointPow10);
         if(Signal && DownTrendBuffer[bar+1]>0)
           {
            UpTrendSignal[bar]=stop;
            if(Line) UpTrendLine[bar]=stop;
           }
         else
           {
            UpTrendBuffer[bar]=stop;
            if(Line) UpTrendLine[bar]=stop;
           }
        }
//----
      if(trend<0)
        {
         Price=bsmax[bar];
         stop=PointPow10*MathRound(Price/PointPow10);
         if(Signal && UpTrendBuffer[bar+1]>0)
           {
            DownTrendSignal[bar]=stop;
            if(Line) DownTrendLine[bar]=stop;
           }
         else
           {
            DownTrendBuffer[bar]=stop;
            if(Line) DownTrendLine[bar]=stop;
           }
        }
     }
   if(ShowPrice)
     {
      int bar0=0;
      datetime time0=time[bar0]+1*PeriodSeconds();
      SetRightPrice(0,Price_name,0,time0,stop,Price_color);
     }
//----     
   ChartRedraw(0);
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|  RightPrice creation                                             |
//+------------------------------------------------------------------+
void CreateRightPrice(long chart_id,// chart ID
                      string   name,              // object name
                      int      nwin,              // window index
                      datetime time,              // price level time
                      double   price,             // price level
                      color    Color              // Text color
                      )
//---- 
  {
//----
   ObjectCreate(chart_id,name,OBJ_ARROW_RIGHT_PRICE,nwin,time,price);
   ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
   ObjectSetInteger(chart_id,name,OBJPROP_BACK,true);
   ObjectSetInteger(chart_id,name,OBJPROP_WIDTH,2);
//----
  }
//+------------------------------------------------------------------+
//|  RightPrice reinstallation                                       |
//+------------------------------------------------------------------+
void SetRightPrice(long chart_id,// chart ID
                   string   name,              // object name
                   int      nwin,              // window index
                   datetime time,              // price level time
                   double   price,             // price level
                   color    Color              // Text color
                   )
//---- 
  {
//----
   if(ObjectFind(chart_id,name)==-1) CreateRightPrice(chart_id,name,nwin,time,price,Color);
   else ObjectMove(chart_id,name,0,time,price);
//----
  }
//+------------------------------------------------------------------+
