//+------------------------------------------------------------------+
//|                                     Exp_i-SpectrAnalysis_RVI.mq5 |
//|                               Copyright  2016, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2016, Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"
//+-----------------------------------------------+
//|                              | 
//+-----------------------------------------------+
#include <TradeAlgorithms.mqh>
//+-----------------------------------------------+
//|             |
//+-----------------------------------------------+
input double MM=0.1;              //      
input MarginMode MMMode=LOT;      //   
input int    StopLoss_=1000;      //  
input int    TakeProfit_=2000;    //  
input int    Deviation_=10;       //.    
input bool   BuyPosOpen=true;     //    
input bool   SellPosOpen=true;    //    
input bool   BuyPosClose=true;     //    
input bool   SellPosClose=true;    //    
//+-----------------------------------------------+
//|                  |
//+-----------------------------------------------+
input ENUM_TIMEFRAMES InpInd_Timeframe=PERIOD_H4; // 
input uint SignalBar=1;//     
input uint RVIPeriod=14;                          // averaging period 
input uint N = 7;                                 // number Length 
input uint SS = 20;                               // smoothing factor 
//+----------------------------------------------+
//----          
int TimeShiftSec;
//----      
int InpInd_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//----    i-SpectrAnalysis_RVI
   InpInd_Handle=iCustom(Symbol(),InpInd_Timeframe,"i-SpectrAnalysis_RVI",RVIPeriod,N,SS,0);
   if(InpInd_Handle==INVALID_HANDLE)
     {
      Print("     i-SpectrAnalysis_RVI");
      return(INIT_FAILED);
     }
//----          
   TimeShiftSec=PeriodSeconds(InpInd_Timeframe);

//----     
   min_rates_total=int(MathPow(2,N))+1;
   min_rates_total+=int(1+2+SignalBar);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//----
   GlobalVariableDel_(Symbol());
//----
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//----       
   if(BarsCalculated(InpInd_Handle)<min_rates_total) return;

//----       IsNewBar()  SeriesInfoInteger()  
   LoadHistory(TimeCurrent()-PeriodSeconds(InpInd_Timeframe)-1,Symbol(),InpInd_Timeframe);

//----   
   double Line1[2],Line2[2];
//----   
   static bool Recount=true;
   static bool BUY_Open=false,BUY_Close=false;
   static bool SELL_Open=false,SELL_Close=false;
   static datetime UpSignalTime,DnSignalTime;
   static CIsNewBar NB;

//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
   if(!SignalBar || NB.IsNewBar(Symbol(),InpInd_Timeframe) || Recount) //     
     {
      //----   
      BUY_Open=false;
      SELL_Open=false;
      BUY_Close=false;
      SELL_Close=false;
      Recount=false;

      //----      
      if(CopyBuffer(InpInd_Handle,0,SignalBar,2,Line1)<=0) {Recount=true; return;}
      if(CopyBuffer(InpInd_Handle,1,SignalBar,2,Line2)<=0) {Recount=true; return;}

      //----    
      if(Line1[1]>Line2[1])
        {
         if(BuyPosOpen && Line1[0]<=Line2[0]) BUY_Open=true;
         if(SellPosClose) SELL_Close=true; 
         UpSignalTime=datetime(SeriesInfoInteger(Symbol(),InpInd_Timeframe,SERIES_LASTBAR_DATE))+TimeShiftSec;
        }

      //----    
      if(Line1[1]<Line2[1])
        {
         if(SellPosOpen && Line1[0]>=Line2[0]) SELL_Open=true;
         if(BuyPosClose) BUY_Close=true;
         DnSignalTime=datetime(SeriesInfoInteger(Symbol(),InpInd_Timeframe,SERIES_LASTBAR_DATE))+TimeShiftSec;
        }
     }

//+----------------------------------------------+
//|                              |
//+----------------------------------------------+
//----  
   BuyPositionClose(BUY_Close,Symbol(),Deviation_);

//----     
   SellPositionClose(SELL_Close,Symbol(),Deviation_);

//----  
   BuyPositionOpen(BUY_Open,Symbol(),UpSignalTime,MM,MMMode,Deviation_,StopLoss_,TakeProfit_);

//----  
   SellPositionOpen(SELL_Open,Symbol(),DnSignalTime,MM,MMMode,Deviation_,StopLoss_,TakeProfit_);
//----
  }
//+------------------------------------------------------------------+
