//+------------------------------------------------------------------+
//|                                              Exp_SMI_Correct.mq5 |
//|                               Copyright  2016, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2016, Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"
//+----------------------------------------------+
//                              | 
//+----------------------------------------------+
#include <TradeAlgorithms.mqh>
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
/*enum MarginMode  -     TradeAlgorithms.mqh
  {
   FREEMARGIN=0,     //MM     
   BALANCE,          //MM     
   LOSSFREEMARGIN,   //MM       
   LOSSBALANCE,      //MM       
   LOT               //  
  }; */
//+----------------------------------------------+
//|    CXMA                        |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
input double MM=0.1;              //      
input MarginMode MMMode=LOT;      //   
input int    StopLoss_=1000;      //  
input int    TakeProfit_=2000;    //  
input int    Deviation_=10;       //.    
input bool   BuyPosOpen=true;     //    
input bool   SellPosOpen=true;    //    
input bool   BuyPosClose=true;     //    
input bool   SellPosClose=true;    //    
//+----------------------------------------------+
//|    Exp_ColorMETRO  |
//+----------------------------------------------+
input ENUM_TIMEFRAMES InpInd_Timeframe=PERIOD_H4; // 
//----
input uint ExtrPeriod=13; //                    
input Smooth_Method MA_Method1=MODE_EMA_; //    
input uint Length1=25; //                       
input int Phase1=15; //  ,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input Smooth_Method MA_Method2=MODE_JJMA; //    
input uint Length2=3; //    
input int Phase2=15;  //  ,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input Smooth_Method MA_Method3=MODE_JJMA; //    
input uint Length3=5; //    
input int Phase3=15;  //  ,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_CLOSE_;// 
input int Shift=0; //      
input int HighLevel=+50;
input int MiddleLevel=0;
input int LowLevel=-50;
input color HighLevelsColor=clrBlue;
input color MiddleLevelsColor=clrGray;
input color LowLevelsColor=clrRed;
//----
input uint SignalBar=1;//     
//+----------------------------------------------+
//----          
int TimeShiftSec;
//----      
int InpInd_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//----    SMI_Correct
   InpInd_Handle=iCustom(Symbol(),InpInd_Timeframe,"SMI_Correct",
                         ExtrPeriod,MA_Method1,Length1,Phase1,MA_Method2,Length2,Phase2,MA_Method3,Length3,Phase3,IPC,0,0,0,0,clrNONE,clrNONE,clrNONE);
   if(InpInd_Handle==INVALID_HANDLE)
     {
      Print("      SMI_Correct");
      return(INIT_FAILED);
     }

//----          
   TimeShiftSec=PeriodSeconds(InpInd_Timeframe);

//----       
   min_rates_total=int(ExtrPeriod);
   min_rates_total+=GetStartBars(MA_Method1,Length1,Phase1);
   min_rates_total+=GetStartBars(MA_Method2,Length2,Phase2);
   min_rates_total+=GetStartBars(MA_Method3,Length3,Phase3);
   min_rates_total+=int(3+SignalBar);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//----
   GlobalVariableDel_(Symbol());
//----
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//----       
   if(BarsCalculated(InpInd_Handle)<min_rates_total) return;

//----       IsNewBar()  SeriesInfoInteger()  
   LoadHistory(TimeCurrent()-PeriodSeconds(InpInd_Timeframe)-1,Symbol(),InpInd_Timeframe);

//----   
   static bool Recount=true;
   static bool BUY_Open=false,BUY_Close=false;
   static bool SELL_Open=false,SELL_Close=false;
   static datetime UpSignalTime,DnSignalTime;
   static CIsNewBar NB;

//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
   if(!SignalBar || NB.IsNewBar(Symbol(),InpInd_Timeframe) || Recount) //     
     {
      //----   
      BUY_Open=false;
      SELL_Open=false;
      BUY_Close=false;
      SELL_Close=false;
      Recount=false;
      //----   
      double Ind[2],Sign[2];

      //----      
      if(CopyBuffer(InpInd_Handle,0,SignalBar,2,Ind)<=0) {Recount=true; return;}
      if(CopyBuffer(InpInd_Handle,1,SignalBar,2,Sign)<=0) {Recount=true; return;}

      //----    
      if(Ind[1]>Sign[1])
        {
         if(BuyPosOpen && Ind[0]<=Sign[0]) BUY_Open=true;
         if(SellPosClose) SELL_Close=true;
         UpSignalTime=datetime(SeriesInfoInteger(Symbol(),InpInd_Timeframe,SERIES_LASTBAR_DATE))+TimeShiftSec;
        }

      //----    
      if(Ind[1]<Sign[1])
        {
         if(SellPosOpen && Ind[0]>=Sign[0]) SELL_Open=true;
         if(BuyPosClose) BUY_Close=true;
         DnSignalTime=datetime(SeriesInfoInteger(Symbol(),InpInd_Timeframe,SERIES_LASTBAR_DATE))+TimeShiftSec;
        }
     }

//+----------------------------------------------+
//|                              |
//+----------------------------------------------+
//----  
   BuyPositionClose(BUY_Close,Symbol(),Deviation_);

//----     
   SellPositionClose(SELL_Close,Symbol(),Deviation_);

//----  
   BuyPositionOpen(BUY_Open,Symbol(),UpSignalTime,MM,MMMode,Deviation_,StopLoss_,TakeProfit_);

//----  
   SellPositionOpen(SELL_Open,Symbol(),DnSignalTime,MM,MMMode,Deviation_,StopLoss_,TakeProfit_);
//----
  }
//+------------------------------------------------------------------+
