//+---------------------------------------------------------------------+
//|                                                       XDPO_Sign.mq5 | 
//|                                           Copyright  2006, Ramdass | 
//|                                                                     | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2006, Ramdass"
#property link ""
//----   
#property version   "1.00"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 2
//---    
#property indicator_plots   2
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0       //        
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---        DeepPink 
#property indicator_color1  clrDeepPink
//---    1  4
#property indicator_width1  4
//---    
#property indicator_label1  "XDPO Sell"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---        DodgerBlue 
#property indicator_color2  clrDodgerBlue
//---    2  4
#property indicator_width2  4
//---    
#property indicator_label2 "XDPO Buy"

//+----------------------------------------------+
//|    CXMA                        |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+

//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input Smooth_Method MA_Method1=MODE_SMA_; //  
input int Length1=12; //                     
input int Phase1=15; //  ,
                     // JJMA    -100 ... +100,     ;
//  VIDIA   CMO,  AMA    
input Smooth_Method MA_Method2=MODE_JJMA; //  
input int Length2= 5; //  
input int Phase2=15;  // ,
                      // JJMA    -100 ... +100,     ;
//  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_CLOSE_;// 
input int Shift=0; //      
//+----------------------------------------------+
//----   ,    
//      
double SellBuffer[],BuyBuffer[];
//----      
int ATR_Handle;
//----      
int min_rates_total,min_rates_1,min_rates_2;
//+------------------------------------------------------------------+   
//| XDPO indicator initialization function                           | 
//+------------------------------------------------------------------+ 
int OnInit()
  {
//----     
   min_rates_1=XMA1.GetStartBars(MA_Method1, Length1, Phase1);
   min_rates_2=XMA2.GetStartBars(MA_Method2, Length2, Phase2);
   min_rates_total=min_rates_1+min_rates_2+1;
   int ATR_Period=10;
   min_rates_total=int(MathMax(min_rates_total,ATR_Period));
//----    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//----       
   XMA1.XMALengthCheck("Length1", Length1);
   XMA2.XMALengthCheck("Length2", Length2);
//----       
   XMA1.XMAPhaseCheck("Phase1", Phase1, MA_Method1);
   XMA2.XMAPhaseCheck("Phase2", Phase2, MA_Method2);

//----      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(0,PLOT_ARROW,172);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);

//----      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//----       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(1,PLOT_ARROW,172);
//----    1  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);

//----      
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(MA_Method1);
   string Smooth2=XMA1.GetString_MA_Method(MA_Method2);
   StringConcatenate(shortname,"XDPO_Histogram(",Length1,", ",Length2,", ",Smooth1,", ",Smooth2,")");
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+ 
//| XDPO iteration function                                          | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);

//----       
   double price,x1xma,diff,xdiff,ATR[1];
   static double xdiff_prev,xdiff_prev_prev;
//----        
   int first,bar;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=0; //      
      xdiff_prev=0.0;
      xdiff_prev_prev=0.0;
     }
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      price=PriceSeries(IPC,bar,open,low,high,close);
      x1xma= XMA1.XMASeries(0,prev_calculated,rates_total,MA_Method1,Phase1,Length1,price,bar,false);
      diff=price-x1xma;
      xdiff=XMA2.XMASeries(min_rates_1,prev_calculated,rates_total,MA_Method2,Phase2,Length2,diff,bar,false);
      
      BuyBuffer[bar]=0.0;
      SellBuffer[bar]=0.0;

      if(xdiff_prev_prev>xdiff_prev && xdiff_prev<xdiff)
        {
         //----      
         if(CopyBuffer(ATR_Handle,0,time[bar],1,ATR)<=0) return(RESET);
         BuyBuffer[bar]=low[bar]-ATR[0]*3/8;
        }
        
      if(xdiff_prev_prev<xdiff_prev && xdiff_prev>xdiff)
        {
         //----      
         if(CopyBuffer(ATR_Handle,0,time[bar],1,ATR)<=0) return(RESET);
         SellBuffer[bar]=high[bar]+ATR[0]*3/8;
        }

      if(bar<rates_total-1)
        {
         xdiff_prev_prev=xdiff_prev;
         xdiff_prev=xdiff;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
