//+------------------------------------------------------------------+
//|                                                     RVICloud.mq5 |
//|                                                                  |
//| RVI                                                              |
//|                                                                  |
//| Algorithm taken from book                                        |
//|     "Cybernetics Analysis for Stock and Futures"                 |
//| by John F. Ehlers                                                |
//|                                                                  |
//|                                              contact@mqlsoft.com |
//|                                          http://www.mqlsoft.com/ |
//+------------------------------------------------------------------+
//----  
#property copyright "Coded by Witold Wozniak"
//----  
#property link      "www.mqlsoft.com"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 2
//----    
#property indicator_plots   1
//+----------------------------------------------+
//|    Adaptive RVI  |
//+----------------------------------------------+
//----   1    
#property indicator_type1   DRAW_FILLING
//----   jd  
#property indicator_color1  clrBlue,clrRed
//----    
#property indicator_label1  "RVI"
//+----------------------------------------------+
//|    Trigger       |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----         
#property indicator_color2  Blue
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  1
#property indicator_width2  1
//----    
#property indicator_label2  "Trigger"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 0.0
#property indicator_levelcolor Gray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int Length=8; //  
input int Shift=0; //       
//+----------------------------------------------+
//----   ,    
//      
double RVIBuffer[];
double TriggerBuffer[];
//----      
int min_rates_total;
//----   
int Count[];
double Value1[],Value2[],dPriceHL[],dPriceOC[];
//+------------------------------------------------------------------+
//|                          |
//+------------------------------------------------------------------+   
double Get_dPrice(const double  &Price1[],const double  &Price2[],int bar)
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
  {
//----
   return(Price1[bar]-Price2[bar]);
  }
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos
(
 int &CoArr[],//        
 int Size
 )
// Recount_ArrayZeroPos(count, Length)
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
  {
//----
   int numb,Max1,Max2;
   static int count=1;

   Max2=Size;
   Max1=Max2-1;
   
   count--;
   if(count<0) count=Max1;

   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
//----
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total=Length+3;

//----       
   ArrayResize(Count,Length);
   ArrayResize(Value1,Length);
   ArrayResize(Value2,Length);

//----      
   SetIndexBuffer(0,RVIBuffer,INDICATOR_DATA);
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1  min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   SetIndexBuffer(1,TriggerBuffer,INDICATOR_DATA);

//----      
   string shortname;
   StringConcatenate(shortname,"RVI(",Length,", ",Shift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,2);
//----
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(RESET);

//----    
   int first,bar;
   double Num,Denom,rvi;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
        first=3; //      
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      Value1[Count[0]]=(Get_dPrice(close,open,bar)
                        +2.0*Get_dPrice(close,open,bar-1)
                        +2.0*Get_dPrice(close,open,bar-2)
                        +Get_dPrice(close,open,bar-3))/6.0;
                        
      Value2[Count[0]]=(Get_dPrice(high,low,bar)
                        +2.0*Get_dPrice(high,low,bar-1)
                        +2.0*Get_dPrice(high,low,bar-2)
                        +Get_dPrice(high,low,bar-3))/6.0;

      Num=0.0;
      Denom=0.0;

      for(int iii=0; iii<Length; iii++)
        {
         Num+=Value1[Count[iii]];
         Denom+=Value2[Count[iii]];
        }

      if(Denom!=0.0) rvi=Num/Denom;
      else rvi=0.0;

      RVIBuffer[bar]=rvi;     
      TriggerBuffer[bar]=RVIBuffer[bar-1];

      if(bar<rates_total-1) Recount_ArrayZeroPos(Count,Length);
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
