//+------------------------------------------------------------------+
//|                                           FineTuningMA_StDev.mq5 | 
//|                                         Copyright  2010, gumgum |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010, gumgum"
#property link      ""
//----   
#property version   "1.00"
//----  
#property description "    "
//----     
#property indicator_chart_window 
//----        
#property indicator_buffers 5
//----     
#property indicator_plots   5
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       RoyalBlue 
#property indicator_color1 clrRoyalBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     3
#property indicator_width1  3
//----   
#property indicator_label1  "FineTuningMA"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_ARROW
//----        
#property indicator_color2  clrRed
//----    2  2
#property indicator_width2  2
//----    
#property indicator_label2  "Dn_Signal 1"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_ARROW
//----        
#property indicator_color3  clrSpringGreen
//----    3  2
#property indicator_width3  2
//----    
#property indicator_label3  "Up_Signal 1"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   4   
#property indicator_type4   DRAW_ARROW
//----        
#property indicator_color4  clrRed
//----    4  4
#property indicator_width4  4
//----    
#property indicator_label4  "Dn_Signal 2"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//----   5   
#property indicator_type5   DRAW_ARROW
//----        
#property indicator_color5  clrSpringGreen
//----    5  4
#property indicator_width5  4
//----    
#property indicator_label5  "Up_Signal 2"
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint   FTMA=10;
input double rank1=2;
input double rank2=2;
input double rank3=2;
input double shift1=1;
input double shift2=1;
input double shift3=1;
input Applied_price_ IPC=PRICE_TYPICAL_;// 
  input double dK1=1.5;  // 1   
input double dK2=2.5;  // 2   
input uint std_period=9; //  
input int Shift=0; //      
input int PriceShift=0; // c     
//+----------------------------------------------+

//----   ,    
//      
double LineBuffer[];
double BearsBuffer1[],BullsBuffer1[];
double BearsBuffer2[],BullsBuffer2[];
//----
double PM[],dFTMA[];
//----      
double dPriceShift;
//----      
int min_rates_total;
//+------------------------------------------------------------------+   
//| FineTuningMA indicator initialization function                   | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----    
   dPriceShift=_Point*PriceShift;

//----       
   ArrayResize(PM,FTMA); 
   ArrayResize(dFTMA,std_period);

//----  
   double sum=0;
   for(int h=0; h<int(FTMA); h++)
     {
      PM[h]=shift1+MathPow(h/(FTMA-1.0),rank1)*(1.0-shift1);
      PM[h]=(shift2+MathPow(1-(h/(FTMA-1.0)),rank2)*(1.0-shift2))*PM[h];

      if((h/(FTMA-1.))<0.5) PM[h]=(shift3+MathPow((1-(h/(FTMA-1.0))*2.0),rank3)*(1.0-shift3))*PM[h];
      else PM[h]=(shift3+MathPow((h/(FTMA-1.0))*2.0-1.0,rank3)*(1.0-shift3))*PM[h];

      sum+=PM[h];
     }

   double sum1=0;
   for(int h=0; h<int(FTMA); h++)
     {
      PM[h]=PM[h]/sum;
      sum1+=PM[h];
     }

//----     
   min_rates_total=int(FTMA)+int(std_period);

//----      
   SetIndexBuffer(0,LineBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
   
//----    BearsBuffer   
   SetIndexBuffer(1,BearsBuffer1,INDICATOR_DATA);
//----    2  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(1,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----    BullsBuffer   
   SetIndexBuffer(2,BullsBuffer1,INDICATOR_DATA);
//----    3  
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(2,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----    BearsBuffer   
   SetIndexBuffer(3,BearsBuffer2,INDICATOR_DATA);
//----    2  
   PlotIndexSetInteger(3,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(3,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----    BullsBuffer   
   SetIndexBuffer(4,BullsBuffer2,INDICATOR_DATA);
//----    3  
   PlotIndexSetInteger(4,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(4,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(4,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"FineTuningMA_StDev");

//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
  }
//+------------------------------------------------------------------+ 
//| FineTuningMA iteration function                                  | 
//+------------------------------------------------------------------+ 
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----        
   int first,bar;
   double ftma,SMAdif,Sum,StDev,dstd,BEARS1,BULLS1,BEARS2,BULLS2,Filter1,Filter2;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=min_rates_total; //      
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      double sum1=0;
      for(int h=0; h<int(FTMA); h++) sum1+=PM[h]*PriceSeries(IPC,bar-h,open,low,high,close);
      LineBuffer[bar]=sum1+dPriceShift;
     }
     
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=min_rates_total;
//----      
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //----        
      for(int iii=0; iii<int(std_period); iii++) dFTMA[iii]=LineBuffer[bar-iii]-LineBuffer[bar-iii-1];

      //----     
      Sum=0.0;
      for(int iii=0; iii<int(std_period); iii++) Sum+=dFTMA[iii];
      SMAdif=Sum/std_period;

      //----       
      Sum=0.0;
      for(int iii=0; iii<int(std_period); iii++) Sum+=MathPow(dFTMA[iii]-SMAdif,2);

      //----      StDev   
      StDev=MathSqrt(Sum/std_period);

      //----  
      dstd=NormalizeDouble(dFTMA[0],_Digits+2);
      Filter1=NormalizeDouble(dK1*StDev,_Digits+2);
      Filter2=NormalizeDouble(dK2*StDev,_Digits+2);
      BEARS1=EMPTY_VALUE;
      BULLS1=EMPTY_VALUE;
      BEARS2=EMPTY_VALUE;
      BULLS2=EMPTY_VALUE;
      ftma=LineBuffer[bar];

      //----   
      if(dstd<-Filter1 && dstd>=-Filter2) BEARS1=ftma; //  
      if(dstd<-Filter2) BEARS2=ftma; //  
      if(dstd>+Filter1 && dstd<=+Filter2) BULLS1=ftma; //  
      if(dstd>+Filter2) BULLS2=ftma; //  

      //----       
      BullsBuffer1[bar]=BULLS1;
      BearsBuffer1[bar]=BEARS1;
      BullsBuffer2[bar]=BULLS2;
      BearsBuffer2[bar]=BEARS2;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//| PriceSeries() function                                           |
//+------------------------------------------------------------------+
double PriceSeries
(
 uint applied_price,//  
 uint   bar,//            ).
 const double &Open[],
 const double &Low[],
 const double &High[],
 const double &Close[]
 )
//PriceSeries(applied_price, bar, open, low, high, close)
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
  {
//----
   switch(applied_price)
     {
      //----     ENUM_APPLIED_PRICE
      case  PRICE_CLOSE: return(Close[bar]);
      case  PRICE_OPEN: return(Open [bar]);
      case  PRICE_HIGH: return(High [bar]);
      case  PRICE_LOW: return(Low[bar]);
      case  PRICE_MEDIAN: return((High[bar]+Low[bar])/2.0);
      case  PRICE_TYPICAL: return((Close[bar]+High[bar]+Low[bar])/3.0);
      case  PRICE_WEIGHTED: return((2*Close[bar]+High[bar]+Low[bar])/4.0);

      //----                            
      case  8: return((Open[bar] + Close[bar])/2.0);
      case  9: return((Open[bar] + Close[bar] + High[bar] + Low[bar])/4.0);
      //----                                
      case 10:
        {
         if(Close[bar]>Open[bar])return(High[bar]);
         else
           {
            if(Close[bar]<Open[bar])
               return(Low[bar]);
            else return(Close[bar]);
           }
        }
      //----         
      case 11:
        {
         if(Close[bar]>Open[bar])return((High[bar]+Close[bar])/2.0);
         else
           {
            if(Close[bar]<Open[bar])
               return((Low[bar]+Close[bar])/2.0);
            else return(Close[bar]);
           }
         break;
        }
      //----
      default: return(Close[bar]);
     }
//----
//return(0);
  }
//+------------------------------------------------------------------+
