//+------------------------------------------------------------------+ 
//|                                            Squeeze_RA_V1_HTF.mq5 | 
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.00"
#property description " Squeeze_RA_V1       "
//----     
#property indicator_separate_window 
//----    6
#property indicator_buffers 6 
//----     
#property indicator_plots   6
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                                      //        
#define INDICATOR_NAME "Squeeze_RA_V1"               //    
#define SIZE 6                                       //      CountIndicator
//+----------------------------------------------+
//|    1             |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_HISTOGRAM
//----       MediumBlue 
#property indicator_color1 clrMediumBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     3
#property indicator_width1  3
//----   
#property indicator_label1  "SqzFiredLong"
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//----     
#property indicator_type2   DRAW_HISTOGRAM
//----       Tomato 
#property indicator_color2 clrTomato
//----   -  
#property indicator_style2  STYLE_SOLID
//----     3
#property indicator_width2 3
//----   
#property indicator_label2 "SqzFiredShort"
//+----------------------------------------------+
//|    3             |
//+----------------------------------------------+
#property indicator_type3   DRAW_HISTOGRAM
//----       DodgerBlue 
#property indicator_color3  clrDodgerBlue
//----   -  
#property indicator_style3  STYLE_SOLID
//----     3
#property indicator_width3 3
//----   
#property indicator_label3 "SqzFiredLong_Weak"
//+----------------------------------------------+
//|    4             |
//+----------------------------------------------+
//----     
#property indicator_type4   DRAW_HISTOGRAM
//----       Orange 
#property indicator_color4  clrOrange
//----   -  
#property indicator_style4  STYLE_SOLID
//----     3
#property indicator_width4 3
//----   
#property indicator_label4 "SqzFiredShort_Weak"
//+----------------------------------------------+
//|    5             |
//+----------------------------------------------+
//----     
#property indicator_type5   DRAW_ARROW
//----       Lime 
#property indicator_color5  clrLime
//----   -  
#property indicator_style5  STYLE_SOLID
//----     3
#property indicator_width5 3
//----   
#property indicator_label5 "Squeeze_Off"
//+----------------------------------------------+
//|    6             |
//+----------------------------------------------+
//----     
#property indicator_type6   DRAW_ARROW
//----       Magenta 
#property indicator_color6  clrMagenta
//----   -  
#property indicator_style6  STYLE_SOLID
//----     3
#property indicator_width6 3
//----   
#property indicator_label6 "Squeeze_On"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;  //   
//+----------------------------------------------+
//----   ,    
//----      
double IndBuffer1[],IndBuffer2[],IndBuffer3[],IndBuffer4[],IndBuffer5[],IndBuffer6[];
//----   
string Symbol_,Word;
//----      
int min_rates_total;
//----      
int Ind_Handle;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   if(!TimeFramesCheck(INDICATOR_NAME,TimeFrame)) return(INIT_FAILED);
//----   
   min_rates_total=2;
   Symbol_=Symbol();
   Word=INDICATOR_NAME+" : "+Symbol_+StringSubstr(EnumToString(_Period),7,-1);
//----    Squeeze_RA_V1
   Ind_Handle=iCustom(Symbol(),TimeFrame,INDICATOR_NAME);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      Squeeze_RA_V1");
      return(INIT_FAILED);
     }
//----   
   IndInit(0,IndBuffer1,EMPTY_VALUE,min_rates_total,0);
   IndInit(1,IndBuffer2,EMPTY_VALUE,min_rates_total,0);
   IndInit(2,IndBuffer3,EMPTY_VALUE,min_rates_total,0);
   IndInit(3,IndBuffer4,EMPTY_VALUE,min_rates_total,0);
   IndInit(4,IndBuffer5,EMPTY_VALUE,min_rates_total,0);
   IndInit(5,IndBuffer6,EMPTY_VALUE,min_rates_total,0);
//----           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME,"(",GetStringTimeframe(TimeFrame),")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//----         
   ArraySetAsSeries(time,true);
//----
   if(!CountIndicator(0,NULL,TimeFrame,Ind_Handle,0,IndBuffer1,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(1,NULL,TimeFrame,Ind_Handle,1,IndBuffer2,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(2,NULL,TimeFrame,Ind_Handle,2,IndBuffer3,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(3,NULL,TimeFrame,Ind_Handle,3,IndBuffer4,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(4,NULL,TimeFrame,Ind_Handle,4,IndBuffer5,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(5,NULL,TimeFrame,Ind_Handle,5,IndBuffer6,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+    
void IndInit(int Number,double &Buffer[],double Empty_Value,int Draw_Begin,int nShift)
  {
//----      
   SetIndexBuffer(Number,Buffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(Number,PLOT_DRAW_BEGIN,Draw_Begin);
//----   ,      
   PlotIndexSetDouble(Number,PLOT_EMPTY_VALUE,Empty_Value);
//----       Shift
   PlotIndexSetInteger(Number,PLOT_SHIFT,nShift);
//----       
   ArraySetAsSeries(Buffer,true);
  }
//+------------------------------------------------------------------+
//| CountLine                                                        |
//+------------------------------------------------------------------+
bool CountIndicator(uint     Numb,            //   CountLine      (  - 0)
                    string   Symb,            //  
                    ENUM_TIMEFRAMES TFrame,   //  
                    int      IndHandle,       //   
                    uint     BuffNumb,        //    
                    double&  IndBuf[],        //   
                    const datetime& iTime[],  //  
                    const int Rates_Total,    //       
                    const int Prev_Calculated,//       
                    const int Min_Rates_Total)//       
  {
//----
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;
//----      
//----   limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       
//----    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----      
      IndBuf[bar]=0.0;
      //----       IndTime
      if(CopyTime(Symbol_,TFrame,iTime[bar],1,IndTime)<=0) return(RESET);
      //----
      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double Arr[1];
         //----      
         if(CopyBuffer(IndHandle,BuffNumb,iTime[bar],1,Arr)<=0) return(RESET);
         //----
         IndBuf[bar]=Arr[0];
        }
      else IndBuf[bar]=IndBuf[bar+1];
     }
//----     
   return(true);
  }
//+------------------------------------------------------------------+
//| TimeFramesCheck()                                                |
//+------------------------------------------------------------------+    
bool TimeFramesCheck(string IndName,
                     ENUM_TIMEFRAMES TFrame) //  
  {
//----     
   if(TFrame<Period() && TFrame!=PERIOD_CURRENT)
     {
      Print("    "+IndName+"       !");
      Print("    !");
      return(RESET);
     }
//----
   return(true);
  }
//+------------------------------------------------------------------+
