//+---------------------------------------------------------------------+
//|                                                Ultra_Oscillator.mq5 | 
//|                                Copyright  2015, Yuriy Tokman (YTG) | 
//|                                                  http://ytg.com.ua/ | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2015, Yuriy Tokman (YTG)"
#property link "http://ytg.com.ua/"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window 
//----   
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       DodgerBlue 
#property indicator_color1 clrDodgerBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "Ultra_Oscillator"
//+-----------------------------------+
//|   CXMA              |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2,XMA3;
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input Smooth_Method XMA_Method=MODE_LWMA; //  
input int XLength1=7;  //   1
input int XLength2=14; //   2
input int XLength3=28; //   3
input int XPhase=15; //  
                     //  JJMA    -100 ... +100,     ;
//  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_CLOSE; //  
input int Shift=0; //      
//+-----------------------------------+
//----   ,    
//----      
double IndBuffer[];
//----      
int min_rates_total;
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   int Length=MathMax(XLength1,MathMax(XLength2,XLength3));
   min_rates_total=GetStartBars(XMA_Method,Length,XPhase);
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(XMA_Method);
   StringConcatenate(shortname,"Ultra_Oscillator(",XLength1,", ",XLength2,", ",XLength3,", ",Smooth1,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----       
   double price;
//----        
   int first,bar;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=0; //      
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      price=PriceSeries(IPC,bar,open,low,high,close);
      IndBuffer[bar]=XMA1.XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,XLength1,price,bar,false)
                     +XMA2.XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,XLength2,price,bar,false)
                     +XMA3.XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,XLength3,price,bar,false);
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
