//+------------------------------------------------------------------+
//|                                                          WPR.mq5 |
//|                                       Copyright  2005, Dark Han |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2005, Dark Han"
//----    
#property link      "http://www.metaquotes.net/"
#property description "Williams Percent Range"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----    1
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//----       
#property indicator_maximum 0
#property indicator_minimum -100
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type1 DRAW_LINE
//----      MediumOrchid 
#property indicator_color1 clrMediumOrchid
//----   - 
#property indicator_style1 STYLE_SOLID
//----     2
#property indicator_width1 2
//----    
#property indicator_label1  "WPR"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 -30
#property indicator_level2 -70
#property indicator_levelcolor clrGray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum ENUM_APPLIED_PRICE_ // 
  {
   PRICE_CLOSE_ = 1,     //PRICE_CLOSE
   PRICE_HIGH_,          //PRICE_HIGH
   PRICE_LOW_            //PRICE_LOW
  };
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint ExtWPRPeriod=11;                       //  
input ENUM_APPLIED_PRICE_ IPC=PRICE_CLOSE_;       //  
input int Shift = 0;                              //      
//+----------------------------------------------+
//----   ,    
//----      
double ExtLineBuffer[];
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total=int(ExtWPRPeriod);
//----    ExtLineBuffer   
   SetIndexBuffer(0,ExtLineBuffer,INDICATOR_DATA);
//----      
   string shortname;
   StringConcatenate(shortname,"WPR(",ExtWPRPeriod," ",EnumToString(IPC),")");
//----    1    ATRShift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----          
   ArraySetAsSeries(ExtLineBuffer,true);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
//----    
   int limit,bar;
   double range,HH,LL;
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-1; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
//----         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ExtLineBuffer[bar]=50;
      HH=high[ArrayMaximum(high,bar,ExtWPRPeriod)];
      LL=low[ArrayMinimum(low,bar,ExtWPRPeriod)];
      range=HH-LL;
//----
      if(!CompareDouble(range,0.0))
         switch(IPC)
           {
            case PRICE_CLOSE_ :
              {
               ExtLineBuffer[bar]=-100*(HH-close[bar])/range;
               break;
              }
            case PRICE_HIGH_ :
              {
               ExtLineBuffer[bar]=-100*(HH-high[bar])/range;
               break;
              }
            case PRICE_LOW_ :
              {
               ExtLineBuffer[bar]=-100*(HH-low[bar])/range;
               break;
              }
           }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                             |
//+------------------------------------------------------------------+
bool CompareDouble(double Number1,double Number2)
  {
//----
   bool Compare=NormalizeDouble(Number1-Number2,8)==0;
//----
   return(Compare);
  }
//+------------------------------------------------------------------+
