//+---------------------------------------------------------------------+
//|                                                       VininI_BB.mq5 |
//|                        Copyright  2011, Victor Niclolaev aka Vinin |
//|                                                       vinin@mail.ru |
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2011, Victor Niclolaev aka Vinin"
#property link      "vinin@mail.ru"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 3 
//----    
#property indicator_plots   3
//+-----------------------------------+
//|    1  |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----        
#property indicator_color1 clrOliveDrab
//----   -  
#property indicator_style1  STYLE_SOLID
//----     3
#property indicator_width1  3
//----   
#property indicator_label1  "Upper VininI_BB"
//+-----------------------------------+
//|    2  |
//+-----------------------------------+
//----     
#property indicator_type2   DRAW_LINE
//----        
#property indicator_color2 clrGray
//----   -  
#property indicator_style2  STYLE_SOLID
//----     3
#property indicator_width2  3
//----   
#property indicator_label2  "Middle VininI_BB"
//+-----------------------------------+
//|    3  |
//+-----------------------------------+
//----     
#property indicator_type3   DRAW_LINE
//----        
#property indicator_color3 clrPaleVioletRed
//----   -  
#property indicator_style3  STYLE_SOLID
//----     3
#property indicator_width3  3
//----   
#property indicator_label3  "Lower VininI_BB"
//+-----------------------------------+
//|   CXMA              |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//----    CXMA  CStdDeviation   SmoothAlgorithms.mqh
CXMA XMA1;
CStdDeviation STD;
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input Smooth_Method JMethod=MODE_SMA; //   
input uint JLength=100; //    
input int JPhase=15; //   
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input double BandsDeviation=1.0; // 
input Applied_price_ IPC=PRICE_CLOSE;//  
input int Shift=0; //      
//+-----------------------------------+
//----  
double UpperBuffer[];
double MiddleBuffer[];
double lowerBuffer[];
//----      
int min_rates_total;
//+------------------------------------------------------------------+    
//| VininI_BB Channel indicator initialization function              | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total=int(JLength)+1;
//----      
   SetIndexBuffer(0,UpperBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   SetIndexBuffer(1,MiddleBuffer,INDICATOR_DATA);
//----    2  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   SetIndexBuffer(2,lowerBuffer,INDICATOR_DATA);
//----    3  
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----       3
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   string shortname;
   StringConcatenate(shortname,"VininI_BB(JLength=",JLength,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+  
//| VininI_BB Channel iteration function                             | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----       
   double price,xma,stdev;
//----   
   int first,bar;
//----    first    
   if(prev_calculated==0) //      
     {
      first=1; //      
      UpperBuffer[first-1]=0.0;
      lowerBuffer[first-1]=99999999.99999999;
     }
   else
     {
      first=prev_calculated-1;//      
     }
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      UpperBuffer[bar]=EMPTY_VALUE;
      lowerBuffer[bar]=EMPTY_VALUE;
      MiddleBuffer[bar]=EMPTY_VALUE;
      //----
      price=PriceSeries(IPC,bar,open,low,high,close);
      xma=XMA1.XMASeries(1,prev_calculated,rates_total,JMethod,JPhase,JLength,price,bar,false);
      stdev=STD.StdDevSeries(1,prev_calculated,rates_total,JLength,BandsDeviation,price,xma,bar,false);
      stdev*=BandsDeviation;
      //----
      UpperBuffer[bar]=UpperBuffer[bar-1];
      lowerBuffer[bar]=lowerBuffer[bar-1];
      if(high[bar]>UpperBuffer[bar])
        {
         UpperBuffer[bar]=high[bar];
         lowerBuffer[bar]=high[bar]-2.0*stdev;
         if(lowerBuffer[bar]<lowerBuffer[bar-1]) lowerBuffer[bar]=lowerBuffer[bar-1];
        }
      if(low[bar]<lowerBuffer[bar])
        {
         lowerBuffer[bar]=low[bar];
         UpperBuffer[bar]=low[bar]+2.0*stdev;
         if(UpperBuffer[bar]>UpperBuffer[bar-1]) UpperBuffer[bar]=UpperBuffer[bar-1];
        }
      MiddleBuffer[bar]=(UpperBuffer[bar]+lowerBuffer[bar])*0.5;
     }
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+
