//+--------------------------------------------------------------------------+
//|                                                     Laguerre_ADXSign.mq5 |
//|                         Copyright  2005, Emerald King / transport_david | 
//| http://finance.groups.yahoo.com/group/MetaTrader_Experts_and_Indicators/ | 
//+--------------------------------------------------------------------------+
#property copyright "Copyright  2007, Emerald King / transport_david"
#property link "http://finance.groups.yahoo.com/group/MetaTrader_Experts_and_Indicators/"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----        
#property indicator_buffers 2
//----     
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---         
#property indicator_color1  clrMagenta
//---    1  4
#property indicator_width1  4
//---    
#property indicator_label1  "Laguerre_ADX Sell"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---         
#property indicator_color2  clrDodgerBlue
//---    2  4
#property indicator_width2  4
//---    
#property indicator_label2 "Laguerre_ADX Buy"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint ADXPeriod=14;
input double gamma=0.764;
input int Shift=0;                                 //       
//+----------------------------------------------+
//----   ,    
//      
double SellBuffer[];
double BuyBuffer[];
//----      
int min_rates_total;
//----      
int ADX_Handle,ATR_Handle;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   int ATR_Period=15;
   min_rates_total=int(MathMax(ATR_Period,ADXPeriod));

//----    iADX
   ADX_Handle=iADX(NULL,0,ADXPeriod);
   if(ADX_Handle==INVALID_HANDLE)
     {
      Print("      iADX");
      return(INIT_FAILED);
     }
//----    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//----      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(0,PLOT_ARROW,234);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//----       
   ArraySetAsSeries(SellBuffer,true);

//----      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//----       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(1,PLOT_ARROW,233);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//----       
   ArraySetAsSeries(BuyBuffer,true);
   
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(ATR_Handle)<rates_total || BarsCalculated(ADX_Handle)<rates_total || rates_total<min_rates_total) return(RESET);

//----    
   int to_copy,limit,bar;
   double pL0,pL1,pL2,pL3,pL0A,pL1A,pL2A,pL3A,mL0,mL1,mL2,mL3,mL0A,mL1A,mL2A,mL3A,LDMIP=0,LDMIM=0,CU,CD,DMIP[],DMIM[],ATR[];
//----        
   static double pL0_,pL1_,pL2_,pL3_,pL0A_,pL1A_,pL2A_,pL3A_,LDMIP_;
   static double mL0_,mL1_,mL2_,mL3_,mL0A_,mL1A_,mL2A_,mL3A_,LDMIM_;

//----       
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      limit=rates_total-min_rates_total-1; //      
      //----    
      pL0_ = 0.0;
      pL1_ = 0.0;
      pL2_ = 0.0;
      pL3_ = 0.0;
      pL0A_ = 0.0;
      pL1A_ = 0.0;
      pL2A_ = 0.0;
      pL3A_ = 0.0;
      //----    
      mL0_ = 0.0;
      mL1_ = 0.0;
      mL2_ = 0.0;
      mL3_ = 0.0;
      mL0A_ = 0.0;
      mL1A_ = 0.0;
      mL2A_ = 0.0;
      mL3A_ = 0.0;
     }
   else limit=rates_total-prev_calculated; //      
   to_copy=limit+1;

//----      
   if(CopyBuffer(ADX_Handle,PLUSDI_LINE,0,to_copy,DMIP)<=0) return(RESET);
   if(CopyBuffer(ADX_Handle,MINUSDI_LINE,0,to_copy,DMIM)<=0) return(RESET);
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0)  return(RESET);

//----         
   ArraySetAsSeries(DMIP,true);
   ArraySetAsSeries(DMIM,true);
   ArraySetAsSeries(ATR,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);

//----   
   pL0 = pL0_;
   pL1 = pL1_;
   pL2 = pL2_;
   pL3 = pL3_;
   pL0A = pL0A_;
   pL1A = pL1A_;
   pL2A = pL2A_;
   pL3A = pL3A_; 
     
//----   
   mL0 = mL0_;
   mL1 = mL1_;
   mL2 = mL2_;
   mL3 = mL3_;
   mL0A = mL0A_;
   mL1A = mL1A_;
   mL2A = mL2A_;
   mL3A = mL3A_;

//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      pL0A = pL0;
      pL1A = pL1;
      pL2A = pL2;
      pL3A = pL3;
      //----
      pL0 = (1 - gamma) * DMIP[bar] + gamma * pL0A;
      pL1 = - gamma * pL0 + pL0A + gamma * pL1A;
      pL2 = - gamma * pL1 + pL1A + gamma * pL2A;
      pL3 = - gamma * pL2 + pL2A + gamma * pL3A;
      //----
      CU = 0;
      CD = 0;
      //---- 
      if(pL0 >= pL1) CU  = pL0 - pL1; else CD  = pL1 - pL0;
      if(pL1 >= pL2) CU += pL1 - pL2; else CD += pL2 - pL1;
      if(pL2 >= pL3) CU += pL2 - pL3; else CD += pL3 - pL2;
      //----
      if(CU+CD!=0) LDMIP=CU/(CU+CD);

      mL0A = mL0;
      mL1A = mL1;
      mL2A = mL2;
      mL3A = mL3;
      //----
      mL0 = (1 - gamma) * DMIM[bar] + gamma * mL0A;
      mL1 = - gamma * mL0 + mL0A + gamma * mL1A;
      mL2 = - gamma * mL1 + mL1A + gamma * mL2A;
      mL3 = - gamma * mL2 + mL2A + gamma * mL3A;
      //----
      CU = 0;
      CD = 0;
      //---- 
      if(mL0 >= mL1) CU  = mL0 - mL1; else CD  = mL1 - mL0;
      if(mL1 >= mL2) CU += mL1 - mL2; else CD += mL2 - mL1;
      if(mL2 >= mL3) CU += mL2 - mL3; else CD += mL3 - mL2;
      //----
      if(CU+CD!=0) LDMIM=CU/(CU+CD);
      
      SellBuffer[bar]=0.0;
      BuyBuffer[bar]=0.0;
      
      if(LDMIP_<=LDMIM_ && LDMIP>LDMIM) BuyBuffer[bar]=low[bar]-ATR[bar]*3/8;
      if(LDMIP_>=LDMIM_ && LDMIP<LDMIM) SellBuffer[bar]=high[bar]+ATR[bar]*3/8;

      //----        
      if(bar==1)
        {
         pL0_ = pL0;
         pL1_ = pL1;
         pL2_ = pL2;
         pL3_ = pL3;
         pL0A_ = pL0A;
         pL1A_ = pL1A;
         pL2A_ = pL2A;
         pL3A_ = pL3A;
         
         mL0_ = mL0;
         mL1_ = mL1;
         mL2_ = mL2;
         mL3_ = mL3;
         mL0A_ = mL0A;
         mL1A_ = mL1A;
         mL2A_ = mL2A;
         mL3A_ = mL3A;
        }
        
      if(bar)
        {
         LDMIP_=LDMIP;
         LDMIM_=LDMIM;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
