//+---------------------------------------------------------------------+ 
//|                                                             KRI.mq5 | 
//|                                Copyright  2011,   Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2011, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.01"
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 1 
//----    
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----        
#property indicator_color1 clrGold
//----   -  
#property indicator_style1  STYLE_SOLID
//----     1
#property indicator_width1  1
//----   
#property indicator_label1  "KRI"
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum ENUM_PRICE_TYPE // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+-----------------------------------+
//|         |
//+-----------------------------------+
input int KRIPeriod=20; //  
input ENUM_MA_METHOD MA_Method_=MODE_SMA; //  
input double Ratio=1.0;
input ENUM_PRICE_TYPE IPC=PRICE_CLOSE_; //  
input int Shift=0; //      
//+-----------------------------------+
//----  
double KRIBuffer[];
//----      
int StartBar;
//+------------------------------------------------------------------+
//|                                         |
//+------------------------------------------------------------------+ 
#include <SmoothAlgorithms.mqh>
//+------------------------------------------------------------------+    
//| KRI indicator initialization function                            |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----  
   StartBar=KRIPeriod+1;
//----      
   SetIndexBuffer(0,KRIBuffer,INDICATOR_DATA);
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,StartBar);
//---      DataWindow
   PlotIndexSetString(0,PLOT_LABEL,"KRI");
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   string shortname;
   StringConcatenate(shortname,"KRI( KRIPeriod = ",KRIPeriod,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+  
//| KRI iteration function                                           | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<StartBar) return(0);
//----       
   double price_,KRI,mov;
//----   
   int first,bar;
//----    first    
   if(prev_calculated==0) //      
     {
      first=0; //      
     }
   else //      
     {
      first=prev_calculated-1;
     }
//----    Moving_Average  StdDeviation
   static CMoving_Average MA;
//----      
   for(bar=first; bar<rates_total; bar++)
     {
      //----   PriceSeries     Series
      price_=PriceSeries(IPC,bar,open,low,high,close);
      //----
      mov=MA.MASeries(0,prev_calculated,rates_total,KRIPeriod,MA_Method_,price_,bar,false);
      //----
      KRI=100 *(price_-mov)/mov;
      KRIBuffer[bar]=KRI;
     }
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+
