//+------------------------------------------------------------------+
//|                                                OrdersManager.mqh |
//|                            Copyright 2015, Kristoffer Klevenberg |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
//
// Usage:
//
// COrdersManager Orders;
//
// Orders.DeleteAll();              // Close and delete all orders
// Orders.CloseOpen()               // Close all open orders
// Orders.CloseSell()               // Close all SELL orders
// Orders.CloseBuy()                // Close all BUY orders
// Orders.DeletePending()           // Delete all pending orders
// Orders.CheckOpenOrders()         // Returns amount of open orders
// Orders.CheckOpenBuyOrders()      // Returns amount of buy orders open
// Orders.CheckOpenSellOrders()     // Returns amount of sell orders open
//
#property copyright "Copyright 2015, Kristoffer Klevenberg"
#property link      "https://www.mql5.com"
#property version   "1.00"
#property strict
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class COrdersManager
  {
private:

public:
   //Constructor
                     COrdersManager(){};

   //Deconstructor
                    ~COrdersManager(){};

   //+------------------------------------------------------------------+
   //| Deletes all orders                                               |
   //+------------------------------------------------------------------+
   void DeleteAll()
     {
      for(int pos=0; pos<OrdersTotal(); pos++)
        {
         if(OrderSelect(pos,SELECT_BY_POS,MODE_TRADES))
           {
            //close buy
            if(OrderType()==OP_BUY)
              {
               if(OrderClose(OrderTicket(),OrderLots(),MarketInfo(OrderSymbol(),MODE_BID),2,clrNONE))
                  Print("OrdersManager: ",OrderTicket()," closed successfully");
               else
                  Print("OrdersManager: ",OrderTicket()," closed unsuccessfully");
               // close sell
                 }else if(OrderType()==OP_SELL){
               if(OrderClose(OrderTicket(),OrderLots(),MarketInfo(OrderSymbol(),MODE_ASK),2,clrNONE))
                  Print("OrdersManager: ",OrderTicket()," closed successfully");
               else
                  Print("OrdersManager: ",OrderTicket()," closed unsuccessfully");
               //close pending
                 }else{
               if(OrderDelete(OrderTicket(),clrNONE))
                  Print("OrdersManager: ",OrderTicket()," deleted successfully");
               else
                  Print("OrdersManager: ",OrderTicket()," deleted unsuccessfully");
              }
           }
        }
     };
   //+------------------------------------------------------------------+
   //| Check if any orders are open                                     |
   //+------------------------------------------------------------------+
   int CheckOpenOrders()
     {
      int count=0;
      for(int pos=0; pos<OrdersTotal(); pos++)
        {
         if(OrderSelect(pos,SELECT_BY_POS,MODE_TRADES))
           {
            if(OrderType()==OP_SELL || OrderType()==OP_BUY)
              {
               count++;
              }
           }
        }
      return count;
     };
   //+------------------------------------------------------------------+
   //| Check if buy orders are open                                     |
   //+------------------------------------------------------------------+
   int CheckOpenBuyOrders()
     {
      int count=0;
      for(int pos=0; pos<OrdersTotal(); pos++)
        {
         if(OrderSelect(pos,SELECT_BY_POS,MODE_TRADES))
           {
            if(OrderType()==OP_BUY)
              {
               count++;
              }
           }
        }
      return count;
     };
   //+------------------------------------------------------------------+
   //| Check if sell orders are open                                    |
   //+------------------------------------------------------------------+
   int CheckOpenSellOrders()
     {
      int count=0;
      for(int pos=0; pos<OrdersTotal(); pos++)
        {
         if(OrderSelect(pos,SELECT_BY_POS,MODE_TRADES))
           {
            if(OrderType()==OP_SELL)
              {
               count++;
              }
           }
        }
      return count;
     };
   //+------------------------------------------------------------------+
   //| Remove all pending orders                                        |
   //+------------------------------------------------------------------+
   void DeletePending()
     {
      for(int pos=0; pos<OrdersTotal(); pos++)
        {
         if(OrderSelect(pos,SELECT_BY_POS,MODE_TRADES))
           {
            if(OrderType()!=OP_BUY && OrderType()!=OP_SELL)
              {
               if(OrderDelete(OrderTicket(),clrNONE))
                  Print("OrdersManager: ",OrderTicket()," deleted successfully");
               else
                  Print("OrdersManager: ",OrderTicket()," deleted unsuccessfully");
              }
           }

        }
     };
   //+------------------------------------------------------------------+
   //| Remove all open orders                                           |
   //+------------------------------------------------------------------+
   void CloseOpen()
     {
      for(int pos=0; pos<OrdersTotal(); pos++)
        {
         if(OrderSelect(pos,SELECT_BY_POS,MODE_TRADES))
           {
            if(OrderType()==OP_BUY)
              {
               if(OrderClose(OrderTicket(),OrderLots(),MarketInfo(OrderSymbol(),MODE_BID),2,clrNONE))
                  Print("OrdersManager: ",OrderTicket()," closed successfully");
               else
                  Print("OrdersManager: ",OrderTicket()," closed unsuccessfully");
                 }else if(OrderType()==OP_SELL){
               if(OrderClose(OrderTicket(),OrderLots(),MarketInfo(OrderSymbol(),MODE_ASK),2,clrNONE))
                  Print("OrdersManager: ",OrderTicket()," closed successfully");
               else
                  Print("OrdersManager: ",OrderTicket()," closed unsuccessfully");
              }
           }
        }
     };
   //+------------------------------------------------------------------+
   //| Close all Buy orders                                             |
   //+------------------------------------------------------------------+
   void CloseBuy()
     {
      for(int pos=0; pos<OrdersTotal(); pos++)
        {
         if(OrderSelect(pos,SELECT_BY_POS,MODE_TRADES))
           {
            if(OrderType()==OP_BUY)
              {
               if(OrderClose(OrderTicket(),OrderLots(),MarketInfo(OrderSymbol(),MODE_BID),2,clrNONE))
                  Print("OrdersManager: ",OrderTicket()," closed successfully");
               else
                  Print("OrdersManager: ",OrderTicket()," closed unsuccessfully");
              }
           }
        }
     };
   //+------------------------------------------------------------------+
   //| Close all Buy orders                                             |
   //+------------------------------------------------------------------+
   void CloseSell()
     {
      for(int pos=0; pos<OrdersTotal(); pos++)
        {
         if(OrderSelect(pos,SELECT_BY_POS,MODE_TRADES))
           {
            if(OrderType()==OP_SELL)
              {
               if(OrderClose(OrderTicket(),OrderLots(),MarketInfo(OrderSymbol(),MODE_BID),2,clrNONE))
                  Print("OrdersManager: ",OrderTicket()," closed successfully");
               else
                  Print("OrdersManager: ",OrderTicket()," closed unsuccessfully");
              }
           }
        }
     };
  };
//+------------------------------------------------------------------+
