//+------------------------------------------------------------------+
//|                                            FX_Sniper_Ergodic_CCI |
//|                                      Copyright  2004, Fx Sniper |
//|                                                                  |
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2004, Fx Sniper"
//----  
#property link      ""
//----   
#property version   "1.00"
#property description "Louw Coetzer aka FX Sniper"
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 2
//----    
#property indicator_plots   2
//+----------------------------------------------+
//|    CCI           |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_LINE
//----        
#property indicator_color1  clrRed
//----   1 -  
#property indicator_style1  STYLE_SOLID
//----    1  1
#property indicator_width1  1
//----   
#property indicator_label1  "CCI"
//+----------------------------------------------+
//|    ErgoCCI       |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----       DarkOrchid 
#property indicator_color2  clrDarkOrchid
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  1
#property indicator_width2  1
//----   
#property indicator_label2  "FX Sniper Ergo/CCI"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|   CMoving_Average              |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//----    CEMA   SmoothAlgorithms.mqh
CMoving_Average EMA1,EMA2,EMA3,EMA4,EMA5,EMA6;
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint pq=2;
input uint pr=14;
input uint ps=5;
input uint CCI_period=14;
input int  Shift=0;       //       
//+----------------------------------------------+
//----   ,    
//----      
double CCIBuffer[];
double ErgoCCIBuffer[];
//----      
int CCI_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total=int(CCI_period+1+pr+pq+ps);
//----    CCI
   CCI_Handle=iCCI(NULL,0,CCI_period,PRICE_TYPICAL);
   if(CCI_Handle==INVALID_HANDLE) Print("      CCI");
//----      
   SetIndexBuffer(0,CCIBuffer,INDICATOR_DATA);
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1  min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----       
   ArraySetAsSeries(CCIBuffer,true);
//----      
   SetIndexBuffer(1,ErgoCCIBuffer,INDICATOR_DATA);
//----    2    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       2  min_rates_total
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----       
   ArraySetAsSeries(ErgoCCIBuffer,true);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"FX Sniper Ergo/CCI");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(CCI_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//----    
   int to_copy,limit,bar,MaxBarA,MaxBarB,MaxBarC;
   double dc,absdc,e1dc,e1absdc,e2dc,e2absdc,e3dc,e3absdc;
//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
      limit=int(rates_total-CCI_period-1); //      
   else limit=rates_total-prev_calculated; //      
//----
   to_copy=limit+1;
//----
   MaxBarA=int(rates_total-min_rates_total-CCI_period-1);
   MaxBarB=int(MaxBarA-pq);
   MaxBarC=int(MaxBarB-pr);
//----         
   ArraySetAsSeries(close,true);
//----      
   if(CopyBuffer(CCI_Handle,0,0,to_copy,CCIBuffer)<=0) return(RESET);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      dc=close[bar]-close[bar+1];
      absdc=MathAbs(dc);
      //----
      e1dc=EMA1.EMASeries(MaxBarA,prev_calculated,rates_total,pq,dc,bar,true);
      e1absdc=EMA2.EMASeries(MaxBarA,prev_calculated,rates_total,pq,absdc,bar,true);
      //----
      e2dc=EMA3.EMASeries(MaxBarB,prev_calculated,rates_total,pr,e1dc,bar,true);
      e2absdc=EMA4.EMASeries(MaxBarB,prev_calculated,rates_total,pr,e1absdc,bar,true);
      //----
      e3dc=EMA3.EMASeries(MaxBarC,prev_calculated,rates_total,ps,e2dc,bar,true);
      e3absdc=EMA4.EMASeries(MaxBarC,prev_calculated,rates_total,ps,e2absdc,bar,true);
      //----
      if(e3absdc) ErgoCCIBuffer[bar]=450*e3dc/e3absdc;
      else ErgoCCIBuffer[bar]=50;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
