//+---------------------------------------------------------------------+
//|                                                   ColorX2MA_Osc.mq5 | 
//|                                Copyright  2012,   Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2012, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
#property description " X2MA,            0   100."
#property description "           ."
#property description "       "
//----   
#property version   "1.11"
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----      
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//----      
#property indicator_color1 clrTeal,clrBlueViolet,clrIndianRed,clrMagenta
//----   - 
#property indicator_style1 STYLE_SOLID
//----     2
#property indicator_width1 2
//----   
#property indicator_label1 "X2MA_Osc"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 0.0
#property indicator_levelcolor clrGray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|   CXMA                        |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_   //TrendFollow_2 Price 
  };
//+----------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint nPeriod=100; //   
input Smooth_Method MA_Method1=MODE_SMA; //     
input uint Length1=12; //                        
input int Phase1=15;   //   
                       //  JJMA    -100 ... +100,     
                       //  VIDIA   CMO,  AMA    
input Smooth_Method MA_Method2=MODE_JJMA; //     
input uint Length2 = 5; //     
input int Phase2=15;    //   
                        //  JJMA    -100 ... +100,     ;
                        //  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_CLOSE; //  
/* ,      ( 1-CLOSE, 2-OPEN, 3-HIGH, 4-LOW, 
  5-MEDIAN, 6-TYPICAL, 7-WEIGHTED, 8-SIMPL, 9-QUARTER, 10-TRENDFOLLOW, 11-0.5 * TRENDFOLLOW.) */
input int Shift=0; //      
//+----------------------------------------------+
//----   ,    
//----      
double X2MAOsc[],ColorX2MAOsc[];
//----   ,    
//----      
int Count[];
double X2MA[];
//----      
int min_rates_total,min_rates_1,min_rates_2;
//+------------------------------------------------------------------+
//|                |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[],//        
                          int Size)    //   
  {
//----
   int numb,Max1,Max2;
   static int count=1;
//----
   Max2=Size;
   Max1=Max2-1;
//----
   count--;
   if(count<0) count=Max1;
//----
   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
  }
//+------------------------------------------------------------------+
//|                                     |
//+------------------------------------------------------------------+   
double Interpolation(double a,double b,double c,double d,double X) //a; X; b -   , c; d; -    .
  {
//----
   if(b-a==0) return(10000000); //
   else return(d -(b-X) *(d-c)/(b-a));
  }
//+------------------------------------------------------------------+   
//| X2MA Osc indicator initialization function                       | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_1=XMA1.GetStartBars(MA_Method1, Length1, Phase1);
   min_rates_2=XMA2.GetStartBars(MA_Method2, Length2, Phase2);
   min_rates_total=min_rates_1+min_rates_2+1;
//----       
   XMA1.XMALengthCheck("Length1", Length1);
   XMA2.XMALengthCheck("Length2", Length2);
//----       
   XMA1.XMAPhaseCheck("Phase1", Phase1, MA_Method1);
   XMA2.XMAPhaseCheck("Phase2", Phase2, MA_Method2);
//----       
   ArrayResize(Count,nPeriod);
   ArrayResize(X2MA,nPeriod);
//----   
   ArrayInitialize(Count,0);
   ArrayInitialize(X2MA,0.0);
//----       
   ArraySetAsSeries(Count,true);
   ArraySetAsSeries(X2MA,true);
//----      
   SetIndexBuffer(0,X2MAOsc,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(X2MAOsc,true);
//----     ,     
   SetIndexBuffer(1,ColorX2MAOsc,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorX2MAOsc,true);
//----      
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(MA_Method1);
   string Smooth2=XMA1.GetString_MA_Method(MA_Method2);
   StringConcatenate(shortname,"X2MA_Osc(",nPeriod,", ",Length1,", ",Length2,", ",Smooth1,", ",Smooth2,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----  
  }
//+------------------------------------------------------------------+ 
//| X2MA Osc iteration function                                      | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);
   ArraySetAsSeries(open,true);
//----       
   double price_,x1xma,x2xmaosc,MAX,MIN;
//----        
   int limit,bar,maxbar1,maxbar2;
//----
   maxbar1=rates_total-1;
   maxbar2=maxbar1-min_rates_1;
//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
      limit=rates_total-1; //      
   else limit=rates_total-prev_calculated; //      
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----   PriceSeries     price_
      price_=PriceSeries(IPC,bar,open,low,high,close);
      //----    XMASeries
      x1xma=XMA1.XMASeries(maxbar1,prev_calculated,rates_total,MA_Method1,Phase1,Length1,price_,bar,true);
      X2MA[Count[0]]=XMA2.XMASeries(maxbar2,prev_calculated,rates_total,MA_Method2,Phase2,Length2,x1xma,bar,true);
      //----  
      MAX=X2MA[ArrayMaximum(X2MA,0,WHOLE_ARRAY)];
      MIN=X2MA[ArrayMinimum(X2MA,0,WHOLE_ARRAY)];
      //----         0  100     
      x2xmaosc=Interpolation(MAX,MIN,100,0,X2MA[Count[0]]);
      X2MAOsc[bar]=x2xmaosc-50;
      //----          
      if(bar) Recount_ArrayZeroPos(Count,nPeriod);
     }
//----
   if(prev_calculated>rates_total || prev_calculated<=0) limit--;
//----    
   for(bar=limit; bar>=0; bar--)
     {
      int bar1=bar+1;
      //----
      if(X2MAOsc[bar]>=0)
        {
         if(X2MAOsc[bar]>X2MAOsc[bar1]) ColorX2MAOsc[bar]=0;
         if(X2MAOsc[bar]<X2MAOsc[bar1]) ColorX2MAOsc[bar]=1;
         if(X2MAOsc[bar]==X2MAOsc[bar1]) ColorX2MAOsc[bar]=ColorX2MAOsc[bar1];
        }
      //----
      if(X2MAOsc[bar]<0)
        {
         if(X2MAOsc[bar]<X2MAOsc[bar1]) ColorX2MAOsc[bar]=2;
         if(X2MAOsc[bar]>X2MAOsc[bar1]) ColorX2MAOsc[bar]=3;
         if(X2MAOsc[bar]==X2MAOsc[bar1]) ColorX2MAOsc[bar]=ColorX2MAOsc[bar1];
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
