//+------------------------------------------------------------------+
//|                                             FractalsNoRedraw.mq5 |
//|                                                         Tapochun |
//|                         https://login.mql5.com/ru/users/tapochun |
//+------------------------------------------------------------------+
#property copyright "2009, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property copyright "Tapochun"
#property link      "https://login.mql5.com/ru/users/tapochun"
//---- indicator settings
#property indicator_chart_window
#property indicator_buffers 2
#property indicator_plots   2
//---
#property indicator_type1   DRAW_ARROW
#property indicator_color1  clrWhite
#property indicator_label1  "Fractal_nr Up"
#property indicator_width1  1
//---
#property indicator_type2   DRAW_ARROW
#property indicator_color2  clrWhite
#property indicator_label2  "Fractal_nr Dn"
#property indicator_width2  1
//---- indicator buffers
double ExtUpperBuffer[];
double ExtLowerBuffer[];
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
enum ENUM_FRACTAL      //  -  
  {
   UP, //  
   DN  //  
  };
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//---- indicator buffers mapping
   SetIndexBuffer(0,ExtUpperBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,ExtLowerBuffer,INDICATOR_DATA);
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);   //   
//---- sets first bar from what index will be drawn
   PlotIndexSetInteger(0,PLOT_ARROW,217);
   PlotIndexSetInteger(1,PLOT_ARROW,218);
//---- sets drawing line empty value--
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---
   PlotIndexSetInteger(0,PLOT_ARROW_SHIFT,-10);
   PlotIndexSetInteger(1,PLOT_ARROW_SHIFT,10);
  }
//+------------------------------------------------------------------+
//|  Accelerator/Decelerator Oscillator                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,//    
                const int prev_calculated,//      
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---   ,     
   if(rates_total<5) return(0);         //  0 (   prev_calculated  . )
//---
   if(prev_calculated<=0) //   					
     {                    //   
      //---      
      ArrayInitialize( ExtUpperBuffer, EMPTY_VALUE );   //   
      ArrayInitialize( ExtLowerBuffer, EMPTY_VALUE );   //   
      //---
      for(int i=2; i<rates_total-3; i++) //    
        {
         CheckFractal(UP,i,ExtUpperBuffer,high);        //   
         CheckFractal(DN,i,ExtLowerBuffer,low);         //   
        }
      return( rates_total );
     }
   else                               //    
     {
      if(rates_total>prev_calculated) //    
        {
         //---      
         ExtUpperBuffer[ rates_total-1 ] = EMPTY_VALUE;
         ExtLowerBuffer[ rates_total-1 ] = EMPTY_VALUE;
         //--- ,       rates_total-4 (   )
         CheckFractal(UP,rates_total-4,ExtUpperBuffer,high);   //   
         CheckFractal(DN,rates_total-4,ExtLowerBuffer,low);    //   
        }
      return( rates_total );
     }
//---
   return(rates_total); //       
  }
//+------------------------------------------------------------------+
//|     i   type                  |
//+------------------------------------------------------------------+
void CheckFractal(const ENUM_FRACTAL type, //  ,  
                  const int i,             //     
                  double &buffer[],        //    (out)
                  const double &price[])   //  
  {
//---   ( )
   double p=price[i];                  //    (rates_total-4)
   double pf_1 = price[ i+1 ];         //   
   double pf_2 = price[ i+2 ];         //    ( /rates_total-2)
   double pp_1 = price[ i-1 ];         //   
   double pp_2 = price[ i-2 ];         //    (rates_total-6)
//---
   if(type==UP) //   	
     {
      if(p>pf_1 && p>pf_2 && p>=pp_1 && p>=pp_2)
         ExtUpperBuffer[i]=price[i];   //    
      //---
      return;
     }
//---
   if(type==DN) //   
     {
      if(p<pf_1 && p<pf_2 && p<=pp_1 && p<=pp_2)
         ExtLowerBuffer[i]=price[i];   //    
      //---
      return;
     }
//---     
   Print(__FUNCTION__,": !    : "+EnumToString(type));
   return;
  }
//+------------------------------------------------------------------+
