//+---------------------------------------------------------------------+
//|                                                MovingAverage_FN.mq5 | 
//|                                              Copyright  2009, TULA |
//|                                                  Piboli             |
//+---------------------------------------------------------------------+ 
//| For the indicator to work, place the file SmoothAlgorithms.mqh      |
//| in the directory: terminal_data_folder\MQL5\Include                 |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2009, TULA"
#property link ""
//---- indicator version number
#property version   "1.00"
//---- drawing the indicator in the main window
#property indicator_chart_window 
//---- number of indicator buffers
#property indicator_buffers 1 
//---- only one plot is used
#property indicator_plots   1
//+-----------------------------------+
//|  Indicator drawing parameters     |
//+-----------------------------------+
//---- drawing the indicator as a line
#property indicator_type1   DRAW_LINE
//---- DodgerBlue color is used for the indicator line
#property indicator_color1 DodgerBlue
//---- the indicator line is a continuous curve
#property indicator_style1  STYLE_SOLID
//---- indicator line width is equal to 1
#property indicator_width1  1
//---- displaying the indicator label
#property indicator_label1  "MovingAverage_FN"

//+-----------------------------------+
//|  CXMA class description           |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+

//---- declaration of the CXMA class variables from the SmoothAlgorithms.mqh file
CXMA XMA1;
//+-----------------------------------+
//|  Declaration of enumerations      |
//+-----------------------------------+
enum Applied_price_ //Type od constant
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_   //TrendFollow_2 Price 
  };
//+-----------------------------------+
//|  Declaration of enumerations      |
//+-----------------------------------+
/*enum Smooth_Method - enumeration is declared in SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|  Declaration of enumerations      |
//+-----------------------------------+
enum filter_mode
  {
   N4=4,  //filter 4
   N5,    //filter 5
   N6,    //filter 6
   N7,    //filter 7
   N8,    //filter 8
   N9,    //filter 9
   N10,   //filter 10
   N11,   //filter 11
   N12,   //filter 12
   N13,   //filter 13
   N14,   //filter 14
   N15,   //filter 15
   N16,   //filter 16
   N17,   //filter 17
   N18,   //filter 18
   N19,   //filter 19
   N20,   //filter 20
   N21,   //filter 21
   N22,   //filter 22
   N23,   //filter 23
   N24,   //filter 24
   N25,   //filter 25
   N26,   //filter 26
   N27,   //filter 27
   N28,   //filter 28
   N29,   //filter 29
   N30,   //filter 30
   N31,   //filter 31
   N32,   //filter 32
   N33,   //filter 33
   N34,   //filter 34
   N35,   //filter 35
   N36,   //filter 36
   N37,   //filter 37
   N38,   //filter 38
   N39,   //filter 39
   N40,   //filter 40
   N41,   //filter 41
   N42,   //filter 42
   N43,   //filter 43
   N44,   //filter 44
   N45,   //filter 45
   N46,   //filter 46
   N47,   //filter 47
   N48,   //filter 48
   N49,   //filter 49
   N50,   //filter 50
   N51,   //filter 51
   N52,   //filter 52
   N53,   //filter 53
   N54,   //filter 54
   N55,   //filter 55
   N56,   //filter 56
   N57,   //filter 57
   N58,   //filter 58
   N59,   //filter 59
   N60    //filter 60
  };
//+-----------------------------------+
//|  INDICATOR INPUT PARAMETERS       |
//+-----------------------------------+
input filter_mode FilterNumber=N44; //fulter number for the calculation
input Smooth_Method XMA_Method=MODE_JJMA; //smoothing method
input int XLength=12; //smoothing depth                    
input int XPhase=15; //smoothing parameter,
  // for JJMA that can change withing the range -100 ... +100. It impacts the quality of the intermediate process of smoothing;
  // For VIDIA, it is a CMO period, for AMA, it is a slow moving average period
input Applied_price_ IPC=PRICE_CLOSE;//price constant
/* , used for calculation of the indicator ( 1-CLOSE, 2-OPEN, 3-HIGH, 4-LOW, 
  5-MEDIAN, 6-TYPICAL, 7-WEIGHTED, 8-SIMPL, 9-QUARTER, 10-TRENDFOLLOW, 11-0.5 * TRENDFOLLOW.) */
input int Shift=0; // horizontal shift of the indicator in bars
input int PriceShift=0; // vertical shift of the indicator in points
//+-----------------------------------+

//---- declaration of a dynamic array that further 
// will be used as an indicator buffer
double XMA[];

//---- Declaration of the average vertical shift value variable
double dPriceShift;
//---- Declaration of integer variables of data starting point
int min_rates_total;
//+------------------------------------------------------------------+   
//| MovingAverage_FN indicator initialization function               | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//---- Initialization of variables of the start of data calculation
   min_rates_total=700+XMA1.GetStartBars(XMA_Method, XLength, XPhase);
//---- setting alerts for invalid values of external parameters
   XMA1.XMALengthCheck("XLength", XLength);
   XMA1.XMAPhaseCheck("XPhase", XPhase, XMA_Method);
//---- Initialization of the vertical shift
   dPriceShift=_Point*PriceShift;
   
//---- set dynamic array as an indicator buffer
   SetIndexBuffer(0,XMA,INDICATOR_DATA);
//---- moving the indicator 1 horizontally
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---- performing the shift of beginning of indicator drawing
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---- setting the indicator values that won't be visible on a chart
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
   
//--- creation of the name to be displayed in a separate sub-window and in a pop up help
   IndicatorSetString(INDICATOR_SHORTNAME,"MovingAverage_FN");
   
//--- determining the accuracy of displaying the indicator values
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//---- end of initialization
  }
//+------------------------------------------------------------------+ 
//| MovingAverage_FN iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(
                const int rates_total,    // amount of history in bars at the current tick
                const int prev_calculated,// amount of history in bars at the previous tick
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//---- checking the number of bars to be enough for calculation
   if(rates_total<min_rates_total) return(0);

//---- declaration of variables with a floating point  
   double digfilter,x1xma;
//---- Declaration of integer variables and getting the bars already calculated
   int first,bar;

//---- calculation of the starting number first for the bar recalculation loop
   if(prev_calculated>rates_total || prev_calculated<=0) // checking for the first start of calculation of an indicator
      first=700; // starting number for calculation of all bars
   else first=prev_calculated-1; // starting number for calculation of new bars

//---- Main calculation loop of the indicator
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      
      digfilter=FN(FilterNumber,open,low,high,close,IPC,bar);
      x1xma = XMA1.XMASeries(700,prev_calculated,rates_total,XMA_Method,XPhase,XLength,digfilter,bar,false);
      //----       
      XMA[bar]=x1xma+dPriceShift;
     }
//----     
   return(rates_total);
  }

//+------------------------------------------------------------------+
//LPF are calculated by Digital Filter Methods http://fx.qrz.ru/     |
//+------------------------------------------------------------------+
double  FN(filter_mode filter,const double &O[],const double &L[],const double &H[],const double &C[],Applied_price_ Price,int index)
  {
//----
   switch(filter)
     {
      case N4:
         return(
                0.755921135321*PriceSeries(Price,index,O,L,H,C)
                +0.372695463315*PriceSeries(Price,index-1,O,L,H,C)
                -0.1227477536509*PriceSeries(Price,index-2,O,L,H,C)
                -0.0682196256116*PriceSeries(Price,index-3,O,L,H,C)
                +0.0930420041115*PriceSeries(Price,index-4,O,L,H,C)
                -0.00899996832959*PriceSeries(Price,index-5,O,L,H,C)
                -0.0542664725221*PriceSeries(Price,index-6,O,L,H,C)
                +0.0360714890012*PriceSeries(Price,index-7,O,L,H,C)
                +0.01776244392449*PriceSeries(Price,index-8,O,L,H,C)
                -0.0360800341007*PriceSeries(Price,index-9,O,L,H,C)
                +0.00769970759653*PriceSeries(Price,index-10,O,L,H,C)
                +0.02233317596740*PriceSeries(Price,index-11,O,L,H,C)
                -0.01874632243583*PriceSeries(Price,index-12,O,L,H,C)
                -0.00585956702243*PriceSeries(Price,index-13,O,L,H,C)
                +0.01757001382762*PriceSeries(Price,index-14,O,L,H,C)
                -0.00589271510556*PriceSeries(Price,index-15,O,L,H,C)
                -0.00977759936478*PriceSeries(Price,index-16,O,L,H,C)
                +0.01019259783060*PriceSeries(Price,index-17,O,L,H,C)
                +0.001309849787704*PriceSeries(Price,index-18,O,L,H,C)
                -0.00837412415197*PriceSeries(Price,index-19,O,L,H,C)
                +0.00398336707035*PriceSeries(Price,index-20,O,L,H,C)
                +0.00380943659834*PriceSeries(Price,index-21,O,L,H,C)
                -0.00517254056171*PriceSeries(Price,index-22,O,L,H,C)
                +0.0003078573492474*PriceSeries(Price,index-23,O,L,H,C)
                +0.00353726807775*PriceSeries(Price,index-24,O,L,H,C)
                -0.002326411760936*PriceSeries(Price,index-25,O,L,H,C)
                -0.001106818856381*PriceSeries(Price,index-26,O,L,H,C)
                +0.002285484046142*PriceSeries(Price,index-27,O,L,H,C)
                -0.000606758580570*PriceSeries(Price,index-28,O,L,H,C)
                -0.001192883741798*PriceSeries(Price,index-29,O,L,H,C)
                +0.001128169580325*PriceSeries(Price,index-30,O,L,H,C)
                +0.0001081585096803*PriceSeries(Price,index-31,O,L,H,C)
                -0.000803993770218*PriceSeries(Price,index-32,O,L,H,C)
                +0.000422687550919*PriceSeries(Price,index-33,O,L,H,C)
                +0.0002492026134532*PriceSeries(Price,index-34,O,L,H,C)
                -0.000418437384649*PriceSeries(Price,index-35,O,L,H,C)
                +0.0001099568341645*PriceSeries(Price,index-36,O,L,H,C)
                +0.0001818118740379*PriceSeries(Price,index-37,O,L,H,C)
                -0.0001819042045230*PriceSeries(Price,index-38,O,L,H,C)
                +0.00001376031370469*PriceSeries(Price,index-39,O,L,H,C)
                +0.0000944464605727*PriceSeries(Price,index-40,O,L,H,C)
                -0.0000726949275881*PriceSeries(Price,index-41,O,L,H,C)
                -0.000001649184802174*PriceSeries(Price,index-42,O,L,H,C)
                +0.0000454599752580*PriceSeries(Price,index-43,O,L,H,C)
                -0.0000434882759643*PriceSeries(Price,index-44,O,L,H,C)
                +0.00002296858969507*PriceSeries(Price,index-45,O,L,H,C)
                -0.00000726301267758*PriceSeries(Price,index-46,O,L,H,C)
                +0.000001073598073258*PriceSeries(Price,index-47,O,L,H,C)
                +0.000000082040859009*PriceSeries(Price,index-48,O,L,H,C)
                -0.000000045208071155*PriceSeries(Price,index-49,O,L,H,C)
                );

      case N5:
         return(
                0.830724629861*PriceSeries(Price,index,O,L,H,C)
                +0.357853467115*PriceSeries(Price,index-1,O,L,H,C)
                -0.1015682700953*PriceSeries(Price,index-2,O,L,H,C)
                -0.1725167394268*PriceSeries(Price,index-3,O,L,H,C)
                +0.01607231593831*PriceSeries(Price,index-4,O,L,H,C)
                +0.1108748053391*PriceSeries(Price,index-5,O,L,H,C)
                +0.01649382784179*PriceSeries(Price,index-6,O,L,H,C)
                -0.0742341514745*PriceSeries(Price,index-7,O,L,H,C)
                -0.03101545535411*PriceSeries(Price,index-8,O,L,H,C)
                +0.0478525494500*PriceSeries(Price,index-9,O,L,H,C)
                +0.0362133619243*PriceSeries(Price,index-10,O,L,H,C)
                -0.02776934384561*PriceSeries(Price,index-11,O,L,H,C)
                -0.0357594958266*PriceSeries(Price,index-12,O,L,H,C)
                +0.01260697873245*PriceSeries(Price,index-13,O,L,H,C)
                +0.0318305382166*PriceSeries(Price,index-14,O,L,H,C)
                -0.001697852102715*PriceSeries(Price,index-15,O,L,H,C)
                -0.02599408995485*PriceSeries(Price,index-16,O,L,H,C)
                -0.00548866655282*PriceSeries(Price,index-17,O,L,H,C)
                +0.01945406669022*PriceSeries(Price,index-18,O,L,H,C)
                +0.00952726892952*PriceSeries(Price,index-19,O,L,H,C)
                -0.01311266405927*PriceSeries(Price,index-20,O,L,H,C)
                -0.01106513250895*PriceSeries(Price,index-21,O,L,H,C)
                +0.00758588723353*PriceSeries(Price,index-22,O,L,H,C)
                +0.01078576490963*PriceSeries(Price,index-23,O,L,H,C)
                -0.00322012089444*PriceSeries(Price,index-24,O,L,H,C)
                -0.00935091594762*PriceSeries(Price,index-25,O,L,H,C)
                +0.0001260982948471*PriceSeries(Price,index-26,O,L,H,C)
                +0.00734237796800*PriceSeries(Price,index-27,O,L,H,C)
                +0.001771096652395*PriceSeries(Price,index-28,O,L,H,C)
                -0.00522102340739*PriceSeries(Price,index-29,O,L,H,C)
                -0.002670676756354*PriceSeries(Price,index-30,O,L,H,C)
                +0.00330573762237*PriceSeries(Price,index-31,O,L,H,C)
                +0.002834461120276*PriceSeries(Price,index-32,O,L,H,C)
                -0.001776107322435*PriceSeries(Price,index-33,O,L,H,C)
                -0.002532004528291*PriceSeries(Price,index-34,O,L,H,C)
                +0.000692038509829*PriceSeries(Price,index-35,O,L,H,C)
                +0.002000048775027*PriceSeries(Price,index-36,O,L,H,C)
                -0.00002519757405961*PriceSeries(Price,index-37,O,L,H,C)
                -0.001418514991937*PriceSeries(Price,index-38,O,L,H,C)
                -0.0003059388704180*PriceSeries(Price,index-39,O,L,H,C)
                +0.000902822175201*PriceSeries(Price,index-40,O,L,H,C)
                +0.000403366427601*PriceSeries(Price,index-41,O,L,H,C)
                -0.000508371964827*PriceSeries(Price,index-42,O,L,H,C)
                -0.000366122266913*PriceSeries(Price,index-43,O,L,H,C)
                +0.0002477459906005*PriceSeries(Price,index-44,O,L,H,C)
                +0.0002649947510448*PriceSeries(Price,index-45,O,L,H,C)
                -0.0000801695907121*PriceSeries(Price,index-46,O,L,H,C)
                -0.0002067170473780*PriceSeries(Price,index-47,O,L,H,C)
                +0.0000834121187901*PriceSeries(Price,index-48,O,L,H,C)
                +0.0000540797766558*PriceSeries(Price,index-49,O,L,H,C)
                );

      case N6:
         return(
                0.676243575072*PriceSeries(Price,index,O,L,H,C)
                +0.417414053572*PriceSeries(Price,index-1,O,L,H,C)
                +0.0788302256519*PriceSeries(Price,index-2,O,L,H,C)
                -0.1294805953365*PriceSeries(Price,index-3,O,L,H,C)
                -0.1288051861161*PriceSeries(Price,index-4,O,L,H,C)
                -0.00821791501989*PriceSeries(Price,index-5,O,L,H,C)
                +0.0816290274807*PriceSeries(Price,index-6,O,L,H,C)
                +0.0656989324748*PriceSeries(Price,index-7,O,L,H,C)
                -0.01190882568307*PriceSeries(Price,index-8,O,L,H,C)
                -0.0593585602579*PriceSeries(Price,index-9,O,L,H,C)
                -0.0358702529700*PriceSeries(Price,index-10,O,L,H,C)
                +0.01976646425453*PriceSeries(Price,index-11,O,L,H,C)
                +0.0442198151269*PriceSeries(Price,index-12,O,L,H,C)
                +0.01819509126873*PriceSeries(Price,index-13,O,L,H,C)
                -0.02218966516246*PriceSeries(Price,index-14,O,L,H,C)
                -0.0324171183477*PriceSeries(Price,index-15,O,L,H,C)
                -0.00695869675563*PriceSeries(Price,index-16,O,L,H,C)
                +0.02161550949593*PriceSeries(Price,index-17,O,L,H,C)
                +0.02285915672252*PriceSeries(Price,index-18,O,L,H,C)
                -0.0001232285188254*PriceSeries(Price,index-19,O,L,H,C)
                -0.01933551576822*PriceSeries(Price,index-20,O,L,H,C)
                -0.01519815042424*PriceSeries(Price,index-21,O,L,H,C)
                +0.00425392287919*PriceSeries(Price,index-22,O,L,H,C)
                +0.01617977749898*PriceSeries(Price,index-23,O,L,H,C)
                +0.00925630397854*PriceSeries(Price,index-24,O,L,H,C)
                -0.00626529277068*PriceSeries(Price,index-25,O,L,H,C)
                -0.01275746291050*PriceSeries(Price,index-26,O,L,H,C)
                -0.00488403089097*PriceSeries(Price,index-27,O,L,H,C)
                +0.00680085879536*PriceSeries(Price,index-28,O,L,H,C)
                +0.00949372804771*PriceSeries(Price,index-29,O,L,H,C)
                +0.001888466543450*PriceSeries(Price,index-30,O,L,H,C)
                -0.00638905770075*PriceSeries(Price,index-31,O,L,H,C)
                -0.00665683170159*PriceSeries(Price,index-32,O,L,H,C)
                -0.00002775402342876*PriceSeries(Price,index-33,O,L,H,C)
                +0.00546061183423*PriceSeries(Price,index-34,O,L,H,C)
                +0.00438134711268*PriceSeries(Price,index-35,O,L,H,C)
                -0.000967910292538*PriceSeries(Price,index-36,O,L,H,C)
                -0.00434746605168*PriceSeries(Price,index-37,O,L,H,C)
                -0.002691283592260*PriceSeries(Price,index-38,O,L,H,C)
                +0.001377232479582*PriceSeries(Price,index-39,O,L,H,C)
                +0.00329642690663*PriceSeries(Price,index-40,O,L,H,C)
                +0.001529617440852*PriceSeries(Price,index-41,O,L,H,C)
                -0.001495825160174*PriceSeries(Price,index-42,O,L,H,C)
                -0.002550421730458*PriceSeries(Price,index-43,O,L,H,C)
                -0.000842991446213*PriceSeries(Price,index-44,O,L,H,C)
                +0.001785984198751*PriceSeries(Price,index-45,O,L,H,C)
                +0.00317063075399*PriceSeries(Price,index-46,O,L,H,C)
                +0.002693447476028*PriceSeries(Price,index-47,O,L,H,C)
                +0.001410070245339*PriceSeries(Price,index-48,O,L,H,C)
                +0.0002897613206678*PriceSeries(Price,index-49,O,L,H,C)
                );

      case N7:
         return(
                0.469386456476*PriceSeries(Price,index,O,L,H,C)
                +0.400318112911*PriceSeries(Price,index-1,O,L,H,C)
                +0.2291747410230*PriceSeries(Price,index-2,O,L,H,C)
                +0.0417908303875*PriceSeries(Price,index-3,O,L,H,C)
                -0.0781889648407*PriceSeries(Price,index-4,O,L,H,C)
                -0.0963509265787*PriceSeries(Price,index-5,O,L,H,C)
                -0.0399379853104*PriceSeries(Price,index-6,O,L,H,C)
                +0.02910191050393*PriceSeries(Price,index-7,O,L,H,C)
                +0.0586196510891*PriceSeries(Price,index-8,O,L,H,C)
                +0.0369878446711*PriceSeries(Price,index-9,O,L,H,C)
                -0.00832638805305*PriceSeries(Price,index-10,O,L,H,C)
                -0.0383639981436*PriceSeries(Price,index-11,O,L,H,C)
                -0.0331292413898*PriceSeries(Price,index-12,O,L,H,C)
                -0.002890426382596*PriceSeries(Price,index-13,O,L,H,C)
                +0.02473935126595*PriceSeries(Price,index-14,O,L,H,C)
                +0.02861003928034*PriceSeries(Price,index-15,O,L,H,C)
                +0.00926222523023*PriceSeries(Price,index-16,O,L,H,C)
                -0.01470789166839*PriceSeries(Price,index-17,O,L,H,C)
                -0.02370170238568*PriceSeries(Price,index-18,O,L,H,C)
                -0.01259992181062*PriceSeries(Price,index-19,O,L,H,C)
                +0.00714192156203*PriceSeries(Price,index-20,O,L,H,C)
                +0.01868789453631*PriceSeries(Price,index-21,O,L,H,C)
                +0.01383898169693*PriceSeries(Price,index-22,O,L,H,C)
                -0.001524222299142*PriceSeries(Price,index-23,O,L,H,C)
                -0.01383594992644*PriceSeries(Price,index-24,O,L,H,C)
                -0.01358774095346*PriceSeries(Price,index-25,O,L,H,C)
                -0.002448037353662*PriceSeries(Price,index-26,O,L,H,C)
                +0.00937766969432*PriceSeries(Price,index-27,O,L,H,C)
                +0.01231077325060*PriceSeries(Price,index-28,O,L,H,C)
                +0.00500951155701*PriceSeries(Price,index-29,O,L,H,C)
                -0.00549406021636*PriceSeries(Price,index-30,O,L,H,C)
                -0.01039306701578*PriceSeries(Price,index-31,O,L,H,C)
                -0.00638304409319*PriceSeries(Price,index-32,O,L,H,C)
                +0.002305021058070*PriceSeries(Price,index-33,O,L,H,C)
                +0.00815902308575*PriceSeries(Price,index-34,O,L,H,C)
                +0.00679697714324*PriceSeries(Price,index-35,O,L,H,C)
                +0.0001341256000702*PriceSeries(Price,index-36,O,L,H,C)
                -0.00587481805969*PriceSeries(Price,index-37,O,L,H,C)
                -0.00648382199296*PriceSeries(Price,index-38,O,L,H,C)
                -0.001828886108609*PriceSeries(Price,index-39,O,L,H,C)
                +0.00374737937720*PriceSeries(Price,index-40,O,L,H,C)
                +0.00567236729042*PriceSeries(Price,index-41,O,L,H,C)
                +0.002838286447232*PriceSeries(Price,index-42,O,L,H,C)
                -0.001921415731005*PriceSeries(Price,index-43,O,L,H,C)
                -0.00457446775270*PriceSeries(Price,index-44,O,L,H,C)
                -0.00326205124939*PriceSeries(Price,index-45,O,L,H,C)
                +0.000481327595609*PriceSeries(Price,index-46,O,L,H,C)
                +0.00337429553655*PriceSeries(Price,index-47,O,L,H,C)
                +0.00322597808481*PriceSeries(Price,index-48,O,L,H,C)
                +0.000543361110278*PriceSeries(Price,index-49,O,L,H,C)
                -0.002219716412670*PriceSeries(Price,index-50,O,L,H,C)
                -0.002867455113316*PriceSeries(Price,index-51,O,L,H,C)
                -0.001170900058979*PriceSeries(Price,index-52,O,L,H,C)
                +0.001215130276493*PriceSeries(Price,index-53,O,L,H,C)
                +0.002318992155306*PriceSeries(Price,index-54,O,L,H,C)
                +0.001453293041901*PriceSeries(Price,index-55,O,L,H,C)
                -0.000424127809295*PriceSeries(Price,index-56,O,L,H,C)
                -0.001699515716402*PriceSeries(Price,index-57,O,L,H,C)
                -0.001466329289181*PriceSeries(Price,index-58,O,L,H,C)
                -0.0001307011699847*PriceSeries(Price,index-59,O,L,H,C)
                +0.001103717119534*PriceSeries(Price,index-60,O,L,H,C)
                +0.001296219675171*PriceSeries(Price,index-61,O,L,H,C)
                +0.000459469388579*PriceSeries(Price,index-62,O,L,H,C)
                -0.000599914807565*PriceSeries(Price,index-63,O,L,H,C)
                -0.001031157272949*PriceSeries(Price,index-64,O,L,H,C)
                -0.000600309460409*PriceSeries(Price,index-65,O,L,H,C)
                +0.0002307447549879*PriceSeries(Price,index-66,O,L,H,C)
                +0.000765021006060*PriceSeries(Price,index-67,O,L,H,C)
                +0.000627443568766*PriceSeries(Price,index-68,O,L,H,C)
                -0.00002088982587692*PriceSeries(Price,index-69,O,L,H,C)
                -0.000698043602734*PriceSeries(Price,index-70,O,L,H,C)
                -0.001000163748755*PriceSeries(Price,index-71,O,L,H,C)
                -0.000852020102174*PriceSeries(Price,index-72,O,L,H,C)
                -0.000468294826080*PriceSeries(Price,index-73,O,L,H,C)
                -0.0001318344246135*PriceSeries(Price,index-74,O,L,H,C)
                +0.0000843145058974*PriceSeries(Price,index-75,O,L,H,C)
                );

      case N8:
         return(
                0.517351439274*PriceSeries(Price,index,O,L,H,C)
                +0.405538331193*PriceSeries(Price,index-1,O,L,H,C)
                +0.2255229408748*PriceSeries(Price,index-2,O,L,H,C)
                +0.0442245555759*PriceSeries(Price,index-3,O,L,H,C)
                -0.0784152347264*PriceSeries(Price,index-4,O,L,H,C)
                -0.1145966997008*PriceSeries(Price,index-5,O,L,H,C)
                -0.0767991348395*PriceSeries(Price,index-6,O,L,H,C)
                -0.00623757988716*PriceSeries(Price,index-7,O,L,H,C)
                +0.0508755371507*PriceSeries(Price,index-8,O,L,H,C)
                +0.0661936833663*PriceSeries(Price,index-9,O,L,H,C)
                +0.0398296408827*PriceSeries(Price,index-10,O,L,H,C)
                -0.00517700565366*PriceSeries(Price,index-11,O,L,H,C)
                -0.0394810416745*PriceSeries(Price,index-12,O,L,H,C)
                -0.0447899359992*PriceSeries(Price,index-13,O,L,H,C)
                -0.02245623513910*PriceSeries(Price,index-14,O,L,H,C)
                +0.01023296977386*PriceSeries(Price,index-15,O,L,H,C)
                +0.0323352880599*PriceSeries(Price,index-16,O,L,H,C)
                +0.0319961992512*PriceSeries(Price,index-17,O,L,H,C)
                +0.01225908832961*PriceSeries(Price,index-18,O,L,H,C)
                -0.01259223741723*PriceSeries(Price,index-19,O,L,H,C)
                -0.02689856243782*PriceSeries(Price,index-20,O,L,H,C)
                -0.02316602948042*PriceSeries(Price,index-21,O,L,H,C)
                -0.00565622372145*PriceSeries(Price,index-22,O,L,H,C)
                +0.01346994034917*PriceSeries(Price,index-23,O,L,H,C)
                +0.02235488036135*PriceSeries(Price,index-24,O,L,H,C)
                +0.01660954560663*PriceSeries(Price,index-25,O,L,H,C)
                +0.001222859280715*PriceSeries(Price,index-26,O,L,H,C)
                -0.01341580038935*PriceSeries(Price,index-27,O,L,H,C)
                -0.01839002917910*PriceSeries(Price,index-28,O,L,H,C)
                -0.01156615543928*PriceSeries(Price,index-29,O,L,H,C)
                +0.001746852673536*PriceSeries(Price,index-30,O,L,H,C)
                +0.01275233929099*PriceSeries(Price,index-31,O,L,H,C)
                +0.01488816692867*PriceSeries(Price,index-32,O,L,H,C)
                +0.00765031743973*PriceSeries(Price,index-33,O,L,H,C)
                -0.00365167858934*PriceSeries(Price,index-34,O,L,H,C)
                -0.01168767616114*PriceSeries(Price,index-35,O,L,H,C)
                -0.01179880994250*PriceSeries(Price,index-36,O,L,H,C)
                -0.00462458010739*PriceSeries(Price,index-37,O,L,H,C)
                +0.00476526388287*PriceSeries(Price,index-38,O,L,H,C)
                +0.01038789276957*PriceSeries(Price,index-39,O,L,H,C)
                +0.00911315734875*PriceSeries(Price,index-40,O,L,H,C)
                +0.002337459984849*PriceSeries(Price,index-41,O,L,H,C)
                -0.00527903020779*PriceSeries(Price,index-42,O,L,H,C)
                -0.00897275947765*PriceSeries(Price,index-43,O,L,H,C)
                -0.00681911910386*PriceSeries(Price,index-44,O,L,H,C)
                -0.000663724092737*PriceSeries(Price,index-45,O,L,H,C)
                +0.00535104247970*PriceSeries(Price,index-46,O,L,H,C)
                +0.00754099155950*PriceSeries(Price,index-47,O,L,H,C)
                +0.00490470855177*PriceSeries(Price,index-48,O,L,H,C)
                -0.000503650362321*PriceSeries(Price,index-49,O,L,H,C)
                -0.00511436248743*PriceSeries(Price,index-50,O,L,H,C)
                -0.00617314872881*PriceSeries(Price,index-51,O,L,H,C)
                -0.00335694682832*PriceSeries(Price,index-52,O,L,H,C)
                +0.001252796972237*PriceSeries(Price,index-53,O,L,H,C)
                +0.00466995926135*PriceSeries(Price,index-54,O,L,H,C)
                +0.00491767902210*PriceSeries(Price,index-55,O,L,H,C)
                +0.002143064495053*PriceSeries(Price,index-56,O,L,H,C)
                -0.001674558713312*PriceSeries(Price,index-57,O,L,H,C)
                -0.00410861285182*PriceSeries(Price,index-58,O,L,H,C)
                -0.00380992479300*PriceSeries(Price,index-59,O,L,H,C)
                -0.001224887659818*PriceSeries(Price,index-60,O,L,H,C)
                +0.001852420492160*PriceSeries(Price,index-61,O,L,H,C)
                +0.00350538139474*PriceSeries(Price,index-62,O,L,H,C)
                +0.002872147511079*PriceSeries(Price,index-63,O,L,H,C)
                +0.000563280247375*PriceSeries(Price,index-64,O,L,H,C)
                -0.001856839168939*PriceSeries(Price,index-65,O,L,H,C)
                -0.002914132657517*PriceSeries(Price,index-66,O,L,H,C)
                -0.002107185770305*PriceSeries(Price,index-67,O,L,H,C)
                -0.0001105599340543*PriceSeries(Price,index-68,O,L,H,C)
                +0.001752628437613*PriceSeries(Price,index-69,O,L,H,C)
                +0.002372850949172*PriceSeries(Price,index-70,O,L,H,C)
                +0.001498041686551*PriceSeries(Price,index-71,O,L,H,C)
                -0.0002026702822819*PriceSeries(Price,index-72,O,L,H,C)
                -0.001631734776043*PriceSeries(Price,index-73,O,L,H,C)
                -0.001958744987090*PriceSeries(Price,index-74,O,L,H,C)
                -0.001086412251269*PriceSeries(Price,index-75,O,L,H,C)
                +0.000359942631345*PriceSeries(Price,index-76,O,L,H,C)
                +0.001458360588386*PriceSeries(Price,index-77,O,L,H,C)
                +0.001539227763170*PriceSeries(Price,index-78,O,L,H,C)
                +0.000531460923048*PriceSeries(Price,index-79,O,L,H,C)
                -0.001062022336771*PriceSeries(Price,index-80,O,L,H,C)
                -0.002491544104260*PriceSeries(Price,index-81,O,L,H,C)
                -0.00317018507987*PriceSeries(Price,index-82,O,L,H,C)
                -0.002933350993225*PriceSeries(Price,index-83,O,L,H,C)
                -0.002037405394854*PriceSeries(Price,index-84,O,L,H,C)
                -0.000953043485302*PriceSeries(Price,index-85,O,L,H,C)
                -0.0000992006322013*PriceSeries(Price,index-86,O,L,H,C)
                +0.000328738293149*PriceSeries(Price,index-87,O,L,H,C)
                +0.000376462856705*PriceSeries(Price,index-88,O,L,H,C)
                +0.0002668718811309*PriceSeries(Price,index-89,O,L,H,C)
                );

      case N9:
         return(
                0.458741157158*PriceSeries(Price,index,O,L,H,C)
                +0.379910473654*PriceSeries(Price,index-1,O,L,H,C)
                +0.2466802191525*PriceSeries(Price,index-2,O,L,H,C)
                +0.0988810602986*PriceSeries(Price,index-3,O,L,H,C)
                -0.02267724221458*PriceSeries(Price,index-4,O,L,H,C)
                -0.0902784002443*PriceSeries(Price,index-5,O,L,H,C)
                -0.0976083381815*PriceSeries(Price,index-6,O,L,H,C)
                -0.0594303348622*PriceSeries(Price,index-7,O,L,H,C)
                -0.00338382434638*PriceSeries(Price,index-8,O,L,H,C)
                +0.0422043050119*PriceSeries(Price,index-9,O,L,H,C)
                +0.0592748740077*PriceSeries(Price,index-10,O,L,H,C)
                +0.0454743329040*PriceSeries(Price,index-11,O,L,H,C)
                +0.01246197752853*PriceSeries(Price,index-12,O,L,H,C)
                -0.02138448115797*PriceSeries(Price,index-13,O,L,H,C)
                -0.0401120191802*PriceSeries(Price,index-14,O,L,H,C)
                -0.0370242143394*PriceSeries(Price,index-15,O,L,H,C)
                -0.01648632910718*PriceSeries(Price,index-16,O,L,H,C)
                +0.00950609743275*PriceSeries(Price,index-17,O,L,H,C)
                +0.02784357451333*PriceSeries(Price,index-18,O,L,H,C)
                +0.03058271775417*PriceSeries(Price,index-19,O,L,H,C)
                +0.01811836967713*PriceSeries(Price,index-20,O,L,H,C)
                -0.001902900368966*PriceSeries(Price,index-21,O,L,H,C)
                -0.01898614329508*PriceSeries(Price,index-22,O,L,H,C)
                -0.02510500126715*PriceSeries(Price,index-23,O,L,H,C)
                -0.01832348756610*PriceSeries(Price,index-24,O,L,H,C)
                -0.003155507905651*PriceSeries(Price,index-25,O,L,H,C)
                +0.01221327811913*PriceSeries(Price,index-26,O,L,H,C)
                +0.02022797682279*PriceSeries(Price,index-27,O,L,H,C)
                +0.01758583781818*PriceSeries(Price,index-28,O,L,H,C)
                +0.00648372907048*PriceSeries(Price,index-29,O,L,H,C)
                -0.00691492112909*PriceSeries(Price,index-30,O,L,H,C)
                -0.01582174658134*PriceSeries(Price,index-31,O,L,H,C)
                -0.01620110306684*PriceSeries(Price,index-32,O,L,H,C)
                -0.00853316085295*PriceSeries(Price,index-33,O,L,H,C)
                +0.002773858077596*PriceSeries(Price,index-34,O,L,H,C)
                +0.01185406390400*PriceSeries(Price,index-35,O,L,H,C)
                +0.01438341124328*PriceSeries(Price,index-36,O,L,H,C)
                +0.00959598017142*PriceSeries(Price,index-37,O,L,H,C)
                +0.000398810845257*PriceSeries(Price,index-38,O,L,H,C)
                -0.00833230110406*PriceSeries(Price,index-39,O,L,H,C)
                -0.01230457255322*PriceSeries(Price,index-40,O,L,H,C)
                -0.00988878293405*PriceSeries(Price,index-41,O,L,H,C)
                -0.002735272356056*PriceSeries(Price,index-42,O,L,H,C)
                +0.00527485896372*PriceSeries(Price,index-43,O,L,H,C)
                +0.01010841903976*PriceSeries(Price,index-44,O,L,H,C)
                +0.00958843001546*PriceSeries(Price,index-45,O,L,H,C)
                +0.00434378447526*PriceSeries(Price,index-46,O,L,H,C)
                -0.002696951321022*PriceSeries(Price,index-47,O,L,H,C)
                -0.00791608576685*PriceSeries(Price,index-48,O,L,H,C)
                -0.00884831125038*PriceSeries(Price,index-49,O,L,H,C)
                -0.00532424074894*PriceSeries(Price,index-50,O,L,H,C)
                +0.000602690600991*PriceSeries(Price,index-51,O,L,H,C)
                +0.00582711983279*PriceSeries(Price,index-52,O,L,H,C)
                +0.00780425209037*PriceSeries(Price,index-53,O,L,H,C)
                +0.00577436891397*PriceSeries(Price,index-54,O,L,H,C)
                +0.001017800615972*PriceSeries(Price,index-55,O,L,H,C)
                -0.00391967132802*PriceSeries(Price,index-56,O,L,H,C)
                -0.00657659183608*PriceSeries(Price,index-57,O,L,H,C)
                -0.00579123761654*PriceSeries(Price,index-58,O,L,H,C)
                -0.002188912527445*PriceSeries(Price,index-59,O,L,H,C)
                +0.002251143734607*PriceSeries(Price,index-60,O,L,H,C)
                +0.00527063938222*PriceSeries(Price,index-61,O,L,H,C)
                +0.00547151881422*PriceSeries(Price,index-62,O,L,H,C)
                +0.002949506470418*PriceSeries(Price,index-63,O,L,H,C)
                -0.000857153570803*PriceSeries(Price,index-64,O,L,H,C)
                -0.00397430254259*PriceSeries(Price,index-65,O,L,H,C)
                -0.00490757484756*PriceSeries(Price,index-66,O,L,H,C)
                -0.00334904950736*PriceSeries(Price,index-67,O,L,H,C)
                -0.0002457094729696*PriceSeries(Price,index-68,O,L,H,C)
                +0.002758455827083*PriceSeries(Price,index-69,O,L,H,C)
                +0.00418610369097*PriceSeries(Price,index-70,O,L,H,C)
                +0.00344538342224*PriceSeries(Price,index-71,O,L,H,C)
                +0.001058814122543*PriceSeries(Price,index-72,O,L,H,C)
                -0.001676221608473*PriceSeries(Price,index-73,O,L,H,C)
                -0.00338516960097*PriceSeries(Price,index-74,O,L,H,C)
                -0.00330121238049*PriceSeries(Price,index-75,O,L,H,C)
                -0.001598642033147*PriceSeries(Price,index-76,O,L,H,C)
                +0.000763164544008*PriceSeries(Price,index-77,O,L,H,C)
                +0.002572223241840*PriceSeries(Price,index-78,O,L,H,C)
                +0.002980501264550*PriceSeries(Price,index-79,O,L,H,C)
                +0.001894210590676*PriceSeries(Price,index-80,O,L,H,C)
                -0.0000380593939198*PriceSeries(Price,index-81,O,L,H,C)
                -0.001802047237687*PriceSeries(Price,index-82,O,L,H,C)
                -0.002545481715096*PriceSeries(Price,index-83,O,L,H,C)
                -0.001984237246203*PriceSeries(Price,index-84,O,L,H,C)
                -0.000496930727252*PriceSeries(Price,index-85,O,L,H,C)
                +0.001114163689114*PriceSeries(Price,index-86,O,L,H,C)
                +0.002050949539754*PriceSeries(Price,index-87,O,L,H,C)
                +0.001910473388565*PriceSeries(Price,index-88,O,L,H,C)
                +0.000849898712812*PriceSeries(Price,index-89,O,L,H,C)
                -0.000536899865918*PriceSeries(Price,index-90,O,L,H,C)
                -0.001546449958695*PriceSeries(Price,index-91,O,L,H,C)
                -0.001718676795139*PriceSeries(Price,index-92,O,L,H,C)
                -0.001041065804987*PriceSeries(Price,index-93,O,L,H,C)
                +0.0000839202980457*PriceSeries(Price,index-94,O,L,H,C)
                +0.001070857356642*PriceSeries(Price,index-95,O,L,H,C)
                +0.001452687708072*PriceSeries(Price,index-96,O,L,H,C)
                +0.001097376134122*PriceSeries(Price,index-97,O,L,H,C)
                +0.0002424793186883*PriceSeries(Price,index-98,O,L,H,C)
                -0.000653623854939*PriceSeries(Price,index-99,O,L,H,C)
                -0.001153539749005*PriceSeries(Price,index-100,O,L,H,C)
                -0.001051348329995*PriceSeries(Price,index-101,O,L,H,C)
                -0.000450587374788*PriceSeries(Price,index-102,O,L,H,C)
                +0.0003136428647644*PriceSeries(Price,index-103,O,L,H,C)
                +0.000857866555246*PriceSeries(Price,index-104,O,L,H,C)
                +0.000939215724290*PriceSeries(Price,index-105,O,L,H,C)
                +0.000559296996459*PriceSeries(Price,index-106,O,L,H,C)
                -0.0000589023184140*PriceSeries(Price,index-107,O,L,H,C)
                -0.000597433949538*PriceSeries(Price,index-108,O,L,H,C)
                -0.000803286692296*PriceSeries(Price,index-109,O,L,H,C)
                -0.000602236243159*PriceSeries(Price,index-110,O,L,H,C)
                -0.0001182251803270*PriceSeries(Price,index-111,O,L,H,C)
                +0.000400137607139*PriceSeries(Price,index-112,O,L,H,C)
                +0.000704352426457*PriceSeries(Price,index-113,O,L,H,C)
                +0.000655427384529*PriceSeries(Price,index-114,O,L,H,C)
                +0.0002750854969855*PriceSeries(Price,index-115,O,L,H,C)
                -0.0002813665870260*PriceSeries(Price,index-116,O,L,H,C)
                -0.000805307453039*PriceSeries(Price,index-117,O,L,H,C)
                -0.001125502991013*PriceSeries(Price,index-118,O,L,H,C)
                -0.001170149229693*PriceSeries(Price,index-119,O,L,H,C)
                -0.000976858605614*PriceSeries(Price,index-120,O,L,H,C)
                -0.000656637043467*PriceSeries(Price,index-121,O,L,H,C)
                -0.000336730370065*PriceSeries(Price,index-122,O,L,H,C)
                -0.0001132923458826*PriceSeries(Price,index-123,O,L,H,C)
                +0.0000946736165949*PriceSeries(Price,index-124,O,L,H,C)
                );

      case N10:
         return(
                0.412811092345*PriceSeries(Price,index,O,L,H,C)
                +0.355641710546*PriceSeries(Price,index-1,O,L,H,C)
                +0.2555772895076*PriceSeries(Price,index-2,O,L,H,C)
                +0.1369165973419*PriceSeries(Price,index-3,O,L,H,C)
                +0.02686304531672*PriceSeries(Price,index-4,O,L,H,C)
                -0.0521769521715*PriceSeries(Price,index-5,O,L,H,C)
                -0.0884588057873*PriceSeries(Price,index-6,O,L,H,C)
                -0.0831860965254*PriceSeries(Price,index-7,O,L,H,C)
                -0.0487118807291*PriceSeries(Price,index-8,O,L,H,C)
                -0.00350277417466*PriceSeries(Price,index-9,O,L,H,C)
                +0.0342788087231*PriceSeries(Price,index-10,O,L,H,C)
                +0.0523888853817*PriceSeries(Price,index-11,O,L,H,C)
                +0.0475546667181*PriceSeries(Price,index-12,O,L,H,C)
                +0.02520586307093*PriceSeries(Price,index-13,O,L,H,C)
                -0.00368699254568*PriceSeries(Price,index-14,O,L,H,C)
                -0.02728515336991*PriceSeries(Price,index-15,O,L,H,C)
                -0.0372846351129*PriceSeries(Price,index-16,O,L,H,C)
                -0.03152767975630*PriceSeries(Price,index-17,O,L,H,C)
                -0.01407852615658*PriceSeries(Price,index-18,O,L,H,C)
                +0.00700110348243*PriceSeries(Price,index-19,O,L,H,C)
                +0.02312862554055*PriceSeries(Price,index-20,O,L,H,C)
                +0.02851851989785*PriceSeries(Price,index-21,O,L,H,C)
                +0.02211687547876*PriceSeries(Price,index-22,O,L,H,C)
                +0.00755235313221*PriceSeries(Price,index-23,O,L,H,C)
                -0.00869944464385*PriceSeries(Price,index-24,O,L,H,C)
                -0.02008231537255*PriceSeries(Price,index-25,O,L,H,C)
                -0.02251758768719*PriceSeries(Price,index-26,O,L,H,C)
                -0.01578694859550*PriceSeries(Price,index-27,O,L,H,C)
                -0.00330085253872*PriceSeries(Price,index-28,O,L,H,C)
                +0.00953015453459*PriceSeries(Price,index-29,O,L,H,C)
                +0.01757959219632*PriceSeries(Price,index-30,O,L,H,C)
                +0.01800400103278*PriceSeries(Price,index-31,O,L,H,C)
                +0.01119557677629*PriceSeries(Price,index-32,O,L,H,C)
                +0.000390958490311*PriceSeries(Price,index-33,O,L,H,C)
                -0.00981456377333*PriceSeries(Price,index-34,O,L,H,C)
                -0.01538550702846*PriceSeries(Price,index-35,O,L,H,C)
                -0.01441074566486*PriceSeries(Price,index-36,O,L,H,C)
                -0.00771949678782*PriceSeries(Price,index-37,O,L,H,C)
                +0.001631697080736*PriceSeries(Price,index-38,O,L,H,C)
                +0.00972371543905*PriceSeries(Price,index-39,O,L,H,C)
                +0.01339417009587*PriceSeries(Price,index-40,O,L,H,C)
                +0.01145167280688*PriceSeries(Price,index-41,O,L,H,C)
                +0.00502725766998*PriceSeries(Price,index-42,O,L,H,C)
                -0.003022900631165*PriceSeries(Price,index-43,O,L,H,C)
                -0.00936694634454*PriceSeries(Price,index-44,O,L,H,C)
                -0.01156038159001*PriceSeries(Price,index-45,O,L,H,C)
                -0.00897159657458*PriceSeries(Price,index-46,O,L,H,C)
                -0.002926150423218*PriceSeries(Price,index-47,O,L,H,C)
                +0.00394124706681*PriceSeries(Price,index-48,O,L,H,C)
                +0.00882105617866*PriceSeries(Price,index-49,O,L,H,C)
                +0.00986665604256*PriceSeries(Price,index-50,O,L,H,C)
                +0.00687961415634*PriceSeries(Price,index-51,O,L,H,C)
                +0.001293904479950*PriceSeries(Price,index-52,O,L,H,C)
                -0.00449412421533*PriceSeries(Price,index-53,O,L,H,C)
                -0.00814380034140*PriceSeries(Price,index-54,O,L,H,C)
                -0.00830768632714*PriceSeries(Price,index-55,O,L,H,C)
                -0.00511687156582*PriceSeries(Price,index-56,O,L,H,C)
                -0.0000445692183062*PriceSeries(Price,index-57,O,L,H,C)
                +0.00476192791482*PriceSeries(Price,index-58,O,L,H,C)
                +0.00738283631512*PriceSeries(Price,index-59,O,L,H,C)
                +0.00688526196671*PriceSeries(Price,index-60,O,L,H,C)
                +0.00364332286119*PriceSeries(Price,index-61,O,L,H,C)
                -0.000885426588501*PriceSeries(Price,index-62,O,L,H,C)
                -0.00480675636141*PriceSeries(Price,index-63,O,L,H,C)
                -0.00657629091712*PriceSeries(Price,index-64,O,L,H,C)
                -0.00560133038342*PriceSeries(Price,index-65,O,L,H,C)
                -0.002426465653825*PriceSeries(Price,index-66,O,L,H,C)
                +0.001548912237520*PriceSeries(Price,index-67,O,L,H,C)
                +0.00468108320773*PriceSeries(Price,index-68,O,L,H,C)
                +0.00575700257575*PriceSeries(Price,index-69,O,L,H,C)
                +0.00445821561554*PriceSeries(Price,index-70,O,L,H,C)
                +0.001439132205861*PriceSeries(Price,index-71,O,L,H,C)
                -0.001990574524888*PriceSeries(Price,index-72,O,L,H,C)
                -0.00442928836396*PriceSeries(Price,index-73,O,L,H,C)
                -0.00495229516478*PriceSeries(Price,index-74,O,L,H,C)
                -0.00345676171484*PriceSeries(Price,index-75,O,L,H,C)
                -0.000656883117772*PriceSeries(Price,index-76,O,L,H,C)
                +0.002249336676810*PriceSeries(Price,index-77,O,L,H,C)
                +0.00408885509014*PriceSeries(Price,index-78,O,L,H,C)
                +0.00418356614118*PriceSeries(Price,index-79,O,L,H,C)
                +0.002594540898784*PriceSeries(Price,index-80,O,L,H,C)
                +0.0000553128562730*PriceSeries(Price,index-81,O,L,H,C)
                -0.002361195395403*PriceSeries(Price,index-82,O,L,H,C)
                -0.00369291117546*PriceSeries(Price,index-83,O,L,H,C)
                -0.00346842691132*PriceSeries(Price,index-84,O,L,H,C)
                -0.001867672110957*PriceSeries(Price,index-85,O,L,H,C)
                +0.000388082612835*PriceSeries(Price,index-86,O,L,H,C)
                +0.002357221520603*PriceSeries(Price,index-87,O,L,H,C)
                +0.00326814890759*PriceSeries(Price,index-88,O,L,H,C)
                +0.002818619403996*PriceSeries(Price,index-89,O,L,H,C)
                +0.001268927910240*PriceSeries(Price,index-90,O,L,H,C)
                -0.000695777711141*PriceSeries(Price,index-91,O,L,H,C)
                -0.002265349161073*PriceSeries(Price,index-92,O,L,H,C)
                -0.002836294763406*PriceSeries(Price,index-93,O,L,H,C)
                -0.002240906737136*PriceSeries(Price,index-94,O,L,H,C)
                -0.000787645344714*PriceSeries(Price,index-95,O,L,H,C)
                +0.000891126810789*PriceSeries(Price,index-96,O,L,H,C)
                +0.002111930144085*PriceSeries(Price,index-97,O,L,H,C)
                +0.002416233672577*PriceSeries(Price,index-98,O,L,H,C)
                +0.001739651574046*PriceSeries(Price,index-99,O,L,H,C)
                +0.000412892652433*PriceSeries(Price,index-100,O,L,H,C)
                -0.000994996596019*PriceSeries(Price,index-101,O,L,H,C)
                -0.001918672766073*PriceSeries(Price,index-102,O,L,H,C)
                -0.002021509771176*PriceSeries(Price,index-103,O,L,H,C)
                -0.001315124358665*PriceSeries(Price,index-104,O,L,H,C)
                -0.0001321787206968*PriceSeries(Price,index-105,O,L,H,C)
                +0.001026780931878*PriceSeries(Price,index-106,O,L,H,C)
                +0.001703344781971*PriceSeries(Price,index-107,O,L,H,C)
                +0.001660729205597*PriceSeries(Price,index-108,O,L,H,C)
                +0.000963117418202*PriceSeries(Price,index-109,O,L,H,C)
                -0.0000697653913498*PriceSeries(Price,index-110,O,L,H,C)
                -0.001006622660525*PriceSeries(Price,index-111,O,L,H,C)
                -0.001483086478152*PriceSeries(Price,index-112,O,L,H,C)
                -0.001341540888869*PriceSeries(Price,index-113,O,L,H,C)
                -0.000679647790356*PriceSeries(Price,index-114,O,L,H,C)
                +0.0002058883085059*PriceSeries(Price,index-115,O,L,H,C)
                +0.000950154297969*PriceSeries(Price,index-116,O,L,H,C)
                +0.001268992962424*PriceSeries(Price,index-117,O,L,H,C)
                +0.001065581251561*PriceSeries(Price,index-118,O,L,H,C)
                +0.000455760583637*PriceSeries(Price,index-119,O,L,H,C)
                -0.0002925184086283*PriceSeries(Price,index-120,O,L,H,C)
                -0.000874922188537*PriceSeries(Price,index-121,O,L,H,C)
                -0.001073288207873*PriceSeries(Price,index-122,O,L,H,C)
                -0.000835023781472*PriceSeries(Price,index-123,O,L,H,C)
                -0.0002828823174691*PriceSeries(Price,index-124,O,L,H,C)
                +0.000345499900625*PriceSeries(Price,index-125,O,L,H,C)
                +0.000797989615227*PriceSeries(Price,index-126,O,L,H,C)
                +0.000907432796666*PriceSeries(Price,index-127,O,L,H,C)
                +0.000651212333867*PriceSeries(Price,index-128,O,L,H,C)
                +0.0001506822556327*PriceSeries(Price,index-129,O,L,H,C)
                -0.000384840428786*PriceSeries(Price,index-130,O,L,H,C)
                -0.000743673762986*PriceSeries(Price,index-131,O,L,H,C)
                -0.000792911811139*PriceSeries(Price,index-132,O,L,H,C)
                -0.000524310347491*PriceSeries(Price,index-133,O,L,H,C)
                -0.0000504444431105*PriceSeries(Price,index-134,O,L,H,C)
                +0.000442883789106*PriceSeries(Price,index-135,O,L,H,C)
                +0.000768485201285*PriceSeries(Price,index-136,O,L,H,C)
                +0.000802596979347*PriceSeries(Price,index-137,O,L,H,C)
                +0.000524739213257*PriceSeries(Price,index-138,O,L,H,C)
                +0.00001551748805700*PriceSeries(Price,index-139,O,L,H,C)
                -0.000578032271651*PriceSeries(Price,index-140,O,L,H,C)
                -0.001095420416889*PriceSeries(Price,index-141,O,L,H,C)
                -0.001414635671128*PriceSeries(Price,index-142,O,L,H,C)
                -0.001483948206384*PriceSeries(Price,index-143,O,L,H,C)
                -0.001326429865682*PriceSeries(Price,index-144,O,L,H,C)
                -0.001020246913650*PriceSeries(Price,index-145,O,L,H,C)
                -0.000665694566242*PriceSeries(Price,index-146,O,L,H,C)
                -0.000352665284736*PriceSeries(Price,index-147,O,L,H,C)
                -0.0001435194754345*PriceSeries(Price,index-148,O,L,H,C)
                +0.0000725499276845*PriceSeries(Price,index-149,O,L,H,C)
                );

      case N11:
         return(
                0.317176228737*PriceSeries(Price,index,O,L,H,C)
                +0.2987958552517*PriceSeries(Price,index-1,O,L,H,C)
                +0.2474685273392*PriceSeries(Price,index-2,O,L,H,C)
                +0.1736944460727*PriceSeries(Price,index-3,O,L,H,C)
                +0.0920896732437*PriceSeries(Price,index-4,O,L,H,C)
                +0.01787357254827*PriceSeries(Price,index-5,O,L,H,C)
                -0.0366577915157*PriceSeries(Price,index-6,O,L,H,C)
                -0.0647631549216*PriceSeries(Price,index-7,O,L,H,C)
                -0.0663517978193*PriceSeries(Price,index-8,O,L,H,C)
                -0.0473398231087*PriceSeries(Price,index-9,O,L,H,C)
                -0.01754091294161*PriceSeries(Price,index-10,O,L,H,C)
                +0.01225245173049*PriceSeries(Price,index-11,O,L,H,C)
                +0.0331594386314*PriceSeries(Price,index-12,O,L,H,C)
                +0.0402966158067*PriceSeries(Price,index-13,O,L,H,C)
                +0.0335588989894*PriceSeries(Price,index-14,O,L,H,C)
                +0.01699663272287*PriceSeries(Price,index-15,O,L,H,C)
                -0.002906545377442*PriceSeries(Price,index-16,O,L,H,C)
                -0.01946114199915*PriceSeries(Price,index-17,O,L,H,C)
                -0.02781330389863*PriceSeries(Price,index-18,O,L,H,C)
                -0.02622054412127*PriceSeries(Price,index-19,O,L,H,C)
                -0.01625584148467*PriceSeries(Price,index-20,O,L,H,C)
                -0.001978731799360*PriceSeries(Price,index-21,O,L,H,C)
                +0.01158066326903*PriceSeries(Price,index-22,O,L,H,C)
                +0.02009880637554*PriceSeries(Price,index-23,O,L,H,C)
                +0.02126464020738*PriceSeries(Price,index-24,O,L,H,C)
                +0.01533870863125*PriceSeries(Price,index-25,O,L,H,C)
                +0.00485130332115*PriceSeries(Price,index-26,O,L,H,C)
                -0.00639672879114*PriceSeries(Price,index-27,O,L,H,C)
                -0.01466001744811*PriceSeries(Price,index-28,O,L,H,C)
                -0.01745496132229*PriceSeries(Price,index-29,O,L,H,C)
                -0.01426976626788*PriceSeries(Price,index-30,O,L,H,C)
                -0.00658627016647*PriceSeries(Price,index-31,O,L,H,C)
                +0.002745065748129*PriceSeries(Price,index-32,O,L,H,C)
                +0.01053090752982*PriceSeries(Price,index-33,O,L,H,C)
                +0.01430269603033*PriceSeries(Price,index-34,O,L,H,C)
                +0.01307712094681*PriceSeries(Price,index-35,O,L,H,C)
                +0.00758203811901*PriceSeries(Price,index-36,O,L,H,C)
                -0.0000919398490591*PriceSeries(Price,index-37,O,L,H,C)
                -0.00726472622895*PriceSeries(Price,index-38,O,L,H,C)
                -0.01158608046268*PriceSeries(Price,index-39,O,L,H,C)
                -0.01179104495040*PriceSeries(Price,index-40,O,L,H,C)
                -0.00805334405062*PriceSeries(Price,index-41,O,L,H,C)
                -0.001843995652439*PriceSeries(Price,index-42,O,L,H,C)
                +0.00462999921163*PriceSeries(Price,index-43,O,L,H,C)
                +0.00919828455111*PriceSeries(Price,index-44,O,L,H,C)
                +0.01044452569097*PriceSeries(Price,index-45,O,L,H,C)
                +0.00813475610559*PriceSeries(Price,index-46,O,L,H,C)
                +0.00323078283324*PriceSeries(Price,index-47,O,L,H,C)
                -0.002493491917181*PriceSeries(Price,index-48,O,L,H,C)
                -0.00708479700428*PriceSeries(Price,index-49,O,L,H,C)
                -0.00906955263125*PriceSeries(Price,index-50,O,L,H,C)
                -0.00791934432208*PriceSeries(Price,index-51,O,L,H,C)
                -0.00417830117790*PriceSeries(Price,index-52,O,L,H,C)
                +0.000772731518536*PriceSeries(Price,index-53,O,L,H,C)
                +0.00521854562808*PriceSeries(Price,index-54,O,L,H,C)
                +0.00769812715633*PriceSeries(Price,index-55,O,L,H,C)
                +0.00747932652151*PriceSeries(Price,index-56,O,L,H,C)
                +0.00476728335658*PriceSeries(Price,index-57,O,L,H,C)
                +0.000590195226365*PriceSeries(Price,index-58,O,L,H,C)
                -0.00358387156778*PriceSeries(Price,index-59,O,L,H,C)
                -0.00635845402410*PriceSeries(Price,index-60,O,L,H,C)
                -0.00687174553620*PriceSeries(Price,index-61,O,L,H,C)
                -0.00505912685296*PriceSeries(Price,index-62,O,L,H,C)
                -0.001637007443843*PriceSeries(Price,index-63,O,L,H,C)
                +0.002173449153637*PriceSeries(Price,index-64,O,L,H,C)
                +0.00507830600192*PriceSeries(Price,index-65,O,L,H,C)
                +0.00614697522352*PriceSeries(Price,index-66,O,L,H,C)
                +0.00510660057512*PriceSeries(Price,index-67,O,L,H,C)
                +0.002402885512109*PriceSeries(Price,index-68,O,L,H,C)
                -0.000982195087319*PriceSeries(Price,index-69,O,L,H,C)
                -0.00388364489653*PriceSeries(Price,index-70,O,L,H,C)
                -0.00535174291382*PriceSeries(Price,index-71,O,L,H,C)
                -0.00496007749980*PriceSeries(Price,index-72,O,L,H,C)
                -0.002924410167051*PriceSeries(Price,index-73,O,L,H,C)
                -0.000001218648782526*PriceSeries(Price,index-74,O,L,H,C)
                +0.002790131517731*PriceSeries(Price,index-75,O,L,H,C)
                +0.00452062596919*PriceSeries(Price,index-76,O,L,H,C)
                +0.00465856038635*PriceSeries(Price,index-77,O,L,H,C)
                +0.00322962517113*PriceSeries(Price,index-78,O,L,H,C)
                +0.000783095943739*PriceSeries(Price,index-79,O,L,H,C)
                -0.001815739666240*PriceSeries(Price,index-80,O,L,H,C)
                -0.00368962856345*PriceSeries(Price,index-81,O,L,H,C)
                -0.00424365383087*PriceSeries(Price,index-82,O,L,H,C)
                -0.00335172188295*PriceSeries(Price,index-83,O,L,H,C)
                -0.001377636648590*PriceSeries(Price,index-84,O,L,H,C)
                +0.000968859470797*PriceSeries(Price,index-85,O,L,H,C)
                +0.002885354828065*PriceSeries(Price,index-86,O,L,H,C)
                +0.00374964776416*PriceSeries(Price,index-87,O,L,H,C)
                +0.00331993254832*PriceSeries(Price,index-88,O,L,H,C)
                +0.001798538771962*PriceSeries(Price,index-89,O,L,H,C)
                -0.0002559381359976*PriceSeries(Price,index-90,O,L,H,C)
                -0.002131799774531*PriceSeries(Price,index-91,O,L,H,C)
                -0.00320946562491*PriceSeries(Price,index-92,O,L,H,C)
                -0.00316465966240*PriceSeries(Price,index-93,O,L,H,C)
                -0.002063497883355*PriceSeries(Price,index-94,O,L,H,C)
                -0.000322500874876*PriceSeries(Price,index-95,O,L,H,C)
                +0.001446804918897*PriceSeries(Price,index-96,O,L,H,C)
                +0.002651486101705*PriceSeries(Price,index-97,O,L,H,C)
                +0.002914709382055*PriceSeries(Price,index-98,O,L,H,C)
                +0.002191839945070*PriceSeries(Price,index-99,O,L,H,C)
                +0.000770030980989*PriceSeries(Price,index-100,O,L,H,C)
                -0.000843216254207*PriceSeries(Price,index-101,O,L,H,C)
                -0.002099997738688*PriceSeries(Price,index-102,O,L,H,C)
                -0.002597088986094*PriceSeries(Price,index-103,O,L,H,C)
                -0.002203972980593*PriceSeries(Price,index-104,O,L,H,C)
                -0.001093669244186*PriceSeries(Price,index-105,O,L,H,C)
                +0.000329395090185*PriceSeries(Price,index-106,O,L,H,C)
                +0.001575446400089*PriceSeries(Price,index-107,O,L,H,C)
                +0.002237044417449*PriceSeries(Price,index-108,O,L,H,C)
                +0.002121241017563*PriceSeries(Price,index-109,O,L,H,C)
                +0.001303798072287*PriceSeries(Price,index-110,O,L,H,C)
                +0.0000909516894331*PriceSeries(Price,index-111,O,L,H,C)
                -0.001093868221626*PriceSeries(Price,index-112,O,L,H,C)
                -0.001857071167943*PriceSeries(Price,index-113,O,L,H,C)
                -0.001964780358517*PriceSeries(Price,index-114,O,L,H,C)
                -0.001413060949018*PriceSeries(Price,index-115,O,L,H,C)
                -0.000417978595021*PriceSeries(Price,index-116,O,L,H,C)
                +0.000667295549801*PriceSeries(Price,index-117,O,L,H,C)
                +0.001477003934176*PriceSeries(Price,index-118,O,L,H,C)
                +0.001755352048660*PriceSeries(Price,index-119,O,L,H,C)
                +0.001436235760151*PriceSeries(Price,index-120,O,L,H,C)
                +0.000655752236874*PriceSeries(Price,index-121,O,L,H,C)
                -0.0003033321239428*PriceSeries(Price,index-122,O,L,H,C)
                -0.001113165696661*PriceSeries(Price,index-123,O,L,H,C)
                -0.001512236393570*PriceSeries(Price,index-124,O,L,H,C)
                -0.001388958218798*PriceSeries(Price,index-125,O,L,H,C)
                -0.000811142687325*PriceSeries(Price,index-126,O,L,H,C)
                +0.00000591276710974*PriceSeries(Price,index-127,O,L,H,C)
                +0.000778602587803*PriceSeries(Price,index-128,O,L,H,C)
                +0.001252897553686*PriceSeries(Price,index-129,O,L,H,C)
                +0.001287175444486*PriceSeries(Price,index-130,O,L,H,C)
                +0.000893323111348*PriceSeries(Price,index-131,O,L,H,C)
                +0.0002246136213780*PriceSeries(Price,index-132,O,L,H,C)
                -0.000482750318348*PriceSeries(Price,index-133,O,L,H,C)
                -0.000992445149049*PriceSeries(Price,index-134,O,L,H,C)
                -0.001146449980262*PriceSeries(Price,index-135,O,L,H,C)
                -0.000913141631565*PriceSeries(Price,index-136,O,L,H,C)
                -0.000390851689562*PriceSeries(Price,index-137,O,L,H,C)
                +0.0002318484856335*PriceSeries(Price,index-138,O,L,H,C)
                +0.000743610118544*PriceSeries(Price,index-139,O,L,H,C)
                +0.000981568751458*PriceSeries(Price,index-140,O,L,H,C)
                +0.000882434194540*PriceSeries(Price,index-141,O,L,H,C)
                +0.000497924155465*PriceSeries(Price,index-142,O,L,H,C)
                -0.00002897956886155*PriceSeries(Price,index-143,O,L,H,C)
                -0.000516388726791*PriceSeries(Price,index-144,O,L,H,C)
                -0.000805914148218*PriceSeries(Price,index-145,O,L,H,C)
                -0.000813535010706*PriceSeries(Price,index-146,O,L,H,C)
                -0.000553066214887*PriceSeries(Price,index-147,O,L,H,C)
                -0.0001258688768397*PriceSeries(Price,index-148,O,L,H,C)
                +0.000317763338309*PriceSeries(Price,index-149,O,L,H,C)
                +0.000630942777220*PriceSeries(Price,index-150,O,L,H,C)
                +0.000718421609095*PriceSeries(Price,index-151,O,L,H,C)
                +0.000564848394918*PriceSeries(Price,index-152,O,L,H,C)
                +0.0002349905175604*PriceSeries(Price,index-153,O,L,H,C)
                -0.0001523231146942*PriceSeries(Price,index-154,O,L,H,C)
                -0.000466496809200*PriceSeries(Price,index-155,O,L,H,C)
                -0.000608878024163*PriceSeries(Price,index-156,O,L,H,C)
                -0.000543053682178*PriceSeries(Price,index-157,O,L,H,C)
                -0.0003032005796213*PriceSeries(Price,index-158,O,L,H,C)
                +0.00002164452330378*PriceSeries(Price,index-159,O,L,H,C)
                +0.000319865643351*PriceSeries(Price,index-160,O,L,H,C)
                +0.000495439222759*PriceSeries(Price,index-161,O,L,H,C)
                +0.000498122038244*PriceSeries(Price,index-162,O,L,H,C)
                +0.000337207623021*PriceSeries(Price,index-163,O,L,H,C)
                +0.0000749567110101*PriceSeries(Price,index-164,O,L,H,C)
                -0.0001969982845287*PriceSeries(Price,index-165,O,L,H,C)
                -0.000389050549569*PriceSeries(Price,index-166,O,L,H,C)
                -0.000442667485968*PriceSeries(Price,index-167,O,L,H,C)
                -0.000347664727193*PriceSeries(Price,index-168,O,L,H,C)
                -0.0001426466017517*PriceSeries(Price,index-169,O,L,H,C)
                +0.0001001303776069*PriceSeries(Price,index-170,O,L,H,C)
                +0.0002996358498541*PriceSeries(Price,index-171,O,L,H,C)
                +0.000392585813507*PriceSeries(Price,index-172,O,L,H,C)
                +0.000352261806835*PriceSeries(Price,index-173,O,L,H,C)
                +0.0001956783021986*PriceSeries(Price,index-174,O,L,H,C)
                -0.00002459589846023*PriceSeries(Price,index-175,O,L,H,C)
                -0.0002369551633063*PriceSeries(Price,index-176,O,L,H,C)
                -0.000374465771060*PriceSeries(Price,index-177,O,L,H,C)
                -0.000393388526282*PriceSeries(Price,index-178,O,L,H,C)
                -0.0002845955750233*PriceSeries(Price,index-179,O,L,H,C)
                -0.0000742255676848*PriceSeries(Price,index-180,O,L,H,C)
                +0.0001866215864820*PriceSeries(Price,index-181,O,L,H,C)
                +0.000437553388360*PriceSeries(Price,index-182,O,L,H,C)
                +0.000625440608359*PriceSeries(Price,index-183,O,L,H,C)
                +0.000717632944148*PriceSeries(Price,index-184,O,L,H,C)
                +0.000707694687340*PriceSeries(Price,index-185,O,L,H,C)
                +0.000612998840401*PriceSeries(Price,index-186,O,L,H,C)
                +0.000466592442976*PriceSeries(Price,index-187,O,L,H,C)
                +0.0003060581753020*PriceSeries(Price,index-188,O,L,H,C)
                +0.0002054856966477*PriceSeries(Price,index-189,O,L,H,C)
                +0.000001516563625927*PriceSeries(Price,index-190,O,L,H,C)
                );

      case N12:
         return(
                0.337690319421*PriceSeries(Price,index,O,L,H,C)
                +0.3054166867667*PriceSeries(Price,index-1,O,L,H,C)
                +0.2464278425356*PriceSeries(Price,index-2,O,L,H,C)
                +0.1706996428068*PriceSeries(Price,index-3,O,L,H,C)
                +0.0905987358111*PriceSeries(Price,index-4,O,L,H,C)
                +0.01842074213700*PriceSeries(Price,index-5,O,L,H,C)
                -0.0359667705911*PriceSeries(Price,index-6,O,L,H,C)
                -0.0668725401492*PriceSeries(Price,index-7,O,L,H,C)
                -0.0735680339069*PriceSeries(Price,index-8,O,L,H,C)
                -0.0599870786704*PriceSeries(Price,index-9,O,L,H,C)
                -0.0334632307587*PriceSeries(Price,index-10,O,L,H,C)
                -0.002841063626335*PriceSeries(Price,index-11,O,L,H,C)
                +0.02357766278727*PriceSeries(Price,index-12,O,L,H,C)
                +0.0397801939714*PriceSeries(Price,index-13,O,L,H,C)
                +0.0431082869720*PriceSeries(Price,index-14,O,L,H,C)
                +0.0344522375421*PriceSeries(Price,index-15,O,L,H,C)
                +0.01760010034882*PriceSeries(Price,index-16,O,L,H,C)
                -0.002033038951410*PriceSeries(Price,index-17,O,L,H,C)
                -0.01893876551793*PriceSeries(Price,index-18,O,L,H,C)
                -0.02891798908427*PriceSeries(Price,index-19,O,L,H,C)
                -0.03001997553870*PriceSeries(Price,index-20,O,L,H,C)
                -0.02282469787792*PriceSeries(Price,index-21,O,L,H,C)
                -0.01005333072636*PriceSeries(Price,index-22,O,L,H,C)
                +0.00433833777670*PriceSeries(Price,index-23,O,L,H,C)
                +0.01630957802759*PriceSeries(Price,index-24,O,L,H,C)
                +0.02281157124468*PriceSeries(Price,index-25,O,L,H,C)
                +0.02251741363870*PriceSeries(Price,index-26,O,L,H,C)
                +0.01604054090347*PriceSeries(Price,index-27,O,L,H,C)
                +0.00562180034460*PriceSeries(Price,index-28,O,L,H,C)
                -0.00559421230593*PriceSeries(Price,index-29,O,L,H,C)
                -0.01447282332269*PriceSeries(Price,index-30,O,L,H,C)
                -0.01873675473219*PriceSeries(Price,index-31,O,L,H,C)
                -0.01752521705877*PriceSeries(Price,index-32,O,L,H,C)
                -0.01153357997313*PriceSeries(Price,index-33,O,L,H,C)
                -0.002722714422528*PriceSeries(Price,index-34,O,L,H,C)
                +0.00629663382706*PriceSeries(Price,index-35,O,L,H,C)
                +0.01301816953706*PriceSeries(Price,index-36,O,L,H,C)
                +0.01572020044672*PriceSeries(Price,index-37,O,L,H,C)
                +0.01389129922517*PriceSeries(Price,index-38,O,L,H,C)
                +0.00830020624949*PriceSeries(Price,index-39,O,L,H,C)
                +0.000711164310142*PriceSeries(Price,index-40,O,L,H,C)
                -0.00665790248842*PriceSeries(Price,index-41,O,L,H,C)
                -0.01177192932379*PriceSeries(Price,index-42,O,L,H,C)
                -0.01333054572258*PriceSeries(Price,index-43,O,L,H,C)
                -0.01108815806852*PriceSeries(Price,index-44,O,L,H,C)
                -0.00586654307895*PriceSeries(Price,index-45,O,L,H,C)
                +0.000727796952975*PriceSeries(Price,index-46,O,L,H,C)
                +0.00678858831011*PriceSeries(Price,index-47,O,L,H,C)
                +0.01065331967971*PriceSeries(Price,index-48,O,L,H,C)
                +0.01135235156983*PriceSeries(Price,index-49,O,L,H,C)
                +0.00884424484910*PriceSeries(Price,index-50,O,L,H,C)
                +0.00398243538820*PriceSeries(Price,index-51,O,L,H,C)
                -0.001764620349902*PriceSeries(Price,index-52,O,L,H,C)
                -0.00675083726290*PriceSeries(Price,index-53,O,L,H,C)
                -0.00961875616027*PriceSeries(Price,index-54,O,L,H,C)
                -0.00966414318861*PriceSeries(Price,index-55,O,L,H,C)
                -0.00700226992037*PriceSeries(Price,index-56,O,L,H,C)
                -0.002498777999938*PriceSeries(Price,index-57,O,L,H,C)
                +0.002505235551383*PriceSeries(Price,index-58,O,L,H,C)
                +0.00658824769981*PriceSeries(Price,index-59,O,L,H,C)
                +0.00864840229083*PriceSeries(Price,index-60,O,L,H,C)
                +0.00819700154454*PriceSeries(Price,index-61,O,L,H,C)
                +0.00546840940211*PriceSeries(Price,index-62,O,L,H,C)
                +0.001323527721151*PriceSeries(Price,index-63,O,L,H,C)
                -0.003017335425663*PriceSeries(Price,index-64,O,L,H,C)
                -0.00633063432165*PriceSeries(Price,index-65,O,L,H,C)
                -0.00773160133070*PriceSeries(Price,index-66,O,L,H,C)
                -0.00690741437500*PriceSeries(Price,index-67,O,L,H,C)
                -0.00418086338158*PriceSeries(Price,index-68,O,L,H,C)
                -0.000393860026993*PriceSeries(Price,index-69,O,L,H,C)
                +0.00334937894921*PriceSeries(Price,index-70,O,L,H,C)
                +0.00600190886054*PriceSeries(Price,index-71,O,L,H,C)
                +0.00686466150169*PriceSeries(Price,index-72,O,L,H,C)
                +0.00576794818771*PriceSeries(Price,index-73,O,L,H,C)
                +0.003097641157871*PriceSeries(Price,index-74,O,L,H,C)
                -0.000335153860067*PriceSeries(Price,index-75,O,L,H,C)
                -0.00353811978329*PriceSeries(Price,index-76,O,L,H,C)
                -0.00562278147672*PriceSeries(Price,index-77,O,L,H,C)
                -0.00604912115506*PriceSeries(Price,index-78,O,L,H,C)
                -0.00476302539105*PriceSeries(Price,index-79,O,L,H,C)
                -0.002192245882754*PriceSeries(Price,index-80,O,L,H,C)
                +0.000892337493484*PriceSeries(Price,index-81,O,L,H,C)
                +0.00360611078745*PriceSeries(Price,index-82,O,L,H,C)
                +0.00520293753185*PriceSeries(Price,index-83,O,L,H,C)
                +0.00527877267934*PriceSeries(Price,index-84,O,L,H,C)
                +0.00387148649758*PriceSeries(Price,index-85,O,L,H,C)
                +0.001433078767975*PriceSeries(Price,index-86,O,L,H,C)
                -0.001313063434473*PriceSeries(Price,index-87,O,L,H,C)
                -0.00358533628969*PriceSeries(Price,index-88,O,L,H,C)
                -0.00476516973643*PriceSeries(Price,index-89,O,L,H,C)
                -0.00456400335201*PriceSeries(Price,index-90,O,L,H,C)
                -0.003091387142448*PriceSeries(Price,index-91,O,L,H,C)
                -0.000808900987141*PriceSeries(Price,index-92,O,L,H,C)
                +0.001612738083939*PriceSeries(Price,index-93,O,L,H,C)
                +0.00348966023191*PriceSeries(Price,index-94,O,L,H,C)
                +0.00431692192830*PriceSeries(Price,index-95,O,L,H,C)
                +0.00390307617916*PriceSeries(Price,index-96,O,L,H,C)
                +0.002411703656043*PriceSeries(Price,index-97,O,L,H,C)
                +0.0003019221011163*PriceSeries(Price,index-98,O,L,H,C)
                -0.001811618154074*PriceSeries(Price,index-99,O,L,H,C)
                -0.00333687600914*PriceSeries(Price,index-100,O,L,H,C)
                -0.00386936601643*PriceSeries(Price,index-101,O,L,H,C)
                -0.00329818887621*PriceSeries(Price,index-102,O,L,H,C)
                -0.001825742532787*PriceSeries(Price,index-103,O,L,H,C)
                +0.0001010680980227*PriceSeries(Price,index-104,O,L,H,C)
                +0.001925421184447*PriceSeries(Price,index-105,O,L,H,C)
                +0.003140724531204*PriceSeries(Price,index-106,O,L,H,C)
                +0.00343047283058*PriceSeries(Price,index-107,O,L,H,C)
                +0.002749456850097*PriceSeries(Price,index-108,O,L,H,C)
                +0.001325854304909*PriceSeries(Price,index-109,O,L,H,C)
                -0.000413279753632*PriceSeries(Price,index-110,O,L,H,C)
                -0.001969275615312*PriceSeries(Price,index-111,O,L,H,C)
                -0.002914174803791*PriceSeries(Price,index-112,O,L,H,C)
                -0.003007669953374*PriceSeries(Price,index-113,O,L,H,C)
                -0.002256963228696*PriceSeries(Price,index-114,O,L,H,C)
                -0.000904997221305*PriceSeries(Price,index-115,O,L,H,C)
                +0.000646766957834*PriceSeries(Price,index-116,O,L,H,C)
                +0.001956876277700*PriceSeries(Price,index-117,O,L,H,C)
                +0.002668873217132*PriceSeries(Price,index-118,O,L,H,C)
                +0.002607562710539*PriceSeries(Price,index-119,O,L,H,C)
                +0.001820750266196*PriceSeries(Price,index-120,O,L,H,C)
                +0.000556994197938*PriceSeries(Price,index-121,O,L,H,C)
                -0.000811882840837*PriceSeries(Price,index-122,O,L,H,C)
                -0.001899588081084*PriceSeries(Price,index-123,O,L,H,C)
                -0.002413858651414*PriceSeries(Price,index-124,O,L,H,C)
                -0.002234259724169*PriceSeries(Price,index-125,O,L,H,C)
                -0.001438886235473*PriceSeries(Price,index-126,O,L,H,C)
                -0.0002744731820661*PriceSeries(Price,index-127,O,L,H,C)
                +0.000919311032909*PriceSeries(Price,index-128,O,L,H,C)
                +0.001808467209898*PriceSeries(Price,index-129,O,L,H,C)
                +0.002157594429544*PriceSeries(Price,index-130,O,L,H,C)
                +0.001891518931937*PriceSeries(Price,index-131,O,L,H,C)
                +0.001109629668820*PriceSeries(Price,index-132,O,L,H,C)
                +0.0000509718414077*PriceSeries(Price,index-133,O,L,H,C)
                -0.000978217400359*PriceSeries(Price,index-134,O,L,H,C)
                -0.001692614254000*PriceSeries(Price,index-135,O,L,H,C)
                -0.001906476993661*PriceSeries(Price,index-136,O,L,H,C)
                -0.001581168091766*PriceSeries(Price,index-137,O,L,H,C)
                -0.000829775459049*PriceSeries(Price,index-138,O,L,H,C)
                +0.0001208188764840*PriceSeries(Price,index-139,O,L,H,C)
                +0.000997877868402*PriceSeries(Price,index-140,O,L,H,C)
                +0.001560697617851*PriceSeries(Price,index-141,O,L,H,C)
                +0.001666180908263*PriceSeries(Price,index-142,O,L,H,C)
                +0.001304497769968*PriceSeries(Price,index-143,O,L,H,C)
                +0.000596057259263*PriceSeries(Price,index-144,O,L,H,C)
                -0.0002475315331973*PriceSeries(Price,index-145,O,L,H,C)
                -0.000986271233196*PriceSeries(Price,index-146,O,L,H,C)
                -0.001419635703376*PriceSeries(Price,index-147,O,L,H,C)
                -0.001440620766263*PriceSeries(Price,index-148,O,L,H,C)
                -0.001061308133813*PriceSeries(Price,index-149,O,L,H,C)
                -0.000404344202488*PriceSeries(Price,index-150,O,L,H,C)
                +0.000336016358923*PriceSeries(Price,index-151,O,L,H,C)
                +0.000950914518563*PriceSeries(Price,index-152,O,L,H,C)
                +0.001275499367551*PriceSeries(Price,index-153,O,L,H,C)
                +0.001232637507839*PriceSeries(Price,index-154,O,L,H,C)
                +0.000850444766666*PriceSeries(Price,index-155,O,L,H,C)
                +0.0002497450567590*PriceSeries(Price,index-156,O,L,H,C)
                -0.000393472947036*PriceSeries(Price,index-157,O,L,H,C)
                -0.000899343568176*PriceSeries(Price,index-158,O,L,H,C)
                -0.001134008011803*PriceSeries(Price,index-159,O,L,H,C)
                -0.001044672709476*PriceSeries(Price,index-160,O,L,H,C)
                -0.000670487165324*PriceSeries(Price,index-161,O,L,H,C)
                -0.0001276361490056*PriceSeries(Price,index-162,O,L,H,C)
                +0.000426316873117*PriceSeries(Price,index-163,O,L,H,C)
                +0.000837789087685*PriceSeries(Price,index-164,O,L,H,C)
                +0.000999465384521*PriceSeries(Price,index-165,O,L,H,C)
                +0.000877771261239*PriceSeries(Price,index-166,O,L,H,C)
                +0.000518883594104*PriceSeries(Price,index-167,O,L,H,C)
                +0.0000323326950991*PriceSeries(Price,index-168,O,L,H,C)
                -0.000441921043723*PriceSeries(Price,index-169,O,L,H,C)
                -0.000773517395433*PriceSeries(Price,index-170,O,L,H,C)
                -0.000877077985935*PriceSeries(Price,index-171,O,L,H,C)
                -0.000733825673771*PriceSeries(Price,index-172,O,L,H,C)
                -0.000393747373644*PriceSeries(Price,index-173,O,L,H,C)
                +0.0000410809277515*PriceSeries(Price,index-174,O,L,H,C)
                +0.000446823195479*PriceSeries(Price,index-175,O,L,H,C)
                +0.000712732527188*PriceSeries(Price,index-176,O,L,H,C)
                +0.000771010395494*PriceSeries(Price,index-177,O,L,H,C)
                +0.000613522010304*PriceSeries(Price,index-178,O,L,H,C)
                +0.0002917132954967*PriceSeries(Price,index-179,O,L,H,C)
                -0.0000999120333423*PriceSeries(Price,index-180,O,L,H,C)
                -0.000451060669530*PriceSeries(Price,index-181,O,L,H,C)
                -0.000666360609387*PriceSeries(Price,index-182,O,L,H,C)
                -0.000690567076533*PriceSeries(Price,index-183,O,L,H,C)
                -0.000522212277177*PriceSeries(Price,index-184,O,L,H,C)
                -0.0002121686531481*PriceSeries(Price,index-185,O,L,H,C)
                +0.0001516288959956*PriceSeries(Price,index-186,O,L,H,C)
                +0.000468820275188*PriceSeries(Price,index-187,O,L,H,C)
                +0.000653590795765*PriceSeries(Price,index-188,O,L,H,C)
                +0.000656981540085*PriceSeries(Price,index-189,O,L,H,C)
                +0.000478682426925*PriceSeries(Price,index-190,O,L,H,C)
                +0.0001662744420471*PriceSeries(Price,index-191,O,L,H,C)
                -0.0001979688745028*PriceSeries(Price,index-192,O,L,H,C)
                -0.000518057992568*PriceSeries(Price,index-193,O,L,H,C)
                -0.000708220326686*PriceSeries(Price,index-194,O,L,H,C)
                -0.000713034911241*PriceSeries(Price,index-195,O,L,H,C)
                -0.000519418917259*PriceSeries(Price,index-196,O,L,H,C)
                -0.0001580078935077*PriceSeries(Price,index-197,O,L,H,C)
                +0.0003057738692871*PriceSeries(Price,index-198,O,L,H,C)
                +0.000787752427987*PriceSeries(Price,index-199,O,L,H,C)
                +0.001204079951224*PriceSeries(Price,index-200,O,L,H,C)
                +0.001488899288066*PriceSeries(Price,index-201,O,L,H,C)
                +0.001605927539523*PriceSeries(Price,index-202,O,L,H,C)
                +0.001553187113350*PriceSeries(Price,index-203,O,L,H,C)
                +0.001358780034372*PriceSeries(Price,index-204,O,L,H,C)
                +0.001071720082900*PriceSeries(Price,index-205,O,L,H,C)
                +0.000749249081965*PriceSeries(Price,index-206,O,L,H,C)
                +0.000443981985986*PriceSeries(Price,index-207,O,L,H,C)
                +0.0001954021863015*PriceSeries(Price,index-208,O,L,H,C)
                +0.00002326267422554*PriceSeries(Price,index-209,O,L,H,C)
                -0.0000705822870772*PriceSeries(Price,index-210,O,L,H,C)
                -0.0000990025610677*PriceSeries(Price,index-211,O,L,H,C)
                -0.0001526825736122*PriceSeries(Price,index-212,O,L,H,C)
                );

      case N13:
         return(
                0.336064966484*PriceSeries(Price,index,O,L,H,C)
                +0.3047926296965*PriceSeries(Price,index-1,O,L,H,C)
                +0.2474983491625*PriceSeries(Price,index-2,O,L,H,C)
                +0.1736310550882*PriceSeries(Price,index-3,O,L,H,C)
                +0.0949644970904*PriceSeries(Price,index-4,O,L,H,C)
                +0.02330860852137*PriceSeries(Price,index-5,O,L,H,C)
                -0.0317034853911*PriceSeries(Price,index-6,O,L,H,C)
                -0.0642901596966*PriceSeries(Price,index-7,O,L,H,C)
                -0.0733261637959*PriceSeries(Price,index-8,O,L,H,C)
                -0.0621482800357*PriceSeries(Price,index-9,O,L,H,C)
                -0.0374570572389*PriceSeries(Price,index-10,O,L,H,C)
                -0.00760493629018*PriceSeries(Price,index-11,O,L,H,C)
                +0.01931799018835*PriceSeries(Price,index-12,O,L,H,C)
                +0.0371672956951*PriceSeries(Price,index-13,O,L,H,C)
                +0.0428419034418*PriceSeries(Price,index-14,O,L,H,C)
                +0.0365969316550*PriceSeries(Price,index-15,O,L,H,C)
                +0.02156593367920*PriceSeries(Price,index-16,O,L,H,C)
                +0.002669555421989*PriceSeries(Price,index-17,O,L,H,C)
                -0.01478217352865*PriceSeries(Price,index-18,O,L,H,C)
                -0.02643772432206*PriceSeries(Price,index-19,O,L,H,C)
                -0.02988489424255*PriceSeries(Price,index-20,O,L,H,C)
                -0.02506008514895*PriceSeries(Price,index-21,O,L,H,C)
                -0.01403583569872*PriceSeries(Price,index-22,O,L,H,C)
                -0.0002924317541463*PriceSeries(Price,index-23,O,L,H,C)
                +0.01230160805440*PriceSeries(Price,index-24,O,L,H,C)
                +0.02052011270532*PriceSeries(Price,index-25,O,L,H,C)
                +0.02255941458211*PriceSeries(Price,index-26,O,L,H,C)
                +0.01838923535798*PriceSeries(Price,index-27,O,L,H,C)
                +0.00961764946569*PriceSeries(Price,index-28,O,L,H,C)
                -0.001058547014365*PriceSeries(Price,index-29,O,L,H,C)
                -0.01064534498879*PriceSeries(Price,index-30,O,L,H,C)
                -0.01666214958185*PriceSeries(Price,index-31,O,L,H,C)
                -0.01775905959140*PriceSeries(Price,index-32,O,L,H,C)
                -0.01399309649067*PriceSeries(Price,index-33,O,L,H,C)
                -0.00671436422045*PriceSeries(Price,index-34,O,L,H,C)
                +0.001881653505925*PriceSeries(Price,index-35,O,L,H,C)
                +0.00939557174566*PriceSeries(Price,index-36,O,L,H,C)
                +0.01387733565028*PriceSeries(Price,index-37,O,L,H,C)
                +0.01431752627576*PriceSeries(Price,index-38,O,L,H,C)
                +0.01085674734404*PriceSeries(Price,index-39,O,L,H,C)
                +0.00467508456496*PriceSeries(Price,index-40,O,L,H,C)
                -0.002389262959691*PriceSeries(Price,index-41,O,L,H,C)
                -0.00837390484139*PriceSeries(Price,index-42,O,L,H,C)
                -0.01172707125760*PriceSeries(Price,index-43,O,L,H,C)
                -0.01170020250035*PriceSeries(Price,index-44,O,L,H,C)
                -0.00850162560418*PriceSeries(Price,index-45,O,L,H,C)
                -0.00318399016936*PriceSeries(Price,index-46,O,L,H,C)
                +0.002688834379060*PriceSeries(Price,index-47,O,L,H,C)
                +0.00749336723710*PriceSeries(Price,index-48,O,L,H,C)
                +0.00998834460851*PriceSeries(Price,index-49,O,L,H,C)
                +0.00962845925381*PriceSeries(Price,index-50,O,L,H,C)
                +0.00667252248402*PriceSeries(Price,index-51,O,L,H,C)
                +0.002068387031930*PriceSeries(Price,index-52,O,L,H,C)
                -0.002842039466980*PriceSeries(Price,index-53,O,L,H,C)
                -0.00670809250680*PriceSeries(Price,index-54,O,L,H,C)
                -0.00853694657477*PriceSeries(Price,index-55,O,L,H,C)
                -0.00794322448491*PriceSeries(Price,index-56,O,L,H,C)
                -0.00522052170436*PriceSeries(Price,index-57,O,L,H,C)
                -0.001224872688591*PriceSeries(Price,index-58,O,L,H,C)
                +0.002888004672674*PriceSeries(Price,index-59,O,L,H,C)
                +0.00599283264039*PriceSeries(Price,index-60,O,L,H,C)
                +0.00729889228032*PriceSeries(Price,index-61,O,L,H,C)
                +0.00654715220455*PriceSeries(Price,index-62,O,L,H,C)
                +0.00405234309593*PriceSeries(Price,index-63,O,L,H,C)
                +0.000586858297869*PriceSeries(Price,index-64,O,L,H,C)
                -0.002853727031454*PriceSeries(Price,index-65,O,L,H,C)
                -0.00533346931872*PriceSeries(Price,index-66,O,L,H,C)
                -0.00622779978437*PriceSeries(Price,index-67,O,L,H,C)
                -0.00537715882691*PriceSeries(Price,index-68,O,L,H,C)
                -0.003105956607839*PriceSeries(Price,index-69,O,L,H,C)
                -0.0001086365966577*PriceSeries(Price,index-70,O,L,H,C)
                +0.002759117371223*PriceSeries(Price,index-71,O,L,H,C)
                +0.00472220186050*PriceSeries(Price,index-72,O,L,H,C)
                +0.00529321004467*PriceSeries(Price,index-73,O,L,H,C)
                +0.00439025129434*PriceSeries(Price,index-74,O,L,H,C)
                +0.002337886079923*PriceSeries(Price,index-75,O,L,H,C)
                -0.0002428614490656*PriceSeries(Price,index-76,O,L,H,C)
                -0.002619705286754*PriceSeries(Price,index-77,O,L,H,C)
                -0.00415487920742*PriceSeries(Price,index-78,O,L,H,C)
                -0.00447428028720*PriceSeries(Price,index-79,O,L,H,C)
                -0.00355568992437*PriceSeries(Price,index-80,O,L,H,C)
                -0.001716136681026*PriceSeries(Price,index-81,O,L,H,C)
                +0.000492759050197*PriceSeries(Price,index-82,O,L,H,C)
                +0.002448030390127*PriceSeries(Price,index-83,O,L,H,C)
                +0.00362940867897*PriceSeries(Price,index-84,O,L,H,C)
                +0.00375605623403*PriceSeries(Price,index-85,O,L,H,C)
                +0.002850500609441*PriceSeries(Price,index-86,O,L,H,C)
                +0.001216136354843*PriceSeries(Price,index-87,O,L,H,C)
                -0.000660876952845*PriceSeries(Price,index-88,O,L,H,C)
                -0.002254492981197*PriceSeries(Price,index-89,O,L,H,C)
                -0.003144833492045*PriceSeries(Price,index-90,O,L,H,C)
                -0.003127280233841*PriceSeries(Price,index-91,O,L,H,C)
                -0.002256711212341*PriceSeries(Price,index-92,O,L,H,C)
                -0.000818275110808*PriceSeries(Price,index-93,O,L,H,C)
                +0.000763345637492*PriceSeries(Price,index-94,O,L,H,C)
                +0.002047845939889*PriceSeries(Price,index-95,O,L,H,C)
                +0.002700723685407*PriceSeries(Price,index-96,O,L,H,C)
                +0.002579003901930*PriceSeries(Price,index-97,O,L,H,C)
                +0.001759685735546*PriceSeries(Price,index-98,O,L,H,C)
                +0.000506327711007*PriceSeries(Price,index-99,O,L,H,C)
                -0.000813638029595*PriceSeries(Price,index-100,O,L,H,C)
                -0.001835438046617*PriceSeries(Price,index-101,O,L,H,C)
                -0.002296725132605*PriceSeries(Price,index-102,O,L,H,C)
                -0.002103688174494*PriceSeries(Price,index-103,O,L,H,C)
                -0.001347041133214*PriceSeries(Price,index-104,O,L,H,C)
                -0.0002666013837400*PriceSeries(Price,index-105,O,L,H,C)
                +0.000823107023885*PriceSeries(Price,index-106,O,L,H,C)
                +0.001623391051321*PriceSeries(Price,index-107,O,L,H,C)
                +0.001932388523320*PriceSeries(Price,index-108,O,L,H,C)
                +0.001694713420125*PriceSeries(Price,index-109,O,L,H,C)
                +0.001008039079937*PriceSeries(Price,index-110,O,L,H,C)
                +0.0000872603852553*PriceSeries(Price,index-111,O,L,H,C)
                -0.000801464568537*PriceSeries(Price,index-112,O,L,H,C)
                -0.001416806209407*PriceSeries(Price,index-113,O,L,H,C)
                -0.001606970163567*PriceSeries(Price,index-114,O,L,H,C)
                -0.001345960415064*PriceSeries(Price,index-115,O,L,H,C)
                -0.000733075353902*PriceSeries(Price,index-116,O,L,H,C)
                +0.0000420379155079*PriceSeries(Price,index-117,O,L,H,C)
                +0.000756974726517*PriceSeries(Price,index-118,O,L,H,C)
                +0.001219695696420*PriceSeries(Price,index-119,O,L,H,C)
                +0.001319369185631*PriceSeries(Price,index-120,O,L,H,C)
                +0.001051708601777*PriceSeries(Price,index-121,O,L,H,C)
                +0.000513497816065*PriceSeries(Price,index-122,O,L,H,C)
                -0.0001303916070119*PriceSeries(Price,index-123,O,L,H,C)
                -0.000696689335917*PriceSeries(Price,index-124,O,L,H,C)
                -0.001035210552604*PriceSeries(Price,index-125,O,L,H,C)
                -0.001068086927768*PriceSeries(Price,index-126,O,L,H,C)
                -0.000806393928383*PriceSeries(Price,index-127,O,L,H,C)
                -0.000341420850696*PriceSeries(Price,index-128,O,L,H,C)
                +0.0001857953056109*PriceSeries(Price,index-129,O,L,H,C)
                +0.000626484746288*PriceSeries(Price,index-130,O,L,H,C)
                +0.000865616193353*PriceSeries(Price,index-131,O,L,H,C)
                +0.000851260153847*PriceSeries(Price,index-132,O,L,H,C)
                +0.000604709084396*PriceSeries(Price,index-133,O,L,H,C)
                +0.0002096178938672*PriceSeries(Price,index-134,O,L,H,C)
                -0.0002152811394863*PriceSeries(Price,index-135,O,L,H,C)
                -0.000551281101922*PriceSeries(Price,index-136,O,L,H,C)
                -0.000712360658549*PriceSeries(Price,index-137,O,L,H,C)
                -0.000666677096367*PriceSeries(Price,index-138,O,L,H,C)
                -0.000441494671349*PriceSeries(Price,index-139,O,L,H,C)
                -0.0001115400092807*PriceSeries(Price,index-140,O,L,H,C)
                +0.0002249445139924*PriceSeries(Price,index-141,O,L,H,C)
                +0.000474998924573*PriceSeries(Price,index-142,O,L,H,C)
                +0.000576258083366*PriceSeries(Price,index-143,O,L,H,C)
                +0.000511836907892*PriceSeries(Price,index-144,O,L,H,C)
                +0.0003117785592646*PriceSeries(Price,index-145,O,L,H,C)
                +0.0000412548409832*PriceSeries(Price,index-146,O,L,H,C)
                -0.0002200048953228*PriceSeries(Price,index-147,O,L,H,C)
                -0.000400771457021*PriceSeries(Price,index-148,O,L,H,C)
                -0.000457484183898*PriceSeries(Price,index-149,O,L,H,C)
                -0.000384078714360*PriceSeries(Price,index-150,O,L,H,C)
                -0.0002108828064791*PriceSeries(Price,index-151,O,L,H,C)
                +0.00000660203879169*PriceSeries(Price,index-152,O,L,H,C)
                +0.0002049389941204*PriceSeries(Price,index-153,O,L,H,C)
                +0.000330948949345*PriceSeries(Price,index-154,O,L,H,C)
                +0.000355692532552*PriceSeries(Price,index-155,O,L,H,C)
                +0.0002805149393730*PriceSeries(Price,index-156,O,L,H,C)
                +0.0001342873320625*PriceSeries(Price,index-157,O,L,H,C)
                -0.0000368060586309*PriceSeries(Price,index-158,O,L,H,C)
                -0.0001834144065633*PriceSeries(Price,index-159,O,L,H,C)
                -0.0002670954957084*PriceSeries(Price,index-160,O,L,H,C)
                -0.0002700326474201*PriceSeries(Price,index-161,O,L,H,C)
                -0.0001982538443033*PriceSeries(Price,index-162,O,L,H,C)
                -0.0000779661991955*PriceSeries(Price,index-163,O,L,H,C)
                +0.0000533241960429*PriceSeries(Price,index-164,O,L,H,C)
                +0.0001583582887463*PriceSeries(Price,index-165,O,L,H,C)
                +0.0002103482018490*PriceSeries(Price,index-166,O,L,H,C)
                +0.0001995131949661*PriceSeries(Price,index-167,O,L,H,C)
                +0.0001344571399406*PriceSeries(Price,index-168,O,L,H,C)
                +0.0000381363268615*PriceSeries(Price,index-169,O,L,H,C)
                -0.0000599353346303*PriceSeries(Price,index-170,O,L,H,C)
                -0.0001322330061668*PriceSeries(Price,index-171,O,L,H,C)
                -0.0001611587205026*PriceSeries(Price,index-172,O,L,H,C)
                -0.0001426312616576*PriceSeries(Price,index-173,O,L,H,C)
                -0.0000863255517414*PriceSeries(Price,index-174,O,L,H,C)
                -0.00001142648790542*PriceSeries(Price,index-175,O,L,H,C)
                +0.0000593934870058*PriceSeries(Price,index-176,O,L,H,C)
                +0.0001067655968949*PriceSeries(Price,index-177,O,L,H,C)
                +0.0001196857886060*PriceSeries(Price,index-178,O,L,H,C)
                +0.0000979558379775*PriceSeries(Price,index-179,O,L,H,C)
                +0.0000511174889597*PriceSeries(Price,index-180,O,L,H,C)
                -0.00000518510495084*PriceSeries(Price,index-181,O,L,H,C)
                -0.0000542923828083*PriceSeries(Price,index-182,O,L,H,C)
                -0.0000831499101855*PriceSeries(Price,index-183,O,L,H,C)
                -0.0000856796725459*PriceSeries(Price,index-184,O,L,H,C)
                -0.0000638725682593*PriceSeries(Price,index-185,O,L,H,C)
                -0.00002653227745590*PriceSeries(Price,index-186,O,L,H,C)
                +0.00001419310971945*PriceSeries(Price,index-187,O,L,H,C)
                +0.0000465503094742*PriceSeries(Price,index-188,O,L,H,C)
                +0.0000622565367776*PriceSeries(Price,index-189,O,L,H,C)
                +0.0000585389960072*PriceSeries(Price,index-190,O,L,H,C)
                +0.0000387895347999*PriceSeries(Price,index-191,O,L,H,C)
                +0.00001035637979310*PriceSeries(Price,index-192,O,L,H,C)
                -0.00001793061539166*PriceSeries(Price,index-193,O,L,H,C)
                -0.0000376658619242*PriceSeries(Price,index-194,O,L,H,C)
                -0.0000445704767628*PriceSeries(Price,index-195,O,L,H,C)
                -0.0000378952765145*PriceSeries(Price,index-196,O,L,H,C)
                -0.00002125989570553*PriceSeries(Price,index-197,O,L,H,C)
                -0.000000529931170486*PriceSeries(Price,index-198,O,L,H,C)
                +0.00001787726705513*PriceSeries(Price,index-199,O,L,H,C)
                +0.00002896044112468*PriceSeries(Price,index-200,O,L,H,C)
                +0.00003043935862773*PriceSeries(Price,index-201,O,L,H,C)
                +0.00002301340638260*PriceSeries(Price,index-202,O,L,H,C)
                +0.00000987382770249*PriceSeries(Price,index-203,O,L,H,C)
                -0.00000460121237547*PriceSeries(Price,index-204,O,L,H,C)
                -0.00001615588916167*PriceSeries(Price,index-205,O,L,H,C)
                -0.00002190887441160*PriceSeries(Price,index-206,O,L,H,C)
                -0.00002086105741710*PriceSeries(Price,index-207,O,L,H,C)
                -0.00001395092451455*PriceSeries(Price,index-208,O,L,H,C)
                -0.00000340900247555*PriceSeries(Price,index-209,O,L,H,C)
                +0.00000790335527301*PriceSeries(Price,index-210,O,L,H,C)
                +0.00001721853532153*PriceSeries(Price,index-211,O,L,H,C)
                +0.00002199277788538*PriceSeries(Price,index-212,O,L,H,C)
                +0.00001971807378304*PriceSeries(Price,index-213,O,L,H,C)
                +0.00000711301308858*PriceSeries(Price,index-214,O,L,H,C)
                -0.00002064616658789*PriceSeries(Price,index-215,O,L,H,C)
                -0.0000707035836421*PriceSeries(Price,index-216,O,L,H,C)
                +0.0000521349883245*PriceSeries(Price,index-217,O,L,H,C)
                );

      case N14:
         return(
                0.3093898210822*PriceSeries(Price,index,O,L,H,C)
                +0.2849919653873*PriceSeries(Price,index-1,O,L,H,C)
                +0.2396669696742*PriceSeries(Price,index-2,O,L,H,C)
                +0.1797672276390*PriceSeries(Price,index-3,O,L,H,C)
                +0.1134578010817*PriceSeries(Price,index-4,O,L,H,C)
                +0.0493643625791*PriceSeries(Price,index-5,O,L,H,C)
                -0.00481555442715*PriceSeries(Price,index-6,O,L,H,C)
                -0.0434896206214*PriceSeries(Price,index-7,O,L,H,C)
                -0.0639331190598*PriceSeries(Price,index-8,O,L,H,C)
                -0.0665165834385*PriceSeries(Price,index-9,O,L,H,C)
                -0.0543822450253*PriceSeries(Price,index-10,O,L,H,C)
                -0.0326563191679*PriceSeries(Price,index-11,O,L,H,C)
                -0.00736735321144*PriceSeries(Price,index-12,O,L,H,C)
                +0.01571196279202*PriceSeries(Price,index-13,O,L,H,C)
                +0.0320789980726*PriceSeries(Price,index-14,O,L,H,C)
                +0.0391907582025*PriceSeries(Price,index-15,O,L,H,C)
                +0.0367213374482*PriceSeries(Price,index-16,O,L,H,C)
                +0.02637043778198*PriceSeries(Price,index-17,O,L,H,C)
                +0.01129500242280*PriceSeries(Price,index-18,O,L,H,C)
                -0.00469417199618*PriceSeries(Price,index-19,O,L,H,C)
                -0.01799192524018*PriceSeries(Price,index-20,O,L,H,C)
                -0.02593642145442*PriceSeries(Price,index-21,O,L,H,C)
                -0.02728448257135*PriceSeries(Price,index-22,O,L,H,C)
                -0.02234757205969*PriceSeries(Price,index-23,O,L,H,C)
                -0.01278709752258*PriceSeries(Price,index-24,O,L,H,C)
                -0.001138673113088*PriceSeries(Price,index-25,O,L,H,C)
                +0.00981301879063*PriceSeries(Price,index-26,O,L,H,C)
                +0.01766407701653*PriceSeries(Price,index-27,O,L,H,C)
                +0.02089022380705*PriceSeries(Price,index-28,O,L,H,C)
                +0.01911632173450*PriceSeries(Price,index-29,O,L,H,C)
                +0.01311418419396*PriceSeries(Price,index-30,O,L,H,C)
                +0.00454802879617*PriceSeries(Price,index-31,O,L,H,C)
                -0.00445956502683*PriceSeries(Price,index-32,O,L,H,C)
                -0.01183365113992*PriceSeries(Price,index-33,O,L,H,C)
                -0.01600853882296*PriceSeries(Price,index-34,O,L,H,C)
                -0.01624558932470*PriceSeries(Price,index-35,O,L,H,C)
                -0.01274571925845*PriceSeries(Price,index-36,O,L,H,C)
                -0.00654428788207*PriceSeries(Price,index-37,O,L,H,C)
                +0.000774843738466*PriceSeries(Price,index-38,O,L,H,C)
                +0.00747121307592*PriceSeries(Price,index-39,O,L,H,C)
                +0.01205139570531*PriceSeries(Price,index-40,O,L,H,C)
                +0.01359302635919*PriceSeries(Price,index-41,O,L,H,C)
                +0.01192077656781*PriceSeries(Price,index-42,O,L,H,C)
                +0.00760307052537*PriceSeries(Price,index-43,O,L,H,C)
                +0.001780292774484*PriceSeries(Price,index-44,O,L,H,C)
                -0.00412721481943*PriceSeries(Price,index-45,O,L,H,C)
                -0.00875870828261*PriceSeries(Price,index-46,O,L,H,C)
                -0.01112040341401*PriceSeries(Price,index-47,O,L,H,C)
                -0.01079266282279*PriceSeries(Price,index-48,O,L,H,C)
                -0.00799510701329*PriceSeries(Price,index-49,O,L,H,C)
                -0.00350237376283*PriceSeries(Price,index-50,O,L,H,C)
                +0.001562553215953*PriceSeries(Price,index-51,O,L,H,C)
                +0.00600389446573*PriceSeries(Price,index-52,O,L,H,C)
                +0.00883111063871*PriceSeries(Price,index-53,O,L,H,C)
                +0.00947568226820*PriceSeries(Price,index-54,O,L,H,C)
                +0.00790019692963*PriceSeries(Price,index-55,O,L,H,C)
                +0.00458006613021*PriceSeries(Price,index-56,O,L,H,C)
                +0.000368540421281*PriceSeries(Price,index-57,O,L,H,C)
                -0.00371841978030*PriceSeries(Price,index-58,O,L,H,C)
                -0.00674396043320*PriceSeries(Price,index-59,O,L,H,C)
                -0.00806214529579*PriceSeries(Price,index-60,O,L,H,C)
                -0.00745243949709*PriceSeries(Price,index-61,O,L,H,C)
                -0.00514980368227*PriceSeries(Price,index-62,O,L,H,C)
                -0.001768400965138*PriceSeries(Price,index-63,O,L,H,C)
                +0.001858323271626*PriceSeries(Price,index-64,O,L,H,C)
                +0.00488047633841*PriceSeries(Price,index-65,O,L,H,C)
                +0.00662861329437*PriceSeries(Price,index-66,O,L,H,C)
                +0.00675965144553*PriceSeries(Price,index-67,O,L,H,C)
                +0.00532053333857*PriceSeries(Price,index-68,O,L,H,C)
                +0.002718879531318*PriceSeries(Price,index-69,O,L,H,C)
                -0.000388304896689*PriceSeries(Price,index-70,O,L,H,C)
                -0.00325822297077*PriceSeries(Price,index-71,O,L,H,C)
                -0.00523807667125*PriceSeries(Price,index-72,O,L,H,C)
                -0.00591175671570*PriceSeries(Price,index-73,O,L,H,C)
                -0.00518498233635*PriceSeries(Price,index-74,O,L,H,C)
                -0.00329198850473*PriceSeries(Price,index-75,O,L,H,C)
                -0.000725936106418*PriceSeries(Price,index-76,O,L,H,C)
                +0.001887355939908*PriceSeries(Price,index-77,O,L,H,C)
                +0.00394050442022*PriceSeries(Price,index-78,O,L,H,C)
                +0.00498433309030*PriceSeries(Price,index-79,O,L,H,C)
                +0.00482449233723*PriceSeries(Price,index-80,O,L,H,C)
                +0.00355458521683*PriceSeries(Price,index-81,O,L,H,C)
                +0.001521002901532*PriceSeries(Price,index-82,O,L,H,C)
                -0.000769151474298*PriceSeries(Price,index-83,O,L,H,C)
                -0.002773121575455*PriceSeries(Price,index-84,O,L,H,C)
                -0.00403995966338*PriceSeries(Price,index-85,O,L,H,C)
                -0.00431079587128*PriceSeries(Price,index-86,O,L,H,C)
                -0.00356983360396*PriceSeries(Price,index-87,O,L,H,C)
                -0.002036638243915*PriceSeries(Price,index-88,O,L,H,C)
                -0.0001041211699675*PriceSeries(Price,index-89,O,L,H,C)
                +0.001760746225627*PriceSeries(Price,index-90,O,L,H,C)
                +0.003128762635260*PriceSeries(Price,index-91,O,L,H,C)
                +0.00370631127180*PriceSeries(Price,index-92,O,L,H,C)
                +0.00339710228890*PriceSeries(Price,index-93,O,L,H,C)
                +0.002315157907492*PriceSeries(Price,index-94,O,L,H,C)
                +0.000748386880677*PriceSeries(Price,index-95,O,L,H,C)
                -0.000916557980560*PriceSeries(Price,index-96,O,L,H,C)
                -0.002288728626022*PriceSeries(Price,index-97,O,L,H,C)
                -0.003063912050065*PriceSeries(Price,index-98,O,L,H,C)
                -0.003091080646992*PriceSeries(Price,index-99,O,L,H,C)
                -0.002400159480319*PriceSeries(Price,index-100,O,L,H,C)
                -0.001186338106666*PriceSeries(Price,index-101,O,L,H,C)
                +0.0002432501830756*PriceSeries(Price,index-102,O,L,H,C)
                +0.001546319220512*PriceSeries(Price,index-103,O,L,H,C)
                +0.002426653468500*PriceSeries(Price,index-104,O,L,H,C)
                +0.002700724691249*PriceSeries(Price,index-105,O,L,H,C)
                +0.002334828548849*PriceSeries(Price,index-106,O,L,H,C)
                +0.001445571195861*PriceSeries(Price,index-107,O,L,H,C)
                +0.0002653746872796*PriceSeries(Price,index-108,O,L,H,C)
                -0.000917281038668*PriceSeries(Price,index-109,O,L,H,C)
                -0.001827716712692*PriceSeries(Price,index-110,O,L,H,C)
                -0.002268227377267*PriceSeries(Price,index-111,O,L,H,C)
                -0.002160242426734*PriceSeries(Price,index-112,O,L,H,C)
                -0.001556595827134*PriceSeries(Price,index-113,O,L,H,C)
                -0.000622642084423*PriceSeries(Price,index-114,O,L,H,C)
                +0.000407873587136*PriceSeries(Price,index-115,O,L,H,C)
                +0.001290691600703*PriceSeries(Price,index-116,O,L,H,C)
                +0.001828378679350*PriceSeries(Price,index-117,O,L,H,C)
                +0.001913902253860*PriceSeries(Price,index-118,O,L,H,C)
                +0.001550859664513*PriceSeries(Price,index-119,O,L,H,C)
                +0.000846977154389*PriceSeries(Price,index-120,O,L,H,C)
                -0.00001638599222026*PriceSeries(Price,index-121,O,L,H,C)
                -0.000830273709425*PriceSeries(Price,index-122,O,L,H,C)
                -0.001408218226042*PriceSeries(Price,index-123,O,L,H,C)
                -0.001628476080611*PriceSeries(Price,index-124,O,L,H,C)
                -0.001458968726202*PriceSeries(Price,index-125,O,L,H,C)
                -0.000959977938584*PriceSeries(Price,index-126,O,L,H,C)
                -0.0002652077327132*PriceSeries(Price,index-127,O,L,H,C)
                +0.000453272396155*PriceSeries(Price,index-128,O,L,H,C)
                +0.001027195197633*PriceSeries(Price,index-129,O,L,H,C)
                +0.001331088582907*PriceSeries(Price,index-130,O,L,H,C)
                +0.001309161228217*PriceSeries(Price,index-131,O,L,H,C)
                +0.000984529584625*PriceSeries(Price,index-132,O,L,H,C)
                +0.000449466328042*PriceSeries(Price,index-133,O,L,H,C)
                -0.0001598812655986*PriceSeries(Price,index-134,O,L,H,C)
                -0.000697666247303*PriceSeries(Price,index-135,O,L,H,C)
                -0.001042901011352*PriceSeries(Price,index-136,O,L,H,C)
                -0.001126225155322*PriceSeries(Price,index-137,O,L,H,C)
                -0.000943219141231*PriceSeries(Price,index-138,O,L,H,C)
                -0.000551731059930*PriceSeries(Price,index-139,O,L,H,C)
                -0.0000548567529728*PriceSeries(Price,index-140,O,L,H,C)
                +0.000425720475235*PriceSeries(Price,index-141,O,L,H,C)
                +0.000779162156875*PriceSeries(Price,index-142,O,L,H,C)
                +0.000930694469449*PriceSeries(Price,index-143,O,L,H,C)
                +0.000856998329752*PriceSeries(Price,index-144,O,L,H,C)
                +0.000588607464730*PriceSeries(Price,index-145,O,L,H,C)
                +0.0001996163177576*PriceSeries(Price,index-146,O,L,H,C)
                -0.0002122012688728*PriceSeries(Price,index-147,O,L,H,C)
                -0.000549607746660*PriceSeries(Price,index-148,O,L,H,C)
                -0.000738611681496*PriceSeries(Price,index-149,O,L,H,C)
                -0.000744282390294*PriceSeries(Price,index-150,O,L,H,C)
                -0.000576591034573*PriceSeries(Price,index-151,O,L,H,C)
                -0.0002853425380971*PriceSeries(Price,index-152,O,L,H,C)
                +0.0000539334960400*PriceSeries(Price,index-153,O,L,H,C)
                +0.000359211464902*PriceSeries(Price,index-154,O,L,H,C)
                +0.000561507925622*PriceSeries(Price,index-155,O,L,H,C)
                +0.000620265036626*PriceSeries(Price,index-156,O,L,H,C)
                +0.000530946780169*PriceSeries(Price,index-157,O,L,H,C)
                +0.000323948510019*PriceSeries(Price,index-158,O,L,H,C)
                +0.0000551159388307*PriceSeries(Price,index-159,O,L,H,C)
                -0.0002088418808769*PriceSeries(Price,index-160,O,L,H,C)
                -0.000406725822810*PriceSeries(Price,index-161,O,L,H,C)
                -0.000496738558686*PriceSeries(Price,index-162,O,L,H,C)
                -0.000465083899086*PriceSeries(Price,index-163,O,L,H,C)
                -0.000327299914867*PriceSeries(Price,index-164,O,L,H,C)
                -0.0001226986035738*PriceSeries(Price,index-165,O,L,H,C)
                +0.0000964452405303*PriceSeries(Price,index-166,O,L,H,C)
                +0.0002779666888041*PriceSeries(Price,index-167,O,L,H,C)
                +0.000382111743900*PriceSeries(Price,index-168,O,L,H,C)
                +0.000389942121332*PriceSeries(Price,index-169,O,L,H,C)
                +0.0003063513261723*PriceSeries(Price,index-170,O,L,H,C)
                +0.0001572886163909*PriceSeries(Price,index-171,O,L,H,C)
                -0.00001774424918786*PriceSeries(Price,index-172,O,L,H,C)
                -0.0001760188898287*PriceSeries(Price,index-173,O,L,H,C)
                -0.0002817162251430*PriceSeries(Price,index-174,O,L,H,C)
                -0.0003139489789774*PriceSeries(Price,index-175,O,L,H,C)
                -0.0002705772577546*PriceSeries(Price,index-176,O,L,H,C)
                -0.0001672726278013*PriceSeries(Price,index-177,O,L,H,C)
                -0.0000326736323560*PriceSeries(Price,index-178,O,L,H,C)
                +0.0000993952622057*PriceSeries(Price,index-179,O,L,H,C)
                +0.0001981797527410*PriceSeries(Price,index-180,O,L,H,C)
                +0.0002430751124698*PriceSeries(Price,index-181,O,L,H,C)
                +0.0002277080877413*PriceSeries(Price,index-182,O,L,H,C)
                +0.0001603094653366*PriceSeries(Price,index-183,O,L,H,C)
                +0.0000607144131360*PriceSeries(Price,index-184,O,L,H,C)
                -0.0000452068677873*PriceSeries(Price,index-185,O,L,H,C)
                -0.0001320593862549*PriceSeries(Price,index-186,O,L,H,C)
                -0.0001809943460727*PriceSeries(Price,index-187,O,L,H,C)
                -0.0001835679261503*PriceSeries(Price,index-188,O,L,H,C)
                -0.0001429203236376*PriceSeries(Price,index-189,O,L,H,C)
                -0.0000721085778310*PriceSeries(Price,index-190,O,L,H,C)
                +0.00000966491394268*PriceSeries(Price,index-191,O,L,H,C)
                +0.0000822709004950*PriceSeries(Price,index-192,O,L,H,C)
                +0.0001294214353967*PriceSeries(Price,index-193,O,L,H,C)
                +0.0001421373659789*PriceSeries(Price,index-194,O,L,H,C)
                +0.0001203603724775*PriceSeries(Price,index-195,O,L,H,C)
                +0.0000722550777274*PriceSeries(Price,index-196,O,L,H,C)
                +0.00001131296639721*PriceSeries(Price,index-197,O,L,H,C)
                -0.0000468399648640*PriceSeries(Price,index-198,O,L,H,C)
                -0.0000888083501153*PriceSeries(Price,index-199,O,L,H,C)
                -0.0001060086810845*PriceSeries(Price,index-200,O,L,H,C)
                -0.0000966359381087*PriceSeries(Price,index-201,O,L,H,C)
                -0.0000653087497315*PriceSeries(Price,index-202,O,L,H,C)
                -0.00002151621135193*PriceSeries(Price,index-203,O,L,H,C)
                +0.00002322704427888*PriceSeries(Price,index-204,O,L,H,C)
                +0.0000582365765863*PriceSeries(Price,index-205,O,L,H,C)
                +0.0000761510234626*PriceSeries(Price,index-206,O,L,H,C)
                +0.0000742744809828*PriceSeries(Price,index-207,O,L,H,C)
                +0.0000549234558545*PriceSeries(Price,index-208,O,L,H,C)
                +0.00002442460051143*PriceSeries(Price,index-209,O,L,H,C)
                -0.00000876253080154*PriceSeries(Price,index-210,O,L,H,C)
                -0.0000365140948979*PriceSeries(Price,index-211,O,L,H,C)
                -0.0000528267989377*PriceSeries(Price,index-212,O,L,H,C)
                -0.0000548911806665*PriceSeries(Price,index-213,O,L,H,C)
                -0.0000435258525444*PriceSeries(Price,index-214,O,L,H,C)
                -0.00002304808428883*PriceSeries(Price,index-215,O,L,H,C)
                +0.000000677434862725*PriceSeries(Price,index-216,O,L,H,C)
                +0.00002192402421381*PriceSeries(Price,index-217,O,L,H,C)
                +0.0000353937522469*PriceSeries(Price,index-218,O,L,H,C)
                +0.0000390771594715*PriceSeries(Price,index-219,O,L,H,C)
                +0.0000329051532291*PriceSeries(Price,index-220,O,L,H,C)
                +0.00001953726123796*PriceSeries(Price,index-221,O,L,H,C)
                +0.000002943574724109*PriceSeries(Price,index-222,O,L,H,C)
                -0.00001255259442252*PriceSeries(Price,index-223,O,L,H,C)
                -0.00002335734680117*PriceSeries(Price,index-224,O,L,H,C)
                -0.00002744533546850*PriceSeries(Price,index-225,O,L,H,C)
                -0.00002457539711285*PriceSeries(Price,index-226,O,L,H,C)
                -0.00001619694111032*PriceSeries(Price,index-227,O,L,H,C)
                -0.00000479504136469*PriceSeries(Price,index-228,O,L,H,C)
                +0.00000675683974227*PriceSeries(Price,index-229,O,L,H,C)
                +0.00001597620664729*PriceSeries(Price,index-230,O,L,H,C)
                +0.00002112506800489*PriceSeries(Price,index-231,O,L,H,C)
                +0.00002138774008472*PriceSeries(Price,index-232,O,L,H,C)
                +0.00001651242813454*PriceSeries(Price,index-233,O,L,H,C)
                +0.00000637373086603*PriceSeries(Price,index-234,O,L,H,C)
                -0.00000973510113299*PriceSeries(Price,index-235,O,L,H,C)
                -0.0000335266440205*PriceSeries(Price,index-236,O,L,H,C)
                -0.0000680608116329*PriceSeries(Price,index-237,O,L,H,C)
                +0.0000672929215383*PriceSeries(Price,index-238,O,L,H,C)
                );

      case N15:
         return(
                0.2858376350808*PriceSeries(Price,index,O,L,H,C)
                +0.2665972188141*PriceSeries(Price,index-1,O,L,H,C)
                +0.2304527021350*PriceSeries(Price,index-2,O,L,H,C)
                +0.1817382495382*PriceSeries(Price,index-3,O,L,H,C)
                +0.1261624631079*PriceSeries(Price,index-4,O,L,H,C)
                +0.0699980885341*PriceSeries(Price,index-5,O,L,H,C)
                +0.01921127938706*PriceSeries(Price,index-6,O,L,H,C)
                -0.02133579803880*PriceSeries(Price,index-7,O,L,H,C)
                -0.0484895957500*PriceSeries(Price,index-8,O,L,H,C)
                -0.0611312197893*PriceSeries(Price,index-9,O,L,H,C)
                -0.0601847756882*PriceSeries(Price,index-10,O,L,H,C)
                -0.0483208304868*PriceSeries(Price,index-11,O,L,H,C)
                -0.02941597728174*PriceSeries(Price,index-12,O,L,H,C)
                -0.00786616459302*PriceSeries(Price,index-13,O,L,H,C)
                +0.01212948412054*PriceSeries(Price,index-14,O,L,H,C)
                +0.02719840878904*PriceSeries(Price,index-15,O,L,H,C)
                +0.0352421863578*PriceSeries(Price,index-16,O,L,H,C)
                +0.0356413650031*PriceSeries(Price,index-17,O,L,H,C)
                +0.02920075025219*PriceSeries(Price,index-18,O,L,H,C)
                +0.01786271839621*PriceSeries(Price,index-19,O,L,H,C)
                +0.00425357669702*PriceSeries(Price,index-20,O,L,H,C)
                -0.00884767796853*PriceSeries(Price,index-21,O,L,H,C)
                -0.01902120076395*PriceSeries(Price,index-22,O,L,H,C)
                -0.02461141417811*PriceSeries(Price,index-23,O,L,H,C)
                -0.02496227055764*PriceSeries(Price,index-24,O,L,H,C)
                -0.02045362246126*PriceSeries(Price,index-25,O,L,H,C)
                -0.01234670165642*PriceSeries(Price,index-26,O,L,H,C)
                -0.002480318199511*PriceSeries(Price,index-27,O,L,H,C)
                +0.00711653177793*PriceSeries(Price,index-28,O,L,H,C)
                +0.01461904358495*PriceSeries(Price,index-29,O,L,H,C)
                +0.01873504624574*PriceSeries(Price,index-30,O,L,H,C)
                +0.01891116946952*PriceSeries(Price,index-31,O,L,H,C)
                +0.01538656397112*PriceSeries(Price,index-32,O,L,H,C)
                +0.00909388920213*PriceSeries(Price,index-33,O,L,H,C)
                +0.001435861035080*PriceSeries(Price,index-34,O,L,H,C)
                -0.00601302383473*PriceSeries(Price,index-35,O,L,H,C)
                -0.01181869928128*PriceSeries(Price,index-36,O,L,H,C)
                -0.01495387181255*PriceSeries(Price,index-37,O,L,H,C)
                -0.01497063900728*PriceSeries(Price,index-38,O,L,H,C)
                -0.01205207676734*PriceSeries(Price,index-39,O,L,H,C)
                -0.00693982403089*PriceSeries(Price,index-40,O,L,H,C)
                -0.000758586026220*PriceSeries(Price,index-41,O,L,H,C)
                +0.00522321800693*PriceSeries(Price,index-42,O,L,H,C)
                +0.00984714225522*PriceSeries(Price,index-43,O,L,H,C)
                +0.01228330595417*PriceSeries(Price,index-44,O,L,H,C)
                +0.01217362068476*PriceSeries(Price,index-45,O,L,H,C)
                +0.00967606686580*PriceSeries(Price,index-46,O,L,H,C)
                +0.00540659092879*PriceSeries(Price,index-47,O,L,H,C)
                +0.0002951813569588*PriceSeries(Price,index-48,O,L,H,C)
                -0.00461167595649*PriceSeries(Price,index-49,O,L,H,C)
                -0.00836111062473*PriceSeries(Price,index-50,O,L,H,C)
                -0.01027521234158*PriceSeries(Price,index-51,O,L,H,C)
                -0.01006970417708*PriceSeries(Price,index-52,O,L,H,C)
                -0.00789002999573*PriceSeries(Price,index-53,O,L,H,C)
                -0.00426175876156*PriceSeries(Price,index-54,O,L,H,C)
                +0.00003082957153432*PriceSeries(Price,index-55,O,L,H,C)
                +0.00411091801461*PriceSeries(Price,index-56,O,L,H,C)
                +0.00718547078324*PriceSeries(Price,index-57,O,L,H,C)
                +0.00869683667389*PriceSeries(Price,index-58,O,L,H,C)
                +0.00842105667701*PriceSeries(Price,index-59,O,L,H,C)
                +0.00649623775477*PriceSeries(Price,index-60,O,L,H,C)
                +0.00337853100305*PriceSeries(Price,index-61,O,L,H,C)
                -0.0002622074560291*PriceSeries(Price,index-62,O,L,H,C)
                -0.00368399256586*PriceSeries(Price,index-63,O,L,H,C)
                -0.00622193846698*PriceSeries(Price,index-64,O,L,H,C)
                -0.00741561346261*PriceSeries(Price,index-65,O,L,H,C)
                -0.00709040714542*PriceSeries(Price,index-66,O,L,H,C)
                -0.00537905497416*PriceSeries(Price,index-67,O,L,H,C)
                -0.002681668966802*PriceSeries(Price,index-68,O,L,H,C)
                +0.000425032648703*PriceSeries(Price,index-69,O,L,H,C)
                +0.00330930934394*PriceSeries(Price,index-70,O,L,H,C)
                +0.00541138080231*PriceSeries(Price,index-71,O,L,H,C)
                +0.00635067829299*PriceSeries(Price,index-72,O,L,H,C)
                +0.00599301475787*PriceSeries(Price,index-73,O,L,H,C)
                +0.00446623771571*PriceSeries(Price,index-74,O,L,H,C)
                +0.002123488389968*PriceSeries(Price,index-75,O,L,H,C)
                -0.000536373998997*PriceSeries(Price,index-76,O,L,H,C)
                -0.002973671597856*PriceSeries(Price,index-77,O,L,H,C)
                -0.00471627929969*PriceSeries(Price,index-78,O,L,H,C)
                -0.00544998480709*PriceSeries(Price,index-79,O,L,H,C)
                -0.00507369156039*PriceSeries(Price,index-80,O,L,H,C)
                -0.00371017469919*PriceSeries(Price,index-81,O,L,H,C)
                -0.001672081959737*PriceSeries(Price,index-82,O,L,H,C)
                +0.000608102037117*PriceSeries(Price,index-83,O,L,H,C)
                +0.002668786454931*PriceSeries(Price,index-84,O,L,H,C)
                +0.00411182318902*PriceSeries(Price,index-85,O,L,H,C)
                +0.00467854558222*PriceSeries(Price,index-86,O,L,H,C)
                +0.00429488254827*PriceSeries(Price,index-87,O,L,H,C)
                +0.003078066593077*PriceSeries(Price,index-88,O,L,H,C)
                +0.001305116325047*PriceSeries(Price,index-89,O,L,H,C)
                -0.000648884719607*PriceSeries(Price,index-90,O,L,H,C)
                -0.002389317686405*PriceSeries(Price,index-91,O,L,H,C)
                -0.00358098263701*PriceSeries(Price,index-92,O,L,H,C)
                -0.00401191932020*PriceSeries(Price,index-93,O,L,H,C)
                -0.00363001908823*PriceSeries(Price,index-94,O,L,H,C)
                -0.002546406960775*PriceSeries(Price,index-95,O,L,H,C)
                -0.001006310460820*PriceSeries(Price,index-96,O,L,H,C)
                +0.000665340331058*PriceSeries(Price,index-97,O,L,H,C)
                +0.002131795423905*PriceSeries(Price,index-98,O,L,H,C)
                +0.003111705663745*PriceSeries(Price,index-99,O,L,H,C)
                +0.00343246632982*PriceSeries(Price,index-100,O,L,H,C)
                +0.003059650954671*PriceSeries(Price,index-101,O,L,H,C)
                +0.002097753691876*PriceSeries(Price,index-102,O,L,H,C)
                +0.000763368578236*PriceSeries(Price,index-103,O,L,H,C)
                -0.000662697737157*PriceSeries(Price,index-104,O,L,H,C)
                -0.001893938909014*PriceSeries(Price,index-105,O,L,H,C)
                -0.002695202434209*PriceSeries(Price,index-106,O,L,H,C)
                -0.002927037620894*PriceSeries(Price,index-107,O,L,H,C)
                -0.002569073417620*PriceSeries(Price,index-108,O,L,H,C)
                -0.001718753075140*PriceSeries(Price,index-109,O,L,H,C)
                -0.000566715806102*PriceSeries(Price,index-110,O,L,H,C)
                +0.000645200019213*PriceSeries(Price,index-111,O,L,H,C)
                +0.001674224576877*PriceSeries(Price,index-112,O,L,H,C)
                +0.002324857482096*PriceSeries(Price,index-113,O,L,H,C)
                +0.002485512630327*PriceSeries(Price,index-114,O,L,H,C)
                +0.002146821387740*PriceSeries(Price,index-115,O,L,H,C)
                +0.001398853099579*PriceSeries(Price,index-116,O,L,H,C)
                +0.000408657392351*PriceSeries(Price,index-117,O,L,H,C)
                -0.000616393509729*PriceSeries(Price,index-118,O,L,H,C)
                -0.001471626013594*PriceSeries(Price,index-119,O,L,H,C)
                -0.001995545951605*PriceSeries(Price,index-120,O,L,H,C)
                -0.002099888713035*PriceSeries(Price,index-121,O,L,H,C)
                -0.001783717541787*PriceSeries(Price,index-122,O,L,H,C)
                -0.001129515987249*PriceSeries(Price,index-123,O,L,H,C)
                -0.0002829053490617*PriceSeries(Price,index-124,O,L,H,C)
                +0.000579238324453*PriceSeries(Price,index-125,O,L,H,C)
                +0.001285386348749*PriceSeries(Price,index-126,O,L,H,C)
                +0.001703139120879*PriceSeries(Price,index-127,O,L,H,C)
                +0.001763635574789*PriceSeries(Price,index-128,O,L,H,C)
                +0.001472195575103*PriceSeries(Price,index-129,O,L,H,C)
                +0.000903658140336*PriceSeries(Price,index-130,O,L,H,C)
                +0.0001841998462332*PriceSeries(Price,index-131,O,L,H,C)
                -0.000536252053802*PriceSeries(Price,index-132,O,L,H,C)
                -0.001114922558974*PriceSeries(Price,index-133,O,L,H,C)
                -0.001444202877172*PriceSeries(Price,index-134,O,L,H,C)
                -0.001471267935711*PriceSeries(Price,index-135,O,L,H,C)
                -0.001205871344538*PriceSeries(Price,index-136,O,L,H,C)
                -0.000715285687583*PriceSeries(Price,index-137,O,L,H,C)
                -0.0001080711699125*PriceSeries(Price,index-138,O,L,H,C)
                +0.000489569581498*PriceSeries(Price,index-139,O,L,H,C)
                +0.000959719499118*PriceSeries(Price,index-140,O,L,H,C)
                +0.001215784039596*PriceSeries(Price,index-141,O,L,H,C)
                +0.001218070666575*PriceSeries(Price,index-142,O,L,H,C)
                +0.000979267949982*PriceSeries(Price,index-143,O,L,H,C)
                +0.000559243491274*PriceSeries(Price,index-144,O,L,H,C)
                +0.0000506873160477*PriceSeries(Price,index-145,O,L,H,C)
                -0.000440990291573*PriceSeries(Price,index-146,O,L,H,C)
                -0.000819274054755*PriceSeries(Price,index-147,O,L,H,C)
                -0.001015265284905*PriceSeries(Price,index-148,O,L,H,C)
                -0.000999890533564*PriceSeries(Price,index-149,O,L,H,C)
                -0.000787575433885*PriceSeries(Price,index-150,O,L,H,C)
                -0.000431029608035*PriceSeries(Price,index-151,O,L,H,C)
                -0.00000874841536136*PriceSeries(Price,index-152,O,L,H,C)
                +0.000392016486173*PriceSeries(Price,index-153,O,L,H,C)
                +0.000693056018551*PriceSeries(Price,index-154,O,L,H,C)
                +0.000840257398585*PriceSeries(Price,index-155,O,L,H,C)
                +0.000813018913952*PriceSeries(Price,index-156,O,L,H,C)
                +0.000626538393919*PriceSeries(Price,index-157,O,L,H,C)
                +0.000326718145910*PriceSeries(Price,index-158,O,L,H,C)
                -0.00002059122406912*PriceSeries(Price,index-159,O,L,H,C)
                -0.000343890438604*PriceSeries(Price,index-160,O,L,H,C)
                -0.000580492381634*PriceSeries(Price,index-161,O,L,H,C)
                -0.000688539073820*PriceSeries(Price,index-162,O,L,H,C)
                -0.000654092842680*PriceSeries(Price,index-163,O,L,H,C)
                -0.000492336618991*PriceSeries(Price,index-164,O,L,H,C)
                -0.0002428136535891*PriceSeries(Price,index-165,O,L,H,C)
                +0.0000398276741621*PriceSeries(Price,index-166,O,L,H,C)
                +0.0002976175416498*PriceSeries(Price,index-167,O,L,H,C)
                +0.000480949353698*PriceSeries(Price,index-168,O,L,H,C)
                +0.000558019897905*PriceSeries(Price,index-169,O,L,H,C)
                +0.000520021021049*PriceSeries(Price,index-170,O,L,H,C)
                +0.000381532199976*PriceSeries(Price,index-171,O,L,H,C)
                +0.0001762157714846*PriceSeries(Price,index-172,O,L,H,C)
                -0.0000510912573347*PriceSeries(Price,index-173,O,L,H,C)
                -0.0002539620706079*PriceSeries(Price,index-174,O,L,H,C)
                -0.000393726402131*PriceSeries(Price,index-175,O,L,H,C)
                -0.000446699019517*PriceSeries(Price,index-176,O,L,H,C)
                -0.000407912926343*PriceSeries(Price,index-177,O,L,H,C)
                -0.0002909767829231*PriceSeries(Price,index-178,O,L,H,C)
                -0.0001241366588706*PriceSeries(Price,index-179,O,L,H,C)
                +0.0000562476623248*PriceSeries(Price,index-180,O,L,H,C)
                +0.0002135408220459*PriceSeries(Price,index-181,O,L,H,C)
                +0.000318083719068*PriceSeries(Price,index-182,O,L,H,C)
                +0.000352671950117*PriceSeries(Price,index-183,O,L,H,C)
                +0.0003151466338628*PriceSeries(Price,index-184,O,L,H,C)
                +0.0002178855222108*PriceSeries(Price,index-185,O,L,H,C)
                +0.0000842167109749*PriceSeries(Price,index-186,O,L,H,C)
                -0.0000567847041069*PriceSeries(Price,index-187,O,L,H,C)
                -0.0001766718400091*PriceSeries(Price,index-188,O,L,H,C)
                -0.0002531143198758*PriceSeries(Price,index-189,O,L,H,C)
                -0.0002740371124817*PriceSeries(Price,index-190,O,L,H,C)
                -0.0002392303085085*PriceSeries(Price,index-191,O,L,H,C)
                -0.0001596162520250*PriceSeries(Price,index-192,O,L,H,C)
                -0.0000542203434225*PriceSeries(Price,index-193,O,L,H,C)
                +0.0000541315252436*PriceSeries(Price,index-194,O,L,H,C)
                +0.0001437099304902*PriceSeries(Price,index-195,O,L,H,C)
                +0.0001981071491545*PriceSeries(Price,index-196,O,L,H,C)
                +0.0002092020042974*PriceSeries(Price,index-197,O,L,H,C)
                +0.0001780399691266*PriceSeries(Price,index-198,O,L,H,C)
                +0.0001140209876364*PriceSeries(Price,index-199,O,L,H,C)
                +0.0000324456577229*PriceSeries(Price,index-200,O,L,H,C)
                -0.0000491521909369*PriceSeries(Price,index-201,O,L,H,C)
                -0.0001145239354157*PriceSeries(Price,index-202,O,L,H,C)
                -0.0001519530055723*PriceSeries(Price,index-203,O,L,H,C)
                -0.0001562374481449*PriceSeries(Price,index-204,O,L,H,C)
                -0.0001291842068664*PriceSeries(Price,index-205,O,L,H,C)
                -0.0000787507095116*PriceSeries(Price,index-206,O,L,H,C)
                -0.00001687766750965*PriceSeries(Price,index-207,O,L,H,C)
                +0.0000431578744276*PriceSeries(Price,index-208,O,L,H,C)
                +0.0000895740942352*PriceSeries(Price,index-209,O,L,H,C)
                +0.0001142374702629*PriceSeries(Price,index-210,O,L,H,C)
                +0.0001140940283850*PriceSeries(Price,index-211,O,L,H,C)
                +0.0000913540570981*PriceSeries(Price,index-212,O,L,H,C)
                +0.0000526019787862*PriceSeries(Price,index-213,O,L,H,C)
                +0.00000683698835617*PriceSeries(Price,index-214,O,L,H,C)
                -0.0000360038970010*PriceSeries(Price,index-215,O,L,H,C)
                -0.0000677383927727*PriceSeries(Price,index-216,O,L,H,C)
                -0.0000829765166268*PriceSeries(Price,index-217,O,L,H,C)
                -0.0000802266729462*PriceSeries(Price,index-218,O,L,H,C)
                -0.0000617006702457*PriceSeries(Price,index-219,O,L,H,C)
                -0.0000326210578661*PriceSeries(Price,index-220,O,L,H,C)
                +0.000000197603662409*PriceSeries(Price,index-221,O,L,H,C)
                +0.00002981095906130*PriceSeries(Price,index-222,O,L,H,C)
                +0.0000506520329063*PriceSeries(Price,index-223,O,L,H,C)
                +0.0000594361065048*PriceSeries(Price,index-224,O,L,H,C)
                +0.0000556378438222*PriceSeries(Price,index-225,O,L,H,C)
                +0.0000412089057798*PriceSeries(Price,index-226,O,L,H,C)
                +0.00002018043350341*PriceSeries(Price,index-227,O,L,H,C)
                -0.000002104182315365*PriceSeries(Price,index-228,O,L,H,C)
                -0.00002163899140618*PriceSeries(Price,index-229,O,L,H,C)
                -0.0000344334098632*PriceSeries(Price,index-230,O,L,H,C)
                -0.0000388233395509*PriceSeries(Price,index-231,O,L,H,C)
                -0.0000348755252597*PriceSeries(Price,index-232,O,L,H,C)
                -0.00002430747311690*PriceSeries(Price,index-233,O,L,H,C)
                -0.00000996151895352*PriceSeries(Price,index-234,O,L,H,C)
                +0.00000503063932615*PriceSeries(Price,index-235,O,L,H,C)
                +0.00001790063220199*PriceSeries(Price,index-236,O,L,H,C)
                +0.00002691939645065*PriceSeries(Price,index-237,O,L,H,C)
                +0.00003161891248290*PriceSeries(Price,index-238,O,L,H,C)
                +0.0000328762173459*PriceSeries(Price,index-239,O,L,H,C)
                +0.0000325317248451*PriceSeries(Price,index-240,O,L,H,C)
                +0.0000329875464322*PriceSeries(Price,index-241,O,L,H,C)
                -0.0001003420306167*PriceSeries(Price,index-242,O,L,H,C)
                );

      case
         N16: return(
                     0.2655285095039*PriceSeries(Price,index,O,L,H,C)
                     +0.2500999876213*PriceSeries(Price,index-1,O,L,H,C)
                     +0.2208601059617*PriceSeries(Price,index-2,O,L,H,C)
                     +0.1808409540744*PriceSeries(Price,index-3,O,L,H,C)
                     +0.1341126902254*PriceSeries(Price,index-4,O,L,H,C)
                     +0.0852832774361*PriceSeries(Price,index-5,O,L,H,C)
                     +0.0389423067404*PriceSeries(Price,index-6,O,L,H,C)
                     -0.000876954480921*PriceSeries(Price,index-7,O,L,H,C)
                     -0.03114694870656*PriceSeries(Price,index-8,O,L,H,C)
                     -0.0501500450519*PriceSeries(Price,index-9,O,L,H,C)
                     -0.0576022462150*PriceSeries(Price,index-10,O,L,H,C)
                     -0.0545868473975*PriceSeries(Price,index-11,O,L,H,C)
                     -0.0433151083689*PriceSeries(Price,index-12,O,L,H,C)
                     -0.02675413499745*PriceSeries(Price,index-13,O,L,H,C)
                     -0.00817917858182*PriceSeries(Price,index-14,O,L,H,C)
                     +0.00928445204951*PriceSeries(Price,index-15,O,L,H,C)
                     +0.02306604817210*PriceSeries(Price,index-16,O,L,H,C)
                     +0.03144765975944*PriceSeries(Price,index-17,O,L,H,C)
                     +0.0337204206422*PriceSeries(Price,index-18,O,L,H,C)
                     +0.03018594011132*PriceSeries(Price,index-19,O,L,H,C)
                     +0.02201280206302*PriceSeries(Price,index-20,O,L,H,C)
                     +0.01097861252126*PriceSeries(Price,index-21,O,L,H,C)
                     -0.000856783084047*PriceSeries(Price,index-22,O,L,H,C)
                     -0.01149388773665*PriceSeries(Price,index-23,O,L,H,C)
                     -0.01929966672454*PriceSeries(Price,index-24,O,L,H,C)
                     -0.02323358873944*PriceSeries(Price,index-25,O,L,H,C)
                     -0.02296464765772*PriceSeries(Price,index-26,O,L,H,C)
                     -0.01886892968762*PriceSeries(Price,index-27,O,L,H,C)
                     -0.01191613320642*PriceSeries(Price,index-28,O,L,H,C)
                     -0.00347019997345*PriceSeries(Price,index-29,O,L,H,C)
                     +0.00495903056111*PriceSeries(Price,index-30,O,L,H,C)
                     +0.01197067883869*PriceSeries(Price,index-31,O,L,H,C)
                     +0.01649332160751*PriceSeries(Price,index-32,O,L,H,C)
                     +0.01793801772457*PriceSeries(Price,index-33,O,L,H,C)
                     +0.01626351790265*PriceSeries(Price,index-34,O,L,H,C)
                     +0.01194829971088*PriceSeries(Price,index-35,O,L,H,C)
                     +0.00587964441079*PriceSeries(Price,index-36,O,L,H,C)
                     -0.000817616505254*PriceSeries(Price,index-37,O,L,H,C)
                     -0.00698118341669*PriceSeries(Price,index-38,O,L,H,C)
                     -0.01160606752108*PriceSeries(Price,index-39,O,L,H,C)
                     -0.01400232266585*PriceSeries(Price,index-40,O,L,H,C)
                     -0.01389203275554*PriceSeries(Price,index-41,O,L,H,C)
                     -0.01143273028980*PriceSeries(Price,index-42,O,L,H,C)
                     -0.00716738641983*PriceSeries(Price,index-43,O,L,H,C)
                     -0.001913023012966*PriceSeries(Price,index-44,O,L,H,C)
                     +0.00339039682901*PriceSeries(Price,index-45,O,L,H,C)
                     +0.00784378443001*PriceSeries(Price,index-46,O,L,H,C)
                     +0.01073750291973*PriceSeries(Price,index-47,O,L,H,C)
                     +0.01166086280271*PriceSeries(Price,index-48,O,L,H,C)
                     +0.01055611721742*PriceSeries(Price,index-49,O,L,H,C)
                     +0.00771071414203*PriceSeries(Price,index-50,O,L,H,C)
                     +0.00369202095495*PriceSeries(Price,index-51,O,L,H,C)
                     -0.000761745081615*PriceSeries(Price,index-52,O,L,H,C)
                     -0.00487416203731*PriceSeries(Price,index-53,O,L,H,C)
                     -0.00796336098491*PriceSeries(Price,index-54,O,L,H,C)
                     -0.00955272830898*PriceSeries(Price,index-55,O,L,H,C)
                     -0.00944186635938*PriceSeries(Price,index-56,O,L,H,C)
                     -0.00772777852073*PriceSeries(Price,index-57,O,L,H,C)
                     -0.00477489574715*PriceSeries(Price,index-58,O,L,H,C)
                     -0.001141285860305*PriceSeries(Price,index-59,O,L,H,C)
                     +0.002524515509154*PriceSeries(Price,index-60,O,L,H,C)
                     +0.00559741243051*PriceSeries(Price,index-61,O,L,H,C)
                     +0.00758067550471*PriceSeries(Price,index-62,O,L,H,C)
                     +0.00818453871083*PriceSeries(Price,index-63,O,L,H,C)
                     +0.00736633860656*PriceSeries(Price,index-64,O,L,H,C)
                     +0.00532703871203*PriceSeries(Price,index-65,O,L,H,C)
                     +0.002466626843223*PriceSeries(Price,index-66,O,L,H,C)
                     -0.000692392574388*PriceSeries(Price,index-67,O,L,H,C)
                     -0.00359897038474*PriceSeries(Price,index-68,O,L,H,C)
                     -0.00576842034843*PriceSeries(Price,index-69,O,L,H,C)
                     -0.00686202691982*PriceSeries(Price,index-70,O,L,H,C)
                     -0.00673854617873*PriceSeries(Price,index-71,O,L,H,C)
                     -0.00546995792898*PriceSeries(Price,index-72,O,L,H,C)
                     -0.00332036339245*PriceSeries(Price,index-73,O,L,H,C)
                     -0.000693012195816*PriceSeries(Price,index-74,O,L,H,C)
                     +0.001944092651207*PriceSeries(Price,index-75,O,L,H,C)
                     +0.00414059847603*PriceSeries(Price,index-76,O,L,H,C)
                     +0.00553980807516*PriceSeries(Price,index-77,O,L,H,C)
                     +0.00593564050918*PriceSeries(Price,index-78,O,L,H,C)
                     +0.00530158056782*PriceSeries(Price,index-79,O,L,H,C)
                     +0.00378791367918*PriceSeries(Price,index-80,O,L,H,C)
                     +0.001688867169164*PriceSeries(Price,index-81,O,L,H,C)
                     -0.000613365115557*PriceSeries(Price,index-82,O,L,H,C)
                     -0.002717455172221*PriceSeries(Price,index-83,O,L,H,C)
                     -0.00427211941705*PriceSeries(Price,index-84,O,L,H,C)
                     -0.00503410392652*PriceSeries(Price,index-85,O,L,H,C)
                     -0.00490530865206*PriceSeries(Price,index-86,O,L,H,C)
                     -0.00394371545723*PriceSeries(Price,index-87,O,L,H,C)
                     -0.002347164981876*PriceSeries(Price,index-88,O,L,H,C)
                     -0.000413987730914*PriceSeries(Price,index-89,O,L,H,C)
                     +0.001512006866874*PriceSeries(Price,index-90,O,L,H,C)
                     +0.003102074987695*PriceSeries(Price,index-91,O,L,H,C)
                     +0.00409809619614*PriceSeries(Price,index-92,O,L,H,C)
                     +0.00435381803426*PriceSeries(Price,index-93,O,L,H,C)
                     +0.00385538270211*PriceSeries(Price,index-94,O,L,H,C)
                     +0.002718340265533*PriceSeries(Price,index-95,O,L,H,C)
                     +0.001162717294235*PriceSeries(Price,index-96,O,L,H,C)
                     -0.000528786204368*PriceSeries(Price,index-97,O,L,H,C)
                     -0.002061636952160*PriceSeries(Price,index-98,O,L,H,C)
                     -0.00318030998187*PriceSeries(Price,index-99,O,L,H,C)
                     -0.00371037302759*PriceSeries(Price,index-100,O,L,H,C)
                     -0.00358507711045*PriceSeries(Price,index-101,O,L,H,C)
                     -0.002852384504797*PriceSeries(Price,index-102,O,L,H,C)
                     -0.001662144315326*PriceSeries(Price,index-103,O,L,H,C)
                     -0.0002363595518518*PriceSeries(Price,index-104,O,L,H,C)
                     +0.001171731604578*PriceSeries(Price,index-105,O,L,H,C)
                     +0.002322204046778*PriceSeries(Price,index-106,O,L,H,C)
                     +0.003028977871927*PriceSeries(Price,index-107,O,L,H,C)
                     +0.00318940591843*PriceSeries(Price,index-108,O,L,H,C)
                     +0.002798462434295*PriceSeries(Price,index-109,O,L,H,C)
                     +0.001945602436912*PriceSeries(Price,index-110,O,L,H,C)
                     +0.000795582610624*PriceSeries(Price,index-111,O,L,H,C)
                     -0.000442818336090*PriceSeries(Price,index-112,O,L,H,C)
                     -0.001554317535446*PriceSeries(Price,index-113,O,L,H,C)
                     -0.002354230316281*PriceSeries(Price,index-114,O,L,H,C)
                     -0.002718822908674*PriceSeries(Price,index-115,O,L,H,C)
                     -0.002603927923047*PriceSeries(Price,index-116,O,L,H,C)
                     -0.002049199799550*PriceSeries(Price,index-117,O,L,H,C)
                     -0.001167852939053*PriceSeries(Price,index-118,O,L,H,C)
                     -0.0001242013331659*PriceSeries(Price,index-119,O,L,H,C)
                     +0.000896605611068*PriceSeries(Price,index-120,O,L,H,C)
                     +0.001721116337126*PriceSeries(Price,index-121,O,L,H,C)
                     +0.002216788866535*PriceSeries(Price,index-122,O,L,H,C)
                     +0.002312939086359*PriceSeries(Price,index-123,O,L,H,C)
                     +0.002010177036349*PriceSeries(Price,index-124,O,L,H,C)
                     +0.001377304678850*PriceSeries(Price,index-125,O,L,H,C)
                     +0.000536614587096*PriceSeries(Price,index-126,O,L,H,C)
                     -0.000359338512927*PriceSeries(Price,index-127,O,L,H,C)
                     -0.001155107568938*PriceSeries(Price,index-128,O,L,H,C)
                     -0.001719147270590*PriceSeries(Price,index-129,O,L,H,C)
                     -0.001965214969152*PriceSeries(Price,index-130,O,L,H,C)
                     -0.001865210672174*PriceSeries(Price,index-131,O,L,H,C)
                     -0.001451399261669*PriceSeries(Price,index-132,O,L,H,C)
                     -0.000808289890269*PriceSeries(Price,index-133,O,L,H,C)
                     -0.0000558539997422*PriceSeries(Price,index-134,O,L,H,C)
                     +0.000672579277744*PriceSeries(Price,index-135,O,L,H,C)
                     +0.001253714428316*PriceSeries(Price,index-136,O,L,H,C)
                     +0.001594934259545*PriceSeries(Price,index-137,O,L,H,C)
                     +0.001648781045218*PriceSeries(Price,index-138,O,L,H,C)
                     +0.001419070251465*PriceSeries(Price,index-139,O,L,H,C)
                     +0.000957882358765*PriceSeries(Price,index-140,O,L,H,C)
                     +0.000354489562913*PriceSeries(Price,index-141,O,L,H,C)
                     -0.0002816026046552*PriceSeries(Price,index-142,O,L,H,C)
                     -0.000840327948375*PriceSeries(Price,index-143,O,L,H,C)
                     -0.001229937191439*PriceSeries(Price,index-144,O,L,H,C)
                     -0.001391790837300*PriceSeries(Price,index-145,O,L,H,C)
                     -0.001308907681543*PriceSeries(Price,index-146,O,L,H,C)
                     -0.001006919436461*PriceSeries(Price,index-147,O,L,H,C)
                     -0.000547665014483*PriceSeries(Price,index-148,O,L,H,C)
                     -0.00001693859259391*PriceSeries(Price,index-149,O,L,H,C)
                     +0.000491311258005*PriceSeries(Price,index-150,O,L,H,C)
                     +0.000891508915316*PriceSeries(Price,index-151,O,L,H,C)
                     +0.001120566184787*PriceSeries(Price,index-152,O,L,H,C)
                     +0.001147730609292*PriceSeries(Price,index-153,O,L,H,C)
                     +0.000978147194660*PriceSeries(Price,index-154,O,L,H,C)
                     +0.000650369575904*PriceSeries(Price,index-155,O,L,H,C)
                     +0.0002280407904079*PriceSeries(Price,index-156,O,L,H,C)
                     -0.0002121540647015*PriceSeries(Price,index-157,O,L,H,C)
                     -0.000594313267968*PriceSeries(Price,index-158,O,L,H,C)
                     -0.000856202017012*PriceSeries(Price,index-159,O,L,H,C)
                     -0.000959232258103*PriceSeries(Price,index-160,O,L,H,C)
                     -0.000893849655016*PriceSeries(Price,index-161,O,L,H,C)
                     -0.000679766057082*PriceSeries(Price,index-162,O,L,H,C)
                     -0.000361054330483*PriceSeries(Price,index-163,O,L,H,C)
                     +0.000002617880655820*PriceSeries(Price,index-164,O,L,H,C)
                     +0.000346996312642*PriceSeries(Price,index-165,O,L,H,C)
                     +0.000614398934134*PriceSeries(Price,index-166,O,L,H,C)
                     +0.000763326719073*PriceSeries(Price,index-167,O,L,H,C)
                     +0.000774664311493*PriceSeries(Price,index-168,O,L,H,C)
                     +0.000653758949174*PriceSeries(Price,index-169,O,L,H,C)
                     +0.000428223422134*PriceSeries(Price,index-170,O,L,H,C)
                     +0.0001421000401400*PriceSeries(Price,index-171,O,L,H,C)
                     -0.0001526813364512*PriceSeries(Price,index-172,O,L,H,C)
                     -0.000405469652234*PriceSeries(Price,index-173,O,L,H,C)
                     -0.000575521706902*PriceSeries(Price,index-174,O,L,H,C)
                     -0.000638491658266*PriceSeries(Price,index-175,O,L,H,C)
                     -0.000589550747813*PriceSeries(Price,index-176,O,L,H,C)
                     -0.000443296031814*PriceSeries(Price,index-177,O,L,H,C)
                     -0.0002300456804083*PriceSeries(Price,index-178,O,L,H,C)
                     +0.00001014176371439*PriceSeries(Price,index-179,O,L,H,C)
                     +0.0002348923714587*PriceSeries(Price,index-180,O,L,H,C)
                     +0.000406885614640*PriceSeries(Price,index-181,O,L,H,C)
                     +0.000499904929464*PriceSeries(Price,index-182,O,L,H,C)
                     +0.000502730283754*PriceSeries(Price,index-183,O,L,H,C)
                     +0.000420144761439*PriceSeries(Price,index-184,O,L,H,C)
                     +0.0002712465320681*PriceSeries(Price,index-185,O,L,H,C)
                     +0.0000852640184668*PriceSeries(Price,index-186,O,L,H,C)
                     -0.0001039942485546*PriceSeries(Price,index-187,O,L,H,C)
                     -0.0002642197356266*PriceSeries(Price,index-188,O,L,H,C)
                     -0.000369922906542*PriceSeries(Price,index-189,O,L,H,C)
                     -0.000406472005200*PriceSeries(Price,index-190,O,L,H,C)
                     -0.000371933970999*PriceSeries(Price,index-191,O,L,H,C)
                     -0.0002766303495010*PriceSeries(Price,index-192,O,L,H,C)
                     -0.0001404801014905*PriceSeries(Price,index-193,O,L,H,C)
                     +0.00001081815318285*PriceSeries(Price,index-194,O,L,H,C)
                     +0.0001505821633843*PriceSeries(Price,index-195,O,L,H,C)
                     +0.0002558777001556*PriceSeries(Price,index-196,O,L,H,C)
                     +0.0003111062663561*PriceSeries(Price,index-197,O,L,H,C)
                     +0.0003100513520066*PriceSeries(Price,index-198,O,L,H,C)
                     +0.0002567400471703*PriceSeries(Price,index-199,O,L,H,C)
                     +0.0001635330304198*PriceSeries(Price,index-200,O,L,H,C)
                     +0.0000490021427232*PriceSeries(Price,index-201,O,L,H,C)
                     -0.0000660728616852*PriceSeries(Price,index-202,O,L,H,C)
                     -0.0001621063487704*PriceSeries(Price,index-203,O,L,H,C)
                     -0.0002241623255492*PriceSeries(Price,index-204,O,L,H,C)
                     -0.0002440560631459*PriceSeries(Price,index-205,O,L,H,C)
                     -0.0002213850804759*PriceSeries(Price,index-206,O,L,H,C)
                     -0.0001629724135461*PriceSeries(Price,index-207,O,L,H,C)
                     -0.0000812700671475*PriceSeries(Price,index-208,O,L,H,C)
                     +0.00000823950107937*PriceSeries(Price,index-209,O,L,H,C)
                     +0.0000898168424005*PriceSeries(Price,index-210,O,L,H,C)
                     +0.0001502438359228*PriceSeries(Price,index-211,O,L,H,C)
                     +0.0001808269535375*PriceSeries(Price,index-212,O,L,H,C)
                     +0.0001786538412983*PriceSeries(Price,index-213,O,L,H,C)
                     +0.0001465890632056*PriceSeries(Price,index-214,O,L,H,C)
                     +0.0000923767986500*PriceSeries(Price,index-215,O,L,H,C)
                     +0.00002679404774735*PriceSeries(Price,index-216,O,L,H,C)
                     -0.0000382452976371*PriceSeries(Price,index-217,O,L,H,C)
                     -0.0000916925290354*PriceSeries(Price,index-218,O,L,H,C)
                     -0.0001252625419057*PriceSeries(Price,index-219,O,L,H,C)
                     -0.0001351242354757*PriceSeries(Price,index-220,O,L,H,C)
                     -0.0001216234075297*PriceSeries(Price,index-221,O,L,H,C)
                     -0.0000885450193546*PriceSeries(Price,index-222,O,L,H,C)
                     -0.0000436451646733*PriceSeries(Price,index-223,O,L,H,C)
                     +0.00000491481676837*PriceSeries(Price,index-224,O,L,H,C)
                     +0.0000484035310693*PriceSeries(Price,index-225,O,L,H,C)
                     +0.0000800027545439*PriceSeries(Price,index-226,O,L,H,C)
                     +0.0000953960521442*PriceSeries(Price,index-227,O,L,H,C)
                     +0.0000933995840864*PriceSeries(Price,index-228,O,L,H,C)
                     +0.0000759173018209*PriceSeries(Price,index-229,O,L,H,C)
                     +0.0000472766990445*PriceSeries(Price,index-230,O,L,H,C)
                     +0.00001336122582079*PriceSeries(Price,index-231,O,L,H,C)
                     -0.00001962437036436*PriceSeries(Price,index-232,O,L,H,C)
                     -0.0000461533267798*PriceSeries(Price,index-233,O,L,H,C)
                     -0.0000623456407334*PriceSeries(Price,index-234,O,L,H,C)
                     -0.0000663850095158*PriceSeries(Price,index-235,O,L,H,C)
                     -0.0000587152030053*PriceSeries(Price,index-236,O,L,H,C)
                     -0.0000416469230311*PriceSeries(Price,index-237,O,L,H,C)
                     -0.00001885488175651*PriceSeries(Price,index-238,O,L,H,C)
                     +0.00000550203488948*PriceSeries(Price,index-239,O,L,H,C)
                     +0.00002752263964595*PriceSeries(Price,index-240,O,L,H,C)
                     +0.0000444608991810*PriceSeries(Price,index-241,O,L,H,C)
                     +0.0000554125744269*PriceSeries(Price,index-242,O,L,H,C)
                     +0.0000624515884548*PriceSeries(Price,index-243,O,L,H,C)
                     +0.0000725917602119*PriceSeries(Price,index-244,O,L,H,C)
                     +0.0001029811083346*PriceSeries(Price,index-245,O,L,H,C)
                     -0.0000588815596380*PriceSeries(Price,index-246,O,L,H,C)
                     );

      case N17:
         return(
                0.2477411194448*PriceSeries(Price,index,O,L,H,C)
                +0.2351933622708*PriceSeries(Price,index-1,O,L,H,C)
                +0.2112442241964*PriceSeries(Price,index-2,O,L,H,C)
                +0.1780614966034*PriceSeries(Price,index-3,O,L,H,C)
                +0.1385993761817*PriceSeries(Price,index-4,O,L,H,C)
                +0.0962811739850*PriceSeries(Price,index-5,O,L,H,C)
                +0.0546372307453*PriceSeries(Price,index-6,O,L,H,C)
                +0.01694012607908*PriceSeries(Price,index-7,O,L,H,C)
                -0.01412079058562*PriceSeries(Price,index-8,O,L,H,C)
                -0.0366893180406*PriceSeries(Price,index-9,O,L,H,C)
                -0.0498900698883*PriceSeries(Price,index-10,O,L,H,C)
                -0.0538603591841*PriceSeries(Price,index-11,O,L,H,C)
                -0.0496668552928*PriceSeries(Price,index-12,O,L,H,C)
                -0.0391215165628*PriceSeries(Price,index-13,O,L,H,C)
                -0.02452290405272*PriceSeries(Price,index-14,O,L,H,C)
                -0.00835717561286*PriceSeries(Price,index-15,O,L,H,C)
                +0.00700365320809*PriceSeries(Price,index-16,O,L,H,C)
                +0.01956945053047*PriceSeries(Price,index-17,O,L,H,C)
                +0.02793532913393*PriceSeries(Price,index-18,O,L,H,C)
                +0.03139916841241*PriceSeries(Price,index-19,O,L,H,C)
                +0.02998402097210*PriceSeries(Price,index-20,O,L,H,C)
                +0.02436831479255*PriceSeries(Price,index-21,O,L,H,C)
                +0.01573845213761*PriceSeries(Price,index-22,O,L,H,C)
                +0.00558744878860*PriceSeries(Price,index-23,O,L,H,C)
                -0.00451098042319*PriceSeries(Price,index-24,O,L,H,C)
                -0.01312204535946*PriceSeries(Price,index-25,O,L,H,C)
                -0.01913478780932*PriceSeries(Price,index-26,O,L,H,C)
                -0.02189007919009*PriceSeries(Price,index-27,O,L,H,C)
                -0.02123831666594*PriceSeries(Price,index-28,O,L,H,C)
                -0.01752353112594*PriceSeries(Price,index-29,O,L,H,C)
                -0.01150064098640*PriceSeries(Price,index-30,O,L,H,C)
                -0.00420139726679*PriceSeries(Price,index-31,O,L,H,C)
                +0.00322956889398*PriceSeries(Price,index-32,O,L,H,C)
                +0.00970408320779*PriceSeries(Price,index-33,O,L,H,C)
                +0.01434136504367*PriceSeries(Price,index-34,O,L,H,C)
                +0.01658063352354*PriceSeries(Price,index-35,O,L,H,C)
                +0.01624177621277*PriceSeries(Price,index-36,O,L,H,C)
                +0.01352848182522*PriceSeries(Price,index-37,O,L,H,C)
                +0.00897664970016*PriceSeries(Price,index-38,O,L,H,C)
                +0.00335825478992*PriceSeries(Price,index-39,O,L,H,C)
                -0.002443188460168*PriceSeries(Price,index-40,O,L,H,C)
                -0.00756643129833*PriceSeries(Price,index-41,O,L,H,C)
                -0.01129593256468*PriceSeries(Price,index-42,O,L,H,C)
                -0.01315784311996*PriceSeries(Price,index-43,O,L,H,C)
                -0.01297615635377*PriceSeries(Price,index-44,O,L,H,C)
                -0.01088297063169*PriceSeries(Price,index-45,O,L,H,C)
                -0.00728360024549*PriceSeries(Price,index-46,O,L,H,C)
                -0.002783864425144*PriceSeries(Price,index-47,O,L,H,C)
                +0.001908281637460*PriceSeries(Price,index-48,O,L,H,C)
                +0.00609109273883*PriceSeries(Price,index-49,O,L,H,C)
                +0.00917146697614*PriceSeries(Price,index-50,O,L,H,C)
                +0.01074657503186*PriceSeries(Price,index-51,O,L,H,C)
                +0.01065405094100*PriceSeries(Price,index-52,O,L,H,C)
                +0.00898464216517*PriceSeries(Price,index-53,O,L,H,C)
                +0.00605736494843*PriceSeries(Price,index-54,O,L,H,C)
                +0.002362226720239*PriceSeries(Price,index-55,O,L,H,C)
                -0.001519383472634*PriceSeries(Price,index-56,O,L,H,C)
                -0.00500439195238*PriceSeries(Price,index-57,O,L,H,C)
                -0.00759387579770*PriceSeries(Price,index-58,O,L,H,C)
                -0.00894300257397*PriceSeries(Price,index-59,O,L,H,C)
                -0.00890514967243*PriceSeries(Price,index-60,O,L,H,C)
                -0.00754513099703*PriceSeries(Price,index-61,O,L,H,C)
                -0.00512061592726*PriceSeries(Price,index-62,O,L,H,C)
                -0.002036033108189*PriceSeries(Price,index-63,O,L,H,C)
                +0.001223355710909*PriceSeries(Price,index-64,O,L,H,C)
                +0.00416649264388*PriceSeries(Price,index-65,O,L,H,C)
                +0.00636937704499*PriceSeries(Price,index-66,O,L,H,C)
                +0.00753508912707*PriceSeries(Price,index-67,O,L,H,C)
                +0.00753251224718*PriceSeries(Price,index-68,O,L,H,C)
                +0.00640912086329*PriceSeries(Price,index-69,O,L,H,C)
                +0.00437675496561*PriceSeries(Price,index-70,O,L,H,C)
                +0.001773673755784*PriceSeries(Price,index-71,O,L,H,C)
                -0.000990558968753*PriceSeries(Price,index-72,O,L,H,C)
                -0.00349864002894*PriceSeries(Price,index-73,O,L,H,C)
                -0.00538769072606*PriceSeries(Price,index-74,O,L,H,C)
                -0.00640098190432*PriceSeries(Price,index-75,O,L,H,C)
                -0.00642186716692*PriceSeries(Price,index-76,O,L,H,C)
                -0.00548570114707*PriceSeries(Price,index-77,O,L,H,C)
                -0.00376869401823*PriceSeries(Price,index-78,O,L,H,C)
                -0.001556329085478*PriceSeries(Price,index-79,O,L,H,C)
                +0.000803195340409*PriceSeries(Price,index-80,O,L,H,C)
                +0.002953143936635*PriceSeries(Price,index-81,O,L,H,C)
                +0.00458151761249*PriceSeries(Price,index-82,O,L,H,C)
                +0.00546576603560*PriceSeries(Price,index-83,O,L,H,C)
                +0.00550246923202*PriceSeries(Price,index-84,O,L,H,C)
                +0.00471818143548*PriceSeries(Price,index-85,O,L,H,C)
                +0.00326063434762*PriceSeries(Price,index-86,O,L,H,C)
                +0.001372161920056*PriceSeries(Price,index-87,O,L,H,C)
                -0.000649871652993*PriceSeries(Price,index-88,O,L,H,C)
                -0.002499387538486*PriceSeries(Price,index-89,O,L,H,C)
                -0.00390744474475*PriceSeries(Price,index-90,O,L,H,C)
                -0.00468086640617*PriceSeries(Price,index-91,O,L,H,C)
                -0.00472818728542*PriceSeries(Price,index-92,O,L,H,C)
                -0.00406944661282*PriceSeries(Price,index-93,O,L,H,C)
                -0.002829052996832*PriceSeries(Price,index-94,O,L,H,C)
                -0.001213416021998*PriceSeries(Price,index-95,O,L,H,C)
                +0.000522894377154*PriceSeries(Price,index-96,O,L,H,C)
                +0.002116784362608*PriceSeries(Price,index-97,O,L,H,C)
                +0.00333615909228*PriceSeries(Price,index-98,O,L,H,C)
                +0.00401333980478*PriceSeries(Price,index-99,O,L,H,C)
                +0.00406761842652*PriceSeries(Price,index-100,O,L,H,C)
                +0.00351407245168*PriceSeries(Price,index-101,O,L,H,C)
                +0.002457752674739*PriceSeries(Price,index-102,O,L,H,C)
                +0.001074678009371*PriceSeries(Price,index-103,O,L,H,C)
                -0.000416985901952*PriceSeries(Price,index-104,O,L,H,C)
                -0.001791045518947*PriceSeries(Price,index-105,O,L,H,C)
                -0.002847235150038*PriceSeries(Price,index-106,O,L,H,C)
                -0.00344010016803*PriceSeries(Price,index-107,O,L,H,C)
                -0.00349865116299*PriceSeries(Price,index-108,O,L,H,C)
                -0.003034115778480*PriceSeries(Price,index-109,O,L,H,C)
                -0.002135237474215*PriceSeries(Price,index-110,O,L,H,C)
                -0.000952146268172*PriceSeries(Price,index-111,O,L,H,C)
                +0.000328330507996*PriceSeries(Price,index-112,O,L,H,C)
                +0.001511882335235*PriceSeries(Price,index-113,O,L,H,C)
                +0.002425894172300*PriceSeries(Price,index-114,O,L,H,C)
                +0.002944457310780*PriceSeries(Price,index-115,O,L,H,C)
                +0.003005258831569*PriceSeries(Price,index-116,O,L,H,C)
                +0.002616573463942*PriceSeries(Price,index-117,O,L,H,C)
                +0.001853259619570*PriceSeries(Price,index-118,O,L,H,C)
                +0.000843192003002*PriceSeries(Price,index-119,O,L,H,C)
                -0.0002539348692201*PriceSeries(Price,index-120,O,L,H,C)
                -0.001271441576151*PriceSeries(Price,index-121,O,L,H,C)
                -0.002060993197827*PriceSeries(Price,index-122,O,L,H,C)
                -0.002513750719799*PriceSeries(Price,index-123,O,L,H,C)
                -0.002575299693816*PriceSeries(Price,index-124,O,L,H,C)
                -0.002251502075576*PriceSeries(Price,index-125,O,L,H,C)
                -0.001605423595955*PriceSeries(Price,index-126,O,L,H,C)
                -0.000745633834315*PriceSeries(Price,index-127,O,L,H,C)
                +0.0001916583899529*PriceSeries(Price,index-128,O,L,H,C)
                +0.001063990308391*PriceSeries(Price,index-129,O,L,H,C)
                +0.001744176334454*PriceSeries(Price,index-130,O,L,H,C)
                +0.002138516356133*PriceSeries(Price,index-131,O,L,H,C)
                +0.002199609846156*PriceSeries(Price,index-132,O,L,H,C)
                +0.001931465085563*PriceSeries(Price,index-133,O,L,H,C)
                +0.001386956793675*PriceSeries(Price,index-134,O,L,H,C)
                +0.000657994344838*PriceSeries(Price,index-135,O,L,H,C)
                -0.0001397412463578*PriceSeries(Price,index-136,O,L,H,C)
                -0.000884891210371*PriceSeries(Price,index-137,O,L,H,C)
                -0.001468839299006*PriceSeries(Price,index-138,O,L,H,C)
                -0.001811236323661*PriceSeries(Price,index-139,O,L,H,C)
                -0.001870944758937*PriceSeries(Price,index-140,O,L,H,C)
                -0.001650540935660*PriceSeries(Price,index-141,O,L,H,C)
                -0.001194097847252*PriceSeries(Price,index-142,O,L,H,C)
                -0.000579072238854*PriceSeries(Price,index-143,O,L,H,C)
                +0.0000967090420772*PriceSeries(Price,index-144,O,L,H,C)
                +0.000730384213519*PriceSeries(Price,index-145,O,L,H,C)
                +0.001229577647706*PriceSeries(Price,index-146,O,L,H,C)
                +0.001525760230166*PriceSeries(Price,index-147,O,L,H,C)
                +0.001583355529127*PriceSeries(Price,index-148,O,L,H,C)
                +0.001403796227090*PriceSeries(Price,index-149,O,L,H,C)
                +0.001023677852722*PriceSeries(Price,index-150,O,L,H,C)
                +0.000507820525957*PriceSeries(Price,index-151,O,L,H,C)
                -0.0000614639489010*PriceSeries(Price,index-152,O,L,H,C)
                -0.000597455215777*PriceSeries(Price,index-153,O,L,H,C)
                -0.001022086520248*PriceSeries(Price,index-154,O,L,H,C)
                -0.001277112716350*PriceSeries(Price,index-155,O,L,H,C)
                -0.001332044988005*PriceSeries(Price,index-156,O,L,H,C)
                -0.001187371736150*PriceSeries(Price,index-157,O,L,H,C)
                -0.000873202045386*PriceSeries(Price,index-158,O,L,H,C)
                -0.000443516044097*PriceSeries(Price,index-159,O,L,H,C)
                +0.0000329623531876*PriceSeries(Price,index-160,O,L,H,C)
                +0.000483576720620*PriceSeries(Price,index-161,O,L,H,C)
                +0.000842675204428*PriceSeries(Price,index-162,O,L,H,C)
                +0.001061181375007*PriceSeries(Price,index-163,O,L,H,C)
                +0.001113008517371*PriceSeries(Price,index-164,O,L,H,C)
                +0.000997949285573*PriceSeries(Price,index-165,O,L,H,C)
                +0.000740588347027*PriceSeries(Price,index-166,O,L,H,C)
                +0.000385485486296*PriceSeries(Price,index-167,O,L,H,C)
                -0.00001037739024903*PriceSeries(Price,index-168,O,L,H,C)
                -0.000386527980720*PriceSeries(Price,index-169,O,L,H,C)
                -0.000688253085683*PriceSeries(Price,index-170,O,L,H,C)
                -0.000874383133846*PriceSeries(Price,index-171,O,L,H,C)
                -0.000922766160531*PriceSeries(Price,index-172,O,L,H,C)
                -0.000832710419537*PriceSeries(Price,index-173,O,L,H,C)
                -0.000624080314907*PriceSeries(Price,index-174,O,L,H,C)
                -0.000333300605330*PriceSeries(Price,index-175,O,L,H,C)
                -0.00000723772811826*PriceSeries(Price,index-176,O,L,H,C)
                +0.0003042191203272*PriceSeries(Price,index-177,O,L,H,C)
                +0.000555805960547*PriceSeries(Price,index-178,O,L,H,C)
                +0.000713277036942*PriceSeries(Price,index-179,O,L,H,C)
                +0.000758009808452*PriceSeries(Price,index-180,O,L,H,C)
                +0.000688865497675*PriceSeries(Price,index-181,O,L,H,C)
                +0.000521776527866*PriceSeries(Price,index-182,O,L,H,C)
                +0.0002861142899668*PriceSeries(Price,index-183,O,L,H,C)
                +0.00002020081481115*PriceSeries(Price,index-184,O,L,H,C)
                -0.0002354250883840*PriceSeries(Price,index-185,O,L,H,C)
                -0.000443380529668*PriceSeries(Price,index-186,O,L,H,C)
                -0.000575714678918*PriceSeries(Price,index-187,O,L,H,C)
                -0.000616573918490*PriceSeries(Price,index-188,O,L,H,C)
                -0.000564837578242*PriceSeries(Price,index-189,O,L,H,C)
                -0.000432799710009*PriceSeries(Price,index-190,O,L,H,C)
                -0.0002441452225298*PriceSeries(Price,index-191,O,L,H,C)
                -0.00002965318600663*PriceSeries(Price,index-192,O,L,H,C)
                +0.0001779332090415*PriceSeries(Price,index-193,O,L,H,C)
                +0.000348243341608*PriceSeries(Price,index-194,O,L,H,C)
                +0.000458438150330*PriceSeries(Price,index-195,O,L,H,C)
                +0.000495458523936*PriceSeries(Price,index-196,O,L,H,C)
                +0.000457881693109*PriceSeries(Price,index-197,O,L,H,C)
                +0.000355403827384*PriceSeries(Price,index-198,O,L,H,C)
                +0.0002064697647699*PriceSeries(Price,index-199,O,L,H,C)
                +0.0000356610150239*PriceSeries(Price,index-200,O,L,H,C)
                -0.0001307656773097*PriceSeries(Price,index-201,O,L,H,C)
                -0.0002687662069580*PriceSeries(Price,index-202,O,L,H,C)
                -0.000359556787171*PriceSeries(Price,index-203,O,L,H,C)
                -0.000392685965368*PriceSeries(Price,index-204,O,L,H,C)
                -0.000366594977082*PriceSeries(Price,index-205,O,L,H,C)
                -0.0002884356873579*PriceSeries(Price,index-206,O,L,H,C)
                -0.0001728287876745*PriceSeries(Price,index-207,O,L,H,C)
                -0.0000388592897926*PriceSeries(Price,index-208,O,L,H,C)
                +0.0000929193552418*PriceSeries(Price,index-209,O,L,H,C)
                +0.0002032128927153*PriceSeries(Price,index-210,O,L,H,C)
                +0.0002772477706622*PriceSeries(Price,index-211,O,L,H,C)
                +0.0003064904849858*PriceSeries(Price,index-212,O,L,H,C)
                +0.0002893127647775*PriceSeries(Price,index-213,O,L,H,C)
                +0.0002310687282238*PriceSeries(Price,index-214,O,L,H,C)
                +0.0001429390749005*PriceSeries(Price,index-215,O,L,H,C)
                +0.0000395472971417*PriceSeries(Price,index-216,O,L,H,C)
                -0.0000631302004568*PriceSeries(Price,index-217,O,L,H,C)
                -0.0001500900133304*PriceSeries(Price,index-218,O,L,H,C)
                -0.0002096290433870*PriceSeries(Price,index-219,O,L,H,C)
                -0.0002349683141095*PriceSeries(Price,index-220,O,L,H,C)
                -0.0002246189833916*PriceSeries(Price,index-221,O,L,H,C)
                -0.0001823358120045*PriceSeries(Price,index-222,O,L,H,C)
                -0.0001163507974532*PriceSeries(Price,index-223,O,L,H,C)
                -0.0000378979448962*PriceSeries(Price,index-224,O,L,H,C)
                +0.0000408383149558*PriceSeries(Price,index-225,O,L,H,C)
                +0.0001084391915900*PriceSeries(Price,index-226,O,L,H,C)
                +0.0001558130692373*PriceSeries(Price,index-227,O,L,H,C)
                +0.0001773375017134*PriceSeries(Price,index-228,O,L,H,C)
                +0.0001716178848264*PriceSeries(Price,index-229,O,L,H,C)
                +0.0001413206620970*PriceSeries(Price,index-230,O,L,H,C)
                +0.0000924800985755*PriceSeries(Price,index-231,O,L,H,C)
                +0.0000333145836024*PriceSeries(Price,index-232,O,L,H,C)
                -0.00002696440188548*PriceSeries(Price,index-233,O,L,H,C)
                -0.0000795557200664*PriceSeries(Price,index-234,O,L,H,C)
                -0.0001172476559170*PriceSeries(Price,index-235,O,L,H,C)
                -0.0001354430481326*PriceSeries(Price,index-236,O,L,H,C)
                -0.0001325246913819*PriceSeries(Price,index-237,O,L,H,C)
                -0.0001098850868904*PriceSeries(Price,index-238,O,L,H,C)
                -0.0000713923712882*PriceSeries(Price,index-239,O,L,H,C)
                -0.00002276066753158*PriceSeries(Price,index-240,O,L,H,C)
                +0.00002944914062098*PriceSeries(Price,index-241,O,L,H,C)
                +0.0000786406145221*PriceSeries(Price,index-242,O,L,H,C)
                +0.0001194039884380*PriceSeries(Price,index-243,O,L,H,C)
                +0.0001473370342852*PriceSeries(Price,index-244,O,L,H,C)
                +0.0001620485685942*PriceSeries(Price,index-245,O,L,H,C)
                +0.0001585550657372*PriceSeries(Price,index-246,O,L,H,C)
                +0.0001555176891574*PriceSeries(Price,index-247,O,L,H,C)
                +0.0000999831070290*PriceSeries(Price,index-248,O,L,H,C)
                +0.0001825223694255*PriceSeries(Price,index-249,O,L,H,C)
                +0.0000489965226222*PriceSeries(Price,index-250,O,L,H,C)
                );

      case N18:
         return(
                0.2332804754294*PriceSeries(Price,index,O,L,H,C)
                +0.2229029635413*PriceSeries(Price,index-1,O,L,H,C)
                +0.2029806292613*PriceSeries(Price,index-2,O,L,H,C)
                +0.1750991427233*PriceSeries(Price,index-3,O,L,H,C)
                +0.1414460676333*PriceSeries(Price,index-4,O,L,H,C)
                +0.1046041216632*PriceSeries(Price,index-5,O,L,H,C)
                +0.0673102086991*PriceSeries(Price,index-6,O,L,H,C)
                +0.0322049602439*PriceSeries(Price,index-7,O,L,H,C)
                +0.001598195937121*PriceSeries(Price,index-8,O,L,H,C)
                -0.02272641648264*PriceSeries(Price,index-9,O,L,H,C)
                -0.0396487490586*PriceSeries(Price,index-10,O,L,H,C)
                -0.0487794414949*PriceSeries(Price,index-11,O,L,H,C)
                -0.0504524140626*PriceSeries(Price,index-12,O,L,H,C)
                -0.0456461638544*PriceSeries(Price,index-13,O,L,H,C)
                -0.0358447329087*PriceSeries(Price,index-14,O,L,H,C)
                -0.02285533732211*PriceSeries(Price,index-15,O,L,H,C)
                -0.00860362256532*PriceSeries(Price,index-16,O,L,H,C)
                +0.00507083251539*PriceSeries(Price,index-17,O,L,H,C)
                +0.01659712794463*PriceSeries(Price,index-18,O,L,H,C)
                +0.02481535702616*PriceSeries(Price,index-19,O,L,H,C)
                +0.02906548799409*PriceSeries(Price,index-20,O,L,H,C)
                +0.02921607207539*PriceSeries(Price,index-21,O,L,H,C)
                +0.02563309234202*PriceSeries(Price,index-22,O,L,H,C)
                +0.01909582974711*PriceSeries(Price,index-23,O,L,H,C)
                +0.01067232225470*PriceSeries(Price,index-24,O,L,H,C)
                +0.001570815495585*PriceSeries(Price,index-25,O,L,H,C)
                -0.00701439989033*PriceSeries(Price,index-26,O,L,H,C)
                -0.01404479054340*PriceSeries(Price,index-27,O,L,H,C)
                -0.01875130369112*PriceSeries(Price,index-28,O,L,H,C)
                -0.02070849513060*PriceSeries(Price,index-29,O,L,H,C)
                -0.01986266294136*PriceSeries(Price,index-30,O,L,H,C)
                -0.01651344662380*PriceSeries(Price,index-31,O,L,H,C)
                -0.01125376934317*PriceSeries(Price,index-32,O,L,H,C)
                -0.00487781007792*PriceSeries(Price,index-33,O,L,H,C)
                +0.001730111852530*PriceSeries(Price,index-34,O,L,H,C)
                +0.00771111442219*PriceSeries(Price,index-35,O,L,H,C)
                +0.01233751084675*PriceSeries(Price,index-36,O,L,H,C)
                +0.01509626469932*PriceSeries(Price,index-37,O,L,H,C)
                +0.01574114794194*PriceSeries(Price,index-38,O,L,H,C)
                +0.01430874715770*PriceSeries(Price,index-39,O,L,H,C)
                +0.01109830058013*PriceSeries(Price,index-40,O,L,H,C)
                +0.00661965100660*PriceSeries(Price,index-41,O,L,H,C)
                +0.001517497573642*PriceSeries(Price,index-42,O,L,H,C)
                -0.00351748978729*PriceSeries(Price,index-43,O,L,H,C)
                -0.00783882399723*PriceSeries(Price,index-44,O,L,H,C)
                -0.01092432824997*PriceSeries(Price,index-45,O,L,H,C)
                -0.01243654910231*PriceSeries(Price,index-46,O,L,H,C)
                -0.01225685270791*PriceSeries(Price,index-47,O,L,H,C)
                -0.01049004267180*PriceSeries(Price,index-48,O,L,H,C)
                -0.00744035857083*PriceSeries(Price,index-49,O,L,H,C)
                -0.00356312049227*PriceSeries(Price,index-50,O,L,H,C)
                +0.000600661299588*PriceSeries(Price,index-51,O,L,H,C)
                +0.00449771542010*PriceSeries(Price,index-52,O,L,H,C)
                +0.00763418600606*PriceSeries(Price,index-53,O,L,H,C)
                +0.00963657776927*PriceSeries(Price,index-54,O,L,H,C)
                +0.01029455677744*PriceSeries(Price,index-55,O,L,H,C)
                +0.00958100058069*PriceSeries(Price,index-56,O,L,H,C)
                +0.00764759677220*PriceSeries(Price,index-57,O,L,H,C)
                +0.00479767706299*PriceSeries(Price,index-58,O,L,H,C)
                +0.001440611659896*PriceSeries(Price,index-59,O,L,H,C)
                -0.001965515413341*PriceSeries(Price,index-60,O,L,H,C)
                -0.00497520829095*PriceSeries(Price,index-61,O,L,H,C)
                -0.00721268857684*PriceSeries(Price,index-62,O,L,H,C)
                -0.00841776417016*PriceSeries(Price,index-63,O,L,H,C)
                -0.00847487317563*PriceSeries(Price,index-64,O,L,H,C)
                -0.00742231927194*PriceSeries(Price,index-65,O,L,H,C)
                -0.00544118940934*PriceSeries(Price,index-66,O,L,H,C)
                -0.002826264232025*PriceSeries(Price,index-67,O,L,H,C)
                +0.0000567123830093*PriceSeries(Price,index-68,O,L,H,C)
                +0.002821265154300*PriceSeries(Price,index-69,O,L,H,C)
                +0.00511122655212*PriceSeries(Price,index-70,O,L,H,C)
                +0.00664585311169*PriceSeries(Price,index-71,O,L,H,C)
                +0.00725349059021*PriceSeries(Price,index-72,O,L,H,C)
                +0.00688975655816*PriceSeries(Price,index-73,O,L,H,C)
                +0.00563856366285*PriceSeries(Price,index-74,O,L,H,C)
                +0.00369637951953*PriceSeries(Price,index-75,O,L,H,C)
                +0.001342492376621*PriceSeries(Price,index-76,O,L,H,C)
                -0.001100449671027*PriceSeries(Price,index-77,O,L,H,C)
                -0.00331003745273*PriceSeries(Price,index-78,O,L,H,C)
                -0.00500612908152*PriceSeries(Price,index-79,O,L,H,C)
                -0.00598579598312*PriceSeries(Price,index-80,O,L,H,C)
                -0.00614699595678*PriceSeries(Price,index-81,O,L,H,C)
                -0.00549820835360*PriceSeries(Price,index-82,O,L,H,C)
                -0.00415336731071*PriceSeries(Price,index-83,O,L,H,C)
                -0.002313192886805*PriceSeries(Price,index-84,O,L,H,C)
                -0.0002359182623760*PriceSeries(Price,index-85,O,L,H,C)
                +0.001798476588039*PriceSeries(Price,index-86,O,L,H,C)
                +0.00352555874219*PriceSeries(Price,index-87,O,L,H,C)
                +0.00473042808051*PriceSeries(Price,index-88,O,L,H,C)
                +0.00527399676210*PriceSeries(Price,index-89,O,L,H,C)
                +0.00510849678785*PriceSeries(Price,index-90,O,L,H,C)
                +0.00428047993430*PriceSeries(Price,index-91,O,L,H,C)
                +0.002921448637850*PriceSeries(Price,index-92,O,L,H,C)
                +0.001227677745503*PriceSeries(Price,index-93,O,L,H,C)
                -0.000567664748573*PriceSeries(Price,index-94,O,L,H,C)
                -0.002226289962932*PriceSeries(Price,index-95,O,L,H,C)
                -0.00353607819560*PriceSeries(Price,index-96,O,L,H,C)
                -0.00433790211502*PriceSeries(Price,index-97,O,L,H,C)
                -0.00454455818373*PriceSeries(Price,index-98,O,L,H,C)
                -0.00414968033908*PriceSeries(Price,index-99,O,L,H,C)
                -0.00322575091156*PriceSeries(Price,index-100,O,L,H,C)
                -0.001911904685888*PriceSeries(Price,index-101,O,L,H,C)
                -0.000393422119382*PriceSeries(Price,index-102,O,L,H,C)
                +0.001124074436393*PriceSeries(Price,index-103,O,L,H,C)
                +0.002442216899600*PriceSeries(Price,index-104,O,L,H,C)
                +0.00339555716637*PriceSeries(Price,index-105,O,L,H,C)
                +0.00387206961692*PriceSeries(Price,index-106,O,L,H,C)
                +0.00382593265142*PriceSeries(Price,index-107,O,L,H,C)
                +0.00328124502520*PriceSeries(Price,index-108,O,L,H,C)
                +0.002326436575968*PriceSeries(Price,index-109,O,L,H,C)
                +0.001100498570361*PriceSeries(Price,index-110,O,L,H,C)
                -0.0002269540386357*PriceSeries(Price,index-111,O,L,H,C)
                -0.001478904255084*PriceSeries(Price,index-112,O,L,H,C)
                -0.002494345874634*PriceSeries(Price,index-113,O,L,H,C)
                -0.003148764934527*PriceSeries(Price,index-114,O,L,H,C)
                -0.00336916000433*PriceSeries(Price,index-115,O,L,H,C)
                -0.003141790815434*PriceSeries(Price,index-116,O,L,H,C)
                -0.002511914857013*PriceSeries(Price,index-117,O,L,H,C)
                -0.001575814952840*PriceSeries(Price,index-118,O,L,H,C)
                -0.000466436782825*PriceSeries(Price,index-119,O,L,H,C)
                +0.000665269935056*PriceSeries(Price,index-120,O,L,H,C)
                +0.001670711153012*PriceSeries(Price,index-121,O,L,H,C)
                +0.002422988604511*PriceSeries(Price,index-122,O,L,H,C)
                +0.002832721436288*PriceSeries(Price,index-123,O,L,H,C)
                +0.002858417483333*PriceSeries(Price,index-124,O,L,H,C)
                +0.002510203894875*PriceSeries(Price,index-125,O,L,H,C)
                +0.001846691457773*PriceSeries(Price,index-126,O,L,H,C)
                +0.000965599237254*PriceSeries(Price,index-127,O,L,H,C)
                -0.00001039039938264*PriceSeries(Price,index-128,O,L,H,C)
                -0.000950551106176*PriceSeries(Price,index-129,O,L,H,C)
                -0.001733473770857*PriceSeries(Price,index-130,O,L,H,C)
                -0.002262592802532*PriceSeries(Price,index-131,O,L,H,C)
                -0.002477921264008*PriceSeries(Price,index-132,O,L,H,C)
                -0.002362569357148*PriceSeries(Price,index-133,O,L,H,C)
                -0.001943415751324*PriceSeries(Price,index-134,O,L,H,C)
                -0.001286013103158*PriceSeries(Price,index-135,O,L,H,C)
                -0.000484651557795*PriceSeries(Price,index-136,O,L,H,C)
                +0.000351006927960*PriceSeries(Price,index-137,O,L,H,C)
                +0.001110787032854*PriceSeries(Price,index-138,O,L,H,C)
                +0.001698412106107*PriceSeries(Price,index-139,O,L,H,C)
                +0.002043557261617*PriceSeries(Price,index-140,O,L,H,C)
                +0.002110089430620*PriceSeries(Price,index-141,O,L,H,C)
                +0.001899522031087*PriceSeries(Price,index-142,O,L,H,C)
                +0.001449440211872*PriceSeries(Price,index-143,O,L,H,C)
                +0.000827264450241*PriceSeries(Price,index-144,O,L,H,C)
                +0.0001203569792409*PriceSeries(Price,index-145,O,L,H,C)
                -0.000576121571110*PriceSeries(Price,index-146,O,L,H,C)
                -0.001171896697358*PriceSeries(Price,index-147,O,L,H,C)
                -0.001593186851332*PriceSeries(Price,index-148,O,L,H,C)
                -0.001791685340765*PriceSeries(Price,index-149,O,L,H,C)
                -0.001749924215550*PriceSeries(Price,index-150,O,L,H,C)
                -0.001482358228761*PriceSeries(Price,index-151,O,L,H,C)
                -0.001032309358783*PriceSeries(Price,index-152,O,L,H,C)
                -0.000465191233365*PriceSeries(Price,index-153,O,L,H,C)
                +0.0001408221019337*PriceSeries(Price,index-154,O,L,H,C)
                +0.000705495497535*PriceSeries(Price,index-155,O,L,H,C)
                +0.001157032199442*PriceSeries(Price,index-156,O,L,H,C)
                +0.001441127369729*PriceSeries(Price,index-157,O,L,H,C)
                +0.001527338192748*PriceSeries(Price,index-158,O,L,H,C)
                +0.001412137977682*PriceSeries(Price,index-159,O,L,H,C)
                +0.001118310783681*PriceSeries(Price,index-160,O,L,H,C)
                +0.000690973630607*PriceSeries(Price,index-161,O,L,H,C)
                +0.0001908058903474*PriceSeries(Price,index-162,O,L,H,C)
                -0.0003144319579553*PriceSeries(Price,index-163,O,L,H,C)
                -0.000759016349141*PriceSeries(Price,index-164,O,L,H,C)
                -0.001087694145614*PriceSeries(Price,index-165,O,L,H,C)
                -0.001262486497092*PriceSeries(Price,index-166,O,L,H,C)
                -0.001266881587174*PriceSeries(Price,index-167,O,L,H,C)
                -0.001107169013482*PriceSeries(Price,index-168,O,L,H,C)
                -0.000810646396134*PriceSeries(Price,index-169,O,L,H,C)
                -0.000421270781371*PriceSeries(Price,index-170,O,L,H,C)
                +0.00000678293189828*PriceSeries(Price,index-171,O,L,H,C)
                +0.000416517877619*PriceSeries(Price,index-172,O,L,H,C)
                +0.000755678102792*PriceSeries(Price,index-173,O,L,H,C)
                +0.000983292535591*PriceSeries(Price,index-174,O,L,H,C)
                +0.001074551266822*PriceSeries(Price,index-175,O,L,H,C)
                +0.001023318625584*PriceSeries(Price,index-176,O,L,H,C)
                +0.000842177527917*PriceSeries(Price,index-177,O,L,H,C)
                +0.000559977018483*PriceSeries(Price,index-178,O,L,H,C)
                +0.0002174340435018*PriceSeries(Price,index-179,O,L,H,C)
                -0.0001386754260302*PriceSeries(Price,index-180,O,L,H,C)
                -0.000461792158165*PriceSeries(Price,index-181,O,L,H,C)
                -0.000711648150486*PriceSeries(Price,index-182,O,L,H,C)
                -0.000859142182187*PriceSeries(Price,index-183,O,L,H,C)
                -0.000889690455934*PriceSeries(Price,index-184,O,L,H,C)
                -0.000804411184048*PriceSeries(Price,index-185,O,L,H,C)
                -0.000619368267507*PriceSeries(Price,index-186,O,L,H,C)
                -0.000362749481173*PriceSeries(Price,index-187,O,L,H,C)
                -0.0000707703913073*PriceSeries(Price,index-188,O,L,H,C)
                +0.0002174318535667*PriceSeries(Price,index-189,O,L,H,C)
                +0.000464924793546*PriceSeries(Price,index-190,O,L,H,C)
                +0.000641696997446*PriceSeries(Price,index-191,O,L,H,C)
                +0.000728168538201*PriceSeries(Price,index-192,O,L,H,C)
                +0.000717288834221*PriceSeries(Price,index-193,O,L,H,C)
                +0.000614845525439*PriceSeries(Price,index-194,O,L,H,C)
                +0.000438155289183*PriceSeries(Price,index-195,O,L,H,C)
                +0.0002132751929945*PriceSeries(Price,index-196,O,L,H,C)
                -0.00002870796221884*PriceSeries(Price,index-197,O,L,H,C)
                -0.0002559755413968*PriceSeries(Price,index-198,O,L,H,C)
                -0.000440036193956*PriceSeries(Price,index-199,O,L,H,C)
                -0.000559310505519*PriceSeries(Price,index-200,O,L,H,C)
                -0.000601493147845*PriceSeries(Price,index-201,O,L,H,C)
                -0.000564812631147*PriceSeries(Price,index-202,O,L,H,C)
                -0.000457635807354*PriceSeries(Price,index-203,O,L,H,C)
                -0.0002970265121520*PriceSeries(Price,index-204,O,L,H,C)
                -0.0001060452755358*PriceSeries(Price,index-205,O,L,H,C)
                +0.0000894066784287*PriceSeries(Price,index-206,O,L,H,C)
                +0.0002641209452018*PriceSeries(Price,index-207,O,L,H,C)
                +0.000396697486001*PriceSeries(Price,index-208,O,L,H,C)
                +0.000472140394860*PriceSeries(Price,index-209,O,L,H,C)
                +0.000483455671469*PriceSeries(Price,index-210,O,L,H,C)
                +0.000432164974391*PriceSeries(Price,index-211,O,L,H,C)
                +0.000327684442662*PriceSeries(Price,index-212,O,L,H,C)
                +0.0001857812687355*PriceSeries(Price,index-213,O,L,H,C)
                +0.00002621600558330*PriceSeries(Price,index-214,O,L,H,C)
                -0.0001299208134412*PriceSeries(Price,index-215,O,L,H,C)
                -0.0002630230192215*PriceSeries(Price,index-216,O,L,H,C)
                -0.000357260680070*PriceSeries(Price,index-217,O,L,H,C)
                -0.000402577034539*PriceSeries(Price,index-218,O,L,H,C)
                -0.000395515567150*PriceSeries(Price,index-219,O,L,H,C)
                -0.000339513798978*PriceSeries(Price,index-220,O,L,H,C)
                -0.0002440063742819*PriceSeries(Price,index-221,O,L,H,C)
                -0.0001231432717006*PriceSeries(Price,index-222,O,L,H,C)
                +0.00000633351070337*PriceSeries(Price,index-223,O,L,H,C)
                +0.0001271586104603*PriceSeries(Price,index-224,O,L,H,C)
                +0.0002236823827172*PriceSeries(Price,index-225,O,L,H,C)
                +0.0002837323492520*PriceSeries(Price,index-226,O,L,H,C)
                +0.0002998724995248*PriceSeries(Price,index-227,O,L,H,C)
                +0.0002701104649617*PriceSeries(Price,index-228,O,L,H,C)
                +0.0001978113170788*PriceSeries(Price,index-229,O,L,H,C)
                +0.0000911339187656*PriceSeries(Price,index-230,O,L,H,C)
                -0.0000382477311274*PriceSeries(Price,index-231,O,L,H,C)
                -0.0001767310012502*PriceSeries(Price,index-232,O,L,H,C)
                -0.0003102269384421*PriceSeries(Price,index-233,O,L,H,C)
                -0.000426022106497*PriceSeries(Price,index-234,O,L,H,C)
                -0.000513791397097*PriceSeries(Price,index-235,O,L,H,C)
                -0.000566890442417*PriceSeries(Price,index-236,O,L,H,C)
                -0.000582345048883*PriceSeries(Price,index-237,O,L,H,C)
                -0.000561456001878*PriceSeries(Price,index-238,O,L,H,C)
                -0.000508833404722*PriceSeries(Price,index-239,O,L,H,C)
                -0.000431739030381*PriceSeries(Price,index-240,O,L,H,C)
                -0.000339150600597*PriceSeries(Price,index-241,O,L,H,C)
                -0.0002404072841485*PriceSeries(Price,index-242,O,L,H,C)
                -0.0001445509128063*PriceSeries(Price,index-243,O,L,H,C)
                -0.0000586406045147*PriceSeries(Price,index-244,O,L,H,C)
                +0.00001125974973164*PriceSeries(Price,index-245,O,L,H,C)
                +0.0000624363202517*PriceSeries(Price,index-246,O,L,H,C)
                +0.0000941471642542*PriceSeries(Price,index-247,O,L,H,C)
                +0.0001075126549819*PriceSeries(Price,index-248,O,L,H,C)
                +0.0001055849641679*PriceSeries(Price,index-249,O,L,H,C)
                +0.0000923576374076*PriceSeries(Price,index-250,O,L,H,C)
                +0.0001531427931149*PriceSeries(Price,index-251,O,L,H,C)
                );

      case N19:
         return(
                0.2207345455193*PriceSeries(Price,index,O,L,H,C)
                +0.2120061019938*PriceSeries(Price,index-1,O,L,H,C)
                +0.1951716802928*PriceSeries(Price,index-2,O,L,H,C)
                +0.1714232641479*PriceSeries(Price,index-3,O,L,H,C)
                +0.1424213713986*PriceSeries(Price,index-4,O,L,H,C)
                +0.1101553752957*PriceSeries(Price,index-5,O,L,H,C)
                +0.0767780208723*PriceSeries(Price,index-6,O,L,H,C)
                +0.0444292408950*PriceSeries(Price,index-7,O,L,H,C)
                +0.01506524278098*PriceSeries(Price,index-8,O,L,H,C)
                -0.00969194890178*PriceSeries(Price,index-9,O,L,H,C)
                -0.02867143010008*PriceSeries(Price,index-10,O,L,H,C)
                -0.0412272081208*PriceSeries(Price,index-11,O,L,H,C)
                -0.0472634069330*PriceSeries(Price,index-12,O,L,H,C)
                -0.0472102112154*PriceSeries(Price,index-13,O,L,H,C)
                -0.0419544322541*PriceSeries(Price,index-14,O,L,H,C)
                -0.0327328269774*PriceSeries(Price,index-15,O,L,H,C)
                -0.02099950796052*PriceSeries(Price,index-16,O,L,H,C)
                -0.00828090391355*PriceSeries(Price,index-17,O,L,H,C)
                +0.00396760864882*PriceSeries(Price,index-18,O,L,H,C)
                +0.01448991618608*PriceSeries(Price,index-19,O,L,H,C)
                +0.02233079418487*PriceSeries(Price,index-20,O,L,H,C)
                +0.02690252899522*PriceSeries(Price,index-21,O,L,H,C)
                +0.02801192441935*PriceSeries(Price,index-22,O,L,H,C)
                +0.02584715437635*PriceSeries(Price,index-23,O,L,H,C)
                +0.02092795870022*PriceSeries(Price,index-24,O,L,H,C)
                +0.01402612076043*PriceSeries(Price,index-25,O,L,H,C)
                +0.00606586964148*PriceSeries(Price,index-26,O,L,H,C)
                -0.001984631608747*PriceSeries(Price,index-27,O,L,H,C)
                -0.00921915319884*PriceSeries(Price,index-28,O,L,H,C)
                -0.01488592510403*PriceSeries(Price,index-29,O,L,H,C)
                -0.01845798883354*PriceSeries(Price,index-30,O,L,H,C)
                -0.01967534441877*PriceSeries(Price,index-31,O,L,H,C)
                -0.01855600335631*PriceSeries(Price,index-32,O,L,H,C)
                -0.01537655935075*PriceSeries(Price,index-33,O,L,H,C)
                -0.01062597821792*PriceSeries(Price,index-34,O,L,H,C)
                -0.00493905718263*PriceSeries(Price,index-35,O,L,H,C)
                +0.000982265994946*PriceSeries(Price,index-36,O,L,H,C)
                +0.00645053650235*PriceSeries(Price,index-37,O,L,H,C)
                +0.01086839774306*PriceSeries(Price,index-38,O,L,H,C)
                +0.01379019798149*PriceSeries(Price,index-39,O,L,H,C)
                +0.01496362522869*PriceSeries(Price,index-40,O,L,H,C)
                +0.01434772174465*PriceSeries(Price,index-41,O,L,H,C)
                +0.01210653631956*PriceSeries(Price,index-42,O,L,H,C)
                +0.00858020003801*PriceSeries(Price,index-43,O,L,H,C)
                +0.00423780344479*PriceSeries(Price,index-44,O,L,H,C)
                -0.000381919223483*PriceSeries(Price,index-45,O,L,H,C)
                -0.00473486225984*PriceSeries(Price,index-46,O,L,H,C)
                -0.00833343845591*PriceSeries(Price,index-47,O,L,H,C)
                -0.01079920553073*PriceSeries(Price,index-48,O,L,H,C)
                -0.01190081904965*PriceSeries(Price,index-49,O,L,H,C)
                -0.01157362888360*PriceSeries(Price,index-50,O,L,H,C)
                -0.00991957181842*PriceSeries(Price,index-51,O,L,H,C)
                -0.00718816640032*PriceSeries(Price,index-52,O,L,H,C)
                -0.00374161512753*PriceSeries(Price,index-53,O,L,H,C)
                -0.00000856443630154*PriceSeries(Price,index-54,O,L,H,C)
                +0.00356771070720*PriceSeries(Price,index-55,O,L,H,C)
                +0.00658065424917*PriceSeries(Price,index-56,O,L,H,C)
                +0.00870545349525*PriceSeries(Price,index-57,O,L,H,C)
                +0.00973291574070*PriceSeries(Price,index-58,O,L,H,C)
                +0.00958875283595*PriceSeries(Price,index-59,O,L,H,C)
                +0.00833670568151*PriceSeries(Price,index-60,O,L,H,C)
                +0.00616571104242*PriceSeries(Price,index-61,O,L,H,C)
                +0.00336327501241*PriceSeries(Price,index-62,O,L,H,C)
                +0.0002785477770138*PriceSeries(Price,index-63,O,L,H,C)
                -0.002720216812423*PriceSeries(Price,index-64,O,L,H,C)
                -0.00528881628780*PriceSeries(Price,index-65,O,L,H,C)
                -0.00714581594717*PriceSeries(Price,index-66,O,L,H,C)
                -0.00810264903438*PriceSeries(Price,index-67,O,L,H,C)
                -0.00808187573852*PriceSeries(Price,index-68,O,L,H,C)
                -0.00712202778894*PriceSeries(Price,index-69,O,L,H,C)
                -0.00536887993371*PriceSeries(Price,index-70,O,L,H,C)
                -0.003054737447518*PriceSeries(Price,index-71,O,L,H,C)
                -0.000468439193850*PriceSeries(Price,index-72,O,L,H,C)
                +0.002080017519969*PriceSeries(Price,index-73,O,L,H,C)
                +0.00429609511172*PriceSeries(Price,index-74,O,L,H,C)
                +0.00593420867537*PriceSeries(Price,index-75,O,L,H,C)
                +0.00682442784177*PriceSeries(Price,index-76,O,L,H,C)
                +0.00688947087148*PriceSeries(Price,index-77,O,L,H,C)
                +0.00615044835262*PriceSeries(Price,index-78,O,L,H,C)
                +0.00472099380410*PriceSeries(Price,index-79,O,L,H,C)
                +0.002790935088931*PriceSeries(Price,index-80,O,L,H,C)
                +0.000601679144262*PriceSeries(Price,index-81,O,L,H,C)
                -0.001583500745307*PriceSeries(Price,index-82,O,L,H,C)
                -0.00351073734399*PriceSeries(Price,index-83,O,L,H,C)
                -0.00496466452469*PriceSeries(Price,index-84,O,L,H,C)
                -0.00579211039105*PriceSeries(Price,index-85,O,L,H,C)
                -0.00591777037734*PriceSeries(Price,index-86,O,L,H,C)
                -0.00535035236085*PriceSeries(Price,index-87,O,L,H,C)
                -0.00417877567252*PriceSeries(Price,index-88,O,L,H,C)
                -0.002559211412765*PriceSeries(Price,index-89,O,L,H,C)
                -0.000694723956445*PriceSeries(Price,index-90,O,L,H,C)
                +0.001189817577982*PriceSeries(Price,index-91,O,L,H,C)
                +0.002874574167135*PriceSeries(Price,index-92,O,L,H,C)
                +0.00417008221921*PriceSeries(Price,index-93,O,L,H,C)
                +0.00493828317421*PriceSeries(Price,index-94,O,L,H,C)
                +0.00510686919838*PriceSeries(Price,index-95,O,L,H,C)
                +0.00467557539853*PriceSeries(Price,index-96,O,L,H,C)
                +0.00371386757237*PriceSeries(Price,index-97,O,L,H,C)
                +0.002350645926908*PriceSeries(Price,index-98,O,L,H,C)
                +0.000757342346019*PriceSeries(Price,index-99,O,L,H,C)
                -0.000873340564341*PriceSeries(Price,index-100,O,L,H,C)
                -0.002350527823291*PriceSeries(Price,index-101,O,L,H,C)
                -0.00350726202203*PriceSeries(Price,index-102,O,L,H,C)
                -0.00421917832499*PriceSeries(Price,index-103,O,L,H,C)
                -0.00441757871746*PriceSeries(Price,index-104,O,L,H,C)
                -0.00409566188066*PriceSeries(Price,index-105,O,L,H,C)
                -0.00330733806476*PriceSeries(Price,index-106,O,L,H,C)
                -0.002159052728139*PriceSeries(Price,index-107,O,L,H,C)
                -0.000795732583705*PriceSeries(Price,index-108,O,L,H,C)
                +0.000617266384198*PriceSeries(Price,index-109,O,L,H,C)
                +0.001914037331504*PriceSeries(Price,index-110,O,L,H,C)
                +0.002947419127995*PriceSeries(Price,index-111,O,L,H,C)
                +0.00360552384076*PriceSeries(Price,index-112,O,L,H,C)
                +0.00382362214170*PriceSeries(Price,index-113,O,L,H,C)
                +0.00359019004208*PriceSeries(Price,index-114,O,L,H,C)
                +0.002946566401860*PriceSeries(Price,index-115,O,L,H,C)
                +0.001980477838693*PriceSeries(Price,index-116,O,L,H,C)
                +0.000814390182592*PriceSeries(Price,index-117,O,L,H,C)
                -0.000409838333892*PriceSeries(Price,index-118,O,L,H,C)
                -0.001548057547860*PriceSeries(Price,index-119,O,L,H,C)
                -0.002470648842444*PriceSeries(Price,index-120,O,L,H,C)
                -0.003077146545886*PriceSeries(Price,index-121,O,L,H,C)
                -0.00330699262847*PriceSeries(Price,index-122,O,L,H,C)
                -0.003145320177065*PriceSeries(Price,index-123,O,L,H,C)
                -0.002623233993723*PriceSeries(Price,index-124,O,L,H,C)
                -0.001812751544785*PriceSeries(Price,index-125,O,L,H,C)
                -0.000817131246714*PriceSeries(Price,index-126,O,L,H,C)
                +0.0002421130725716*PriceSeries(Price,index-127,O,L,H,C)
                +0.001239918389485*PriceSeries(Price,index-128,O,L,H,C)
                +0.002062314945568*PriceSeries(Price,index-129,O,L,H,C)
                +0.002619327934498*PriceSeries(Price,index-130,O,L,H,C)
                +0.002854654058901*PriceSeries(Price,index-131,O,L,H,C)
                +0.002751162635932*PriceSeries(Price,index-132,O,L,H,C)
                +0.002331611550847*PriceSeries(Price,index-133,O,L,H,C)
                +0.001654746806812*PriceSeries(Price,index-134,O,L,H,C)
                +0.000807329328006*PriceSeries(Price,index-135,O,L,H,C)
                -0.0001068442133430*PriceSeries(Price,index-136,O,L,H,C)
                -0.000979543625150*PriceSeries(Price,index-137,O,L,H,C)
                -0.001710816853394*PriceSeries(Price,index-138,O,L,H,C)
                -0.002220329839561*PriceSeries(Price,index-139,O,L,H,C)
                -0.002456072835796*PriceSeries(Price,index-140,O,L,H,C)
                -0.002399481455828*PriceSeries(Price,index-141,O,L,H,C)
                -0.002066519038687*PriceSeries(Price,index-142,O,L,H,C)
                -0.001504700013105*PriceSeries(Price,index-143,O,L,H,C)
                -0.000786560492226*PriceSeries(Price,index-144,O,L,H,C)
                -0.000000411887651535*PriceSeries(Price,index-145,O,L,H,C)
                +0.000760393661591*PriceSeries(Price,index-146,O,L,H,C)
                +0.001408504454387*PriceSeries(Price,index-147,O,L,H,C)
                +0.001872465493855*PriceSeries(Price,index-148,O,L,H,C)
                +0.002104517637925*PriceSeries(Price,index-149,O,L,H,C)
                +0.002085349279358*PriceSeries(Price,index-150,O,L,H,C)
                +0.001825408040076*PriceSeries(Price,index-151,O,L,H,C)
                +0.001362693038990*PriceSeries(Price,index-152,O,L,H,C)
                +0.000757455531251*PriceSeries(Price,index-153,O,L,H,C)
                +0.0000844629655505*PriceSeries(Price,index-154,O,L,H,C)
                -0.000576139334383*PriceSeries(Price,index-155,O,L,H,C)
                -0.001148310722050*PriceSeries(Price,index-156,O,L,H,C)
                -0.001568775672795*PriceSeries(Price,index-157,O,L,H,C)
                -0.001793944932744*PriceSeries(Price,index-158,O,L,H,C)
                -0.001804289653129*PriceSeries(Price,index-159,O,L,H,C)
                -0.001605803324664*PriceSeries(Price,index-160,O,L,H,C)
                -0.001228454241932*PriceSeries(Price,index-161,O,L,H,C)
                -0.000721879312686*PriceSeries(Price,index-162,O,L,H,C)
                -0.0001489945389391*PriceSeries(Price,index-163,O,L,H,C)
                +0.000421743582501*PriceSeries(Price,index-164,O,L,H,C)
                +0.000924472687941*PriceSeries(Price,index-165,O,L,H,C)
                +0.001303430989994*PriceSeries(Price,index-166,O,L,H,C)
                +0.001519082755176*PriceSeries(Price,index-167,O,L,H,C)
                +0.001552113285477*PriceSeries(Price,index-168,O,L,H,C)
                +0.001404990165212*PriceSeries(Price,index-169,O,L,H,C)
                +0.001100894262080*PriceSeries(Price,index-170,O,L,H,C)
                +0.000680347608973*PriceSeries(Price,index-171,O,L,H,C)
                +0.0001958966787910*PriceSeries(Price,index-172,O,L,H,C)
                -0.0002943532042713*PriceSeries(Price,index-173,O,L,H,C)
                -0.000733678025944*PriceSeries(Price,index-174,O,L,H,C)
                -0.001073197365502*PriceSeries(Price,index-175,O,L,H,C)
                -0.001277307900200*PriceSeries(Price,index-176,O,L,H,C)
                -0.001327231297331*PriceSeries(Price,index-177,O,L,H,C)
                -0.001222677357019*PriceSeries(Price,index-178,O,L,H,C)
                -0.000981153276010*PriceSeries(Price,index-179,O,L,H,C)
                -0.000635341394326*PriceSeries(Price,index-180,O,L,H,C)
                -0.0002287542337135*PriceSeries(Price,index-181,O,L,H,C)
                +0.0001896348598632*PriceSeries(Price,index-182,O,L,H,C)
                +0.000571275949314*PriceSeries(Price,index-183,O,L,H,C)
                +0.000873586895631*PriceSeries(Price,index-184,O,L,H,C)
                +0.001064677429188*PriceSeries(Price,index-185,O,L,H,C)
                +0.001126596762636*PriceSeries(Price,index-186,O,L,H,C)
                +0.001056931306129*PriceSeries(Price,index-187,O,L,H,C)
                +0.000868472297857*PriceSeries(Price,index-188,O,L,H,C)
                +0.000587220345362*PriceSeries(Price,index-189,O,L,H,C)
                +0.0002488783162482*PriceSeries(Price,index-190,O,L,H,C)
                -0.0001056244785402*PriceSeries(Price,index-191,O,L,H,C)
                -0.000434988860287*PriceSeries(Price,index-192,O,L,H,C)
                -0.000702351886981*PriceSeries(Price,index-193,O,L,H,C)
                -0.000879357475990*PriceSeries(Price,index-194,O,L,H,C)
                -0.000949053557029*PriceSeries(Price,index-195,O,L,H,C)
                -0.000907460394302*PriceSeries(Price,index-196,O,L,H,C)
                -0.000763494459820*PriceSeries(Price,index-197,O,L,H,C)
                -0.000537496885243*PriceSeries(Price,index-198,O,L,H,C)
                -0.0002584177007041*PriceSeries(Price,index-199,O,L,H,C)
                +0.0000397779093552*PriceSeries(Price,index-200,O,L,H,C)
                +0.000322243568029*PriceSeries(Price,index-201,O,L,H,C)
                +0.000557231332610*PriceSeries(Price,index-202,O,L,H,C)
                +0.000719661823530*PriceSeries(Price,index-203,O,L,H,C)
                +0.000793686555994*PriceSeries(Price,index-204,O,L,H,C)
                +0.000774219586581*PriceSeries(Price,index-205,O,L,H,C)
                +0.000666973958653*PriceSeries(Price,index-206,O,L,H,C)
                +0.000487582168446*PriceSeries(Price,index-207,O,L,H,C)
                +0.0002592414650436*PriceSeries(Price,index-208,O,L,H,C)
                +0.00000989660874565*PriceSeries(Price,index-209,O,L,H,C)
                -0.0002311958139878*PriceSeries(Price,index-210,O,L,H,C)
                -0.000436809418274*PriceSeries(Price,index-211,O,L,H,C)
                -0.000584835913130*PriceSeries(Price,index-212,O,L,H,C)
                -0.000660539623677*PriceSeries(Price,index-213,O,L,H,C)
                -0.000658004833816*PriceSeries(Price,index-214,O,L,H,C)
                -0.000580417901772*PriceSeries(Price,index-215,O,L,H,C)
                -0.000439418691515*PriceSeries(Price,index-216,O,L,H,C)
                -0.0002533942416053*PriceSeries(Price,index-217,O,L,H,C)
                -0.0000451921575275*PriceSeries(Price,index-218,O,L,H,C)
                +0.0001606995347240*PriceSeries(Price,index-219,O,L,H,C)
                +0.000340959091967*PriceSeries(Price,index-220,O,L,H,C)
                +0.000475943562382*PriceSeries(Price,index-221,O,L,H,C)
                +0.000551938612843*PriceSeries(Price,index-222,O,L,H,C)
                +0.000562314536709*PriceSeries(Price,index-223,O,L,H,C)
                +0.000508071863658*PriceSeries(Price,index-224,O,L,H,C)
                +0.000397504327570*PriceSeries(Price,index-225,O,L,H,C)
                +0.0002449290757354*PriceSeries(Price,index-226,O,L,H,C)
                +0.0000689266209905*PriceSeries(Price,index-227,O,L,H,C)
                -0.0001099298803450*PriceSeries(Price,index-228,O,L,H,C)
                -0.0002713487734198*PriceSeries(Price,index-229,O,L,H,C)
                -0.000397623120387*PriceSeries(Price,index-230,O,L,H,C)
                -0.000475434358464*PriceSeries(Price,index-231,O,L,H,C)
                -0.000497236376707*PriceSeries(Price,index-232,O,L,H,C)
                -0.000461817633619*PriceSeries(Price,index-233,O,L,H,C)
                -0.000374284593633*PriceSeries(Price,index-234,O,L,H,C)
                -0.0002451597859607*PriceSeries(Price,index-235,O,L,H,C)
                -0.0000894565856380*PriceSeries(Price,index-236,O,L,H,C)
                +0.0000756237771830*PriceSeries(Price,index-237,O,L,H,C)
                +0.0002319693068502*PriceSeries(Price,index-238,O,L,H,C)
                +0.000362787541096*PriceSeries(Price,index-239,O,L,H,C)
                +0.000454173466452*PriceSeries(Price,index-240,O,L,H,C)
                +0.000496448377870*PriceSeries(Price,index-241,O,L,H,C)
                +0.000484853017075*PriceSeries(Price,index-242,O,L,H,C)
                +0.000419886605811*PriceSeries(Price,index-243,O,L,H,C)
                +0.0003069719551354*PriceSeries(Price,index-244,O,L,H,C)
                +0.0001557782935182*PriceSeries(Price,index-245,O,L,H,C)
                -0.00002099630979397*PriceSeries(Price,index-246,O,L,H,C)
                -0.0002089289643792*PriceSeries(Price,index-247,O,L,H,C)
                -0.000393398765426*PriceSeries(Price,index-248,O,L,H,C)
                -0.000560848870037*PriceSeries(Price,index-249,O,L,H,C)
                -0.000699724689447*PriceSeries(Price,index-250,O,L,H,C)
                -0.000802348674468*PriceSeries(Price,index-251,O,L,H,C)
                -0.000863471626753*PriceSeries(Price,index-252,O,L,H,C)
                -0.000882326599529*PriceSeries(Price,index-253,O,L,H,C)
                -0.000861452740924*PriceSeries(Price,index-254,O,L,H,C)
                -0.000806161096021*PriceSeries(Price,index-255,O,L,H,C)
                -0.000723863126777*PriceSeries(Price,index-256,O,L,H,C)
                -0.000623180261791*PriceSeries(Price,index-257,O,L,H,C)
                -0.000513147257397*PriceSeries(Price,index-258,O,L,H,C)
                -0.000402295827258*PriceSeries(Price,index-259,O,L,H,C)
                -0.0002980561523812*PriceSeries(Price,index-260,O,L,H,C)
                -0.0002062676593520*PriceSeries(Price,index-261,O,L,H,C)
                -0.0001311784225159*PriceSeries(Price,index-262,O,L,H,C)
                -0.0000756609331916*PriceSeries(Price,index-263,O,L,H,C)
                -0.0000420629271095*PriceSeries(Price,index-264,O,L,H,C)
                +0.0000921622435508*PriceSeries(Price,index-265,O,L,H,C)
                );

      case N20:
         return(
                0.1963908974546*PriceSeries(Price,index,O,L,H,C)
                +0.1925747742966*PriceSeries(Price,index-1,O,L,H,C)
                +0.1813935930175*PriceSeries(Price,index-2,O,L,H,C)
                +0.1636265948990*PriceSeries(Price,index-3,O,L,H,C)
                +0.1405001408663*PriceSeries(Price,index-4,O,L,H,C)
                +0.1135860812777*PriceSeries(Price,index-5,O,L,H,C)
                +0.0846726507977*PriceSeries(Price,index-6,O,L,H,C)
                +0.0556195345841*PriceSeries(Price,index-7,O,L,H,C)
                +0.02821006458929*PriceSeries(Price,index-8,O,L,H,C)
                +0.00401358801059*PriceSeries(Price,index-9,O,L,H,C)
                -0.01573009219719*PriceSeries(Price,index-10,O,L,H,C)
                -0.03019454821932*PriceSeries(Price,index-11,O,L,H,C)
                -0.0390122871402*PriceSeries(Price,index-12,O,L,H,C)
                -0.0422791683913*PriceSeries(Price,index-13,O,L,H,C)
                -0.0405186728231*PriceSeries(Price,index-14,O,L,H,C)
                -0.0346106990630*PriceSeries(Price,index-15,O,L,H,C)
                -0.02569270863156*PriceSeries(Price,index-16,O,L,H,C)
                -0.01504335806680*PriceSeries(Price,index-17,O,L,H,C)
                -0.00396003852208*PriceSeries(Price,index-18,O,L,H,C)
                +0.00635810783199*PriceSeries(Price,index-19,O,L,H,C)
                +0.01491109384236*PriceSeries(Price,index-20,O,L,H,C)
                +0.02097427449736*PriceSeries(Price,index-21,O,L,H,C)
                +0.02414390210485*PriceSeries(Price,index-22,O,L,H,C)
                +0.02434934089987*PriceSeries(Price,index-23,O,L,H,C)
                +0.02183258046646*PriceSeries(Price,index-24,O,L,H,C)
                +0.01709884160490*PriceSeries(Price,index-25,O,L,H,C)
                +0.01084472109740*PriceSeries(Price,index-26,O,L,H,C)
                +0.00387222566442*PriceSeries(Price,index-27,O,L,H,C)
                -0.003001963740456*PriceSeries(Price,index-28,O,L,H,C)
                -0.00903264419521*PriceSeries(Price,index-29,O,L,H,C)
                -0.01361923729221*PriceSeries(Price,index-30,O,L,H,C)
                -0.01635924965914*PriceSeries(Price,index-31,O,L,H,C)
                -0.01707771112289*PriceSeries(Price,index-32,O,L,H,C)
                -0.01583093530756*PriceSeries(Price,index-33,O,L,H,C)
                -0.01288567639490*PriceSeries(Price,index-34,O,L,H,C)
                -0.00867724853386*PriceSeries(Price,index-35,O,L,H,C)
                -0.00375218233674*PriceSeries(Price,index-36,O,L,H,C)
                +0.001297672679912*PriceSeries(Price,index-37,O,L,H,C)
                +0.00590214121764*PriceSeries(Price,index-38,O,L,H,C)
                +0.00957361212919*PriceSeries(Price,index-39,O,L,H,C)
                +0.01195563375408*PriceSeries(Price,index-40,O,L,H,C)
                +0.01285463991384*PriceSeries(Price,index-41,O,L,H,C)
                +0.01225226059785*PriceSeries(Price,index-42,O,L,H,C)
                +0.01029787897630*PriceSeries(Price,index-43,O,L,H,C)
                +0.00728323949845*PriceSeries(Price,index-44,O,L,H,C)
                +0.00360276373540*PriceSeries(Price,index-45,O,L,H,C)
                -0.0002953950019006*PriceSeries(Price,index-46,O,L,H,C)
                -0.00396175804290*PriceSeries(Price,index-47,O,L,H,C)
                -0.00699548207969*PriceSeries(Price,index-48,O,L,H,C)
                -0.00908650757491*PriceSeries(Price,index-49,O,L,H,C)
                -0.01004562872863*PriceSeries(Price,index-50,O,L,H,C)
                -0.00981973669402*PriceSeries(Price,index-51,O,L,H,C)
                -0.00849124013388*PriceSeries(Price,index-52,O,L,H,C)
                -0.00626245309872*PriceSeries(Price,index-53,O,L,H,C)
                -0.00342736253432*PriceSeries(Price,index-54,O,L,H,C)
                -0.000334475206754*PriceSeries(Price,index-55,O,L,H,C)
                +0.002654731106429*PriceSeries(Price,index-56,O,L,H,C)
                +0.00520693651829*PriceSeries(Price,index-57,O,L,H,C)
                +0.00705312637495*PriceSeries(Price,index-58,O,L,H,C)
                +0.00801594411234*PriceSeries(Price,index-59,O,L,H,C)
                +0.00802557719041*PriceSeries(Price,index-60,O,L,H,C)
                +0.00712289373368*PriceSeries(Price,index-61,O,L,H,C)
                +0.00545002313118*PriceSeries(Price,index-62,O,L,H,C)
                +0.00322996776603*PriceSeries(Price,index-63,O,L,H,C)
                +0.000737993231896*PriceSeries(Price,index-64,O,L,H,C)
                -0.001731649213775*PriceSeries(Price,index-65,O,L,H,C)
                -0.00389973737273*PriceSeries(Price,index-66,O,L,H,C)
                -0.00553297723510*PriceSeries(Price,index-67,O,L,H,C)
                -0.00646843993106*PriceSeries(Price,index-68,O,L,H,C)
                -0.00662905120519*PriceSeries(Price,index-69,O,L,H,C)
                -0.00602875397794*PriceSeries(Price,index-70,O,L,H,C)
                -0.00476718143883*PriceSeries(Price,index-71,O,L,H,C)
                -0.003014865404093*PriceSeries(Price,index-72,O,L,H,C)
                -0.000991030252534*PriceSeries(Price,index-73,O,L,H,C)
                +0.001063222684598*PriceSeries(Price,index-74,O,L,H,C)
                +0.002913126439373*PriceSeries(Price,index-75,O,L,H,C)
                +0.00435661076619*PriceSeries(Price,index-76,O,L,H,C)
                +0.00524590711671*PriceSeries(Price,index-77,O,L,H,C)
                +0.00550213943934*PriceSeries(Price,index-78,O,L,H,C)
                +0.00512152559556*PriceSeries(Price,index-79,O,L,H,C)
                +0.00417281713658*PriceSeries(Price,index-80,O,L,H,C)
                +0.002786611456499*PriceSeries(Price,index-81,O,L,H,C)
                +0.001138066308713*PriceSeries(Price,index-82,O,L,H,C)
                -0.000574764758593*PriceSeries(Price,index-83,O,L,H,C)
                -0.002154346741678*PriceSeries(Price,index-84,O,L,H,C)
                -0.00342610119765*PriceSeries(Price,index-85,O,L,H,C)
                -0.00425735781979*PriceSeries(Price,index-86,O,L,H,C)
                -0.00457080180879*PriceSeries(Price,index-87,O,L,H,C)
                -0.00435110204810*PriceSeries(Price,index-88,O,L,H,C)
                -0.00364423067593*PriceSeries(Price,index-89,O,L,H,C)
                -0.002549834308823*PriceSeries(Price,index-90,O,L,H,C)
                -0.001207793337698*PriceSeries(Price,index-91,O,L,H,C)
                +0.0002192767483054*PriceSeries(Price,index-92,O,L,H,C)
                +0.001565433313521*PriceSeries(Price,index-93,O,L,H,C)
                +0.002680440056445*PriceSeries(Price,index-94,O,L,H,C)
                +0.00344627262865*PriceSeries(Price,index-95,O,L,H,C)
                +0.00378931355119*PriceSeries(Price,index-96,O,L,H,C)
                +0.00368701294670*PriceSeries(Price,index-97,O,L,H,C)
                +0.00316846928504*PriceSeries(Price,index-98,O,L,H,C)
                +0.002309098721666*PriceSeries(Price,index-99,O,L,H,C)
                +0.001220229417273*PriceSeries(Price,index-100,O,L,H,C)
                +0.0000350038949408*PriceSeries(Price,index-101,O,L,H,C)
                -0.001107659392365*PriceSeries(Price,index-102,O,L,H,C)
                -0.002079139699457*PriceSeries(Price,index-103,O,L,H,C)
                -0.002775386511195*PriceSeries(Price,index-104,O,L,H,C)
                -0.003127831296996*PriceSeries(Price,index-105,O,L,H,C)
                -0.003109822973720*PriceSeries(Price,index-106,O,L,H,C)
                -0.002738025862232*PriceSeries(Price,index-107,O,L,H,C)
                -0.002068816278352*PriceSeries(Price,index-108,O,L,H,C)
                -0.001190284452399*PriceSeries(Price,index-109,O,L,H,C)
                -0.0002109274789983*PriceSeries(Price,index-110,O,L,H,C)
                +0.000753545005006*PriceSeries(Price,index-111,O,L,H,C)
                +0.001593710228646*PriceSeries(Price,index-112,O,L,H,C)
                +0.002218681113542*PriceSeries(Price,index-113,O,L,H,C)
                +0.002565752650678*PriceSeries(Price,index-114,O,L,H,C)
                +0.002606444990954*PriceSeries(Price,index-115,O,L,H,C)
                +0.002348394224459*PriceSeries(Price,index-116,O,L,H,C)
                +0.001833038560458*PriceSeries(Price,index-117,O,L,H,C)
                +0.001129531118984*PriceSeries(Price,index-118,O,L,H,C)
                +0.000325726011965*PriceSeries(Price,index-119,O,L,H,C)
                -0.000482613753988*PriceSeries(Price,index-120,O,L,H,C)
                -0.001203080134290*PriceSeries(Price,index-121,O,L,H,C)
                -0.001757047216458*PriceSeries(Price,index-122,O,L,H,C)
                -0.002088101032689*PriceSeries(Price,index-123,O,L,H,C)
                -0.002167586652230*PriceSeries(Price,index-124,O,L,H,C)
                -0.001996753531803*PriceSeries(Price,index-125,O,L,H,C)
                -0.001605391148213*PriceSeries(Price,index-126,O,L,H,C)
                -0.001047253504142*PriceSeries(Price,index-127,O,L,H,C)
                -0.000392927287535*PriceSeries(Price,index-128,O,L,H,C)
                +0.0002789344785515*PriceSeries(Price,index-129,O,L,H,C)
                +0.000890941340744*PriceSeries(Price,index-130,O,L,H,C)
                +0.001375764478281*PriceSeries(Price,index-131,O,L,H,C)
                +0.001683419173990*PriceSeries(Price,index-132,O,L,H,C)
                +0.001786258225449*PriceSeries(Price,index-133,O,L,H,C)
                +0.001681198398811*PriceSeries(Price,index-134,O,L,H,C)
                +0.001389039901660*PriceSeries(Price,index-135,O,L,H,C)
                +0.000951078606615*PriceSeries(Price,index-136,O,L,H,C)
                +0.000423512997092*PriceSeries(Price,index-137,O,L,H,C)
                -0.0001296199453913*PriceSeries(Price,index-138,O,L,H,C)
                -0.000644107084719*PriceSeries(Price,index-139,O,L,H,C)
                -0.001062914801935*PriceSeries(Price,index-140,O,L,H,C)
                -0.001342407023113*PriceSeries(Price,index-141,O,L,H,C)
                -0.001456760767363*PriceSeries(Price,index-142,O,L,H,C)
                -0.001400149474991*PriceSeries(Price,index-143,O,L,H,C)
                -0.001186539296448*PriceSeries(Price,index-144,O,L,H,C)
                -0.000847225110659*PriceSeries(Price,index-145,O,L,H,C)
                -0.000426487622129*PriceSeries(Price,index-146,O,L,H,C)
                +0.00002404799731451*PriceSeries(Price,index-147,O,L,H,C)
                +0.000451647454202*PriceSeries(Price,index-148,O,L,H,C)
                +0.000808554138724*PriceSeries(Price,index-149,O,L,H,C)
                +0.001057234409317*PriceSeries(Price,index-150,O,L,H,C)
                +0.001174216267505*PriceSeries(Price,index-151,O,L,H,C)
                +0.001152143357889*PriceSeries(Price,index-152,O,L,H,C)
                +0.000999887924411*PriceSeries(Price,index-153,O,L,H,C)
                +0.000740796658524*PriceSeries(Price,index-154,O,L,H,C)
                +0.000409355583632*PriceSeries(Price,index-155,O,L,H,C)
                +0.0000467294032100*PriceSeries(Price,index-156,O,L,H,C)
                -0.0003042608451405*PriceSeries(Price,index-157,O,L,H,C)
                -0.000604119081587*PriceSeries(Price,index-158,O,L,H,C)
                -0.000821043336644*PriceSeries(Price,index-159,O,L,H,C)
                -0.000934208269769*PriceSeries(Price,index-160,O,L,H,C)
                -0.000935634280869*PriceSeries(Price,index-161,O,L,H,C)
                -0.000830494611517*PriceSeries(Price,index-162,O,L,H,C)
                -0.000635898108602*PriceSeries(Price,index-163,O,L,H,C)
                -0.000378359101737*PriceSeries(Price,index-164,O,L,H,C)
                -0.0000903079507486*PriceSeries(Price,index-165,O,L,H,C)
                +0.0001939101040508*PriceSeries(Price,index-166,O,L,H,C)
                +0.000442063127542*PriceSeries(Price,index-167,O,L,H,C)
                +0.000627623237386*PriceSeries(Price,index-168,O,L,H,C)
                +0.000732527417898*PriceSeries(Price,index-169,O,L,H,C)
                +0.000748830394659*PriceSeries(Price,index-170,O,L,H,C)
                +0.000679113687624*PriceSeries(Price,index-171,O,L,H,C)
                +0.000535665339948*PriceSeries(Price,index-172,O,L,H,C)
                +0.000338585190704*PriceSeries(Price,index-173,O,L,H,C)
                +0.0001130867854537*PriceSeries(Price,index-174,O,L,H,C)
                -0.0001136527540416*PriceSeries(Price,index-175,O,L,H,C)
                -0.0003157086435257*PriceSeries(Price,index-176,O,L,H,C)
                -0.000471316544555*PriceSeries(Price,index-177,O,L,H,C)
                -0.000565153900884*PriceSeries(Price,index-178,O,L,H,C)
                -0.000589763171594*PriceSeries(Price,index-179,O,L,H,C)
                -0.000545996367844*PriceSeries(Price,index-180,O,L,H,C)
                -0.000442480653212*PriceSeries(Price,index-181,O,L,H,C)
                -0.0002942182371303*PriceSeries(Price,index-182,O,L,H,C)
                -0.0001205269591943*PriceSeries(Price,index-183,O,L,H,C)
                +0.0000574068334142*PriceSeries(Price,index-184,O,L,H,C)
                +0.0002190597997413*PriceSeries(Price,index-185,O,L,H,C)
                +0.000346890169093*PriceSeries(Price,index-186,O,L,H,C)
                +0.000428187667316*PriceSeries(Price,index-187,O,L,H,C)
                +0.000456267353977*PriceSeries(Price,index-188,O,L,H,C)
                +0.000430904692962*PriceSeries(Price,index-189,O,L,H,C)
                +0.000358002251528*PriceSeries(Price,index-190,O,L,H,C)
                +0.0002485692639655*PriceSeries(Price,index-191,O,L,H,C)
                +0.0001171707930448*PriceSeries(Price,index-192,O,L,H,C)
                -0.00001994539050242*PriceSeries(Price,index-193,O,L,H,C)
                -0.0001468106723027*PriceSeries(Price,index-194,O,L,H,C)
                -0.0002495538939765*PriceSeries(Price,index-195,O,L,H,C)
                -0.000317873040197*PriceSeries(Price,index-196,O,L,H,C)
                -0.000346010530332*PriceSeries(Price,index-197,O,L,H,C)
                -0.000333148877711*PriceSeries(Price,index-198,O,L,H,C)
                -0.0002832137939436*PriceSeries(Price,index-199,O,L,H,C)
                -0.0002041408663355*PriceSeries(Price,index-200,O,L,H,C)
                -0.0001067228205105*PriceSeries(Price,index-201,O,L,H,C)
                -0.00000319682842388*PriceSeries(Price,index-202,O,L,H,C)
                +0.0000942497676722*PriceSeries(Price,index-203,O,L,H,C)
                +0.0001748785709605*PriceSeries(Price,index-204,O,L,H,C)
                +0.0002305468338857*PriceSeries(Price,index-205,O,L,H,C)
                +0.0002564826764459*PriceSeries(Price,index-206,O,L,H,C)
                +0.0002516224541224*PriceSeries(Price,index-207,O,L,H,C)
                +0.0002184996597492*PriceSeries(Price,index-208,O,L,H,C)
                +0.0001627252456167*PriceSeries(Price,index-209,O,L,H,C)
                +0.0000921436684803*PriceSeries(Price,index-210,O,L,H,C)
                +0.00001578415206804*PriceSeries(Price,index-211,O,L,H,C)
                -0.0000572561096317*PriceSeries(Price,index-212,O,L,H,C)
                -0.0001188636441054*PriceSeries(Price,index-213,O,L,H,C)
                -0.0001627791767425*PriceSeries(Price,index-214,O,L,H,C)
                -0.0001851963555703*PriceSeries(Price,index-215,O,L,H,C)
                -0.0001850347796843*PriceSeries(Price,index-216,O,L,H,C)
                -0.0001638783450566*PriceSeries(Price,index-217,O,L,H,C)
                -0.0001256108206201*PriceSeries(Price,index-218,O,L,H,C)
                -0.0000758101884305*PriceSeries(Price,index-219,O,L,H,C)
                -0.00002098605945116*PriceSeries(Price,index-220,O,L,H,C)
                +0.0000322388164977*PriceSeries(Price,index-221,O,L,H,C)
                +0.0000779007365581*PriceSeries(Price,index-222,O,L,H,C)
                +0.0001113355649172*PriceSeries(Price,index-223,O,L,H,C)
                +0.0001296252519850*PriceSeries(Price,index-224,O,L,H,C)
                +0.0001318101761382*PriceSeries(Price,index-225,O,L,H,C)
                +0.0001188554411125*PriceSeries(Price,index-226,O,L,H,C)
                +0.0000933944753557*PriceSeries(Price,index-227,O,L,H,C)
                +0.0000593001355230*PriceSeries(Price,index-228,O,L,H,C)
                +0.00002114415437205*PriceSeries(Price,index-229,O,L,H,C)
                -0.00001638811011357*PriceSeries(Price,index-230,O,L,H,C)
                -0.0000490533336945*PriceSeries(Price,index-231,O,L,H,C)
                -0.0000735077016850*PriceSeries(Price,index-232,O,L,H,C)
                -0.0000876220734282*PriceSeries(Price,index-233,O,L,H,C)
                -0.0000906347255891*PriceSeries(Price,index-234,O,L,H,C)
                -0.0000831335157515*PriceSeries(Price,index-235,O,L,H,C)
                -0.0000668755844515*PriceSeries(Price,index-236,O,L,H,C)
                -0.0000444817047348*PriceSeries(Price,index-237,O,L,H,C)
                -0.00001906028591148*PriceSeries(Price,index-238,O,L,H,C)
                +0.00000619170600688*PriceSeries(Price,index-239,O,L,H,C)
                +0.00002837195751985*PriceSeries(Price,index-240,O,L,H,C)
                +0.0000451924388312*PriceSeries(Price,index-241,O,L,H,C)
                +0.0000551899695088*PriceSeries(Price,index-242,O,L,H,C)
                +0.0000578155142749*PriceSeries(Price,index-243,O,L,H,C)
                +0.0000534179838380*PriceSeries(Price,index-244,O,L,H,C)
                +0.0000431301095712*PriceSeries(Price,index-245,O,L,H,C)
                +0.00002865821308767*PriceSeries(Price,index-246,O,L,H,C)
                +0.00001201244262167*PriceSeries(Price,index-247,O,L,H,C)
                -0.00000475850023573*PriceSeries(Price,index-248,O,L,H,C)
                -0.00001979870902662*PriceSeries(Price,index-249,O,L,H,C)
                -0.0000316545357571*PriceSeries(Price,index-250,O,L,H,C)
                -0.0000394422421027*PriceSeries(Price,index-251,O,L,H,C)
                -0.0000429067412877*PriceSeries(Price,index-252,O,L,H,C)
                -0.0000423588547002*PriceSeries(Price,index-253,O,L,H,C)
                -0.0000385803090441*PriceSeries(Price,index-254,O,L,H,C)
                -0.0000327588915231*PriceSeries(Price,index-255,O,L,H,C)
                -0.00002637798284075*PriceSeries(Price,index-256,O,L,H,C)
                -0.00002096320526199*PriceSeries(Price,index-257,O,L,H,C)
                -0.00001711617454071*PriceSeries(Price,index-258,O,L,H,C)
                +0.0001033990834410*PriceSeries(Price,index-259,O,L,H,C)
                );

      case N21:
         return(
                0.2047184705138*PriceSeries(Price,index,O,L,H,C)
                +0.1976409250494*PriceSeries(Price,index-1,O,L,H,C)
                +0.1839276141088*PriceSeries(Price,index-2,O,L,H,C)
                +0.1644291629021*PriceSeries(Price,index-3,O,L,H,C)
                +0.1403418766868*PriceSeries(Price,index-4,O,L,H,C)
                +0.1131194409186*PriceSeries(Price,index-5,O,L,H,C)
                +0.0843666575448*PriceSeries(Price,index-6,O,L,H,C)
                +0.0557237409965*PriceSeries(Price,index-7,O,L,H,C)
                +0.02875039855472*PriceSeries(Price,index-8,O,L,H,C)
                +0.00481879071453*PriceSeries(Price,index-9,O,L,H,C)
                -0.01497637412620*PriceSeries(Price,index-10,O,L,H,C)
                -0.02988393559610*PriceSeries(Price,index-11,O,L,H,C)
                -0.0395339429223*PriceSeries(Price,index-12,O,L,H,C)
                -0.0439447415454*PriceSeries(Price,index-13,O,L,H,C)
                -0.0434998398644*PriceSeries(Price,index-14,O,L,H,C)
                -0.0388974918780*PriceSeries(Price,index-15,O,L,H,C)
                -0.03107801266489*PriceSeries(Price,index-16,O,L,H,C)
                -0.02113560608421*PriceSeries(Price,index-17,O,L,H,C)
                -0.01022252978007*PriceSeries(Price,index-18,O,L,H,C)
                +0.000546199191124*PriceSeries(Price,index-19,O,L,H,C)
                +0.01017970633898*PriceSeries(Price,index-20,O,L,H,C)
                +0.01788288735876*PriceSeries(Price,index-21,O,L,H,C)
                +0.02310751304505*PriceSeries(Price,index-22,O,L,H,C)
                +0.02557945755648*PriceSeries(Price,index-23,O,L,H,C)
                +0.02530097308394*PriceSeries(Price,index-24,O,L,H,C)
                +0.02252905943283*PriceSeries(Price,index-25,O,L,H,C)
                +0.01773310213222*PriceSeries(Price,index-26,O,L,H,C)
                +0.01153654691786*PriceSeries(Price,index-27,O,L,H,C)
                +0.00464863394761*PriceSeries(Price,index-28,O,L,H,C)
                -0.002207231858755*PriceSeries(Price,index-29,O,L,H,C)
                -0.00836184336188*PriceSeries(Price,index-30,O,L,H,C)
                -0.01325936618107*PriceSeries(Price,index-31,O,L,H,C)
                -0.01650237073551*PriceSeries(Price,index-32,O,L,H,C)
                -0.01787946415029*PriceSeries(Price,index-33,O,L,H,C)
                -0.01737384110366*PriceSeries(Price,index-34,O,L,H,C)
                -0.01515305818624*PriceSeries(Price,index-35,O,L,H,C)
                -0.01154192756821*PriceSeries(Price,index-36,O,L,H,C)
                -0.00698202563359*PriceSeries(Price,index-37,O,L,H,C)
                -0.001982268136174*PriceSeries(Price,index-38,O,L,H,C)
                +0.002934242914141*PriceSeries(Price,index-39,O,L,H,C)
                +0.00728192337538*PriceSeries(Price,index-40,O,L,H,C)
                +0.01065802432002*PriceSeries(Price,index-41,O,L,H,C)
                +0.01277762940732*PriceSeries(Price,index-42,O,L,H,C)
                +0.01349538199050*PriceSeries(Price,index-43,O,L,H,C)
                +0.01281257251102*PriceSeries(Price,index-44,O,L,H,C)
                +0.01086954872423*PriceSeries(Price,index-45,O,L,H,C)
                +0.00792492166196*PriceSeries(Price,index-46,O,L,H,C)
                +0.00432417129506*PriceSeries(Price,index-47,O,L,H,C)
                +0.000461255509652*PriceSeries(Price,index-48,O,L,H,C)
                -0.00326277374222*PriceSeries(Price,index-49,O,L,H,C)
                -0.00647988183167*PriceSeries(Price,index-50,O,L,H,C)
                -0.00889009369778*PriceSeries(Price,index-51,O,L,H,C)
                -0.01028816893526*PriceSeries(Price,index-52,O,L,H,C)
                -0.01057973533968*PriceSeries(Price,index-53,O,L,H,C)
                -0.00978566846592*PriceSeries(Price,index-54,O,L,H,C)
                -0.00803486991480*PriceSeries(Price,index-55,O,L,H,C)
                -0.00554659317376*PriceSeries(Price,index-56,O,L,H,C)
                -0.002604575925732*PriceSeries(Price,index-57,O,L,H,C)
                +0.000474191010327*PriceSeries(Price,index-58,O,L,H,C)
                +0.00337262089736*PriceSeries(Price,index-59,O,L,H,C)
                +0.00580536542446*PriceSeries(Price,index-60,O,L,H,C)
                +0.00754608209273*PriceSeries(Price,index-61,O,L,H,C)
                +0.00844771952395*PriceSeries(Price,index-62,O,L,H,C)
                +0.00845398071684*PriceSeries(Price,index-63,O,L,H,C)
                +0.00760126615054*PriceSeries(Price,index-64,O,L,H,C)
                +0.00601119473534*PriceSeries(Price,index-65,O,L,H,C)
                +0.00387491782103*PriceSeries(Price,index-66,O,L,H,C)
                +0.001431031957969*PriceSeries(Price,index-67,O,L,H,C)
                -0.001060351849823*PriceSeries(Price,index-68,O,L,H,C)
                -0.00334472967887*PriceSeries(Price,index-69,O,L,H,C)
                -0.00519863529730*PriceSeries(Price,index-70,O,L,H,C)
                -0.00645100333429*PriceSeries(Price,index-71,O,L,H,C)
                -0.00699838226594*PriceSeries(Price,index-72,O,L,H,C)
                -0.00681276392659*PriceSeries(Price,index-73,O,L,H,C)
                -0.00594147944097*PriceSeries(Price,index-74,O,L,H,C)
                -0.00449952087583*PriceSeries(Price,index-75,O,L,H,C)
                -0.002655286719714*PriceSeries(Price,index-76,O,L,H,C)
                -0.000611517986908*PriceSeries(Price,index-77,O,L,H,C)
                +0.001416561173826*PriceSeries(Price,index-78,O,L,H,C)
                +0.00322349421262*PriceSeries(Price,index-79,O,L,H,C)
                +0.00463406276888*PriceSeries(Price,index-80,O,L,H,C)
                +0.00551988302759*PriceSeries(Price,index-81,O,L,H,C)
                +0.00581068421841*PriceSeries(Price,index-82,O,L,H,C)
                +0.00549924264287*PriceSeries(Price,index-83,O,L,H,C)
                +0.00463977559981*PriceSeries(Price,index-84,O,L,H,C)
                +0.00334012917045*PriceSeries(Price,index-85,O,L,H,C)
                +0.001748873764162*PriceSeries(Price,index-86,O,L,H,C)
                +0.0000386740644007*PriceSeries(Price,index-87,O,L,H,C)
                -0.001612100214535*PriceSeries(Price,index-88,O,L,H,C)
                -0.003037731198476*PriceSeries(Price,index-89,O,L,H,C)
                -0.00410149868186*PriceSeries(Price,index-90,O,L,H,C)
                -0.00470852677390*PriceSeries(Price,index-91,O,L,H,C)
                -0.00481386916472*PriceSeries(Price,index-92,O,L,H,C)
                -0.00442526779368*PriceSeries(Price,index-93,O,L,H,C)
                -0.00360041522241*PriceSeries(Price,index-94,O,L,H,C)
                -0.002439279259252*PriceSeries(Price,index-95,O,L,H,C)
                -0.001072368636872*PriceSeries(Price,index-96,O,L,H,C)
                +0.000353633409750*PriceSeries(Price,index-97,O,L,H,C)
                +0.001691410059392*PriceSeries(Price,index-98,O,L,H,C)
                +0.002808008174256*PriceSeries(Price,index-99,O,L,H,C)
                +0.00359784946981*PriceSeries(Price,index-100,O,L,H,C)
                +0.00399247935373*PriceSeries(Price,index-101,O,L,H,C)
                +0.00396618467339*PriceSeries(Price,index-102,O,L,H,C)
                +0.00353704403941*PriceSeries(Price,index-103,O,L,H,C)
                +0.002763504053481*PriceSeries(Price,index-104,O,L,H,C)
                +0.001736936986463*PriceSeries(Price,index-105,O,L,H,C)
                +0.000571148956749*PriceSeries(Price,index-106,O,L,H,C)
                -0.000610047688852*PriceSeries(Price,index-107,O,L,H,C)
                -0.001685798117909*PriceSeries(Price,index-108,O,L,H,C)
                -0.002550426054439*PriceSeries(Price,index-109,O,L,H,C)
                -0.003123633011791*PriceSeries(Price,index-110,O,L,H,C)
                -0.00335775948161*PriceSeries(Price,index-111,O,L,H,C)
                -0.00324143896229*PriceSeries(Price,index-112,O,L,H,C)
                -0.002799441426195*PriceSeries(Price,index-113,O,L,H,C)
                -0.002088789446181*PriceSeries(Price,index-114,O,L,H,C)
                -0.001191792907728*PriceSeries(Price,index-115,O,L,H,C)
                -0.0002066970067539*PriceSeries(Price,index-116,O,L,H,C)
                +0.000762902245781*PriceSeries(Price,index-117,O,L,H,C)
                +0.001618832259012*PriceSeries(Price,index-118,O,L,H,C)
                +0.002278144352159*PriceSeries(Price,index-119,O,L,H,C)
                +0.002681017055101*PriceSeries(Price,index-120,O,L,H,C)
                +0.002795988338162*PriceSeries(Price,index-121,O,L,H,C)
                +0.002622116787518*PriceSeries(Price,index-122,O,L,H,C)
                +0.002187932082126*PriceSeries(Price,index-123,O,L,H,C)
                +0.001547431278580*PriceSeries(Price,index-124,O,L,H,C)
                +0.000773603677032*PriceSeries(Price,index-125,O,L,H,C)
                -0.0000497152537081*PriceSeries(Price,index-126,O,L,H,C)
                -0.000836803437976*PriceSeries(Price,index-127,O,L,H,C)
                -0.001508887360105*PriceSeries(Price,index-128,O,L,H,C)
                -0.002001892657863*PriceSeries(Price,index-129,O,L,H,C)
                -0.002272440731327*PriceSeries(Price,index-130,O,L,H,C)
                -0.002301480068389*PriceSeries(Price,index-131,O,L,H,C)
                -0.002095304252439*PriceSeries(Price,index-132,O,L,H,C)
                -0.001683942559996*PriceSeries(Price,index-133,O,L,H,C)
                -0.001117185145176*PriceSeries(Price,index-134,O,L,H,C)
                -0.000458741814682*PriceSeries(Price,index-135,O,L,H,C)
                +0.0002207950180562*PriceSeries(Price,index-136,O,L,H,C)
                +0.000851421521893*PriceSeries(Price,index-137,O,L,H,C)
                +0.001370840119229*PriceSeries(Price,index-138,O,L,H,C)
                +0.001730527535851*PriceSeries(Price,index-139,O,L,H,C)
                +0.001900138212524*PriceSeries(Price,index-140,O,L,H,C)
                +0.001869884771749*PriceSeries(Price,index-141,O,L,H,C)
                +0.001650752831999*PriceSeries(Price,index-142,O,L,H,C)
                +0.001272533320699*PriceSeries(Price,index-143,O,L,H,C)
                +0.000780053808505*PriceSeries(Price,index-144,O,L,H,C)
                +0.0002280022261508*PriceSeries(Price,index-145,O,L,H,C)
                -0.000325052989190*PriceSeries(Price,index-146,O,L,H,C)
                -0.000822786040369*PriceSeries(Price,index-147,O,L,H,C)
                -0.001216783354920*PriceSeries(Price,index-148,O,L,H,C)
                -0.001471155439154*PriceSeries(Price,index-149,O,L,H,C)
                -0.001565705081761*PriceSeries(Price,index-150,O,L,H,C)
                -0.001497337915043*PriceSeries(Price,index-151,O,L,H,C)
                -0.001279693311810*PriceSeries(Price,index-152,O,L,H,C)
                -0.000941060203029*PriceSeries(Price,index-153,O,L,H,C)
                -0.000520895992779*PriceSeries(Price,index-154,O,L,H,C)
                -0.0000653089670866*PriceSeries(Price,index-155,O,L,H,C)
                +0.000377868303178*PriceSeries(Price,index-156,O,L,H,C)
                +0.000764092607020*PriceSeries(Price,index-157,O,L,H,C)
                +0.001056472202622*PriceSeries(Price,index-158,O,L,H,C)
                +0.001229243683254*PriceSeries(Price,index-159,O,L,H,C)
                +0.001269907896445*PriceSeries(Price,index-160,O,L,H,C)
                +0.001179964707170*PriceSeries(Price,index-161,O,L,H,C)
                +0.000974143012549*PriceSeries(Price,index-162,O,L,H,C)
                +0.000678355838197*PriceSeries(Price,index-163,O,L,H,C)
                +0.000326551940979*PriceSeries(Price,index-164,O,L,H,C)
                -0.0000430714276660*PriceSeries(Price,index-165,O,L,H,C)
                -0.000392177279468*PriceSeries(Price,index-166,O,L,H,C)
                -0.000686172906100*PriceSeries(Price,index-167,O,L,H,C)
                -0.000897610221251*PriceSeries(Price,index-168,O,L,H,C)
                -0.001008664063865*PriceSeries(Price,index-169,O,L,H,C)
                -0.001012504904485*PriceSeries(Price,index-170,O,L,H,C)
                -0.000913532705935*PriceSeries(Price,index-171,O,L,H,C)
                -0.000726423332365*PriceSeries(Price,index-172,O,L,H,C)
                -0.000474154476820*PriceSeries(Price,index-173,O,L,H,C)
                -0.0001853149801650*PriceSeries(Price,index-174,O,L,H,C)
                +0.0001091003490477*PriceSeries(Price,index-175,O,L,H,C)
                +0.000378927961219*PriceSeries(Price,index-176,O,L,H,C)
                +0.000597910048796*PriceSeries(Price,index-177,O,L,H,C)
                +0.000746158151113*PriceSeries(Price,index-178,O,L,H,C)
                +0.000811925909882*PriceSeries(Price,index-179,O,L,H,C)
                +0.000792392252866*PriceSeries(Price,index-180,O,L,H,C)
                +0.000693561951700*PriceSeries(Price,index-181,O,L,H,C)
                +0.000529204505701*PriceSeries(Price,index-182,O,L,H,C)
                +0.000319151253269*PriceSeries(Price,index-183,O,L,H,C)
                +0.0000868732929752*PriceSeries(Price,index-184,O,L,H,C)
                -0.0001429710914276*PriceSeries(Price,index-185,O,L,H,C)
                -0.000347196970708*PriceSeries(Price,index-186,O,L,H,C)
                -0.000506323646484*PriceSeries(Price,index-187,O,L,H,C)
                -0.000606432019810*PriceSeries(Price,index-188,O,L,H,C)
                -0.000640267162774*PriceSeries(Price,index-189,O,L,H,C)
                -0.000607696349375*PriceSeries(Price,index-190,O,L,H,C)
                -0.000515322235478*PriceSeries(Price,index-191,O,L,H,C)
                -0.000375522628280*PriceSeries(Price,index-192,O,L,H,C)
                -0.0002048510065307*PriceSeries(Price,index-193,O,L,H,C)
                -0.00002218898483270*PriceSeries(Price,index-194,O,L,H,C)
                +0.0001533580441165*PriceSeries(Price,index-195,O,L,H,C)
                +0.0003043644928592*PriceSeries(Price,index-196,O,L,H,C)
                +0.000416784490540*PriceSeries(Price,index-197,O,L,H,C)
                +0.000481256884197*PriceSeries(Price,index-198,O,L,H,C)
                +0.000493766228286*PriceSeries(Price,index-199,O,L,H,C)
                +0.000455779299255*PriceSeries(Price,index-200,O,L,H,C)
                +0.000373838599806*PriceSeries(Price,index-201,O,L,H,C)
                +0.0002585767030973*PriceSeries(Price,index-202,O,L,H,C)
                +0.0001234715257277*PriceSeries(Price,index-203,O,L,H,C)
                -0.00001673952406077*PriceSeries(Price,index-204,O,L,H,C)
                -0.0001475724560298*PriceSeries(Price,index-205,O,L,H,C)
                -0.0002563190204953*PriceSeries(Price,index-206,O,L,H,C)
                -0.000333183795871*PriceSeries(Price,index-207,O,L,H,C)
                -0.000372181984941*PriceSeries(Price,index-208,O,L,H,C)
                -0.000371488110341*PriceSeries(Price,index-209,O,L,H,C)
                -0.000333449926193*PriceSeries(Price,index-210,O,L,H,C)
                -0.0002639798714685*PriceSeries(Price,index-211,O,L,H,C)
                -0.0001719694149661*PriceSeries(Price,index-212,O,L,H,C)
                -0.0000679881224714*PriceSeries(Price,index-213,O,L,H,C)
                +0.0000367353222442*PriceSeries(Price,index-214,O,L,H,C)
                +0.0001315943390908*PriceSeries(Price,index-215,O,L,H,C)
                +0.0002075743560120*PriceSeries(Price,index-216,O,L,H,C)
                +0.0002581444553023*PriceSeries(Price,index-217,O,L,H,C)
                +0.0002797086623623*PriceSeries(Price,index-218,O,L,H,C)
                +0.0002718658410393*PriceSeries(Price,index-219,O,L,H,C)
                +0.0002371881826437*PriceSeries(Price,index-220,O,L,H,C)
                +0.0001808460875177*PriceSeries(Price,index-221,O,L,H,C)
                +0.0001098502043206*PriceSeries(Price,index-222,O,L,H,C)
                +0.0000323088867227*PriceSeries(Price,index-223,O,L,H,C)
                -0.0000435319681925*PriceSeries(Price,index-224,O,L,H,C)
                -0.0001101953753118*PriceSeries(Price,index-225,O,L,H,C)
                -0.0001614857296545*PriceSeries(Price,index-226,O,L,H,C)
                -0.0001932402807216*PriceSeries(Price,index-227,O,L,H,C)
                -0.0002035460729391*PriceSeries(Price,index-228,O,L,H,C)
                -0.0001927628409945*PriceSeries(Price,index-229,O,L,H,C)
                -0.0001634007139392*PriceSeries(Price,index-230,O,L,H,C)
                -0.0001196463215109*PriceSeries(Price,index-231,O,L,H,C)
                -0.0000669011861643*PriceSeries(Price,index-232,O,L,H,C)
                -0.00001107403423796*PriceSeries(Price,index-233,O,L,H,C)
                +0.0000419801367881*PriceSeries(Price,index-234,O,L,H,C)
                +0.0000871327785228*PriceSeries(Price,index-235,O,L,H,C)
                +0.0001203786528610*PriceSeries(Price,index-236,O,L,H,C)
                +0.0001392231837944*PriceSeries(Price,index-237,O,L,H,C)
                +0.0001427202369640*PriceSeries(Price,index-238,O,L,H,C)
                +0.0001318315528212*PriceSeries(Price,index-239,O,L,H,C)
                +0.0001085156854847*PriceSeries(Price,index-240,O,L,H,C)
                +0.0000761275852740*PriceSeries(Price,index-241,O,L,H,C)
                +0.0000385845221818*PriceSeries(Price,index-242,O,L,H,C)
                +0.000000094091609828*PriceSeries(Price,index-243,O,L,H,C)
                -0.0000353925696238*PriceSeries(Price,index-244,O,L,H,C)
                -0.0000644823923454*PriceSeries(Price,index-245,O,L,H,C)
                -0.0000847203771556*PriceSeries(Price,index-246,O,L,H,C)
                -0.0000946819242758*PriceSeries(Price,index-247,O,L,H,C)
                -0.0000941173030586*PriceSeries(Price,index-248,O,L,H,C)
                -0.0000838031139689*PriceSeries(Price,index-249,O,L,H,C)
                -0.0000654627248746*PriceSeries(Price,index-250,O,L,H,C)
                -0.0000413930850733*PriceSeries(Price,index-251,O,L,H,C)
                -0.00001407986337463*PriceSeries(Price,index-252,O,L,H,C)
                +0.00001301877966178*PriceSeries(Price,index-253,O,L,H,C)
                +0.0000380419027005*PriceSeries(Price,index-254,O,L,H,C)
                +0.0000586946286684*PriceSeries(Price,index-255,O,L,H,C)
                +0.0000735259752400*PriceSeries(Price,index-256,O,L,H,C)
                +0.0000818234084556*PriceSeries(Price,index-257,O,L,H,C)
                +0.0000835708435678*PriceSeries(Price,index-258,O,L,H,C)
                +0.0000794762145820*PriceSeries(Price,index-259,O,L,H,C)
                +0.0000707510818220*PriceSeries(Price,index-260,O,L,H,C)
                +0.0000590278746613*PriceSeries(Price,index-261,O,L,H,C)
                +0.0000460805747736*PriceSeries(Price,index-262,O,L,H,C)
                +0.0000337342805566*PriceSeries(Price,index-263,O,L,H,C)
                +0.00002362634025216*PriceSeries(Price,index-264,O,L,H,C)
                +0.00001719087075760*PriceSeries(Price,index-265,O,L,H,C)
                -0.0001175200672180*PriceSeries(Price,index-266,O,L,H,C)
                );

      case N22:
         return(
                0.1781829549709*PriceSeries(Price,index,O,L,H,C)
                +0.1753876765916*PriceSeries(Price,index-1,O,L,H,C)
                +0.1671598537769*PriceSeries(Price,index-2,O,L,H,C)
                +0.1539628677412*PriceSeries(Price,index-3,O,L,H,C)
                +0.1365342844759*PriceSeries(Price,index-4,O,L,H,C)
                +0.1158364350078*PriceSeries(Price,index-5,O,L,H,C)
                +0.0929923829378*PriceSeries(Price,index-6,O,L,H,C)
                +0.0692119515260*PriceSeries(Price,index-7,O,L,H,C)
                +0.0457131716967*PriceSeries(Price,index-8,O,L,H,C)
                +0.02364478936820*PriceSeries(Price,index-9,O,L,H,C)
                +0.00401532079986*PriceSeries(Price,index-10,O,L,H,C)
                -0.01236642423839*PriceSeries(Price,index-11,O,L,H,C)
                -0.02493536367702*PriceSeries(Price,index-12,O,L,H,C)
                -0.0333959415638*PriceSeries(Price,index-13,O,L,H,C)
                -0.0377283476643*PriceSeries(Price,index-14,O,L,H,C)
                -0.0381752898886*PriceSeries(Price,index-15,O,L,H,C)
                -0.0352109009649*PriceSeries(Price,index-16,O,L,H,C)
                -0.02949465347750*PriceSeries(Price,index-17,O,L,H,C)
                -0.02181420324269*PriceSeries(Price,index-18,O,L,H,C)
                -0.01302179812753*PriceSeries(Price,index-19,O,L,H,C)
                -0.00396922795502*PriceSeries(Price,index-20,O,L,H,C)
                +0.00455376430599*PriceSeries(Price,index-21,O,L,H,C)
                +0.01187312801374*PriceSeries(Price,index-22,O,L,H,C)
                +0.01747249580034*PriceSeries(Price,index-23,O,L,H,C)
                +0.02102085122944*PriceSeries(Price,index-24,O,L,H,C)
                +0.02238442113173*PriceSeries(Price,index-25,O,L,H,C)
                +0.02162263017842*PriceSeries(Price,index-26,O,L,H,C)
                +0.01896921545664*PriceSeries(Price,index-27,O,L,H,C)
                +0.01480072497245*PriceSeries(Price,index-28,O,L,H,C)
                +0.00959553458562*PriceSeries(Price,index-29,O,L,H,C)
                +0.00388713799612*PriceSeries(Price,index-30,O,L,H,C)
                -0.001784238467758*PriceSeries(Price,index-31,O,L,H,C)
                -0.00691768682878*PriceSeries(Price,index-32,O,L,H,C)
                -0.01109169549730*PriceSeries(Price,index-33,O,L,H,C)
                -0.01399526706247*PriceSeries(Price,index-34,O,L,H,C)
                -0.01544796276440*PriceSeries(Price,index-35,O,L,H,C)
                -0.01540776972697*PriceSeries(Price,index-36,O,L,H,C)
                -0.01396675117788*PriceSeries(Price,index-37,O,L,H,C)
                -0.01133546367966*PriceSeries(Price,index-38,O,L,H,C)
                -0.00781802177983*PriceSeries(Price,index-39,O,L,H,C)
                -0.00378039667003*PriceSeries(Price,index-40,O,L,H,C)
                +0.000385009021525*PriceSeries(Price,index-41,O,L,H,C)
                +0.00429528531641*PriceSeries(Price,index-42,O,L,H,C)
                +0.00761031611312*PriceSeries(Price,index-43,O,L,H,C)
                +0.01006069954602*PriceSeries(Price,index-44,O,L,H,C)
                +0.01146811113964*PriceSeries(Price,index-45,O,L,H,C)
                +0.01175668418066*PriceSeries(Price,index-46,O,L,H,C)
                +0.01095482041484*PriceSeries(Price,index-47,O,L,H,C)
                +0.00918770349162*PriceSeries(Price,index-48,O,L,H,C)
                +0.00666158506983*PriceSeries(Price,index-49,O,L,H,C)
                +0.00364158807658*PriceSeries(Price,index-50,O,L,H,C)
                +0.000425269690288*PriceSeries(Price,index-51,O,L,H,C)
                -0.002685537584082*PriceSeries(Price,index-52,O,L,H,C)
                -0.00541203741356*PriceSeries(Price,index-53,O,L,H,C)
                -0.00752254496074*PriceSeries(Price,index-54,O,L,H,C)
                -0.00885131852889*PriceSeries(Price,index-55,O,L,H,C)
                -0.00931068570217*PriceSeries(Price,index-56,O,L,H,C)
                -0.00889565805326*PriceSeries(Price,index-57,O,L,H,C)
                -0.00768092387459*PriceSeries(Price,index-58,O,L,H,C)
                -0.00581079529494*PriceSeries(Price,index-59,O,L,H,C)
                -0.00348329074186*PriceSeries(Price,index-60,O,L,H,C)
                -0.000930012780737*PriceSeries(Price,index-61,O,L,H,C)
                +0.001606205829871*PriceSeries(Price,index-62,O,L,H,C)
                +0.00389379164420*PriceSeries(Price,index-63,O,L,H,C)
                +0.00573302173139*PriceSeries(Price,index-64,O,L,H,C)
                +0.00697293431047*PriceSeries(Price,index-65,O,L,H,C)
                +0.00752317174418*PriceSeries(Price,index-66,O,L,H,C)
                +0.00735987609551*PriceSeries(Price,index-67,O,L,H,C)
                +0.00652532650761*PriceSeries(Price,index-68,O,L,H,C)
                +0.00512158191756*PriceSeries(Price,index-69,O,L,H,C)
                +0.00329892885634*PriceSeries(Price,index-70,O,L,H,C)
                +0.001240369728246*PriceSeries(Price,index-71,O,L,H,C)
                -0.000856295825832*PriceSeries(Price,index-72,O,L,H,C)
                -0.002797081108502*PriceSeries(Price,index-73,O,L,H,C)
                -0.00440939914055*PriceSeries(Price,index-74,O,L,H,C)
                -0.00555706207311*PriceSeries(Price,index-75,O,L,H,C)
                -0.00615142265933*PriceSeries(Price,index-76,O,L,H,C)
                -0.00615777666934*PriceSeries(Price,index-77,O,L,H,C)
                -0.00559661089967*PriceSeries(Price,index-78,O,L,H,C)
                -0.00453976496531*PriceSeries(Price,index-79,O,L,H,C)
                -0.003102032766167*PriceSeries(Price,index-80,O,L,H,C)
                -0.001429130456391*PriceSeries(Price,index-81,O,L,H,C)
                +0.000316746601944*PriceSeries(Price,index-82,O,L,H,C)
                +0.001972372447184*PriceSeries(Price,index-83,O,L,H,C)
                +0.00338849959024*PriceSeries(Price,index-84,O,L,H,C)
                +0.00444307158571*PriceSeries(Price,index-85,O,L,H,C)
                +0.00505148843135*PriceSeries(Price,index-86,O,L,H,C)
                +0.00517308769193*PriceSeries(Price,index-87,O,L,H,C)
                +0.00481337423665*PriceSeries(Price,index-88,O,L,H,C)
                +0.00402194013045*PriceSeries(Price,index-89,O,L,H,C)
                +0.002886408385986*PriceSeries(Price,index-90,O,L,H,C)
                +0.001523088659695*PriceSeries(Price,index-91,O,L,H,C)
                +0.0000653151447231*PriceSeries(Price,index-92,O,L,H,C)
                -0.001349389168453*PriceSeries(Price,index-93,O,L,H,C)
                -0.002592102103181*PriceSeries(Price,index-94,O,L,H,C)
                -0.00355407445967*PriceSeries(Price,index-95,O,L,H,C)
                -0.00415606088859*PriceSeries(Price,index-96,O,L,H,C)
                -0.00435462649184*PriceSeries(Price,index-97,O,L,H,C)
                -0.00414495250367*PriceSeries(Price,index-98,O,L,H,C)
                -0.00355999401004*PriceSeries(Price,index-99,O,L,H,C)
                -0.002666190167221*PriceSeries(Price,index-100,O,L,H,C)
                -0.001556233750577*PriceSeries(Price,index-101,O,L,H,C)
                -0.000339662725204*PriceSeries(Price,index-102,O,L,H,C)
                +0.000867788516351*PriceSeries(Price,index-103,O,L,H,C)
                +0.001955059965890*PriceSeries(Price,index-104,O,L,H,C)
                +0.002825845919011*PriceSeries(Price,index-105,O,L,H,C)
                +0.00340698557268*PriceSeries(Price,index-106,O,L,H,C)
                +0.00365444503992*PriceSeries(Price,index-107,O,L,H,C)
                +0.00355641771018*PriceSeries(Price,index-108,O,L,H,C)
                +0.003133352241228*PriceSeries(Price,index-109,O,L,H,C)
                +0.002435003891698*PriceSeries(Price,index-110,O,L,H,C)
                +0.001534883110403*PriceSeries(Price,index-111,O,L,H,C)
                +0.000522693282641*PriceSeries(Price,index-112,O,L,H,C)
                -0.000504477519521*PriceSeries(Price,index-113,O,L,H,C)
                -0.001451356625346*PriceSeries(Price,index-114,O,L,H,C)
                -0.002233219025543*PriceSeries(Price,index-115,O,L,H,C)
                -0.002783358455174*PriceSeries(Price,index-116,O,L,H,C)
                -0.003058652874908*PriceSeries(Price,index-117,O,L,H,C)
                -0.003042767765665*PriceSeries(Price,index-118,O,L,H,C)
                -0.002746781813396*PriceSeries(Price,index-119,O,L,H,C)
                -0.002207262820987*PriceSeries(Price,index-120,O,L,H,C)
                -0.001482051281816*PriceSeries(Price,index-121,O,L,H,C)
                -0.000644219312952*PriceSeries(Price,index-122,O,L,H,C)
                +0.0002251808749489*PriceSeries(Price,index-123,O,L,H,C)
                +0.001044864335709*PriceSeries(Price,index-124,O,L,H,C)
                +0.001740827724501*PriceSeries(Price,index-125,O,L,H,C)
                +0.002252944698815*PriceSeries(Price,index-126,O,L,H,C)
                +0.002540058638682*PriceSeries(Price,index-127,O,L,H,C)
                +0.002583156410634*PriceSeries(Price,index-128,O,L,H,C)
                +0.002386389024688*PriceSeries(Price,index-129,O,L,H,C)
                +0.001975919400014*PriceSeries(Price,index-130,O,L,H,C)
                +0.001396772163424*PriceSeries(Price,index-131,O,L,H,C)
                +0.000708043077127*PriceSeries(Price,index-132,O,L,H,C)
                -0.00002302911801327*PriceSeries(Price,index-133,O,L,H,C)
                -0.000727548886777*PriceSeries(Price,index-134,O,L,H,C)
                -0.001341385079838*PriceSeries(Price,index-135,O,L,H,C)
                -0.001810938416970*PriceSeries(Price,index-136,O,L,H,C)
                -0.002097740970047*PriceSeries(Price,index-137,O,L,H,C)
                -0.002181500865249*PriceSeries(Price,index-138,O,L,H,C)
                -0.002061366912198*PriceSeries(Price,index-139,O,L,H,C)
                -0.001755348035920*PriceSeries(Price,index-140,O,L,H,C)
                -0.001298009941700*PriceSeries(Price,index-141,O,L,H,C)
                -0.000736717842500*PriceSeries(Price,index-142,O,L,H,C)
                -0.0001268229699844*PriceSeries(Price,index-143,O,L,H,C)
                +0.000473725478716*PriceSeries(Price,index-144,O,L,H,C)
                +0.001009828742778*PriceSeries(Price,index-145,O,L,H,C)
                +0.001434232123827*PriceSeries(Price,index-146,O,L,H,C)
                +0.001711624688694*PriceSeries(Price,index-147,O,L,H,C)
                +0.001821492670660*PriceSeries(Price,index-148,O,L,H,C)
                +0.001759504655439*PriceSeries(Price,index-149,O,L,H,C)
                +0.001537353027336*PriceSeries(Price,index-150,O,L,H,C)
                +0.001181115305282*PriceSeries(Price,index-151,O,L,H,C)
                +0.000728345738538*PriceSeries(Price,index-152,O,L,H,C)
                +0.0002242011958229*PriceSeries(Price,index-153,O,L,H,C)
                -0.0002830012197368*PriceSeries(Price,index-154,O,L,H,C)
                -0.000746361362062*PriceSeries(Price,index-155,O,L,H,C)
                -0.001124683423216*PriceSeries(Price,index-156,O,L,H,C)
                -0.001386081578774*PriceSeries(Price,index-157,O,L,H,C)
                -0.001510601296418*PriceSeries(Price,index-158,O,L,H,C)
                -0.001491639026447*PriceSeries(Price,index-159,O,L,H,C)
                -0.001336077044800*PriceSeries(Price,index-160,O,L,H,C)
                -0.001063167575943*PriceSeries(Price,index-161,O,L,H,C)
                -0.000702307314649*PriceSeries(Price,index-162,O,L,H,C)
                -0.0002899558369412*PriceSeries(Price,index-163,O,L,H,C)
                +0.0001339924279085*PriceSeries(Price,index-164,O,L,H,C)
                +0.000530018699099*PriceSeries(Price,index-165,O,L,H,C)
                +0.000862620142013*PriceSeries(Price,index-166,O,L,H,C)
                +0.001103449261595*PriceSeries(Price,index-167,O,L,H,C)
                +0.001233670890302*PriceSeries(Price,index-168,O,L,H,C)
                +0.001245356633591*PriceSeries(Price,index-169,O,L,H,C)
                +0.001141814663483*PriceSeries(Price,index-170,O,L,H,C)
                +0.000936870362653*PriceSeries(Price,index-171,O,L,H,C)
                +0.000653197614977*PriceSeries(Price,index-172,O,L,H,C)
                +0.000319890932470*PriceSeries(Price,index-173,O,L,H,C)
                -0.00003046018947575*PriceSeries(Price,index-174,O,L,H,C)
                -0.000364918642897*PriceSeries(Price,index-175,O,L,H,C)
                -0.000653258061845*PriceSeries(Price,index-176,O,L,H,C)
                -0.000870656832092*PriceSeries(Price,index-177,O,L,H,C)
                -0.000999787383012*PriceSeries(Price,index-178,O,L,H,C)
                -0.001032130221450*PriceSeries(Price,index-179,O,L,H,C)
                -0.000968428905776*PriceSeries(Price,index-180,O,L,H,C)
                -0.000818261591765*PriceSeries(Price,index-181,O,L,H,C)
                -0.000598816312407*PriceSeries(Price,index-182,O,L,H,C)
                -0.000333007595085*PriceSeries(Price,index-183,O,L,H,C)
                -0.0000471351308556*PriceSeries(Price,index-184,O,L,H,C)
                +0.0002316783901552*PriceSeries(Price,index-185,O,L,H,C)
                +0.000478031212834*PriceSeries(Price,index-186,O,L,H,C)
                +0.000670517339261*PriceSeries(Price,index-187,O,L,H,C)
                +0.000793549295103*PriceSeries(Price,index-188,O,L,H,C)
                +0.000838569602958*PriceSeries(Price,index-189,O,L,H,C)
                +0.000804560706270*PriceSeries(Price,index-190,O,L,H,C)
                +0.000697838977193*PriceSeries(Price,index-191,O,L,H,C)
                +0.000531171528099*PriceSeries(Price,index-192,O,L,H,C)
                +0.000322340353000*PriceSeries(Price,index-193,O,L,H,C)
                +0.0000922914236587*PriceSeries(Price,index-194,O,L,H,C)
                -0.0001369310278875*PriceSeries(Price,index-195,O,L,H,C)
                -0.000344262750316*PriceSeries(Price,index-196,O,L,H,C)
                -0.000511528601005*PriceSeries(Price,index-197,O,L,H,C)
                -0.000625000435846*PriceSeries(Price,index-198,O,L,H,C)
                -0.000676487284775*PriceSeries(Price,index-199,O,L,H,C)
                -0.000663856872090*PriceSeries(Price,index-200,O,L,H,C)
                -0.000590977597441*PriceSeries(Price,index-201,O,L,H,C)
                -0.000467112583478*PriceSeries(Price,index-202,O,L,H,C)
                -0.0003058302608775*PriceSeries(Price,index-203,O,L,H,C)
                -0.0001235709584160*PriceSeries(Price,index-204,O,L,H,C)
                +0.0000619991295611*PriceSeries(Price,index-205,O,L,H,C)
                +0.0002336689283638*PriceSeries(Price,index-206,O,L,H,C)
                +0.000376254706829*PriceSeries(Price,index-207,O,L,H,C)
                +0.000477920700895*PriceSeries(Price,index-208,O,L,H,C)
                +0.000531118267069*PriceSeries(Price,index-209,O,L,H,C)
                +0.000533099290041*PriceSeries(Price,index-210,O,L,H,C)
                +0.000485955630697*PriceSeries(Price,index-211,O,L,H,C)
                +0.000396215579834*PriceSeries(Price,index-212,O,L,H,C)
                +0.0002740417680529*PriceSeries(Price,index-213,O,L,H,C)
                +0.0001321235973909*PriceSeries(Price,index-214,O,L,H,C)
                -0.00001560049470682*PriceSeries(Price,index-215,O,L,H,C)
                -0.0001552956786340*PriceSeries(Price,index-216,O,L,H,C)
                -0.0002745006589633*PriceSeries(Price,index-217,O,L,H,C)
                -0.000363215198076*PriceSeries(Price,index-218,O,L,H,C)
                -0.000414708253374*PriceSeries(Price,index-219,O,L,H,C)
                -0.000425984675869*PriceSeries(Price,index-220,O,L,H,C)
                -0.000397900103824*PriceSeries(Price,index-221,O,L,H,C)
                -0.000334891352004*PriceSeries(Price,index-222,O,L,H,C)
                -0.0002444017980935*PriceSeries(Price,index-223,O,L,H,C)
                -0.0001360522811865*PriceSeries(Price,index-224,O,L,H,C)
                -0.00002064696969103*PriceSeries(Price,index-225,O,L,H,C)
                +0.0000908772174284*PriceSeries(Price,index-226,O,L,H,C)
                +0.0001884775713721*PriceSeries(Price,index-227,O,L,H,C)
                +0.0002638768101743*PriceSeries(Price,index-228,O,L,H,C)
                +0.0003112501557953*PriceSeries(Price,index-229,O,L,H,C)
                +0.000327645919585*PriceSeries(Price,index-230,O,L,H,C)
                +0.0003131079381860*PriceSeries(Price,index-231,O,L,H,C)
                +0.0002705254244760*PriceSeries(Price,index-232,O,L,H,C)
                +0.0002052136048669*PriceSeries(Price,index-233,O,L,H,C)
                +0.0001243172019491*PriceSeries(Price,index-234,O,L,H,C)
                +0.0000360486715289*PriceSeries(Price,index-235,O,L,H,C)
                -0.0000511262748778*PriceSeries(Price,index-236,O,L,H,C)
                -0.0001292731687003*PriceSeries(Price,index-237,O,L,H,C)
                -0.0001917062547220*PriceSeries(Price,index-238,O,L,H,C)
                -0.0002335315803959*PriceSeries(Price,index-239,O,L,H,C)
                -0.0002520165498593*PriceSeries(Price,index-240,O,L,H,C)
                -0.0002467118001222*PriceSeries(Price,index-241,O,L,H,C)
                -0.0002193725163936*PriceSeries(Price,index-242,O,L,H,C)
                -0.0001736968897323*PriceSeries(Price,index-243,O,L,H,C)
                -0.0001148625870363*PriceSeries(Price,index-244,O,L,H,C)
                -0.0000489802526096*PriceSeries(Price,index-245,O,L,H,C)
                +0.00001753454354722*PriceSeries(Price,index-246,O,L,H,C)
                +0.0000785570750521*PriceSeries(Price,index-247,O,L,H,C)
                +0.0001288061972458*PriceSeries(Price,index-248,O,L,H,C)
                +0.0001643014582030*PriceSeries(Price,index-249,O,L,H,C)
                +0.0001826282713035*PriceSeries(Price,index-250,O,L,H,C)
                +0.0001830962209395*PriceSeries(Price,index-251,O,L,H,C)
                +0.0001666963103393*PriceSeries(Price,index-252,O,L,H,C)
                +0.0001359190212320*PriceSeries(Price,index-253,O,L,H,C)
                +0.0000944261792394*PriceSeries(Price,index-254,O,L,H,C)
                +0.0000466246498349*PriceSeries(Price,index-255,O,L,H,C)
                -0.000002740189420625*PriceSeries(Price,index-256,O,L,H,C)
                -0.0000490728098485*PriceSeries(Price,index-257,O,L,H,C)
                -0.0000883254515929*PriceSeries(Price,index-258,O,L,H,C)
                -0.0001173407182773*PriceSeries(Price,index-259,O,L,H,C)
                -0.0001340957279193*PriceSeries(Price,index-260,O,L,H,C)
                -0.0001378078712421*PriceSeries(Price,index-261,O,L,H,C)
                -0.0001289784298204*PriceSeries(Price,index-262,O,L,H,C)
                -0.0001092020017303*PriceSeries(Price,index-263,O,L,H,C)
                -0.0000809751131220*PriceSeries(Price,index-264,O,L,H,C)
                -0.0000474228006096*PriceSeries(Price,index-265,O,L,H,C)
                -0.00001195337206334*PriceSeries(Price,index-266,O,L,H,C)
                +0.00002205442938081*PriceSeries(Price,index-267,O,L,H,C)
                +0.0000516231069354*PriceSeries(Price,index-268,O,L,H,C)
                +0.0000743401338436*PriceSeries(Price,index-269,O,L,H,C)
                +0.0000885915313663*PriceSeries(Price,index-270,O,L,H,C)
                +0.0000936659956397*PriceSeries(Price,index-271,O,L,H,C)
                +0.0000896980646080*PriceSeries(Price,index-272,O,L,H,C)
                +0.0000776622382939*PriceSeries(Price,index-273,O,L,H,C)
                +0.0000591756630803*PriceSeries(Price,index-274,O,L,H,C)
                +0.0000364264296100*PriceSeries(Price,index-275,O,L,H,C)
                +0.00001181126363475*PriceSeries(Price,index-276,O,L,H,C)
                -0.00001233650005671*PriceSeries(Price,index-277,O,L,H,C)
                -0.0000338262083323*PriceSeries(Price,index-278,O,L,H,C)
                -0.0000509238948356*PriceSeries(Price,index-279,O,L,H,C)
                -0.0000623398687480*PriceSeries(Price,index-280,O,L,H,C)
                -0.0000674649857848*PriceSeries(Price,index-281,O,L,H,C)
                -0.0000662096289653*PriceSeries(Price,index-282,O,L,H,C)
                -0.0000590153166433*PriceSeries(Price,index-283,O,L,H,C)
                -0.0000470819551147*PriceSeries(Price,index-284,O,L,H,C)
                -0.0000317251312534*PriceSeries(Price,index-285,O,L,H,C)
                -0.00001451329545907*PriceSeries(Price,index-286,O,L,H,C)
                +0.000003138210846166*PriceSeries(Price,index-287,O,L,H,C)
                +0.00001965287007597*PriceSeries(Price,index-288,O,L,H,C)
                +0.0000334540160737*PriceSeries(Price,index-289,O,L,H,C)
                +0.0000442320692534*PriceSeries(Price,index-290,O,L,H,C)
                +0.0000509189227934*PriceSeries(Price,index-291,O,L,H,C)
                +0.0000536332670257*PriceSeries(Price,index-292,O,L,H,C)
                +0.0000525061548595*PriceSeries(Price,index-293,O,L,H,C)
                +0.0000480831285524*PriceSeries(Price,index-294,O,L,H,C)
                +0.0001270031700279*PriceSeries(Price,index-295,O,L,H,C)
                );

      case N23:
         return(
                0.1699488445142*PriceSeries(Price,index,O,L,H,C)
                +0.1675501421907*PriceSeries(Price,index-1,O,L,H,C)
                +0.1604760576079*PriceSeries(Price,index-2,O,L,H,C)
                +0.1490852518979*PriceSeries(Price,index-3,O,L,H,C)
                +0.1339512972891*PriceSeries(Price,index-4,O,L,H,C)
                +0.1158280654962*PriceSeries(Price,index-5,O,L,H,C)
                +0.0956045169104*PriceSeries(Price,index-6,O,L,H,C)
                +0.0742518627236*PriceSeries(Price,index-7,O,L,H,C)
                +0.0527665531041*PriceSeries(Price,index-8,O,L,H,C)
                +0.0321127863465*PriceSeries(Price,index-9,O,L,H,C)
                +0.01316822211022*PriceSeries(Price,index-10,O,L,H,C)
                -0.00332368143948*PriceSeries(Price,index-11,O,L,H,C)
                -0.01679178111386*PriceSeries(Price,index-12,O,L,H,C)
                -0.02686357360292*PriceSeries(Price,index-13,O,L,H,C)
                -0.0333783225482*PriceSeries(Price,index-14,O,L,H,C)
                -0.0363864909469*PriceSeries(Price,index-15,O,L,H,C)
                -0.0361359122658*PriceSeries(Price,index-16,O,L,H,C)
                -0.0330460157831*PriceSeries(Price,index-17,O,L,H,C)
                -0.02767219289473*PriceSeries(Price,index-18,O,L,H,C)
                -0.02066300248153*PriceSeries(Price,index-19,O,L,H,C)
                -0.01271332167216*PriceSeries(Price,index-20,O,L,H,C)
                -0.00451673036240*PriceSeries(Price,index-21,O,L,H,C)
                +0.00327963434058*PriceSeries(Price,index-22,O,L,H,C)
                +0.01011479598360*PriceSeries(Price,index-23,O,L,H,C)
                +0.01554574769419*PriceSeries(Price,index-24,O,L,H,C)
                +0.01926951109077*PriceSeries(Price,index-25,O,L,H,C)
                +0.02113435352024*PriceSeries(Price,index-26,O,L,H,C)
                +0.02113987520471*PriceSeries(Price,index-27,O,L,H,C)
                +0.01942647658060*PriceSeries(Price,index-28,O,L,H,C)
                +0.01625545001487*PriceSeries(Price,index-29,O,L,H,C)
                +0.01198156201657*PriceSeries(Price,index-30,O,L,H,C)
                +0.00702045442363*PriceSeries(Price,index-31,O,L,H,C)
                +0.001813471457786*PriceSeries(Price,index-32,O,L,H,C)
                -0.00320740166204*PriceSeries(Price,index-33,O,L,H,C)
                -0.00765192574872*PriceSeries(Price,index-34,O,L,H,C)
                -0.01119906189690*PriceSeries(Price,index-35,O,L,H,C)
                -0.01361769734721*PriceSeries(Price,index-36,O,L,H,C)
                -0.01477942270464*PriceSeries(Price,index-37,O,L,H,C)
                -0.01466278599238*PriceSeries(Price,index-38,O,L,H,C)
                -0.01334911444862*PriceSeries(Price,index-39,O,L,H,C)
                -0.01101062476446*PriceSeries(Price,index-40,O,L,H,C)
                -0.00789209685533*PriceSeries(Price,index-41,O,L,H,C)
                -0.00428781914119*PriceSeries(Price,index-42,O,L,H,C)
                -0.000515802395576*PriceSeries(Price,index-43,O,L,H,C)
                +0.003108616236449*PriceSeries(Price,index-44,O,L,H,C)
                +0.00629770249935*PriceSeries(Price,index-45,O,L,H,C)
                +0.00881290941486*PriceSeries(Price,index-46,O,L,H,C)
                +0.01048157844840*PriceSeries(Price,index-47,O,L,H,C)
                +0.01120766142416*PriceSeries(Price,index-48,O,L,H,C)
                +0.01097587987856*PriceSeries(Price,index-49,O,L,H,C)
                +0.00984927677755*PriceSeries(Price,index-50,O,L,H,C)
                +0.00796063323584*PriceSeries(Price,index-51,O,L,H,C)
                +0.00549868946796*PriceSeries(Price,index-52,O,L,H,C)
                +0.002690479359926*PriceSeries(Price,index-53,O,L,H,C)
                -0.0002186554504747*PriceSeries(Price,index-54,O,L,H,C)
                -0.002985684018691*PriceSeries(Price,index-55,O,L,H,C)
                -0.00538946589043*PriceSeries(Price,index-56,O,L,H,C)
                -0.00724776520740*PriceSeries(Price,index-57,O,L,H,C)
                -0.00843043882660*PriceSeries(Price,index-58,O,L,H,C)
                -0.00886788955111*PriceSeries(Price,index-59,O,L,H,C)
                -0.00855428916681*PriceSeries(Price,index-60,O,L,H,C)
                -0.00754551394382*PriceSeries(Price,index-61,O,L,H,C)
                -0.00595215970255*PriceSeries(Price,index-62,O,L,H,C)
                -0.00392838895963*PriceSeries(Price,index-63,O,L,H,C)
                -0.001657666525159*PriceSeries(Price,index-64,O,L,H,C)
                +0.000663345694836*PriceSeries(Price,index-65,O,L,H,C)
                +0.002841361331332*PriceSeries(Price,index-66,O,L,H,C)
                +0.00470214948133*PriceSeries(Price,index-67,O,L,H,C)
                +0.00610408016955*PriceSeries(Price,index-68,O,L,H,C)
                +0.00694851445128*PriceSeries(Price,index-69,O,L,H,C)
                +0.00718630586625*PriceSeries(Price,index-70,O,L,H,C)
                +0.00682002312367*PriceSeries(Price,index-71,O,L,H,C)
                +0.00590186601061*PriceSeries(Price,index-72,O,L,H,C)
                +0.00452759504940*PriceSeries(Price,index-73,O,L,H,C)
                +0.002827112005606*PriceSeries(Price,index-74,O,L,H,C)
                +0.000952575065084*PriceSeries(Price,index-75,O,L,H,C)
                -0.000934892869806*PriceSeries(Price,index-76,O,L,H,C)
                -0.002678767280789*PriceSeries(Price,index-77,O,L,H,C)
                -0.00413983918667*PriceSeries(Price,index-78,O,L,H,C)
                -0.00520707179088*PriceSeries(Price,index-79,O,L,H,C)
                -0.00580577212658*PriceSeries(Price,index-80,O,L,H,C)
                -0.00590249635369*PriceSeries(Price,index-81,O,L,H,C)
                -0.00550639776481*PriceSeries(Price,index-82,O,L,H,C)
                -0.00466702658053*PriceSeries(Price,index-83,O,L,H,C)
                -0.00346887829535*PriceSeries(Price,index-84,O,L,H,C)
                -0.002023249239882*PriceSeries(Price,index-85,O,L,H,C)
                -0.000458155791941*PriceSeries(Price,index-86,O,L,H,C)
                +0.001092788255763*PriceSeries(Price,index-87,O,L,H,C)
                +0.002501587909492*PriceSeries(Price,index-88,O,L,H,C)
                +0.00365625122952*PriceSeries(Price,index-89,O,L,H,C)
                +0.00446951068076*PriceSeries(Price,index-90,O,L,H,C)
                +0.00488522059774*PriceSeries(Price,index-91,O,L,H,C)
                +0.00488197685991*PriceSeries(Price,index-92,O,L,H,C)
                +0.00447375147715*PriceSeries(Price,index-93,O,L,H,C)
                +0.00370758555506*PriceSeries(Price,index-94,O,L,H,C)
                +0.002658624245172*PriceSeries(Price,index-95,O,L,H,C)
                +0.001422992080245*PriceSeries(Price,index-96,O,L,H,C)
                +0.0001091622168230*PriceSeries(Price,index-97,O,L,H,C)
                -0.001171417202837*PriceSeries(Price,index-98,O,L,H,C)
                -0.002313642002122*PriceSeries(Price,index-99,O,L,H,C)
                -0.00322724839298*PriceSeries(Price,index-100,O,L,H,C)
                -0.00384380913724*PriceSeries(Price,index-101,O,L,H,C)
                -0.00412170251362*PriceSeries(Price,index-102,O,L,H,C)
                -0.00404870317795*PriceSeries(Price,index-103,O,L,H,C)
                -0.00364205791478*PriceSeries(Price,index-104,O,L,H,C)
                -0.002946119572708*PriceSeries(Price,index-105,O,L,H,C)
                -0.002027810598081*PriceSeries(Price,index-106,O,L,H,C)
                -0.000970362549957*PriceSeries(Price,index-107,O,L,H,C)
                +0.0001340996311758*PriceSeries(Price,index-108,O,L,H,C)
                +0.001192473840246*PriceSeries(Price,index-109,O,L,H,C)
                +0.002118428311871*PriceSeries(Price,index-110,O,L,H,C)
                +0.002839345044184*PriceSeries(Price,index-111,O,L,H,C)
                +0.00330190645018*PriceSeries(Price,index-112,O,L,H,C)
                +0.00347590778511*PriceSeries(Price,index-113,O,L,H,C)
                +0.00335603098761*PriceSeries(Price,index-114,O,L,H,C)
                +0.002961501044368*PriceSeries(Price,index-115,O,L,H,C)
                +0.002333718076310*PriceSeries(Price,index-116,O,L,H,C)
                +0.001532123161789*PriceSeries(Price,index-117,O,L,H,C)
                +0.000628699954231*PriceSeries(Price,index-118,O,L,H,C)
                -0.0002983930275471*PriceSeries(Price,index-119,O,L,H,C)
                -0.001171500219018*PriceSeries(Price,index-120,O,L,H,C)
                -0.001919896759954*PriceSeries(Price,index-121,O,L,H,C)
                -0.002485439058029*PriceSeries(Price,index-122,O,L,H,C)
                -0.002826990694212*PriceSeries(Price,index-123,O,L,H,C)
                -0.002923299893621*PriceSeries(Price,index-124,O,L,H,C)
                -0.002774133910934*PriceSeries(Price,index-125,O,L,H,C)
                -0.002399634637303*PriceSeries(Price,index-126,O,L,H,C)
                -0.001838002099593*PriceSeries(Price,index-127,O,L,H,C)
                -0.001141751400353*PriceSeries(Price,index-128,O,L,H,C)
                -0.000372902336838*PriceSeries(Price,index-129,O,L,H,C)
                +0.000402471348822*PriceSeries(Price,index-130,O,L,H,C)
                +0.001119854562278*PriceSeries(Price,index-131,O,L,H,C)
                +0.001721596882879*PriceSeries(Price,index-132,O,L,H,C)
                +0.002161479315518*PriceSeries(Price,index-133,O,L,H,C)
                +0.002408185536232*PriceSeries(Price,index-134,O,L,H,C)
                +0.002447428350456*PriceSeries(Price,index-135,O,L,H,C)
                +0.002282590102040*PriceSeries(Price,index-136,O,L,H,C)
                +0.001933877022057*PriceSeries(Price,index-137,O,L,H,C)
                +0.001436102546647*PriceSeries(Price,index-138,O,L,H,C)
                +0.000835327823182*PriceSeries(Price,index-139,O,L,H,C)
                +0.0001846772011778*PriceSeries(Price,index-140,O,L,H,C)
                -0.000460301802928*PriceSeries(Price,index-141,O,L,H,C)
                -0.001046325854160*PriceSeries(Price,index-142,O,L,H,C)
                -0.001526726042397*PriceSeries(Price,index-143,O,L,H,C)
                -0.001865108506275*PriceSeries(Price,index-144,O,L,H,C)
                -0.002038041589931*PriceSeries(Price,index-145,O,L,H,C)
                -0.002036580821213*PriceSeries(Price,index-146,O,L,H,C)
                -0.001866536763788*PriceSeries(Price,index-147,O,L,H,C)
                -0.001547512553189*PriceSeries(Price,index-148,O,L,H,C)
                -0.001110824753863*PriceSeries(Price,index-149,O,L,H,C)
                -0.000596518270965*PriceSeries(Price,index-150,O,L,H,C)
                -0.0000497569790988*PriceSeries(Price,index-151,O,L,H,C)
                +0.000483094870827*PriceSeries(Price,index-152,O,L,H,C)
                +0.000958358229022*PriceSeries(Price,index-153,O,L,H,C)
                +0.001338577714026*PriceSeries(Price,index-154,O,L,H,C)
                +0.001595423550786*PriceSeries(Price,index-155,O,L,H,C)
                +0.001711736876379*PriceSeries(Price,index-156,O,L,H,C)
                +0.001682582742544*PriceSeries(Price,index-157,O,L,H,C)
                +0.001515248925053*PriceSeries(Price,index-158,O,L,H,C)
                +0.001228233060443*PriceSeries(Price,index-159,O,L,H,C)
                +0.000849328840445*PriceSeries(Price,index-160,O,L,H,C)
                +0.000413006011775*PriceSeries(Price,index-161,O,L,H,C)
                -0.0000426734554071*PriceSeries(Price,index-162,O,L,H,C)
                -0.000479338666406*PriceSeries(Price,index-163,O,L,H,C)
                -0.000861502392436*PriceSeries(Price,index-164,O,L,H,C)
                -0.001159407988441*PriceSeries(Price,index-165,O,L,H,C)
                -0.001351299620038*PriceSeries(Price,index-166,O,L,H,C)
                -0.001424951109893*PriceSeries(Price,index-167,O,L,H,C)
                -0.001378354199011*PriceSeries(Price,index-168,O,L,H,C)
                -0.001219528042954*PriceSeries(Price,index-169,O,L,H,C)
                -0.000965508159282*PriceSeries(Price,index-170,O,L,H,C)
                -0.000640618680028*PriceSeries(Price,index-171,O,L,H,C)
                -0.0002742010073755*PriceSeries(Price,index-172,O,L,H,C)
                +0.0001019946677205*PriceSeries(Price,index-173,O,L,H,C)
                +0.000456529891893*PriceSeries(Price,index-174,O,L,H,C)
                +0.000760868749576*PriceSeries(Price,index-175,O,L,H,C)
                +0.000991642650505*PriceSeries(Price,index-176,O,L,H,C)
                +0.001132403464633*PriceSeries(Price,index-177,O,L,H,C)
                +0.001174739635000*PriceSeries(Price,index-178,O,L,H,C)
                +0.001118686378591*PriceSeries(Price,index-179,O,L,H,C)
                +0.000972414962861*PriceSeries(Price,index-180,O,L,H,C)
                +0.000751266128011*PriceSeries(Price,index-181,O,L,H,C)
                +0.000476216279031*PriceSeries(Price,index-182,O,L,H,C)
                +0.0001719342303711*PriceSeries(Price,index-183,O,L,H,C)
                -0.0001353950798301*PriceSeries(Price,index-184,O,L,H,C)
                -0.000420296476022*PriceSeries(Price,index-185,O,L,H,C)
                -0.000660084792024*PriceSeries(Price,index-186,O,L,H,C)
                -0.000836645989945*PriceSeries(Price,index-187,O,L,H,C)
                -0.000937764998061*PriceSeries(Price,index-188,O,L,H,C)
                -0.000957915765822*PriceSeries(Price,index-189,O,L,H,C)
                -0.000898470983031*PriceSeries(Price,index-190,O,L,H,C)
                -0.000767325976203*PriceSeries(Price,index-191,O,L,H,C)
                -0.000578002562651*PriceSeries(Price,index-192,O,L,H,C)
                -0.000348312010558*PriceSeries(Price,index-193,O,L,H,C)
                -0.0000987209872139*PriceSeries(Price,index-194,O,L,H,C)
                +0.0001494414984990*PriceSeries(Price,index-195,O,L,H,C)
                +0.000375787094143*PriceSeries(Price,index-196,O,L,H,C)
                +0.000562514789826*PriceSeries(Price,index-197,O,L,H,C)
                +0.000695786321608*PriceSeries(Price,index-198,O,L,H,C)
                +0.000766711457272*PriceSeries(Price,index-199,O,L,H,C)
                +0.000771891999133*PriceSeries(Price,index-200,O,L,H,C)
                +0.000713489822920*PriceSeries(Price,index-201,O,L,H,C)
                +0.000598822272905*PriceSeries(Price,index-202,O,L,H,C)
                +0.000439558115529*PriceSeries(Price,index-203,O,L,H,C)
                +0.0002505757323195*PriceSeries(Price,index-204,O,L,H,C)
                +0.0000486075074885*PriceSeries(Price,index-205,O,L,H,C)
                -0.0001492196499883*PriceSeries(Price,index-206,O,L,H,C)
                -0.000326817869426*PriceSeries(Price,index-207,O,L,H,C)
                -0.000470415076963*PriceSeries(Price,index-208,O,L,H,C)
                -0.000569603768305*PriceSeries(Price,index-209,O,L,H,C)
                -0.000618059073452*PriceSeries(Price,index-210,O,L,H,C)
                -0.000613894916251*PriceSeries(Price,index-211,O,L,H,C)
                -0.000559635716770*PriceSeries(Price,index-212,O,L,H,C)
                -0.000461820277999*PriceSeries(Price,index-213,O,L,H,C)
                -0.000330303733057*PriceSeries(Price,index-214,O,L,H,C)
                -0.0001772954227790*PriceSeries(Price,index-215,O,L,H,C)
                -0.00001625508736781*PriceSeries(Price,index-216,O,L,H,C)
                +0.0001392693409158*PriceSeries(Price,index-217,O,L,H,C)
                +0.0002767637797660*PriceSeries(Price,index-218,O,L,H,C)
                +0.000385730629964*PriceSeries(Price,index-219,O,L,H,C)
                +0.000458478962208*PriceSeries(Price,index-220,O,L,H,C)
                +0.000490625569424*PriceSeries(Price,index-221,O,L,H,C)
                +0.000481313338379*PriceSeries(Price,index-222,O,L,H,C)
                +0.000433129039048*PriceSeries(Price,index-223,O,L,H,C)
                +0.000351732934404*PriceSeries(Price,index-224,O,L,H,C)
                +0.0002452629610435*PriceSeries(Price,index-225,O,L,H,C)
                +0.0001235431752054*PriceSeries(Price,index-226,O,L,H,C)
                -0.000002787345116589*PriceSeries(Price,index-227,O,L,H,C)
                -0.0001231898879707*PriceSeries(Price,index-228,O,L,H,C)
                -0.0002280970271017*PriceSeries(Price,index-229,O,L,H,C)
                -0.0003096470904886*PriceSeries(Price,index-230,O,L,H,C)
                -0.000362259409545*PriceSeries(Price,index-231,O,L,H,C)
                -0.000382973330584*PriceSeries(Price,index-232,O,L,H,C)
                -0.000371581714179*PriceSeries(Price,index-233,O,L,H,C)
                -0.000330517184039*PriceSeries(Price,index-234,O,L,H,C)
                -0.0002645183388477*PriceSeries(Price,index-235,O,L,H,C)
                -0.0001801476871507*PriceSeries(Price,index-236,O,L,H,C)
                -0.0000851555776580*PriceSeries(Price,index-237,O,L,H,C)
                +0.00001220198617955*PriceSeries(Price,index-238,O,L,H,C)
                +0.0001038791434731*PriceSeries(Price,index-239,O,L,H,C)
                +0.0001826880717948*PriceSeries(Price,index-240,O,L,H,C)
                +0.0002428289148902*PriceSeries(Price,index-241,O,L,H,C)
                +0.0002803190715955*PriceSeries(Price,index-242,O,L,H,C)
                +0.0002932163793231*PriceSeries(Price,index-243,O,L,H,C)
                +0.0002816886374180*PriceSeries(Price,index-244,O,L,H,C)
                +0.0002478835808255*PriceSeries(Price,index-245,O,L,H,C)
                +0.0001956512092911*PriceSeries(Price,index-246,O,L,H,C)
                +0.0001301623913070*PriceSeries(Price,index-247,O,L,H,C)
                +0.0000573855753610*PriceSeries(Price,index-248,O,L,H,C)
                -0.00001641889682998*PriceSeries(Price,index-249,O,L,H,C)
                -0.0000852276669122*PriceSeries(Price,index-250,O,L,H,C)
                -0.0001437251968674*PriceSeries(Price,index-251,O,L,H,C)
                -0.0001876980116067*PriceSeries(Price,index-252,O,L,H,C)
                -0.0002143557853106*PriceSeries(Price,index-253,O,L,H,C)
                -0.0002224435061456*PriceSeries(Price,index-254,O,L,H,C)
                -0.0002122927594786*PriceSeries(Price,index-255,O,L,H,C)
                -0.0001857070083130*PriceSeries(Price,index-256,O,L,H,C)
                -0.0001457303774242*PriceSeries(Price,index-257,O,L,H,C)
                -0.0000963485434265*PriceSeries(Price,index-258,O,L,H,C)
                -0.0000420802616575*PriceSeries(Price,index-259,O,L,H,C)
                +0.00001234962682948*PriceSeries(Price,index-260,O,L,H,C)
                +0.0000624417077927*PriceSeries(Price,index-261,O,L,H,C)
                +0.0001042783564142*PriceSeries(Price,index-262,O,L,H,C)
                +0.0001347782521038*PriceSeries(Price,index-263,O,L,H,C)
                +0.0001519184428847*PriceSeries(Price,index-264,O,L,H,C)
                +0.0001547731585682*PriceSeries(Price,index-265,O,L,H,C)
                +0.0001436082644908*PriceSeries(Price,index-266,O,L,H,C)
                +0.0001197395343680*PriceSeries(Price,index-267,O,L,H,C)
                +0.0000853582996209*PriceSeries(Price,index-268,O,L,H,C)
                +0.0000433833976736*PriceSeries(Price,index-269,O,L,H,C)
                -0.000002877743120115*PriceSeries(Price,index-270,O,L,H,C)
                -0.0000499419075912*PriceSeries(Price,index-271,O,L,H,C)
                -0.0000945607138748*PriceSeries(Price,index-272,O,L,H,C)
                -0.0001338628934640*PriceSeries(Price,index-273,O,L,H,C)
                -0.0001654727482667*PriceSeries(Price,index-274,O,L,H,C)
                -0.0001877981861852*PriceSeries(Price,index-275,O,L,H,C)
                -0.0001999440043539*PriceSeries(Price,index-276,O,L,H,C)
                -0.0002018756565952*PriceSeries(Price,index-277,O,L,H,C)
                -0.0001941901630423*PriceSeries(Price,index-278,O,L,H,C)
                -0.0001781508840424*PriceSeries(Price,index-279,O,L,H,C)
                -0.0001556736555211*PriceSeries(Price,index-280,O,L,H,C)
                -0.0001286617670725*PriceSeries(Price,index-281,O,L,H,C)
                -0.0000992679410533*PriceSeries(Price,index-282,O,L,H,C)
                -0.0000694651251729*PriceSeries(Price,index-283,O,L,H,C)
                -0.0000412969023893*PriceSeries(Price,index-284,O,L,H,C)
                -0.00001654032383930*PriceSeries(Price,index-285,O,L,H,C)
                +0.00000426562673904*PriceSeries(Price,index-286,O,L,H,C)
                +0.00001980964905683*PriceSeries(Price,index-287,O,L,H,C)
                +0.00003017212723366*PriceSeries(Price,index-288,O,L,H,C)
                +0.0000354026726622*PriceSeries(Price,index-289,O,L,H,C)
                +0.0000360262654722*PriceSeries(Price,index-290,O,L,H,C)
                +0.0001263182452759*PriceSeries(Price,index-291,O,L,H,C)
                );

      case N24:
         return(
                0.1752582433557*PriceSeries(Price,index,O,L,H,C)
                +0.1707875832001*PriceSeries(Price,index-1,O,L,H,C)
                +0.1620520950112*PriceSeries(Price,index-2,O,L,H,C)
                +0.1494521266199*PriceSeries(Price,index-3,O,L,H,C)
                +0.1335606032665*PriceSeries(Price,index-4,O,L,H,C)
                +0.1150917554369*PriceSeries(Price,index-5,O,L,H,C)
                +0.0948624078675*PriceSeries(Price,index-6,O,L,H,C)
                +0.0737481127736*PriceSeries(Price,index-7,O,L,H,C)
                +0.0526367283109*PriceSeries(Price,index-8,O,L,H,C)
                +0.0323821623994*PriceSeries(Price,index-9,O,L,H,C)
                +0.01376095732910*PriceSeries(Price,index-10,O,L,H,C)
                -0.002565813433195*PriceSeries(Price,index-11,O,L,H,C)
                -0.01608321545129*PriceSeries(Price,index-12,O,L,H,C)
                -0.02644406063023*PriceSeries(Price,index-13,O,L,H,C)
                -0.0334804084715*PriceSeries(Price,index-14,O,L,H,C)
                -0.0372045284448*PriceSeries(Price,index-15,O,L,H,C)
                -0.0377995628029*PriceSeries(Price,index-16,O,L,H,C)
                -0.0356007415702*PriceSeries(Price,index-17,O,L,H,C)
                -0.03106855421183*PriceSeries(Price,index-18,O,L,H,C)
                -0.02475575215635*PriceSeries(Price,index-19,O,L,H,C)
                -0.01727038277172*PriceSeries(Price,index-20,O,L,H,C)
                -0.00923721064126*PriceSeries(Price,index-21,O,L,H,C)
                -0.001259976578953*PriceSeries(Price,index-22,O,L,H,C)
                +0.00611327983024*PriceSeries(Price,index-23,O,L,H,C)
                +0.01241975590021*PriceSeries(Price,index-24,O,L,H,C)
                +0.01730471548674*PriceSeries(Price,index-25,O,L,H,C)
                +0.02053641391856*PriceSeries(Price,index-26,O,L,H,C)
                +0.02201256220684*PriceSeries(Price,index-27,O,L,H,C)
                +0.02175824644450*PriceSeries(Price,index-28,O,L,H,C)
                +0.01991585976569*PriceSeries(Price,index-29,O,L,H,C)
                +0.01672799869992*PriceSeries(Price,index-30,O,L,H,C)
                +0.01251480589785*PriceSeries(Price,index-31,O,L,H,C)
                +0.00764744138681*PriceSeries(Price,index-32,O,L,H,C)
                +0.002519641176577*PriceSeries(Price,index-33,O,L,H,C)
                -0.002480715130409*PriceSeries(Price,index-34,O,L,H,C)
                -0.00699808403427*PriceSeries(Price,index-35,O,L,H,C)
                -0.01073217059168*PriceSeries(Price,index-36,O,L,H,C)
                -0.01345582742890*PriceSeries(Price,index-37,O,L,H,C)
                -0.01502702870603*PriceSeries(Price,index-38,O,L,H,C)
                -0.01539432717919*PriceSeries(Price,index-39,O,L,H,C)
                -0.01459575271176*PriceSeries(Price,index-40,O,L,H,C)
                -0.01275150707857*PriceSeries(Price,index-41,O,L,H,C)
                -0.01005125788951*PriceSeries(Price,index-42,O,L,H,C)
                -0.00673713856683*PriceSeries(Price,index-43,O,L,H,C)
                -0.003083856344679*PriceSeries(Price,index-44,O,L,H,C)
                +0.000622607539749*PriceSeries(Price,index-45,O,L,H,C)
                +0.00410610347788*PriceSeries(Price,index-46,O,L,H,C)
                +0.00711978864981*PriceSeries(Price,index-47,O,L,H,C)
                +0.00946262317609*PriceSeries(Price,index-48,O,L,H,C)
                +0.01099187855568*PriceSeries(Price,index-49,O,L,H,C)
                +0.01163089166497*PriceSeries(Price,index-50,O,L,H,C)
                +0.01137176219519*PriceSeries(Price,index-51,O,L,H,C)
                +0.01027294631103*PriceSeries(Price,index-52,O,L,H,C)
                +0.00845217687841*PriceSeries(Price,index-53,O,L,H,C)
                +0.00607536409148*PriceSeries(Price,index-54,O,L,H,C)
                +0.00334247111219*PriceSeries(Price,index-55,O,L,H,C)
                +0.000471461929836*PriceSeries(Price,index-56,O,L,H,C)
                -0.002318388157335*PriceSeries(Price,index-57,O,L,H,C)
                -0.00482266596806*PriceSeries(Price,index-58,O,L,H,C)
                -0.00686622711594*PriceSeries(Price,index-59,O,L,H,C)
                -0.00831495900096*PriceSeries(Price,index-60,O,L,H,C)
                -0.00908404147254*PriceSeries(Price,index-61,O,L,H,C)
                -0.00914233100693*PriceSeries(Price,index-62,O,L,H,C)
                -0.00851260184396*PriceSeries(Price,index-63,O,L,H,C)
                -0.00726785614860*PriceSeries(Price,index-64,O,L,H,C)
                -0.00552403937250*PriceSeries(Price,index-65,O,L,H,C)
                -0.00342990404525*PriceSeries(Price,index-66,O,L,H,C)
                -0.001154779403161*PriceSeries(Price,index-67,O,L,H,C)
                +0.001124695261994*PriceSeries(Price,index-68,O,L,H,C)
                +0.00323793889315*PriceSeries(Price,index-69,O,L,H,C)
                +0.00503284538107*PriceSeries(Price,index-70,O,L,H,C)
                +0.00638643928078*PriceSeries(Price,index-71,O,L,H,C)
                +0.00721295885805*PriceSeries(Price,index-72,O,L,H,C)
                +0.00746895501208*PriceSeries(Price,index-73,O,L,H,C)
                +0.00715503639194*PriceSeries(Price,index-74,O,L,H,C)
                +0.00631432573649*PriceSeries(Price,index-75,O,L,H,C)
                +0.00502779465178*PriceSeries(Price,index-76,O,L,H,C)
                +0.00340695866778*PriceSeries(Price,index-77,O,L,H,C)
                +0.001584537351815*PriceSeries(Price,index-78,O,L,H,C)
                -0.0002961345282995*PriceSeries(Price,index-79,O,L,H,C)
                -0.002092152884521*PriceSeries(Price,index-80,O,L,H,C)
                -0.00367167200014*PriceSeries(Price,index-81,O,L,H,C)
                -0.00492339267391*PriceSeries(Price,index-82,O,L,H,C)
                -0.00576417880205*PriceSeries(Price,index-83,O,L,H,C)
                -0.00614435966236*PriceSeries(Price,index-84,O,L,H,C)
                -0.00605034265259*PriceSeries(Price,index-85,O,L,H,C)
                -0.00550448080861*PriceSeries(Price,index-86,O,L,H,C)
                -0.00456223057974*PriceSeries(Price,index-87,O,L,H,C)
                -0.00330697037665*PriceSeries(Price,index-88,O,L,H,C)
                -0.001842864485929*PriceSeries(Price,index-89,O,L,H,C)
                -0.0002864241841445*PriceSeries(Price,index-90,O,L,H,C)
                +0.001242605757027*PriceSeries(Price,index-91,O,L,H,C)
                +0.002630294460678*PriceSeries(Price,index-92,O,L,H,C)
                +0.00377688860535*PriceSeries(Price,index-93,O,L,H,C)
                +0.00460380914637*PriceSeries(Price,index-94,O,L,H,C)
                +0.00505890970585*PriceSeries(Price,index-95,O,L,H,C)
                +0.00511953069397*PriceSeries(Price,index-96,O,L,H,C)
                +0.00479331313820*PriceSeries(Price,index-97,O,L,H,C)
                +0.00411666689591*PriceSeries(Price,index-98,O,L,H,C)
                +0.003151182960041*PriceSeries(Price,index-99,O,L,H,C)
                +0.001978227585549*PriceSeries(Price,index-100,O,L,H,C)
                +0.000692254947772*PriceSeries(Price,index-101,O,L,H,C)
                -0.000606691830432*PriceSeries(Price,index-102,O,L,H,C)
                -0.001820629953809*PriceSeries(Price,index-103,O,L,H,C)
                -0.002860941264555*PriceSeries(Price,index-104,O,L,H,C)
                -0.00365472083061*PriceSeries(Price,index-105,O,L,H,C)
                -0.00414978198931*PriceSeries(Price,index-106,O,L,H,C)
                -0.00431793190542*PriceSeries(Price,index-107,O,L,H,C)
                -0.00415638660568*PriceSeries(Price,index-108,O,L,H,C)
                -0.00368718983705*PriceSeries(Price,index-109,O,L,H,C)
                -0.002954833465491*PriceSeries(Price,index-110,O,L,H,C)
                -0.002022233086104*PriceSeries(Price,index-111,O,L,H,C)
                -0.000965456824434*PriceSeries(Price,index-112,O,L,H,C)
                +0.0001323737592416*PriceSeries(Price,index-113,O,L,H,C)
                +0.001187541437686*PriceSeries(Price,index-114,O,L,H,C)
                +0.002122035221091*PriceSeries(Price,index-115,O,L,H,C)
                +0.002869235050912*PriceSeries(Price,index-116,O,L,H,C)
                +0.00337857801296*PriceSeries(Price,index-117,O,L,H,C)
                +0.00361887102029*PriceSeries(Price,index-118,O,L,H,C)
                +0.00358006833661*PriceSeries(Price,index-119,O,L,H,C)
                +0.00327338511779*PriceSeries(Price,index-120,O,L,H,C)
                +0.002729827759844*PriceSeries(Price,index-121,O,L,H,C)
                +0.001997271221521*PriceSeries(Price,index-122,O,L,H,C)
                +0.001136372218889*PriceSeries(Price,index-123,O,L,H,C)
                +0.0002156170727550*PriceSeries(Price,index-124,O,L,H,C)
                -0.000694043102161*PriceSeries(Price,index-125,O,L,H,C)
                -0.001524600566957*PriceSeries(Price,index-126,O,L,H,C)
                -0.002216016192575*PriceSeries(Price,index-127,O,L,H,C)
                -0.002720491895083*PriceSeries(Price,index-128,O,L,H,C)
                -0.003005687383938*PriceSeries(Price,index-129,O,L,H,C)
                -0.003056710134115*PriceSeries(Price,index-130,O,L,H,C)
                -0.002876686667495*PriceSeries(Price,index-131,O,L,H,C)
                -0.002486021916308*PriceSeries(Price,index-132,O,L,H,C)
                -0.001920323632786*PriceSeries(Price,index-133,O,L,H,C)
                -0.001227291996360*PriceSeries(Price,index-134,O,L,H,C)
                -0.000462759539463*PriceSeries(Price,index-135,O,L,H,C)
                +0.0003137330262296*PriceSeries(Price,index-136,O,L,H,C)
                +0.001043529857609*PriceSeries(Price,index-137,O,L,H,C)
                +0.001673237465651*PriceSeries(Price,index-138,O,L,H,C)
                +0.002158585213059*PriceSeries(Price,index-139,O,L,H,C)
                +0.002467465534314*PriceSeries(Price,index-140,O,L,H,C)
                +0.002581987012428*PriceSeries(Price,index-141,O,L,H,C)
                +0.002499394457866*PriceSeries(Price,index-142,O,L,H,C)
                +0.002231815915697*PriceSeries(Price,index-143,O,L,H,C)
                +0.001804898179919*PriceSeries(Price,index-144,O,L,H,C)
                +0.001255485334412*PriceSeries(Price,index-145,O,L,H,C)
                +0.000628497678365*PriceSeries(Price,index-146,O,L,H,C)
                -0.00002668574881345*PriceSeries(Price,index-147,O,L,H,C)
                -0.000660055928438*PriceSeries(Price,index-148,O,L,H,C)
                -0.001224775628467*PriceSeries(Price,index-149,O,L,H,C)
                -0.001680570353446*PriceSeries(Price,index-150,O,L,H,C)
                -0.001996581757873*PriceSeries(Price,index-151,O,L,H,C)
                -0.002153376976581*PriceSeries(Price,index-152,O,L,H,C)
                -0.002144070308624*PriceSeries(Price,index-153,O,L,H,C)
                -0.001974443960237*PriceSeries(Price,index-154,O,L,H,C)
                -0.001662134554070*PriceSeries(Price,index-155,O,L,H,C)
                -0.001234938865510*PriceSeries(Price,index-156,O,L,H,C)
                -0.000728416224041*PriceSeries(Price,index-157,O,L,H,C)
                -0.0001829667759894*PriceSeries(Price,index-158,O,L,H,C)
                +0.000359336791593*PriceSeries(Price,index-159,O,L,H,C)
                +0.000857962399530*PriceSeries(Price,index-160,O,L,H,C)
                +0.001276916375279*PriceSeries(Price,index-161,O,L,H,C)
                +0.001587309650456*PriceSeries(Price,index-162,O,L,H,C)
                +0.001769281830078*PriceSeries(Price,index-163,O,L,H,C)
                +0.001813233903214*PriceSeries(Price,index-164,O,L,H,C)
                +0.001720210317628*PriceSeries(Price,index-165,O,L,H,C)
                +0.001501477846476*PriceSeries(Price,index-166,O,L,H,C)
                +0.001177381146021*PriceSeries(Price,index-167,O,L,H,C)
                +0.000775501176360*PriceSeries(Price,index-168,O,L,H,C)
                +0.000328379737154*PriceSeries(Price,index-169,O,L,H,C)
                -0.0001290931349808*PriceSeries(Price,index-170,O,L,H,C)
                -0.000562369569274*PriceSeries(Price,index-171,O,L,H,C)
                -0.000939816604948*PriceSeries(Price,index-172,O,L,H,C)
                -0.001235001494417*PriceSeries(Price,index-173,O,L,H,C)
                -0.001428494359415*PriceSeries(Price,index-174,O,L,H,C)
                -0.001509115982844*PriceSeries(Price,index-175,O,L,H,C)
                -0.001474492279944*PriceSeries(Price,index-176,O,L,H,C)
                -0.001330952234393*PriceSeries(Price,index-177,O,L,H,C)
                -0.001092756514158*PriceSeries(Price,index-178,O,L,H,C)
                -0.000780799306851*PriceSeries(Price,index-179,O,L,H,C)
                -0.000420797416658*PriceSeries(Price,index-180,O,L,H,C)
                -0.0000412114757573*PriceSeries(Price,index-181,O,L,H,C)
                +0.000328972317011*PriceSeries(Price,index-182,O,L,H,C)
                +0.000662420882524*PriceSeries(Price,index-183,O,L,H,C)
                +0.000935483450999*PriceSeries(Price,index-184,O,L,H,C)
                +0.001129772074173*PriceSeries(Price,index-185,O,L,H,C)
                +0.001233439642316*PriceSeries(Price,index-186,O,L,H,C)
                +0.001241774867320*PriceSeries(Price,index-187,O,L,H,C)
                +0.001157373632002*PriceSeries(Price,index-188,O,L,H,C)
                +0.000989650878173*PriceSeries(Price,index-189,O,L,H,C)
                +0.000753938571330*PriceSeries(Price,index-190,O,L,H,C)
                +0.000470106744115*PriceSeries(Price,index-191,O,L,H,C)
                +0.0001609536838118*PriceSeries(Price,index-192,O,L,H,C)
                -0.0001496262180886*PriceSeries(Price,index-193,O,L,H,C)
                -0.000438442876055*PriceSeries(Price,index-194,O,L,H,C)
                -0.000684751503150*PriceSeries(Price,index-195,O,L,H,C)
                -0.000871678585789*PriceSeries(Price,index-196,O,L,H,C)
                -0.000987370934258*PriceSeries(Price,index-197,O,L,H,C)
                -0.001025693903888*PriceSeries(Price,index-198,O,L,H,C)
                -0.000986522726168*PriceSeries(Price,index-199,O,L,H,C)
                -0.000875476290519*PriceSeries(Price,index-200,O,L,H,C)
                -0.000703348764322*PriceSeries(Price,index-201,O,L,H,C)
                -0.000485105128034*PriceSeries(Price,index-202,O,L,H,C)
                -0.0002385893851763*PriceSeries(Price,index-203,O,L,H,C)
                +0.00001686159475816*PriceSeries(Price,index-204,O,L,H,C)
                +0.0002619545467450*PriceSeries(Price,index-205,O,L,H,C)
                +0.000478859302994*PriceSeries(Price,index-206,O,L,H,C)
                +0.000652482060692*PriceSeries(Price,index-207,O,L,H,C)
                +0.000771510590240*PriceSeries(Price,index-208,O,L,H,C)
                +0.000829087708404*PriceSeries(Price,index-209,O,L,H,C)
                +0.000823191721545*PriceSeries(Price,index-210,O,L,H,C)
                +0.000756574948444*PriceSeries(Price,index-211,O,L,H,C)
                +0.000636422856377*PriceSeries(Price,index-212,O,L,H,C)
                +0.000473612946356*PriceSeries(Price,index-213,O,L,H,C)
                +0.0002817980478113*PriceSeries(Price,index-214,O,L,H,C)
                +0.0000762517853451*PriceSeries(Price,index-215,O,L,H,C)
                -0.0001272693429533*PriceSeries(Price,index-216,O,L,H,C)
                -0.0003137714285404*PriceSeries(Price,index-217,O,L,H,C)
                -0.000470099591482*PriceSeries(Price,index-218,O,L,H,C)
                -0.000585842020593*PriceSeries(Price,index-219,O,L,H,C)
                -0.000653943817055*PriceSeries(Price,index-220,O,L,H,C)
                -0.000671230882061*PriceSeries(Price,index-221,O,L,H,C)
                -0.000638326398330*PriceSeries(Price,index-222,O,L,H,C)
                -0.000559623550023*PriceSeries(Price,index-223,O,L,H,C)
                -0.000442681397115*PriceSeries(Price,index-224,O,L,H,C)
                -0.0002976343319736*PriceSeries(Price,index-225,O,L,H,C)
                -0.0001362686838977*PriceSeries(Price,index-226,O,L,H,C)
                +0.00002885923311687*PriceSeries(Price,index-227,O,L,H,C)
                +0.0001854334009755*PriceSeries(Price,index-228,O,L,H,C)
                +0.000322228748798*PriceSeries(Price,index-229,O,L,H,C)
                +0.000429949118934*PriceSeries(Price,index-230,O,L,H,C)
                +0.000501793096955*PriceSeries(Price,index-231,O,L,H,C)
                +0.000533907809394*PriceSeries(Price,index-232,O,L,H,C)
                +0.000525494305968*PriceSeries(Price,index-233,O,L,H,C)
                +0.000478787521476*PriceSeries(Price,index-234,O,L,H,C)
                +0.000398745618302*PriceSeries(Price,index-235,O,L,H,C)
                +0.0002926380928517*PriceSeries(Price,index-236,O,L,H,C)
                +0.0001692911110018*PriceSeries(Price,index-237,O,L,H,C)
                +0.0000384421572466*PriceSeries(Price,index-238,O,L,H,C)
                -0.0000899390014326*PriceSeries(Price,index-239,O,L,H,C)
                -0.0002065647175324*PriceSeries(Price,index-240,O,L,H,C)
                -0.0003033181229286*PriceSeries(Price,index-241,O,L,H,C)
                -0.000373907756399*PriceSeries(Price,index-242,O,L,H,C)
                -0.000414221934971*PriceSeries(Price,index-243,O,L,H,C)
                -0.000422521140072*PriceSeries(Price,index-244,O,L,H,C)
                -0.000399506371182*PriceSeries(Price,index-245,O,L,H,C)
                -0.000348113772816*PriceSeries(Price,index-246,O,L,H,C)
                -0.0002732622535234*PriceSeries(Price,index-247,O,L,H,C)
                -0.0001813582210833*PriceSeries(Price,index-248,O,L,H,C)
                -0.0000798234988207*PriceSeries(Price,index-249,O,L,H,C)
                +0.00002354918331005*PriceSeries(Price,index-250,O,L,H,C)
                +0.0001211258936908*PriceSeries(Price,index-251,O,L,H,C)
                +0.0002060293160492*PriceSeries(Price,index-252,O,L,H,C)
                +0.0002725217789270*PriceSeries(Price,index-253,O,L,H,C)
                +0.000316450399433*PriceSeries(Price,index-254,O,L,H,C)
                +0.000335501911177*PriceSeries(Price,index-255,O,L,H,C)
                +0.000329272776430*PriceSeries(Price,index-256,O,L,H,C)
                +0.0002989703600771*PriceSeries(Price,index-257,O,L,H,C)
                +0.0002478069638708*PriceSeries(Price,index-258,O,L,H,C)
                +0.0001801024370910*PriceSeries(Price,index-259,O,L,H,C)
                +0.0001013643291660*PriceSeries(Price,index-260,O,L,H,C)
                +0.00001759110969893*PriceSeries(Price,index-261,O,L,H,C)
                -0.0000650307075447*PriceSeries(Price,index-262,O,L,H,C)
                -0.0001406472066373*PriceSeries(Price,index-263,O,L,H,C)
                -0.0002040543732324*PriceSeries(Price,index-264,O,L,H,C)
                -0.0002510875358153*PriceSeries(Price,index-265,O,L,H,C)
                -0.0002787929264006*PriceSeries(Price,index-266,O,L,H,C)
                -0.0002856365790585*PriceSeries(Price,index-267,O,L,H,C)
                -0.0002714759941524*PriceSeries(Price,index-268,O,L,H,C)
                -0.0002375606131388*PriceSeries(Price,index-269,O,L,H,C)
                -0.0001863024248234*PriceSeries(Price,index-270,O,L,H,C)
                -0.0001211163945584*PriceSeries(Price,index-271,O,L,H,C)
                -0.0000461226944919*PriceSeries(Price,index-272,O,L,H,C)
                +0.0000340316415897*PriceSeries(Price,index-273,O,L,H,C)
                +0.0001147553107787*PriceSeries(Price,index-274,O,L,H,C)
                +0.0001921067225713*PriceSeries(Price,index-275,O,L,H,C)
                +0.0002615152176183*PriceSeries(Price,index-276,O,L,H,C)
                +0.000320158762401*PriceSeries(Price,index-277,O,L,H,C)
                +0.000365538853731*PriceSeries(Price,index-278,O,L,H,C)
                +0.000396267587083*PriceSeries(Price,index-279,O,L,H,C)
                +0.000411886030282*PriceSeries(Price,index-280,O,L,H,C)
                +0.000412796540426*PriceSeries(Price,index-281,O,L,H,C)
                +0.000400223729242*PriceSeries(Price,index-282,O,L,H,C)
                +0.000376007162781*PriceSeries(Price,index-283,O,L,H,C)
                +0.000342502848224*PriceSeries(Price,index-284,O,L,H,C)
                +0.0003023316512607*PriceSeries(Price,index-285,O,L,H,C)
                +0.0002582687297087*PriceSeries(Price,index-286,O,L,H,C)
                +0.0002130187418565*PriceSeries(Price,index-287,O,L,H,C)
                +0.0001691811960329*PriceSeries(Price,index-288,O,L,H,C)
                +0.0001291618295799*PriceSeries(Price,index-289,O,L,H,C)
                +0.0000953640041507*PriceSeries(Price,index-290,O,L,H,C)
                +0.0000704812806245*PriceSeries(Price,index-291,O,L,H,C)
                +0.0000583612011494*PriceSeries(Price,index-292,O,L,H,C)
                -0.0000829688219830*PriceSeries(Price,index-293,O,L,H,C)

                );
      case N25:
         return(
                0.1606952954863*PriceSeries(Price,index,O,L,H,C)
                +0.1586805353200*PriceSeries(Price,index-1,O,L,H,C)
                +0.1527274160785*PriceSeries(Price,index-2,O,L,H,C)
                +0.1431044943359*PriceSeries(Price,index-3,O,L,H,C)
                +0.1302432319222*PriceSeries(Price,index-4,O,L,H,C)
                +0.1147147978292*PriceSeries(Price,index-5,O,L,H,C)
                +0.0971995271336*PriceSeries(Price,index-6,O,L,H,C)
                +0.0784508286700*PriceSeries(Price,index-7,O,L,H,C)
                +0.0592556469606*PriceSeries(Price,index-8,O,L,H,C)
                +0.0403937681148*PriceSeries(Price,index-9,O,L,H,C)
                +0.02259830393202*PriceSeries(Price,index-10,O,L,H,C)
                +0.00651958867788*PriceSeries(Price,index-11,O,L,H,C)
                -0.00730551083349*PriceSeries(Price,index-12,O,L,H,C)
                -0.01847722330901*PriceSeries(Price,index-13,O,L,H,C)
                -0.02674824024855*PriceSeries(Price,index-14,O,L,H,C)
                -0.0320301382188*PriceSeries(Price,index-15,O,L,H,C)
                -0.0343907195244*PriceSeries(Price,index-16,O,L,H,C)
                -0.0340426824523*PriceSeries(Price,index-17,O,L,H,C)
                -0.03132454264141*PriceSeries(Price,index-18,O,L,H,C)
                -0.02667517010892*PriceSeries(Price,index-19,O,L,H,C)
                -0.02060365698510*PriceSeries(Price,index-20,O,L,H,C)
                -0.01365646548128*PriceSeries(Price,index-21,O,L,H,C)
                -0.00638391361164*PriceSeries(Price,index-22,O,L,H,C)
                +0.000691965430229*PriceSeries(Price,index-23,O,L,H,C)
                +0.00710630449853*PriceSeries(Price,index-24,O,L,H,C)
                +0.01247540215970*PriceSeries(Price,index-25,O,L,H,C)
                +0.01651457571775*PriceSeries(Price,index-26,O,L,H,C)
                +0.01904903090190*PriceSeries(Price,index-27,O,L,H,C)
                +0.02001737883413*PriceSeries(Price,index-28,O,L,H,C)
                +0.01946790639555*PriceSeries(Price,index-29,O,L,H,C)
                +0.01754816150543*PriceSeries(Price,index-30,O,L,H,C)
                +0.01448881786870*PriceSeries(Price,index-31,O,L,H,C)
                +0.01058311084658*PriceSeries(Price,index-32,O,L,H,C)
                +0.00616337037033*PriceSeries(Price,index-33,O,L,H,C)
                +0.001576302214586*PriceSeries(Price,index-34,O,L,H,C)
                -0.002841317631447*PriceSeries(Price,index-35,O,L,H,C)
                -0.00678496507603*PriceSeries(Price,index-36,O,L,H,C)
                -0.01000133209284*PriceSeries(Price,index-37,O,L,H,C)
                -0.01230283750765*PriceSeries(Price,index-38,O,L,H,C)
                -0.01357692874436*PriceSeries(Price,index-39,O,L,H,C)
                -0.01378979828367*PriceSeries(Price,index-40,O,L,H,C)
                -0.01298452795172*PriceSeries(Price,index-41,O,L,H,C)
                -0.01127404678145*PriceSeries(Price,index-42,O,L,H,C)
                -0.00882962286568*PriceSeries(Price,index-43,O,L,H,C)
                -0.00586588159433*PriceSeries(Price,index-44,O,L,H,C)
                -0.002623536230354*PriceSeries(Price,index-45,O,L,H,C)
                +0.000648875555040*PriceSeries(Price,index-46,O,L,H,C)
                +0.00371294196050*PriceSeries(Price,index-47,O,L,H,C)
                +0.00635678367324*PriceSeries(Price,index-48,O,L,H,C)
                +0.00840884258644*PriceSeries(Price,index-49,O,L,H,C)
                +0.00974820460317*PriceSeries(Price,index-50,O,L,H,C)
                +0.01031088457310*PriceSeries(Price,index-51,O,L,H,C)
                +0.01009180462886*PriceSeries(Price,index-52,O,L,H,C)
                +0.00914250976753*PriceSeries(Price,index-53,O,L,H,C)
                +0.00756496158531*PriceSeries(Price,index-54,O,L,H,C)
                +0.00550201140009*PriceSeries(Price,index-55,O,L,H,C)
                +0.003125364837153*PriceSeries(Price,index-56,O,L,H,C)
                +0.000621994822974*PriceSeries(Price,index-57,O,L,H,C)
                -0.001819969264892*PriceSeries(Price,index-58,O,L,H,C)
                -0.00402485026432*PriceSeries(Price,index-59,O,L,H,C)
                -0.00584157931369*PriceSeries(Price,index-60,O,L,H,C)
                -0.00715358996112*PriceSeries(Price,index-61,O,L,H,C)
                -0.00788583149647*PriceSeries(Price,index-62,O,L,H,C)
                -0.00800851217551*PriceSeries(Price,index-63,O,L,H,C)
                -0.00753743222083*PriceSeries(Price,index-64,O,L,H,C)
                -0.00653101406947*PriceSeries(Price,index-65,O,L,H,C)
                -0.00508437058502*PriceSeries(Price,index-66,O,L,H,C)
                -0.00332095234760*PriceSeries(Price,index-67,O,L,H,C)
                -0.001382467233484*PriceSeries(Price,index-68,O,L,H,C)
                +0.000582134882217*PriceSeries(Price,index-69,O,L,H,C)
                +0.002427780900168*PriceSeries(Price,index-70,O,L,H,C)
                +0.00402368996717*PriceSeries(Price,index-71,O,L,H,C)
                +0.00526235771810*PriceSeries(Price,index-72,O,L,H,C)
                +0.00606651100999*PriceSeries(Price,index-73,O,L,H,C)
                +0.00639360477819*PriceSeries(Price,index-74,O,L,H,C)
                +0.00623762439325*PriceSeries(Price,index-75,O,L,H,C)
                +0.00562816071164*PriceSeries(Price,index-76,O,L,H,C)
                +0.00462692530940*PriceSeries(Price,index-77,O,L,H,C)
                +0.00332205139562*PriceSeries(Price,index-78,O,L,H,C)
                +0.001820674909485*PriceSeries(Price,index-79,O,L,H,C)
                +0.0002403989941696*PriceSeries(Price,index-80,O,L,H,C)
                -0.001299696940829*PriceSeries(Price,index-81,O,L,H,C)
                -0.002687831650433*PriceSeries(Price,index-82,O,L,H,C)
                -0.00382744644326*PriceSeries(Price,index-83,O,L,H,C)
                -0.00464373212248*PriceSeries(Price,index-84,O,L,H,C)
                -0.00508833094371*PriceSeries(Price,index-85,O,L,H,C)
                -0.00514193347846*PriceSeries(Price,index-86,O,L,H,C)
                -0.00481465575868*PriceSeries(Price,index-87,O,L,H,C)
                -0.00414424675032*PriceSeries(Price,index-88,O,L,H,C)
                -0.00319233276028*PriceSeries(Price,index-89,O,L,H,C)
                -0.002039043792221*PriceSeries(Price,index-90,O,L,H,C)
                -0.000776471561654*PriceSeries(Price,index-91,O,L,H,C)
                +0.000498521038475*PriceSeries(Price,index-92,O,L,H,C)
                +0.001691587778093*PriceSeries(Price,index-93,O,L,H,C)
                +0.002717746894209*PriceSeries(Price,index-94,O,L,H,C)
                +0.00350730181104*PriceSeries(Price,index-95,O,L,H,C)
                +0.00401043082915*PriceSeries(Price,index-96,O,L,H,C)
                +0.00420015569500*PriceSeries(Price,index-97,O,L,H,C)
                +0.00407352711538*PriceSeries(Price,index-98,O,L,H,C)
                +0.00365100046928*PriceSeries(Price,index-99,O,L,H,C)
                +0.002974111360437*PriceSeries(Price,index-100,O,L,H,C)
                +0.002101680640415*PriceSeries(Price,index-101,O,L,H,C)
                +0.001104877801414*PriceSeries(Price,index-102,O,L,H,C)
                +0.0000615469078352*PriceSeries(Price,index-103,O,L,H,C)
                -0.000949762002716*PriceSeries(Price,index-104,O,L,H,C)
                -0.001855607234288*PriceSeries(Price,index-105,O,L,H,C)
                -0.002592890854875*PriceSeries(Price,index-106,O,L,H,C)
                -0.003113149898365*PriceSeries(Price,index-107,O,L,H,C)
                -0.00338562034395*PriceSeries(Price,index-108,O,L,H,C)
                -0.00339888865272*PriceSeries(Price,index-109,O,L,H,C)
                -0.003161058648776*PriceSeries(Price,index-110,O,L,H,C)
                -0.002698473307311*PriceSeries(Price,index-111,O,L,H,C)
                -0.002053134100539*PriceSeries(Price,index-112,O,L,H,C)
                -0.001279054588195*PriceSeries(Price,index-113,O,L,H,C)
                -0.000437854730199*PriceSeries(Price,index-114,O,L,H,C)
                +0.000406054016116*PriceSeries(Price,index-115,O,L,H,C)
                +0.001190321561677*PriceSeries(Price,index-116,O,L,H,C)
                +0.001859190063794*PriceSeries(Price,index-117,O,L,H,C)
                +0.002367380679819*PriceSeries(Price,index-118,O,L,H,C)
                +0.002683069641025*PriceSeries(Price,index-119,O,L,H,C)
                +0.002789765520666*PriceSeries(Price,index-120,O,L,H,C)
                +0.002686988545503*PriceSeries(Price,index-121,O,L,H,C)
                +0.002389741674594*PriceSeries(Price,index-122,O,L,H,C)
                +0.001926855364748*PriceSeries(Price,index-123,O,L,H,C)
                +0.001338369148429*PriceSeries(Price,index-124,O,L,H,C)
                +0.000672175612595*PriceSeries(Price,index-125,O,L,H,C)
                -0.00001979798820084*PriceSeries(Price,index-126,O,L,H,C)
                -0.000685570553806*PriceSeries(Price,index-127,O,L,H,C)
                -0.001276951982296*PriceSeries(Price,index-128,O,L,H,C)
                -0.001752970840406*PriceSeries(Price,index-129,O,L,H,C)
                -0.002082645035437*PriceSeries(Price,index-130,O,L,H,C)
                -0.002246915605657*PriceSeries(Price,index-131,O,L,H,C)
                -0.002239628452839*PriceSeries(Price,index-132,O,L,H,C)
                -0.002067524787392*PriceSeries(Price,index-133,O,L,H,C)
                -0.001749278429169*PriceSeries(Price,index-134,O,L,H,C)
                -0.001313683509204*PriceSeries(Price,index-135,O,L,H,C)
                -0.000797157446626*PriceSeries(Price,index-136,O,L,H,C)
                -0.0002407709545551*PriceSeries(Price,index-137,O,L,H,C)
                +0.0003129598255923*PriceSeries(Price,index-138,O,L,H,C)
                +0.000823272107936*PriceSeries(Price,index-139,O,L,H,C)
                +0.001254107446936*PriceSeries(Price,index-140,O,L,H,C)
                +0.001576607478721*PriceSeries(Price,index-141,O,L,H,C)
                +0.001770984961766*PriceSeries(Price,index-142,O,L,H,C)
                +0.001827652560747*PriceSeries(Price,index-143,O,L,H,C)
                +0.001747555421899*PriceSeries(Price,index-144,O,L,H,C)
                +0.001541710752529*PriceSeries(Price,index-145,O,L,H,C)
                +0.001230016585917*PriceSeries(Price,index-146,O,L,H,C)
                +0.000839447949647*PriceSeries(Price,index-147,O,L,H,C)
                +0.000401795302492*PriceSeries(Price,index-148,O,L,H,C)
                -0.0000488705926984*PriceSeries(Price,index-149,O,L,H,C)
                -0.000478806072645*PriceSeries(Price,index-150,O,L,H,C)
                -0.000857080151897*PriceSeries(Price,index-151,O,L,H,C)
                -0.001157758603886*PriceSeries(Price,index-152,O,L,H,C)
                -0.001361632935985*PriceSeries(Price,index-153,O,L,H,C)
                -0.001457385713073*PriceSeries(Price,index-154,O,L,H,C)
                -0.001442126868402*PriceSeries(Price,index-155,O,L,H,C)
                -0.001321282479323*PriceSeries(Price,index-156,O,L,H,C)
                -0.001107872070704*PriceSeries(Price,index-157,O,L,H,C)
                -0.000821250880814*PriceSeries(Price,index-158,O,L,H,C)
                -0.000485428837765*PriceSeries(Price,index-159,O,L,H,C)
                -0.0001271110104256*PriceSeries(Price,index-160,O,L,H,C)
                +0.0002263852664901*PriceSeries(Price,index-161,O,L,H,C)
                +0.000549178904350*PriceSeries(Price,index-162,O,L,H,C)
                +0.000818684565779*PriceSeries(Price,index-163,O,L,H,C)
                +0.001017154285598*PriceSeries(Price,index-164,O,L,H,C)
                +0.001132800674000*PriceSeries(Price,index-165,O,L,H,C)
                +0.001160430913892*PriceSeries(Price,index-166,O,L,H,C)
                +0.001101566435604*PriceSeries(Price,index-167,O,L,H,C)
                +0.000964060873146*PriceSeries(Price,index-168,O,L,H,C)
                +0.000761260914968*PriceSeries(Price,index-169,O,L,H,C)
                +0.000510794109481*PriceSeries(Price,index-170,O,L,H,C)
                +0.0002330892880769*PriceSeries(Price,index-171,O,L,H,C)
                -0.0000502531993068*PriceSeries(Price,index-172,O,L,H,C)
                -0.000318110090991*PriceSeries(Price,index-173,O,L,H,C)
                -0.000551379478849*PriceSeries(Price,index-174,O,L,H,C)
                -0.000734313645756*PriceSeries(Price,index-175,O,L,H,C)
                -0.000855545549122*PriceSeries(Price,index-176,O,L,H,C)
                -0.000908746407202*PriceSeries(Price,index-177,O,L,H,C)
                -0.000892884072822*PriceSeries(Price,index-178,O,L,H,C)
                -0.000812074738335*PriceSeries(Price,index-179,O,L,H,C)
                -0.000675058133299*PriceSeries(Price,index-180,O,L,H,C)
                -0.000494353976803*PriceSeries(Price,index-181,O,L,H,C)
                -0.0002851707613206*PriceSeries(Price,index-182,O,L,H,C)
                -0.0000641617558490*PriceSeries(Price,index-183,O,L,H,C)
                +0.0001518702876005*PriceSeries(Price,index-184,O,L,H,C)
                +0.000347226443174*PriceSeries(Price,index-185,O,L,H,C)
                +0.000508427325610*PriceSeries(Price,index-186,O,L,H,C)
                +0.000625112635472*PriceSeries(Price,index-187,O,L,H,C)
                +0.000690672617208*PriceSeries(Price,index-188,O,L,H,C)
                +0.000702571275565*PriceSeries(Price,index-189,O,L,H,C)
                +0.000662350488714*PriceSeries(Price,index-190,O,L,H,C)
                +0.000575334496757*PriceSeries(Price,index-191,O,L,H,C)
                +0.000450064289205*PriceSeries(Price,index-192,O,L,H,C)
                +0.0002975168122838*PriceSeries(Price,index-193,O,L,H,C)
                +0.0001301822547539*PriceSeries(Price,index-194,O,L,H,C)
                -0.0000389320623080*PriceSeries(Price,index-195,O,L,H,C)
                -0.0001972915643760*PriceSeries(Price,index-196,O,L,H,C)
                -0.000333739518300*PriceSeries(Price,index-197,O,L,H,C)
                -0.000439261166162*PriceSeries(Price,index-198,O,L,H,C)
                -0.000507553065833*PriceSeries(Price,index-199,O,L,H,C)
                -0.000535360009836*PriceSeries(Price,index-200,O,L,H,C)
                -0.000522573480259*PriceSeries(Price,index-201,O,L,H,C)
                -0.000472090751303*PriceSeries(Price,index-202,O,L,H,C)
                -0.000389453202041*PriceSeries(Price,index-203,O,L,H,C)
                -0.0002823099910892*PriceSeries(Price,index-204,O,L,H,C)
                -0.0001597490826810*PriceSeries(Price,index-205,O,L,H,C)
                -0.00003154989707420*PriceSeries(Price,index-206,O,L,H,C)
                +0.0000925737520571*PriceSeries(Price,index-207,O,L,H,C)
                +0.0002036912419713*PriceSeries(Price,index-208,O,L,H,C)
                +0.0002942819308316*PriceSeries(Price,index-209,O,L,H,C)
                +0.000358719595000*PriceSeries(Price,index-210,O,L,H,C)
                +0.000393594900382*PriceSeries(Price,index-211,O,L,H,C)
                +0.000397858656808*PriceSeries(Price,index-212,O,L,H,C)
                +0.000372775467359*PriceSeries(Price,index-213,O,L,H,C)
                +0.000321712162216*PriceSeries(Price,index-214,O,L,H,C)
                +0.0002497819643388*PriceSeries(Price,index-215,O,L,H,C)
                +0.0001633702165624*PriceSeries(Price,index-216,O,L,H,C)
                +0.0000695959566580*PriceSeries(Price,index-217,O,L,H,C)
                -0.00002425284532893*PriceSeries(Price,index-218,O,L,H,C)
                -0.0001112738842234*PriceSeries(Price,index-219,O,L,H,C)
                -0.0001854397117477*PriceSeries(Price,index-220,O,L,H,C)
                -0.0002419966364064*PriceSeries(Price,index-221,O,L,H,C)
                -0.0002777537676268*PriceSeries(Price,index-222,O,L,H,C)
                -0.0002912309998942*PriceSeries(Price,index-223,O,L,H,C)
                -0.0002826738952373*PriceSeries(Price,index-224,O,L,H,C)
                -0.0002539452885637*PriceSeries(Price,index-225,O,L,H,C)
                -0.0002082922805462*PriceSeries(Price,index-226,O,L,H,C)
                -0.0001500275953907*PriceSeries(Price,index-227,O,L,H,C)
                -0.0000841547944821*PriceSeries(Price,index-228,O,L,H,C)
                -0.00001595157311157*PriceSeries(Price,index-229,O,L,H,C)
                +0.0000494372664806*PriceSeries(Price,index-230,O,L,H,C)
                +0.0001073695745057*PriceSeries(Price,index-231,O,L,H,C)
                +0.0001540294393516*PriceSeries(Price,index-232,O,L,H,C)
                +0.0001866608371444*PriceSeries(Price,index-233,O,L,H,C)
                +0.0002037052207480*PriceSeries(Price,index-234,O,L,H,C)
                +0.0002048544319059*PriceSeries(Price,index-235,O,L,H,C)
                +0.0001909942761419*PriceSeries(Price,index-236,O,L,H,C)
                +0.0001640612689135*PriceSeries(Price,index-237,O,L,H,C)
                +0.0001268436863433*PriceSeries(Price,index-238,O,L,H,C)
                +0.0000827157503190*PriceSeries(Price,index-239,O,L,H,C)
                +0.0000353466711109*PriceSeries(Price,index-240,O,L,H,C)
                -0.00001157975575578*PriceSeries(Price,index-241,O,L,H,C)
                -0.0000546484991006*PriceSeries(Price,index-242,O,L,H,C)
                -0.0000909532071723*PriceSeries(Price,index-243,O,L,H,C)
                -0.0001182686007646*PriceSeries(Price,index-244,O,L,H,C)
                -0.0001351840259120*PriceSeries(Price,index-245,O,L,H,C)
                -0.0001411564105099*PriceSeries(Price,index-246,O,L,H,C)
                -0.0001364804980915*PriceSeries(Price,index-247,O,L,H,C)
                -0.0001222255320615*PriceSeries(Price,index-248,O,L,H,C)
                -0.0001001012512627*PriceSeries(Price,index-249,O,L,H,C)
                -0.0000722731805685*PriceSeries(Price,index-250,O,L,H,C)
                -0.0000411896682617*PriceSeries(Price,index-251,O,L,H,C)
                -0.00000937535410546*PriceSeries(Price,index-252,O,L,H,C)
                +0.00002077574313846*PriceSeries(Price,index-253,O,L,H,C)
                +0.0000471449562922*PriceSeries(Price,index-254,O,L,H,C)
                +0.0000680389225337*PriceSeries(Price,index-255,O,L,H,C)
                +0.0000823016290360*PriceSeries(Price,index-256,O,L,H,C)
                +0.0000893330468446*PriceSeries(Price,index-257,O,L,H,C)
                +0.0000891128008216*PriceSeries(Price,index-258,O,L,H,C)
                +0.0000821724647944*PriceSeries(Price,index-259,O,L,H,C)
                +0.0000694736588631*PriceSeries(Price,index-260,O,L,H,C)
                +0.0000523302198859*PriceSeries(Price,index-261,O,L,H,C)
                +0.0000322925182387*PriceSeries(Price,index-262,O,L,H,C)
                +0.00001096215329521*PriceSeries(Price,index-263,O,L,H,C)
                -0.00001008377945370*PriceSeries(Price,index-264,O,L,H,C)
                -0.00002939782935719*PriceSeries(Price,index-265,O,L,H,C)
                -0.0000458235376180*PriceSeries(Price,index-266,O,L,H,C)
                -0.0000584822463323*PriceSeries(Price,index-267,O,L,H,C)
                -0.0000668192847094*PriceSeries(Price,index-268,O,L,H,C)
                -0.0000707176788344*PriceSeries(Price,index-269,O,L,H,C)
                -0.0000703510662098*PriceSeries(Price,index-270,O,L,H,C)
                -0.0000661717545160*PriceSeries(Price,index-271,O,L,H,C)
                -0.0000590026651274*PriceSeries(Price,index-272,O,L,H,C)
                -0.0000497066547020*PriceSeries(Price,index-273,O,L,H,C)
                -0.0000391752641209*PriceSeries(Price,index-274,O,L,H,C)
                -0.00002855347309348*PriceSeries(Price,index-275,O,L,H,C)
                -0.00001859150315065*PriceSeries(Price,index-276,O,L,H,C)
                -0.00000975354702162*PriceSeries(Price,index-277,O,L,H,C)
                -0.00000339435562938*PriceSeries(Price,index-278,O,L,H,C)
                +0.000000668613000932*PriceSeries(Price,index-279,O,L,H,C)
                +0.0001160320886133*PriceSeries(Price,index-280,O,L,H,C)
                );

      case N26:
         return(
                0.1666294395940*PriceSeries(Price,index,O,L,H,C)
                +0.1628173543380*PriceSeries(Price,index-1,O,L,H,C)
                +0.1553507416959*PriceSeries(Price,index-2,O,L,H,C)
                +0.1445369377812*PriceSeries(Price,index-3,O,L,H,C)
                +0.1308179133306*PriceSeries(Price,index-4,O,L,H,C)
                +0.1147485891128*PriceSeries(Price,index-5,O,L,H,C)
                +0.0969697661496*PriceSeries(Price,index-6,O,L,H,C)
                +0.0781771336223*PriceSeries(Price,index-7,O,L,H,C)
                +0.0590879859864*PriceSeries(Price,index-8,O,L,H,C)
                +0.0404074281818*PriceSeries(Price,index-9,O,L,H,C)
                +0.02279581699694*PriceSeries(Price,index-10,O,L,H,C)
                +0.00683913703972*PriceSeries(Price,index-11,O,L,H,C)
                -0.00697621260258*PriceSeries(Price,index-12,O,L,H,C)
                -0.01828296302250*PriceSeries(Price,index-13,O,L,H,C)
                -0.02684596854133*PriceSeries(Price,index-14,O,L,H,C)
                -0.0325680923638*PriceSeries(Price,index-15,O,L,H,C)
                -0.0354888745658*PriceSeries(Price,index-16,O,L,H,C)
                -0.0357762208490*PriceSeries(Price,index-17,O,L,H,C)
                -0.0337117781105*PriceSeries(Price,index-18,O,L,H,C)
                -0.02967094518539*PriceSeries(Price,index-19,O,L,H,C)
                -0.02409879140480*PriceSeries(Price,index-20,O,L,H,C)
                -0.01748328938013*PriceSeries(Price,index-21,O,L,H,C)
                -0.01032744837226*PriceSeries(Price,index-22,O,L,H,C)
                -0.003121874438291*PriceSeries(Price,index-23,O,L,H,C)
                +0.00368070675591*PriceSeries(Price,index-24,O,L,H,C)
                +0.00968767057345*PriceSeries(Price,index-25,O,L,H,C)
                +0.01458429841009*PriceSeries(Price,index-26,O,L,H,C)
                +0.01814639495936*PriceSeries(Price,index-27,O,L,H,C)
                +0.02024716491443*PriceSeries(Price,index-28,O,L,H,C)
                +0.02085825429800*PriceSeries(Price,index-29,O,L,H,C)
                +0.02004508484746*PriceSeries(Price,index-30,O,L,H,C)
                +0.01795705653637*PriceSeries(Price,index-31,O,L,H,C)
                +0.01481335302996*PriceSeries(Price,index-32,O,L,H,C)
                +0.01088542772184*PriceSeries(Price,index-33,O,L,H,C)
                +0.00647729077138*PriceSeries(Price,index-34,O,L,H,C)
                +0.001904918842661*PriceSeries(Price,index-35,O,L,H,C)
                -0.002524006029813*PriceSeries(Price,index-36,O,L,H,C)
                -0.00652877406485*PriceSeries(Price,index-37,O,L,H,C)
                -0.00987174503161*PriceSeries(Price,index-38,O,L,H,C)
                -0.01237095133348*PriceSeries(Price,index-39,O,L,H,C)
                -0.01390865115557*PriceSeries(Price,index-40,O,L,H,C)
                -0.01443543785526*PriceSeries(Price,index-41,O,L,H,C)
                -0.01396990646193*PriceSeries(Price,index-42,O,L,H,C)
                -0.01259403568763*PriceSeries(Price,index-43,O,L,H,C)
                -0.01044482755872*PriceSeries(Price,index-44,O,L,H,C)
                -0.00770282448085*PriceSeries(Price,index-45,O,L,H,C)
                -0.00457842596510*PriceSeries(Price,index-46,O,L,H,C)
                -0.001296893546631*PriceSeries(Price,index-47,O,L,H,C)
                +0.001916882750943*PriceSeries(Price,index-48,O,L,H,C)
                +0.00485295318198*PriceSeries(Price,index-49,O,L,H,C)
                +0.00732924012283*PriceSeries(Price,index-50,O,L,H,C)
                +0.00920215436838*PriceSeries(Price,index-51,O,L,H,C)
                +0.01037423211759*PriceSeries(Price,index-52,O,L,H,C)
                +0.01079850439524*PriceSeries(Price,index-53,O,L,H,C)
                +0.01047937721064*PriceSeries(Price,index-54,O,L,H,C)
                +0.00947017396104*PriceSeries(Price,index-55,O,L,H,C)
                +0.00786756492033*PriceSeries(Price,index-56,O,L,H,C)
                +0.00580343432158*PriceSeries(Price,index-57,O,L,H,C)
                +0.00343474573522*PriceSeries(Price,index-58,O,L,H,C)
                +0.000932205565204*PriceSeries(Price,index-59,O,L,H,C)
                -0.001531554332136*PriceSeries(Price,index-60,O,L,H,C)
                -0.00379342693348*PriceSeries(Price,index-61,O,L,H,C)
                -0.00571023567216*PriceSeries(Price,index-62,O,L,H,C)
                -0.00716740411002*PriceSeries(Price,index-63,O,L,H,C)
                -0.00808543909217*PriceSeries(Price,index-64,O,L,H,C)
                -0.00842382631499*PriceSeries(Price,index-65,O,L,H,C)
                -0.00818224175749*PriceSeries(Price,index-66,O,L,H,C)
                -0.00739903340464*PriceSeries(Price,index-67,O,L,H,C)
                -0.00614723551299*PriceSeries(Price,index-68,O,L,H,C)
                -0.00452840495692*PriceSeries(Price,index-69,O,L,H,C)
                -0.002664827170447*PriceSeries(Price,index-70,O,L,H,C)
                -0.000690601428245*PriceSeries(Price,index-71,O,L,H,C)
                +0.001257702010843*PriceSeries(Price,index-72,O,L,H,C)
                +0.003050247706545*PriceSeries(Price,index-73,O,L,H,C)
                +0.00457232818573*PriceSeries(Price,index-74,O,L,H,C)
                +0.00573148593560*PriceSeries(Price,index-75,O,L,H,C)
                +0.00646287658211*PriceSeries(Price,index-76,O,L,H,C)
                +0.00673262907922*PriceSeries(Price,index-77,O,L,H,C)
                +0.00653900298826*PriceSeries(Price,index-78,O,L,H,C)
                +0.00591138639042*PriceSeries(Price,index-79,O,L,H,C)
                +0.00490723246691*PriceSeries(Price,index-80,O,L,H,C)
                +0.00360724858450*PriceSeries(Price,index-81,O,L,H,C)
                +0.002109180411481*PriceSeries(Price,index-82,O,L,H,C)
                +0.000520685969653*PriceSeries(Price,index-83,O,L,H,C)
                -0.001048219790516*PriceSeries(Price,index-84,O,L,H,C)
                -0.002492614488257*PriceSeries(Price,index-85,O,L,H,C)
                -0.00371953344866*PriceSeries(Price,index-86,O,L,H,C)
                -0.00465379002149*PriceSeries(Price,index-87,O,L,H,C)
                -0.00524242549543*PriceSeries(Price,index-88,O,L,H,C)
                -0.00545750583360*PriceSeries(Price,index-89,O,L,H,C)
                -0.00529716207679*PriceSeries(Price,index-90,O,L,H,C)
                -0.00478483512551*PriceSeries(Price,index-91,O,L,H,C)
                -0.00396686086610*PriceSeries(Price,index-92,O,L,H,C)
                -0.002908587992388*PriceSeries(Price,index-93,O,L,H,C)
                -0.001689360654383*PriceSeries(Price,index-94,O,L,H,C)
                -0.000396710822938*PriceSeries(Price,index-95,O,L,H,C)
                +0.000879789765209*PriceSeries(Price,index-96,O,L,H,C)
                +0.002054627233114*PriceSeries(Price,index-97,O,L,H,C)
                +0.003051963131125*PriceSeries(Price,index-98,O,L,H,C)
                +0.00381041926197*PriceSeries(Price,index-99,O,L,H,C)
                +0.00428673453236*PriceSeries(Price,index-100,O,L,H,C)
                +0.00445808124073*PriceSeries(Price,index-101,O,L,H,C)
                +0.00432293545194*PriceSeries(Price,index-102,O,L,H,C)
                +0.00390047982919*PriceSeries(Price,index-103,O,L,H,C)
                +0.00322863789165*PriceSeries(Price,index-104,O,L,H,C)
                +0.002360900564698*PriceSeries(Price,index-105,O,L,H,C)
                +0.001362223947381*PriceSeries(Price,index-106,O,L,H,C)
                +0.0003042654981146*PriceSeries(Price,index-107,O,L,H,C)
                -0.000739655523175*PriceSeries(Price,index-108,O,L,H,C)
                -0.001699562447395*PriceSeries(Price,index-109,O,L,H,C)
                -0.002513426106706*PriceSeries(Price,index-110,O,L,H,C)
                -0.003131095849488*PriceSeries(Price,index-111,O,L,H,C)
                -0.00351729092353*PriceSeries(Price,index-112,O,L,H,C)
                -0.00365350345471*PriceSeries(Price,index-113,O,L,H,C)
                -0.00353869461788*PriceSeries(Price,index-114,O,L,H,C)
                -0.00318880543804*PriceSeries(Price,index-115,O,L,H,C)
                -0.002635122440020*PriceSeries(Price,index-116,O,L,H,C)
                -0.001921669468300*PriceSeries(Price,index-117,O,L,H,C)
                -0.001101819152044*PriceSeries(Price,index-118,O,L,H,C)
                -0.0002343903241077*PriceSeries(Price,index-119,O,L,H,C)
                +0.000620511360898*PriceSeries(Price,index-120,O,L,H,C)
                +0.001405581965822*PriceSeries(Price,index-121,O,L,H,C)
                +0.002070112948818*PriceSeries(Price,index-122,O,L,H,C)
                +0.002573185523272*PriceSeries(Price,index-123,O,L,H,C)
                +0.002886132427232*PriceSeries(Price,index-124,O,L,H,C)
                +0.002994058715855*PriceSeries(Price,index-125,O,L,H,C)
                +0.002896413597736*PriceSeries(Price,index-126,O,L,H,C)
                +0.002606538981259*PriceSeries(Price,index-127,O,L,H,C)
                +0.002150337206774*PriceSeries(Price,index-128,O,L,H,C)
                +0.001564080920580*PriceSeries(Price,index-129,O,L,H,C)
                +0.000891645572676*PriceSeries(Price,index-130,O,L,H,C)
                +0.0001812720326131*PriceSeries(Price,index-131,O,L,H,C)
                -0.000517819673762*PriceSeries(Price,index-132,O,L,H,C)
                -0.001158808300668*PriceSeries(Price,index-133,O,L,H,C)
                -0.001700341695774*PriceSeries(Price,index-134,O,L,H,C)
                -0.002109168547271*PriceSeries(Price,index-135,O,L,H,C)
                -0.002362099747035*PriceSeries(Price,index-136,O,L,H,C)
                -0.002447263076866*PriceSeries(Price,index-137,O,L,H,C)
                -0.002364511995296*PriceSeries(Price,index-138,O,L,H,C)
                -0.002125056771273*PriceSeries(Price,index-139,O,L,H,C)
                -0.001750317473501*PriceSeries(Price,index-140,O,L,H,C)
                -0.001270145366466*PriceSeries(Price,index-141,O,L,H,C)
                -0.000720503767054*PriceSeries(Price,index-142,O,L,H,C)
                -0.0001408498424177*PriceSeries(Price,index-143,O,L,H,C)
                +0.000428675825623*PriceSeries(Price,index-144,O,L,H,C)
                +0.000949962304153*PriceSeries(Price,index-145,O,L,H,C)
                +0.001389465344831*PriceSeries(Price,index-146,O,L,H,C)
                +0.001720297923355*PriceSeries(Price,index-147,O,L,H,C)
                +0.001923845876700*PriceSeries(Price,index-148,O,L,H,C)
                +0.001990719633158*PriceSeries(Price,index-149,O,L,H,C)
                +0.001921107514710*PriceSeries(Price,index-150,O,L,H,C)
                +0.001724397568725*PriceSeries(Price,index-151,O,L,H,C)
                +0.001418261464367*PriceSeries(Price,index-152,O,L,H,C)
                +0.001027142150817*PriceSeries(Price,index-153,O,L,H,C)
                +0.000580392790592*PriceSeries(Price,index-154,O,L,H,C)
                +0.0001100960430329*PriceSeries(Price,index-155,O,L,H,C)
                -0.000351182646859*PriceSeries(Price,index-156,O,L,H,C)
                -0.000772634837186*PriceSeries(Price,index-157,O,L,H,C)
                -0.001127211389340*PriceSeries(Price,index-158,O,L,H,C)
                -0.001393346610431*PriceSeries(Price,index-159,O,L,H,C)
                -0.001556204068819*PriceSeries(Price,index-160,O,L,H,C)
                -0.001608456682244*PriceSeries(Price,index-161,O,L,H,C)
                -0.001550509508477*PriceSeries(Price,index-162,O,L,H,C)
                -0.001390206550882*PriceSeries(Price,index-163,O,L,H,C)
                -0.001142022033641*PriceSeries(Price,index-164,O,L,H,C)
                -0.000825860050055*PriceSeries(Price,index-165,O,L,H,C)
                -0.000465491344700*PriceSeries(Price,index-166,O,L,H,C)
                -0.0000868311462400*PriceSeries(Price,index-167,O,L,H,C)
                +0.0002839208600968*PriceSeries(Price,index-168,O,L,H,C)
                +0.000622041216367*PriceSeries(Price,index-169,O,L,H,C)
                +0.000905921886252*PriceSeries(Price,index-170,O,L,H,C)
                +0.001118397841590*PriceSeries(Price,index-171,O,L,H,C)
                +0.001247777455679*PriceSeries(Price,index-172,O,L,H,C)
                +0.001288395961099*PriceSeries(Price,index-173,O,L,H,C)
                +0.001240812982544*PriceSeries(Price,index-174,O,L,H,C)
                +0.001111512313312*PriceSeries(Price,index-175,O,L,H,C)
                +0.000912270095935*PriceSeries(Price,index-176,O,L,H,C)
                +0.000659139544932*PriceSeries(Price,index-177,O,L,H,C)
                +0.000371215887106*PriceSeries(Price,index-178,O,L,H,C)
                +0.0000692208259218*PriceSeries(Price,index-179,O,L,H,C)
                -0.0002259493618665*PriceSeries(Price,index-180,O,L,H,C)
                -0.000494663043384*PriceSeries(Price,index-181,O,L,H,C)
                -0.000719820646835*PriceSeries(Price,index-182,O,L,H,C)
                -0.000887918136034*PriceSeries(Price,index-183,O,L,H,C)
                -0.000989830340001*PriceSeries(Price,index-184,O,L,H,C)
                -0.001021251828002*PriceSeries(Price,index-185,O,L,H,C)
                -0.000982808512259*PriceSeries(Price,index-186,O,L,H,C)
                -0.000879820504001*PriceSeries(Price,index-187,O,L,H,C)
                -0.000721754906982*PriceSeries(Price,index-188,O,L,H,C)
                -0.000521436222429*PriceSeries(Price,index-189,O,L,H,C)
                -0.0002940278081103*PriceSeries(Price,index-190,O,L,H,C)
                -0.0000559239274731*PriceSeries(Price,index-191,O,L,H,C)
                +0.0001764120763398*PriceSeries(Price,index-192,O,L,H,C)
                +0.000387560606342*PriceSeries(Price,index-193,O,L,H,C)
                +0.000564164198540*PriceSeries(Price,index-194,O,L,H,C)
                +0.000695723632217*PriceSeries(Price,index-195,O,L,H,C)
                +0.000775220164551*PriceSeries(Price,index-196,O,L,H,C)
                +0.000799424544481*PriceSeries(Price,index-197,O,L,H,C)
                +0.000768981302286*PriceSeries(Price,index-198,O,L,H,C)
                +0.000688196916395*PriceSeries(Price,index-199,O,L,H,C)
                +0.000564590537262*PriceSeries(Price,index-200,O,L,H,C)
                +0.000408267232246*PriceSeries(Price,index-201,O,L,H,C)
                +0.0002311164118493*PriceSeries(Price,index-202,O,L,H,C)
                +0.0000459334922028*PriceSeries(Price,index-203,O,L,H,C)
                -0.0001344891109130*PriceSeries(Price,index-204,O,L,H,C)
                -0.0002982079565757*PriceSeries(Price,index-205,O,L,H,C)
                -0.000434934573364*PriceSeries(Price,index-206,O,L,H,C)
                -0.000536621714724*PriceSeries(Price,index-207,O,L,H,C)
                -0.000597954442806*PriceSeries(Price,index-208,O,L,H,C)
                -0.000616550586244*PriceSeries(Price,index-209,O,L,H,C)
                -0.000593025396915*PriceSeries(Price,index-210,O,L,H,C)
                -0.000530808265888*PriceSeries(Price,index-211,O,L,H,C)
                -0.000435788697718*PriceSeries(Price,index-212,O,L,H,C)
                -0.0003157995061023*PriceSeries(Price,index-213,O,L,H,C)
                -0.0001800244833827*PriceSeries(Price,index-214,O,L,H,C)
                -0.0000382931447184*PriceSeries(Price,index-215,O,L,H,C)
                +0.0000996046567897*PriceSeries(Price,index-216,O,L,H,C)
                +0.0002245749548364*PriceSeries(Price,index-217,O,L,H,C)
                +0.000328815415912*PriceSeries(Price,index-218,O,L,H,C)
                +0.000406268948208*PriceSeries(Price,index-219,O,L,H,C)
                +0.000452969184971*PriceSeries(Price,index-220,O,L,H,C)
                +0.000467214555435*PriceSeries(Price,index-221,O,L,H,C)
                +0.000449547480861*PriceSeries(Price,index-222,O,L,H,C)
                +0.000402662637380*PriceSeries(Price,index-223,O,L,H,C)
                +0.000331080834249*PriceSeries(Price,index-224,O,L,H,C)
                +0.0002407849334249*PriceSeries(Price,index-225,O,L,H,C)
                +0.0001387153593368*PriceSeries(Price,index-226,O,L,H,C)
                +0.0000323041550394*PriceSeries(Price,index-227,O,L,H,C)
                -0.0000711208704864*PriceSeries(Price,index-228,O,L,H,C)
                -0.0001647439496797*PriceSeries(Price,index-229,O,L,H,C)
                -0.0002427948636583*PriceSeries(Price,index-230,O,L,H,C)
                -0.0003007842452115*PriceSeries(Price,index-231,O,L,H,C)
                -0.000335830503495*PriceSeries(Price,index-232,O,L,H,C)
                -0.000346727003228*PriceSeries(Price,index-233,O,L,H,C)
                -0.000333964142044*PriceSeries(Price,index-234,O,L,H,C)
                -0.0002995776626089*PriceSeries(Price,index-235,O,L,H,C)
                -0.0002469887602073*PriceSeries(Price,index-236,O,L,H,C)
                -0.0001806444860244*PriceSeries(Price,index-237,O,L,H,C)
                -0.0001057029293803*PriceSeries(Price,index-238,O,L,H,C)
                -0.00002763001885583*PriceSeries(Price,index-239,O,L,H,C)
                +0.0000481865320782*PriceSeries(Price,index-240,O,L,H,C)
                +0.0001167746616166*PriceSeries(Price,index-241,O,L,H,C)
                +0.0001739292901296*PriceSeries(Price,index-242,O,L,H,C)
                +0.0002164453115539*PriceSeries(Price,index-243,O,L,H,C)
                +0.0002422344149444*PriceSeries(Price,index-244,O,L,H,C)
                +0.0002504954149642*PriceSeries(Price,index-245,O,L,H,C)
                +0.0002416167652125*PriceSeries(Price,index-246,O,L,H,C)
                +0.0002171417391866*PriceSeries(Price,index-247,O,L,H,C)
                +0.0001795458485014*PriceSeries(Price,index-248,O,L,H,C)
                +0.0001320981842335*PriceSeries(Price,index-249,O,L,H,C)
                +0.0000784868395212*PriceSeries(Price,index-250,O,L,H,C)
                +0.00002268601782710*PriceSeries(Price,index-251,O,L,H,C)
                -0.00003151676344895*PriceSeries(Price,index-252,O,L,H,C)
                -0.0000805445898702*PriceSeries(Price,index-253,O,L,H,C)
                -0.0001214542566158*PriceSeries(Price,index-254,O,L,H,C)
                -0.0001519921434518*PriceSeries(Price,index-255,O,L,H,C)
                -0.0001707479055762*PriceSeries(Price,index-256,O,L,H,C)
                -0.0001771529464869*PriceSeries(Price,index-257,O,L,H,C)
                -0.0001715555630290*PriceSeries(Price,index-258,O,L,H,C)
                -0.0001550506054591*PriceSeries(Price,index-259,O,L,H,C)
                -0.0001294245918321*PriceSeries(Price,index-260,O,L,H,C)
                -0.0000969629893874*PriceSeries(Price,index-261,O,L,H,C)
                -0.0000602461816842*PriceSeries(Price,index-262,O,L,H,C)
                -0.00002206772262099*PriceSeries(Price,index-263,O,L,H,C)
                +0.00001495272185959*PriceSeries(Price,index-264,O,L,H,C)
                +0.0000483894499211*PriceSeries(Price,index-265,O,L,H,C)
                +0.0000761586398310*PriceSeries(Price,index-266,O,L,H,C)
                +0.0000967638849412*PriceSeries(Price,index-267,O,L,H,C)
                +0.0001092300493242*PriceSeries(Price,index-268,O,L,H,C)
                +0.0001132106035381*PriceSeries(Price,index-269,O,L,H,C)
                +0.0001089017615573*PriceSeries(Price,index-270,O,L,H,C)
                +0.0000971017126105*PriceSeries(Price,index-271,O,L,H,C)
                +0.0000789633062168*PriceSeries(Price,index-272,O,L,H,C)
                +0.0000561491017021*PriceSeries(Price,index-273,O,L,H,C)
                +0.00003020853997474*PriceSeries(Price,index-274,O,L,H,C)
                +0.000003160908147296*PriceSeries(Price,index-275,O,L,H,C)
                -0.00002330255998644*PriceSeries(Price,index-276,O,L,H,C)
                -0.0000475867306069*PriceSeries(Price,index-277,O,L,H,C)
                -0.0000683392837222*PriceSeries(Price,index-278,O,L,H,C)
                -0.0000844990439121*PriceSeries(Price,index-279,O,L,H,C)
                -0.0000954620260702*PriceSeries(Price,index-280,O,L,H,C)
                -0.0001009614295176*PriceSeries(Price,index-281,O,L,H,C)
                -0.0001011244998274*PriceSeries(Price,index-282,O,L,H,C)
                -0.0000964251801897*PriceSeries(Price,index-283,O,L,H,C)
                -0.0000872998506353*PriceSeries(Price,index-284,O,L,H,C)
                -0.0000752911784753*PriceSeries(Price,index-285,O,L,H,C)
                -0.0000608080561410*PriceSeries(Price,index-286,O,L,H,C)
                -0.0000452056647530*PriceSeries(Price,index-287,O,L,H,C)
                -0.00002970100471144*PriceSeries(Price,index-288,O,L,H,C)
                -0.00001518252978933*PriceSeries(Price,index-289,O,L,H,C)
                -0.000002402416633150*PriceSeries(Price,index-290,O,L,H,C)
                +0.00000808968872476*PriceSeries(Price,index-291,O,L,H,C)
                +0.00001586158091515*PriceSeries(Price,index-292,O,L,H,C)
                +0.00002073765376291*PriceSeries(Price,index-293,O,L,H,C)
                +0.00002270524850423*PriceSeries(Price,index-294,O,L,H,C)
                +0.0001335529803831*PriceSeries(Price,index-295,O,L,H,C)
                );

      case N27:
         return(
                0.1597915691403*PriceSeries(Price,index,O,L,H,C)
                +0.1564241406126*PriceSeries(Price,index-1,O,L,H,C)
                +0.1498174536330*PriceSeries(Price,index-2,O,L,H,C)
                +0.1402220214517*PriceSeries(Price,index-3,O,L,H,C)
                +0.1279993363554*PriceSeries(Price,index-4,O,L,H,C)
                +0.1136055283261*PriceSeries(Price,index-5,O,L,H,C)
                +0.0975708615467*PriceSeries(Price,index-6,O,L,H,C)
                +0.0804760765038*PriceSeries(Price,index-7,O,L,H,C)
                +0.0629267346625*PriceSeries(Price,index-8,O,L,H,C)
                +0.0455268224282*PriceSeries(Price,index-9,O,L,H,C)
                +0.02885288570881*PriceSeries(Price,index-10,O,L,H,C)
                +0.01342993144853*PriceSeries(Price,index-11,O,L,H,C)
                -0.0002897794016599*PriceSeries(Price,index-12,O,L,H,C)
                -0.01194406475778*PriceSeries(Price,index-13,O,L,H,C)
                -0.02127353403575*PriceSeries(Price,index-14,O,L,H,C)
                -0.02812914409828*PriceSeries(Price,index-15,O,L,H,C)
                -0.0324743749838*PriceSeries(Price,index-16,O,L,H,C)
                -0.0343820180133*PriceSeries(Price,index-17,O,L,H,C)
                -0.0340259099973*PriceSeries(Price,index-18,O,L,H,C)
                -0.0316681275487*PriceSeries(Price,index-19,O,L,H,C)
                -0.02764243787567*PriceSeries(Price,index-20,O,L,H,C)
                -0.02233490644569*PriceSeries(Price,index-21,O,L,H,C)
                -0.01616276176976*PriceSeries(Price,index-22,O,L,H,C)
                -0.00955259361495*PriceSeries(Price,index-23,O,L,H,C)
                -0.002919048723976*PriceSeries(Price,index-24,O,L,H,C)
                +0.00335495227620*PriceSeries(Price,index-25,O,L,H,C)
                +0.00893548058904*PriceSeries(Price,index-26,O,L,H,C)
                +0.01355159188896*PriceSeries(Price,index-27,O,L,H,C)
                +0.01700541649751*PriceSeries(Price,index-28,O,L,H,C)
                +0.01917800349869*PriceSeries(Price,index-29,O,L,H,C)
                +0.02003074851247*PriceSeries(Price,index-30,O,L,H,C)
                +0.01960254695544*PriceSeries(Price,index-31,O,L,H,C)
                +0.01800296108103*PriceSeries(Price,index-32,O,L,H,C)
                +0.01540196601897*PriceSeries(Price,index-33,O,L,H,C)
                +0.01201693385730*PriceSeries(Price,index-34,O,L,H,C)
                +0.00809771418939*PriceSeries(Price,index-35,O,L,H,C)
                +0.00391066299125*PriceSeries(Price,index-36,O,L,H,C)
                -0.0002774206826653*PriceSeries(Price,index-37,O,L,H,C)
                -0.00421460824376*PriceSeries(Price,index-38,O,L,H,C)
                -0.00767753561351*PriceSeries(Price,index-39,O,L,H,C)
                -0.01048284738575*PriceSeries(Price,index-40,O,L,H,C)
                -0.01249578609206*PriceSeries(Price,index-41,O,L,H,C)
                -0.01363562422185*PriceSeries(Price,index-42,O,L,H,C)
                -0.01387770860292*PriceSeries(Price,index-43,O,L,H,C)
                -0.01325220802847*PriceSeries(Price,index-44,O,L,H,C)
                -0.01183970986198*PriceSeries(Price,index-45,O,L,H,C)
                -0.00976411560924*PriceSeries(Price,index-46,O,L,H,C)
                -0.00718329207836*PriceSeries(Price,index-47,O,L,H,C)
                -0.00427817843418*PriceSeries(Price,index-48,O,L,H,C)
                -0.001240978636571*PriceSeries(Price,index-49,O,L,H,C)
                +0.001736777872606*PriceSeries(Price,index-50,O,L,H,C)
                +0.00447565484922*PriceSeries(Price,index-51,O,L,H,C)
                +0.00681851082806*PriceSeries(Price,index-52,O,L,H,C)
                +0.00863898475109*PriceSeries(Price,index-53,O,L,H,C)
                +0.00984777895861*PriceSeries(Price,index-54,O,L,H,C)
                +0.01039650597940*PriceSeries(Price,index-55,O,L,H,C)
                +0.01027891599363*PriceSeries(Price,index-56,O,L,H,C)
                +0.00952958162221*PriceSeries(Price,index-57,O,L,H,C)
                +0.00822016469343*PriceSeries(Price,index-58,O,L,H,C)
                +0.00645362518447*PriceSeries(Price,index-59,O,L,H,C)
                +0.00435674775779*PriceSeries(Price,index-60,O,L,H,C)
                +0.002071547588454*PriceSeries(Price,index-61,O,L,H,C)
                -0.0002539520679646*PriceSeries(Price,index-62,O,L,H,C)
                -0.002474926529536*PriceSeries(Price,index-63,O,L,H,C)
                -0.00445845447476*PriceSeries(Price,index-64,O,L,H,C)
                -0.00609115204847*PriceSeries(Price,index-65,O,L,H,C)
                -0.00728537868330*PriceSeries(Price,index-66,O,L,H,C)
                -0.00798362421969*PriceSeries(Price,index-67,O,L,H,C)
                -0.00816094227399*PriceSeries(Price,index-68,O,L,H,C)
                -0.00782528518514*PriceSeries(Price,index-69,O,L,H,C)
                -0.00701586086020*PriceSeries(Price,index-70,O,L,H,C)
                -0.00579960847692*PriceSeries(Price,index-71,O,L,H,C)
                -0.00426613695365*PriceSeries(Price,index-72,O,L,H,C)
                -0.002521431165737*PriceSeries(Price,index-73,O,L,H,C)
                -0.000680795288546*PriceSeries(Price,index-74,O,L,H,C)
                +0.001138555225470*PriceSeries(Price,index-75,O,L,H,C)
                +0.002824744744311*PriceSeries(Price,index-76,O,L,H,C)
                +0.00427793878083*PriceSeries(Price,index-77,O,L,H,C)
                +0.00541606426965*PriceSeries(Price,index-78,O,L,H,C)
                +0.00617927068737*PriceSeries(Price,index-79,O,L,H,C)
                +0.00653286200828*PriceSeries(Price,index-80,O,L,H,C)
                +0.00646860376302*PriceSeries(Price,index-81,O,L,H,C)
                +0.00600435039667*PriceSeries(Price,index-82,O,L,H,C)
                +0.00518209642471*PriceSeries(Price,index-83,O,L,H,C)
                +0.00406458619254*PriceSeries(Price,index-84,O,L,H,C)
                +0.002730781335019*PriceSeries(Price,index-85,O,L,H,C)
                +0.001270452455322*PriceSeries(Price,index-86,O,L,H,C)
                -0.0002216999790227*PriceSeries(Price,index-87,O,L,H,C)
                -0.001652063088047*PriceSeries(Price,index-88,O,L,H,C)
                -0.002933848438647*PriceSeries(Price,index-89,O,L,H,C)
                -0.00399224780113*PriceSeries(Price,index-90,O,L,H,C)
                -0.00476866758051*PriceSeries(Price,index-91,O,L,H,C)
                -0.00522385194257*PriceSeries(Price,index-92,O,L,H,C)
                -0.00533968873841*PriceSeries(Price,index-93,O,L,H,C)
                -0.00511967728875*PriceSeries(Price,index-94,O,L,H,C)
                -0.00458802982668*PriceSeries(Price,index-95,O,L,H,C)
                -0.00378753022360*PriceSeries(Price,index-96,O,L,H,C)
                -0.002776303218787*PriceSeries(Price,index-97,O,L,H,C)
                -0.001623741718731*PriceSeries(Price,index-98,O,L,H,C)
                -0.000405856459034*PriceSeries(Price,index-99,O,L,H,C)
                +0.000799637959391*PriceSeries(Price,index-100,O,L,H,C)
                +0.001918195394447*PriceSeries(Price,index-101,O,L,H,C)
                +0.002882961824622*PriceSeries(Price,index-102,O,L,H,C)
                +0.00363868470455*PriceSeries(Price,index-103,O,L,H,C)
                +0.00414479108643*PriceSeries(Price,index-104,O,L,H,C)
                +0.00437745320474*PriceSeries(Price,index-105,O,L,H,C)
                +0.00433055805952*PriceSeries(Price,index-106,O,L,H,C)
                +0.00401555043307*PriceSeries(Price,index-107,O,L,H,C)
                +0.00346018766948*PriceSeries(Price,index-108,O,L,H,C)
                +0.002706322652375*PriceSeries(Price,index-109,O,L,H,C)
                +0.001806875953285*PriceSeries(Price,index-110,O,L,H,C)
                +0.000822215646746*PriceSeries(Price,index-111,O,L,H,C)
                -0.0001838184802966*PriceSeries(Price,index-112,O,L,H,C)
                -0.001147988287218*PriceSeries(Price,index-113,O,L,H,C)
                -0.002011570519151*PriceSeries(Price,index-114,O,L,H,C)
                -0.002723867396034*PriceSeries(Price,index-115,O,L,H,C)
                -0.00324512149011*PriceSeries(Price,index-116,O,L,H,C)
                -0.00354865917988*PriceSeries(Price,index-117,O,L,H,C)
                -0.00362215198906*PriceSeries(Price,index-118,O,L,H,C)
                -0.00346795891291*PriceSeries(Price,index-119,O,L,H,C)
                -0.003102532010829*PriceSeries(Price,index-120,O,L,H,C)
                -0.002554978601836*PriceSeries(Price,index-121,O,L,H,C)
                -0.001864860156707*PriceSeries(Price,index-122,O,L,H,C)
                -0.001079425963600*PriceSeries(Price,index-123,O,L,H,C)
                -0.0002504335381096*PriceSeries(Price,index-124,O,L,H,C)
                +0.000569198047654*PriceSeries(Price,index-125,O,L,H,C)
                +0.001328732793429*PriceSeries(Price,index-126,O,L,H,C)
                +0.001982692895224*PriceSeries(Price,index-127,O,L,H,C)
                +0.002493548873864*PriceSeries(Price,index-128,O,L,H,C)
                +0.002833805891811*PriceSeries(Price,index-129,O,L,H,C)
                +0.002987425296229*PriceSeries(Price,index-130,O,L,H,C)
                +0.002950469088622*PriceSeries(Price,index-131,O,L,H,C)
                +0.002730990481131*PriceSeries(Price,index-132,O,L,H,C)
                +0.002348163419714*PriceSeries(Price,index-133,O,L,H,C)
                +0.001830762561856*PriceSeries(Price,index-134,O,L,H,C)
                +0.001215068815765*PriceSeries(Price,index-135,O,L,H,C)
                +0.000542394448359*PriceSeries(Price,index-136,O,L,H,C)
                -0.0001436512105154*PriceSeries(Price,index-137,O,L,H,C)
                -0.000799944991012*PriceSeries(Price,index-138,O,L,H,C)
                -0.001386528400298*PriceSeries(Price,index-139,O,L,H,C)
                -0.001868992542458*PriceSeries(Price,index-140,O,L,H,C)
                -0.002220468236783*PriceSeries(Price,index-141,O,L,H,C)
                -0.002423056954707*PriceSeries(Price,index-142,O,L,H,C)
                -0.002468691634948*PriceSeries(Price,index-143,O,L,H,C)
                -0.002359320182959*PriceSeries(Price,index-144,O,L,H,C)
                -0.002106499309753*PriceSeries(Price,index-145,O,L,H,C)
                -0.001730362900029*PriceSeries(Price,index-146,O,L,H,C)
                -0.001258121211570*PriceSeries(Price,index-147,O,L,H,C)
                -0.000722125646542*PriceSeries(Price,index-148,O,L,H,C)
                -0.0001577208639138*PriceSeries(Price,index-149,O,L,H,C)
                +0.000399080676345*PriceSeries(Price,index-150,O,L,H,C)
                +0.000913839542930*PriceSeries(Price,index-151,O,L,H,C)
                +0.001355811442158*PriceSeries(Price,index-152,O,L,H,C)
                +0.001699730371873*PriceSeries(Price,index-153,O,L,H,C)
                +0.001927233662601*PriceSeries(Price,index-154,O,L,H,C)
                +0.002027778284845*PriceSeries(Price,index-155,O,L,H,C)
                +0.001999069949459*PriceSeries(Price,index-156,O,L,H,C)
                +0.001846931529216*PriceSeries(Price,index-157,O,L,H,C)
                +0.001584707086565*PriceSeries(Price,index-158,O,L,H,C)
                +0.001232176230814*PriceSeries(Price,index-159,O,L,H,C)
                +0.000814129686940*PriceSeries(Price,index-160,O,L,H,C)
                +0.000358657231381*PriceSeries(Price,index-161,O,L,H,C)
                -0.0001046992704075*PriceSeries(Price,index-162,O,L,H,C)
                -0.000546849101362*PriceSeries(Price,index-163,O,L,H,C)
                -0.000940937453435*PriceSeries(Price,index-164,O,L,H,C)
                -0.001263969718878*PriceSeries(Price,index-165,O,L,H,C)
                -0.001498099880510*PriceSeries(Price,index-166,O,L,H,C)
                -0.001631606657471*PriceSeries(Price,index-167,O,L,H,C)
                -0.001659405389539*PriceSeries(Price,index-168,O,L,H,C)
                -0.001583172442668*PriceSeries(Price,index-169,O,L,H,C)
                -0.001411002849700*PriceSeries(Price,index-170,O,L,H,C)
                -0.001156725585664*PriceSeries(Price,index-171,O,L,H,C)
                -0.000838821546240*PriceSeries(Price,index-172,O,L,H,C)
                -0.000479152771055*PriceSeries(Price,index-173,O,L,H,C)
                -0.0001014580313488*PriceSeries(Price,index-174,O,L,H,C)
                +0.0002701629445140*PriceSeries(Price,index-175,O,L,H,C)
                +0.000612789332975*PriceSeries(Price,index-176,O,L,H,C)
                +0.000906053298234*PriceSeries(Price,index-177,O,L,H,C)
                +0.001133340638042*PriceSeries(Price,index-178,O,L,H,C)
                +0.001282690271709*PriceSeries(Price,index-179,O,L,H,C)
                +0.001347406157073*PriceSeries(Price,index-180,O,L,H,C)
                +0.001326279771018*PriceSeries(Price,index-181,O,L,H,C)
                +0.001223496971932*PriceSeries(Price,index-182,O,L,H,C)
                +0.001048190850578*PriceSeries(Price,index-183,O,L,H,C)
                +0.000813708619565*PriceSeries(Price,index-184,O,L,H,C)
                +0.000536632177292*PriceSeries(Price,index-185,O,L,H,C)
                +0.0002356408163852*PriceSeries(Price,index-186,O,L,H,C)
                -0.0000697355583010*PriceSeries(Price,index-187,O,L,H,C)
                -0.000360349025018*PriceSeries(Price,index-188,O,L,H,C)
                -0.000618638517421*PriceSeries(Price,index-189,O,L,H,C)
                -0.000829648095294*PriceSeries(Price,index-190,O,L,H,C)
                -0.000981888377393*PriceSeries(Price,index-191,O,L,H,C)
                -0.001067922292078*PriceSeries(Price,index-192,O,L,H,C)
                -0.001084705743668*PriceSeries(Price,index-193,O,L,H,C)
                -0.001033600158804*PriceSeries(Price,index-194,O,L,H,C)
                -0.000920164768017*PriceSeries(Price,index-195,O,L,H,C)
                -0.000753633135357*PriceSeries(Price,index-196,O,L,H,C)
                -0.000546234954428*PriceSeries(Price,index-197,O,L,H,C)
                -0.0003123027806595*PriceSeries(Price,index-198,O,L,H,C)
                -0.0000673202737179*PriceSeries(Price,index-199,O,L,H,C)
                +0.0001730915229750*PriceSeries(Price,index-200,O,L,H,C)
                +0.000394153658961*PriceSeries(Price,index-201,O,L,H,C)
                +0.000582827087894*PriceSeries(Price,index-202,O,L,H,C)
                +0.000728552608334*PriceSeries(Price,index-203,O,L,H,C)
                +0.000823830343837*PriceSeries(Price,index-204,O,L,H,C)
                +0.000864578257040*PriceSeries(Price,index-205,O,L,H,C)
                +0.000850252100474*PriceSeries(Price,index-206,O,L,H,C)
                +0.000783763834231*PriceSeries(Price,index-207,O,L,H,C)
                +0.000671159846543*PriceSeries(Price,index-208,O,L,H,C)
                +0.000521141901267*PriceSeries(Price,index-209,O,L,H,C)
                +0.000344417705180*PriceSeries(Price,index-210,O,L,H,C)
                +0.0001529541025154*PriceSeries(Price,index-211,O,L,H,C)
                -0.0000408041471265*PriceSeries(Price,index-212,O,L,H,C)
                -0.0002247387884001*PriceSeries(Price,index-213,O,L,H,C)
                -0.000387802809495*PriceSeries(Price,index-214,O,L,H,C)
                -0.000520665262669*PriceSeries(Price,index-215,O,L,H,C)
                -0.000616224284984*PriceSeries(Price,index-216,O,L,H,C)
                -0.000669980569803*PriceSeries(Price,index-217,O,L,H,C)
                -0.000680199619233*PriceSeries(Price,index-218,O,L,H,C)
                -0.000647933794958*PriceSeries(Price,index-219,O,L,H,C)
                -0.000576828536639*PriceSeries(Price,index-220,O,L,H,C)
                -0.000472809423291*PriceSeries(Price,index-221,O,L,H,C)
                -0.000343623838333*PriceSeries(Price,index-222,O,L,H,C)
                -0.0001982695658608*PriceSeries(Price,index-223,O,L,H,C)
                -0.0000464048671669*PriceSeries(Price,index-224,O,L,H,C)
                +0.0001022911054970*PriceSeries(Price,index-225,O,L,H,C)
                +0.0002387187704222*PriceSeries(Price,index-226,O,L,H,C)
                +0.000354915770397*PriceSeries(Price,index-227,O,L,H,C)
                +0.000444481489618*PriceSeries(Price,index-228,O,L,H,C)
                +0.000502950444398*PriceSeries(Price,index-229,O,L,H,C)
                +0.000527950144037*PriceSeries(Price,index-230,O,L,H,C)
                +0.000519312099013*PriceSeries(Price,index-231,O,L,H,C)
                +0.000478944121220*PriceSeries(Price,index-232,O,L,H,C)
                +0.000410660981024*PriceSeries(Price,index-233,O,L,H,C)
                +0.000319854613150*PriceSeries(Price,index-234,O,L,H,C)
                +0.0002130959849967*PriceSeries(Price,index-235,O,L,H,C)
                +0.0000976613669843*PriceSeries(Price,index-236,O,L,H,C)
                -0.00001892403071548*PriceSeries(Price,index-237,O,L,H,C)
                -0.0001293917947857*PriceSeries(Price,index-238,O,L,H,C)
                -0.0002271601765900*PriceSeries(Price,index-239,O,L,H,C)
                -0.0003067163648185*PriceSeries(Price,index-240,O,L,H,C)
                -0.000363920837335*PriceSeries(Price,index-241,O,L,H,C)
                -0.000396193222687*PriceSeries(Price,index-242,O,L,H,C)
                -0.000402624200678*PriceSeries(Price,index-243,O,L,H,C)
                -0.000383955047148*PriceSeries(Price,index-244,O,L,H,C)
                -0.000342432480230*PriceSeries(Price,index-245,O,L,H,C)
                -0.0002816507260333*PriceSeries(Price,index-246,O,L,H,C)
                -0.0002062219572786*PriceSeries(Price,index-247,O,L,H,C)
                -0.0001214739871695*PriceSeries(Price,index-248,O,L,H,C)
                -0.0000330584216739*PriceSeries(Price,index-249,O,L,H,C)
                +0.0000533738009836*PriceSeries(Price,index-250,O,L,H,C)
                +0.0001325856311458*PriceSeries(Price,index-251,O,L,H,C)
                +0.0001999887258264*PriceSeries(Price,index-252,O,L,H,C)
                +0.0002519888852674*PriceSeries(Price,index-253,O,L,H,C)
                +0.0002860587606498*PriceSeries(Price,index-254,O,L,H,C)
                +0.0003009456862493*PriceSeries(Price,index-255,O,L,H,C)
                +0.0002966250850216*PriceSeries(Price,index-256,O,L,H,C)
                +0.0002742748334859*PriceSeries(Price,index-257,O,L,H,C)
                +0.0002361217683595*PriceSeries(Price,index-258,O,L,H,C)
                +0.0001852972498969*PriceSeries(Price,index-259,O,L,H,C)
                +0.0001255405348962*PriceSeries(Price,index-260,O,L,H,C)
                +0.0000609828672911*PriceSeries(Price,index-261,O,L,H,C)
                -0.00000415751700843*PriceSeries(Price,index-262,O,L,H,C)
                -0.0000658289521540*PriceSeries(Price,index-263,O,L,H,C)
                -0.0001203827615443*PriceSeries(Price,index-264,O,L,H,C)
                -0.0001648169238213*PriceSeries(Price,index-265,O,L,H,C)
                -0.0001968899529892*PriceSeries(Price,index-266,O,L,H,C)
                -0.0002152259994140*PriceSeries(Price,index-267,O,L,H,C)
                -0.0002194141725791*PriceSeries(Price,index-268,O,L,H,C)
                -0.0002098991915462*PriceSeries(Price,index-269,O,L,H,C)
                -0.0001879778830100*PriceSeries(Price,index-270,O,L,H,C)
                -0.0001556276763350*PriceSeries(Price,index-271,O,L,H,C)
                -0.0001154027934424*PriceSeries(Price,index-272,O,L,H,C)
                -0.0000701681784277*PriceSeries(Price,index-273,O,L,H,C)
                -0.00002300383498304*PriceSeries(Price,index-274,O,L,H,C)
                +0.00002313093811524*PriceSeries(Price,index-275,O,L,H,C)
                +0.0000653935767906*PriceSeries(Price,index-276,O,L,H,C)
                +0.0001014489872442*PriceSeries(Price,index-277,O,L,H,C)
                +0.0001294003846508*PriceSeries(Price,index-278,O,L,H,C)
                +0.0001479810558961*PriceSeries(Price,index-279,O,L,H,C)
                +0.0001565638924274*PriceSeries(Price,index-280,O,L,H,C)
                +0.0001552082067757*PriceSeries(Price,index-281,O,L,H,C)
                +0.0001445414545411*PriceSeries(Price,index-282,O,L,H,C)
                +0.0001257722374063*PriceSeries(Price,index-283,O,L,H,C)
                +0.0001005230375202*PriceSeries(Price,index-284,O,L,H,C)
                +0.0000707378162769*PriceSeries(Price,index-285,O,L,H,C)
                +0.0000385501964762*PriceSeries(Price,index-286,O,L,H,C)
                +0.00000604526362217*PriceSeries(Price,index-287,O,L,H,C)
                -0.00002467526362518*PriceSeries(Price,index-288,O,L,H,C)
                -0.0000518049367640*PriceSeries(Price,index-289,O,L,H,C)
                -0.0000738825187090*PriceSeries(Price,index-290,O,L,H,C)
                -0.0000897714094621*PriceSeries(Price,index-291,O,L,H,C)
                -0.0000988379308890*PriceSeries(Price,index-292,O,L,H,C)
                -0.0001008827233247*PriceSeries(Price,index-293,O,L,H,C)
                -0.0000961769479766*PriceSeries(Price,index-294,O,L,H,C)
                -0.0000853304591472*PriceSeries(Price,index-295,O,L,H,C)
                -0.0000693501193057*PriceSeries(Price,index-296,O,L,H,C)
                -0.0000493836986721*PriceSeries(Price,index-297,O,L,H,C)
                -0.00002698633242863*PriceSeries(Price,index-298,O,L,H,C)
                -0.00000340346510407*PriceSeries(Price,index-299,O,L,H,C)
                +0.00001980188246308*PriceSeries(Price,index-300,O,L,H,C)
                +0.0000413501825647*PriceSeries(Price,index-301,O,L,H,C)
                +0.0000601507132128*PriceSeries(Price,index-302,O,L,H,C)
                +0.0000753445057287*PriceSeries(Price,index-303,O,L,H,C)
                +0.0000862737911193*PriceSeries(Price,index-304,O,L,H,C)
                +0.0000926344824125*PriceSeries(Price,index-305,O,L,H,C)
                +0.0000943970321229*PriceSeries(Price,index-306,O,L,H,C)
                +0.0000918427720804*PriceSeries(Price,index-307,O,L,H,C)
                +0.0000855549031008*PriceSeries(Price,index-308,O,L,H,C)
                +0.0000758437686660*PriceSeries(Price,index-309,O,L,H,C)
                +0.0000641881114043*PriceSeries(Price,index-310,O,L,H,C)
                +0.0000508680641007*PriceSeries(Price,index-311,O,L,H,C)
                +0.0000368830000293*PriceSeries(Price,index-312,O,L,H,C)
                +0.00002323338539252*PriceSeries(Price,index-313,O,L,H,C)
                +0.00001065219774448*PriceSeries(Price,index-314,O,L,H,C)
                -0.000000279924821946*PriceSeries(Price,index-315,O,L,H,C)
                -0.00000917647538066*PriceSeries(Price,index-316,O,L,H,C)
                -0.00001573549158618*PriceSeries(Price,index-317,O,L,H,C)
                -0.00001983761512098*PriceSeries(Price,index-318,O,L,H,C)
                -0.00002146668378202*PriceSeries(Price,index-319,O,L,H,C)
                -0.0001331759439441*PriceSeries(Price,index-320,O,L,H,C)
                );

      case N28:
         return(
                0.1536589170195*PriceSeries(Price,index,O,L,H,C)
                +0.1506713444039*PriceSeries(Price,index-1,O,L,H,C)
                +0.1448010883840*PriceSeries(Price,index-2,O,L,H,C)
                +0.1362535323265*PriceSeries(Price,index-3,O,L,H,C)
                +0.1253259540053*PriceSeries(Price,index-4,O,L,H,C)
                +0.1123951340823*PriceSeries(Price,index-5,O,L,H,C)
                +0.0979017157802*PriceSeries(Price,index-6,O,L,H,C)
                +0.0823320434429*PriceSeries(Price,index-7,O,L,H,C)
                +0.0661983046405*PriceSeries(Price,index-8,O,L,H,C)
                +0.0500178430209*PriceSeries(Price,index-9,O,L,H,C)
                +0.0342926064531*PriceSeries(Price,index-10,O,L,H,C)
                +0.01948960517234*PriceSeries(Price,index-11,O,L,H,C)
                +0.00602324652977*PriceSeries(Price,index-12,O,L,H,C)
                -0.00575970448752*PriceSeries(Price,index-13,O,L,H,C)
                -0.01559190515544*PriceSeries(Price,index-14,O,L,H,C)
                -0.02329352013333*PriceSeries(Price,index-15,O,L,H,C)
                -0.02877629793119*PriceSeries(Price,index-16,O,L,H,C)
                -0.0320435572735*PriceSeries(Price,index-17,O,L,H,C)
                -0.0331862012530*PriceSeries(Price,index-18,O,L,H,C)
                -0.0323750014955*PriceSeries(Price,index-19,O,L,H,C)
                -0.02984964755252*PriceSeries(Price,index-20,O,L,H,C)
                -0.02590511561582*PriceSeries(Price,index-21,O,L,H,C)
                -0.02087609097947*PriceSeries(Price,index-22,O,L,H,C)
                -0.01512020000343*PriceSeries(Price,index-23,O,L,H,C)
                -0.00900088213769*PriceSeries(Price,index-24,O,L,H,C)
                -0.002870700926121*PriceSeries(Price,index-25,O,L,H,C)
                +0.002944122874068*PriceSeries(Price,index-26,O,L,H,C)
                +0.00815729824843*PriceSeries(Price,index-27,O,L,H,C)
                +0.01253354336907*PriceSeries(Price,index-28,O,L,H,C)
                +0.01589679390053*PriceSeries(Price,index-29,O,L,H,C)
                +0.01813516803551*PriceSeries(Price,index-30,O,L,H,C)
                +0.01920265183790*PriceSeries(Price,index-31,O,L,H,C)
                +0.01911748550896*PriceSeries(Price,index-32,O,L,H,C)
                +0.01795751417556*PriceSeries(Price,index-33,O,L,H,C)
                +0.01585278760560*PriceSeries(Price,index-34,O,L,H,C)
                +0.01297596571590*PriceSeries(Price,index-35,O,L,H,C)
                +0.00953101168572*PriceSeries(Price,index-36,O,L,H,C)
                +0.00574087537648*PriceSeries(Price,index-37,O,L,H,C)
                +0.001834790508265*PriceSeries(Price,index-38,O,L,H,C)
                -0.001964136975742*PriceSeries(Price,index-39,O,L,H,C)
                -0.00545044979246*PriceSeries(Price,index-40,O,L,H,C)
                -0.00844638057502*PriceSeries(Price,index-41,O,L,H,C)
                -0.01081000503407*PriceSeries(Price,index-42,O,L,H,C)
                -0.01244110823437*PriceSeries(Price,index-43,O,L,H,C)
                -0.01328461267386*PriceSeries(Price,index-44,O,L,H,C)
                -0.01333142556914*PriceSeries(Price,index-45,O,L,H,C)
                -0.01261682349891*PriceSeries(Price,index-46,O,L,H,C)
                -0.01121651695777*PriceSeries(Price,index-47,O,L,H,C)
                -0.00924071706121*PriceSeries(Price,index-48,O,L,H,C)
                -0.00682659595104*PriceSeries(Price,index-49,O,L,H,C)
                -0.00412960393716*PriceSeries(Price,index-50,O,L,H,C)
                -0.001314147374564*PriceSeries(Price,index-51,O,L,H,C)
                +0.001455824221980*PriceSeries(Price,index-52,O,L,H,C)
                +0.00402584344533*PriceSeries(Price,index-53,O,L,H,C)
                +0.00625906379836*PriceSeries(Price,index-54,O,L,H,C)
                +0.00804311642828*PriceSeries(Price,index-55,O,L,H,C)
                +0.00929534998219*PriceSeries(Price,index-56,O,L,H,C)
                +0.00996625822597*PriceSeries(Price,index-57,O,L,H,C)
                +0.01004091390535*PriceSeries(Price,index-58,O,L,H,C)
                +0.00953848320638*PriceSeries(Price,index-59,O,L,H,C)
                +0.00850984029013*PriceSeries(Price,index-60,O,L,H,C)
                +0.00703353789993*PriceSeries(Price,index-61,O,L,H,C)
                +0.00521037375137*PriceSeries(Price,index-62,O,L,H,C)
                +0.003156938462973*PriceSeries(Price,index-63,O,L,H,C)
                +0.000998497406579*PriceSeries(Price,index-64,O,L,H,C)
                -0.001138336828643*PriceSeries(Price,index-65,O,L,H,C)
                -0.003132774892972*PriceSeries(Price,index-66,O,L,H,C)
                -0.00487640568543*PriceSeries(Price,index-67,O,L,H,C)
                -0.00627888199851*PriceSeries(Price,index-68,O,L,H,C)
                -0.00727234608061*PriceSeries(Price,index-69,O,L,H,C)
                -0.00781449555323*PriceSeries(Price,index-70,O,L,H,C)
                -0.00789007087109*PriceSeries(Price,index-71,O,L,H,C)
                -0.00751080968625*PriceSeries(Price,index-72,O,L,H,C)
                -0.00671385307408*PriceSeries(Price,index-73,O,L,H,C)
                -0.00555881629030*PriceSeries(Price,index-74,O,L,H,C)
                -0.00412364614327*PriceSeries(Price,index-75,O,L,H,C)
                -0.002499621886757*PriceSeries(Price,index-76,O,L,H,C)
                -0.000785743288578*PriceSeries(Price,index-77,O,L,H,C)
                +0.000917126920229*PriceSeries(Price,index-78,O,L,H,C)
                +0.002512043441650*PriceSeries(Price,index-79,O,L,H,C)
                +0.00391133784328*PriceSeries(Price,index-80,O,L,H,C)
                +0.00504131291100*PriceSeries(Price,index-81,O,L,H,C)
                +0.00584596461536*PriceSeries(Price,index-82,O,L,H,C)
                +0.00628961641861*PriceSeries(Price,index-83,O,L,H,C)
                +0.00635829641385*PriceSeries(Price,index-84,O,L,H,C)
                +0.00605986235751*PriceSeries(Price,index-85,O,L,H,C)
                +0.00542287046385*PriceSeries(Price,index-86,O,L,H,C)
                +0.00449430716759*PriceSeries(Price,index-87,O,L,H,C)
                +0.00333635590273*PriceSeries(Price,index-88,O,L,H,C)
                +0.002022384930128*PriceSeries(Price,index-89,O,L,H,C)
                +0.000632427564437*PriceSeries(Price,index-90,O,L,H,C)
                -0.000751578255298*PriceSeries(Price,index-91,O,L,H,C)
                -0.002050522735646*PriceSeries(Price,index-92,O,L,H,C)
                -0.00319254743405*PriceSeries(Price,index-93,O,L,H,C)
                -0.00411692507984*PriceSeries(Price,index-94,O,L,H,C)
                -0.00477719556683*PriceSeries(Price,index-95,O,L,H,C)
                -0.00514339704415*PriceSeries(Price,index-96,O,L,H,C)
                -0.00520327560351*PriceSeries(Price,index-97,O,L,H,C)
                -0.00496247938697*PriceSeries(Price,index-98,O,L,H,C)
                -0.00444369595961*PriceSeries(Price,index-99,O,L,H,C)
                -0.00368485933925*PriceSeries(Price,index-100,O,L,H,C)
                -0.002736539503433*PriceSeries(Price,index-101,O,L,H,C)
                -0.001658679816700*PriceSeries(Price,index-102,O,L,H,C)
                -0.000516894422338*PriceSeries(Price,index-103,O,L,H,C)
                +0.000621442835601*PriceSeries(Price,index-104,O,L,H,C)
                +0.001691112848246*PriceSeries(Price,index-105,O,L,H,C)
                +0.002632710898314*PriceSeries(Price,index-106,O,L,H,C)
                +0.00339589740492*PriceSeries(Price,index-107,O,L,H,C)
                +0.00394199729233*PriceSeries(Price,index-108,O,L,H,C)
                +0.00424590062480*PriceSeries(Price,index-109,O,L,H,C)
                +0.00429710242456*PriceSeries(Price,index-110,O,L,H,C)
                +0.00409989266304*PriceSeries(Price,index-111,O,L,H,C)
                +0.00367268407987*PriceSeries(Price,index-112,O,L,H,C)
                +0.003046563769777*PriceSeries(Price,index-113,O,L,H,C)
                +0.002263143188856*PriceSeries(Price,index-114,O,L,H,C)
                +0.001371882467069*PriceSeries(Price,index-115,O,L,H,C)
                +0.000427029189402*PriceSeries(Price,index-116,O,L,H,C)
                -0.000515635450458*PriceSeries(Price,index-117,O,L,H,C)
                -0.001402026305029*PriceSeries(Price,index-118,O,L,H,C)
                -0.002182816583313*PriceSeries(Price,index-119,O,L,H,C)
                -0.002816136913798*PriceSeries(Price,index-120,O,L,H,C)
                -0.00326975979623*PriceSeries(Price,index-121,O,L,H,C)
                -0.00352268549769*PriceSeries(Price,index-122,O,L,H,C)
                -0.00356603392792*PriceSeries(Price,index-123,O,L,H,C)
                -0.00340320461894*PriceSeries(Price,index-124,O,L,H,C)
                -0.003049350610782*PriceSeries(Price,index-125,O,L,H,C)
                -0.002530163575900*PriceSeries(Price,index-126,O,L,H,C)
                -0.001880124804763*PriceSeries(Price,index-127,O,L,H,C)
                -0.001140252469751*PriceSeries(Price,index-128,O,L,H,C)
                -0.000355587516554*PriceSeries(Price,index-129,O,L,H,C)
                +0.000427522339378*PriceSeries(Price,index-130,O,L,H,C)
                +0.001164114762977*PriceSeries(Price,index-131,O,L,H,C)
                +0.001813166422733*PriceSeries(Price,index-132,O,L,H,C)
                +0.002339824494291*PriceSeries(Price,index-133,O,L,H,C)
                +0.002717254828528*PriceSeries(Price,index-134,O,L,H,C)
                +0.002927946400354*PriceSeries(Price,index-135,O,L,H,C)
                +0.002964465465197*PriceSeries(Price,index-136,O,L,H,C)
                +0.002829598729313*PriceSeries(Price,index-137,O,L,H,C)
                +0.002535905971937*PriceSeries(Price,index-138,O,L,H,C)
                +0.002104721152671*PriceSeries(Price,index-139,O,L,H,C)
                +0.001564696869156*PriceSeries(Price,index-140,O,L,H,C)
                +0.000949925418825*PriceSeries(Price,index-141,O,L,H,C)
                +0.0002978466408247*PriceSeries(Price,index-142,O,L,H,C)
                -0.000353009069086*PriceSeries(Price,index-143,O,L,H,C)
                -0.000965265666419*PriceSeries(Price,index-144,O,L,H,C)
                -0.001504815804672*PriceSeries(Price,index-145,O,L,H,C)
                -0.001942695723450*PriceSeries(Price,index-146,O,L,H,C)
                -0.002256601170176*PriceSeries(Price,index-147,O,L,H,C)
                -0.002431992521879*PriceSeries(Price,index-148,O,L,H,C)
                -0.002462704425602*PriceSeries(Price,index-149,O,L,H,C)
                -0.002351061020683*PriceSeries(Price,index-150,O,L,H,C)
                -0.002107516437063*PriceSeries(Price,index-151,O,L,H,C)
                -0.001749809291236*PriceSeries(Price,index-152,O,L,H,C)
                -0.001301742402793*PriceSeries(Price,index-153,O,L,H,C)
                -0.000791638356129*PriceSeries(Price,index-154,O,L,H,C)
                -0.0002505898261613*PriceSeries(Price,index-155,O,L,H,C)
                +0.0002894286614977*PriceSeries(Price,index-156,O,L,H,C)
                +0.000797401265405*PriceSeries(Price,index-157,O,L,H,C)
                +0.001245052169374*PriceSeries(Price,index-158,O,L,H,C)
                +0.001608376155078*PriceSeries(Price,index-159,O,L,H,C)
                +0.001868907003688*PriceSeries(Price,index-160,O,L,H,C)
                +0.002014623475838*PriceSeries(Price,index-161,O,L,H,C)
                +0.002040459727400*PriceSeries(Price,index-162,O,L,H,C)
                +0.001948376246693*PriceSeries(Price,index-163,O,L,H,C)
                +0.001747080047377*PriceSeries(Price,index-164,O,L,H,C)
                +0.001451290485156*PriceSeries(Price,index-165,O,L,H,C)
                +0.001080755527704*PriceSeries(Price,index-166,O,L,H,C)
                +0.000658928806058*PriceSeries(Price,index-167,O,L,H,C)
                +0.0002115532461373*PriceSeries(Price,index-168,O,L,H,C)
                -0.0002349251519066*PriceSeries(Price,index-169,O,L,H,C)
                -0.000654871175508*PriceSeries(Price,index-170,O,L,H,C)
                -0.001024931257082*PriceSeries(Price,index-171,O,L,H,C)
                -0.001325297678407*PriceSeries(Price,index-172,O,L,H,C)
                -0.001540769757049*PriceSeries(Price,index-173,O,L,H,C)
                -0.001661461502291*PriceSeries(Price,index-174,O,L,H,C)
                -0.001683238667250*PriceSeries(Price,index-175,O,L,H,C)
                -0.001607776739179*PriceSeries(Price,index-176,O,L,H,C)
                -0.001442297465180*PriceSeries(Price,index-177,O,L,H,C)
                -0.001198978740895*PriceSeries(Price,index-178,O,L,H,C)
                -0.000894127060574*PriceSeries(Price,index-179,O,L,H,C)
                -0.000547084851621*PriceSeries(Price,index-180,O,L,H,C)
                -0.0001790602876050*PriceSeries(Price,index-181,O,L,H,C)
                +0.0001881802401546*PriceSeries(Price,index-182,O,L,H,C)
                +0.000533569891068*PriceSeries(Price,index-183,O,L,H,C)
                +0.000837923749234*PriceSeries(Price,index-184,O,L,H,C)
                +0.001085003482637*PriceSeries(Price,index-185,O,L,H,C)
                +0.001262355283320*PriceSeries(Price,index-186,O,L,H,C)
                +0.001361918476374*PriceSeries(Price,index-187,O,L,H,C)
                +0.001380346322559*PriceSeries(Price,index-188,O,L,H,C)
                +0.001319060570024*PriceSeries(Price,index-189,O,L,H,C)
                +0.001184030791039*PriceSeries(Price,index-190,O,L,H,C)
                +0.000985273432945*PriceSeries(Price,index-191,O,L,H,C)
                +0.000736169785355*PriceSeries(Price,index-192,O,L,H,C)
                +0.000452579570087*PriceSeries(Price,index-193,O,L,H,C)
                +0.0001518544209403*PriceSeries(Price,index-194,O,L,H,C)
                -0.0001482138804401*PriceSeries(Price,index-195,O,L,H,C)
                -0.000430407925016*PriceSeries(Price,index-196,O,L,H,C)
                -0.000679094594248*PriceSeries(Price,index-197,O,L,H,C)
                -0.000881052397331*PriceSeries(Price,index-198,O,L,H,C)
                -0.001026160963366*PriceSeries(Price,index-199,O,L,H,C)
                -0.001107890020365*PriceSeries(Price,index-200,O,L,H,C)
                -0.001123558657757*PriceSeries(Price,index-201,O,L,H,C)
                -0.001074361844061*PriceSeries(Price,index-202,O,L,H,C)
                -0.000965205417866*PriceSeries(Price,index-203,O,L,H,C)
                -0.000804256216941*PriceSeries(Price,index-204,O,L,H,C)
                -0.000602426753855*PriceSeries(Price,index-205,O,L,H,C)
                -0.000372606610241*PriceSeries(Price,index-206,O,L,H,C)
                -0.0001288933853813*PriceSeries(Price,index-207,O,L,H,C)
                +0.0001142928137771*PriceSeries(Price,index-208,O,L,H,C)
                +0.000343012292236*PriceSeries(Price,index-209,O,L,H,C)
                +0.000544617407685*PriceSeries(Price,index-210,O,L,H,C)
                +0.000708434459950*PriceSeries(Price,index-211,O,L,H,C)
                +0.000826317117999*PriceSeries(Price,index-212,O,L,H,C)
                +0.000893016278223*PriceSeries(Price,index-213,O,L,H,C)
                +0.000906408210446*PriceSeries(Price,index-214,O,L,H,C)
                +0.000867497910012*PriceSeries(Price,index-215,O,L,H,C)
                +0.000780256401207*PriceSeries(Price,index-216,O,L,H,C)
                +0.000651308567991*PriceSeries(Price,index-217,O,L,H,C)
                +0.000489455768673*PriceSeries(Price,index-218,O,L,H,C)
                +0.0003050745561086*PriceSeries(Price,index-219,O,L,H,C)
                +0.0001095037332266*PriceSeries(Price,index-220,O,L,H,C)
                -0.0000856653949800*PriceSeries(Price,index-221,O,L,H,C)
                -0.0002692672218715*PriceSeries(Price,index-222,O,L,H,C)
                -0.000431166743724*PriceSeries(Price,index-223,O,L,H,C)
                -0.000562853477299*PriceSeries(Price,index-224,O,L,H,C)
                -0.000657812339985*PriceSeries(Price,index-225,O,L,H,C)
                -0.000711882685909*PriceSeries(Price,index-226,O,L,H,C)
                -0.000723385855846*PriceSeries(Price,index-227,O,L,H,C)
                -0.000693158143143*PriceSeries(Price,index-228,O,L,H,C)
                -0.000624390244781*PriceSeries(Price,index-229,O,L,H,C)
                -0.000522380535520*PriceSeries(Price,index-230,O,L,H,C)
                -0.000394153303748*PriceSeries(Price,index-231,O,L,H,C)
                -0.0002479825922104*PriceSeries(Price,index-232,O,L,H,C)
                -0.0000928665808146*PriceSeries(Price,index-233,O,L,H,C)
                +0.0000619891612460*PriceSeries(Price,index-234,O,L,H,C)
                +0.0002077247162217*PriceSeries(Price,index-235,O,L,H,C)
                +0.000336334192554*PriceSeries(Price,index-236,O,L,H,C)
                +0.000441078100442*PriceSeries(Price,index-237,O,L,H,C)
                +0.000516826697966*PriceSeries(Price,index-238,O,L,H,C)
                +0.000560324041127*PriceSeries(Price,index-239,O,L,H,C)
                +0.000570254160966*PriceSeries(Price,index-240,O,L,H,C)
                +0.000547285083962*PriceSeries(Price,index-241,O,L,H,C)
                +0.000493966714652*PriceSeries(Price,index-242,O,L,H,C)
                +0.000414465657532*PriceSeries(Price,index-243,O,L,H,C)
                +0.0003143256977804*PriceSeries(Price,index-244,O,L,H,C)
                +0.0002000318884695*PriceSeries(Price,index-245,O,L,H,C)
                +0.0000786618148545*PriceSeries(Price,index-246,O,L,H,C)
                -0.0000425745667853*PriceSeries(Price,index-247,O,L,H,C)
                -0.0001567543638861*PriceSeries(Price,index-248,O,L,H,C)
                -0.0002576276471545*PriceSeries(Price,index-249,O,L,H,C)
                -0.000339945211310*PriceSeries(Price,index-250,O,L,H,C)
                -0.000399707107511*PriceSeries(Price,index-251,O,L,H,C)
                -0.000434382956854*PriceSeries(Price,index-252,O,L,H,C)
                -0.000442974469204*PriceSeries(Price,index-253,O,L,H,C)
                -0.000426014199955*PriceSeries(Price,index-254,O,L,H,C)
                -0.000385470958685*PriceSeries(Price,index-255,O,L,H,C)
                -0.000324618029888*PriceSeries(Price,index-256,O,L,H,C)
                -0.0002477264795620*PriceSeries(Price,index-257,O,L,H,C)
                -0.0001598187206402*PriceSeries(Price,index-258,O,L,H,C)
                -0.0000663659188800*PriceSeries(Price,index-259,O,L,H,C)
                +0.00002707257814328*PriceSeries(Price,index-260,O,L,H,C)
                +0.0001151792234545*PriceSeries(Price,index-261,O,L,H,C)
                +0.0001931057407685*PriceSeries(Price,index-262,O,L,H,C)
                +0.0002568729126561*PriceSeries(Price,index-263,O,L,H,C)
                +0.0003033949538087*PriceSeries(Price,index-264,O,L,H,C)
                +0.000330763101210*PriceSeries(Price,index-265,O,L,H,C)
                +0.000338187768351*PriceSeries(Price,index-266,O,L,H,C)
                +0.000326098868501*PriceSeries(Price,index-267,O,L,H,C)
                +0.0002960063022377*PriceSeries(Price,index-268,O,L,H,C)
                +0.0002504043025864*PriceSeries(Price,index-269,O,L,H,C)
                +0.0001925333651262*PriceSeries(Price,index-270,O,L,H,C)
                +0.0001262213408218*PriceSeries(Price,index-271,O,L,H,C)
                +0.0000556122428718*PriceSeries(Price,index-272,O,L,H,C)
                -0.00001506959487933*PriceSeries(Price,index-273,O,L,H,C)
                -0.0000818229666308*PriceSeries(Price,index-274,O,L,H,C)
                -0.0001410108581680*PriceSeries(Price,index-275,O,L,H,C)
                -0.0001895844129684*PriceSeries(Price,index-276,O,L,H,C)
                -0.0002252481361121*PriceSeries(Price,index-277,O,L,H,C)
                -0.0002465816047758*PriceSeries(Price,index-278,O,L,H,C)
                -0.0002529731285508*PriceSeries(Price,index-279,O,L,H,C)
                -0.0002447577911124*PriceSeries(Price,index-280,O,L,H,C)
                -0.0002230886780419*PriceSeries(Price,index-281,O,L,H,C)
                -0.0001897634166122*PriceSeries(Price,index-282,O,L,H,C)
                -0.0001472569789428*PriceSeries(Price,index-283,O,L,H,C)
                -0.0000983689927083*PriceSeries(Price,index-284,O,L,H,C)
                -0.0000461958063268*PriceSeries(Price,index-285,O,L,H,C)
                +0.00000613561898237*PriceSeries(Price,index-286,O,L,H,C)
                +0.0000556422822704*PriceSeries(Price,index-287,O,L,H,C)
                +0.0000996415888817*PriceSeries(Price,index-288,O,L,H,C)
                +0.0001359264102697*PriceSeries(Price,index-289,O,L,H,C)
                +0.0001627987291619*PriceSeries(Price,index-290,O,L,H,C)
                +0.0001791847436921*PriceSeries(Price,index-291,O,L,H,C)
                +0.0001846337643232*PriceSeries(Price,index-292,O,L,H,C)
                +0.0001794016012882*PriceSeries(Price,index-293,O,L,H,C)
                +0.0001643210985561*PriceSeries(Price,index-294,O,L,H,C)
                +0.0001407325740324*PriceSeries(Price,index-295,O,L,H,C)
                +0.0001103484107681*PriceSeries(Price,index-296,O,L,H,C)
                +0.0000752810412827*PriceSeries(Price,index-297,O,L,H,C)
                +0.0000377765092918*PriceSeries(Price,index-298,O,L,H,C)
                +0.000000034283103298*PriceSeries(Price,index-299,O,L,H,C)
                -0.0000358022040672*PriceSeries(Price,index-300,O,L,H,C)
                -0.0000676918577124*PriceSeries(Price,index-301,O,L,H,C)
                -0.0000941953210545*PriceSeries(Price,index-302,O,L,H,C)
                -0.0001139393669167*PriceSeries(Price,index-303,O,L,H,C)
                -0.0001262705921271*PriceSeries(Price,index-304,O,L,H,C)
                -0.0001308181485831*PriceSeries(Price,index-305,O,L,H,C)
                -0.0001277725120279*PriceSeries(Price,index-306,O,L,H,C)
                -0.0001176802178543*PriceSeries(Price,index-307,O,L,H,C)
                -0.0001014985653199*PriceSeries(Price,index-308,O,L,H,C)
                -0.0000804432368447*PriceSeries(Price,index-309,O,L,H,C)
                -0.0000559884731186*PriceSeries(Price,index-310,O,L,H,C)
                -0.00002970305921976*PriceSeries(Price,index-311,O,L,H,C)
                -0.00000321428450971*PriceSeries(Price,index-312,O,L,H,C)
                +0.00002198945171703*PriceSeries(Price,index-313,O,L,H,C)
                +0.0000445827560821*PriceSeries(Price,index-314,O,L,H,C)
                +0.0000634990195768*PriceSeries(Price,index-315,O,L,H,C)
                +0.0000778119893573*PriceSeries(Price,index-316,O,L,H,C)
                +0.0000868465610261*PriceSeries(Price,index-317,O,L,H,C)
                +0.0000903329726320*PriceSeries(Price,index-318,O,L,H,C)
                +0.0000885848118440*PriceSeries(Price,index-319,O,L,H,C)
                +0.0000819080967773*PriceSeries(Price,index-320,O,L,H,C)
                +0.0000705203780300*PriceSeries(Price,index-321,O,L,H,C)
                +0.0000558698685142*PriceSeries(Price,index-322,O,L,H,C)
                +0.0000384066805048*PriceSeries(Price,index-323,O,L,H,C)
                +0.00001943423731614*PriceSeries(Price,index-324,O,L,H,C)
                -0.000000079524783416*PriceSeries(Price,index-325,O,L,H,C)
                -0.00001911534970425*PriceSeries(Price,index-326,O,L,H,C)
                -0.0000367451372936*PriceSeries(Price,index-327,O,L,H,C)
                -0.0000522154033210*PriceSeries(Price,index-328,O,L,H,C)
                -0.0000649084214794*PriceSeries(Price,index-329,O,L,H,C)
                -0.0000744433278452*PriceSeries(Price,index-330,O,L,H,C)
                -0.0000806074440227*PriceSeries(Price,index-331,O,L,H,C)
                -0.0000834408242271*PriceSeries(Price,index-332,O,L,H,C)
                -0.0000831517870113*PriceSeries(Price,index-333,O,L,H,C)
                -0.0000801964665733*PriceSeries(Price,index-334,O,L,H,C)
                -0.0000752030222678*PriceSeries(Price,index-335,O,L,H,C)
                -0.0000690868762094*PriceSeries(Price,index-336,O,L,H,C)
                -0.0000630475268605*PriceSeries(Price,index-337,O,L,H,C)
                -0.0000588266623109*PriceSeries(Price,index-338,O,L,H,C)
                -0.0000589664088282*PriceSeries(Price,index-339,O,L,H,C)
                -0.0000675276862394*PriceSeries(Price,index-340,O,L,H,C)
                +0.0000834558998611*PriceSeries(Price,index-341,O,L,H,C)
                );

      case N29:
         return(
                0.1466466918556*PriceSeries(Price,index,O,L,H,C)
                +0.1440333699344*PriceSeries(Price,index-1,O,L,H,C)
                +0.1388908276780*PriceSeries(Price,index-2,O,L,H,C)
                +0.1313840357437*PriceSeries(Price,index-3,O,L,H,C)
                +0.1217525047283*PriceSeries(Price,index-4,O,L,H,C)
                +0.1103011228986*PriceSeries(Price,index-5,O,L,H,C)
                +0.0973885490528*PriceSeries(Price,index-6,O,L,H,C)
                +0.0834136388232*PriceSeries(Price,index-7,O,L,H,C)
                +0.0688004724471*PriceSeries(Price,index-8,O,L,H,C)
                +0.0539826040439*PriceSeries(Price,index-9,O,L,H,C)
                +0.0393871727124*PriceSeries(Price,index-10,O,L,H,C)
                +0.02541953154730*PriceSeries(Price,index-11,O,L,H,C)
                +0.01244899961257*PriceSeries(Price,index-12,O,L,H,C)
                +0.000796316049981*PriceSeries(Price,index-13,O,L,H,C)
                -0.00927674187609*PriceSeries(Price,index-14,O,L,H,C)
                -0.01757516427842*PriceSeries(Price,index-15,O,L,H,C)
                -0.02397569750846*PriceSeries(Price,index-16,O,L,H,C)
                -0.02842884118917*PriceSeries(Price,index-17,O,L,H,C)
                -0.03095786388849*PriceSeries(Price,index-18,O,L,H,C)
                -0.0316549236833*PriceSeries(Price,index-19,O,L,H,C)
                -0.03067455149424*PriceSeries(Price,index-20,O,L,H,C)
                -0.02822481391603*PriceSeries(Price,index-21,O,L,H,C)
                -0.02455661140355*PriceSeries(Price,index-22,O,L,H,C)
                -0.01995159735201*PriceSeries(Price,index-23,O,L,H,C)
                -0.01470928669154*PriceSeries(Price,index-24,O,L,H,C)
                -0.00913390953817*PriceSeries(Price,index-25,O,L,H,C)
                -0.00352160222854*PriceSeries(Price,index-26,O,L,H,C)
                +0.001851550802296*PriceSeries(Price,index-27,O,L,H,C)
                +0.00674010642055*PriceSeries(Price,index-28,O,L,H,C)
                +0.01093810142806*PriceSeries(Price,index-29,O,L,H,C)
                +0.01428578011604*PriceSeries(Price,index-30,O,L,H,C)
                +0.01667403088281*PriceSeries(Price,index-31,O,L,H,C)
                +0.01804637271358*PriceSeries(Price,index-32,O,L,H,C)
                +0.01839854253889*PriceSeries(Price,index-33,O,L,H,C)
                +0.01777574350997*PriceSeries(Price,index-34,O,L,H,C)
                +0.01626781248884*PriceSeries(Price,index-35,O,L,H,C)
                +0.01400256092502*PriceSeries(Price,index-36,O,L,H,C)
                +0.01113770686713*PriceSeries(Price,index-37,O,L,H,C)
                +0.00785177926412*PriceSeries(Price,index-38,O,L,H,C)
                +0.00433449375377*PriceSeries(Price,index-39,O,L,H,C)
                +0.000777030757495*PriceSeries(Price,index-40,O,L,H,C)
                -0.002637295060022*PriceSeries(Price,index-41,O,L,H,C)
                -0.00574158568369*PriceSeries(Price,index-42,O,L,H,C)
                -0.00839272329743*PriceSeries(Price,index-43,O,L,H,C)
                -0.01047728486647*PriceSeries(Price,index-44,O,L,H,C)
                -0.01191574220458*PriceSeries(Price,index-45,O,L,H,C)
                -0.01266485761407*PriceSeries(Price,index-46,O,L,H,C)
                -0.01271818456024*PriceSeries(Price,index-47,O,L,H,C)
                -0.01210477502673*PriceSeries(Price,index-48,O,L,H,C)
                -0.01088616820675*PriceSeries(Price,index-49,O,L,H,C)
                -0.00915193330721*PriceSeries(Price,index-50,O,L,H,C)
                -0.00701397973348*PriceSeries(Price,index-51,O,L,H,C)
                -0.00460001678949*PriceSeries(Price,index-52,O,L,H,C)
                -0.002046460854339*PriceSeries(Price,index-53,O,L,H,C)
                +0.000508785241667*PriceSeries(Price,index-54,O,L,H,C)
                +0.002933372562305*PriceSeries(Price,index-55,O,L,H,C)
                +0.00510697459348*PriceSeries(Price,index-56,O,L,H,C)
                +0.00692692717198*PriceSeries(Price,index-57,O,L,H,C)
                +0.00831274957546*PriceSeries(Price,index-58,O,L,H,C)
                +0.00920939976871*PriceSeries(Price,index-59,O,L,H,C)
                +0.00958910514046*PriceSeries(Price,index-60,O,L,H,C)
                +0.00945177015498*PriceSeries(Price,index-61,O,L,H,C)
                +0.00882394617618*PriceSeries(Price,index-62,O,L,H,C)
                +0.00775650947254*PriceSeries(Price,index-63,O,L,H,C)
                +0.00632116171038*PriceSeries(Price,index-64,O,L,H,C)
                +0.00460602215943*PriceSeries(Price,index-65,O,L,H,C)
                +0.002710507132981*PriceSeries(Price,index-66,O,L,H,C)
                +0.000739840769434*PriceSeries(Price,index-67,O,L,H,C)
                -0.001200571865553*PriceSeries(Price,index-68,O,L,H,C)
                -0.003010561965928*PriceSeries(Price,index-69,O,L,H,C)
                -0.00460019102678*PriceSeries(Price,index-70,O,L,H,C)
                -0.00589402660654*PriceSeries(Price,index-71,O,L,H,C)
                -0.00683455778396*PriceSeries(Price,index-72,O,L,H,C)
                -0.00738455593638*PriceSeries(Price,index-73,O,L,H,C)
                -0.00752833451702*PriceSeries(Price,index-74,O,L,H,C)
                -0.00727184353617*PriceSeries(Price,index-75,O,L,H,C)
                -0.00664166364529*PriceSeries(Price,index-76,O,L,H,C)
                -0.00568295200518*PriceSeries(Price,index-77,O,L,H,C)
                -0.00445651313423*PriceSeries(Price,index-78,O,L,H,C)
                -0.003035137892643*PriceSeries(Price,index-79,O,L,H,C)
                -0.001499455332701*PriceSeries(Price,index-80,O,L,H,C)
                +0.0000665100369689*PriceSeries(Price,index-81,O,L,H,C)
                +0.001579796482885*PriceSeries(Price,index-82,O,L,H,C)
                +0.002962795479421*PriceSeries(Price,index-83,O,L,H,C)
                +0.00414710831136*PriceSeries(Price,index-84,O,L,H,C)
                +0.00507683120217*PriceSeries(Price,index-85,O,L,H,C)
                +0.00571107075984*PriceSeries(Price,index-86,O,L,H,C)
                +0.00602562652257*PriceSeries(Price,index-87,O,L,H,C)
                +0.00601373486955*PriceSeries(Price,index-88,O,L,H,C)
                +0.00568590469333*PriceSeries(Price,index-89,O,L,H,C)
                +0.00506884488377*PriceSeries(Price,index-90,O,L,H,C)
                +0.00420359246231*PriceSeries(Price,index-91,O,L,H,C)
                +0.003142942212490*PriceSeries(Price,index-92,O,L,H,C)
                +0.001948348036517*PriceSeries(Price,index-93,O,L,H,C)
                +0.000686455666700*PriceSeries(Price,index-94,O,L,H,C)
                -0.000574526134943*PriceSeries(Price,index-95,O,L,H,C)
                -0.001768436958803*PriceSeries(Price,index-96,O,L,H,C)
                -0.002834558860061*PriceSeries(Price,index-97,O,L,H,C)
                -0.00372063686434*PriceSeries(Price,index-98,O,L,H,C)
                -0.00438535969546*PriceSeries(Price,index-99,O,L,H,C)
                -0.00480021256184*PriceSeries(Price,index-100,O,L,H,C)
                -0.00495059467857*PriceSeries(Price,index-101,O,L,H,C)
                -0.00483619122840*PriceSeries(Price,index-102,O,L,H,C)
                -0.00447057684487*PriceSeries(Price,index-103,O,L,H,C)
                -0.00388011622295*PriceSeries(Price,index-104,O,L,H,C)
                -0.003102215488627*PriceSeries(Price,index-105,O,L,H,C)
                -0.002183054923587*PriceSeries(Price,index-106,O,L,H,C)
                -0.001174921532415*PriceSeries(Price,index-107,O,L,H,C)
                -0.0001332964727329*PriceSeries(Price,index-108,O,L,H,C)
                +0.000886139950161*PriceSeries(Price,index-109,O,L,H,C)
                +0.001830434394375*PriceSeries(Price,index-110,O,L,H,C)
                +0.002652058229366*PriceSeries(Price,index-111,O,L,H,C)
                +0.00331125187481*PriceSeries(Price,index-112,O,L,H,C)
                +0.00377788946312*PriceSeries(Price,index-113,O,L,H,C)
                +0.00403279573407*PriceSeries(Price,index-114,O,L,H,C)
                +0.00406844619746*PriceSeries(Price,index-115,O,L,H,C)
                +0.00388903986091*PriceSeries(Price,index-116,O,L,H,C)
                +0.00350995568727*PriceSeries(Price,index-117,O,L,H,C)
                +0.002956637101514*PriceSeries(Price,index-118,O,L,H,C)
                +0.002262978500016*PriceSeries(Price,index-119,O,L,H,C)
                +0.001469314169633*PriceSeries(Price,index-120,O,L,H,C)
                +0.000620123621125*PriceSeries(Price,index-121,O,L,H,C)
                -0.0002384175773671*PriceSeries(Price,index-122,O,L,H,C)
                -0.001060911595440*PriceSeries(Price,index-123,O,L,H,C)
                -0.001805096123183*PriceSeries(Price,index-124,O,L,H,C)
                -0.002433986582910*PriceSeries(Price,index-125,O,L,H,C)
                -0.002917666055464*PriceSeries(Price,index-126,O,L,H,C)
                -0.00323467289896*PriceSeries(Price,index-127,O,L,H,C)
                -0.00337288830987*PriceSeries(Price,index-128,O,L,H,C)
                -0.00332992917831*PriceSeries(Price,index-129,O,L,H,C)
                -0.003112995475998*PriceSeries(Price,index-130,O,L,H,C)
                -0.002738242646062*PriceSeries(Price,index-131,O,L,H,C)
                -0.002229678419361*PriceSeries(Price,index-132,O,L,H,C)
                -0.001617694397038*PriceSeries(Price,index-133,O,L,H,C)
                -0.000937287886085*PriceSeries(Price,index-134,O,L,H,C)
                -0.0002261035379185*PriceSeries(Price,index-135,O,L,H,C)
                +0.000477625673484*PriceSeries(Price,index-136,O,L,H,C)
                +0.001137097832391*PriceSeries(Price,index-137,O,L,H,C)
                +0.001718844124582*PriceSeries(Price,index-138,O,L,H,C)
                +0.002194392417076*PriceSeries(Price,index-139,O,L,H,C)
                +0.002541636315319*PriceSeries(Price,index-140,O,L,H,C)
                +0.002745813049270*PriceSeries(Price,index-141,O,L,H,C)
                +0.002800093549210*PriceSeries(Price,index-142,O,L,H,C)
                +0.002705710458163*PriceSeries(Price,index-143,O,L,H,C)
                +0.002471687924862*PriceSeries(Price,index-144,O,L,H,C)
                +0.002114138535953*PriceSeries(Price,index-145,O,L,H,C)
                +0.001655239690786*PriceSeries(Price,index-146,O,L,H,C)
                +0.001121881657933*PriceSeries(Price,index-147,O,L,H,C)
                +0.000544143097898*PriceSeries(Price,index-148,O,L,H,C)
                -0.0000463951629789*PriceSeries(Price,index-149,O,L,H,C)
                -0.000618339032402*PriceSeries(Price,index-150,O,L,H,C)
                -0.001142140276661*PriceSeries(Price,index-151,O,L,H,C)
                -0.001591587519883*PriceSeries(Price,index-152,O,L,H,C)
                -0.001945106722141*PriceSeries(Price,index-153,O,L,H,C)
                -0.002186756990928*PriceSeries(Price,index-154,O,L,H,C)
                -0.002306923773854*PriceSeries(Price,index-155,O,L,H,C)
                -0.002302641056266*PriceSeries(Price,index-156,O,L,H,C)
                -0.002177575043641*PriceSeries(Price,index-157,O,L,H,C)
                -0.001941632779574*PriceSeries(Price,index-158,O,L,H,C)
                -0.001610285504404*PriceSeries(Price,index-159,O,L,H,C)
                -0.001203581991066*PriceSeries(Price,index-160,O,L,H,C)
                -0.000744984584620*PriceSeries(Price,index-161,O,L,H,C)
                -0.0002600203693469*PriceSeries(Price,index-162,O,L,H,C)
                +0.0002250972908738*PriceSeries(Price,index-163,O,L,H,C)
                +0.000684891365154*PriceSeries(Price,index-164,O,L,H,C)
                +0.001095917097574*PriceSeries(Price,index-165,O,L,H,C)
                +0.001437959218954*PriceSeries(Price,index-166,O,L,H,C)
                +0.001694987410434*PriceSeries(Price,index-167,O,L,H,C)
                +0.001855898110054*PriceSeries(Price,index-168,O,L,H,C)
                +0.001914943599105*PriceSeries(Price,index-169,O,L,H,C)
                +0.001871899206905*PriceSeries(Price,index-170,O,L,H,C)
                +0.001731905575283*PriceSeries(Price,index-171,O,L,H,C)
                +0.001505056586106*PriceSeries(Price,index-172,O,L,H,C)
                +0.001205718656493*PriceSeries(Price,index-173,O,L,H,C)
                +0.000851664958945*PriceSeries(Price,index-174,O,L,H,C)
                +0.000463028336791*PriceSeries(Price,index-175,O,L,H,C)
                +0.0000611926997174*PriceSeries(Price,index-176,O,L,H,C)
                -0.000332385338362*PriceSeries(Price,index-177,O,L,H,C)
                -0.000697289263738*PriceSeries(Price,index-178,O,L,H,C)
                -0.001015205969432*PriceSeries(Price,index-179,O,L,H,C)
                -0.001270805117501*PriceSeries(Price,index-180,O,L,H,C)
                -0.001452485103310*PriceSeries(Price,index-181,O,L,H,C)
                -0.001552850078638*PriceSeries(Price,index-182,O,L,H,C)
                -0.001568998284741*PriceSeries(Price,index-183,O,L,H,C)
                -0.001502526285177*PriceSeries(Price,index-184,O,L,H,C)
                -0.001359330062828*PriceSeries(Price,index-185,O,L,H,C)
                -0.001149152943170*PriceSeries(Price,index-186,O,L,H,C)
                -0.000884975724731*PriceSeries(Price,index-187,O,L,H,C)
                -0.000582227770621*PriceSeries(Price,index-188,O,L,H,C)
                -0.0002579104446378*PriceSeries(Price,index-189,O,L,H,C)
                +0.0000703478009155*PriceSeries(Price,index-190,O,L,H,C)
                +0.000385229439902*PriceSeries(Price,index-191,O,L,H,C)
                +0.000670639674877*PriceSeries(Price,index-192,O,L,H,C)
                +0.000912502554976*PriceSeries(Price,index-193,O,L,H,C)
                +0.001099453076701*PriceSeries(Price,index-194,O,L,H,C)
                +0.001223340593767*PriceSeries(Price,index-195,O,L,H,C)
                +0.001279575514210*PriceSeries(Price,index-196,O,L,H,C)
                +0.001267243188135*PriceSeries(Price,index-197,O,L,H,C)
                +0.001189064395200*PriceSeries(Price,index-198,O,L,H,C)
                +0.001051119609984*PriceSeries(Price,index-199,O,L,H,C)
                +0.000862445559337*PriceSeries(Price,index-200,O,L,H,C)
                +0.000634456442421*PriceSeries(Price,index-201,O,L,H,C)
                +0.000380284339340*PriceSeries(Price,index-202,O,L,H,C)
                +0.0001140240584074*PriceSeries(Price,index-203,O,L,H,C)
                -0.0001500258500789*PriceSeries(Price,index-204,O,L,H,C)
                -0.000398124925148*PriceSeries(Price,index-205,O,L,H,C)
                -0.000617796286227*PriceSeries(Price,index-206,O,L,H,C)
                -0.000798437729959*PriceSeries(Price,index-207,O,L,H,C)
                -0.000931821640174*PriceSeries(Price,index-208,O,L,H,C)
                -0.001012454345269*PriceSeries(Price,index-209,O,L,H,C)
                -0.001037774855649*PriceSeries(Price,index-210,O,L,H,C)
                -0.001008199277846*PriceSeries(Price,index-211,O,L,H,C)
                -0.000927002976065*PriceSeries(Price,index-212,O,L,H,C)
                -0.000800063869343*PriceSeries(Price,index-213,O,L,H,C)
                -0.000635458813174*PriceSeries(Price,index-214,O,L,H,C)
                -0.000442987060752*PriceSeries(Price,index-215,O,L,H,C)
                -0.0002335848887144*PriceSeries(Price,index-216,O,L,H,C)
                -0.00001872655223804*PriceSeries(Price,index-217,O,L,H,C)
                +0.0001902013020751*PriceSeries(Price,index-218,O,L,H,C)
                +0.000382487837306*PriceSeries(Price,index-219,O,L,H,C)
                +0.000548643779624*PriceSeries(Price,index-220,O,L,H,C)
                +0.000680855725903*PriceSeries(Price,index-221,O,L,H,C)
                +0.000773335276045*PriceSeries(Price,index-222,O,L,H,C)
                +0.000822570021877*PriceSeries(Price,index-223,O,L,H,C)
                +0.000827414066798*PriceSeries(Price,index-224,O,L,H,C)
                +0.000789085366335*PriceSeries(Price,index-225,O,L,H,C)
                +0.000711011683185*PriceSeries(Price,index-226,O,L,H,C)
                +0.000598588097605*PriceSeries(Price,index-227,O,L,H,C)
                +0.000458815045357*PriceSeries(Price,index-228,O,L,H,C)
                +0.0002998917187211*PriceSeries(Price,index-229,O,L,H,C)
                +0.0001307380638120*PriceSeries(Price,index-230,O,L,H,C)
                -0.0000394980229495*PriceSeries(Price,index-231,O,L,H,C)
                -0.0002019189535869*PriceSeries(Price,index-232,O,L,H,C)
                -0.000348341298860*PriceSeries(Price,index-233,O,L,H,C)
                -0.000471698057389*PriceSeries(Price,index-234,O,L,H,C)
                -0.000566366274739*PriceSeries(Price,index-235,O,L,H,C)
                -0.000628413306889*PriceSeries(Price,index-236,O,L,H,C)
                -0.000655742279634*PriceSeries(Price,index-237,O,L,H,C)
                -0.000648143640094*PriceSeries(Price,index-238,O,L,H,C)
                -0.000607221863148*PriceSeries(Price,index-239,O,L,H,C)
                -0.000536278898988*PriceSeries(Price,index-240,O,L,H,C)
                -0.000440045700525*PriceSeries(Price,index-241,O,L,H,C)
                -0.000324417912890*PriceSeries(Price,index-242,O,L,H,C)
                -0.0001960775131412*PriceSeries(Price,index-243,O,L,H,C)
                -0.0000621457836942*PriceSeries(Price,index-244,O,L,H,C)
                +0.0000702393593039*PriceSeries(Price,index-245,O,L,H,C)
                +0.0001942611548334*PriceSeries(Price,index-246,O,L,H,C)
                +0.0003037947226262*PriceSeries(Price,index-247,O,L,H,C)
                +0.000393689509989*PriceSeries(Price,index-248,O,L,H,C)
                +0.000460004488706*PriceSeries(Price,index-249,O,L,H,C)
                +0.000500165716046*PriceSeries(Price,index-250,O,L,H,C)
                +0.000513059929671*PriceSeries(Price,index-251,O,L,H,C)
                +0.000499024898188*PriceSeries(Price,index-252,O,L,H,C)
                +0.000459787156918*PriceSeries(Price,index-253,O,L,H,C)
                +0.000398313791854*PriceSeries(Price,index-254,O,L,H,C)
                +0.000318624993585*PriceSeries(Price,index-255,O,L,H,C)
                +0.0002255135424652*PriceSeries(Price,index-256,O,L,H,C)
                +0.0001243163330638*PriceSeries(Price,index-257,O,L,H,C)
                +0.00002055881983939*PriceSeries(Price,index-258,O,L,H,C)
                -0.0000802858849718*PriceSeries(Price,index-259,O,L,H,C)
                -0.0001731291564889*PriceSeries(Price,index-260,O,L,H,C)
                -0.0002534622454103*PriceSeries(Price,index-261,O,L,H,C)
                -0.000317631524872*PriceSeries(Price,index-262,O,L,H,C)
                -0.000362930583770*PriceSeries(Price,index-263,O,L,H,C)
                -0.000387752794480*PriceSeries(Price,index-264,O,L,H,C)
                -0.000391605162968*PriceSeries(Price,index-265,O,L,H,C)
                -0.000375101348098*PriceSeries(Price,index-266,O,L,H,C)
                -0.000339873833608*PriceSeries(Price,index-267,O,L,H,C)
                -0.0002884689132717*PriceSeries(Price,index-268,O,L,H,C)
                -0.0002241586197389*PriceSeries(Price,index-269,O,L,H,C)
                -0.0001507516060707*PriceSeries(Price,index-270,O,L,H,C)
                -0.0000723725406540*PriceSeries(Price,index-271,O,L,H,C)
                +0.00000675109187621*PriceSeries(Price,index-272,O,L,H,C)
                +0.0000825545011372*PriceSeries(Price,index-273,O,L,H,C)
                +0.0001512688386222*PriceSeries(Price,index-274,O,L,H,C)
                +0.0002096854479989*PriceSeries(Price,index-275,O,L,H,C)
                +0.0002552229693843*PriceSeries(Price,index-276,O,L,H,C)
                +0.0002861082607271*PriceSeries(Price,index-277,O,L,H,C)
                +0.0003013475538593*PriceSeries(Price,index-278,O,L,H,C)
                +0.0003008511183628*PriceSeries(Price,index-279,O,L,H,C)
                +0.0002852929776398*PriceSeries(Price,index-280,O,L,H,C)
                +0.0002561249204248*PriceSeries(Price,index-281,O,L,H,C)
                +0.0002154303947549*PriceSeries(Price,index-282,O,L,H,C)
                +0.0001658077866549*PriceSeries(Price,index-283,O,L,H,C)
                +0.0001102014168629*PriceSeries(Price,index-284,O,L,H,C)
                +0.0000517626227746*PriceSeries(Price,index-285,O,L,H,C)
                -0.00000633319957200*PriceSeries(Price,index-286,O,L,H,C)
                -0.0000610617692895*PriceSeries(Price,index-287,O,L,H,C)
                -0.0001096648174316*PriceSeries(Price,index-288,O,L,H,C)
                -0.0001497898560827*PriceSeries(Price,index-289,O,L,H,C)
                -0.0001796341726788*PriceSeries(Price,index-290,O,L,H,C)
                -0.0001979183122283*PriceSeries(Price,index-291,O,L,H,C)
                -0.0002040366476179*PriceSeries(Price,index-292,O,L,H,C)
                -0.0001979560461428*PriceSeries(Price,index-293,O,L,H,C)
                -0.0001802967041927*PriceSeries(Price,index-294,O,L,H,C)
                -0.0001521252483652*PriceSeries(Price,index-295,O,L,H,C)
                -0.0001150755682156*PriceSeries(Price,index-296,O,L,H,C)
                -0.0000710438336049*PriceSeries(Price,index-297,O,L,H,C)
                -0.00002222378544005*PriceSeries(Price,index-298,O,L,H,C)
                +0.00002906643332315*PriceSeries(Price,index-299,O,L,H,C)
                +0.0000804961912360*PriceSeries(Price,index-300,O,L,H,C)
                +0.0001298411655139*PriceSeries(Price,index-301,O,L,H,C)
                +0.0001750696750737*PriceSeries(Price,index-302,O,L,H,C)
                +0.0002143960253363*PriceSeries(Price,index-303,O,L,H,C)
                +0.0002464798189008*PriceSeries(Price,index-304,O,L,H,C)
                +0.0002702786817057*PriceSeries(Price,index-305,O,L,H,C)
                +0.0002852169926531*PriceSeries(Price,index-306,O,L,H,C)
                +0.0002911855516436*PriceSeries(Price,index-307,O,L,H,C)
                +0.0002883917830628*PriceSeries(Price,index-308,O,L,H,C)
                +0.0002774826308720*PriceSeries(Price,index-309,O,L,H,C)
                +0.0002593481251586*PriceSeries(Price,index-310,O,L,H,C)
                +0.0002352524319083*PriceSeries(Price,index-311,O,L,H,C)
                +0.0002063737016047*PriceSeries(Price,index-312,O,L,H,C)
                +0.0001743379902864*PriceSeries(Price,index-313,O,L,H,C)
                +0.0001405020647525*PriceSeries(Price,index-314,O,L,H,C)
                +0.0001063054102371*PriceSeries(Price,index-315,O,L,H,C)
                +0.0000731105964549*PriceSeries(Price,index-316,O,L,H,C)
                +0.0000420781811175*PriceSeries(Price,index-317,O,L,H,C)
                +0.00001415812707633*PriceSeries(Price,index-318,O,L,H,C)
                -0.00001003749570007*PriceSeries(Price,index-319,O,L,H,C)
                -0.00002964340832976*PriceSeries(Price,index-320,O,L,H,C)
                -0.0000450405256958*PriceSeries(Price,index-321,O,L,H,C)
                -0.0000556875311307*PriceSeries(Price,index-322,O,L,H,C)
                -0.0000619083193316*PriceSeries(Price,index-323,O,L,H,C)
                -0.0000642328243964*PriceSeries(Price,index-324,O,L,H,C)
                -0.0000630542913154*PriceSeries(Price,index-325,O,L,H,C)
                -0.0000589076308569*PriceSeries(Price,index-326,O,L,H,C)
                -0.0000524784821939*PriceSeries(Price,index-327,O,L,H,C)
                -0.0001403090898778*PriceSeries(Price,index-328,O,L,H,C)
                );

      case N30:
         return(
                0.1333158563377*PriceSeries(Price,index,O,L,H,C)
                +0.1322281148596*PriceSeries(Price,index-1,O,L,H,C)
                +0.1289969195684*PriceSeries(Price,index-2,O,L,H,C)
                +0.1237172304459*PriceSeries(Price,index-3,O,L,H,C)
                +0.1165436034875*PriceSeries(Price,index-4,O,L,H,C)
                +0.1076847742903*PriceSeries(Price,index-5,O,L,H,C)
                +0.0973963670948*PriceSeries(Price,index-6,O,L,H,C)
                +0.0859720111812*PriceSeries(Price,index-7,O,L,H,C)
                +0.0737331989170*PriceSeries(Price,index-8,O,L,H,C)
                +0.0610182742338*PriceSeries(Price,index-9,O,L,H,C)
                +0.0481709659568*PriceSeries(Price,index-10,O,L,H,C)
                +0.0355288941557*PriceSeries(Price,index-11,O,L,H,C)
                +0.02341248018688*PriceSeries(Price,index-12,O,L,H,C)
                +0.01211466309144*PriceSeries(Price,index-13,O,L,H,C)
                +0.001891796568908*PriceSeries(Price,index-14,O,L,H,C)
                -0.00704395288277*PriceSeries(Price,index-15,O,L,H,C)
                -0.01453045085735*PriceSeries(Price,index-16,O,L,H,C)
                -0.02045949212444*PriceSeries(Price,index-17,O,L,H,C)
                -0.02477864588685*PriceSeries(Price,index-18,O,L,H,C)
                -0.02749102079675*PriceSeries(Price,index-19,O,L,H,C)
                -0.02865300432856*PriceSeries(Price,index-20,O,L,H,C)
                -0.02837011342597*PriceSeries(Price,index-21,O,L,H,C)
                -0.02679115681739*PriceSeries(Price,index-22,O,L,H,C)
                -0.02410097956876*PriceSeries(Price,index-23,O,L,H,C)
                -0.02051210614327*PriceSeries(Price,index-24,O,L,H,C)
                -0.01625563393725*PriceSeries(Price,index-25,O,L,H,C)
                -0.01157175649959*PriceSeries(Price,index-26,O,L,H,C)
                -0.00670029289929*PriceSeries(Price,index-27,O,L,H,C)
                -0.001871597276882*PriceSeries(Price,index-28,O,L,H,C)
                +0.002701804837556*PriceSeries(Price,index-29,O,L,H,C)
                +0.00683254821645*PriceSeries(Price,index-30,O,L,H,C)
                +0.01036446539692*PriceSeries(Price,index-31,O,L,H,C)
                +0.01317713572225*PriceSeries(Price,index-32,O,L,H,C)
                +0.01518881194680*PriceSeries(Price,index-33,O,L,H,C)
                +0.01635766134735*PriceSeries(Price,index-34,O,L,H,C)
                +0.01668133427606*PriceSeries(Price,index-35,O,L,H,C)
                +0.01619493364533*PriceSeries(Price,index-36,O,L,H,C)
                +0.01496753048389*PriceSeries(Price,index-37,O,L,H,C)
                +0.01309742240163*PriceSeries(Price,index-38,O,L,H,C)
                +0.01070637688350*PriceSeries(Price,index-39,O,L,H,C)
                +0.00793314271205*PriceSeries(Price,index-40,O,L,H,C)
                +0.00492652588404*PriceSeries(Price,index-41,O,L,H,C)
                +0.001838341924771*PriceSeries(Price,index-42,O,L,H,C)
                -0.001183450629156*PriceSeries(Price,index-43,O,L,H,C)
                -0.00400115180662*PriceSeries(Price,index-44,O,L,H,C)
                -0.00649299476028*PriceSeries(Price,index-45,O,L,H,C)
                -0.00855787992514*PriceSeries(Price,index-46,O,L,H,C)
                -0.01011899761622*PriceSeries(Price,index-47,O,L,H,C)
                -0.01112622174139*PriceSeries(Price,index-48,O,L,H,C)
                -0.01155721993800*PriceSeries(Price,index-49,O,L,H,C)
                -0.01141727501449*PriceSeries(Price,index-50,O,L,H,C)
                -0.01073787730514*PriceSeries(Price,index-51,O,L,H,C)
                -0.00957419560948*PriceSeries(Price,index-52,O,L,H,C)
                -0.00800157800787*PriceSeries(Price,index-53,O,L,H,C)
                -0.00611127880190*PriceSeries(Price,index-54,O,L,H,C)
                -0.00400562698786*PriceSeries(Price,index-55,O,L,H,C)
                -0.001792876172956*PriceSeries(Price,index-56,O,L,H,C)
                +0.000418019976434*PriceSeries(Price,index-57,O,L,H,C)
                +0.002522471610974*PriceSeries(Price,index-58,O,L,H,C)
                +0.00442492722242*PriceSeries(Price,index-59,O,L,H,C)
                +0.00604296385293*PriceSeries(Price,index-60,O,L,H,C)
                +0.00731062572544*PriceSeries(Price,index-61,O,L,H,C)
                +0.00818088327005*PriceSeries(Price,index-62,O,L,H,C)
                +0.00862713447690*PriceSeries(Price,index-63,O,L,H,C)
                +0.00864370725891*PriceSeries(Price,index-64,O,L,H,C)
                +0.00824537658492*PriceSeries(Price,index-65,O,L,H,C)
                +0.00746595155053*PriceSeries(Price,index-66,O,L,H,C)
                +0.00635602555035*PriceSeries(Price,index-67,O,L,H,C)
                +0.00498002555392*PriceSeries(Price,index-68,O,L,H,C)
                +0.00341271501129*PriceSeries(Price,index-69,O,L,H,C)
                +0.001735332402221*PriceSeries(Price,index-70,O,L,H,C)
                +0.00003155741402056*PriceSeries(Price,index-71,O,L,H,C)
                -0.001616506535114*PriceSeries(Price,index-72,O,L,H,C)
                -0.003132142456670*PriceSeries(Price,index-73,O,L,H,C)
                -0.00444745593867*PriceSeries(Price,index-74,O,L,H,C)
                -0.00550628757098*PriceSeries(Price,index-75,O,L,H,C)
                -0.00626647987316*PriceSeries(Price,index-76,O,L,H,C)
                -0.00670141793687*PriceSeries(Price,index-77,O,L,H,C)
                -0.00680078928931*PriceSeries(Price,index-78,O,L,H,C)
                -0.00657055434667*PriceSeries(Price,index-79,O,L,H,C)
                -0.00603215287334*PriceSeries(Price,index-80,O,L,H,C)
                -0.00522100360166*PriceSeries(Price,index-81,O,L,H,C)
                -0.00418439425758*PriceSeries(Price,index-82,O,L,H,C)
                -0.002978874512071*PriceSeries(Price,index-83,O,L,H,C)
                -0.001667291029369*PriceSeries(Price,index-84,O,L,H,C)
                -0.0003156162325694*PriceSeries(Price,index-85,O,L,H,C)
                +0.001010277958520*PriceSeries(Price,index-86,O,L,H,C)
                +0.002247742319185*PriceSeries(Price,index-87,O,L,H,C)
                +0.00334022874193*PriceSeries(Price,index-88,O,L,H,C)
                +0.00423979551898*PriceSeries(Price,index-89,O,L,H,C)
                +0.00490912897013*PriceSeries(Price,index-90,O,L,H,C)
                +0.00532300497361*PriceSeries(Price,index-91,O,L,H,C)
                +0.00546913236259*PriceSeries(Price,index-92,O,L,H,C)
                +0.00534835946390*PriceSeries(Price,index-93,O,L,H,C)
                +0.00497425257123*PriceSeries(Price,index-94,O,L,H,C)
                +0.00437207980459*PriceSeries(Price,index-95,O,L,H,C)
                +0.00357727122394*PriceSeries(Price,index-96,O,L,H,C)
                +0.002633438421468*PriceSeries(Price,index-97,O,L,H,C)
                +0.001590061789315*PriceSeries(Price,index-98,O,L,H,C)
                +0.000499966110403*PriceSeries(Price,index-99,O,L,H,C)
                -0.000583294988361*PriceSeries(Price,index-100,O,L,H,C)
                -0.001608012658897*PriceSeries(Price,index-101,O,L,H,C)
                -0.002526737405799*PriceSeries(Price,index-102,O,L,H,C)
                -0.00329842415913*PriceSeries(Price,index-103,O,L,H,C)
                -0.00389021018892*PriceSeries(Price,index-104,O,L,H,C)
                -0.00427875708033*PriceSeries(Price,index-105,O,L,H,C)
                -0.00445109881240*PriceSeries(Price,index-106,O,L,H,C)
                -0.00440497239118*PriceSeries(Price,index-107,O,L,H,C)
                -0.00414863100398*PriceSeries(Price,index-108,O,L,H,C)
                -0.00370015789260*PriceSeries(Price,index-109,O,L,H,C)
                -0.003086333158472*PriceSeries(Price,index-110,O,L,H,C)
                -0.002341114428305*PriceSeries(Price,index-111,O,L,H,C)
                -0.001503816387042*PriceSeries(Price,index-112,O,L,H,C)
                -0.000617086969849*PriceSeries(Price,index-113,O,L,H,C)
                +0.0002752241171319*PriceSeries(Price,index-114,O,L,H,C)
                +0.001130193766781*PriceSeries(Price,index-115,O,L,H,C)
                +0.001907853114343*PriceSeries(Price,index-116,O,L,H,C)
                +0.002573019977766*PriceSeries(Price,index-117,O,L,H,C)
                +0.003096849910891*PriceSeries(Price,index-118,O,L,H,C)
                +0.00345804655870*PriceSeries(Price,index-119,O,L,H,C)
                +0.00364367628515*PriceSeries(Price,index-120,O,L,H,C)
                +0.00364956113177*PriceSeries(Price,index-121,O,L,H,C)
                +0.00348024438125*PriceSeries(Price,index-122,O,L,H,C)
                +0.003148536689563*PriceSeries(Price,index-123,O,L,H,C)
                +0.002674682944130*PriceSeries(Price,index-124,O,L,H,C)
                +0.002085193777990*PriceSeries(Price,index-125,O,L,H,C)
                +0.001411407567315*PriceSeries(Price,index-126,O,L,H,C)
                +0.000687862880953*PriceSeries(Price,index-127,O,L,H,C)
                -0.0000494421861165*PriceSeries(Price,index-128,O,L,H,C)
                -0.000764810767409*PriceSeries(Price,index-129,O,L,H,C)
                -0.001424548109274*PriceSeries(Price,index-130,O,L,H,C)
                -0.001998523082058*PriceSeries(Price,index-131,O,L,H,C)
                -0.002461513439535*PriceSeries(Price,index-132,O,L,H,C)
                -0.002794284028722*PriceSeries(Price,index-133,O,L,H,C)
                -0.002984347411967*PriceSeries(Price,index-134,O,L,H,C)
                -0.003026381704075*PriceSeries(Price,index-135,O,L,H,C)
                -0.002922296643930*PriceSeries(Price,index-136,O,L,H,C)
                -0.002680947073253*PriceSeries(Price,index-137,O,L,H,C)
                -0.002317525633295*PriceSeries(Price,index-138,O,L,H,C)
                -0.001852666895674*PriceSeries(Price,index-139,O,L,H,C)
                -0.001311313724977*PriceSeries(Price,index-140,O,L,H,C)
                -0.000721410520571*PriceSeries(Price,index-141,O,L,H,C)
                -0.0001124828702782*PriceSeries(Price,index-142,O,L,H,C)
                +0.000485816704983*PriceSeries(Price,index-143,O,L,H,C)
                +0.001045130956902*PriceSeries(Price,index-144,O,L,H,C)
                +0.001539722918492*PriceSeries(Price,index-145,O,L,H,C)
                +0.001947636208070*PriceSeries(Price,index-146,O,L,H,C)
                +0.002251647534407*PriceSeries(Price,index-147,O,L,H,C)
                +0.002439963871504*PriceSeries(Price,index-148,O,L,H,C)
                +0.002506640943023*PriceSeries(Price,index-149,O,L,H,C)
                +0.002451714435158*PriceSeries(Price,index-150,O,L,H,C)
                +0.002281036354963*PriceSeries(Price,index-151,O,L,H,C)
                +0.002005840960241*PriceSeries(Price,index-152,O,L,H,C)
                +0.001642062820392*PriceSeries(Price,index-153,O,L,H,C)
                +0.001209447160777*PriceSeries(Price,index-154,O,L,H,C)
                +0.000730506224191*PriceSeries(Price,index-155,O,L,H,C)
                +0.0002293653066813*PriceSeries(Price,index-156,O,L,H,C)
                -0.0002694341029398*PriceSeries(Price,index-157,O,L,H,C)
                -0.000742118940868*PriceSeries(Price,index-158,O,L,H,C)
                -0.001166802950621*PriceSeries(Price,index-159,O,L,H,C)
                -0.001524479792280*PriceSeries(Price,index-160,O,L,H,C)
                -0.001799857375181*PriceSeries(Price,index-161,O,L,H,C)
                -0.001981988763083*PriceSeries(Price,index-162,O,L,H,C)
                -0.002064676395512*PriceSeries(Price,index-163,O,L,H,C)
                -0.002046642411838*PriceSeries(Price,index-164,O,L,H,C)
                -0.001931453911070*PriceSeries(Price,index-165,O,L,H,C)
                -0.001727223418250*PriceSeries(Price,index-166,O,L,H,C)
                -0.001446097679920*PriceSeries(Price,index-167,O,L,H,C)
                -0.001103564682223*PriceSeries(Price,index-168,O,L,H,C)
                -0.000717625994694*PriceSeries(Price,index-169,O,L,H,C)
                -0.0003078659741506*PriceSeries(Price,index-170,O,L,H,C)
                +0.0001055258039591*PriceSeries(Price,index-171,O,L,H,C)
                +0.000502735100757*PriceSeries(Price,index-172,O,L,H,C)
                +0.000865262299065*PriceSeries(Price,index-173,O,L,H,C)
                +0.001176765756063*PriceSeries(Price,index-174,O,L,H,C)
                +0.001423785038724*PriceSeries(Price,index-175,O,L,H,C)
                +0.001596304604746*PriceSeries(Price,index-176,O,L,H,C)
                +0.001688135668106*PriceSeries(Price,index-177,O,L,H,C)
                +0.001697109200728*PriceSeries(Price,index-178,O,L,H,C)
                +0.001625064205129*PriceSeries(Price,index-179,O,L,H,C)
                +0.001477651255526*PriceSeries(Price,index-180,O,L,H,C)
                +0.001263958680402*PriceSeries(Price,index-181,O,L,H,C)
                +0.000995980642136*PriceSeries(Price,index-182,O,L,H,C)
                +0.000687967474097*PriceSeries(Price,index-183,O,L,H,C)
                +0.000355679863559*PriceSeries(Price,index-184,O,L,H,C)
                +0.00001559720723195*PriceSeries(Price,index-185,O,L,H,C)
                -0.0003158859830405*PriceSeries(Price,index-186,O,L,H,C)
                -0.000623243593387*PriceSeries(Price,index-187,O,L,H,C)
                -0.000892529722402*PriceSeries(Price,index-188,O,L,H,C)
                -0.001112000809901*PriceSeries(Price,index-189,O,L,H,C)
                -0.001272612091647*PriceSeries(Price,index-190,O,L,H,C)
                -0.001368369725340*PriceSeries(Price,index-191,O,L,H,C)
                -0.001396535212946*PriceSeries(Price,index-192,O,L,H,C)
                -0.001357659023593*PriceSeries(Price,index-193,O,L,H,C)
                -0.001255462022898*PriceSeries(Price,index-194,O,L,H,C)
                -0.001096569508826*PriceSeries(Price,index-195,O,L,H,C)
                -0.000890110628822*PriceSeries(Price,index-196,O,L,H,C)
                -0.000647218388605*PriceSeries(Price,index-197,O,L,H,C)
                -0.000380438564679*PriceSeries(Price,index-198,O,L,H,C)
                -0.0001030936482106*PriceSeries(Price,index-199,O,L,H,C)
                +0.0001713687412646*PriceSeries(Price,index-200,O,L,H,C)
                +0.000430022207491*PriceSeries(Price,index-201,O,L,H,C)
                +0.000661055857612*PriceSeries(Price,index-202,O,L,H,C)
                +0.000854307142422*PriceSeries(Price,index-203,O,L,H,C)
                +0.001001696707579*PriceSeries(Price,index-204,O,L,H,C)
                +0.001097546433613*PriceSeries(Price,index-205,O,L,H,C)
                +0.001138785340319*PriceSeries(Price,index-206,O,L,H,C)
                +0.001125015810367*PriceSeries(Price,index-207,O,L,H,C)
                +0.001058456988829*PriceSeries(Price,index-208,O,L,H,C)
                +0.000943764188489*PriceSeries(Price,index-209,O,L,H,C)
                +0.000787731433845*PriceSeries(Price,index-210,O,L,H,C)
                +0.000598915136772*PriceSeries(Price,index-211,O,L,H,C)
                +0.000387174078148*PriceSeries(Price,index-212,O,L,H,C)
                +0.0001631646557623*PriceSeries(Price,index-213,O,L,H,C)
                -0.0000621833943148*PriceSeries(Price,index-214,O,L,H,C)
                -0.0002781972175566*PriceSeries(Price,index-215,O,L,H,C)
                -0.000474949052040*PriceSeries(Price,index-216,O,L,H,C)
                -0.000643706954395*PriceSeries(Price,index-217,O,L,H,C)
                -0.000777314596129*PriceSeries(Price,index-218,O,L,H,C)
                -0.000870476597434*PriceSeries(Price,index-219,O,L,H,C)
                -0.000919959561061*PriceSeries(Price,index-220,O,L,H,C)
                -0.000924676929230*PriceSeries(Price,index-221,O,L,H,C)
                -0.000885680808268*PriceSeries(Price,index-222,O,L,H,C)
                -0.000806054021421*PriceSeries(Price,index-223,O,L,H,C)
                -0.000690696144589*PriceSeries(Price,index-224,O,L,H,C)
                -0.000546047259490*PriceSeries(Price,index-225,O,L,H,C)
                -0.000379736138157*PriceSeries(Price,index-226,O,L,H,C)
                -0.0002001892958970*PriceSeries(Price,index-227,O,L,H,C)
                -0.00001621792181988*PriceSeries(Price,index-228,O,L,H,C)
                +0.0001634175868415*PriceSeries(Price,index-229,O,L,H,C)
                +0.000330406589194*PriceSeries(Price,index-230,O,L,H,C)
                +0.000477265221952*PriceSeries(Price,index-231,O,L,H,C)
                +0.000597664314721*PriceSeries(Price,index-232,O,L,H,C)
                +0.000686684510176*PriceSeries(Price,index-233,O,L,H,C)
                +0.000741016309448*PriceSeries(Price,index-234,O,L,H,C)
                +0.000759056297202*PriceSeries(Price,index-235,O,L,H,C)
                +0.000740932249115*PriceSeries(Price,index-236,O,L,H,C)
                +0.000688455106902*PriceSeries(Price,index-237,O,L,H,C)
                +0.000604976809052*PriceSeries(Price,index-238,O,L,H,C)
                +0.000495201465617*PriceSeries(Price,index-239,O,L,H,C)
                +0.000364919667213*PriceSeries(Price,index-240,O,L,H,C)
                +0.0002207106104891*PriceSeries(Price,index-241,O,L,H,C)
                +0.0000696308941989*PriceSeries(Price,index-242,O,L,H,C)
                -0.0000811368551916*PriceSeries(Price,index-243,O,L,H,C)
                -0.0002246065893131*PriceSeries(Price,index-244,O,L,H,C)
                -0.000354307265438*PriceSeries(Price,index-245,O,L,H,C)
                -0.000464565086525*PriceSeries(Price,index-246,O,L,H,C)
                -0.000550722866278*PriceSeries(Price,index-247,O,L,H,C)
                -0.000609343043212*PriceSeries(Price,index-248,O,L,H,C)
                -0.000638319866024*PriceSeries(Price,index-249,O,L,H,C)
                -0.000636935351411*PriceSeries(Price,index-250,O,L,H,C)
                -0.000605860634773*PriceSeries(Price,index-251,O,L,H,C)
                -0.000547070585519*PriceSeries(Price,index-252,O,L,H,C)
                -0.000463743457319*PriceSeries(Price,index-253,O,L,H,C)
                -0.000360076601511*PriceSeries(Price,index-254,O,L,H,C)
                -0.0002410646698713*PriceSeries(Price,index-255,O,L,H,C)
                -0.0001122782253649*PriceSeries(Price,index-256,O,L,H,C)
                +0.00002041111061901*PriceSeries(Price,index-257,O,L,H,C)
                +0.0001510690538450*PriceSeries(Price,index-258,O,L,H,C)
                +0.0002739636126793*PriceSeries(Price,index-259,O,L,H,C)
                +0.000383816833846*PriceSeries(Price,index-260,O,L,H,C)
                +0.000475981028864*PriceSeries(Price,index-261,O,L,H,C)
                +0.000546636953707*PriceSeries(Price,index-262,O,L,H,C)
                +0.000592911604551*PriceSeries(Price,index-263,O,L,H,C)
                +0.000612970705787*PriceSeries(Price,index-264,O,L,H,C)
                +0.000606078836880*PriceSeries(Price,index-265,O,L,H,C)
                +0.000572545916529*PriceSeries(Price,index-266,O,L,H,C)
                +0.000513710130596*PriceSeries(Price,index-267,O,L,H,C)
                +0.000431839917476*PriceSeries(Price,index-268,O,L,H,C)
                +0.000329995039247*PriceSeries(Price,index-269,O,L,H,C)
                +0.0002119011064113*PriceSeries(Price,index-270,O,L,H,C)
                +0.0000817229149662*PriceSeries(Price,index-271,O,L,H,C)
                -0.0000560702771491*PriceSeries(Price,index-272,O,L,H,C)
                -0.0001968871792803*PriceSeries(Price,index-273,O,L,H,C)
                -0.000336236413547*PriceSeries(Price,index-274,O,L,H,C)
                -0.000469845277504*PriceSeries(Price,index-275,O,L,H,C)
                -0.000593864760924*PriceSeries(Price,index-276,O,L,H,C)
                -0.000704941343096*PriceSeries(Price,index-277,O,L,H,C)
                -0.000800305767018*PriceSeries(Price,index-278,O,L,H,C)
                -0.000877925087722*PriceSeries(Price,index-279,O,L,H,C)
                -0.000936446373389*PriceSeries(Price,index-280,O,L,H,C)
                -0.000975258237612*PriceSeries(Price,index-281,O,L,H,C)
                -0.000994428965781*PriceSeries(Price,index-282,O,L,H,C)
                -0.000994629298850*PriceSeries(Price,index-283,O,L,H,C)
                -0.000977198231467*PriceSeries(Price,index-284,O,L,H,C)
                -0.000943881716885*PriceSeries(Price,index-285,O,L,H,C)
                -0.000896800662546*PriceSeries(Price,index-286,O,L,H,C)
                -0.000838370913154*PriceSeries(Price,index-287,O,L,H,C)
                -0.000771102906827*PriceSeries(Price,index-288,O,L,H,C)
                -0.000697719966451*PriceSeries(Price,index-289,O,L,H,C)
                -0.000620749690032*PriceSeries(Price,index-290,O,L,H,C)
                -0.000542538633141*PriceSeries(Price,index-291,O,L,H,C)
                -0.000465386203028*PriceSeries(Price,index-292,O,L,H,C)
                -0.000391144403796*PriceSeries(Price,index-293,O,L,H,C)
                -0.000321634705218*PriceSeries(Price,index-294,O,L,H,C)
                -0.0002580583037238*PriceSeries(Price,index-295,O,L,H,C)
                -0.0002011752601005*PriceSeries(Price,index-296,O,L,H,C)
                -0.0001525314035400*PriceSeries(Price,index-297,O,L,H,C)
                -0.0001130991571617*PriceSeries(Price,index-298,O,L,H,C)
                -0.0000860458621373*PriceSeries(Price,index-299,O,L,H,C)
                -0.0000789284318923*PriceSeries(Price,index-300,O,L,H,C)
                +0.0000548704014262*PriceSeries(Price,index-301,O,L,H,C)
                );

      case N31:
         return(
                0.1341712613453*PriceSeries(Price,index,O,L,H,C)
                +0.1321296996020*PriceSeries(Price,index-1,O,L,H,C)
                +0.1281026676058*PriceSeries(Price,index-2,O,L,H,C)
                +0.1222005094307*PriceSeries(Price,index-3,O,L,H,C)
                +0.1145842040423*PriceSeries(Price,index-4,O,L,H,C)
                +0.1054601087319*PriceSeries(Price,index-5,O,L,H,C)
                +0.0950732392146*PriceSeries(Price,index-6,O,L,H,C)
                +0.0836993354772*PriceSeries(Price,index-7,O,L,H,C)
                +0.0716359899685*PriceSeries(Price,index-8,O,L,H,C)
                +0.0591931615255*PriceSeries(Price,index-9,O,L,H,C)
                +0.0466833853639*PriceSeries(Price,index-10,O,L,H,C)
                +0.0344120578096*PriceSeries(Price,index-11,O,L,H,C)
                +0.02266809069678*PriceSeries(Price,index-12,O,L,H,C)
                +0.01171529104720*PriceSeries(Price,index-13,O,L,H,C)
                +0.001784730100969*PriceSeries(Price,index-14,O,L,H,C)
                -0.00693163133833*PriceSeries(Price,index-15,O,L,H,C)
                -0.01428587588206*PriceSeries(Price,index-16,O,L,H,C)
                -0.02017744949152*PriceSeries(Price,index-17,O,L,H,C)
                -0.02455481242522*PriceSeries(Price,index-18,O,L,H,C)
                -0.02741536943371*PriceSeries(Price,index-19,O,L,H,C)
                -0.02880374054736*PriceSeries(Price,index-20,O,L,H,C)
                -0.02880845274574*PriceSeries(Price,index-21,O,L,H,C)
                -0.02755722429660*PriceSeries(Price,index-22,O,L,H,C)
                -0.02521102748344*PriceSeries(Price,index-23,O,L,H,C)
                -0.02195719449065*PriceSeries(Price,index-24,O,L,H,C)
                -0.01800181577736*PriceSeries(Price,index-25,O,L,H,C)
                -0.01356175398585*PriceSeries(Price,index-26,O,L,H,C)
                -0.00885655051681*PriceSeries(Price,index-27,O,L,H,C)
                -0.00410053564500*PriceSeries(Price,index-28,O,L,H,C)
                +0.000504574731047*PriceSeries(Price,index-29,O,L,H,C)
                +0.00477633590011*PriceSeries(Price,index-30,O,L,H,C)
                +0.00855727256663*PriceSeries(Price,index-31,O,L,H,C)
                +0.01171941288185*PriceSeries(Price,index-32,O,L,H,C)
                +0.01416755820440*PriceSeries(Price,index-33,O,L,H,C)
                +0.01584117526289*PriceSeries(Price,index-34,O,L,H,C)
                +0.01671491154244*PriceSeries(Price,index-35,O,L,H,C)
                +0.01679773823580*PriceSeries(Price,index-36,O,L,H,C)
                +0.01613083142191*PriceSeries(Price,index-37,O,L,H,C)
                +0.01478427719536*PriceSeries(Price,index-38,O,L,H,C)
                +0.01285281520874*PriceSeries(Price,index-39,O,L,H,C)
                +0.01045077552632*PriceSeries(Price,index-40,O,L,H,C)
                +0.00770647962129*PriceSeries(Price,index-41,O,L,H,C)
                +0.00475630403799*PriceSeries(Price,index-42,O,L,H,C)
                +0.001738693686497*PriceSeries(Price,index-43,O,L,H,C)
                -0.001211676693855*PriceSeries(Price,index-44,O,L,H,C)
                -0.00396931604521*PriceSeries(Price,index-45,O,L,H,C)
                -0.00642276679569*PriceSeries(Price,index-46,O,L,H,C)
                -0.00847864095366*PriceSeries(Price,index-47,O,L,H,C)
                -0.01006478195729*PriceSeries(Price,index-48,O,L,H,C)
                -0.01113239378818*PriceSeries(Price,index-49,O,L,H,C)
                -0.01165713835915*PriceSeries(Price,index-50,O,L,H,C)
                -0.01163914657500*PriceSeries(Price,index-51,O,L,H,C)
                -0.01110203129139*PriceSeries(Price,index-52,O,L,H,C)
                -0.01009092297645*PriceSeries(Price,index-53,O,L,H,C)
                -0.00866970182101*PriceSeries(Price,index-54,O,L,H,C)
                -0.00691752056347*PriceSeries(Price,index-55,O,L,H,C)
                -0.00492482648695*PriceSeries(Price,index-56,O,L,H,C)
                -0.002789031707822*PriceSeries(Price,index-57,O,L,H,C)
                -0.000610065939238*PriceSeries(Price,index-58,O,L,H,C)
                +0.001514041589677*PriceSeries(Price,index-59,O,L,H,C)
                +0.00349131801156*PriceSeries(Price,index-60,O,L,H,C)
                +0.00523961989313*PriceSeries(Price,index-61,O,L,H,C)
                +0.00668983384410*PriceSeries(Price,index-62,O,L,H,C)
                +0.00778841971994*PriceSeries(Price,index-63,O,L,H,C)
                +0.00849919070873*PriceSeries(Price,index-64,O,L,H,C)
                +0.00880428801576*PriceSeries(Price,index-65,O,L,H,C)
                +0.00870432186278*PriceSeries(Price,index-66,O,L,H,C)
                +0.00821772654120*PriceSeries(Price,index-67,O,L,H,C)
                +0.00737934411119*PriceSeries(Price,index-68,O,L,H,C)
                +0.00623836100516*PriceSeries(Price,index-69,O,L,H,C)
                +0.00485567305996*PriceSeries(Price,index-70,O,L,H,C)
                +0.00330083995944*PriceSeries(Price,index-71,O,L,H,C)
                +0.001648742946095*PriceSeries(Price,index-72,O,L,H,C)
                -0.00002386054996143*PriceSeries(Price,index-73,O,L,H,C)
                -0.001641783714333*PriceSeries(Price,index-74,O,L,H,C)
                -0.003134657009773*PriceSeries(Price,index-75,O,L,H,C)
                -0.00443988180820*PriceSeries(Price,index-76,O,L,H,C)
                -0.00550513737843*PriceSeries(Price,index-77,O,L,H,C)
                -0.00629037841411*PriceSeries(Price,index-78,O,L,H,C)
                -0.00676921423967*PriceSeries(Price,index-79,O,L,H,C)
                -0.00692967148825*PriceSeries(Price,index-80,O,L,H,C)
                -0.00677427018808*PriceSeries(Price,index-81,O,L,H,C)
                -0.00631949662162*PriceSeries(Price,index-82,O,L,H,C)
                -0.00559464056415*PriceSeries(Price,index-83,O,L,H,C)
                -0.00464013197924*PriceSeries(Price,index-84,O,L,H,C)
                -0.00350541599211*PriceSeries(Price,index-85,O,L,H,C)
                -0.002246508293025*PriceSeries(Price,index-86,O,L,H,C)
                -0.000923311043630*PriceSeries(Price,index-87,O,L,H,C)
                +0.000403143753851*PriceSeries(Price,index-88,O,L,H,C)
                +0.001673442931079*PriceSeries(Price,index-89,O,L,H,C)
                +0.002832376207642*PriceSeries(Price,index-90,O,L,H,C)
                +0.00383127009687*PriceSeries(Price,index-91,O,L,H,C)
                +0.00462996294745*PriceSeries(Price,index-92,O,L,H,C)
                +0.00519835649094*PriceSeries(Price,index-93,O,L,H,C)
                +0.00551746285102*PriceSeries(Price,index-94,O,L,H,C)
                +0.00557994728350*PriceSeries(Price,index-95,O,L,H,C)
                +0.00539012813344*PriceSeries(Price,index-96,O,L,H,C)
                +0.00496346525049*PriceSeries(Price,index-97,O,L,H,C)
                +0.00432556886934*PriceSeries(Price,index-98,O,L,H,C)
                +0.00351077636193*PriceSeries(Price,index-99,O,L,H,C)
                +0.002560393907695*PriceSeries(Price,index-100,O,L,H,C)
                +0.001520662233869*PriceSeries(Price,index-101,O,L,H,C)
                +0.000440563776682*PriceSeries(Price,index-102,O,L,H,C)
                -0.000630430786428*PriceSeries(Price,index-103,O,L,H,C)
                -0.001644581844209*PriceSeries(Price,index-104,O,L,H,C)
                -0.002557966621563*PriceSeries(Price,index-105,O,L,H,C)
                -0.00333233400676*PriceSeries(Price,index-106,O,L,H,C)
                -0.00393666089251*PriceSeries(Price,index-107,O,L,H,C)
                -0.00434834916860*PriceSeries(Price,index-108,O,L,H,C)
                -0.00455400832080*PriceSeries(Price,index-109,O,L,H,C)
                -0.00454981546460*PriceSeries(Price,index-110,O,L,H,C)
                -0.00434143834008*PriceSeries(Price,index-111,O,L,H,C)
                -0.00394352879459*PriceSeries(Price,index-112,O,L,H,C)
                -0.00337883914895*PriceSeries(Price,index-113,O,L,H,C)
                -0.002676997812665*PriceSeries(Price,index-114,O,L,H,C)
                -0.001873003610467*PriceSeries(Price,index-115,O,L,H,C)
                -0.001005529852586*PriceSeries(Price,index-116,O,L,H,C)
                -0.0001150920751985*PriceSeries(Price,index-117,O,L,H,C)
                +0.000757800568109*PriceSeries(Price,index-118,O,L,H,C)
                +0.001574461679615*PriceSeries(Price,index-119,O,L,H,C)
                +0.002299711575072*PriceSeries(Price,index-120,O,L,H,C)
                +0.002903356549645*PriceSeries(Price,index-121,O,L,H,C)
                +0.00336141535620*PriceSeries(Price,index-122,O,L,H,C)
                +0.00365703552783*PriceSeries(Price,index-123,O,L,H,C)
                +0.00378106723518*PriceSeries(Price,index-124,O,L,H,C)
                +0.00373227188505*PriceSeries(Price,index-125,O,L,H,C)
                +0.00351718830132*PriceSeries(Price,index-126,O,L,H,C)
                +0.003149633837879*PriceSeries(Price,index-127,O,L,H,C)
                +0.002649911148317*PriceSeries(Price,index-128,O,L,H,C)
                +0.002043733266220*PriceSeries(Price,index-129,O,L,H,C)
                +0.001360937621535*PriceSeries(Price,index-130,O,L,H,C)
                +0.000634042446229*PriceSeries(Price,index-131,O,L,H,C)
                -0.0001032621001579*PriceSeries(Price,index-132,O,L,H,C)
                -0.000817670208090*PriceSeries(Price,index-133,O,L,H,C)
                -0.001477722176944*PriceSeries(Price,index-134,O,L,H,C)
                -0.002055189246770*PriceSeries(Price,index-135,O,L,H,C)
                -0.002526233808686*PriceSeries(Price,index-136,O,L,H,C)
                -0.002872385910504*PriceSeries(Price,index-137,O,L,H,C)
                -0.003081224663964*PriceSeries(Price,index-138,O,L,H,C)
                -0.003146793896268*PriceSeries(Price,index-139,O,L,H,C)
                -0.003069695497509*PriceSeries(Price,index-140,O,L,H,C)
                -0.002856917090427*PriceSeries(Price,index-141,O,L,H,C)
                -0.002521344696337*PriceSeries(Price,index-142,O,L,H,C)
                -0.002081048365524*PriceSeries(Price,index-143,O,L,H,C)
                -0.001558339158745*PriceSeries(Price,index-144,O,L,H,C)
                -0.000978673015622*PriceSeries(Price,index-145,O,L,H,C)
                -0.000369419186434*PriceSeries(Price,index-146,O,L,H,C)
                +0.0002413946284201*PriceSeries(Price,index-147,O,L,H,C)
                +0.000826373622937*PriceSeries(Price,index-148,O,L,H,C)
                +0.001359952657091*PriceSeries(Price,index-149,O,L,H,C)
                +0.001819499781445*PriceSeries(Price,index-150,O,L,H,C)
                +0.002186259459733*PriceSeries(Price,index-151,O,L,H,C)
                +0.002446095604895*PriceSeries(Price,index-152,O,L,H,C)
                +0.002590010534761*PriceSeries(Price,index-153,O,L,H,C)
                +0.002614419844989*PriceSeries(Price,index-154,O,L,H,C)
                +0.002521173831454*PriceSeries(Price,index-155,O,L,H,C)
                +0.002317353271579*PriceSeries(Price,index-156,O,L,H,C)
                +0.002014807275801*PriceSeries(Price,index-157,O,L,H,C)
                +0.001629515982939*PriceSeries(Price,index-158,O,L,H,C)
                +0.001180764562036*PriceSeries(Price,index-159,O,L,H,C)
                +0.000690208540261*PriceSeries(Price,index-160,O,L,H,C)
                +0.0001808258372060*PriceSeries(Price,index-161,O,L,H,C)
                -0.000324121132140*PriceSeries(Price,index-162,O,L,H,C)
                -0.000802152258973*PriceSeries(Price,index-163,O,L,H,C)
                -0.001232546280125*PriceSeries(Price,index-164,O,L,H,C)
                -0.001597231672192*PriceSeries(Price,index-165,O,L,H,C)
                -0.001881520079427*PriceSeries(Price,index-166,O,L,H,C)
                -0.002074697223620*PriceSeries(Price,index-167,O,L,H,C)
                -0.002170373250832*PriceSeries(Price,index-168,O,L,H,C)
                -0.002166698218595*PriceSeries(Price,index-169,O,L,H,C)
                -0.002066296412717*PriceSeries(Price,index-170,O,L,H,C)
                -0.001876067604345*PriceSeries(Price,index-171,O,L,H,C)
                -0.001606740555183*PriceSeries(Price,index-172,O,L,H,C)
                -0.001272322852907*PriceSeries(Price,index-173,O,L,H,C)
                -0.000889375897470*PriceSeries(Price,index-174,O,L,H,C)
                -0.000476223484000*PriceSeries(Price,index-175,O,L,H,C)
                -0.0000520679835867*PriceSeries(Price,index-176,O,L,H,C)
                +0.000363867506842*PriceSeries(Price,index-177,O,L,H,C)
                +0.000753217360120*PriceSeries(Price,index-178,O,L,H,C)
                +0.001099264356427*PriceSeries(Price,index-179,O,L,H,C)
                +0.001387650569678*PriceSeries(Price,index-180,O,L,H,C)
                +0.001606945760664*PriceSeries(Price,index-181,O,L,H,C)
                +0.001749108475365*PriceSeries(Price,index-182,O,L,H,C)
                +0.001809733594937*PriceSeries(Price,index-183,O,L,H,C)
                +0.001788174511129*PriceSeries(Price,index-184,O,L,H,C)
                +0.001687470887395*PriceSeries(Price,index-185,O,L,H,C)
                +0.001514111134955*PriceSeries(Price,index-186,O,L,H,C)
                +0.001277669568125*PriceSeries(Price,index-187,O,L,H,C)
                +0.000990288605466*PriceSeries(Price,index-188,O,L,H,C)
                +0.000666073733604*PriceSeries(Price,index-189,O,L,H,C)
                +0.000320412143264*PriceSeries(Price,index-190,O,L,H,C)
                -0.00003074885533207*PriceSeries(Price,index-191,O,L,H,C)
                -0.000371616545691*PriceSeries(Price,index-192,O,L,H,C)
                -0.000687269542338*PriceSeries(Price,index-193,O,L,H,C)
                -0.000964294549403*PriceSeries(Price,index-194,O,L,H,C)
                -0.001191348007739*PriceSeries(Price,index-195,O,L,H,C)
                -0.001359598516509*PriceSeries(Price,index-196,O,L,H,C)
                -0.001463075972502*PriceSeries(Price,index-197,O,L,H,C)
                -0.001498842785834*PriceSeries(Price,index-198,O,L,H,C)
                -0.001467053742950*PriceSeries(Price,index-199,O,L,H,C)
                -0.001370873990376*PriceSeries(Price,index-200,O,L,H,C)
                -0.001216254627319*PriceSeries(Price,index-201,O,L,H,C)
                -0.001011583684581*PriceSeries(Price,index-202,O,L,H,C)
                -0.000767275931097*PriceSeries(Price,index-203,O,L,H,C)
                -0.000495215297358*PriceSeries(Price,index-204,O,L,H,C)
                -0.0002082310094558*PriceSeries(Price,index-205,O,L,H,C)
                +0.0000805361634411*PriceSeries(Price,index-206,O,L,H,C)
                +0.000358202914112*PriceSeries(Price,index-207,O,L,H,C)
                +0.000612728484471*PriceSeries(Price,index-208,O,L,H,C)
                +0.000833412044512*PriceSeries(Price,index-209,O,L,H,C)
                +0.001011339946444*PriceSeries(Price,index-210,O,L,H,C)
                +0.001139735906440*PriceSeries(Price,index-211,O,L,H,C)
                +0.001214213124748*PriceSeries(Price,index-212,O,L,H,C)
                +0.001232890834096*PriceSeries(Price,index-213,O,L,H,C)
                +0.001196412801451*PriceSeries(Price,index-214,O,L,H,C)
                +0.001107863430180*PriceSeries(Price,index-215,O,L,H,C)
                +0.000972555959694*PriceSeries(Price,index-216,O,L,H,C)
                +0.000797727966277*PriceSeries(Price,index-217,O,L,H,C)
                +0.000592189269260*PriceSeries(Price,index-218,O,L,H,C)
                +0.000365874814145*PriceSeries(Price,index-219,O,L,H,C)
                +0.0001293593658816*PriceSeries(Price,index-220,O,L,H,C)
                -0.0001065904752285*PriceSeries(Price,index-221,O,L,H,C)
                -0.000331550368468*PriceSeries(Price,index-222,O,L,H,C)
                -0.000535840420245*PriceSeries(Price,index-223,O,L,H,C)
                -0.000710975140591*PriceSeries(Price,index-224,O,L,H,C)
                -0.000849981706787*PriceSeries(Price,index-225,O,L,H,C)
                -0.000947684334183*PriceSeries(Price,index-226,O,L,H,C)
                -0.001000868303560*PriceSeries(Price,index-227,O,L,H,C)
                -0.001008379385951*PriceSeries(Price,index-228,O,L,H,C)
                -0.000971116396826*PriceSeries(Price,index-229,O,L,H,C)
                -0.000891945316937*PriceSeries(Price,index-230,O,L,H,C)
                -0.000775495105140*PriceSeries(Price,index-231,O,L,H,C)
                -0.000627914336126*PriceSeries(Price,index-232,O,L,H,C)
                -0.000456566538659*PriceSeries(Price,index-233,O,L,H,C)
                -0.0002696722946749*PriceSeries(Price,index-234,O,L,H,C)
                -0.0000758919516374*PriceSeries(Price,index-235,O,L,H,C)
                +0.0001160262664149*PriceSeries(Price,index-236,O,L,H,C)
                +0.0002976588515693*PriceSeries(Price,index-237,O,L,H,C)
                +0.000461286339486*PriceSeries(Price,index-238,O,L,H,C)
                +0.000600165073937*PriceSeries(Price,index-239,O,L,H,C)
                +0.000708853238064*PriceSeries(Price,index-240,O,L,H,C)
                +0.000783370113838*PriceSeries(Price,index-241,O,L,H,C)
                +0.000821355733226*PriceSeries(Price,index-242,O,L,H,C)
                +0.000822125804708*PriceSeries(Price,index-243,O,L,H,C)
                +0.000786645019482*PriceSeries(Price,index-244,O,L,H,C)
                +0.000717451925691*PriceSeries(Price,index-245,O,L,H,C)
                +0.000618487054629*PriceSeries(Price,index-246,O,L,H,C)
                +0.000494908418821*PriceSeries(Price,index-247,O,L,H,C)
                +0.000352806770476*PriceSeries(Price,index-248,O,L,H,C)
                +0.0001989226486753*PriceSeries(Price,index-249,O,L,H,C)
                +0.0000403104771432*PriceSeries(Price,index-250,O,L,H,C)
                -0.0001159265971617*PriceSeries(Price,index-251,O,L,H,C)
                -0.0002629877399574*PriceSeries(Price,index-252,O,L,H,C)
                -0.000394668942298*PriceSeries(Price,index-253,O,L,H,C)
                -0.000505604576964*PriceSeries(Price,index-254,O,L,H,C)
                -0.000591443631000*PriceSeries(Price,index-255,O,L,H,C)
                -0.000649112801934*PriceSeries(Price,index-256,O,L,H,C)
                -0.000676770101694*PriceSeries(Price,index-257,O,L,H,C)
                -0.000673995209735*PriceSeries(Price,index-258,O,L,H,C)
                -0.000641653542312*PriceSeries(Price,index-259,O,L,H,C)
                -0.000581908066325*PriceSeries(Price,index-260,O,L,H,C)
                -0.000498030886841*PriceSeries(Price,index-261,O,L,H,C)
                -0.000394275954187*PriceSeries(Price,index-262,O,L,H,C)
                -0.0002756279629226*PriceSeries(Price,index-263,O,L,H,C)
                -0.0001476106059634*PriceSeries(Price,index-264,O,L,H,C)
                -0.00001600013174963*PriceSeries(Price,index-265,O,L,H,C)
                +0.0001133940817112*PriceSeries(Price,index-266,O,L,H,C)
                +0.0002350303444657*PriceSeries(Price,index-267,O,L,H,C)
                +0.000343816914701*PriceSeries(Price,index-268,O,L,H,C)
                +0.000435326323013*PriceSeries(Price,index-269,O,L,H,C)
                +0.000505940009132*PriceSeries(Price,index-270,O,L,H,C)
                +0.000553079314634*PriceSeries(Price,index-271,O,L,H,C)
                +0.000575183907722*PriceSeries(Price,index-272,O,L,H,C)
                +0.000571748503788*PriceSeries(Price,index-273,O,L,H,C)
                +0.000543436307309*PriceSeries(Price,index-274,O,L,H,C)
                +0.000491854129911*PriceSeries(Price,index-275,O,L,H,C)
                +0.000419600205780*PriceSeries(Price,index-276,O,L,H,C)
                +0.000330061365598*PriceSeries(Price,index-277,O,L,H,C)
                +0.0002272660780160*PriceSeries(Price,index-278,O,L,H,C)
                +0.0001157261653769*PriceSeries(Price,index-279,O,L,H,C)
                +0.000000199707673993*PriceSeries(Price,index-280,O,L,H,C)
                -0.0001144585649526*PriceSeries(Price,index-281,O,L,H,C)
                -0.0002235403015980*PriceSeries(Price,index-282,O,L,H,C)
                -0.000322613413286*PriceSeries(Price,index-283,O,L,H,C)
                -0.000407746576086*PriceSeries(Price,index-284,O,L,H,C)
                -0.000475602734710*PriceSeries(Price,index-285,O,L,H,C)
                -0.000523594161941*PriceSeries(Price,index-286,O,L,H,C)
                -0.000549870265883*PriceSeries(Price,index-287,O,L,H,C)
                -0.000553442281203*PriceSeries(Price,index-288,O,L,H,C)
                -0.000534230028675*PriceSeries(Price,index-289,O,L,H,C)
                -0.000493006864560*PriceSeries(Price,index-290,O,L,H,C)
                -0.000431106858730*PriceSeries(Price,index-291,O,L,H,C)
                -0.000350850449567*PriceSeries(Price,index-292,O,L,H,C)
                -0.0002548860307175*PriceSeries(Price,index-293,O,L,H,C)
                -0.0001464907751662*PriceSeries(Price,index-294,O,L,H,C)
                -0.00002917551591292*PriceSeries(Price,index-295,O,L,H,C)
                +0.0000933171870261*PriceSeries(Price,index-296,O,L,H,C)
                +0.0002172450730080*PriceSeries(Price,index-297,O,L,H,C)
                +0.000338932170409*PriceSeries(Price,index-298,O,L,H,C)
                +0.000454958062603*PriceSeries(Price,index-299,O,L,H,C)
                +0.000562201703237*PriceSeries(Price,index-300,O,L,H,C)
                +0.000657999601390*PriceSeries(Price,index-301,O,L,H,C)
                +0.000740156875718*PriceSeries(Price,index-302,O,L,H,C)
                +0.000807062562349*PriceSeries(Price,index-303,O,L,H,C)
                +0.000857633778918*PriceSeries(Price,index-304,O,L,H,C)
                +0.000891348875946*PriceSeries(Price,index-305,O,L,H,C)
                +0.000908191413201*PriceSeries(Price,index-306,O,L,H,C)
                +0.000908862406669*PriceSeries(Price,index-307,O,L,H,C)
                +0.000894588809523*PriceSeries(Price,index-308,O,L,H,C)
                +0.000866219905303*PriceSeries(Price,index-309,O,L,H,C)
                +0.000825979702068*PriceSeries(Price,index-310,O,L,H,C)
                +0.000775606893128*PriceSeries(Price,index-311,O,L,H,C)
                +0.000717292296411*PriceSeries(Price,index-312,O,L,H,C)
                +0.000653208624818*PriceSeries(Price,index-313,O,L,H,C)
                +0.000585485901237*PriceSeries(Price,index-314,O,L,H,C)
                +0.000516188347667*PriceSeries(Price,index-315,O,L,H,C)
                +0.000447192255248*PriceSeries(Price,index-316,O,L,H,C)
                +0.000380210458634*PriceSeries(Price,index-317,O,L,H,C)
                +0.000316691481872*PriceSeries(Price,index-318,O,L,H,C)
                +0.0002578747508899*PriceSeries(Price,index-319,O,L,H,C)
                +0.0002047291147389*PriceSeries(Price,index-320,O,L,H,C)
                +0.0001580714923787*PriceSeries(Price,index-321,O,L,H,C)
                +0.0001186048867578*PriceSeries(Price,index-322,O,L,H,C)
                +0.0000872128371319*PriceSeries(Price,index-323,O,L,H,C)
                +0.0000653259596884*PriceSeries(Price,index-324,O,L,H,C)
                +0.0000558520287829*PriceSeries(Price,index-325,O,L,H,C)
                -0.0000739938944542*PriceSeries(Price,index-326,O,L,H,C)
                );

      case N32:
         return(
                0.1248897904062*PriceSeries(Price,index,O,L,H,C)
                +0.1239990834923*PriceSeries(Price,index-1,O,L,H,C)
                +0.1213498798458*PriceSeries(Price,index-2,O,L,H,C)
                +0.1170102269278*PriceSeries(Price,index-3,O,L,H,C)
                +0.1110912146941*PriceSeries(Price,index-4,O,L,H,C)
                +0.1037435736543*PriceSeries(Price,index-5,O,L,H,C)
                +0.0951530727356*PriceSeries(Price,index-6,O,L,H,C)
                +0.0855348706977*PriceSeries(Price,index-7,O,L,H,C)
                +0.0751270093014*PriceSeries(Price,index-8,O,L,H,C)
                +0.0641832642477*PriceSeries(Price,index-9,O,L,H,C)
                +0.0529655901477*PriceSeries(Price,index-10,O,L,H,C)
                +0.0417364077383*PriceSeries(Price,index-11,O,L,H,C)
                +0.03075098487313*PriceSeries(Price,index-12,O,L,H,C)
                +0.02025015740149*PriceSeries(Price,index-13,O,L,H,C)
                +0.01045362216110*PriceSeries(Price,index-14,O,L,H,C)
                +0.001554012497046*PriceSeries(Price,index-15,O,L,H,C)
                -0.00628806217986*PriceSeries(Price,index-16,O,L,H,C)
                -0.01294786618732*PriceSeries(Price,index-17,O,L,H,C)
                -0.01833916972393*PriceSeries(Price,index-18,O,L,H,C)
                -0.02241559925559*PriceSeries(Price,index-19,O,L,H,C)
                -0.02517068657875*PriceSeries(Price,index-20,O,L,H,C)
                -0.02663664166123*PriceSeries(Price,index-21,O,L,H,C)
                -0.02688191751633*PriceSeries(Price,index-22,O,L,H,C)
                -0.02600767549467*PriceSeries(Price,index-23,O,L,H,C)
                -0.02414329508530*PriceSeries(Price,index-24,O,L,H,C)
                -0.02144110238233*PriceSeries(Price,index-25,O,L,H,C)
                -0.01807051479683*PriceSeries(Price,index-26,O,L,H,C)
                -0.01421181563179*PriceSeries(Price,index-27,O,L,H,C)
                -0.01004978032404*PriceSeries(Price,index-28,O,L,H,C)
                -0.00576737632147*PriceSeries(Price,index-29,O,L,H,C)
                -0.001539750829396*PriceSeries(Price,index-30,O,L,H,C)
                +0.002471294558907*PriceSeries(Price,index-31,O,L,H,C)
                +0.00612216535592*PriceSeries(Price,index-32,O,L,H,C)
                +0.00929152271121*PriceSeries(Price,index-33,O,L,H,C)
                +0.01188340255790*PriceSeries(Price,index-34,O,L,H,C)
                +0.01382932509283*PriceSeries(Price,index-35,O,L,H,C)
                +0.01508935253892*PriceSeries(Price,index-36,O,L,H,C)
                +0.01565209201397*PriceSeries(Price,index-37,O,L,H,C)
                +0.01553367841077*PriceSeries(Price,index-38,O,L,H,C)
                +0.01477580809166*PriceSeries(Price,index-39,O,L,H,C)
                +0.01344292663775*PriceSeries(Price,index-40,O,L,H,C)
                +0.01161870174168*PriceSeries(Price,index-41,O,L,H,C)
                +0.00940193465921*PriceSeries(Price,index-42,O,L,H,C)
                +0.00690207973128*PriceSeries(Price,index-43,O,L,H,C)
                +0.00423455089322*PriceSeries(Price,index-44,O,L,H,C)
                +0.001515996602685*PriceSeries(Price,index-45,O,L,H,C)
                -0.001140279694085*PriceSeries(Price,index-46,O,L,H,C)
                -0.00362858725544*PriceSeries(Price,index-47,O,L,H,C)
                -0.00585465435862*PriceSeries(Price,index-48,O,L,H,C)
                -0.00773884563311*PriceSeries(Price,index-49,O,L,H,C)
                -0.00921868896676*PriceSeries(Price,index-50,O,L,H,C)
                -0.01025063982016*PriceSeries(Price,index-51,O,L,H,C)
                -0.01081104200312*PriceSeries(Price,index-52,O,L,H,C)
                -0.01089627588503*PriceSeries(Price,index-53,O,L,H,C)
                -0.01052211639155*PriceSeries(Price,index-54,O,L,H,C)
                -0.00972235279423*PriceSeries(Price,index-55,O,L,H,C)
                -0.00854674913227*PriceSeries(Price,index-56,O,L,H,C)
                -0.00705844715362*PriceSeries(Price,index-57,O,L,H,C)
                -0.00533093213344*PriceSeries(Price,index-58,O,L,H,C)
                -0.00344469522205*PriceSeries(Price,index-59,O,L,H,C)
                -0.001483733709697*PriceSeries(Price,index-60,O,L,H,C)
                +0.000467967388128*PriceSeries(Price,index-61,O,L,H,C)
                +0.002329832654155*PriceSeries(Price,index-62,O,L,H,C)
                +0.00402784172811*PriceSeries(Price,index-63,O,L,H,C)
                +0.00549730599849*PriceSeries(Price,index-64,O,L,H,C)
                +0.00668517770180*PriceSeries(Price,index-65,O,L,H,C)
                +0.00755181406838*PriceSeries(Price,index-66,O,L,H,C)
                +0.00807214307489*PriceSeries(Price,index-67,O,L,H,C)
                +0.00823620273456*PriceSeries(Price,index-68,O,L,H,C)
                +0.00804905163833*PriceSeries(Price,index-69,O,L,H,C)
                +0.00753007362161*PriceSeries(Price,index-70,O,L,H,C)
                +0.00671172299211*PriceSeries(Price,index-71,O,L,H,C)
                +0.00563777781806*PriceSeries(Price,index-72,O,L,H,C)
                +0.00436118657163*PriceSeries(Price,index-73,O,L,H,C)
                +0.002941607322570*PriceSeries(Price,index-74,O,L,H,C)
                +0.001442748228844*PriceSeries(Price,index-75,O,L,H,C)
                -0.0000703769966674*PriceSeries(Price,index-76,O,L,H,C)
                -0.001534164730661*PriceSeries(Price,index-77,O,L,H,C)
                -0.002888998637314*PriceSeries(Price,index-78,O,L,H,C)
                -0.00408158751402*PriceSeries(Price,index-79,O,L,H,C)
                -0.00506697537262*PriceSeries(Price,index-80,O,L,H,C)
                -0.00581015107825*PriceSeries(Price,index-81,O,L,H,C)
                -0.00628720312775*PriceSeries(Price,index-82,O,L,H,C)
                -0.00648598513447*PriceSeries(Price,index-83,O,L,H,C)
                -0.00640627844387*PriceSeries(Price,index-84,O,L,H,C)
                -0.00605945917019*PriceSeries(Price,index-85,O,L,H,C)
                -0.00546769697007*PriceSeries(Price,index-86,O,L,H,C)
                -0.00466273126487*PriceSeries(Price,index-87,O,L,H,C)
                -0.00368428668139*PriceSeries(Price,index-88,O,L,H,C)
                -0.002578202607188*PriceSeries(Price,index-89,O,L,H,C)
                -0.001394361489513*PriceSeries(Price,index-90,O,L,H,C)
                -0.0001845065349247*PriceSeries(Price,index-91,O,L,H,C)
                +0.000999958365286*PriceSeries(Price,index-92,O,L,H,C)
                +0.002110095343160*PriceSeries(Price,index-93,O,L,H,C)
                +0.003101400129407*PriceSeries(Price,index-94,O,L,H,C)
                +0.00393553348437*PriceSeries(Price,index-95,O,L,H,C)
                +0.00458175116772*PriceSeries(Price,index-96,O,L,H,C)
                +0.00501798121462*PriceSeries(Price,index-97,O,L,H,C)
                +0.00523151312624*PriceSeries(Price,index-98,O,L,H,C)
                +0.00521928048495*PriceSeries(Price,index-99,O,L,H,C)
                +0.00498773575045*PriceSeries(Price,index-100,O,L,H,C)
                +0.00455233286456*PriceSeries(Price,index-101,O,L,H,C)
                +0.00393664910437*PriceSeries(Price,index-102,O,L,H,C)
                +0.00317119175054*PriceSeries(Price,index-103,O,L,H,C)
                +0.002291947038093*PriceSeries(Price,index-104,O,L,H,C)
                +0.001338738094082*PriceSeries(Price,index-105,O,L,H,C)
                +0.000353464822994*PriceSeries(Price,index-106,O,L,H,C)
                -0.000621698210284*PriceSeries(Price,index-107,O,L,H,C)
                -0.001546069980779*PriceSeries(Price,index-108,O,L,H,C)
                -0.002382124636539*PriceSeries(Price,index-109,O,L,H,C)
                -0.003096980111610*PriceSeries(Price,index-110,O,L,H,C)
                -0.00366365606761*PriceSeries(Price,index-111,O,L,H,C)
                -0.00406205449307*PriceSeries(Price,index-112,O,L,H,C)
                -0.00427962894353*PriceSeries(Price,index-113,O,L,H,C)
                -0.00431172216918*PriceSeries(Price,index-114,O,L,H,C)
                -0.00416156615411*PriceSeries(Price,index-115,O,L,H,C)
                -0.00383995277707*PriceSeries(Price,index-116,O,L,H,C)
                -0.00336459681232*PriceSeries(Price,index-117,O,L,H,C)
                -0.002759225274400*PriceSeries(Price,index-118,O,L,H,C)
                -0.002052437691655*PriceSeries(Price,index-119,O,L,H,C)
                -0.001276390370360*PriceSeries(Price,index-120,O,L,H,C)
                -0.000465363780995*PriceSeries(Price,index-121,O,L,H,C)
                +0.000345724335049*PriceSeries(Price,index-122,O,L,H,C)
                +0.001122796760275*PriceSeries(Price,index-123,O,L,H,C)
                +0.001834023996771*PriceSeries(Price,index-124,O,L,H,C)
                +0.002451103757832*PriceSeries(Price,index-125,O,L,H,C)
                +0.002950362324009*PriceSeries(Price,index-126,O,L,H,C)
                +0.00331363595353*PriceSeries(Price,index-127,O,L,H,C)
                +0.00352890070304*PriceSeries(Price,index-128,O,L,H,C)
                +0.00359063026571*PriceSeries(Price,index-129,O,L,H,C)
                +0.00349987327607*PriceSeries(Price,index-130,O,L,H,C)
                +0.00326405345533*PriceSeries(Price,index-131,O,L,H,C)
                +0.002896507478428*PriceSeries(Price,index-132,O,L,H,C)
                +0.002415786061772*PriceSeries(Price,index-133,O,L,H,C)
                +0.001844753076843*PriceSeries(Price,index-134,O,L,H,C)
                +0.001209525129683*PriceSeries(Price,index-135,O,L,H,C)
                +0.000538299731014*PriceSeries(Price,index-136,O,L,H,C)
                -0.0001398762767974*PriceSeries(Price,index-137,O,L,H,C)
                -0.000796345069184*PriceSeries(Price,index-138,O,L,H,C)
                -0.001404030941917*PriceSeries(Price,index-139,O,L,H,C)
                -0.001938539240230*PriceSeries(Price,index-140,O,L,H,C)
                -0.002379117260153*PriceSeries(Price,index-141,O,L,H,C)
                -0.002709440058832*PriceSeries(Price,index-142,O,L,H,C)
                -0.002918192298479*PriceSeries(Price,index-143,O,L,H,C)
                -0.002999426459270*PriceSeries(Price,index-144,O,L,H,C)
                -0.002952687581356*PriceSeries(Price,index-145,O,L,H,C)
                -0.002782904709478*PriceSeries(Price,index-146,O,L,H,C)
                -0.002500058990965*PriceSeries(Price,index-147,O,L,H,C)
                -0.002118647514117*PriceSeries(Price,index-148,O,L,H,C)
                -0.001656970099993*PriceSeries(Price,index-149,O,L,H,C)
                -0.001136273058573*PriceSeries(Price,index-150,O,L,H,C)
                -0.000579789135247*PriceSeries(Price,index-151,O,L,H,C)
                -0.00001171632359100*PriceSeries(Price,index-152,O,L,H,C)
                +0.000543820198737*PriceSeries(Price,index-153,O,L,H,C)
                +0.001063779065490*PriceSeries(Price,index-154,O,L,H,C)
                +0.001527144850548*PriceSeries(Price,index-155,O,L,H,C)
                +0.001915763383159*PriceSeries(Price,index-156,O,L,H,C)
                +0.002215037658571*PriceSeries(Price,index-157,O,L,H,C)
                +0.002414458353965*PriceSeries(Price,index-158,O,L,H,C)
                +0.002507950500860*PriceSeries(Price,index-159,O,L,H,C)
                +0.002494026008538*PriceSeries(Price,index-160,O,L,H,C)
                +0.002375740122274*PriceSeries(Price,index-161,O,L,H,C)
                +0.002160458176715*PriceSeries(Price,index-162,O,L,H,C)
                +0.001859446822867*PriceSeries(Price,index-163,O,L,H,C)
                +0.001487310948510*PriceSeries(Price,index-164,O,L,H,C)
                +0.001061303498724*PriceSeries(Price,index-165,O,L,H,C)
                +0.000600540108818*PriceSeries(Price,index-166,O,L,H,C)
                +0.0001251537192203*PriceSeries(Price,index-167,O,L,H,C)
                -0.000344573951833*PriceSeries(Price,index-168,O,L,H,C)
                -0.000789067081783*PriceSeries(Price,index-169,O,L,H,C)
                -0.001190261001929*PriceSeries(Price,index-170,O,L,H,C)
                -0.001532325372558*PriceSeries(Price,index-171,O,L,H,C)
                -0.001802276806295*PriceSeries(Price,index-172,O,L,H,C)
                -0.001990457770165*PriceSeries(Price,index-173,O,L,H,C)
                -0.002090864749420*PriceSeries(Price,index-174,O,L,H,C)
                -0.002101315384380*PriceSeries(Price,index-175,O,L,H,C)
                -0.002023451298920*PriceSeries(Price,index-176,O,L,H,C)
                -0.001862580323757*PriceSeries(Price,index-177,O,L,H,C)
                -0.001627368484412*PriceSeries(Price,index-178,O,L,H,C)
                -0.001329398198361*PriceSeries(Price,index-179,O,L,H,C)
                -0.000982614365294*PriceSeries(Price,index-180,O,L,H,C)
                -0.000602684237557*PriceSeries(Price,index-181,O,L,H,C)
                -0.0002062999724754*PriceSeries(Price,index-182,O,L,H,C)
                +0.0001895455034890*PriceSeries(Price,index-183,O,L,H,C)
                +0.000568278288262*PriceSeries(Price,index-184,O,L,H,C)
                +0.000914428836761*PriceSeries(Price,index-185,O,L,H,C)
                +0.001214254868756*PriceSeries(Price,index-186,O,L,H,C)
                +0.001456277166463*PriceSeries(Price,index-187,O,L,H,C)
                +0.001631707814709*PriceSeries(Price,index-188,O,L,H,C)
                +0.001734755435381*PriceSeries(Price,index-189,O,L,H,C)
                +0.001762797499835*PriceSeries(Price,index-190,O,L,H,C)
                +0.001716415623127*PriceSeries(Price,index-191,O,L,H,C)
                +0.001599295600081*PriceSeries(Price,index-192,O,L,H,C)
                +0.001417999587176*PriceSeries(Price,index-193,O,L,H,C)
                +0.001181623032145*PriceSeries(Price,index-194,O,L,H,C)
                +0.000901353496014*PriceSeries(Price,index-195,O,L,H,C)
                +0.000589952223983*PriceSeries(Price,index-196,O,L,H,C)
                +0.0002611820661832*PriceSeries(Price,index-197,O,L,H,C)
                -0.0000707929644850*PriceSeries(Price,index-198,O,L,H,C)
                -0.000392010626725*PriceSeries(Price,index-199,O,L,H,C)
                -0.000689290523034*PriceSeries(Price,index-200,O,L,H,C)
                -0.000950767522771*PriceSeries(Price,index-201,O,L,H,C)
                -0.001166357276966*PriceSeries(Price,index-202,O,L,H,C)
                -0.001328135925624*PriceSeries(Price,index-203,O,L,H,C)
                -0.001430620130048*PriceSeries(Price,index-204,O,L,H,C)
                -0.001470938081967*PriceSeries(Price,index-205,O,L,H,C)
                -0.001448886946364*PriceSeries(Price,index-206,O,L,H,C)
                -0.001366877076495*PriceSeries(Price,index-207,O,L,H,C)
                -0.001229768089131*PriceSeries(Price,index-208,O,L,H,C)
                -0.001044606307338*PriceSeries(Price,index-209,O,L,H,C)
                -0.000820276987862*PriceSeries(Price,index-210,O,L,H,C)
                -0.000567087997732*PriceSeries(Price,index-211,O,L,H,C)
                -0.0002963040700256*PriceSeries(Price,index-212,O,L,H,C)
                -0.00001965236874555*PriceSeries(Price,index-213,O,L,H,C)
                +0.0002511792167400*PriceSeries(Price,index-214,O,L,H,C)
                +0.000505029851140*PriceSeries(Price,index-215,O,L,H,C)
                +0.000731719515446*PriceSeries(Price,index-216,O,L,H,C)
                +0.000922450579783*PriceSeries(Price,index-217,O,L,H,C)
                +0.001070141647927*PriceSeries(Price,index-218,O,L,H,C)
                +0.001169681355642*PriceSeries(Price,index-219,O,L,H,C)
                +0.001218093465959*PriceSeries(Price,index-220,O,L,H,C)
                +0.001214608541919*PriceSeries(Price,index-221,O,L,H,C)
                +0.001160641518346*PriceSeries(Price,index-222,O,L,H,C)
                +0.001059678464930*PriceSeries(Price,index-223,O,L,H,C)
                +0.000917079565429*PriceSeries(Price,index-224,O,L,H,C)
                +0.000739808678497*PriceSeries(Price,index-225,O,L,H,C)
                +0.000536102661740*PriceSeries(Price,index-226,O,L,H,C)
                +0.0003150958267063*PriceSeries(Price,index-227,O,L,H,C)
                +0.0000864163736685*PriceSeries(Price,index-228,O,L,H,C)
                -0.0001402276101641*PriceSeries(Price,index-229,O,L,H,C)
                -0.000355455025590*PriceSeries(Price,index-230,O,L,H,C)
                -0.000550594698179*PriceSeries(Price,index-231,O,L,H,C)
                -0.000718028997468*PriceSeries(Price,index-232,O,L,H,C)
                -0.000851484793552*PriceSeries(Price,index-233,O,L,H,C)
                -0.000946260943697*PriceSeries(Price,index-234,O,L,H,C)
                -0.000999384425919*PriceSeries(Price,index-235,O,L,H,C)
                -0.001009690417590*PriceSeries(Price,index-236,O,L,H,C)
                -0.000977824916832*PriceSeries(Price,index-237,O,L,H,C)
                -0.000906171781652*PriceSeries(Price,index-238,O,L,H,C)
                -0.000798709178307*PriceSeries(Price,index-239,O,L,H,C)
                -0.000660803257507*PriceSeries(Price,index-240,O,L,H,C)
                -0.000498949301295*PriceSeries(Price,index-241,O,L,H,C)
                -0.000320472512134*PriceSeries(Price,index-242,O,L,H,C)
                -0.0001332019807160*PriceSeries(Price,index-243,O,L,H,C)
                +0.0000548678707603*PriceSeries(Price,index-244,O,L,H,C)
                +0.0002359139312373*PriceSeries(Price,index-245,O,L,H,C)
                +0.000402605154642*PriceSeries(Price,index-246,O,L,H,C)
                +0.000548394482699*PriceSeries(Price,index-247,O,L,H,C)
                +0.000667770537334*PriceSeries(Price,index-248,O,L,H,C)
                +0.000756459659747*PriceSeries(Price,index-249,O,L,H,C)
                +0.000811571191314*PriceSeries(Price,index-250,O,L,H,C)
                +0.000831681447348*PriceSeries(Price,index-251,O,L,H,C)
                +0.000816854516084*PriceSeries(Price,index-252,O,L,H,C)
                +0.000768600705772*PriceSeries(Price,index-253,O,L,H,C)
                +0.000689776047070*PriceSeries(Price,index-254,O,L,H,C)
                +0.000584428627137*PriceSeries(Price,index-255,O,L,H,C)
                +0.000457599589336*PriceSeries(Price,index-256,O,L,H,C)
                +0.0003150882988527*PriceSeries(Price,index-257,O,L,H,C)
                +0.0001631923917554*PriceSeries(Price,index-258,O,L,H,C)
                +0.00000843415784265*PriceSeries(Price,index-259,O,L,H,C)
                -0.0001427150556764*PriceSeries(Price,index-260,O,L,H,C)
                -0.0002841009826785*PriceSeries(Price,index-261,O,L,H,C)
                -0.000410132390374*PriceSeries(Price,index-262,O,L,H,C)
                -0.000515997240425*PriceSeries(Price,index-263,O,L,H,C)
                -0.000597840936387*PriceSeries(Price,index-264,O,L,H,C)
                -0.000652900309401*PriceSeries(Price,index-265,O,L,H,C)
                -0.000679588985115*PriceSeries(Price,index-266,O,L,H,C)
                -0.000677531899117*PriceSeries(Price,index-267,O,L,H,C)
                -0.000647548896706*PriceSeries(Price,index-268,O,L,H,C)
                -0.000591589473284*PriceSeries(Price,index-269,O,L,H,C)
                -0.000512622692925*PriceSeries(Price,index-270,O,L,H,C)
                -0.000414488079757*PriceSeries(Price,index-271,O,L,H,C)
                -0.0003017147365273*PriceSeries(Price,index-272,O,L,H,C)
                -0.0001793170506533*PriceSeries(Price,index-273,O,L,H,C)
                -0.0000525760640009*PriceSeries(Price,index-274,O,L,H,C)
                +0.0000731841062685*PriceSeries(Price,index-275,O,L,H,C)
                +0.0001928154966903*PriceSeries(Price,index-276,O,L,H,C)
                +0.0003015523420853*PriceSeries(Price,index-277,O,L,H,C)
                +0.000395195906743*PriceSeries(Price,index-278,O,L,H,C)
                +0.000470271173081*PriceSeries(Price,index-279,O,L,H,C)
                +0.000524149800717*PriceSeries(Price,index-280,O,L,H,C)
                +0.000555135295611*PriceSeries(Price,index-281,O,L,H,C)
                +0.000562507978139*PriceSeries(Price,index-282,O,L,H,C)
                +0.000546529044452*PriceSeries(Price,index-283,O,L,H,C)
                +0.000508404707307*PriceSeries(Price,index-284,O,L,H,C)
                +0.000450213009705*PriceSeries(Price,index-285,O,L,H,C)
                +0.000374797358558*PriceSeries(Price,index-286,O,L,H,C)
                +0.0002856320645521*PriceSeries(Price,index-287,O,L,H,C)
                +0.0001866661494745*PriceSeries(Price,index-288,O,L,H,C)
                +0.0000821523601277*PriceSeries(Price,index-289,O,L,H,C)
                -0.00002353130635656*PriceSeries(Price,index-290,O,L,H,C)
                -0.0001260602054388*PriceSeries(Price,index-291,O,L,H,C)
                -0.0002213346542473*PriceSeries(Price,index-292,O,L,H,C)
                -0.0003056379306286*PriceSeries(Price,index-293,O,L,H,C)
                -0.000375774787710*PriceSeries(Price,index-294,O,L,H,C)
                -0.000429185552457*PriceSeries(Price,index-295,O,L,H,C)
                -0.000464031984332*PriceSeries(Price,index-296,O,L,H,C)
                -0.000479252302726*PriceSeries(Price,index-297,O,L,H,C)
                -0.000474584104286*PriceSeries(Price,index-298,O,L,H,C)
                -0.000450555231367*PriceSeries(Price,index-299,O,L,H,C)
                -0.000408443961664*PriceSeries(Price,index-300,O,L,H,C)
                -0.000350211103744*PriceSeries(Price,index-301,O,L,H,C)
                -0.0002784076431503*PriceSeries(Price,index-302,O,L,H,C)
                -0.0001960624375237*PriceSeries(Price,index-303,O,L,H,C)
                -0.0001065550720038*PriceSeries(Price,index-304,O,L,H,C)
                -0.00001347934365605*PriceSeries(Price,index-305,O,L,H,C)
                +0.0000794970472275*PriceSeries(Price,index-306,O,L,H,C)
                +0.0001687711365837*PriceSeries(Price,index-307,O,L,H,C)
                +0.0002509365109681*PriceSeries(Price,index-308,O,L,H,C)
                +0.000322903604155*PriceSeries(Price,index-309,O,L,H,C)
                +0.000382004374276*PriceSeries(Price,index-310,O,L,H,C)
                +0.000426077959455*PriceSeries(Price,index-311,O,L,H,C)
                +0.000453534706143*PriceSeries(Price,index-312,O,L,H,C)
                +0.000463396846979*PriceSeries(Price,index-313,O,L,H,C)
                +0.000455315057154*PriceSeries(Price,index-314,O,L,H,C)
                +0.000429561109880*PriceSeries(Price,index-315,O,L,H,C)
                +0.000386997836185*PriceSeries(Price,index-316,O,L,H,C)
                +0.000329028512152*PriceSeries(Price,index-317,O,L,H,C)
                +0.0002575285835507*PriceSeries(Price,index-318,O,L,H,C)
                +0.0001747632372696*PriceSeries(Price,index-319,O,L,H,C)
                +0.0000832947048989*PriceSeries(Price,index-320,O,L,H,C)
                -0.00001411667090953*PriceSeries(Price,index-321,O,L,H,C)
                -0.0001146136392972*PriceSeries(Price,index-322,O,L,H,C)
                -0.0002153417695298*PriceSeries(Price,index-323,O,L,H,C)
                -0.0003135442906811*PriceSeries(Price,index-324,O,L,H,C)
                -0.000406649012878*PriceSeries(Price,index-325,O,L,H,C)
                -0.000492344707898*PriceSeries(Price,index-326,O,L,H,C)
                -0.000568644751901*PriceSeries(Price,index-327,O,L,H,C)
                -0.000633936292390*PriceSeries(Price,index-328,O,L,H,C)
                -0.000687013722872*PriceSeries(Price,index-329,O,L,H,C)
                -0.000727095853750*PriceSeries(Price,index-330,O,L,H,C)
                -0.000753826855322*PriceSeries(Price,index-331,O,L,H,C)
                -0.000767261784385*PriceSeries(Price,index-332,O,L,H,C)
                -0.000767838223449*PriceSeries(Price,index-333,O,L,H,C)
                -0.000756336176036*PriceSeries(Price,index-334,O,L,H,C)
                -0.000733828790905*PriceSeries(Price,index-335,O,L,H,C)
                -0.000701626678476*PriceSeries(Price,index-336,O,L,H,C)
                -0.000661218528302*PriceSeries(Price,index-337,O,L,H,C)
                -0.000614210486352*PriceSeries(Price,index-338,O,L,H,C)
                -0.000562266400535*PriceSeries(Price,index-339,O,L,H,C)
                -0.000507050709829*PriceSeries(Price,index-340,O,L,H,C)
                -0.000450175542141*PriceSeries(Price,index-341,O,L,H,C)
                -0.000393153559741*PriceSeries(Price,index-342,O,L,H,C)
                -0.000337358243518*PriceSeries(Price,index-343,O,L,H,C)
                -0.0002839935674659*PriceSeries(Price,index-344,O,L,H,C)
                -0.0002340752739599*PriceSeries(Price,index-345,O,L,H,C)
                -0.0001884261352883*PriceSeries(Price,index-346,O,L,H,C)
                -0.0001476877356427*PriceSeries(Price,index-347,O,L,H,C)
                -0.0001123518786548*PriceSeries(Price,index-348,O,L,H,C)
                -0.0000828172665334*PriceSeries(Price,index-349,O,L,H,C)
                -0.0000594867649163*PriceSeries(Price,index-350,O,L,H,C)
                -0.0000429534414029*PriceSeries(Price,index-351,O,L,H,C)
                -0.0000341574487203*PriceSeries(Price,index-352,O,L,H,C)
                +0.0000829093606086*PriceSeries(Price,index-353,O,L,H,C)
                );

      case N33:
         return(
                0.1228102424378*PriceSeries(Price,index,O,L,H,C)
                +0.1219431345488*PriceSeries(Price,index-1,O,L,H,C)
                +0.1193639167049*PriceSeries(Price,index-2,O,L,H,C)
                +0.1151382331114*PriceSeries(Price,index-3,O,L,H,C)
                +0.1093732689822*PriceSeries(Price,index-4,O,L,H,C)
                +0.1022144955073*PriceSeries(Price,index-5,O,L,H,C)
                +0.0938412652908*PriceSeries(Price,index-6,O,L,H,C)
                +0.0844614042799*PriceSeries(Price,index-7,O,L,H,C)
                +0.0743049790107*PriceSeries(Price,index-8,O,L,H,C)
                +0.0636174445338*PriceSeries(Price,index-9,O,L,H,C)
                +0.0526523977370*PriceSeries(Price,index-10,O,L,H,C)
                +0.0416641723181*PriceSeries(Price,index-11,O,L,H,C)
                +0.03090051504550*PriceSeries(Price,index-12,O,L,H,C)
                +0.02059557808498*PriceSeries(Price,index-13,O,L,H,C)
                +0.01096344925718*PriceSeries(Price,index-14,O,L,H,C)
                +0.002192421649761*PriceSeries(Price,index-15,O,L,H,C)
                -0.00555982314926*PriceSeries(Price,index-16,O,L,H,C)
                -0.01216997679524*PriceSeries(Price,index-17,O,L,H,C)
                -0.01755170689782*PriceSeries(Price,index-18,O,L,H,C)
                -0.02165703725278*PriceSeries(Price,index-19,O,L,H,C)
                -0.02447648438138*PriceSeries(Price,index-20,O,L,H,C)
                -0.02603797154102*PriceSeries(Price,index-21,O,L,H,C)
                -0.02640458241842*PriceSeries(Price,index-22,O,L,H,C)
                -0.02567125501713*PriceSeries(Price,index-23,O,L,H,C)
                -0.02396055045573*PriceSeries(Price,index-24,O,L,H,C)
                -0.02141766031189*PriceSeries(Price,index-25,O,L,H,C)
                -0.01820483884510*PriceSeries(Price,index-26,O,L,H,C)
                -0.01449546222124*PriceSeries(Price,index-27,O,L,H,C)
                -0.01046792527743*PriceSeries(Price,index-28,O,L,H,C)
                -0.00629958718719*PriceSeries(Price,index-29,O,L,H,C)
                -0.002160970710473*PriceSeries(Price,index-30,O,L,H,C)
                +0.001789594054499*PriceSeries(Price,index-31,O,L,H,C)
                +0.00541071073300*PriceSeries(Price,index-32,O,L,H,C)
                +0.00858189774938*PriceSeries(Price,index-33,O,L,H,C)
                +0.01120669512883*PriceSeries(Price,index-34,O,L,H,C)
                +0.01321481665230*PriceSeries(Price,index-35,O,L,H,C)
                +0.01456330298594*PriceSeries(Price,index-36,O,L,H,C)
                +0.01523666815641*PriceSeries(Price,index-37,O,L,H,C)
                +0.01524606792145*PriceSeries(Price,index-38,O,L,H,C)
                +0.01462755286404*PriceSeries(Price,index-39,O,L,H,C)
                +0.01343950016517*PriceSeries(Price,index-40,O,L,H,C)
                +0.01175934492154*PriceSeries(Price,index-41,O,L,H,C)
                +0.00967975370985*PriceSeries(Price,index-42,O,L,H,C)
                +0.00730439916608*PriceSeries(Price,index-43,O,L,H,C)
                +0.00474350414362*PriceSeries(Price,index-44,O,L,H,C)
                +0.002109327311568*PriceSeries(Price,index-45,O,L,H,C)
                -0.000488241079276*PriceSeries(Price,index-46,O,L,H,C)
                -0.002945813812688*PriceSeries(Price,index-47,O,L,H,C)
                -0.00517022721741*PriceSeries(Price,index-48,O,L,H,C)
                -0.00708172305707*PriceSeries(Price,index-49,O,L,H,C)
                -0.00861649136980*PriceSeries(Price,index-50,O,L,H,C)
                -0.00972850098110*PriceSeries(Price,index-51,O,L,H,C)
                -0.01039057355578*PriceSeries(Price,index-52,O,L,H,C)
                -0.01059468707082*PriceSeries(Price,index-53,O,L,H,C)
                -0.01035152431007*PriceSeries(Price,index-54,O,L,H,C)
                -0.00968931023783*PriceSeries(Price,index-55,O,L,H,C)
                -0.00865200786479*PriceSeries(Price,index-56,O,L,H,C)
                -0.00729696459960*PriceSeries(Price,index-57,O,L,H,C)
                -0.00569211932230*PriceSeries(Price,index-58,O,L,H,C)
                -0.00391289388752*PriceSeries(Price,index-59,O,L,H,C)
                -0.002038901053330*PriceSeries(Price,index-60,O,L,H,C)
                -0.0001506037902019*PriceSeries(Price,index-61,O,L,H,C)
                +0.001673941390855*PriceSeries(Price,index-62,O,L,H,C)
                +0.00336213184538*PriceSeries(Price,index-63,O,L,H,C)
                +0.00484954377781*PriceSeries(Price,index-64,O,L,H,C)
                +0.00608223779943*PriceSeries(Price,index-65,O,L,H,C)
                +0.00701856751529*PriceSeries(Price,index-66,O,L,H,C)
                +0.00763043550686*PriceSeries(Price,index-67,O,L,H,C)
                +0.00790396457390*PriceSeries(Price,index-68,O,L,H,C)
                +0.00783957621355*PriceSeries(Price,index-69,O,L,H,C)
                +0.00745149203382*PriceSeries(Price,index-70,O,L,H,C)
                +0.00676669619163*PriceSeries(Price,index-71,O,L,H,C)
                +0.00582341721199*PriceSeries(Price,index-72,O,L,H,C)
                +0.00466920496195*PriceSeries(Price,index-73,O,L,H,C)
                +0.00335869246177*PriceSeries(Price,index-74,O,L,H,C)
                +0.001951142130351*PriceSeries(Price,index-75,O,L,H,C)
                +0.000507881730505*PriceSeries(Price,index-76,O,L,H,C)
                -0.000910263369449*PriceSeries(Price,index-77,O,L,H,C)
                -0.002245437935835*PriceSeries(Price,index-78,O,L,H,C)
                -0.00344502796720*PriceSeries(Price,index-79,O,L,H,C)
                -0.00446364923729*PriceSeries(Price,index-80,O,L,H,C)
                -0.00526478121907*PriceSeries(Price,index-81,O,L,H,C)
                -0.00582199065776*PriceSeries(Price,index-82,O,L,H,C)
                -0.00611970721307*PriceSeries(Price,index-83,O,L,H,C)
                -0.00615353279198*PriceSeries(Price,index-84,O,L,H,C)
                -0.00593008559095*PriceSeries(Price,index-85,O,L,H,C)
                -0.00546639865310*PriceSeries(Price,index-86,O,L,H,C)
                -0.00478891023359*PriceSeries(Price,index-87,O,L,H,C)
                -0.00393209881418*PriceSeries(Price,index-88,O,L,H,C)
                -0.002936828594628*PriceSeries(Price,index-89,O,L,H,C)
                -0.001848481212886*PriceSeries(Price,index-90,O,L,H,C)
                -0.000714956020419*PriceSeries(Price,index-91,O,L,H,C)
                +0.000415375662037*PriceSeries(Price,index-92,O,L,H,C)
                +0.001495677320660*PriceSeries(Price,index-93,O,L,H,C)
                +0.002482533992018*PriceSeries(Price,index-94,O,L,H,C)
                +0.00333764505753*PriceSeries(Price,index-95,O,L,H,C)
                +0.00402925910986*PriceSeries(Price,index-96,O,L,H,C)
                +0.00453329915855*PriceSeries(Price,index-97,O,L,H,C)
                +0.00483414050238*PriceSeries(Price,index-98,O,L,H,C)
                +0.00492501886902*PriceSeries(Price,index-99,O,L,H,C)
                +0.00480806219271*PriceSeries(Price,index-100,O,L,H,C)
                +0.00449395498080*PriceSeries(Price,index-101,O,L,H,C)
                +0.00400125902997*PriceSeries(Price,index-102,O,L,H,C)
                +0.00335542775379*PriceSeries(Price,index-103,O,L,H,C)
                +0.002587563010849*PriceSeries(Price,index-104,O,L,H,C)
                +0.001732972591893*PriceSeries(Price,index-105,O,L,H,C)
                +0.000829593146851*PriceSeries(Price,index-106,O,L,H,C)
                -0.0000836528299983*PriceSeries(Price,index-107,O,L,H,C)
                -0.000968496391278*PriceSeries(Price,index-108,O,L,H,C)
                -0.001788890318044*PriceSeries(Price,index-109,O,L,H,C)
                -0.002512443254523*PriceSeries(Price,index-110,O,L,H,C)
                -0.003111664139744*PriceSeries(Price,index-111,O,L,H,C)
                -0.00356497052035*PriceSeries(Price,index-112,O,L,H,C)
                -0.00385742526782*PriceSeries(Price,index-113,O,L,H,C)
                -0.00398117839907*PriceSeries(Price,index-114,O,L,H,C)
                -0.00393560351404*PriceSeries(Price,index-115,O,L,H,C)
                -0.00372713122578*PriceSeries(Price,index-116,O,L,H,C)
                -0.00336879439077*PriceSeries(Price,index-117,O,L,H,C)
                -0.002879511509588*PriceSeries(Price,index-118,O,L,H,C)
                -0.002283144860820*PriceSeries(Price,index-119,O,L,H,C)
                -0.001607378297149*PriceSeries(Price,index-120,O,L,H,C)
                -0.000882465896811*PriceSeries(Price,index-121,O,L,H,C)
                -0.0001399067009196*PriceSeries(Price,index-122,O,L,H,C)
                +0.000588897543533*PriceSeries(Price,index-123,O,L,H,C)
                +0.001273945468513*PriceSeries(Price,index-124,O,L,H,C)
                +0.001887846944793*PriceSeries(Price,index-125,O,L,H,C)
                +0.002406893866854*PriceSeries(Price,index-126,O,L,H,C)
                +0.002811950007749*PriceSeries(Price,index-127,O,L,H,C)
                +0.003089127619241*PriceSeries(Price,index-128,O,L,H,C)
                +0.00323022817417*PriceSeries(Price,index-129,O,L,H,C)
                +0.00323293505873*PriceSeries(Price,index-130,O,L,H,C)
                +0.003100756608139*PriceSeries(Price,index-131,O,L,H,C)
                +0.002842728251729*PriceSeries(Price,index-132,O,L,H,C)
                +0.002472892346381*PriceSeries(Price,index-133,O,L,H,C)
                +0.002009583097290*PriceSeries(Price,index-134,O,L,H,C)
                +0.001474551361644*PriceSeries(Price,index-135,O,L,H,C)
                +0.000891969850544*PriceSeries(Price,index-136,O,L,H,C)
                +0.0002873631874647*PriceSeries(Price,index-137,O,L,H,C)
                -0.0003134906697565*PriceSeries(Price,index-138,O,L,H,C)
                -0.000885641117478*PriceSeries(Price,index-139,O,L,H,C)
                -0.001405983164791*PriceSeries(Price,index-140,O,L,H,C)
                -0.001854172484420*PriceSeries(Price,index-141,O,L,H,C)
                -0.002213401771062*PriceSeries(Price,index-142,O,L,H,C)
                -0.002471009571220*PriceSeries(Price,index-143,O,L,H,C)
                -0.002618900509851*PriceSeries(Price,index-144,O,L,H,C)
                -0.002653764288962*PriceSeries(Price,index-145,O,L,H,C)
                -0.002577089516998*PriceSeries(Price,index-146,O,L,H,C)
                -0.002394977031317*PriceSeries(Price,index-147,O,L,H,C)
                -0.002117765641502*PriceSeries(Price,index-148,O,L,H,C)
                -0.001759490779334*PriceSeries(Price,index-149,O,L,H,C)
                -0.001337202984929*PriceSeries(Price,index-150,O,L,H,C)
                -0.000870178255505*PriceSeries(Price,index-151,O,L,H,C)
                -0.000379055967984*PriceSeries(Price,index-152,O,L,H,C)
                +0.0001150577421562*PriceSeries(Price,index-153,O,L,H,C)
                +0.000591482770545*PriceSeries(Price,index-154,O,L,H,C)
                +0.001030816833318*PriceSeries(Price,index-155,O,L,H,C)
                +0.001415711794651*PriceSeries(Price,index-156,O,L,H,C)
                +0.001731544059555*PriceSeries(Price,index-157,O,L,H,C)
                +0.001966953721936*PriceSeries(Price,index-158,O,L,H,C)
                +0.002114233339410*PriceSeries(Price,index-159,O,L,H,C)
                +0.002169554048115*PriceSeries(Price,index-160,O,L,H,C)
                +0.002133023820290*PriceSeries(Price,index-161,O,L,H,C)
                +0.002008579752216*PriceSeries(Price,index-162,O,L,H,C)
                +0.001803723176858*PriceSeries(Price,index-163,O,L,H,C)
                +0.001529112815825*PriceSeries(Price,index-164,O,L,H,C)
                +0.001198036731096*PriceSeries(Price,index-165,O,L,H,C)
                +0.000825788292696*PriceSeries(Price,index-166,O,L,H,C)
                +0.000428974718976*PriceSeries(Price,index-167,O,L,H,C)
                +0.00002478889602618*PriceSeries(Price,index-168,O,L,H,C)
                -0.000369724045751*PriceSeries(Price,index-169,O,L,H,C)
                -0.000738374589839*PriceSeries(Price,index-170,O,L,H,C)
                -0.001066482247970*PriceSeries(Price,index-171,O,L,H,C)
                -0.001341448633445*PriceSeries(Price,index-172,O,L,H,C)
                -0.001553228275032*PriceSeries(Price,index-173,O,L,H,C)
                -0.001694680155396*PriceSeries(Price,index-174,O,L,H,C)
                -0.001761788480536*PriceSeries(Price,index-175,O,L,H,C)
                -0.001753746943266*PriceSeries(Price,index-176,O,L,H,C)
                -0.001672906530265*PriceSeries(Price,index-177,O,L,H,C)
                -0.001524592646528*PriceSeries(Price,index-178,O,L,H,C)
                -0.001316802743884*PriceSeries(Price,index-179,O,L,H,C)
                -0.001059800364529*PriceSeries(Price,index-180,O,L,H,C)
                -0.000765625340699*PriceSeries(Price,index-181,O,L,H,C)
                -0.000447542846393*PriceSeries(Price,index-182,O,L,H,C)
                -0.0001194560364570*PriceSeries(Price,index-183,O,L,H,C)
                +0.0002046920752511*PriceSeries(Price,index-184,O,L,H,C)
                +0.000511502158076*PriceSeries(Price,index-185,O,L,H,C)
                +0.000788663551563*PriceSeries(Price,index-186,O,L,H,C)
                +0.001025438927289*PriceSeries(Price,index-187,O,L,H,C)
                +0.001213069889264*PriceSeries(Price,index-188,O,L,H,C)
                +0.001345088642466*PriceSeries(Price,index-189,O,L,H,C)
                +0.001417525301730*PriceSeries(Price,index-190,O,L,H,C)
                +0.001429005056304*PriceSeries(Price,index-191,O,L,H,C)
                +0.001380734080729*PriceSeries(Price,index-192,O,L,H,C)
                +0.001276377778631*PriceSeries(Price,index-193,O,L,H,C)
                +0.001121839472848*PriceSeries(Price,index-194,O,L,H,C)
                +0.000924951638339*PriceSeries(Price,index-195,O,L,H,C)
                +0.000695095008840*PriceSeries(Price,index-196,O,L,H,C)
                +0.000442763440864*PriceSeries(Price,index-197,O,L,H,C)
                +0.0001790942949336*PriceSeries(Price,index-198,O,L,H,C)
                -0.0000846149323527*PriceSeries(Price,index-199,O,L,H,C)
                -0.000337383071335*PriceSeries(Price,index-200,O,L,H,C)
                -0.000568995144044*PriceSeries(Price,index-201,O,L,H,C)
                -0.000770407544393*PriceSeries(Price,index-202,O,L,H,C)
                -0.000934092720391*PriceSeries(Price,index-203,O,L,H,C)
                -0.001054310567907*PriceSeries(Price,index-204,O,L,H,C)
                -0.001127297307183*PriceSeries(Price,index-205,O,L,H,C)
                -0.001151366330163*PriceSeries(Price,index-206,O,L,H,C)
                -0.001126919232901*PriceSeries(Price,index-207,O,L,H,C)
                -0.001056369053519*PriceSeries(Price,index-208,O,L,H,C)
                -0.000943981495445*PriceSeries(Price,index-209,O,L,H,C)
                -0.000795643244569*PriceSeries(Price,index-210,O,L,H,C)
                -0.000618569170621*PriceSeries(Price,index-211,O,L,H,C)
                -0.000420962355843*PriceSeries(Price,index-212,O,L,H,C)
                -0.0002116425811254*PriceSeries(Price,index-213,O,L,H,C)
                +0.000000340123878486*PriceSeries(Price,index-214,O,L,H,C)
                +0.0002060902014000*PriceSeries(Price,index-215,O,L,H,C)
                +0.000397233575555*PriceSeries(Price,index-216,O,L,H,C)
                +0.000566252120816*PriceSeries(Price,index-217,O,L,H,C)
                +0.000706772417266*PriceSeries(Price,index-218,O,L,H,C)
                +0.000813797959997*PriceSeries(Price,index-219,O,L,H,C)
                +0.000883876841000*PriceSeries(Price,index-220,O,L,H,C)
                +0.000915199874542*PriceSeries(Price,index-221,O,L,H,C)
                +0.000907627051879*PriceSeries(Price,index-222,O,L,H,C)
                +0.000862643247221*PriceSeries(Price,index-223,O,L,H,C)
                +0.000783247198190*PriceSeries(Price,index-224,O,L,H,C)
                +0.000673780545278*PriceSeries(Price,index-225,O,L,H,C)
                +0.000539705889639*PriceSeries(Price,index-226,O,L,H,C)
                +0.000387344591788*PriceSeries(Price,index-227,O,L,H,C)
                +0.0002235865244358*PriceSeries(Price,index-228,O,L,H,C)
                +0.0000555849442387*PriceSeries(Price,index-229,O,L,H,C)
                -0.0001095502197017*PriceSeries(Price,index-230,O,L,H,C)
                -0.0002650478690215*PriceSeries(Price,index-231,O,L,H,C)
                -0.000404748043834*PriceSeries(Price,index-232,O,L,H,C)
                -0.000523340205029*PriceSeries(Price,index-233,O,L,H,C)
                -0.000616558443818*PriceSeries(Price,index-234,O,L,H,C)
                -0.000681326859974*PriceSeries(Price,index-235,O,L,H,C)
                -0.000715850683503*PriceSeries(Price,index-236,O,L,H,C)
                -0.000719650938733*PriceSeries(Price,index-237,O,L,H,C)
                -0.000693542823360*PriceSeries(Price,index-238,O,L,H,C)
                -0.000639560527337*PriceSeries(Price,index-239,O,L,H,C)
                -0.000560833503450*PriceSeries(Price,index-240,O,L,H,C)
                -0.000461420919886*PriceSeries(Price,index-241,O,L,H,C)
                -0.000346112413064*PriceSeries(Price,index-242,O,L,H,C)
                -0.0002202045569357*PriceSeries(Price,index-243,O,L,H,C)
                -0.0000892633827104*PriceSeries(Price,index-244,O,L,H,C)
                +0.0000411165596942*PriceSeries(Price,index-245,O,L,H,C)
                +0.0001655465265337*PriceSeries(Price,index-246,O,L,H,C)
                +0.0002790617753660*PriceSeries(Price,index-247,O,L,H,C)
                +0.000377314858533*PriceSeries(Price,index-248,O,L,H,C)
                +0.000456736575102*PriceSeries(Price,index-249,O,L,H,C)
                +0.000514659002141*PriceSeries(Price,index-250,O,L,H,C)
                +0.000549396869615*PriceSeries(Price,index-251,O,L,H,C)
                +0.000560285171826*PriceSeries(Price,index-252,O,L,H,C)
                +0.000547672699671*PriceSeries(Price,index-253,O,L,H,C)
                +0.000512873275779*PriceSeries(Price,index-254,O,L,H,C)
                +0.000458078374258*PriceSeries(Price,index-255,O,L,H,C)
                +0.000386236108449*PriceSeries(Price,index-256,O,L,H,C)
                +0.0003009025856952*PriceSeries(Price,index-257,O,L,H,C)
                +0.0002060727429489*PriceSeries(Price,index-258,O,L,H,C)
                +0.0001059986752479*PriceSeries(Price,index-259,O,L,H,C)
                +0.00000500362393881*PriceSeries(Price,index-260,O,L,H,C)
                -0.0000927006154317*PriceSeries(Price,index-261,O,L,H,C)
                -0.0001831854842642*PriceSeries(Price,index-262,O,L,H,C)
                -0.0002629596479578*PriceSeries(Price,index-263,O,L,H,C)
                -0.000329099124649*PriceSeries(Price,index-264,O,L,H,C)
                -0.000379349051141*PriceSeries(Price,index-265,O,L,H,C)
                -0.000412194054088*PriceSeries(Price,index-266,O,L,H,C)
                -0.000426895301201*PriceSeries(Price,index-267,O,L,H,C)
                -0.000423493578977*PriceSeries(Price,index-268,O,L,H,C)
                -0.000402779489610*PriceSeries(Price,index-269,O,L,H,C)
                -0.000366233483648*PriceSeries(Price,index-270,O,L,H,C)
                -0.0003159393803318*PriceSeries(Price,index-271,O,L,H,C)
                -0.0002544756722440*PriceSeries(Price,index-272,O,L,H,C)
                -0.0001847898673854*PriceSeries(Price,index-273,O,L,H,C)
                -0.0001100620476865*PriceSeries(Price,index-274,O,L,H,C)
                -0.0000335639640251*PriceSeries(Price,index-275,O,L,H,C)
                +0.0000414804943840*PriceSeries(Price,index-276,O,L,H,C)
                +0.0001120278986717*PriceSeries(Price,index-277,O,L,H,C)
                +0.0001753354292592*PriceSeries(Price,index-278,O,L,H,C)
                +0.0002290636761835*PriceSeries(Price,index-279,O,L,H,C)
                +0.0002713585653559*PriceSeries(Price,index-280,O,L,H,C)
                +0.0003009101244227*PriceSeries(Price,index-281,O,L,H,C)
                +0.000316986438748*PriceSeries(Price,index-282,O,L,H,C)
                +0.000319441924104*PriceSeries(Price,index-283,O,L,H,C)
                +0.0003087005338015*PriceSeries(Price,index-284,O,L,H,C)
                +0.0002857159900890*PriceSeries(Price,index-285,O,L,H,C)
                +0.0002519117244839*PriceSeries(Price,index-286,O,L,H,C)
                +0.0002091034314588*PriceSeries(Price,index-287,O,L,H,C)
                +0.0001594079442622*PriceSeries(Price,index-288,O,L,H,C)
                +0.0001051431746018*PriceSeries(Price,index-289,O,L,H,C)
                +0.0000487239893747*PriceSeries(Price,index-290,O,L,H,C)
                -0.00000744177650413*PriceSeries(Price,index-291,O,L,H,C)
                -0.0000610532360988*PriceSeries(Price,index-292,O,L,H,C)
                -0.0001100080195477*PriceSeries(Price,index-293,O,L,H,C)
                -0.0001524814909447*PriceSeries(Price,index-294,O,L,H,C)
                -0.0001869909396402*PriceSeries(Price,index-295,O,L,H,C)
                -0.0002124432317573*PriceSeries(Price,index-296,O,L,H,C)
                -0.0002281645702113*PriceSeries(Price,index-297,O,L,H,C)
                -0.0002339112347234*PriceSeries(Price,index-298,O,L,H,C)
                -0.0002298615173442*PriceSeries(Price,index-299,O,L,H,C)
                -0.0002165905928458*PriceSeries(Price,index-300,O,L,H,C)
                -0.0001950303555206*PriceSeries(Price,index-301,O,L,H,C)
                -0.0001664159315521*PriceSeries(Price,index-302,O,L,H,C)
                -0.0001322212446314*PriceSeries(Price,index-303,O,L,H,C)
                -0.0000940873527600*PriceSeries(Price,index-304,O,L,H,C)
                -0.0000537474652739*PriceSeries(Price,index-305,O,L,H,C)
                -0.00001295148646836*PriceSeries(Price,index-306,O,L,H,C)
                +0.00002660745961845*PriceSeries(Price,index-307,O,L,H,C)
                +0.0000633612127298*PriceSeries(Price,index-308,O,L,H,C)
                +0.0000959259672356*PriceSeries(Price,index-309,O,L,H,C)
                +0.0001231508926659*PriceSeries(Price,index-310,O,L,H,C)
                +0.0001441553942088*PriceSeries(Price,index-311,O,L,H,C)
                +0.0001583540586485*PriceSeries(Price,index-312,O,L,H,C)
                +0.0001654677776382*PriceSeries(Price,index-313,O,L,H,C)
                +0.0001655208753206*PriceSeries(Price,index-314,O,L,H,C)
                +0.0001588260475365*PriceSeries(Price,index-315,O,L,H,C)
                +0.0001459589432615*PriceSeries(Price,index-316,O,L,H,C)
                +0.0001277229672481*PriceSeries(Price,index-317,O,L,H,C)
                +0.0001051053224240*PriceSeries(Price,index-318,O,L,H,C)
                +0.0000792273934972*PriceSeries(Price,index-319,O,L,H,C)
                +0.0000512930263318*PriceSeries(Price,index-320,O,L,H,C)
                +0.00002253632185951*PriceSeries(Price,index-321,O,L,H,C)
                -0.00000583035516681*PriceSeries(Price,index-322,O,L,H,C)
                -0.0000326656687915*PriceSeries(Price,index-323,O,L,H,C)
                -0.0000569422591776*PriceSeries(Price,index-324,O,L,H,C)
                -0.0000777818239919*PriceSeries(Price,index-325,O,L,H,C)
                -0.0000944831895888*PriceSeries(Price,index-326,O,L,H,C)
                -0.0001065430975867*PriceSeries(Price,index-327,O,L,H,C)
                -0.0001136671982030*PriceSeries(Price,index-328,O,L,H,C)
                -0.0001157701779926*PriceSeries(Price,index-329,O,L,H,C)
                -0.0001129675564844*PriceSeries(Price,index-330,O,L,H,C)
                -0.0001055616838321*PriceSeries(Price,index-331,O,L,H,C)
                -0.0000940210242854*PriceSeries(Price,index-332,O,L,H,C)
                -0.0000789514746079*PriceSeries(Price,index-333,O,L,H,C)
                -0.0000610627646825*PriceSeries(Price,index-334,O,L,H,C)
                -0.0000411348371995*PriceSeries(Price,index-335,O,L,H,C)
                -0.00001998485017396*PriceSeries(Price,index-336,O,L,H,C)
                +0.000001567766862945*PriceSeries(Price,index-337,O,L,H,C)
                +0.00002273676179628*PriceSeries(Price,index-338,O,L,H,C)
                +0.0000427989010017*PriceSeries(Price,index-339,O,L,H,C)
                +0.0000611158090619*PriceSeries(Price,index-340,O,L,H,C)
                +0.0000771524032779*PriceSeries(Price,index-341,O,L,H,C)
                +0.0000904945772478*PriceSeries(Price,index-342,O,L,H,C)
                +0.0001008603437627*PriceSeries(Price,index-343,O,L,H,C)
                +0.0001080990075605*PriceSeries(Price,index-344,O,L,H,C)
                +0.0001121839093008*PriceSeries(Price,index-345,O,L,H,C)
                +0.0001132078170937*PriceSeries(Price,index-346,O,L,H,C)
                +0.0001113779531815*PriceSeries(Price,index-347,O,L,H,C)
                +0.0001069994282821*PriceSeries(Price,index-348,O,L,H,C)
                +0.0001004486399608*PriceSeries(Price,index-349,O,L,H,C)
                +0.0000921537434598*PriceSeries(Price,index-350,O,L,H,C)
                +0.0000825887012992*PriceSeries(Price,index-351,O,L,H,C)
                +0.0000722621426637*PriceSeries(Price,index-352,O,L,H,C)
                +0.0000616848781806*PriceSeries(Price,index-353,O,L,H,C)
                +0.0000513356775976*PriceSeries(Price,index-354,O,L,H,C)
                +0.0000416614175100*PriceSeries(Price,index-355,O,L,H,C)
                +0.0000331106103208*PriceSeries(Price,index-356,O,L,H,C)
                +0.00002615654616163*PriceSeries(Price,index-357,O,L,H,C)
                +0.00002127436527489*PriceSeries(Price,index-358,O,L,H,C)
                +0.00001820732345552*PriceSeries(Price,index-359,O,L,H,C)
                -0.0001060957138391*PriceSeries(Price,index-360,O,L,H,C)
                );

      case N34:
         return(
                0.1265189681734*PriceSeries(Price,index,O,L,H,C)
                +0.1248546140415*PriceSeries(Price,index-1,O,L,H,C)
                +0.1215654608327*PriceSeries(Price,index-2,O,L,H,C)
                +0.1167294942823*PriceSeries(Price,index-3,O,L,H,C)
                +0.1104609207032*PriceSeries(Price,index-4,O,L,H,C)
                +0.1029069346480*PriceSeries(Price,index-5,O,L,H,C)
                +0.0942435686712*PriceSeries(Price,index-6,O,L,H,C)
                +0.0846707492178*PriceSeries(Price,index-7,O,L,H,C)
                +0.0744067174729*PriceSeries(Price,index-8,O,L,H,C)
                +0.0636819764311*PriceSeries(Price,index-9,O,L,H,C)
                +0.0527329606607*PriceSeries(Price,index-10,O,L,H,C)
                +0.0417956103091*PriceSeries(Price,index-11,O,L,H,C)
                +0.03109905226554*PriceSeries(Price,index-12,O,L,H,C)
                +0.02085956685679*PriceSeries(Price,index-13,O,L,H,C)
                +0.01127503135358*PriceSeries(Price,index-14,O,L,H,C)
                +0.002519985016828*PriceSeries(Price,index-15,O,L,H,C)
                -0.00525852766623*PriceSeries(Price,index-16,O,L,H,C)
                -0.01194423780681*PriceSeries(Price,index-17,O,L,H,C)
                -0.01745395579550*PriceSeries(Price,index-18,O,L,H,C)
                -0.02173886461944*PriceSeries(Price,index-19,O,L,H,C)
                -0.02478475897100*PriceSeries(Price,index-20,O,L,H,C)
                -0.02661126881560*PriceSeries(Price,index-21,O,L,H,C)
                -0.02727008791802*PriceSeries(Price,index-22,O,L,H,C)
                -0.02684230697319*PriceSeries(Price,index-23,O,L,H,C)
                -0.02543492917849*PriceSeries(Price,index-24,O,L,H,C)
                -0.02317672337445*PriceSeries(Price,index-25,O,L,H,C)
                -0.02021353045972*PriceSeries(Price,index-26,O,L,H,C)
                -0.01670321241565*PriceSeries(Price,index-27,O,L,H,C)
                -0.01281038525254*PriceSeries(Price,index-28,O,L,H,C)
                -0.00870113427515*PriceSeries(Price,index-29,O,L,H,C)
                -0.00453785092434*PriceSeries(Price,index-30,O,L,H,C)
                -0.000474383817384*PriceSeries(Price,index-31,O,L,H,C)
                +0.00334838228732*PriceSeries(Price,index-32,O,L,H,C)
                +0.00680635885828*PriceSeries(Price,index-33,O,L,H,C)
                +0.00979542191367*PriceSeries(Price,index-34,O,L,H,C)
                +0.01223380080102*PriceSeries(Price,index-35,O,L,H,C)
                +0.01406367034215*PriceSeries(Price,index-36,O,L,H,C)
                +0.01525188058161*PriceSeries(Price,index-37,O,L,H,C)
                +0.01578986569172*PriceSeries(Price,index-38,O,L,H,C)
                +0.01569272536987*PriceSeries(Price,index-39,O,L,H,C)
                +0.01499757279610*PriceSeries(Price,index-40,O,L,H,C)
                +0.01376119022327*PriceSeries(Price,index-41,O,L,H,C)
                +0.01205713431160*PriceSeries(Price,index-42,O,L,H,C)
                +0.00997236838544*PriceSeries(Price,index-43,O,L,H,C)
                +0.00760358824278*PriceSeries(Price,index-44,O,L,H,C)
                +0.00505334287866*PriceSeries(Price,index-45,O,L,H,C)
                +0.002426125604236*PriceSeries(Price,index-46,O,L,H,C)
                -0.0001754665433309*PriceSeries(Price,index-47,O,L,H,C)
                -0.002654335987236*PriceSeries(Price,index-48,O,L,H,C)
                -0.00492217029323*PriceSeries(Price,index-49,O,L,H,C)
                -0.00690227105075*PriceSeries(Price,index-50,O,L,H,C)
                -0.00853187890203*PriceSeries(Price,index-51,O,L,H,C)
                -0.00976389051298*PriceSeries(Price,index-52,O,L,H,C)
                -0.01056796956383*PriceSeries(Price,index-53,O,L,H,C)
                -0.01093099157383*PriceSeries(Price,index-54,O,L,H,C)
                -0.01085686847281*PriceSeries(Price,index-55,O,L,H,C)
                -0.01036574229482*PriceSeries(Price,index-56,O,L,H,C)
                -0.00949263723251*PriceSeries(Price,index-57,O,L,H,C)
                -0.00828559634405*PriceSeries(Price,index-58,O,L,H,C)
                -0.00680342673499*PriceSeries(Price,index-59,O,L,H,C)
                -0.00511311224822*PriceSeries(Price,index-60,O,L,H,C)
                -0.00328703085851*PriceSeries(Price,index-61,O,L,H,C)
                -0.001400053017032*PriceSeries(Price,index-62,O,L,H,C)
                +0.000473336224369*PriceSeries(Price,index-63,O,L,H,C)
                +0.002261820145116*PriceSeries(Price,index-64,O,L,H,C)
                +0.00389980762259*PriceSeries(Price,index-65,O,L,H,C)
                +0.00532970675931*PriceSeries(Price,index-66,O,L,H,C)
                +0.00650381140386*PriceSeries(Price,index-67,O,L,H,C)
                +0.00738577397439*PriceSeries(Price,index-68,O,L,H,C)
                +0.00795158935193*PriceSeries(Price,index-69,O,L,H,C)
                +0.00819010194042*PriceSeries(Price,index-70,O,L,H,C)
                +0.00810300079583*PriceSeries(Price,index-71,O,L,H,C)
                +0.00770434730788*PriceSeries(Price,index-72,O,L,H,C)
                +0.00701963833481*PriceSeries(Price,index-73,O,L,H,C)
                +0.00608448377796*PriceSeries(Price,index-74,O,L,H,C)
                +0.00494293043608*PriceSeries(Price,index-75,O,L,H,C)
                +0.00364553043276*PriceSeries(Price,index-76,O,L,H,C)
                +0.002247213948000*PriceSeries(Price,index-77,O,L,H,C)
                +0.000805069583454*PriceSeries(Price,index-78,O,L,H,C)
                -0.000623899552784*PriceSeries(Price,index-79,O,L,H,C)
                -0.001984940685336*PriceSeries(Price,index-80,O,L,H,C)
                -0.00322757396506*PriceSeries(Price,index-81,O,L,H,C)
                -0.00430738813423*PriceSeries(Price,index-82,O,L,H,C)
                -0.00518755866759*PriceSeries(Price,index-83,O,L,H,C)
                -0.00584002667596*PriceSeries(Price,index-84,O,L,H,C)
                -0.00624631861536*PriceSeries(Price,index-85,O,L,H,C)
                -0.00639797014295*PriceSeries(Price,index-86,O,L,H,C)
                -0.00629656256889*PriceSeries(Price,index-87,O,L,H,C)
                -0.00595337061372*PriceSeries(Price,index-88,O,L,H,C)
                -0.00538865581217*PriceSeries(Price,index-89,O,L,H,C)
                -0.00463063074157*PriceSeries(Price,index-90,O,L,H,C)
                -0.00371415367650*PriceSeries(Price,index-91,O,L,H,C)
                -0.002679203336110*PriceSeries(Price,index-92,O,L,H,C)
                -0.001569199480641*PriceSeries(Price,index-93,O,L,H,C)
                -0.000429239853266*PriceSeries(Price,index-94,O,L,H,C)
                +0.000695680229093*PriceSeries(Price,index-95,O,L,H,C)
                +0.001762393989546*PriceSeries(Price,index-96,O,L,H,C)
                +0.002731175920076*PriceSeries(Price,index-97,O,L,H,C)
                +0.00356717290552*PriceSeries(Price,index-98,O,L,H,C)
                +0.00424161659278*PriceSeries(Price,index-99,O,L,H,C)
                +0.00473276420112*PriceSeries(Price,index-100,O,L,H,C)
                +0.00502654813885*PriceSeries(Price,index-101,O,L,H,C)
                +0.00511690976296*PriceSeries(Price,index-102,O,L,H,C)
                +0.00500582159618*PriceSeries(Price,index-103,O,L,H,C)
                +0.00470299375932*PriceSeries(Price,index-104,O,L,H,C)
                +0.00422529635664*PriceSeries(Price,index-105,O,L,H,C)
                +0.00359591676750*PriceSeries(Price,index-106,O,L,H,C)
                +0.002843300635164*PriceSeries(Price,index-107,O,L,H,C)
                +0.001999910585901*PriceSeries(Price,index-108,O,L,H,C)
                +0.001100873036003*PriceSeries(Price,index-109,O,L,H,C)
                +0.0001825450381385*PriceSeries(Price,index-110,O,L,H,C)
                -0.000718916829760*PriceSeries(Price,index-111,O,L,H,C)
                -0.001568955407625*PriceSeries(Price,index-112,O,L,H,C)
                -0.002335899971596*PriceSeries(Price,index-113,O,L,H,C)
                -0.002992125778338*PriceSeries(Price,index-114,O,L,H,C)
                -0.00351500921803*PriceSeries(Price,index-115,O,L,H,C)
                -0.00388768298520*PriceSeries(Price,index-116,O,L,H,C)
                -0.00409953417075*PriceSeries(Price,index-117,O,L,H,C)
                -0.00414646250503*PriceSeries(Price,index-118,O,L,H,C)
                -0.00403086485018*PriceSeries(Price,index-119,O,L,H,C)
                -0.00376138542319*PriceSeries(Price,index-120,O,L,H,C)
                -0.00335241465784*PriceSeries(Price,index-121,O,L,H,C)
                -0.002823392511879*PriceSeries(Price,index-122,O,L,H,C)
                -0.002197920733402*PriceSeries(Price,index-123,O,L,H,C)
                -0.001502751078394*PriceSeries(Price,index-124,O,L,H,C)
                -0.000766659081620*PriceSeries(Price,index-125,O,L,H,C)
                -0.00001928774885742*PriceSeries(Price,index-126,O,L,H,C)
                +0.000710033747070*PriceSeries(Price,index-127,O,L,H,C)
                +0.001393409682483*PriceSeries(Price,index-128,O,L,H,C)
                +0.002005435269857*PriceSeries(Price,index-129,O,L,H,C)
                +0.002524106991730*PriceSeries(Price,index-130,O,L,H,C)
                +0.002931604962669*PriceSeries(Price,index-131,O,L,H,C)
                +0.00321486745702*PriceSeries(Price,index-132,O,L,H,C)
                +0.00336599042067*PriceSeries(Price,index-133,O,L,H,C)
                +0.00338239505607*PriceSeries(Price,index-134,O,L,H,C)
                +0.00326680671727*PriceSeries(Price,index-135,O,L,H,C)
                +0.003027005554541*PriceSeries(Price,index-136,O,L,H,C)
                +0.002675409423472*PriceSeries(Price,index-137,O,L,H,C)
                +0.002228467494388*PriceSeries(Price,index-138,O,L,H,C)
                +0.001705929555309*PriceSeries(Price,index-139,O,L,H,C)
                +0.001129987870027*PriceSeries(Price,index-140,O,L,H,C)
                +0.000524365249045*PriceSeries(Price,index-141,O,L,H,C)
                -0.0000866560231695*PriceSeries(Price,index-142,O,L,H,C)
                -0.000679180540095*PriceSeries(Price,index-143,O,L,H,C)
                -0.001230629528066*PriceSeries(Price,index-144,O,L,H,C)
                -0.001720574158469*PriceSeries(Price,index-145,O,L,H,C)
                -0.002131490019036*PriceSeries(Price,index-146,O,L,H,C)
                -0.002449351894108*PriceSeries(Price,index-147,O,L,H,C)
                -0.002664106540293*PriceSeries(Price,index-148,O,L,H,C)
                -0.002769953044022*PriceSeries(Price,index-149,O,L,H,C)
                -0.002765474625424*PriceSeries(Price,index-150,O,L,H,C)
                -0.002653573743585*PriceSeries(Price,index-151,O,L,H,C)
                -0.002441264345961*PriceSeries(Price,index-152,O,L,H,C)
                -0.002139286544316*PriceSeries(Price,index-153,O,L,H,C)
                -0.001761605365792*PriceSeries(Price,index-154,O,L,H,C)
                -0.001324780889281*PriceSeries(Price,index-155,O,L,H,C)
                -0.000847266833403*PriceSeries(Price,index-156,O,L,H,C)
                -0.000348637512493*PriceSeries(Price,index-157,O,L,H,C)
                +0.0001511923208290*PriceSeries(Price,index-158,O,L,H,C)
                +0.000632759321418*PriceSeries(Price,index-159,O,L,H,C)
                +0.001077789858541*PriceSeries(Price,index-160,O,L,H,C)
                +0.001469889863650*PriceSeries(Price,index-161,O,L,H,C)
                +0.001795125832562*PriceSeries(Price,index-162,O,L,H,C)
                +0.002042517899951*PriceSeries(Price,index-163,O,L,H,C)
                +0.002204381836982*PriceSeries(Price,index-164,O,L,H,C)
                +0.002276556285519*PriceSeries(Price,index-165,O,L,H,C)
                +0.002258468249737*PriceSeries(Price,index-166,O,L,H,C)
                +0.002153074653920*PriceSeries(Price,index-167,O,L,H,C)
                +0.001966650145775*PriceSeries(Price,index-168,O,L,H,C)
                +0.001708468227692*PriceSeries(Price,index-169,O,L,H,C)
                +0.001390359811534*PriceSeries(Price,index-170,O,L,H,C)
                +0.001026191520721*PriceSeries(Price,index-171,O,L,H,C)
                +0.000631273072872*PriceSeries(Price,index-172,O,L,H,C)
                +0.0002217277603901*PriceSeries(Price,index-173,O,L,H,C)
                -0.0001861591547843*PriceSeries(Price,index-174,O,L,H,C)
                -0.000576575590176*PriceSeries(Price,index-175,O,L,H,C)
                -0.000934787924991*PriceSeries(Price,index-176,O,L,H,C)
                -0.001247685872097*PriceSeries(Price,index-177,O,L,H,C)
                -0.001504255283457*PriceSeries(Price,index-178,O,L,H,C)
                -0.001695948185115*PriceSeries(Price,index-179,O,L,H,C)
                -0.001816959573852*PriceSeries(Price,index-180,O,L,H,C)
                -0.001864378827473*PriceSeries(Price,index-181,O,L,H,C)
                -0.001838232953446*PriceSeries(Price,index-182,O,L,H,C)
                -0.001741407838190*PriceSeries(Price,index-183,O,L,H,C)
                -0.001579466861288*PriceSeries(Price,index-184,O,L,H,C)
                -0.001360362789225*PriceSeries(Price,index-185,O,L,H,C)
                -0.001094067725661*PriceSeries(Price,index-186,O,L,H,C)
                -0.000792136200905*PriceSeries(Price,index-187,O,L,H,C)
                -0.000467209591258*PriceSeries(Price,index-188,O,L,H,C)
                -0.0001325010042422*PriceSeries(Price,index-189,O,L,H,C)
                +0.0001987381075422*PriceSeries(Price,index-190,O,L,H,C)
                +0.000513730096405*PriceSeries(Price,index-191,O,L,H,C)
                +0.000800662935082*PriceSeries(Price,index-192,O,L,H,C)
                +0.001049117649972*PriceSeries(Price,index-193,O,L,H,C)
                +0.001250443733801*PriceSeries(Price,index-194,O,L,H,C)
                +0.001398047086618*PriceSeries(Price,index-195,O,L,H,C)
                +0.001487594397620*PriceSeries(Price,index-196,O,L,H,C)
                +0.001517121099481*PriceSeries(Price,index-197,O,L,H,C)
                +0.001487049521048*PriceSeries(Price,index-198,O,L,H,C)
                +0.001400106055252*PriceSeries(Price,index-199,O,L,H,C)
                +0.001261157444032*PriceSeries(Price,index-200,O,L,H,C)
                +0.001076962626598*PriceSeries(Price,index-201,O,L,H,C)
                +0.000855864398700*PriceSeries(Price,index-202,O,L,H,C)
                +0.000607414030655*PriceSeries(Price,index-203,O,L,H,C)
                +0.000341979534553*PriceSeries(Price,index-204,O,L,H,C)
                +0.0000703076402707*PriceSeries(Price,index-205,O,L,H,C)
                -0.0001968925049349*PriceSeries(Price,index-206,O,L,H,C)
                -0.000449377709659*PriceSeries(Price,index-207,O,L,H,C)
                -0.000677742243803*PriceSeries(Price,index-208,O,L,H,C)
                -0.000873778157131*PriceSeries(Price,index-209,O,L,H,C)
                -0.001030746939385*PriceSeries(Price,index-210,O,L,H,C)
                -0.001143614565509*PriceSeries(Price,index-211,O,L,H,C)
                -0.001209192239807*PriceSeries(Price,index-212,O,L,H,C)
                -0.001226219412571*PriceSeries(Price,index-213,O,L,H,C)
                -0.001195350347217*PriceSeries(Price,index-214,O,L,H,C)
                -0.001119087094441*PriceSeries(Price,index-215,O,L,H,C)
                -0.001001622831712*PriceSeries(Price,index-216,O,L,H,C)
                -0.000848639492037*PriceSeries(Price,index-217,O,L,H,C)
                -0.000667037668858*PriceSeries(Price,index-218,O,L,H,C)
                -0.000464646971265*PriceSeries(Price,index-219,O,L,H,C)
                -0.0002498792289021*PriceSeries(Price,index-220,O,L,H,C)
                -0.00003140354959487*PriceSeries(Price,index-221,O,L,H,C)
                +0.0001822157362411*PriceSeries(Price,index-222,O,L,H,C)
                +0.000382831291579*PriceSeries(Price,index-223,O,L,H,C)
                +0.000563038553751*PriceSeries(Price,index-224,O,L,H,C)
                +0.000716419447700*PriceSeries(Price,index-225,O,L,H,C)
                +0.000837788188643*PriceSeries(Price,index-226,O,L,H,C)
                +0.000923338162769*PriceSeries(Price,index-227,O,L,H,C)
                +0.000970767038535*PriceSeries(Price,index-228,O,L,H,C)
                +0.000979309820996*PriceSeries(Price,index-229,O,L,H,C)
                +0.000949739743900*PriceSeries(Price,index-230,O,L,H,C)
                +0.000884279468071*PriceSeries(Price,index-231,O,L,H,C)
                +0.000786485841440*PriceSeries(Price,index-232,O,L,H,C)
                +0.000661064442285*PriceSeries(Price,index-233,O,L,H,C)
                +0.000513661789048*PriceSeries(Price,index-234,O,L,H,C)
                +0.000350607193312*PriceSeries(Price,index-235,O,L,H,C)
                +0.0001786635923410*PriceSeries(Price,index-236,O,L,H,C)
                +0.00000473275014683*PriceSeries(Price,index-237,O,L,H,C)
                -0.0001643980661554*PriceSeries(Price,index-238,O,L,H,C)
                -0.000322335338600*PriceSeries(Price,index-239,O,L,H,C)
                -0.000463294860381*PriceSeries(Price,index-240,O,L,H,C)
                -0.000582334552271*PriceSeries(Price,index-241,O,L,H,C)
                -0.000675493782005*PriceSeries(Price,index-242,O,L,H,C)
                -0.000739943147180*PriceSeries(Price,index-243,O,L,H,C)
                -0.000774041339863*PriceSeries(Price,index-244,O,L,H,C)
                -0.000777379306754*PriceSeries(Price,index-245,O,L,H,C)
                -0.000750743654561*PriceSeries(Price,index-246,O,L,H,C)
                -0.000696066102705*PriceSeries(Price,index-247,O,L,H,C)
                -0.000616301363376*PriceSeries(Price,index-248,O,L,H,C)
                -0.000515288587186*PriceSeries(Price,index-249,O,L,H,C)
                -0.000397572361405*PriceSeries(Price,index-250,O,L,H,C)
                -0.0002682097873927*PriceSeries(Price,index-251,O,L,H,C)
                -0.0001325482921638*PriceSeries(Price,index-252,O,L,H,C)
                +0.00000397681724130*PriceSeries(Price,index-253,O,L,H,C)
                +0.0001360701536578*PriceSeries(Price,index-254,O,L,H,C)
                +0.0002587644177317*PriceSeries(Price,index-255,O,L,H,C)
                +0.000367618620746*PriceSeries(Price,index-256,O,L,H,C)
                +0.000458852323995*PriceSeries(Price,index-257,O,L,H,C)
                +0.000529498016082*PriceSeries(Price,index-258,O,L,H,C)
                +0.000577465606276*PriceSeries(Price,index-259,O,L,H,C)
                +0.000601614828618*PriceSeries(Price,index-260,O,L,H,C)
                +0.000601756021951*PriceSeries(Price,index-261,O,L,H,C)
                +0.000578639730605*PriceSeries(Price,index-262,O,L,H,C)
                +0.000533885286642*PriceSeries(Price,index-263,O,L,H,C)
                +0.000469899650847*PriceSeries(Price,index-264,O,L,H,C)
                +0.000389757942330*PriceSeries(Price,index-265,O,L,H,C)
                +0.0002970560924447*PriceSeries(Price,index-266,O,L,H,C)
                +0.0001957626939949*PriceSeries(Price,index-267,O,L,H,C)
                +0.0000900496733185*PriceSeries(Price,index-268,O,L,H,C)
                -0.00001587778761565*PriceSeries(Price,index-269,O,L,H,C)
                -0.0001179433501503*PriceSeries(Price,index-270,O,L,H,C)
                -0.0002123533078578*PriceSeries(Price,index-271,O,L,H,C)
                -0.0002957324958938*PriceSeries(Price,index-272,O,L,H,C)
                -0.000365250701687*PriceSeries(Price,index-273,O,L,H,C)
                -0.000418695943058*PriceSeries(Price,index-274,O,L,H,C)
                -0.000454559696203*PriceSeries(Price,index-275,O,L,H,C)
                -0.000472057243598*PriceSeries(Price,index-276,O,L,H,C)
                -0.000471141074343*PriceSeries(Price,index-277,O,L,H,C)
                -0.000452472920055*PriceSeries(Price,index-278,O,L,H,C)
                -0.000417380087858*PriceSeries(Price,index-279,O,L,H,C)
                -0.000367778187932*PriceSeries(Price,index-280,O,L,H,C)
                -0.0003060696490476*PriceSeries(Price,index-281,O,L,H,C)
                -0.0002350542763840*PriceSeries(Price,index-282,O,L,H,C)
                -0.0001577805530785*PriceSeries(Price,index-283,O,L,H,C)
                -0.0000774430390132*PriceSeries(Price,index-284,O,L,H,C)
                +0.000002763849561853*PriceSeries(Price,index-285,O,L,H,C)
                +0.0000797522421631*PriceSeries(Price,index-286,O,L,H,C)
                +0.0001506768242285*PriceSeries(Price,index-287,O,L,H,C)
                +0.0002130153424467*PriceSeries(Price,index-288,O,L,H,C)
                +0.0002646661821754*PriceSeries(Price,index-289,O,L,H,C)
                +0.0003040175225613*PriceSeries(Price,index-290,O,L,H,C)
                +0.000329981651005*PriceSeries(Price,index-291,O,L,H,C)
                +0.000342025853659*PriceSeries(Price,index-292,O,L,H,C)
                +0.000340174272658*PriceSeries(Price,index-293,O,L,H,C)
                +0.000324982271684*PriceSeries(Price,index-294,O,L,H,C)
                +0.0002974972124847*PriceSeries(Price,index-295,O,L,H,C)
                +0.0002591978631888*PriceSeries(Price,index-296,O,L,H,C)
                +0.0002119350425072*PriceSeries(Price,index-297,O,L,H,C)
                +0.0001578124134444*PriceSeries(Price,index-298,O,L,H,C)
                +0.0000991446691672*PriceSeries(Price,index-299,O,L,H,C)
                +0.0000383106436283*PriceSeries(Price,index-300,O,L,H,C)
                -0.00002229709723434*PriceSeries(Price,index-301,O,L,H,C)
                -0.0000804063198800*PriceSeries(Price,index-302,O,L,H,C)
                -0.0001338994185000*PriceSeries(Price,index-303,O,L,H,C)
                -0.0001809421449121*PriceSeries(Price,index-304,O,L,H,C)
                -0.0002200000764917*PriceSeries(Price,index-305,O,L,H,C)
                -0.0002499077075956*PriceSeries(Price,index-306,O,L,H,C)
                -0.0002698967988820*PriceSeries(Price,index-307,O,L,H,C)
                -0.0002796107061374*PriceSeries(Price,index-308,O,L,H,C)
                -0.0002790935288129*PriceSeries(Price,index-309,O,L,H,C)
                -0.0002687859964111*PriceSeries(Price,index-310,O,L,H,C)
                -0.0002494868939816*PriceSeries(Price,index-311,O,L,H,C)
                -0.0002223080670271*PriceSeries(Price,index-312,O,L,H,C)
                -0.0001886090643424*PriceSeries(Price,index-313,O,L,H,C)
                -0.0001499757645539*PriceSeries(Price,index-314,O,L,H,C)
                -0.0001080813080718*PriceSeries(Price,index-315,O,L,H,C)
                -0.0000646989030419*PriceSeries(Price,index-316,O,L,H,C)
                -0.00002155591364510*PriceSeries(Price,index-317,O,L,H,C)
                +0.00001965904262653*PriceSeries(Price,index-318,O,L,H,C)
                +0.0000574436737731*PriceSeries(Price,index-319,O,L,H,C)
                +0.0000904322373555*PriceSeries(Price,index-320,O,L,H,C)
                +0.0001175359497533*PriceSeries(Price,index-321,O,L,H,C)
                +0.0001379129544162*PriceSeries(Price,index-322,O,L,H,C)
                +0.0001510104503681*PriceSeries(Price,index-323,O,L,H,C)
                +0.0001565694211869*PriceSeries(Price,index-324,O,L,H,C)
                +0.0001546322480331*PriceSeries(Price,index-325,O,L,H,C)
                +0.0001455126853721*PriceSeries(Price,index-326,O,L,H,C)
                +0.0001297721655924*PriceSeries(Price,index-327,O,L,H,C)
                +0.0001082147171687*PriceSeries(Price,index-328,O,L,H,C)
                +0.0000818238429816*PriceSeries(Price,index-329,O,L,H,C)
                +0.0000516989409441*PriceSeries(Price,index-330,O,L,H,C)
                +0.00001908942581872*PriceSeries(Price,index-331,O,L,H,C)
                -0.00001477132641972*PriceSeries(Price,index-332,O,L,H,C)
                -0.0000486005248951*PriceSeries(Price,index-333,O,L,H,C)
                -0.0000812239750992*PriceSeries(Price,index-334,O,L,H,C)
                -0.0001114795835589*PriceSeries(Price,index-335,O,L,H,C)
                -0.0001384431538215*PriceSeries(Price,index-336,O,L,H,C)
                -0.0001612536304930*PriceSeries(Price,index-337,O,L,H,C)
                -0.0001792850150481*PriceSeries(Price,index-338,O,L,H,C)
                -0.0001920995755377*PriceSeries(Price,index-339,O,L,H,C)
                -0.0001994519330282*PriceSeries(Price,index-340,O,L,H,C)
                -0.0002012915671354*PriceSeries(Price,index-341,O,L,H,C)
                -0.0001977568079225*PriceSeries(Price,index-342,O,L,H,C)
                -0.0001892058682211*PriceSeries(Price,index-343,O,L,H,C)
                -0.0001760593538173*PriceSeries(Price,index-344,O,L,H,C)
                -0.0001589642478532*PriceSeries(Price,index-345,O,L,H,C)
                -0.0001386453601915*PriceSeries(Price,index-346,O,L,H,C)
                -0.0001158399740609*PriceSeries(Price,index-347,O,L,H,C)
                -0.0000914175545819*PriceSeries(Price,index-348,O,L,H,C)
                -0.0000661718559952*PriceSeries(Price,index-349,O,L,H,C)
                -0.0000409578491825*PriceSeries(Price,index-350,O,L,H,C)
                -0.00001639697455219*PriceSeries(Price,index-351,O,L,H,C)
                +0.00000665897892699*PriceSeries(Price,index-352,O,L,H,C)
                +0.00002779416123853*PriceSeries(Price,index-353,O,L,H,C)
                +0.0000464712607543*PriceSeries(Price,index-354,O,L,H,C)
                +0.0000623027545580*PriceSeries(Price,index-355,O,L,H,C)
                +0.0000750747915678*PriceSeries(Price,index-356,O,L,H,C)
                +0.0000846688458947*PriceSeries(Price,index-357,O,L,H,C)
                +0.0000911390764063*PriceSeries(Price,index-358,O,L,H,C)
                +0.0000943021137172*PriceSeries(Price,index-359,O,L,H,C)
                +0.0000949375579387*PriceSeries(Price,index-360,O,L,H,C)
                +0.0000927475406116*PriceSeries(Price,index-361,O,L,H,C)
                +0.0000883267100790*PriceSeries(Price,index-362,O,L,H,C)
                +0.0000821832498991*PriceSeries(Price,index-363,O,L,H,C)
                +0.0000745609436187*PriceSeries(Price,index-364,O,L,H,C)
                +0.0000658262527697*PriceSeries(Price,index-365,O,L,H,C)
                +0.0000564395607466*PriceSeries(Price,index-366,O,L,H,C)
                +0.0001402004076757*PriceSeries(Price,index-367,O,L,H,C)
                );

      case N35:
         return(
                0.1220902276085*PriceSeries(Price,index,O,L,H,C)
                +0.1205833161488*PriceSeries(Price,index-1,O,L,H,C)
                +0.1176030892704*PriceSeries(Price,index-2,O,L,H,C)
                +0.1132158439484*PriceSeries(Price,index-3,O,L,H,C)
                +0.1075188121159*PriceSeries(Price,index-4,O,L,H,C)
                +0.1006375851251*PriceSeries(Price,index-5,O,L,H,C)
                +0.0927227846933*PriceSeries(Price,index-6,O,L,H,C)
                +0.0839460968877*PriceSeries(Price,index-7,O,L,H,C)
                +0.0744957702499*PriceSeries(Price,index-8,O,L,H,C)
                +0.0645717115493*PriceSeries(Price,index-9,O,L,H,C)
                +0.0543803226153*PriceSeries(Price,index-10,O,L,H,C)
                +0.0441292238742*PriceSeries(Price,index-11,O,L,H,C)
                +0.0340220064743*PriceSeries(Price,index-12,O,L,H,C)
                +0.02425318043015*PriceSeries(Price,index-13,O,L,H,C)
                +0.01500342984028*PriceSeries(Price,index-14,O,L,H,C)
                +0.00643533579235*PriceSeries(Price,index-15,O,L,H,C)
                -0.001310343139067*PriceSeries(Price,index-16,O,L,H,C)
                -0.00811771716071*PriceSeries(Price,index-17,O,L,H,C)
                -0.01389808001262*PriceSeries(Price,index-18,O,L,H,C)
                -0.01859141937887*PriceSeries(Price,index-19,O,L,H,C)
                -0.02216710840853*PriceSeries(Price,index-20,O,L,H,C)
                -0.02462376634896*PriceSeries(Price,index-21,O,L,H,C)
                -0.02598831609880*PriceSeries(Price,index-22,O,L,H,C)
                -0.02631426575473*PriceSeries(Price,index-23,O,L,H,C)
                -0.02567930840698*PriceSeries(Price,index-24,O,L,H,C)
                -0.02418228840384*PriceSeries(Price,index-25,O,L,H,C)
                -0.02193967454124*PriceSeries(Price,index-26,O,L,H,C)
                -0.01908162471250*PriceSeries(Price,index-27,O,L,H,C)
                -0.01574778733471*PriceSeries(Price,index-28,O,L,H,C)
                -0.01208295781740*PriceSeries(Price,index-29,O,L,H,C)
                -0.00823273508781*PriceSeries(Price,index-30,O,L,H,C)
                -0.00433928750781*PriceSeries(Price,index-31,O,L,H,C)
                -0.000537380210793*PriceSeries(Price,index-32,O,L,H,C)
                +0.003049256093608*PriceSeries(Price,index-33,O,L,H,C)
                +0.00631108271497*PriceSeries(Price,index-34,O,L,H,C)
                +0.00915539218181*PriceSeries(Price,index-35,O,L,H,C)
                +0.01150831783635*PriceSeries(Price,index-36,O,L,H,C)
                +0.01331621991907*PriceSeries(Price,index-37,O,L,H,C)
                +0.01454638310960*PriceSeries(Price,index-38,O,L,H,C)
                +0.01518705631625*PriceSeries(Price,index-39,O,L,H,C)
                +0.01524682956169*PriceSeries(Price,index-40,O,L,H,C)
                +0.01475341323383*PriceSeries(Price,index-41,O,L,H,C)
                +0.01375184370081*PriceSeries(Price,index-42,O,L,H,C)
                +0.01230223596963*PriceSeries(Price,index-43,O,L,H,C)
                +0.01047711443687*PriceSeries(Price,index-44,O,L,H,C)
                +0.00835847633334*PriceSeries(Price,index-45,O,L,H,C)
                +0.00603464079489*PriceSeries(Price,index-46,O,L,H,C)
                +0.00359703367790*PriceSeries(Price,index-47,O,L,H,C)
                +0.001136975606238*PriceSeries(Price,index-48,O,L,H,C)
                -0.001257384128124*PriceSeries(Price,index-49,O,L,H,C)
                -0.00350392851758*PriceSeries(Price,index-50,O,L,H,C)
                -0.00552911410762*PriceSeries(Price,index-51,O,L,H,C)
                -0.00727014409833*PriceSeries(Price,index-52,O,L,H,C)
                -0.00867668202918*PriceSeries(Price,index-53,O,L,H,C)
                -0.00971210781499*PriceSeries(Price,index-54,O,L,H,C)
                -0.01035423938191*PriceSeries(Price,index-55,O,L,H,C)
                -0.01059556298519*PriceSeries(Price,index-56,O,L,H,C)
                -0.01044293912436*PriceSeries(Price,index-57,O,L,H,C)
                -0.00991683984461*PriceSeries(Price,index-58,O,L,H,C)
                -0.00905013930409*PriceSeries(Price,index-59,O,L,H,C)
                -0.00788653047079*PriceSeries(Price,index-60,O,L,H,C)
                -0.00647860998614*PriceSeries(Price,index-61,O,L,H,C)
                -0.00488573870359*PriceSeries(Price,index-62,O,L,H,C)
                -0.00317172220067*PriceSeries(Price,index-63,O,L,H,C)
                -0.001402431833632*PriceSeries(Price,index-64,O,L,H,C)
                +0.000356587520939*PriceSeries(Price,index-65,O,L,H,C)
                +0.002042396367673*PriceSeries(Price,index-66,O,L,H,C)
                +0.00359679924482*PriceSeries(Price,index-67,O,L,H,C)
                +0.00496823246815*PriceSeries(Price,index-68,O,L,H,C)
                +0.00611337123676*PriceSeries(Price,index-69,O,L,H,C)
                +0.00699838891534*PriceSeries(Price,index-70,O,L,H,C)
                +0.00759985560275*PriceSeries(Price,index-71,O,L,H,C)
                +0.00790522770049*PriceSeries(Price,index-72,O,L,H,C)
                +0.00791296312354*PriceSeries(Price,index-73,O,L,H,C)
                +0.00763221980076*PriceSeries(Price,index-74,O,L,H,C)
                +0.00708221032921*PriceSeries(Price,index-75,O,L,H,C)
                +0.00629120266728*PriceSeries(Price,index-76,O,L,H,C)
                +0.00529524487062*PriceSeries(Price,index-77,O,L,H,C)
                +0.00413663991704*PriceSeries(Price,index-78,O,L,H,C)
                +0.002862256394403*PriceSeries(Price,index-79,O,L,H,C)
                +0.001521716705968*PriceSeries(Price,index-80,O,L,H,C)
                +0.0001655449207060*PriceSeries(Price,index-81,O,L,H,C)
                -0.001156667596314*PriceSeries(Price,index-82,O,L,H,C)
                -0.002398002192913*PriceSeries(Price,index-83,O,L,H,C)
                -0.00351582395295*PriceSeries(Price,index-84,O,L,H,C)
                -0.00447317859059*PriceSeries(Price,index-85,O,L,H,C)
                -0.00523996014146*PriceSeries(Price,index-86,O,L,H,C)
                -0.00579379579871*PriceSeries(Price,index-87,O,L,H,C)
                -0.00612062880987*PriceSeries(Price,index-88,O,L,H,C)
                -0.00621499477676*PriceSeries(Price,index-89,O,L,H,C)
                -0.00607997795595*PriceSeries(Price,index-90,O,L,H,C)
                -0.00572686373009*PriceSeries(Price,index-91,O,L,H,C)
                -0.00517451003242*PriceSeries(Price,index-92,O,L,H,C)
                -0.00444846055003*PriceSeries(Price,index-93,O,L,H,C)
                -0.00357984491192*PriceSeries(Price,index-94,O,L,H,C)
                -0.002604104094602*PriceSeries(Price,index-95,O,L,H,C)
                -0.001559602361109*PriceSeries(Price,index-96,O,L,H,C)
                -0.000486162414503*PriceSeries(Price,index-97,O,L,H,C)
                +0.000576410917490*PriceSeries(Price,index-98,O,L,H,C)
                +0.001589761679046*PriceSeries(Price,index-99,O,L,H,C)
                +0.002518333328041*PriceSeries(Price,index-100,O,L,H,C)
                +0.00333057827130*PriceSeries(Price,index-101,O,L,H,C)
                +0.00399999163580*PriceSeries(Price,index-102,O,L,H,C)
                +0.00450594310159*PriceSeries(Price,index-103,O,L,H,C)
                +0.00483426514553*PriceSeries(Price,index-104,O,L,H,C)
                +0.00497760210920*PriceSeries(Price,index-105,O,L,H,C)
                +0.00493550247690*PriceSeries(Price,index-106,O,L,H,C)
                +0.00471425631760*PriceSeries(Price,index-107,O,L,H,C)
                +0.00432649923555*PriceSeries(Price,index-108,O,L,H,C)
                +0.00379059095705*PriceSeries(Price,index-109,O,L,H,C)
                +0.003129810652927*PriceSeries(Price,index-110,O,L,H,C)
                +0.002371381867485*PriceSeries(Price,index-111,O,L,H,C)
                +0.001545394775346*PriceSeries(Price,index-112,O,L,H,C)
                +0.000683639848830*PriceSeries(Price,index-113,O,L,H,C)
                -0.0001815872215118*PriceSeries(Price,index-114,O,L,H,C)
                -0.001018670832897*PriceSeries(Price,index-115,O,L,H,C)
                -0.001797800176796*PriceSeries(Price,index-116,O,L,H,C)
                -0.002492015921447*PriceSeries(Price,index-117,O,L,H,C)
                -0.003078105948900*PriceSeries(Price,index-118,O,L,H,C)
                -0.00353737121352*PriceSeries(Price,index-119,O,L,H,C)
                -0.00385618122801*PriceSeries(Price,index-120,O,L,H,C)
                -0.00402635471432*PriceSeries(Price,index-121,O,L,H,C)
                -0.00404531649382*PriceSeries(Price,index-122,O,L,H,C)
                -0.00391606285873*PriceSeries(Price,index-123,O,L,H,C)
                -0.00364690921832*PriceSeries(Price,index-124,O,L,H,C)
                -0.00325106667370*PriceSeries(Price,index-125,O,L,H,C)
                -0.002746038296518*PriceSeries(Price,index-126,O,L,H,C)
                -0.002152884343965*PriceSeries(Price,index-127,O,L,H,C)
                -0.001495361172282*PriceSeries(Price,index-128,O,L,H,C)
                -0.000799006607929*PriceSeries(Price,index-129,O,L,H,C)
                -0.0000901538966823*PriceSeries(Price,index-130,O,L,H,C)
                +0.000605035869434*PriceSeries(Price,index-131,O,L,H,C)
                +0.001261527441793*PriceSeries(Price,index-132,O,L,H,C)
                +0.001856292908183*PriceSeries(Price,index-133,O,L,H,C)
                +0.002369103628161*PriceSeries(Price,index-134,O,L,H,C)
                +0.002783197524600*PriceSeries(Price,index-135,O,L,H,C)
                +0.003085814959193*PriceSeries(Price,index-136,O,L,H,C)
                +0.00326855803367*PriceSeries(Price,index-137,O,L,H,C)
                +0.00332760361726*PriceSeries(Price,index-138,O,L,H,C)
                +0.00326372428229*PriceSeries(Price,index-139,O,L,H,C)
                +0.003082163184965*PriceSeries(Price,index-140,O,L,H,C)
                +0.002792323599905*PriceSeries(Price,index-141,O,L,H,C)
                +0.002407343005285*PriceSeries(Price,index-142,O,L,H,C)
                +0.001943515138917*PriceSeries(Price,index-143,O,L,H,C)
                +0.001419627814597*PriceSeries(Price,index-144,O,L,H,C)
                +0.000856213430118*PriceSeries(Price,index-145,O,L,H,C)
                +0.0002747703912504*PriceSeries(Price,index-146,O,L,H,C)
                -0.0003030599943717*PriceSeries(Price,index-147,O,L,H,C)
                -0.000856266717029*PriceSeries(Price,index-148,O,L,H,C)
                -0.001365241413635*PriceSeries(Price,index-149,O,L,H,C)
                -0.001812440671445*PriceSeries(Price,index-150,O,L,H,C)
                -0.002182993028591*PriceSeries(Price,index-151,O,L,H,C)
                -0.002465167627903*PriceSeries(Price,index-152,O,L,H,C)
                -0.002650740229801*PriceSeries(Price,index-153,O,L,H,C)
                -0.002735198736377*PriceSeries(Price,index-154,O,L,H,C)
                -0.002717831865519*PriceSeries(Price,index-155,O,L,H,C)
                -0.002601657647229*PriceSeries(Price,index-156,O,L,H,C)
                -0.002393233586744*PriceSeries(Price,index-157,O,L,H,C)
                -0.002102323903232*PriceSeries(Price,index-158,O,L,H,C)
                -0.001741484218586*PriceSeries(Price,index-159,O,L,H,C)
                -0.001325520852420*PriceSeries(Price,index-160,O,L,H,C)
                -0.000870908990534*PriceSeries(Price,index-161,O,L,H,C)
                -0.000395147561567*PriceSeries(Price,index-162,O,L,H,C)
                +0.0000839024802177*PriceSeries(Price,index-163,O,L,H,C)
                +0.000548678758243*PriceSeries(Price,index-164,O,L,H,C)
                +0.000982551135029*PriceSeries(Price,index-165,O,L,H,C)
                +0.001370411593114*PriceSeries(Price,index-166,O,L,H,C)
                +0.001699180813898*PriceSeries(Price,index-167,O,L,H,C)
                +0.001958248078666*PriceSeries(Price,index-168,O,L,H,C)
                +0.002139793117338*PriceSeries(Price,index-169,O,L,H,C)
                +0.002239014884979*PriceSeries(Price,index-170,O,L,H,C)
                +0.002254224530897*PriceSeries(Price,index-171,O,L,H,C)
                +0.002186845865066*PriceSeries(Price,index-172,O,L,H,C)
                +0.002041281317055*PriceSeries(Price,index-173,O,L,H,C)
                +0.001824683966988*PriceSeries(Price,index-174,O,L,H,C)
                +0.001546630941710*PriceSeries(Price,index-175,O,L,H,C)
                +0.001218722396931*PriceSeries(Price,index-176,O,L,H,C)
                +0.000854096193110*PriceSeries(Price,index-177,O,L,H,C)
                +0.000466929195155*PriceSeries(Price,index-178,O,L,H,C)
                +0.0000718770930089*PriceSeries(Price,index-179,O,L,H,C)
                -0.000316456039921*PriceSeries(Price,index-180,O,L,H,C)
                -0.000684062252001*PriceSeries(Price,index-181,O,L,H,C)
                -0.001018021095061*PriceSeries(Price,index-182,O,L,H,C)
                -0.001306949637796*PriceSeries(Price,index-183,O,L,H,C)
                -0.001541376038976*PriceSeries(Price,index-184,O,L,H,C)
                -0.001714045426268*PriceSeries(Price,index-185,O,L,H,C)
                -0.001820131047403*PriceSeries(Price,index-186,O,L,H,C)
                -0.001857352076045*PriceSeries(Price,index-187,O,L,H,C)
                -0.001825993935314*PriceSeries(Price,index-188,O,L,H,C)
                -0.001728843724281*PriceSeries(Price,index-189,O,L,H,C)
                -0.001571018862654*PriceSeries(Price,index-190,O,L,H,C)
                -0.001359728105695*PriceSeries(Price,index-191,O,L,H,C)
                -0.001103964465718*PriceSeries(Price,index-192,O,L,H,C)
                -0.000814121363189*PriceSeries(Price,index-193,O,L,H,C)
                -0.000501591872865*PriceSeries(Price,index-194,O,L,H,C)
                -0.0001783168232945*PriceSeries(Price,index-195,O,L,H,C)
                +0.0001436563687176*PriceSeries(Price,index-196,O,L,H,C)
                +0.000452619435026*PriceSeries(Price,index-197,O,L,H,C)
                +0.000737622814274*PriceSeries(Price,index-198,O,L,H,C)
                +0.000988859724880*PriceSeries(Price,index-199,O,L,H,C)
                +0.001197992412937*PriceSeries(Price,index-200,O,L,H,C)
                +0.001358421835641*PriceSeries(Price,index-201,O,L,H,C)
                +0.001465487860675*PriceSeries(Price,index-202,O,L,H,C)
                +0.001516594687782*PriceSeries(Price,index-203,O,L,H,C)
                +0.001511246097206*PriceSeries(Price,index-204,O,L,H,C)
                +0.001451024396203*PriceSeries(Price,index-205,O,L,H,C)
                +0.001339473539430*PriceSeries(Price,index-206,O,L,H,C)
                +0.001181918434892*PriceSeries(Price,index-207,O,L,H,C)
                +0.000985236645025*PriceSeries(Price,index-208,O,L,H,C)
                +0.000757559431066*PriceSeries(Price,index-209,O,L,H,C)
                +0.000507949635243*PriceSeries(Price,index-210,O,L,H,C)
                +0.0002460454397445*PriceSeries(Price,index-211,O,L,H,C)
                -0.00001831040102167*PriceSeries(Price,index-212,O,L,H,C)
                -0.0002754257646060*PriceSeries(Price,index-213,O,L,H,C)
                -0.000516118146833*PriceSeries(Price,index-214,O,L,H,C)
                -0.000732030724603*PriceSeries(Price,index-215,O,L,H,C)
                -0.000915926919843*PriceSeries(Price,index-216,O,L,H,C)
                -0.001061911565687*PriceSeries(Price,index-217,O,L,H,C)
                -0.001165624736520*PriceSeries(Price,index-218,O,L,H,C)
                -0.001224357029554*PriceSeries(Price,index-219,O,L,H,C)
                -0.001237109249510*PriceSeries(Price,index-220,O,L,H,C)
                -0.001204577479920*PriceSeries(Price,index-221,O,L,H,C)
                -0.001129105089147*PriceSeries(Price,index-222,O,L,H,C)
                -0.001014523792219*PriceSeries(Price,index-223,O,L,H,C)
                -0.000866007735092*PriceSeries(Price,index-224,O,L,H,C)
                -0.000689822792225*PriceSeries(Price,index-225,O,L,H,C)
                -0.000493093560736*PriceSeries(Price,index-226,O,L,H,C)
                -0.0002835027211069*PriceSeries(Price,index-227,O,L,H,C)
                -0.0000690089678883*PriceSeries(Price,index-228,O,L,H,C)
                +0.0001424638083147*PriceSeries(Price,index-229,O,L,H,C)
                +0.000343298015604*PriceSeries(Price,index-230,O,L,H,C)
                +0.000526467857779*PriceSeries(Price,index-231,O,L,H,C)
                +0.000685770360635*PriceSeries(Price,index-232,O,L,H,C)
                +0.000816041908697*PriceSeries(Price,index-233,O,L,H,C)
                +0.000913298441714*PriceSeries(Price,index-234,O,L,H,C)
                +0.000974875650411*PriceSeries(Price,index-235,O,L,H,C)
                +0.000999471795868*PriceSeries(Price,index-236,O,L,H,C)
                +0.000987165687331*PriceSeries(Price,index-237,O,L,H,C)
                +0.000939383363404*PriceSeries(Price,index-238,O,L,H,C)
                +0.000858802109407*PriceSeries(Price,index-239,O,L,H,C)
                +0.000749220357972*PriceSeries(Price,index-240,O,L,H,C)
                +0.000615394393454*PriceSeries(Price,index-241,O,L,H,C)
                +0.000462828878601*PriceSeries(Price,index-242,O,L,H,C)
                +0.0002975732638820*PriceSeries(Price,index-243,O,L,H,C)
                +0.0001259671936433*PriceSeries(Price,index-244,O,L,H,C)
                -0.0000455833689446*PriceSeries(Price,index-245,O,L,H,C)
                -0.0002108570034973*PriceSeries(Price,index-246,O,L,H,C)
                -0.000364016929416*PriceSeries(Price,index-247,O,L,H,C)
                -0.000499835991194*PriceSeries(Price,index-248,O,L,H,C)
                -0.000613857912292*PriceSeries(Price,index-249,O,L,H,C)
                -0.000702544017605*PriceSeries(Price,index-250,O,L,H,C)
                -0.000763364325954*PriceSeries(Price,index-251,O,L,H,C)
                -0.000794891052930*PriceSeries(Price,index-252,O,L,H,C)
                -0.000796776273200*PriceSeries(Price,index-253,O,L,H,C)
                -0.000769782836159*PriceSeries(Price,index-254,O,L,H,C)
                -0.000715685702254*PriceSeries(Price,index-255,O,L,H,C)
                -0.000637208972297*PriceSeries(Price,index-256,O,L,H,C)
                -0.000537875170730*PriceSeries(Price,index-257,O,L,H,C)
                -0.000421872601216*PriceSeries(Price,index-258,O,L,H,C)
                -0.0002938704546723*PriceSeries(Price,index-259,O,L,H,C)
                -0.0001588524161592*PriceSeries(Price,index-260,O,L,H,C)
                -0.00002190687984999*PriceSeries(Price,index-261,O,L,H,C)
                +0.0001119489465888*PriceSeries(Price,index-262,O,L,H,C)
                +0.0002379585904964*PriceSeries(Price,index-263,O,L,H,C)
                +0.000351773515793*PriceSeries(Price,index-264,O,L,H,C)
                +0.000449628593139*PriceSeries(Price,index-265,O,L,H,C)
                +0.000528440827352*PriceSeries(Price,index-266,O,L,H,C)
                +0.000585901531444*PriceSeries(Price,index-267,O,L,H,C)
                +0.000620557022818*PriceSeries(Price,index-268,O,L,H,C)
                +0.000631811217139*PriceSeries(Price,index-269,O,L,H,C)
                +0.000619939539541*PriceSeries(Price,index-270,O,L,H,C)
                +0.000586049741852*PriceSeries(Price,index-271,O,L,H,C)
                +0.000532013531350*PriceSeries(Price,index-272,O,L,H,C)
                +0.000460383914844*PriceSeries(Price,index-273,O,L,H,C)
                +0.000374268154863*PriceSeries(Price,index-274,O,L,H,C)
                +0.0002772097916194*PriceSeries(Price,index-275,O,L,H,C)
                +0.0001730409939933*PriceSeries(Price,index-276,O,L,H,C)
                +0.0000657455150994*PriceSeries(Price,index-277,O,L,H,C)
                -0.0000407077720162*PriceSeries(Price,index-278,O,L,H,C)
                -0.0001425016580594*PriceSeries(Price,index-279,O,L,H,C)
                -0.0002360967802063*PriceSeries(Price,index-280,O,L,H,C)
                -0.000318354914414*PriceSeries(Price,index-281,O,L,H,C)
                -0.000386664597349*PriceSeries(Price,index-282,O,L,H,C)
                -0.000438971065934*PriceSeries(Price,index-283,O,L,H,C)
                -0.000473889004819*PriceSeries(Price,index-284,O,L,H,C)
                -0.000490687553736*PriceSeries(Price,index-285,O,L,H,C)
                -0.000489322273584*PriceSeries(Price,index-286,O,L,H,C)
                -0.000470403195551*PriceSeries(Price,index-287,O,L,H,C)
                -0.000435159257436*PriceSeries(Price,index-288,O,L,H,C)
                -0.000385373982477*PriceSeries(Price,index-289,O,L,H,C)
                -0.000323300735520*PriceSeries(Price,index-290,O,L,H,C)
                -0.0002515623029208*PriceSeries(Price,index-291,O,L,H,C)
                -0.0001730445962709*PriceSeries(Price,index-292,O,L,H,C)
                -0.0000907944069181*PriceSeries(Price,index-293,O,L,H,C)
                -0.00000789901977173*PriceSeries(Price,index-294,O,L,H,C)
                +0.0000726409485154*PriceSeries(Price,index-295,O,L,H,C)
                +0.0001480075326119*PriceSeries(Price,index-296,O,L,H,C)
                +0.0002156357659450*PriceSeries(Price,index-297,O,L,H,C)
                +0.0002733627132557*PriceSeries(Price,index-298,O,L,H,C)
                +0.000319416822132*PriceSeries(Price,index-299,O,L,H,C)
                +0.000352532006043*PriceSeries(Price,index-300,O,L,H,C)
                +0.000371936544867*PriceSeries(Price,index-301,O,L,H,C)
                +0.000377386720334*PriceSeries(Price,index-302,O,L,H,C)
                +0.000369142083979*PriceSeries(Price,index-303,O,L,H,C)
                +0.000347952741009*PriceSeries(Price,index-304,O,L,H,C)
                +0.0003150063873304*PriceSeries(Price,index-305,O,L,H,C)
                +0.0002718864681632*PriceSeries(Price,index-306,O,L,H,C)
                +0.0002204812253369*PriceSeries(Price,index-307,O,L,H,C)
                +0.0001629137165578*PriceSeries(Price,index-308,O,L,H,C)
                +0.0001014464489326*PriceSeries(Price,index-309,O,L,H,C)
                +0.0000384319418390*PriceSeries(Price,index-310,O,L,H,C)
                -0.00002381617767725*PriceSeries(Price,index-311,O,L,H,C)
                -0.0000831093890334*PriceSeries(Price,index-312,O,L,H,C)
                -0.0001373999643070*PriceSeries(Price,index-313,O,L,H,C)
                -0.0001849271344848*PriceSeries(Price,index-314,O,L,H,C)
                -0.0002242162378925*PriceSeries(Price,index-315,O,L,H,C)
                -0.0002541413342261*PriceSeries(Price,index-316,O,L,H,C)
                -0.0002739624845749*PriceSeries(Price,index-317,O,L,H,C)
                -0.0002833161781214*PriceSeries(Price,index-318,O,L,H,C)
                -0.0002822412068298*PriceSeries(Price,index-319,O,L,H,C)
                -0.0002711312169765*PriceSeries(Price,index-320,O,L,H,C)
                -0.0002507402863366*PriceSeries(Price,index-321,O,L,H,C)
                -0.0002221174946391*PriceSeries(Price,index-322,O,L,H,C)
                -0.0001865948891668*PriceSeries(Price,index-323,O,L,H,C)
                -0.0001456832909485*PriceSeries(Price,index-324,O,L,H,C)
                -0.0001010296538849*PriceSeries(Price,index-325,O,L,H,C)
                -0.0000543481879016*PriceSeries(Price,index-326,O,L,H,C)
                -0.00000742368308942*PriceSeries(Price,index-327,O,L,H,C)
                +0.0000381141615068*PriceSeries(Price,index-328,O,L,H,C)
                +0.0000806471417436*PriceSeries(Price,index-329,O,L,H,C)
                +0.0001187907180040*PriceSeries(Price,index-330,O,L,H,C)
                +0.0001513257094939*PriceSeries(Price,index-331,O,L,H,C)
                +0.0001773049078679*PriceSeries(Price,index-332,O,L,H,C)
                +0.0001960269670976*PriceSeries(Price,index-333,O,L,H,C)
                +0.0002070988584194*PriceSeries(Price,index-334,O,L,H,C)
                +0.0002103922221209*PriceSeries(Price,index-335,O,L,H,C)
                +0.0002060817274558*PriceSeries(Price,index-336,O,L,H,C)
                +0.0001945751107116*PriceSeries(Price,index-337,O,L,H,C)
                +0.0001765417303133*PriceSeries(Price,index-338,O,L,H,C)
                +0.0001528436288619*PriceSeries(Price,index-339,O,L,H,C)
                +0.0001245597961179*PriceSeries(Price,index-340,O,L,H,C)
                +0.0000928424570813*PriceSeries(Price,index-341,O,L,H,C)
                +0.0000588900248721*PriceSeries(Price,index-342,O,L,H,C)
                +0.00002404915743675*PriceSeries(Price,index-343,O,L,H,C)
                -0.00001046100847524*PriceSeries(Price,index-344,O,L,H,C)
                -0.0000434197989571*PriceSeries(Price,index-345,O,L,H,C)
                -0.0000737076731469*PriceSeries(Price,index-346,O,L,H,C)
                -0.0001003571622334*PriceSeries(Price,index-347,O,L,H,C)
                -0.0001225305600156*PriceSeries(Price,index-348,O,L,H,C)
                -0.0001396033377180*PriceSeries(Price,index-349,O,L,H,C)
                -0.0001511165309170*PriceSeries(Price,index-350,O,L,H,C)
                -0.0001568498319569*PriceSeries(Price,index-351,O,L,H,C)
                -0.0001567559286761*PriceSeries(Price,index-352,O,L,H,C)
                -0.0001510117220024*PriceSeries(Price,index-353,O,L,H,C)
                -0.0001399248294507*PriceSeries(Price,index-354,O,L,H,C)
                -0.0001239822395873*PriceSeries(Price,index-355,O,L,H,C)
                -0.0001038202288114*PriceSeries(Price,index-356,O,L,H,C)
                -0.0000803194307312*PriceSeries(Price,index-357,O,L,H,C)
                -0.0000540957888398*PriceSeries(Price,index-358,O,L,H,C)
                -0.00002617638378117*PriceSeries(Price,index-359,O,L,H,C)
                +0.000002627484371994*PriceSeries(Price,index-360,O,L,H,C)
                +0.00003141065729363*PriceSeries(Price,index-361,O,L,H,C)
                +0.0000593617383125*PriceSeries(Price,index-362,O,L,H,C)
                +0.0000856980167763*PriceSeries(Price,index-363,O,L,H,C)
                +0.0001097623668394*PriceSeries(Price,index-364,O,L,H,C)
                +0.0001309659395486*PriceSeries(Price,index-365,O,L,H,C)
                +0.0001488769936934*PriceSeries(Price,index-366,O,L,H,C)
                +0.0001631554708531*PriceSeries(Price,index-367,O,L,H,C)
                +0.0001736394884002*PriceSeries(Price,index-368,O,L,H,C)
                +0.0001802721583690*PriceSeries(Price,index-369,O,L,H,C)
                +0.0001831614321113*PriceSeries(Price,index-370,O,L,H,C)
                +0.0001824033684996*PriceSeries(Price,index-371,O,L,H,C)
                +0.0001779603298431*PriceSeries(Price,index-372,O,L,H,C)
                +0.0001709060192568*PriceSeries(Price,index-373,O,L,H,C)
                +0.0001611212568957*PriceSeries(Price,index-374,O,L,H,C)
                +0.0001492644227780*PriceSeries(Price,index-375,O,L,H,C)
                +0.0001358253807306*PriceSeries(Price,index-376,O,L,H,C)
                +0.0001213042455950*PriceSeries(Price,index-377,O,L,H,C)
                +0.0001062426486853*PriceSeries(Price,index-378,O,L,H,C)
                +0.0000911291042232*PriceSeries(Price,index-379,O,L,H,C)
                +0.0000764707800176*PriceSeries(Price,index-380,O,L,H,C)
                +0.0000627038863111*PriceSeries(Price,index-381,O,L,H,C)
                +0.0000502736960891*PriceSeries(Price,index-382,O,L,H,C)
                +0.0000395557014206*PriceSeries(Price,index-383,O,L,H,C)
                +0.00003094878231067*PriceSeries(Price,index-384,O,L,H,C)
                +0.00002481316417138*PriceSeries(Price,index-385,O,L,H,C)
                +0.00002158283497404*PriceSeries(Price,index-386,O,L,H,C)
                -0.0001086880712773*PriceSeries(Price,index-387,O,L,H,C)
                );

      case N36:
         return(
                0.1183849844402*PriceSeries(Price,index,O,L,H,C)
                +0.1170109363717*PriceSeries(Price,index-1,O,L,H,C)
                +0.1142916413132*PriceSeries(Price,index-2,O,L,H,C)
                +0.1102839805560*PriceSeries(Price,index-3,O,L,H,C)
                +0.1050714928232*PriceSeries(Price,index-4,O,L,H,C)
                +0.0987622899552*PriceSeries(Price,index-5,O,L,H,C)
                +0.0914863658681*PriceSeries(Price,index-6,O,L,H,C)
                +0.0833923744676*PriceSeries(Price,index-7,O,L,H,C)
                +0.0746439619770*PriceSeries(Price,index-8,O,L,H,C)
                +0.0654157541099*PriceSeries(Price,index-9,O,L,H,C)
                +0.0558891071335*PriceSeries(Price,index-10,O,L,H,C)
                +0.0462477334385*PriceSeries(Price,index-11,O,L,H,C)
                +0.0366733249938*PriceSeries(Price,index-12,O,L,H,C)
                +0.02734128022846*PriceSeries(Price,index-13,O,L,H,C)
                +0.01841666041024*PriceSeries(Price,index-14,O,L,H,C)
                +0.01005046253576*PriceSeries(Price,index-15,O,L,H,C)
                +0.002376324264448*PriceSeries(Price,index-16,O,L,H,C)
                -0.00449227971456*PriceSeries(Price,index-17,O,L,H,C)
                -0.01046425938311*PriceSeries(Price,index-18,O,L,H,C)
                -0.01547252078793*PriceSeries(Price,index-19,O,L,H,C)
                -0.01947491400429*PriceSeries(Price,index-20,O,L,H,C)
                -0.02245452130946*PriceSeries(Price,index-21,O,L,H,C)
                -0.02441927470844*PriceSeries(Price,index-22,O,L,H,C)
                -0.02540093911851*PriceSeries(Price,index-23,O,L,H,C)
                -0.02545348988034*PriceSeries(Price,index-24,O,L,H,C)
                -0.02465095238877*PriceSeries(Price,index-25,O,L,H,C)
                -0.02308476291812*PriceSeries(Price,index-26,O,L,H,C)
                -0.02086074731150*PriceSeries(Price,index-27,O,L,H,C)
                -0.01809579292784*PriceSeries(Price,index-28,O,L,H,C)
                -0.01491433339074*PriceSeries(Price,index-29,O,L,H,C)
                -0.01144472470508*PriceSeries(Price,index-30,O,L,H,C)
                -0.00781564298735*PriceSeries(Price,index-31,O,L,H,C)
                -0.00415257528489*PriceSeries(Price,index-32,O,L,H,C)
                -0.000574530534328*PriceSeries(Price,index-33,O,L,H,C)
                +0.002808974739137*PriceSeries(Price,index-34,O,L,H,C)
                +0.00590054480213*PriceSeries(Price,index-35,O,L,H,C)
                +0.00861711613678*PriceSeries(Price,index-36,O,L,H,C)
                +0.01089166832408*PriceSeries(Price,index-37,O,L,H,C)
                +0.01267443052687*PriceSeries(Price,index-38,O,L,H,C)
                +0.01393353379237*PriceSeries(Price,index-39,O,L,H,C)
                +0.01465513544496*PriceSeries(Price,index-40,O,L,H,C)
                +0.01484300028783*PriceSeries(Price,index-41,O,L,H,C)
                +0.01451759339277*PriceSeries(Price,index-42,O,L,H,C)
                +0.01371470202299*PriceSeries(Price,index-43,O,L,H,C)
                +0.01248366496903*PriceSeries(Price,index-44,O,L,H,C)
                +0.01088525152616*PriceSeries(Price,index-45,O,L,H,C)
                +0.00898928814291*PriceSeries(Price,index-46,O,L,H,C)
                +0.00687208655737*PriceSeries(Price,index-47,O,L,H,C)
                +0.00461378473650*PriceSeries(Price,index-48,O,L,H,C)
                +0.002295654119370*PriceSeries(Price,index-49,O,L,H,C)
                -0.000002511183952949*PriceSeries(Price,index-50,O,L,H,C)
                -0.002204882075730*PriceSeries(Price,index-51,O,L,H,C)
                -0.00424184741803*PriceSeries(Price,index-52,O,L,H,C)
                -0.00605201168928*PriceSeries(Price,index-53,O,L,H,C)
                -0.00758384207085*PriceSeries(Price,index-54,O,L,H,C)
                -0.00879696515837*PriceSeries(Price,index-55,O,L,H,C)
                -0.00966304640686*PriceSeries(Price,index-56,O,L,H,C)
                -0.01016627285026*PriceSeries(Price,index-57,O,L,H,C)
                -0.01030340456578*PriceSeries(Price,index-58,O,L,H,C)
                -0.01008343571278*PriceSeries(Price,index-59,O,L,H,C)
                -0.00952686251511*PriceSeries(Price,index-60,O,L,H,C)
                -0.00866461650390*PriceSeries(Price,index-61,O,L,H,C)
                -0.00753668592674*PriceSeries(Price,index-62,O,L,H,C)
                -0.00619050090350*PriceSeries(Price,index-63,O,L,H,C)
                -0.00467911733373*PriceSeries(Price,index-64,O,L,H,C)
                -0.003059290303794*PriceSeries(Price,index-65,O,L,H,C)
                -0.001389474019574*PriceSeries(Price,index-66,O,L,H,C)
                +0.0002721551651385*PriceSeries(Price,index-67,O,L,H,C)
                +0.001869620835254*PriceSeries(Price,index-68,O,L,H,C)
                +0.00335091975103*PriceSeries(Price,index-69,O,L,H,C)
                +0.00466962805605*PriceSeries(Price,index-70,O,L,H,C)
                +0.00578625747176*PriceSeries(Price,index-71,O,L,H,C)
                +0.00666935926135*PriceSeries(Price,index-72,O,L,H,C)
                +0.00729631440821*PriceSeries(Price,index-73,O,L,H,C)
                +0.00765382393730*PriceSeries(Price,index-74,O,L,H,C)
                +0.00773806262564*PriceSeries(Price,index-75,O,L,H,C)
                +0.00755452828119*PriceSeries(Price,index-76,O,L,H,C)
                +0.00711757469522*PriceSeries(Price,index-77,O,L,H,C)
                +0.00644967442900*PriceSeries(Price,index-78,O,L,H,C)
                +0.00558042505771*PriceSeries(Price,index-79,O,L,H,C)
                +0.00454535391783*PriceSeries(Price,index-80,O,L,H,C)
                +0.00338455259330*PriceSeries(Price,index-81,O,L,H,C)
                +0.002141204520426*PriceSeries(Price,index-82,O,L,H,C)
                +0.000860043618285*PriceSeries(Price,index-83,O,L,H,C)
                -0.000414189149458*PriceSeries(Price,index-84,O,L,H,C)
                -0.001638254660128*PriceSeries(Price,index-85,O,L,H,C)
                -0.002771824018540*PriceSeries(Price,index-86,O,L,H,C)
                -0.00377876232802*PriceSeries(Price,index-87,O,L,H,C)
                -0.00462822485568*PriceSeries(Price,index-88,O,L,H,C)
                -0.00529555943264*PriceSeries(Price,index-89,O,L,H,C)
                -0.00576296488528*PriceSeries(Price,index-90,O,L,H,C)
                -0.00601991291504*PriceSeries(Price,index-91,O,L,H,C)
                -0.00606330499357*PriceSeries(Price,index-92,O,L,H,C)
                -0.00589738352196*PriceSeries(Price,index-93,O,L,H,C)
                -0.00553339200899*PriceSeries(Price,index-94,O,L,H,C)
                -0.00498901212074*PriceSeries(Price,index-95,O,L,H,C)
                -0.00428759733938*PriceSeries(Price,index-96,O,L,H,C)
                -0.00345723396219*PriceSeries(Price,index-97,O,L,H,C)
                -0.002529668284127*PriceSeries(Price,index-98,O,L,H,C)
                -0.001539135903307*PriceSeries(Price,index-99,O,L,H,C)
                -0.000521137467925*PriceSeries(Price,index-100,O,L,H,C)
                +0.000488798218328*PriceSeries(Price,index-101,O,L,H,C)
                +0.001456320500486*PriceSeries(Price,index-102,O,L,H,C)
                +0.002349393476077*PriceSeries(Price,index-103,O,L,H,C)
                +0.003139327041545*PriceSeries(Price,index-104,O,L,H,C)
                +0.00380166687524*PriceSeries(Price,index-105,O,L,H,C)
                +0.00431692221825*PriceSeries(Price,index-106,O,L,H,C)
                +0.00467110486489*PriceSeries(Price,index-107,O,L,H,C)
                +0.00485607012377*PriceSeries(Price,index-108,O,L,H,C)
                +0.00486965076754*PriceSeries(Price,index-109,O,L,H,C)
                +0.00471558492091*PriceSeries(Price,index-110,O,L,H,C)
                +0.00440324565985*PriceSeries(Price,index-111,O,L,H,C)
                +0.00394718421082*PriceSeries(Price,index-112,O,L,H,C)
                +0.00336651192561*PriceSeries(Price,index-113,O,L,H,C)
                +0.002684135458602*PriceSeries(Price,index-114,O,L,H,C)
                +0.001925889948588*PriceSeries(Price,index-115,O,L,H,C)
                +0.001119583021608*PriceSeries(Price,index-116,O,L,H,C)
                +0.0002940048177654*PriceSeries(Price,index-117,O,L,H,C)
                -0.000522083181234*PriceSeries(Price,index-118,O,L,H,C)
                -0.001300922762309*PriceSeries(Price,index-119,O,L,H,C)
                -0.002016689075095*PriceSeries(Price,index-120,O,L,H,C)
                -0.002646321308795*PriceSeries(Price,index-121,O,L,H,C)
                -0.00317024977173*PriceSeries(Price,index-122,O,L,H,C)
                -0.00357297973671*PriceSeries(Price,index-123,O,L,H,C)
                -0.00384352845410*PriceSeries(Price,index-124,O,L,H,C)
                -0.00397569299412*PriceSeries(Price,index-125,O,L,H,C)
                -0.00396815470285*PriceSeries(Price,index-126,O,L,H,C)
                -0.00382440809266*PriceSeries(Price,index-127,O,L,H,C)
                -0.00355253404042*PriceSeries(Price,index-128,O,L,H,C)
                -0.00316481387020*PriceSeries(Price,index-129,O,L,H,C)
                -0.002677218513316*PriceSeries(Price,index-130,O,L,H,C)
                -0.002108770347580*PriceSeries(Price,index-131,O,L,H,C)
                -0.001480831640508*PriceSeries(Price,index-132,O,L,H,C)
                -0.000816310557226*PriceSeries(Price,index-133,O,L,H,C)
                -0.0001388515506139*PriceSeries(Price,index-134,O,L,H,C)
                +0.000528000075588*PriceSeries(Price,index-135,O,L,H,C)
                +0.001161592519601*PriceSeries(Price,index-136,O,L,H,C)
                +0.001740932666035*PriceSeries(Price,index-137,O,L,H,C)
                +0.002247357850802*PriceSeries(Price,index-138,O,L,H,C)
                +0.002665131350482*PriceSeries(Price,index-139,O,L,H,C)
                +0.002981908079983*PriceSeries(Price,index-140,O,L,H,C)
                +0.00318908783273*PriceSeries(Price,index-141,O,L,H,C)
                +0.00328201959221*PriceSeries(Price,index-142,O,L,H,C)
                +0.00326007919999*PriceSeries(Price,index-143,O,L,H,C)
                +0.003126593592156*PriceSeries(Price,index-144,O,L,H,C)
                +0.002888645293573*PriceSeries(Price,index-145,O,L,H,C)
                +0.002556739439677*PriceSeries(Price,index-146,O,L,H,C)
                +0.002144373754723*PriceSeries(Price,index-147,O,L,H,C)
                +0.001667501585915*PriceSeries(Price,index-148,O,L,H,C)
                +0.001143939308339*PriceSeries(Price,index-149,O,L,H,C)
                +0.000592703427561*PriceSeries(Price,index-150,O,L,H,C)
                +0.0000333426992934*PriceSeries(Price,index-151,O,L,H,C)
                -0.000514755316034*PriceSeries(Price,index-152,O,L,H,C)
                -0.001033014430981*PriceSeries(Price,index-153,O,L,H,C)
                -0.001504301241178*PriceSeries(Price,index-154,O,L,H,C)
                -0.001913468191075*PriceSeries(Price,index-155,O,L,H,C)
                -0.002247842117201*PriceSeries(Price,index-156,O,L,H,C)
                -0.002497592999179*PriceSeries(Price,index-157,O,L,H,C)
                -0.002656017949411*PriceSeries(Price,index-158,O,L,H,C)
                -0.002719694262357*PriceSeries(Price,index-159,O,L,H,C)
                -0.002688531740427*PriceSeries(Price,index-160,O,L,H,C)
                -0.002565695038433*PriceSeries(Price,index-161,O,L,H,C)
                -0.002357430107008*PriceSeries(Price,index-162,O,L,H,C)
                -0.002072775594474*PriceSeries(Price,index-163,O,L,H,C)
                -0.001723196478280*PriceSeries(Price,index-164,O,L,H,C)
                -0.001322130902115*PriceSeries(Price,index-165,O,L,H,C)
                -0.000884492751930*PriceSeries(Price,index-166,O,L,H,C)
                -0.000426117367578*PriceSeries(Price,index-167,O,L,H,C)
                +0.0000367916946543*PriceSeries(Price,index-168,O,L,H,C)
                +0.000488238460771*PriceSeries(Price,index-169,O,L,H,C)
                +0.000912968509442*PriceSeries(Price,index-170,O,L,H,C)
                +0.001296987435451*PriceSeries(Price,index-171,O,L,H,C)
                +0.001628002281660*PriceSeries(Price,index-172,O,L,H,C)
                +0.001895818186168*PriceSeries(Price,index-173,O,L,H,C)
                +0.002092630909241*PriceSeries(Price,index-174,O,L,H,C)
                +0.002213251781600*PriceSeries(Price,index-175,O,L,H,C)
                +0.002255220605862*PriceSeries(Price,index-176,O,L,H,C)
                +0.002218836197575*PriceSeries(Price,index-177,O,L,H,C)
                +0.002107079061013*PriceSeries(Price,index-178,O,L,H,C)
                +0.001925455804283*PriceSeries(Price,index-179,O,L,H,C)
                +0.001681748506017*PriceSeries(Price,index-180,O,L,H,C)
                +0.001385701091027*PriceSeries(Price,index-181,O,L,H,C)
                +0.001048638087961*PriceSeries(Price,index-182,O,L,H,C)
                +0.000683043380229*PriceSeries(Price,index-183,O,L,H,C)
                +0.0003021012296043*PriceSeries(Price,index-184,O,L,H,C)
                -0.0000807664350405*PriceSeries(Price,index-185,O,L,H,C)
                -0.000452373350172*PriceSeries(Price,index-186,O,L,H,C)
                -0.000800210086642*PriceSeries(Price,index-187,O,L,H,C)
                -0.001112865496937*PriceSeries(Price,index-188,O,L,H,C)
                -0.001380387137956*PriceSeries(Price,index-189,O,L,H,C)
                -0.001594599472326*PriceSeries(Price,index-190,O,L,H,C)
                -0.001749335617407*PriceSeries(Price,index-191,O,L,H,C)
                -0.001840613404009*PriceSeries(Price,index-192,O,L,H,C)
                -0.001866716662402*PriceSeries(Price,index-193,O,L,H,C)
                -0.001828207774287*PriceSeries(Price,index-194,O,L,H,C)
                -0.001727854705931*PriceSeries(Price,index-195,O,L,H,C)
                -0.001570488417144*PriceSeries(Price,index-196,O,L,H,C)
                -0.001362789117030*PriceSeries(Price,index-197,O,L,H,C)
                -0.001113015017025*PriceSeries(Price,index-198,O,L,H,C)
                -0.000830685090345*PriceSeries(Price,index-199,O,L,H,C)
                -0.000526220020163*PriceSeries(Price,index-200,O,L,H,C)
                -0.0002105666706872*PriceSeries(Price,index-201,O,L,H,C)
                +0.0001051910748113*PriceSeries(Price,index-202,O,L,H,C)
                +0.000410217385125*PriceSeries(Price,index-203,O,L,H,C)
                +0.000694289427553*PriceSeries(Price,index-204,O,L,H,C)
                +0.000948136384478*PriceSeries(Price,index-205,O,L,H,C)
                +0.001163735085313*PriceSeries(Price,index-206,O,L,H,C)
                +0.001334559586525*PriceSeries(Price,index-207,O,L,H,C)
                +0.001455767707528*PriceSeries(Price,index-208,O,L,H,C)
                +0.001524333373852*PriceSeries(Price,index-209,O,L,H,C)
                +0.001539106104708*PriceSeries(Price,index-210,O,L,H,C)
                +0.001500808110649*PriceSeries(Price,index-211,O,L,H,C)
                +0.001411968630475*PriceSeries(Price,index-212,O,L,H,C)
                +0.001276792450295*PriceSeries(Price,index-213,O,L,H,C)
                +0.001100980099976*PriceSeries(Price,index-214,O,L,H,C)
                +0.000891493759849*PriceSeries(Price,index-215,O,L,H,C)
                +0.000656294549198*PriceSeries(Price,index-216,O,L,H,C)
                +0.000404037493860*PriceSeries(Price,index-217,O,L,H,C)
                +0.0001437680078090*PriceSeries(Price,index-218,O,L,H,C)
                -0.0001154076337063*PriceSeries(Price,index-219,O,L,H,C)
                -0.000364628925496*PriceSeries(Price,index-220,O,L,H,C)
                -0.000595586031006*PriceSeries(Price,index-221,O,L,H,C)
                -0.000800786605184*PriceSeries(Price,index-222,O,L,H,C)
                -0.000973800545012*PriceSeries(Price,index-223,O,L,H,C)
                -0.001109449982009*PriceSeries(Price,index-224,O,L,H,C)
                -0.001203961944642*PriceSeries(Price,index-225,O,L,H,C)
                -0.001255063418150*PriceSeries(Price,index-226,O,L,H,C)
                -0.001262024510440*PriceSeries(Price,index-227,O,L,H,C)
                -0.001225645436474*PriceSeries(Price,index-228,O,L,H,C)
                -0.001148197410266*PriceSeries(Price,index-229,O,L,H,C)
                -0.001033302732490*PriceSeries(Price,index-230,O,L,H,C)
                -0.000885786302192*PriceSeries(Price,index-231,O,L,H,C)
                -0.000711472898488*PriceSeries(Price,index-232,O,L,H,C)
                -0.000516972983982*PriceSeries(Price,index-233,O,L,H,C)
                -0.0003094240741800*PriceSeries(Price,index-234,O,L,H,C)
                -0.0000962491731797*PriceSeries(Price,index-235,O,L,H,C)
                +0.0001151227593371*PriceSeries(Price,index-236,O,L,H,C)
                +0.000317495521686*PriceSeries(Price,index-237,O,L,H,C)
                +0.000504161019906*PriceSeries(Price,index-238,O,L,H,C)
                +0.000669105885460*PriceSeries(Price,index-239,O,L,H,C)
                +0.000807212881863*PriceSeries(Price,index-240,O,L,H,C)
                +0.000914402693896*PriceSeries(Price,index-241,O,L,H,C)
                +0.000987760043274*PriceSeries(Price,index-242,O,L,H,C)
                +0.001025596953629*PriceSeries(Price,index-243,O,L,H,C)
                +0.001027486227002*PriceSeries(Price,index-244,O,L,H,C)
                +0.000994240693572*PriceSeries(Price,index-245,O,L,H,C)
                +0.000927861416552*PriceSeries(Price,index-246,O,L,H,C)
                +0.000831430088543*PriceSeries(Price,index-247,O,L,H,C)
                +0.000708988212731*PriceSeries(Price,index-248,O,L,H,C)
                +0.000565362947385*PriceSeries(Price,index-249,O,L,H,C)
                +0.000405993262317*PriceSeries(Price,index-250,O,L,H,C)
                +0.0002367151029525*PriceSeries(Price,index-251,O,L,H,C)
                +0.0000635678810970*PriceSeries(Price,index-252,O,L,H,C)
                -0.0001074384902413*PriceSeries(Price,index-253,O,L,H,C)
                -0.0002705070194016*PriceSeries(Price,index-254,O,L,H,C)
                -0.000420267624568*PriceSeries(Price,index-255,O,L,H,C)
                -0.000551932853624*PriceSeries(Price,index-256,O,L,H,C)
                -0.000661463854227*PriceSeries(Price,index-257,O,L,H,C)
                -0.000745672918318*PriceSeries(Price,index-258,O,L,H,C)
                -0.000802328650923*PriceSeries(Price,index-259,O,L,H,C)
                -0.000830192857960*PriceSeries(Price,index-260,O,L,H,C)
                -0.000829048370947*PriceSeries(Price,index-261,O,L,H,C)
                -0.000799674147669*PriceSeries(Price,index-262,O,L,H,C)
                -0.000743797802559*PriceSeries(Price,index-263,O,L,H,C)
                -0.000664005133335*PriceSeries(Price,index-264,O,L,H,C)
                -0.000563639044585*PriceSeries(Price,index-265,O,L,H,C)
                -0.000446654254549*PriceSeries(Price,index-266,O,L,H,C)
                -0.000317476172144*PriceSeries(Price,index-267,O,L,H,C)
                -0.0001808265544379*PriceSeries(Price,index-268,O,L,H,C)
                -0.0000415671247389*PriceSeries(Price,index-269,O,L,H,C)
                +0.0000954894184279*PriceSeries(Price,index-270,O,L,H,C)
                +0.0002257196310761*PriceSeries(Price,index-271,O,L,H,C)
                +0.000344867108602*PriceSeries(Price,index-272,O,L,H,C)
                +0.000449156976507*PriceSeries(Price,index-273,O,L,H,C)
                +0.000535430596908*PriceSeries(Price,index-274,O,L,H,C)
                +0.000601220396435*PriceSeries(Price,index-275,O,L,H,C)
                +0.000644833724730*PriceSeries(Price,index-276,O,L,H,C)
                +0.000665372529732*PriceSeries(Price,index-277,O,L,H,C)
                +0.000662756642961*PriceSeries(Price,index-278,O,L,H,C)
                +0.000637697120520*PriceSeries(Price,index-279,O,L,H,C)
                +0.000591652702185*PriceSeries(Price,index-280,O,L,H,C)
                +0.000526758443414*PriceSeries(Price,index-281,O,L,H,C)
                +0.000445738190342*PriceSeries(Price,index-282,O,L,H,C)
                +0.000351788472618*PriceSeries(Price,index-283,O,L,H,C)
                +0.0002484629090430*PriceSeries(Price,index-284,O,L,H,C)
                +0.0001395360936340*PriceSeries(Price,index-285,O,L,H,C)
                +0.00002887259385388*PriceSeries(Price,index-286,O,L,H,C)
                -0.0000797160222172*PriceSeries(Price,index-287,O,L,H,C)
                -0.0001825849866712*PriceSeries(Price,index-288,O,L,H,C)
                -0.0002763967757216*PriceSeries(Price,index-289,O,L,H,C)
                -0.000358205991557*PriceSeries(Price,index-290,O,L,H,C)
                -0.000425566336017*PriceSeries(Price,index-291,O,L,H,C)
                -0.000476586190104*PriceSeries(Price,index-292,O,L,H,C)
                -0.000509992045824*PriceSeries(Price,index-293,O,L,H,C)
                -0.000525138281382*PriceSeries(Price,index-294,O,L,H,C)
                -0.000522027007091*PriceSeries(Price,index-295,O,L,H,C)
                -0.000501280221851*PriceSeries(Price,index-296,O,L,H,C)
                -0.000464100814896*PriceSeries(Price,index-297,O,L,H,C)
                -0.000412221694099*PriceSeries(Price,index-298,O,L,H,C)
                -0.000347823154314*PriceSeries(Price,index-299,O,L,H,C)
                -0.0002734505357927*PriceSeries(Price,index-300,O,L,H,C)
                -0.0001919133488825*PriceSeries(Price,index-301,O,L,H,C)
                -0.0001061868128741*PriceSeries(Price,index-302,O,L,H,C)
                -0.00001929677352559*PriceSeries(Price,index-303,O,L,H,C)
                +0.0000657769017629*PriceSeries(Price,index-304,O,L,H,C)
                +0.0001462018612441*PriceSeries(Price,index-305,O,L,H,C)
                +0.0002193941285482*PriceSeries(Price,index-306,O,L,H,C)
                +0.0002830838627659*PriceSeries(Price,index-307,O,L,H,C)
                +0.000335397774684*PriceSeries(Price,index-308,O,L,H,C)
                +0.000374901629800*PriceSeries(Price,index-309,O,L,H,C)
                +0.000400642815614*PriceSeries(Price,index-310,O,L,H,C)
                +0.000412159982275*PriceSeries(Price,index-311,O,L,H,C)
                +0.000409495487713*PriceSeries(Price,index-312,O,L,H,C)
                +0.000393169861977*PriceSeries(Price,index-313,O,L,H,C)
                +0.000364148704519*PriceSeries(Price,index-314,O,L,H,C)
                +0.000323810000985*PriceSeries(Price,index-315,O,L,H,C)
                +0.0002738628067962*PriceSeries(Price,index-316,O,L,H,C)
                +0.0002163005054441*PriceSeries(Price,index-317,O,L,H,C)
                +0.0001533062049942*PriceSeries(Price,index-318,O,L,H,C)
                +0.0000871896717036*PriceSeries(Price,index-319,O,L,H,C)
                +0.00002028235609530*PriceSeries(Price,index-320,O,L,H,C)
                -0.0000451148256571*PriceSeries(Price,index-321,O,L,H,C)
                -0.0001068350896608*PriceSeries(Price,index-322,O,L,H,C)
                -0.0001628997747181*PriceSeries(Price,index-323,O,L,H,C)
                -0.0002115816582203*PriceSeries(Price,index-324,O,L,H,C)
                -0.0002514608924855*PriceSeries(Price,index-325,O,L,H,C)
                -0.0002814603287506*PriceSeries(Price,index-326,O,L,H,C)
                -0.0003008688940458*PriceSeries(Price,index-327,O,L,H,C)
                -0.0003093569289077*PriceSeries(Price,index-328,O,L,H,C)
                -0.0003069782874224*PriceSeries(Price,index-329,O,L,H,C)
                -0.0002941477860053*PriceSeries(Price,index-330,O,L,H,C)
                -0.0002716191163920*PriceSeries(Price,index-331,O,L,H,C)
                -0.0002404604155535*PriceSeries(Price,index-332,O,L,H,C)
                -0.0002019772185789*PriceSeries(Price,index-333,O,L,H,C)
                -0.0001577006496715*PriceSeries(Price,index-334,O,L,H,C)
                -0.0001092887794274*PriceSeries(Price,index-335,O,L,H,C)
                -0.0000585015531565*PriceSeries(Price,index-336,O,L,H,C)
                -0.00000709938514258*PriceSeries(Price,index-337,O,L,H,C)
                +0.0000431673889229*PriceSeries(Price,index-338,O,L,H,C)
                +0.0000906745483505*PriceSeries(Price,index-339,O,L,H,C)
                +0.0001339229963801*PriceSeries(Price,index-340,O,L,H,C)
                +0.0001716180276798*PriceSeries(Price,index-341,O,L,H,C)
                +0.0002026941497298*PriceSeries(Price,index-342,O,L,H,C)
                +0.0002263468767537*PriceSeries(Price,index-343,O,L,H,C)
                +0.0002420439244569*PriceSeries(Price,index-344,O,L,H,C)
                +0.0002495474913964*PriceSeries(Price,index-345,O,L,H,C)
                +0.0002489035163229*PriceSeries(Price,index-346,O,L,H,C)
                +0.0002404263560749*PriceSeries(Price,index-347,O,L,H,C)
                +0.0002246914966606*PriceSeries(Price,index-348,O,L,H,C)
                +0.0002025050558925*PriceSeries(Price,index-349,O,L,H,C)
                +0.0001748436590337*PriceSeries(Price,index-350,O,L,H,C)
                +0.0001428674921390*PriceSeries(Price,index-351,O,L,H,C)
                +0.0001078117949925*PriceSeries(Price,index-352,O,L,H,C)
                +0.0000710015064921*PriceSeries(Price,index-353,O,L,H,C)
                +0.0000337489189398*PriceSeries(Price,index-354,O,L,H,C)
                -0.000002623465124550*PriceSeries(Price,index-355,O,L,H,C)
                -0.0000369152059578*PriceSeries(Price,index-356,O,L,H,C)
                -0.0000679825735105*PriceSeries(Price,index-357,O,L,H,C)
                -0.0000948615642805*PriceSeries(Price,index-358,O,L,H,C)
                -0.0001167410332696*PriceSeries(Price,index-359,O,L,H,C)
                -0.0001330041245747*PriceSeries(Price,index-360,O,L,H,C)
                -0.0001432325242165*PriceSeries(Price,index-361,O,L,H,C)
                -0.0001472312396209*PriceSeries(Price,index-362,O,L,H,C)
                -0.0001450063384088*PriceSeries(Price,index-363,O,L,H,C)
                -0.0001367600648276*PriceSeries(Price,index-364,O,L,H,C)
                -0.0001229071241868*PriceSeries(Price,index-365,O,L,H,C)
                -0.0001040084260968*PriceSeries(Price,index-366,O,L,H,C)
                -0.0000807684699292*PriceSeries(Price,index-367,O,L,H,C)
                -0.0000540374621895*PriceSeries(Price,index-368,O,L,H,C)
                -0.00002470189728700*PriceSeries(Price,index-369,O,L,H,C)
                +0.00000625674611624*PriceSeries(Price,index-370,O,L,H,C)
                +0.0000378760858718*PriceSeries(Price,index-371,O,L,H,C)
                +0.0000691614208433*PriceSeries(Price,index-372,O,L,H,C)
                +0.0000992369599433*PriceSeries(Price,index-373,O,L,H,C)
                +0.0001271959730590*PriceSeries(Price,index-374,O,L,H,C)
                +0.0001523247282672*PriceSeries(Price,index-375,O,L,H,C)
                +0.0001739605506756*PriceSeries(Price,index-376,O,L,H,C)
                +0.0001915877071569*PriceSeries(Price,index-377,O,L,H,C)
                +0.0002048327893210*PriceSeries(Price,index-378,O,L,H,C)
                +0.0002134732184119*PriceSeries(Price,index-379,O,L,H,C)
                +0.0002174176378898*PriceSeries(Price,index-380,O,L,H,C)
                +0.0002167107469810*PriceSeries(Price,index-381,O,L,H,C)
                +0.0002115914020951*PriceSeries(Price,index-382,O,L,H,C)
                +0.0002023152046302*PriceSeries(Price,index-383,O,L,H,C)
                +0.0001893384976912*PriceSeries(Price,index-384,O,L,H,C)
                +0.0001731740898243*PriceSeries(Price,index-385,O,L,H,C)
                +0.0001543540961885*PriceSeries(Price,index-386,O,L,H,C)
                +0.0001335295387816*PriceSeries(Price,index-387,O,L,H,C)
                +0.0001113168296078*PriceSeries(Price,index-388,O,L,H,C)
                +0.0000883799449782*PriceSeries(Price,index-389,O,L,H,C)
                +0.0000652586121841*PriceSeries(Price,index-390,O,L,H,C)
                +0.0000426890082855*PriceSeries(Price,index-391,O,L,H,C)
                +0.00002102973709488*PriceSeries(Price,index-392,O,L,H,C)
                +0.000000881175030520*PriceSeries(Price,index-393,O,L,H,C)
                -0.00001738500098468*PriceSeries(Price,index-394,O,L,H,C)
                -0.0000334815712166*PriceSeries(Price,index-395,O,L,H,C)
                -0.0000471600619647*PriceSeries(Price,index-396,O,L,H,C)
                -0.0000582520277263*PriceSeries(Price,index-397,O,L,H,C)
                -0.0000666854909220*PriceSeries(Price,index-398,O,L,H,C)
                -0.0000727185212208*PriceSeries(Price,index-399,O,L,H,C)
                -0.0000759667366714*PriceSeries(Price,index-400,O,L,H,C)
                -0.0000772027245056*PriceSeries(Price,index-401,O,L,H,C)
                -0.0000762322241233*PriceSeries(Price,index-402,O,L,H,C)
                -0.0000732799947453*PriceSeries(Price,index-403,O,L,H,C)
                -0.0000688187746822*PriceSeries(Price,index-404,O,L,H,C)
                -0.0000631684622813*PriceSeries(Price,index-405,O,L,H,C)
                -0.0000565967122034*PriceSeries(Price,index-406,O,L,H,C)
                -0.0000493724239747*PriceSeries(Price,index-407,O,L,H,C)
                -0.0001367357044827*PriceSeries(Price,index-408,O,L,H,C)
                );

      case N37:
         return(
                0.1086000148660*PriceSeries(Price,index,O,L,H,C)
                +0.1080068941643*PriceSeries(Price,index-1,O,L,H,C)
                +0.1062392236698*PriceSeries(Price,index-2,O,L,H,C)
                +0.1033318028012*PriceSeries(Price,index-3,O,L,H,C)
                +0.0993417205503*PriceSeries(Price,index-4,O,L,H,C)
                +0.0943470147792*PriceSeries(Price,index-5,O,L,H,C)
                +0.0884448433879*PriceSeries(Price,index-6,O,L,H,C)
                +0.0817492150695*PriceSeries(Price,index-7,O,L,H,C)
                +0.0743883366470*PriceSeries(Price,index-8,O,L,H,C)
                +0.0665016454862*PriceSeries(Price,index-9,O,L,H,C)
                +0.0582366020582*PriceSeries(Price,index-10,O,L,H,C)
                +0.0497453236566*PriceSeries(Price,index-11,O,L,H,C)
                +0.0411811449961*PriceSeries(Price,index-12,O,L,H,C)
                +0.0326951906375*PriceSeries(Price,index-13,O,L,H,C)
                +0.02443304508429*PriceSeries(Price,index-14,O,L,H,C)
                +0.01653160234396*PriceSeries(Price,index-15,O,L,H,C)
                +0.00911617105502*PriceSeries(Price,index-16,O,L,H,C)
                +0.002297905276588*PriceSeries(Price,index-17,O,L,H,C)
                -0.00382838021568*PriceSeries(Price,index-18,O,L,H,C)
                -0.00918596017911*PriceSeries(Price,index-19,O,L,H,C)
                -0.01371747711676*PriceSeries(Price,index-20,O,L,H,C)
                -0.01738572344612*PriceSeries(Price,index-21,O,L,H,C)
                -0.02017391524793*PriceSeries(Price,index-22,O,L,H,C)
                -0.02208546061324*PriceSeries(Price,index-23,O,L,H,C)
                -0.02314323727087*PriceSeries(Price,index-24,O,L,H,C)
                -0.02338840701393*PriceSeries(Price,index-25,O,L,H,C)
                -0.02287880743580*PriceSeries(Price,index-26,O,L,H,C)
                -0.02168697008379*PriceSeries(Price,index-27,O,L,H,C)
                -0.01989782492850*PriceSeries(Price,index-28,O,L,H,C)
                -0.01760615713485*PriceSeries(Price,index-29,O,L,H,C)
                -0.01491388734737*PriceSeries(Price,index-30,O,L,H,C)
                -0.01192725158484*PriceSeries(Price,index-31,O,L,H,C)
                -0.00875395595177*PriceSeries(Price,index-32,O,L,H,C)
                -0.00550038214874*PriceSeries(Price,index-33,O,L,H,C)
                -0.002268916177850*PriceSeries(Price,index-34,O,L,H,C)
                +0.000844532701842*PriceSeries(Price,index-35,O,L,H,C)
                +0.00375276060221*PriceSeries(Price,index-36,O,L,H,C)
                +0.00637919345229*PriceSeries(Price,index-37,O,L,H,C)
                +0.00865946350355*PriceSeries(Price,index-38,O,L,H,C)
                +0.01054260480809*PriceSeries(Price,index-39,O,L,H,C)
                +0.01199184671880*PriceSeries(Price,index-40,O,L,H,C)
                +0.01298499418622*PriceSeries(Price,index-41,O,L,H,C)
                +0.01351439738114*PriceSeries(Price,index-42,O,L,H,C)
                +0.01358652322522*PriceSeries(Price,index-43,O,L,H,C)
                +0.01322115190696*PriceSeries(Price,index-44,O,L,H,C)
                +0.01245023273690*PriceSeries(Price,index-45,O,L,H,C)
                +0.01131644044909*PriceSeries(Price,index-46,O,L,H,C)
                +0.00987148224997*PriceSeries(Price,index-47,O,L,H,C)
                +0.00817421065242*PriceSeries(Price,index-48,O,L,H,C)
                +0.00628860058058*PriceSeries(Price,index-49,O,L,H,C)
                +0.00428165335189*PriceSeries(Price,index-50,O,L,H,C)
                +0.002221288574928*PriceSeries(Price,index-51,O,L,H,C)
                +0.0001742852473288*PriceSeries(Price,index-52,O,L,H,C)
                -0.001795670268050*PriceSeries(Price,index-53,O,L,H,C)
                -0.00362977723464*PriceSeries(Price,index-54,O,L,H,C)
                -0.00527570628685*PriceSeries(Price,index-55,O,L,H,C)
                -0.00668893911295*PriceSeries(Price,index-56,O,L,H,C)
                -0.00783383028775*PriceSeries(Price,index-57,O,L,H,C)
                -0.00868436844356*PriceSeries(Price,index-58,O,L,H,C)
                -0.00922462454992*PriceSeries(Price,index-59,O,L,H,C)
                -0.00944888240032*PriceSeries(Price,index-60,O,L,H,C)
                -0.00936145795952*PriceSeries(Price,index-61,O,L,H,C)
                -0.00897622236483*PriceSeries(Price,index-62,O,L,H,C)
                -0.00831585120410*PriceSeries(Price,index-63,O,L,H,C)
                -0.00741083172387*PriceSeries(Price,index-64,O,L,H,C)
                -0.00629826381133*PriceSeries(Price,index-65,O,L,H,C)
                -0.00502049766426*PriceSeries(Price,index-66,O,L,H,C)
                -0.00362365420356*PriceSeries(Price,index-67,O,L,H,C)
                -0.002156075509676*PriceSeries(Price,index-68,O,L,H,C)
                -0.000666755308973*PriceSeries(Price,index-69,O,L,H,C)
                +0.000796203243721*PriceSeries(Price,index-70,O,L,H,C)
                +0.002187055766965*PriceSeries(Price,index-71,O,L,H,C)
                +0.00346376785378*PriceSeries(Price,index-72,O,L,H,C)
                +0.00458921241314*PriceSeries(Price,index-73,O,L,H,C)
                +0.00553217969972*PriceSeries(Price,index-74,O,L,H,C)
                +0.00626817510869*PriceSeries(Price,index-75,O,L,H,C)
                +0.00677998584580*PriceSeries(Price,index-76,O,L,H,C)
                +0.00705800493889*PriceSeries(Price,index-77,O,L,H,C)
                +0.00710031046156*PriceSeries(Price,index-78,O,L,H,C)
                +0.00691250294205*PriceSeries(Price,index-79,O,L,H,C)
                +0.00650731314562*PriceSeries(Price,index-80,O,L,H,C)
                +0.00590399861700*PriceSeries(Price,index-81,O,L,H,C)
                +0.00512755268720*PriceSeries(Price,index-82,O,L,H,C)
                +0.00420775670332*PriceSeries(Price,index-83,O,L,H,C)
                +0.00317810781791*PriceSeries(Price,index-84,O,L,H,C)
                +0.002074659417906*PriceSeries(Price,index-85,O,L,H,C)
                +0.000934812966273*PriceSeries(Price,index-86,O,L,H,C)
                -0.0002039007320004*PriceSeries(Price,index-87,O,L,H,C)
                -0.001305011353990*PriceSeries(Price,index-88,O,L,H,C)
                -0.002334234644392*PriceSeries(Price,index-89,O,L,H,C)
                -0.00326049984585*PriceSeries(Price,index-90,O,L,H,C)
                -0.00405684862910*PriceSeries(Price,index-91,O,L,H,C)
                -0.00470118178577*PriceSeries(Price,index-92,O,L,H,C)
                -0.00517683297538*PriceSeries(Price,index-93,O,L,H,C)
                -0.00547295670022*PriceSeries(Price,index-94,O,L,H,C)
                -0.00558472277003*PriceSeries(Price,index-95,O,L,H,C)
                -0.00551331506230*PriceSeries(Price,index-96,O,L,H,C)
                -0.00526574082041*PriceSeries(Price,index-97,O,L,H,C)
                -0.00485446002773*PriceSeries(Price,index-98,O,L,H,C)
                -0.00429685147552*PriceSeries(Price,index-99,O,L,H,C)
                -0.00361453646656*PriceSeries(Price,index-100,O,L,H,C)
                -0.002832583982886*PriceSeries(Price,index-101,O,L,H,C)
                -0.001978626762334*PriceSeries(Price,index-102,O,L,H,C)
                -0.001081917227090*PriceSeries(Price,index-103,O,L,H,C)
                -0.0001723547610685*PriceSeries(Price,index-104,O,L,H,C)
                +0.000720483720325*PriceSeries(Price,index-105,O,L,H,C)
                +0.001568280351193*PriceSeries(Price,index-106,O,L,H,C)
                +0.002344849680068*PriceSeries(Price,index-107,O,L,H,C)
                +0.003026923650906*PriceSeries(Price,index-108,O,L,H,C)
                +0.00359482538588*PriceSeries(Price,index-109,O,L,H,C)
                +0.00403301210378*PriceSeries(Price,index-110,O,L,H,C)
                +0.00433047419856*PriceSeries(Price,index-111,O,L,H,C)
                +0.00448097984761*PriceSeries(Price,index-112,O,L,H,C)
                +0.00448316180580*PriceSeries(Price,index-113,O,L,H,C)
                +0.00434044744784*PriceSeries(Price,index-114,O,L,H,C)
                +0.00406083664811*PriceSeries(Price,index-115,O,L,H,C)
                +0.00365653942922*PriceSeries(Price,index-116,O,L,H,C)
                +0.003143487034161*PriceSeries(Price,index-117,O,L,H,C)
                +0.002540735439476*PriceSeries(Price,index-118,O,L,H,C)
                +0.001869783161577*PriceSeries(Price,index-119,O,L,H,C)
                +0.001153825630799*PriceSeries(Price,index-120,O,L,H,C)
                +0.000416972888557*PriceSeries(Price,index-121,O,L,H,C)
                -0.000316544519420*PriceSeries(Price,index-122,O,L,H,C)
                -0.001023155712278*PriceSeries(Price,index-123,O,L,H,C)
                -0.001680690445691*PriceSeries(Price,index-124,O,L,H,C)
                -0.002269059537985*PriceSeries(Price,index-125,O,L,H,C)
                -0.002770852711527*PriceSeries(Price,index-126,O,L,H,C)
                -0.00317183731699*PriceSeries(Price,index-127,O,L,H,C)
                -0.00346134449849*PriceSeries(Price,index-128,O,L,H,C)
                -0.00363253196172*PriceSeries(Price,index-129,O,L,H,C)
                -0.00368251911440*PriceSeries(Price,index-130,O,L,H,C)
                -0.00361239152996*PriceSeries(Price,index-131,O,L,H,C)
                -0.00342707804263*PriceSeries(Price,index-132,O,L,H,C)
                -0.003135107839474*PriceSeries(Price,index-133,O,L,H,C)
                -0.002748256566328*PriceSeries(Price,index-134,O,L,H,C)
                -0.002281096644070*PriceSeries(Price,index-135,O,L,H,C)
                -0.001750467070414*PriceSeries(Price,index-136,O,L,H,C)
                -0.001174881870718*PriceSeries(Price,index-137,O,L,H,C)
                -0.000573898436257*PriceSeries(Price,index-138,O,L,H,C)
                +0.0000325348316818*PriceSeries(Price,index-139,O,L,H,C)
                +0.000624728745323*PriceSeries(Price,index-140,O,L,H,C)
                +0.001183881459665*PriceSeries(Price,index-141,O,L,H,C)
                +0.001692664757142*PriceSeries(Price,index-142,O,L,H,C)
                +0.002135749433043*PriceSeries(Price,index-143,O,L,H,C)
                +0.002500256091972*PriceSeries(Price,index-144,O,L,H,C)
                +0.002776116956634*PriceSeries(Price,index-145,O,L,H,C)
                +0.002956339437522*PriceSeries(Price,index-146,O,L,H,C)
                +0.003037165530208*PriceSeries(Price,index-147,O,L,H,C)
                +0.003018122872433*PriceSeries(Price,index-148,O,L,H,C)
                +0.002901970019077*PriceSeries(Price,index-149,O,L,H,C)
                +0.002694538431979*PriceSeries(Price,index-150,O,L,H,C)
                +0.002404478574783*PriceSeries(Price,index-151,O,L,H,C)
                +0.002042921263269*PriceSeries(Price,index-152,O,L,H,C)
                +0.001623065480751*PriceSeries(Price,index-153,O,L,H,C)
                +0.001159709250548*PriceSeries(Price,index-154,O,L,H,C)
                +0.000668738584311*PriceSeries(Price,index-155,O,L,H,C)
                +0.0001665917438401*PriceSeries(Price,index-156,O,L,H,C)
                -0.000330281986909*PriceSeries(Price,index-157,O,L,H,C)
                -0.000805953271286*PriceSeries(Price,index-158,O,L,H,C)
                -0.001245515050137*PriceSeries(Price,index-159,O,L,H,C)
                -0.001635541584620*PriceSeries(Price,index-160,O,L,H,C)
                -0.001964490668624*PriceSeries(Price,index-161,O,L,H,C)
                -0.002223035462313*PriceSeries(Price,index-162,O,L,H,C)
                -0.002404318768294*PriceSeries(Price,index-163,O,L,H,C)
                -0.002504121893466*PriceSeries(Price,index-164,O,L,H,C)
                -0.002520944853554*PriceSeries(Price,index-165,O,L,H,C)
                -0.002455997894464*PriceSeries(Price,index-166,O,L,H,C)
                -0.002313104561790*PriceSeries(Price,index-167,O,L,H,C)
                -0.002098523485223*PriceSeries(Price,index-168,O,L,H,C)
                -0.001820695174569*PriceSeries(Price,index-169,O,L,H,C)
                -0.001489923343404*PriceSeries(Price,index-170,O,L,H,C)
                -0.001118003560587*PriceSeries(Price,index-171,O,L,H,C)
                -0.000717810405265*PriceSeries(Price,index-172,O,L,H,C)
                -0.0003028594709289*PriceSeries(Price,index-173,O,L,H,C)
                +0.0001131420907969*PriceSeries(Price,index-174,O,L,H,C)
                +0.000516742497133*PriceSeries(Price,index-175,O,L,H,C)
                +0.000895173695963*PriceSeries(Price,index-176,O,L,H,C)
                +0.001236749685058*PriceSeries(Price,index-177,O,L,H,C)
                +0.001531220735855*PriceSeries(Price,index-178,O,L,H,C)
                +0.001770073706297*PriceSeries(Price,index-179,O,L,H,C)
                +0.001946770973494*PriceSeries(Price,index-180,O,L,H,C)
                +0.002056919327923*PriceSeries(Price,index-181,O,L,H,C)
                +0.002098366861704*PriceSeries(Price,index-182,O,L,H,C)
                +0.002071224931707*PriceSeries(Price,index-183,O,L,H,C)
                +0.001977816377287*PriceSeries(Price,index-184,O,L,H,C)
                +0.001822554630804*PriceSeries(Price,index-185,O,L,H,C)
                +0.001611756502320*PriceSeries(Price,index-186,O,L,H,C)
                +0.001353398163971*PriceSeries(Price,index-187,O,L,H,C)
                +0.001056822583317*PriceSeries(Price,index-188,O,L,H,C)
                +0.000732408511716*PriceSeries(Price,index-189,O,L,H,C)
                +0.000391214196737*PriceSeries(Price,index-190,O,L,H,C)
                +0.0000446052262970*PriceSeries(Price,index-191,O,L,H,C)
                -0.0002961189820029*PriceSeries(Price,index-192,O,L,H,C)
                -0.000620088311251*PriceSeries(Price,index-193,O,L,H,C)
                -0.000917204336333*PriceSeries(Price,index-194,O,L,H,C)
                -0.001178449398693*PriceSeries(Price,index-195,O,L,H,C)
                -0.001396155584516*PriceSeries(Price,index-196,O,L,H,C)
                -0.001564223759455*PriceSeries(Price,index-197,O,L,H,C)
                -0.001678286594665*PriceSeries(Price,index-198,O,L,H,C)
                -0.001735813340744*PriceSeries(Price,index-199,O,L,H,C)
                -0.001736151816563*PriceSeries(Price,index-200,O,L,H,C)
                -0.001680509847004*PriceSeries(Price,index-201,O,L,H,C)
                -0.001571876564377*PriceSeries(Price,index-202,O,L,H,C)
                -0.001414887062673*PriceSeries(Price,index-203,O,L,H,C)
                -0.001215638360813*PriceSeries(Price,index-204,O,L,H,C)
                -0.000981460782389*PriceSeries(Price,index-205,O,L,H,C)
                -0.000720654998165*PriceSeries(Price,index-206,O,L,H,C)
                -0.000442203189869*PriceSeries(Price,index-207,O,L,H,C)
                -0.0001554634597201*PriceSeries(Price,index-208,O,L,H,C)
                +0.0001301395573673*PriceSeries(Price,index-209,O,L,H,C)
                +0.000405420921989*PriceSeries(Price,index-210,O,L,H,C)
                +0.000661726916684*PriceSeries(Price,index-211,O,L,H,C)
                +0.000891202700726*PriceSeries(Price,index-212,O,L,H,C)
                +0.001087029427589*PriceSeries(Price,index-213,O,L,H,C)
                +0.001243621054551*PriceSeries(Price,index-214,O,L,H,C)
                +0.001356778497069*PriceSeries(Price,index-215,O,L,H,C)
                +0.001423795516838*PriceSeries(Price,index-216,O,L,H,C)
                +0.001443513043869*PriceSeries(Price,index-217,O,L,H,C)
                +0.001416323564156*PriceSeries(Price,index-218,O,L,H,C)
                +0.001344123732469*PriceSeries(Price,index-219,O,L,H,C)
                +0.001230220710749*PriceSeries(Price,index-220,O,L,H,C)
                +0.001079195080941*PriceSeries(Price,index-221,O,L,H,C)
                +0.000896724167786*PriceSeries(Price,index-222,O,L,H,C)
                +0.000689375415436*PriceSeries(Price,index-223,O,L,H,C)
                +0.000464374203045*PriceSeries(Price,index-224,O,L,H,C)
                +0.0002293563264559*PriceSeries(Price,index-225,O,L,H,C)
                -0.00000788708917217*PriceSeries(Price,index-226,O,L,H,C)
                -0.0002396657532121*PriceSeries(Price,index-227,O,L,H,C)
                -0.000458635373768*PriceSeries(Price,index-228,O,L,H,C)
                -0.000658027262581*PriceSeries(Price,index-229,O,L,H,C)
                -0.000831853969581*PriceSeries(Price,index-230,O,L,H,C)
                -0.000975084580048*PriceSeries(Price,index-231,O,L,H,C)
                -0.001083787064528*PriceSeries(Price,index-232,O,L,H,C)
                -0.001155229782786*PriceSeries(Price,index-233,O,L,H,C)
                -0.001187942966090*PriceSeries(Price,index-234,O,L,H,C)
                -0.001181738374181*PriceSeries(Price,index-235,O,L,H,C)
                -0.001137685959303*PriceSeries(Price,index-236,O,L,H,C)
                -0.001058052131740*PriceSeries(Price,index-237,O,L,H,C)
                -0.000946198642461*PriceSeries(Price,index-238,O,L,H,C)
                -0.000806449371808*PriceSeries(Price,index-239,O,L,H,C)
                -0.000643929959242*PriceSeries(Price,index-240,O,L,H,C)
                -0.000464383411541*PriceSeries(Price,index-241,O,L,H,C)
                -0.0002739716798388*PriceSeries(Price,index-242,O,L,H,C)
                -0.0000790664365003*PriceSeries(Price,index-243,O,L,H,C)
                +0.0001139613802323*PriceSeries(Price,index-244,O,L,H,C)
                +0.0002989459390271*PriceSeries(Price,index-245,O,L,H,C)
                +0.000470121879386*PriceSeries(Price,index-246,O,L,H,C)
                +0.000622300300617*PriceSeries(Price,index-247,O,L,H,C)
                +0.000751023251157*PriceSeries(Price,index-248,O,L,H,C)
                +0.000852690803652*PriceSeries(Price,index-249,O,L,H,C)
                +0.000924656169535*PriceSeries(Price,index-250,O,L,H,C)
                +0.000965290627960*PriceSeries(Price,index-251,O,L,H,C)
                +0.000974011917085*PriceSeries(Price,index-252,O,L,H,C)
                +0.000951278681472*PriceSeries(Price,index-253,O,L,H,C)
                +0.000898551808795*PriceSeries(Price,index-254,O,L,H,C)
                +0.000818222661543*PriceSeries(Price,index-255,O,L,H,C)
                +0.000713515755509*PriceSeries(Price,index-256,O,L,H,C)
                +0.000588364600575*PriceSeries(Price,index-257,O,L,H,C)
                +0.000447267786235*PriceSeries(Price,index-258,O,L,H,C)
                +0.0002951316149228*PriceSeries(Price,index-259,O,L,H,C)
                +0.0001371012736870*PriceSeries(Price,index-260,O,L,H,C)
                -0.00002160924500476*PriceSeries(Price,index-261,O,L,H,C)
                -0.0001758875918988*PriceSeries(Price,index-262,O,L,H,C)
                -0.000320886271871*PriceSeries(Price,index-263,O,L,H,C)
                -0.000452171100480*PriceSeries(Price,index-264,O,L,H,C)
                -0.000565855244959*PriceSeries(Price,index-265,O,L,H,C)
                -0.000658710208459*PriceSeries(Price,index-266,O,L,H,C)
                -0.000728254510899*PriceSeries(Price,index-267,O,L,H,C)
                -0.000772816564770*PriceSeries(Price,index-268,O,L,H,C)
                -0.000791567122421*PriceSeries(Price,index-269,O,L,H,C)
                -0.000784526938852*PriceSeries(Price,index-270,O,L,H,C)
                -0.000752544917977*PriceSeries(Price,index-271,O,L,H,C)
                -0.000697250648302*PriceSeries(Price,index-272,O,L,H,C)
                -0.000620983747042*PriceSeries(Price,index-273,O,L,H,C)
                -0.000526699065965*PriceSeries(Price,index-274,O,L,H,C)
                -0.000417858159739*PriceSeries(Price,index-275,O,L,H,C)
                -0.0002983054731700*PriceSeries(Price,index-276,O,L,H,C)
                -0.0001721347763278*PriceSeries(Price,index-277,O,L,H,C)
                -0.0000435524230284*PriceSeries(Price,index-278,O,L,H,C)
                +0.0000832628020822*PriceSeries(Price,index-279,O,L,H,C)
                +0.0002042918817329*PriceSeries(Price,index-280,O,L,H,C)
                +0.0003158009643989*PriceSeries(Price,index-281,O,L,H,C)
                +0.000414455795280*PriceSeries(Price,index-282,O,L,H,C)
                +0.000497417504850*PriceSeries(Price,index-283,O,L,H,C)
                +0.000562422988770*PriceSeries(Price,index-284,O,L,H,C)
                +0.000607841552445*PriceSeries(Price,index-285,O,L,H,C)
                +0.000632711208761*PriceSeries(Price,index-286,O,L,H,C)
                +0.000636754692832*PriceSeries(Price,index-287,O,L,H,C)
                +0.000620369049276*PriceSeries(Price,index-288,O,L,H,C)
                +0.000584596947981*PriceSeries(Price,index-289,O,L,H,C)
                +0.000531075628053*PriceSeries(Price,index-290,O,L,H,C)
                +0.000461968663989*PriceSeries(Price,index-291,O,L,H,C)
                +0.000379885110268*PriceSeries(Price,index-292,O,L,H,C)
                +0.0002877816500525*PriceSeries(Price,index-293,O,L,H,C)
                +0.0001888598545358*PriceSeries(Price,index-294,O,L,H,C)
                +0.0000864570642617*PriceSeries(Price,index-295,O,L,H,C)
                -0.00001606493468602*PriceSeries(Price,index-296,O,L,H,C)
                -0.0001154263639940*PriceSeries(Price,index-297,O,L,H,C)
                -0.0002085357178967*PriceSeries(Price,index-298,O,L,H,C)
                -0.0002925830640946*PriceSeries(Price,index-299,O,L,H,C)
                -0.000365121964821*PriceSeries(Price,index-300,O,L,H,C)
                -0.000424139657813*PriceSeries(Price,index-301,O,L,H,C)
                -0.000468107826392*PriceSeries(Price,index-302,O,L,H,C)
                -0.000496021362435*PriceSeries(Price,index-303,O,L,H,C)
                -0.000507415395949*PriceSeries(Price,index-304,O,L,H,C)
                -0.000502364350834*PriceSeries(Price,index-305,O,L,H,C)
                -0.000481467783052*PriceSeries(Price,index-306,O,L,H,C)
                -0.000445815055551*PriceSeries(Price,index-307,O,L,H,C)
                -0.000396939286052*PriceSeries(Price,index-308,O,L,H,C)
                -0.000336754950701*PriceSeries(Price,index-309,O,L,H,C)
                -0.0002674841429929*PriceSeries(Price,index-310,O,L,H,C)
                -0.0001915804893004*PriceSeries(Price,index-311,O,L,H,C)
                -0.0001116419145315*PriceSeries(Price,index-312,O,L,H,C)
                -0.00003032481328318*PriceSeries(Price,index-313,O,L,H,C)
                +0.0000497429188908*PriceSeries(Price,index-314,O,L,H,C)
                +0.0001260472672935*PriceSeries(Price,index-315,O,L,H,C)
                +0.0001962614257732*PriceSeries(Price,index-316,O,L,H,C)
                +0.0002583181967082*PriceSeries(Price,index-317,O,L,H,C)
                +0.0003104686598735*PriceSeries(Price,index-318,O,L,H,C)
                +0.000351328190614*PriceSeries(Price,index-319,O,L,H,C)
                +0.000379912535932*PriceSeries(Price,index-320,O,L,H,C)
                +0.000395653799855*PriceSeries(Price,index-321,O,L,H,C)
                +0.000398410424017*PriceSeries(Price,index-322,O,L,H,C)
                +0.000388460218719*PriceSeries(Price,index-323,O,L,H,C)
                +0.000366477265864*PriceSeries(Price,index-324,O,L,H,C)
                +0.000333501968656*PriceSeries(Price,index-325,O,L,H,C)
                +0.0002908935140723*PriceSeries(Price,index-326,O,L,H,C)
                +0.0002402802323793*PriceSeries(Price,index-327,O,L,H,C)
                +0.0001834999412208*PriceSeries(Price,index-328,O,L,H,C)
                +0.0001225309132051*PriceSeries(Price,index-329,O,L,H,C)
                +0.0000594288343784*PriceSeries(Price,index-330,O,L,H,C)
                -0.00000374351828410*PriceSeries(Price,index-331,O,L,H,C)
                -0.0000649795683368*PriceSeries(Price,index-332,O,L,H,C)
                -0.0001223904398992*PriceSeries(Price,index-333,O,L,H,C)
                -0.0001742669448803*PriceSeries(Price,index-334,O,L,H,C)
                -0.0002191234421354*PriceSeries(Price,index-335,O,L,H,C)
                -0.0002557410449684*PriceSeries(Price,index-336,O,L,H,C)
                -0.0002831979867250*PriceSeries(Price,index-337,O,L,H,C)
                -0.0003008885925068*PriceSeries(Price,index-338,O,L,H,C)
                -0.0003085385023867*PriceSeries(Price,index-339,O,L,H,C)
                -0.0003061969670685*PriceSeries(Price,index-340,O,L,H,C)
                -0.0002942283718755*PriceSeries(Price,index-341,O,L,H,C)
                -0.0002732933750293*PriceSeries(Price,index-342,O,L,H,C)
                -0.0002443160393545*PriceSeries(Price,index-343,O,L,H,C)
                -0.0002084515258021*PriceSeries(Price,index-344,O,L,H,C)
                -0.0001670349518336*PriceSeries(Price,index-345,O,L,H,C)
                -0.0001215358124907*PriceSeries(Price,index-346,O,L,H,C)
                -0.0000735110099872*PriceSeries(Price,index-347,O,L,H,C)
                -0.00002454732259961*PriceSeries(Price,index-348,O,L,H,C)
                +0.00002378405318890*PriceSeries(Price,index-349,O,L,H,C)
                +0.0000699822901753*PriceSeries(Price,index-350,O,L,H,C)
                +0.0001126596745209*PriceSeries(Price,index-351,O,L,H,C)
                +0.0001505772864856*PriceSeries(Price,index-352,O,L,H,C)
                +0.0001826891648619*PriceSeries(Price,index-353,O,L,H,C)
                +0.0002081637461444*PriceSeries(Price,index-354,O,L,H,C)
                +0.0002264069755383*PriceSeries(Price,index-355,O,L,H,C)
                +0.0002370718801178*PriceSeries(Price,index-356,O,L,H,C)
                +0.0002400553916619*PriceSeries(Price,index-357,O,L,H,C)
                +0.0002355054995719*PriceSeries(Price,index-358,O,L,H,C)
                +0.0002238014254173*PriceSeries(Price,index-359,O,L,H,C)
                +0.0002055361815465*PriceSeries(Price,index-360,O,L,H,C)
                +0.0001814940464630*PriceSeries(Price,index-361,O,L,H,C)
                +0.0001526136946576*PriceSeries(Price,index-362,O,L,H,C)
                +0.0001199668121003*PriceSeries(Price,index-363,O,L,H,C)
                +0.0000847104742081*PriceSeries(Price,index-364,O,L,H,C)
                +0.0000480472575896*PriceSeries(Price,index-365,O,L,H,C)
                +0.00001119434164985*PriceSeries(Price,index-366,O,L,H,C)
                -0.00002466252605935*PriceSeries(Price,index-367,O,L,H,C)
                -0.0000583919348211*PriceSeries(Price,index-368,O,L,H,C)
                -0.0000889610838619*PriceSeries(Price,index-369,O,L,H,C)
                -0.0001154678771737*PriceSeries(Price,index-370,O,L,H,C)
                -0.0001371516972392*PriceSeries(Price,index-371,O,L,H,C)
                -0.0001534252351676*PriceSeries(Price,index-372,O,L,H,C)
                -0.0001638754641675*PriceSeries(Price,index-373,O,L,H,C)
                -0.0001682779073663*PriceSeries(Price,index-374,O,L,H,C)
                -0.0001665990488829*PriceSeries(Price,index-375,O,L,H,C)
                -0.0001589705910072*PriceSeries(Price,index-376,O,L,H,C)
                -0.0001457000654962*PriceSeries(Price,index-377,O,L,H,C)
                -0.0001272484077081*PriceSeries(Price,index-378,O,L,H,C)
                -0.0001042157184205*PriceSeries(Price,index-379,O,L,H,C)
                -0.0000773252889495*PriceSeries(Price,index-380,O,L,H,C)
                -0.0000473733105822*PriceSeries(Price,index-381,O,L,H,C)
                -0.00001522907664972*PriceSeries(Price,index-382,O,L,H,C)
                +0.00001820289359871*PriceSeries(Price,index-383,O,L,H,C)
                +0.0000520175940213*PriceSeries(Price,index-384,O,L,H,C)
                +0.0000853217387564*PriceSeries(Price,index-385,O,L,H,C)
                +0.0001172848535654*PriceSeries(Price,index-386,O,L,H,C)
                +0.0001471264354159*PriceSeries(Price,index-387,O,L,H,C)
                +0.0001741481515864*PriceSeries(Price,index-388,O,L,H,C)
                +0.0001977726787747*PriceSeries(Price,index-389,O,L,H,C)
                +0.0002175273283010*PriceSeries(Price,index-390,O,L,H,C)
                +0.0002330815360186*PriceSeries(Price,index-391,O,L,H,C)
                +0.0002442109670287*PriceSeries(Price,index-392,O,L,H,C)
                +0.0002508084864825*PriceSeries(Price,index-393,O,L,H,C)
                +0.0002529168243466*PriceSeries(Price,index-394,O,L,H,C)
                +0.0002506672600784*PriceSeries(Price,index-395,O,L,H,C)
                +0.0002443138405359*PriceSeries(Price,index-396,O,L,H,C)
                +0.0002341951770151*PriceSeries(Price,index-397,O,L,H,C)
                +0.0002207297370327*PriceSeries(Price,index-398,O,L,H,C)
                +0.0002044510899659*PriceSeries(Price,index-399,O,L,H,C)
                +0.0001858850391627*PriceSeries(Price,index-400,O,L,H,C)
                +0.0001655881554429*PriceSeries(Price,index-401,O,L,H,C)
                +0.0001441203800448*PriceSeries(Price,index-402,O,L,H,C)
                +0.0001220167265036*PriceSeries(Price,index-403,O,L,H,C)
                +0.0000998646374915*PriceSeries(Price,index-404,O,L,H,C)
                +0.0000781352838962*PriceSeries(Price,index-405,O,L,H,C)
                +0.0000572793822713*PriceSeries(Price,index-406,O,L,H,C)
                +0.0000377419196640*PriceSeries(Price,index-407,O,L,H,C)
                +0.00001984027879721*PriceSeries(Price,index-408,O,L,H,C)
                +0.00000390812590571*PriceSeries(Price,index-409,O,L,H,C)
                -0.00000996595387706*PriceSeries(Price,index-410,O,L,H,C)
                -0.00002172424180354*PriceSeries(Price,index-411,O,L,H,C)
                -0.00003118103137233*PriceSeries(Price,index-412,O,L,H,C)
                -0.0000384060033396*PriceSeries(Price,index-413,O,L,H,C)
                -0.0000433284505893*PriceSeries(Price,index-414,O,L,H,C)
                -0.0000462674525827*PriceSeries(Price,index-415,O,L,H,C)
                -0.0000475789086340*PriceSeries(Price,index-416,O,L,H,C)
                -0.0000468618321191*PriceSeries(Price,index-417,O,L,H,C)
                -0.0000449705866769*PriceSeries(Price,index-418,O,L,H,C)
                -0.0000418146551828*PriceSeries(Price,index-419,O,L,H,C)
                -0.0000377595704947*PriceSeries(Price,index-420,O,L,H,C)
                -0.0001266226215499*PriceSeries(Price,index-421,O,L,H,C)
                );

      case N38:
         return(
                0.1053359393052*PriceSeries(Price,index,O,L,H,C)
                +0.1047947272137*PriceSeries(Price,index-1,O,L,H,C)
                +0.1031811267090*PriceSeries(Price,index-2,O,L,H,C)
                +0.1005250229138*PriceSeries(Price,index-3,O,L,H,C)
                +0.0968754891121*PriceSeries(Price,index-4,O,L,H,C)
                +0.0922997025372*PriceSeries(Price,index-5,O,L,H,C)
                +0.0868814633185*PriceSeries(Price,index-6,O,L,H,C)
                +0.0807193523022*PriceSeries(Price,index-7,O,L,H,C)
                +0.0739245720851*PriceSeries(Price,index-8,O,L,H,C)
                +0.0666185230951*PriceSeries(Price,index-9,O,L,H,C)
                +0.0589301727343*PriceSeries(Price,index-10,O,L,H,C)
                +0.0509932803094*PriceSeries(Price,index-11,O,L,H,C)
                +0.0429435436030*PriceSeries(Price,index-12,O,L,H,C)
                +0.0349157344064*PriceSeries(Price,index-13,O,L,H,C)
                +0.02704089011694*PriceSeries(Price,index-14,O,L,H,C)
                +0.01944362661026*PriceSeries(Price,index-15,O,L,H,C)
                +0.01223963409143*PriceSeries(Price,index-16,O,L,H,C)
                +0.00553341260349*PriceSeries(Price,index-17,O,L,H,C)
                -0.000583702527917*PriceSeries(Price,index-18,O,L,H,C)
                -0.00603518264136*PriceSeries(Price,index-19,O,L,H,C)
                -0.01076058101050*PriceSeries(Price,index-20,O,L,H,C)
                -0.01471641674867*PriceSeries(Price,index-21,O,L,H,C)
                -0.01787665255776*PriceSeries(Price,index-22,O,L,H,C)
                -0.02023276169834*PriceSeries(Price,index-23,O,L,H,C)
                -0.02179338972516*PriceSeries(Price,index-24,O,L,H,C)
                -0.02258362643936*PriceSeries(Price,index-25,O,L,H,C)
                -0.02264391290221*PriceSeries(Price,index-26,O,L,H,C)
                -0.02202861699901*PriceSeries(Price,index-27,O,L,H,C)
                -0.02080431872042*PriceSeries(Price,index-28,O,L,H,C)
                -0.01904785285483*PriceSeries(Price,index-29,O,L,H,C)
                -0.01684416200431*PriceSeries(Price,index-30,O,L,H,C)
                -0.01428401662839*PriceSeries(Price,index-31,O,L,H,C)
                -0.01146166110580*PriceSeries(Price,index-32,O,L,H,C)
                -0.00847244554302*PriceSeries(Price,index-33,O,L,H,C)
                -0.00541050225363*PriceSeries(Price,index-34,O,L,H,C)
                -0.002366523525609*PriceSeries(Price,index-35,O,L,H,C)
                +0.000574306432304*PriceSeries(Price,index-36,O,L,H,C)
                +0.00333417750114*PriceSeries(Price,index-37,O,L,H,C)
                +0.00584427593122*PriceSeries(Price,index-38,O,L,H,C)
                +0.00804612834768*PriceSeries(Price,index-39,O,L,H,C)
                +0.00989264084957*PriceSeries(Price,index-40,O,L,H,C)
                +0.01134881502450*PriceSeries(Price,index-41,O,L,H,C)
                +0.01239213146697*PriceSeries(Price,index-42,O,L,H,C)
                +0.01301260022896*PriceSeries(Price,index-43,O,L,H,C)
                +0.01321248630992*PriceSeries(Price,index-44,O,L,H,C)
                +0.01300572658214*PriceSeries(Price,index-45,O,L,H,C)
                +0.01241706223267*PriceSeries(Price,index-46,O,L,H,C)
                +0.01148091769037*PriceSeries(Price,index-47,O,L,H,C)
                +0.01024006292581*PriceSeries(Price,index-48,O,L,H,C)
                +0.00874410082309*PriceSeries(Price,index-49,O,L,H,C)
                +0.00704782491674*PriceSeries(Price,index-50,O,L,H,C)
                +0.00520949509071*PriceSeries(Price,index-51,O,L,H,C)
                +0.00328907981224*PriceSeries(Price,index-52,O,L,H,C)
                +0.001346513121500*PriceSeries(Price,index-53,O,L,H,C)
                -0.000559987047042*PriceSeries(Price,index-54,O,L,H,C)
                -0.002375495502290*PriceSeries(Price,index-55,O,L,H,C)
                -0.00404981167038*PriceSeries(Price,index-56,O,L,H,C)
                -0.00553871195629*PriceSeries(Price,index-57,O,L,H,C)
                -0.00680499365115*PriceSeries(Price,index-58,O,L,H,C)
                -0.00781928790541*PriceSeries(Price,index-59,O,L,H,C)
                -0.00856062621485*PriceSeries(Price,index-60,O,L,H,C)
                -0.00901675205806*PriceSeries(Price,index-61,O,L,H,C)
                -0.00918417657606*PriceSeries(Price,index-62,O,L,H,C)
                -0.00906798429631*PriceSeries(Price,index-63,O,L,H,C)
                -0.00868140168006*PriceSeries(Price,index-64,O,L,H,C)
                -0.00804514753316*PriceSeries(Price,index-65,O,L,H,C)
                -0.00718658990332*PriceSeries(Price,index-66,O,L,H,C)
                -0.00613873885055*PriceSeries(Price,index-67,O,L,H,C)
                -0.00493910830601*PriceSeries(Price,index-68,O,L,H,C)
                -0.00362848304304*PriceSeries(Price,index-69,O,L,H,C)
                -0.002249628513342*PriceSeries(Price,index-70,O,L,H,C)
                -0.000845981929136*PriceSeries(Price,index-71,O,L,H,C)
                +0.000539637497413*PriceSeries(Price,index-72,O,L,H,C)
                +0.001866262774213*PriceSeries(Price,index-73,O,L,H,C)
                +0.003095923946576*PriceSeries(Price,index-74,O,L,H,C)
                +0.00419467307041*PriceSeries(Price,index-75,O,L,H,C)
                +0.00513346310358*PriceSeries(Price,index-76,O,L,H,C)
                +0.00588885932799*PriceSeries(Price,index-77,O,L,H,C)
                +0.00644356725977*PriceSeries(Price,index-78,O,L,H,C)
                +0.00678676668071*PriceSeries(Price,index-79,O,L,H,C)
                +0.00691424726287*PriceSeries(Price,index-80,O,L,H,C)
                +0.00682834708778*PriceSeries(Price,index-81,O,L,H,C)
                +0.00653770101746*PriceSeries(Price,index-82,O,L,H,C)
                +0.00605681119666*PriceSeries(Price,index-83,O,L,H,C)
                +0.00540545680954*PriceSeries(Price,index-84,O,L,H,C)
                +0.00460796445111*PriceSeries(Price,index-85,O,L,H,C)
                +0.00369236399460*PriceSeries(Price,index-86,O,L,H,C)
                +0.002689457555858*PriceSeries(Price,index-87,O,L,H,C)
                +0.001631831012824*PriceSeries(Price,index-88,O,L,H,C)
                +0.000552838498300*PriceSeries(Price,index-89,O,L,H,C)
                -0.000514409661103*PriceSeries(Price,index-90,O,L,H,C)
                -0.001538025919615*PriceSeries(Price,index-91,O,L,H,C)
                -0.002488263436457*PriceSeries(Price,index-92,O,L,H,C)
                -0.00333834743833*PriceSeries(Price,index-93,O,L,H,C)
                -0.00406519765043*PriceSeries(Price,index-94,O,L,H,C)
                -0.00465002314949*PriceSeries(Price,index-95,O,L,H,C)
                -0.00507877517686*PriceSeries(Price,index-96,O,L,H,C)
                -0.00534244796287*PriceSeries(Price,index-97,O,L,H,C)
                -0.00543722231695*PriceSeries(Price,index-98,O,L,H,C)
                -0.00536445148989*PriceSeries(Price,index-99,O,L,H,C)
                -0.00513049347461*PriceSeries(Price,index-100,O,L,H,C)
                -0.00474639834551*PriceSeries(Price,index-101,O,L,H,C)
                -0.00422746331927*PriceSeries(Price,index-102,O,L,H,C)
                -0.00359267183826*PriceSeries(Price,index-103,O,L,H,C)
                -0.002864036036453*PriceSeries(Price,index-104,O,L,H,C)
                -0.002065864368133*PriceSeries(Price,index-105,O,L,H,C)
                -0.001223977903862*PriceSeries(Price,index-106,O,L,H,C)
                -0.000364899790765*PriceSeries(Price,index-107,O,L,H,C)
                +0.000484957379298*PriceSeries(Price,index-108,O,L,H,C)
                +0.001300082040856*PriceSeries(Price,index-109,O,L,H,C)
                +0.002056608910594*PriceSeries(Price,index-110,O,L,H,C)
                +0.002732997828380*PriceSeries(Price,index-111,O,L,H,C)
                +0.00331062742799*PriceSeries(Price,index-112,O,L,H,C)
                +0.00377428782965*PriceSeries(Price,index-113,O,L,H,C)
                +0.00411255990012*PriceSeries(Price,index-114,O,L,H,C)
                +0.00431807227825*PriceSeries(Price,index-115,O,L,H,C)
                +0.00438763119915*PriceSeries(Price,index-116,O,L,H,C)
                +0.00432222205220*PriceSeries(Price,index-117,O,L,H,C)
                +0.00412688545816*PriceSeries(Price,index-118,O,L,H,C)
                +0.00381047433681*PriceSeries(Price,index-119,O,L,H,C)
                +0.00338530185149*PriceSeries(Price,index-120,O,L,H,C)
                +0.002866693165277*PriceSeries(Price,index-121,O,L,H,C)
                +0.002272456541710*PriceSeries(Price,index-122,O,L,H,C)
                +0.001622291403295*PriceSeries(Price,index-123,O,L,H,C)
                +0.000937152471501*PriceSeries(Price,index-124,O,L,H,C)
                +0.0002385900197438*PriceSeries(Price,index-125,O,L,H,C)
                -0.000451913439094*PriceSeries(Price,index-126,O,L,H,C)
                -0.001113590032717*PriceSeries(Price,index-127,O,L,H,C)
                -0.001726997894384*PriceSeries(Price,index-128,O,L,H,C)
                -0.002274579397473*PriceSeries(Price,index-129,O,L,H,C)
                -0.002741150608880*PriceSeries(Price,index-130,O,L,H,C)
                -0.003114308703204*PriceSeries(Price,index-131,O,L,H,C)
                -0.00338474682049*PriceSeries(Price,index-132,O,L,H,C)
                -0.00354646884998*PriceSeries(Price,index-133,O,L,H,C)
                -0.00359689978600*PriceSeries(Price,index-134,O,L,H,C)
                -0.00353689053136*PriceSeries(Price,index-135,O,L,H,C)
                -0.00337061922070*PriceSeries(Price,index-136,O,L,H,C)
                -0.003105394205798*PriceSeries(Price,index-137,O,L,H,C)
                -0.002751366696923*PriceSeries(Price,index-138,O,L,H,C)
                -0.002321163608509*PriceSeries(Price,index-139,O,L,H,C)
                -0.001829453342129*PriceSeries(Price,index-140,O,L,H,C)
                -0.001292458997362*PriceSeries(Price,index-141,O,L,H,C)
                -0.000727434786974*PriceSeries(Price,index-142,O,L,H,C)
                -0.0001521222179019*PriceSeries(Price,index-143,O,L,H,C)
                +0.000415797129945*PriceSeries(Price,index-144,O,L,H,C)
                +0.000959235636872*PriceSeries(Price,index-145,O,L,H,C)
                +0.001462204635079*PriceSeries(Price,index-146,O,L,H,C)
                +0.001910275704898*PriceSeries(Price,index-147,O,L,H,C)
                +0.002290985238720*PriceSeries(Price,index-148,O,L,H,C)
                +0.002594171213319*PriceSeries(Price,index-149,O,L,H,C)
                +0.002812233382599*PriceSeries(Price,index-150,O,L,H,C)
                +0.002940310593539*PriceSeries(Price,index-151,O,L,H,C)
                +0.002976371558901*PriceSeries(Price,index-152,O,L,H,C)
                +0.002921218108872*PriceSeries(Price,index-153,O,L,H,C)
                +0.002778402608071*PriceSeries(Price,index-154,O,L,H,C)
                +0.002554063784335*PriceSeries(Price,index-155,O,L,H,C)
                +0.002256687596132*PriceSeries(Price,index-156,O,L,H,C)
                +0.001896801898142*PriceSeries(Price,index-157,O,L,H,C)
                +0.001486615489841*PriceSeries(Price,index-158,O,L,H,C)
                +0.001039613600939*PriceSeries(Price,index-159,O,L,H,C)
                +0.000570122942687*PriceSeries(Price,index-160,O,L,H,C)
                +0.0000928601109147*PriceSeries(Price,index-161,O,L,H,C)
                -0.000377522646678*PriceSeries(Price,index-162,O,L,H,C)
                -0.000826880488124*PriceSeries(Price,index-163,O,L,H,C)
                -0.001241994664435*PriceSeries(Price,index-164,O,L,H,C)
                -0.001610954643965*PriceSeries(Price,index-165,O,L,H,C)
                -0.001923492833183*PriceSeries(Price,index-166,O,L,H,C)
                -0.002171262706371*PriceSeries(Price,index-167,O,L,H,C)
                -0.002348053055282*PriceSeries(Price,index-168,O,L,H,C)
                -0.002449933151415*PriceSeries(Price,index-169,O,L,H,C)
                -0.002475325811474*PriceSeries(Price,index-170,O,L,H,C)
                -0.002425007602081*PriceSeries(Price,index-171,O,L,H,C)
                -0.002302037643708*PriceSeries(Price,index-172,O,L,H,C)
                -0.002111618609320*PriceSeries(Price,index-173,O,L,H,C)
                -0.001860895497210*PriceSeries(Price,index-174,O,L,H,C)
                -0.001558699532894*PriceSeries(Price,index-175,O,L,H,C)
                -0.001215246071971*PriceSeries(Price,index-176,O,L,H,C)
                -0.000841796593617*PriceSeries(Price,index-177,O,L,H,C)
                -0.000450295761887*PriceSeries(Price,index-178,O,L,H,C)
                -0.0000529950688116*PriceSeries(Price,index-179,O,L,H,C)
                +0.000337925249960*PriceSeries(Price,index-180,O,L,H,C)
                +0.000710724517658*PriceSeries(Price,index-181,O,L,H,C)
                +0.001054449154941*PriceSeries(Price,index-182,O,L,H,C)
                +0.001359249322339*PriceSeries(Price,index-183,O,L,H,C)
                +0.001616655675153*PriceSeries(Price,index-184,O,L,H,C)
                +0.001819808630230*PriceSeries(Price,index-185,O,L,H,C)
                +0.001963634138085*PriceSeries(Price,index-186,O,L,H,C)
                +0.002044961698497*PriceSeries(Price,index-187,O,L,H,C)
                +0.002062582197081*PriceSeries(Price,index-188,O,L,H,C)
                +0.002017245016679*PriceSeries(Price,index-189,O,L,H,C)
                +0.001911595732939*PriceSeries(Price,index-190,O,L,H,C)
                +0.001750057482256*PriceSeries(Price,index-191,O,L,H,C)
                +0.001538660739709*PriceSeries(Price,index-192,O,L,H,C)
                +0.001284827717235*PriceSeries(Price,index-193,O,L,H,C)
                +0.000997118846680*PriceSeries(Price,index-194,O,L,H,C)
                +0.000684949814782*PriceSeries(Price,index-195,O,L,H,C)
                +0.000358288342072*PriceSeries(Price,index-196,O,L,H,C)
                +0.00002734032849092*PriceSeries(Price,index-197,O,L,H,C)
                -0.0002977648819133*PriceSeries(Price,index-198,O,L,H,C)
                -0.000607280534621*PriceSeries(Price,index-199,O,L,H,C)
                -0.000892130671910*PriceSeries(Price,index-200,O,L,H,C)
                -0.001144172115386*PriceSeries(Price,index-201,O,L,H,C)
                -0.001356422792716*PriceSeries(Price,index-202,O,L,H,C)
                -0.001523250151423*PriceSeries(Price,index-203,O,L,H,C)
                -0.001640514743296*PriceSeries(Price,index-204,O,L,H,C)
                -0.001705665526180*PriceSeries(Price,index-205,O,L,H,C)
                -0.001717784968583*PriceSeries(Price,index-206,O,L,H,C)
                -0.001677583608291*PriceSeries(Price,index-207,O,L,H,C)
                -0.001587345260766*PriceSeries(Price,index-208,O,L,H,C)
                -0.001450825549795*PriceSeries(Price,index-209,O,L,H,C)
                -0.001273107798235*PriceSeries(Price,index-210,O,L,H,C)
                -0.001060421531231*PriceSeries(Price,index-211,O,L,H,C)
                -0.000819929874197*PriceSeries(Price,index-212,O,L,H,C)
                -0.000559492945519*PriceSeries(Price,index-213,O,L,H,C)
                -0.0002874149287448*PriceSeries(Price,index-214,O,L,H,C)
                -0.00001218284799317*PriceSeries(Price,index-215,O,L,H,C)
                +0.0002577948418542*PriceSeries(Price,index-216,O,L,H,C)
                +0.000514441899515*PriceSeries(Price,index-217,O,L,H,C)
                +0.000750252625111*PriceSeries(Price,index-218,O,L,H,C)
                +0.000958507941521*PriceSeries(Price,index-219,O,L,H,C)
                +0.001133463118813*PriceSeries(Price,index-220,O,L,H,C)
                +0.001270502019858*PriceSeries(Price,index-221,O,L,H,C)
                +0.001366253869475*PriceSeries(Price,index-222,O,L,H,C)
                +0.001418669772270*PriceSeries(Price,index-223,O,L,H,C)
                +0.001427057486489*PriceSeries(Price,index-224,O,L,H,C)
                +0.001392074262435*PriceSeries(Price,index-225,O,L,H,C)
                +0.001315678834195*PriceSeries(Price,index-226,O,L,H,C)
                +0.001201044874067*PriceSeries(Price,index-227,O,L,H,C)
                +0.001052439344077*PriceSeries(Price,index-228,O,L,H,C)
                +0.000875070176074*PriceSeries(Price,index-229,O,L,H,C)
                +0.000674908553196*PriceSeries(Price,index-230,O,L,H,C)
                +0.000458491728654*PriceSeries(Price,index-231,O,L,H,C)
                +0.0002327127861256*PriceSeries(Price,index-232,O,L,H,C)
                +0.00000460400938821*PriceSeries(Price,index-233,O,L,H,C)
                -0.0002188794166064*PriceSeries(Price,index-234,O,L,H,C)
                -0.000431068802629*PriceSeries(Price,index-235,O,L,H,C)
                -0.000625778228138*PriceSeries(Price,index-236,O,L,H,C)
                -0.000797481999521*PriceSeries(Price,index-237,O,L,H,C)
                -0.000941468296189*PriceSeries(Price,index-238,O,L,H,C)
                -0.001053964838136*PriceSeries(Price,index-239,O,L,H,C)
                -0.001132233349038*PriceSeries(Price,index-240,O,L,H,C)
                -0.001174630607648*PriceSeries(Price,index-241,O,L,H,C)
                -0.001180634944553*PriceSeries(Price,index-242,O,L,H,C)
                -0.001150838117692*PriceSeries(Price,index-243,O,L,H,C)
                -0.001086903555332*PriceSeries(Price,index-244,O,L,H,C)
                -0.000991492957711*PriceSeries(Price,index-245,O,L,H,C)
                -0.000868164168801*PriceSeries(Price,index-246,O,L,H,C)
                -0.000721244041376*PriceSeries(Price,index-247,O,L,H,C)
                -0.000555680699296*PriceSeries(Price,index-248,O,L,H,C)
                -0.000376880132794*PriceSeries(Price,index-249,O,L,H,C)
                -0.0001905324324689*PriceSeries(Price,index-250,O,L,H,C)
                -0.000002433168027778*PriceSeries(Price,index-251,O,L,H,C)
                +0.0001816945540805*PriceSeries(Price,index-252,O,L,H,C)
                +0.000356371961022*PriceSeries(Price,index-253,O,L,H,C)
                +0.000516525321184*PriceSeries(Price,index-254,O,L,H,C)
                +0.000657630849172*PriceSeries(Price,index-255,O,L,H,C)
                +0.000775839750812*PriceSeries(Price,index-256,O,L,H,C)
                +0.000868080044159*PriceSeries(Price,index-257,O,L,H,C)
                +0.000932132573214*PriceSeries(Price,index-258,O,L,H,C)
                +0.000966679473429*PriceSeries(Price,index-259,O,L,H,C)
                +0.000971324224851*PriceSeries(Price,index-260,O,L,H,C)
                +0.000946583312633*PriceSeries(Price,index-261,O,L,H,C)
                +0.000893850378248*PriceSeries(Price,index-262,O,L,H,C)
                +0.000815334562272*PriceSeries(Price,index-263,O,L,H,C)
                +0.000713975487052*PriceSeries(Price,index-264,O,L,H,C)
                +0.000593337983677*PriceSeries(Price,index-265,O,L,H,C)
                +0.000457490214418*PriceSeries(Price,index-266,O,L,H,C)
                +0.0003108692649642*PriceSeries(Price,index-267,O,L,H,C)
                +0.0001581385702418*PriceSeries(Price,index-268,O,L,H,C)
                +0.00000404168749608*PriceSeries(Price,index-269,O,L,H,C)
                -0.0001467430606832*PriceSeries(Price,index-270,O,L,H,C)
                -0.0002897426797131*PriceSeries(Price,index-271,O,L,H,C)
                -0.000420820198958*PriceSeries(Price,index-272,O,L,H,C)
                -0.000536292216329*PriceSeries(Price,index-273,O,L,H,C)
                -0.000633030023090*PriceSeries(Price,index-274,O,L,H,C)
                -0.000708541614333*PriceSeries(Price,index-275,O,L,H,C)
                -0.000761032533335*PriceSeries(Price,index-276,O,L,H,C)
                -0.000789444188532*PriceSeries(Price,index-277,O,L,H,C)
                -0.000793468997934*PriceSeries(Price,index-278,O,L,H,C)
                -0.000773542435074*PriceSeries(Price,index-279,O,L,H,C)
                -0.000730812751062*PriceSeries(Price,index-280,O,L,H,C)
                -0.000667089808111*PriceSeries(Price,index-281,O,L,H,C)
                -0.000584775061659*PriceSeries(Price,index-282,O,L,H,C)
                -0.000486775254159*PriceSeries(Price,index-283,O,L,H,C)
                -0.000376402819139*PriceSeries(Price,index-284,O,L,H,C)
                -0.0002572663283396*PriceSeries(Price,index-285,O,L,H,C)
                -0.0001331545394464*PriceSeries(Price,index-286,O,L,H,C)
                -0.00000791771302790*PriceSeries(Price,index-287,O,L,H,C)
                +0.0001146501361387*PriceSeries(Price,index-288,O,L,H,C)
                +0.0002309245033044*PriceSeries(Price,index-289,O,L,H,C)
                +0.000337555844198*PriceSeries(Price,index-290,O,L,H,C)
                +0.000431564199367*PriceSeries(Price,index-291,O,L,H,C)
                +0.000510420381435*PriceSeries(Price,index-292,O,L,H,C)
                +0.000572111585660*PriceSeries(Price,index-293,O,L,H,C)
                +0.000615189809367*PriceSeries(Price,index-294,O,L,H,C)
                +0.000638802027514*PriceSeries(Price,index-295,O,L,H,C)
                +0.000642701651610*PriceSeries(Price,index-296,O,L,H,C)
                +0.000627241379367*PriceSeries(Price,index-297,O,L,H,C)
                +0.000593348104932*PriceSeries(Price,index-298,O,L,H,C)
                +0.000542481087658*PriceSeries(Price,index-299,O,L,H,C)
                +0.000476575055866*PriceSeries(Price,index-300,O,L,H,C)
                +0.000397970337539*PriceSeries(Price,index-301,O,L,H,C)
                +0.0003093324514231*PriceSeries(Price,index-302,O,L,H,C)
                +0.0002135638510164*PriceSeries(Price,index-303,O,L,H,C)
                +0.0001137106847512*PriceSeries(Price,index-304,O,L,H,C)
                +0.00001286751531514*PriceSeries(Price,index-305,O,L,H,C)
                -0.0000859170704698*PriceSeries(Price,index-306,O,L,H,C)
                -0.0001797311298686*PriceSeries(Price,index-307,O,L,H,C)
                -0.0002658836625140*PriceSeries(Price,index-308,O,L,H,C)
                -0.000341980149611*PriceSeries(Price,index-309,O,L,H,C)
                -0.000405987269699*PriceSeries(Price,index-310,O,L,H,C)
                -0.000456285105798*PriceSeries(Price,index-311,O,L,H,C)
                -0.000491705579547*PriceSeries(Price,index-312,O,L,H,C)
                -0.000511556296614*PriceSeries(Price,index-313,O,L,H,C)
                -0.000515629449882*PriceSeries(Price,index-314,O,L,H,C)
                -0.000504195888417*PriceSeries(Price,index-315,O,L,H,C)
                -0.000477984906968*PriceSeries(Price,index-316,O,L,H,C)
                -0.000438150729479*PriceSeries(Price,index-317,O,L,H,C)
                -0.000386227038818*PriceSeries(Price,index-318,O,L,H,C)
                -0.000324071232873*PriceSeries(Price,index-319,O,L,H,C)
                -0.0002538003557548*PriceSeries(Price,index-320,O,L,H,C)
                -0.0001777208550876*PriceSeries(Price,index-321,O,L,H,C)
                -0.0000982544478813*PriceSeries(Price,index-322,O,L,H,C)
                -0.00001786243588669*PriceSeries(Price,index-323,O,L,H,C)
                +0.0000610292032039*PriceSeries(Price,index-324,O,L,H,C)
                +0.0001361017075079*PriceSeries(Price,index-325,O,L,H,C)
                +0.0002052103157054*PriceSeries(Price,index-326,O,L,H,C)
                +0.0002664440657180*PriceSeries(Price,index-327,O,L,H,C)
                +0.000318176990583*PriceSeries(Price,index-328,O,L,H,C)
                +0.000359109399077*PriceSeries(Price,index-329,O,L,H,C)
                +0.000388298264285*PriceSeries(Price,index-330,O,L,H,C)
                +0.000405176099170*PriceSeries(Price,index-331,O,L,H,C)
                +0.000409558062690*PriceSeries(Price,index-332,O,L,H,C)
                +0.000401637401888*PriceSeries(Price,index-333,O,L,H,C)
                +0.000381969683678*PriceSeries(Price,index-334,O,L,H,C)
                +0.000351446594618*PriceSeries(Price,index-335,O,L,H,C)
                +0.0003112603788178*PriceSeries(Price,index-336,O,L,H,C)
                +0.0002628602354597*PriceSeries(Price,index-337,O,L,H,C)
                +0.0002079022018693*PriceSeries(Price,index-338,O,L,H,C)
                +0.0001481942010765*PriceSeries(Price,index-339,O,L,H,C)
                +0.0000856380311751*PriceSeries(Price,index-340,O,L,H,C)
                +0.00002217011627958*PriceSeries(Price,index-341,O,L,H,C)
                -0.0000402971742465*PriceSeries(Price,index-342,O,L,H,C)
                -0.0000999318983996*PriceSeries(Price,index-343,O,L,H,C)
                -0.0001550349831048*PriceSeries(Price,index-344,O,L,H,C)
                -0.0002040872742961*PriceSeries(Price,index-345,O,L,H,C)
                -0.0002457899368751*PriceSeries(Price,index-346,O,L,H,C)
                -0.0002790971800765*PriceSeries(Price,index-347,O,L,H,C)
                -0.0003032405424164*PriceSeries(Price,index-348,O,L,H,C)
                -0.000317744245121*PriceSeries(Price,index-349,O,L,H,C)
                -0.000322431404990*PriceSeries(Price,index-350,O,L,H,C)
                -0.000317421178264*PriceSeries(Price,index-351,O,L,H,C)
                -0.0003031171776816*PriceSeries(Price,index-352,O,L,H,C)
                -0.0002801877574880*PriceSeries(Price,index-353,O,L,H,C)
                -0.0002495389883339*PriceSeries(Price,index-354,O,L,H,C)
                -0.0002122813395186*PriceSeries(Price,index-355,O,L,H,C)
                -0.0001696912446679*PriceSeries(Price,index-356,O,L,H,C)
                -0.0001231688449060*PriceSeries(Price,index-357,O,L,H,C)
                -0.0000741932784808*PriceSeries(Price,index-358,O,L,H,C)
                -0.00002427691670671*PriceSeries(Price,index-359,O,L,H,C)
                +0.00002508006644812*PriceSeries(Price,index-360,O,L,H,C)
                +0.0000724334578652*PriceSeries(Price,index-361,O,L,H,C)
                +0.0001164358610042*PriceSeries(Price,index-362,O,L,H,C)
                +0.0001558735294468*PriceSeries(Price,index-363,O,L,H,C)
                +0.0001896982192045*PriceSeries(Price,index-364,O,L,H,C)
                +0.0002170532791711*PriceSeries(Price,index-365,O,L,H,C)
                +0.0002372933943554*PriceSeries(Price,index-366,O,L,H,C)
                +0.0002499976021556*PriceSeries(Price,index-367,O,L,H,C)
                +0.0002549754114751*PriceSeries(Price,index-368,O,L,H,C)
                +0.0002522660617006*PriceSeries(Price,index-369,O,L,H,C)
                +0.0002421311575629*PriceSeries(Price,index-370,O,L,H,C)
                +0.0002250411012944*PriceSeries(Price,index-371,O,L,H,C)
                +0.0002016559104898*PriceSeries(Price,index-372,O,L,H,C)
                +0.0001728011545448*PriceSeries(Price,index-373,O,L,H,C)
                +0.0001394398611249*PriceSeries(Price,index-374,O,L,H,C)
                +0.0001026413342093*PriceSeries(Price,index-375,O,L,H,C)
                +0.0000635478851015*PriceSeries(Price,index-376,O,L,H,C)
                +0.00002334050648964*PriceSeries(Price,index-377,O,L,H,C)
                -0.00001679548287313*PriceSeries(Price,index-378,O,L,H,C)
                -0.0000557038281655*PriceSeries(Price,index-379,O,L,H,C)
                -0.0000922888299954*PriceSeries(Price,index-380,O,L,H,C)
                -0.0001255440918447*PriceSeries(Price,index-381,O,L,H,C)
                -0.0001545777882915*PriceSeries(Price,index-382,O,L,H,C)
                -0.0001786338479563*PriceSeries(Price,index-383,O,L,H,C)
                -0.0001971085883361*PriceSeries(Price,index-384,O,L,H,C)
                -0.0002095624920060*PriceSeries(Price,index-385,O,L,H,C)
                -0.0002157269698032*PriceSeries(Price,index-386,O,L,H,C)
                -0.0002155061113118*PriceSeries(Price,index-387,O,L,H,C)
                -0.0002089735711550*PriceSeries(Price,index-388,O,L,H,C)
                -0.0001963648766497*PriceSeries(Price,index-389,O,L,H,C)
                -0.0001780655642514*PriceSeries(Price,index-390,O,L,H,C)
                -0.0001545956556801*PriceSeries(Price,index-391,O,L,H,C)
                -0.0001265910673226*PriceSeries(Price,index-392,O,L,H,C)
                -0.0000947826070550*PriceSeries(Price,index-393,O,L,H,C)
                -0.0000599732505523*PriceSeries(Price,index-394,O,L,H,C)
                -0.00002301440486785*PriceSeries(Price,index-395,O,L,H,C)
                +0.00001521813827796*PriceSeries(Price,index-396,O,L,H,C)
                +0.0000538478817181*PriceSeries(Price,index-397,O,L,H,C)
                +0.0000920202986031*PriceSeries(Price,index-398,O,L,H,C)
                +0.0001289239253489*PriceSeries(Price,index-399,O,L,H,C)
                +0.0001638093613514*PriceSeries(Price,index-400,O,L,H,C)
                +0.0001960057439717*PriceSeries(Price,index-401,O,L,H,C)
                +0.0002249343539418*PriceSeries(Price,index-402,O,L,H,C)
                +0.0002501190986731*PriceSeries(Price,index-403,O,L,H,C)
                +0.0002711937170327*PriceSeries(Price,index-404,O,L,H,C)
                +0.0002879056471544*PriceSeries(Price,index-405,O,L,H,C)
                +0.0003001165969154*PriceSeries(Price,index-406,O,L,H,C)
                +0.0003077999528486*PriceSeries(Price,index-407,O,L,H,C)
                +0.0003110352552989*PriceSeries(Price,index-408,O,L,H,C)
                +0.0003100000531273*PriceSeries(Price,index-409,O,L,H,C)
                +0.0003049595275408*PriceSeries(Price,index-410,O,L,H,C)
                +0.0002962543388417*PriceSeries(Price,index-411,O,L,H,C)
                +0.0002842871991781*PriceSeries(Price,index-412,O,L,H,C)
                +0.0002695087061098*PriceSeries(Price,index-413,O,L,H,C)
                +0.0002524029838230*PriceSeries(Price,index-414,O,L,H,C)
                +0.0002334736698116*PriceSeries(Price,index-415,O,L,H,C)
                +0.0002132307546847*PriceSeries(Price,index-416,O,L,H,C)
                +0.0001921787329564*PriceSeries(Price,index-417,O,L,H,C)
                +0.0001708064569455*PriceSeries(Price,index-418,O,L,H,C)
                +0.0001495790110752*PriceSeries(Price,index-419,O,L,H,C)
                +0.0001289318516783*PriceSeries(Price,index-420,O,L,H,C)
                +0.0001092674088914*PriceSeries(Price,index-421,O,L,H,C)
                +0.0000909543636390*PriceSeries(Price,index-422,O,L,H,C)
                +0.0000743299865647*PriceSeries(Price,index-423,O,L,H,C)
                +0.0000597064959614*PriceSeries(Price,index-424,O,L,H,C)
                +0.0000473840723274*PriceSeries(Price,index-425,O,L,H,C)
                +0.0000376784308189*PriceSeries(Price,index-426,O,L,H,C)
                +0.00003098894655353*PriceSeries(Price,index-427,O,L,H,C)
                +0.00002792758969595*PriceSeries(Price,index-428,O,L,H,C)
                -0.0000917070632127*PriceSeries(Price,index-429,O,L,H,C)
                );

      case N39:
         return(
                0.1091876481566*PriceSeries(Price,index,O,L,H,C)
                +0.1081326978355*PriceSeries(Price,index-1,O,L,H,C)
                +0.1060411996452*PriceSeries(Price,index-2,O,L,H,C)
                +0.1029495762226*PriceSeries(Price,index-3,O,L,H,C)
                +0.0989115108948*PriceSeries(Price,index-4,O,L,H,C)
                +0.0939968337288*PriceSeries(Price,index-5,O,L,H,C)
                +0.0882900730699*PriceSeries(Price,index-6,O,L,H,C)
                +0.0818887096554*PriceSeries(Price,index-7,O,L,H,C)
                +0.0749011698947*PriceSeries(Price,index-8,O,L,H,C)
                +0.0674446053120*PriceSeries(Price,index-9,O,L,H,C)
                +0.0596425072557*PriceSeries(Price,index-10,O,L,H,C)
                +0.0516222106986*PriceSeries(Price,index-11,O,L,H,C)
                +0.0435123436467*PriceSeries(Price,index-12,O,L,H,C)
                +0.0354402746940*PriceSeries(Price,index-13,O,L,H,C)
                +0.02752962384210*PriceSeries(Price,index-14,O,L,H,C)
                +0.01989787714545*PriceSeries(Price,index-15,O,L,H,C)
                +0.01265417363924*PriceSeries(Price,index-16,O,L,H,C)
                +0.00589729305553*PriceSeries(Price,index-17,O,L,H,C)
                -0.0002860944311721*PriceSeries(Price,index-18,O,L,H,C)
                -0.00582290035895*PriceSeries(Price,index-19,O,L,H,C)
                -0.01065476338992*PriceSeries(Price,index-20,O,L,H,C)
                -0.01473886809894*PriceSeries(Price,index-21,O,L,H,C)
                -0.01804840109459*PriceSeries(Price,index-22,O,L,H,C)
                -0.02057266385038*PriceSeries(Price,index-23,O,L,H,C)
                -0.02231682292162*PriceSeries(Price,index-24,O,L,H,C)
                -0.02330132886860*PriceSeries(Price,index-25,O,L,H,C)
                -0.02356100709818*PriceSeries(Price,index-26,O,L,H,C)
                -0.02314386099780*PriceSeries(Price,index-27,O,L,H,C)
                -0.02210960772201*PriceSeries(Price,index-28,O,L,H,C)
                -0.02052799789021*PriceSeries(Price,index-29,O,L,H,C)
                -0.01847694879774*PriceSeries(Price,index-30,O,L,H,C)
                -0.01604055243649*PriceSeries(Price,index-31,O,L,H,C)
                -0.01330699247040*PriceSeries(Price,index-32,O,L,H,C)
                -0.01036643445147*PriceSeries(Price,index-33,O,L,H,C)
                -0.00730892451148*PriceSeries(Price,index-34,O,L,H,C)
                -0.00422236254772*PriceSeries(Price,index-35,O,L,H,C)
                -0.001190573899485*PriceSeries(Price,index-36,O,L,H,C)
                +0.001708451108652*PriceSeries(Price,index-37,O,L,H,C)
                +0.00440414258711*PriceSeries(Price,index-38,O,L,H,C)
                +0.00683469552565*PriceSeries(Price,index-39,O,L,H,C)
                +0.00894818114497*PriceSeries(Price,index-40,O,L,H,C)
                +0.01070337148398*PriceSeries(Price,index-41,O,L,H,C)
                +0.01207029749509*PriceSeries(Price,index-42,O,L,H,C)
                +0.01303050132922*PriceSeries(Price,index-43,O,L,H,C)
                +0.01357701949762*PriceSeries(Price,index-44,O,L,H,C)
                +0.01371406958673*PriceSeries(Price,index-45,O,L,H,C)
                +0.01345649008596*PriceSeries(Price,index-46,O,L,H,C)
                +0.01282892331570*PriceSeries(Price,index-47,O,L,H,C)
                +0.01186479610244*PriceSeries(Price,index-48,O,L,H,C)
                +0.01060510502945*PriceSeries(Price,index-49,O,L,H,C)
                +0.00909706402449*PriceSeries(Price,index-50,O,L,H,C)
                +0.00739263054195*PriceSeries(Price,index-51,O,L,H,C)
                +0.00554697329827*PriceSeries(Price,index-52,O,L,H,C)
                +0.00361689842068*PriceSeries(Price,index-53,O,L,H,C)
                +0.001659297789595*PriceSeries(Price,index-54,O,L,H,C)
                -0.0002703628078730*PriceSeries(Price,index-55,O,L,H,C)
                -0.002119457901193*PriceSeries(Price,index-56,O,L,H,C)
                -0.00383950734324*PriceSeries(Price,index-57,O,L,H,C)
                -0.00538731704701*PriceSeries(Price,index-58,O,L,H,C)
                -0.00672595936494*PriceSeries(Price,index-59,O,L,H,C)
                -0.00782553969840*PriceSeries(Price,index-60,O,L,H,C)
                -0.00866377160928*PriceSeries(Price,index-61,O,L,H,C)
                -0.00922631384263*PriceSeries(Price,index-62,O,L,H,C)
                -0.00950690357402*PriceSeries(Price,index-63,O,L,H,C)
                -0.00950725286199*PriceSeries(Price,index-64,O,L,H,C)
                -0.00923675362762*PriceSeries(Price,index-65,O,L,H,C)
                -0.00871196735713*PriceSeries(Price,index-66,O,L,H,C)
                -0.00795595628195*PriceSeries(Price,index-67,O,L,H,C)
                -0.00699744267835*PriceSeries(Price,index-68,O,L,H,C)
                -0.00586985592481*PriceSeries(Price,index-69,O,L,H,C)
                -0.00461026764104*PriceSeries(Price,index-70,O,L,H,C)
                -0.00325826977934*PriceSeries(Price,index-71,O,L,H,C)
                -0.001854807867740*PriceSeries(Price,index-72,O,L,H,C)
                -0.000441020111074*PriceSeries(Price,index-73,O,L,H,C)
                +0.000942905590265*PriceSeries(Price,index-74,O,L,H,C)
                +0.002258806632997*PriceSeries(Price,index-75,O,L,H,C)
                +0.00347154434997*PriceSeries(Price,index-76,O,L,H,C)
                +0.00454988414395*PriceSeries(Price,index-77,O,L,H,C)
                +0.00546725243639*PriceSeries(Price,index-78,O,L,H,C)
                +0.00620233699022*PriceSeries(Price,index-79,O,L,H,C)
                +0.00673953582959*PriceSeries(Price,index-80,O,L,H,C)
                +0.00706922593789*PriceSeries(Price,index-81,O,L,H,C)
                +0.00718787374152*PriceSeries(Price,index-82,O,L,H,C)
                +0.00709796042908*PriceSeries(Price,index-83,O,L,H,C)
                +0.00680775734664*PriceSeries(Price,index-84,O,L,H,C)
                +0.00633093441320*PriceSeries(Price,index-85,O,L,H,C)
                +0.00568604229389*PriceSeries(Price,index-86,O,L,H,C)
                +0.00489585962972*PriceSeries(Price,index-87,O,L,H,C)
                +0.00398665351916*PriceSeries(Price,index-88,O,L,H,C)
                +0.002987348546525*PriceSeries(Price,index-89,O,L,H,C)
                +0.001928656028861*PriceSeries(Price,index-90,O,L,H,C)
                +0.000842164229193*PriceSeries(Price,index-91,O,L,H,C)
                -0.0002405649091648*PriceSeries(Price,index-92,O,L,H,C)
                -0.001288880739521*PriceSeries(Price,index-93,O,L,H,C)
                -0.002273878903811*PriceSeries(Price,index-94,O,L,H,C)
                -0.00316916971699*PriceSeries(Price,index-95,O,L,H,C)
                -0.00395155511095*PriceSeries(Price,index-96,O,L,H,C)
                -0.00460160231170*PriceSeries(Price,index-97,O,L,H,C)
                -0.00510409726369*PriceSeries(Price,index-98,O,L,H,C)
                -0.00544836984915*PriceSeries(Price,index-99,O,L,H,C)
                -0.00562848451197*PriceSeries(Price,index-100,O,L,H,C)
                -0.00564329331980*PriceSeries(Price,index-101,O,L,H,C)
                -0.00549635344225*PriceSeries(Price,index-102,O,L,H,C)
                -0.00519571749306*PriceSeries(Price,index-103,O,L,H,C)
                -0.00475359738810*PriceSeries(Price,index-104,O,L,H,C)
                -0.00418592572919*PriceSeries(Price,index-105,O,L,H,C)
                -0.00351181713750*PriceSeries(Price,index-106,O,L,H,C)
                -0.002752957356914*PriceSeries(Price,index-107,O,L,H,C)
                -0.001932929840904*PriceSeries(Price,index-108,O,L,H,C)
                -0.001076508313394*PriceSeries(Price,index-109,O,L,H,C)
                -0.0002089278882764*PriceSeries(Price,index-110,O,L,H,C)
                +0.000644836054271*PriceSeries(Price,index-111,O,L,H,C)
                +0.001460769965067*PriceSeries(Price,index-112,O,L,H,C)
                +0.002216478513346*PriceSeries(Price,index-113,O,L,H,C)
                +0.002891780374527*PriceSeries(Price,index-114,O,L,H,C)
                +0.00346923245206*PriceSeries(Price,index-115,O,L,H,C)
                +0.00393455927140*PriceSeries(Price,index-116,O,L,H,C)
                +0.00427699028964*PriceSeries(Price,index-117,O,L,H,C)
                +0.00448948389422*PriceSeries(Price,index-118,O,L,H,C)
                +0.00456884887465*PriceSeries(Price,index-119,O,L,H,C)
                +0.00451574631467*PriceSeries(Price,index-120,O,L,H,C)
                +0.00433459180907*PriceSeries(Price,index-121,O,L,H,C)
                +0.00403334288667*PriceSeries(Price,index-122,O,L,H,C)
                +0.00362320295552*PriceSeries(Price,index-123,O,L,H,C)
                +0.003118228517685*PriceSeries(Price,index-124,O,L,H,C)
                +0.002534872440375*PriceSeries(Price,index-125,O,L,H,C)
                +0.001891463754951*PriceSeries(Price,index-126,O,L,H,C)
                +0.001207649312478*PriceSeries(Price,index-127,O,L,H,C)
                +0.000503806068165*PriceSeries(Price,index-128,O,L,H,C)
                -0.0001995507610038*PriceSeries(Price,index-129,O,L,H,C)
                -0.000882355804230*PriceSeries(Price,index-130,O,L,H,C)
                -0.001525551053005*PriceSeries(Price,index-131,O,L,H,C)
                -0.002111608833872*PriceSeries(Price,index-132,O,L,H,C)
                -0.002624995868716*PriceSeries(Price,index-133,O,L,H,C)
                -0.003052575174676*PriceSeries(Price,index-134,O,L,H,C)
                -0.00338392601227*PriceSeries(Price,index-135,O,L,H,C)
                -0.00361158954809*PriceSeries(Price,index-136,O,L,H,C)
                -0.00373121241044*PriceSeries(Price,index-137,O,L,H,C)
                -0.00374161429329*PriceSeries(Price,index-138,O,L,H,C)
                -0.00364474793639*PriceSeries(Price,index-139,O,L,H,C)
                -0.00344558763039*PriceSeries(Price,index-140,O,L,H,C)
                -0.003151917628733*PriceSeries(Price,index-141,O,L,H,C)
                -0.002774061303355*PriceSeries(Price,index-142,O,L,H,C)
                -0.002324526523781*PriceSeries(Price,index-143,O,L,H,C)
                -0.001817615614836*PriceSeries(Price,index-144,O,L,H,C)
                -0.001268970931871*PriceSeries(Price,index-145,O,L,H,C)
                -0.000695111951990*PriceSeries(Price,index-146,O,L,H,C)
                -0.0001129392769344*PriceSeries(Price,index-147,O,L,H,C)
                +0.000460747739438*PriceSeries(Price,index-148,O,L,H,C)
                +0.001009733421012*PriceSeries(Price,index-149,O,L,H,C)
                +0.001518830451149*PriceSeries(Price,index-150,O,L,H,C)
                +0.001974297492657*PriceSeries(Price,index-151,O,L,H,C)
                +0.002364195535491*PriceSeries(Price,index-152,O,L,H,C)
                +0.002678698585030*PriceSeries(Price,index-153,O,L,H,C)
                +0.002910325900744*PriceSeries(Price,index-154,O,L,H,C)
                +0.003054112761739*PriceSeries(Price,index-155,O,L,H,C)
                +0.003107697659972*PriceSeries(Price,index-156,O,L,H,C)
                +0.003071343675761*PriceSeries(Price,index-157,O,L,H,C)
                +0.002947871113528*PriceSeries(Price,index-158,O,L,H,C)
                +0.002742535697319*PriceSeries(Price,index-159,O,L,H,C)
                +0.002462820035555*PriceSeries(Price,index-160,O,L,H,C)
                +0.002118187530787*PriceSeries(Price,index-161,O,L,H,C)
                +0.001719762176968*PriceSeries(Price,index-162,O,L,H,C)
                +0.001279988886442*PriceSeries(Price,index-163,O,L,H,C)
                +0.000812242485510*PriceSeries(Price,index-164,O,L,H,C)
                +0.000330439099600*PriceSeries(Price,index-165,O,L,H,C)
                -0.0001513841005921*PriceSeries(Price,index-166,O,L,H,C)
                -0.000619458946925*PriceSeries(Price,index-167,O,L,H,C)
                -0.001060685180165*PriceSeries(Price,index-168,O,L,H,C)
                -0.001462981391595*PriceSeries(Price,index-169,O,L,H,C)
                -0.001815618032983*PriceSeries(Price,index-170,O,L,H,C)
                -0.002109490261686*PriceSeries(Price,index-171,O,L,H,C)
                -0.002337351820644*PriceSeries(Price,index-172,O,L,H,C)
                -0.002493979390035*PriceSeries(Price,index-173,O,L,H,C)
                -0.002576289309951*PriceSeries(Price,index-174,O,L,H,C)
                -0.002583376546886*PriceSeries(Price,index-175,O,L,H,C)
                -0.002516503766005*PriceSeries(Price,index-176,O,L,H,C)
                -0.002379019043182*PriceSeries(Price,index-177,O,L,H,C)
                -0.002176223392401*PriceSeries(Price,index-178,O,L,H,C)
                -0.001915176649068*PriceSeries(Price,index-179,O,L,H,C)
                -0.001604467901394*PriceSeries(Price,index-180,O,L,H,C)
                -0.001253932833294*PriceSeries(Price,index-181,O,L,H,C)
                -0.000874358276689*PriceSeries(Price,index-182,O,L,H,C)
                -0.000477145066947*PriceSeries(Price,index-183,O,L,H,C)
                -0.0000739808854121*PriceSeries(Price,index-184,O,L,H,C)
                +0.000323507830092*PriceSeries(Price,index-185,O,L,H,C)
                +0.000704077895701*PriceSeries(Price,index-186,O,L,H,C)
                +0.001057193098262*PriceSeries(Price,index-187,O,L,H,C)
                +0.001373299624608*PriceSeries(Price,index-188,O,L,H,C)
                +0.001644091291816*PriceSeries(Price,index-189,O,L,H,C)
                +0.001862712084591*PriceSeries(Price,index-190,O,L,H,C)
                +0.002023932515258*PriceSeries(Price,index-191,O,L,H,C)
                +0.002124260690251*PriceSeries(Price,index-192,O,L,H,C)
                +0.002162012286156*PriceSeries(Price,index-193,O,L,H,C)
                +0.002137321072801*PriceSeries(Price,index-194,O,L,H,C)
                +0.002052102723771*PriceSeries(Price,index-195,O,L,H,C)
                +0.001909961249522*PriceSeries(Price,index-196,O,L,H,C)
                +0.001716057282656*PriceSeries(Price,index-197,O,L,H,C)
                +0.001476928365130*PriceSeries(Price,index-198,O,L,H,C)
                +0.001200275870694*PriceSeries(Price,index-199,O,L,H,C)
                +0.000894722544913*PriceSeries(Price,index-200,O,L,H,C)
                +0.000569548669769*PriceSeries(Price,index-201,O,L,H,C)
                +0.0002344131562852*PriceSeries(Price,index-202,O,L,H,C)
                -0.0001009264879385*PriceSeries(Price,index-203,O,L,H,C)
                -0.000426900337188*PriceSeries(Price,index-204,O,L,H,C)
                -0.000734388705215*PriceSeries(Price,index-205,O,L,H,C)
                -0.001014979393836*PriceSeries(Price,index-206,O,L,H,C)
                -0.001261190059614*PriceSeries(Price,index-207,O,L,H,C)
                -0.001466667643649*PriceSeries(Price,index-208,O,L,H,C)
                -0.001626342041801*PriceSeries(Price,index-209,O,L,H,C)
                -0.001736552599635*PriceSeries(Price,index-210,O,L,H,C)
                -0.001795117985438*PriceSeries(Price,index-211,O,L,H,C)
                -0.001801376135993*PriceSeries(Price,index-212,O,L,H,C)
                -0.001756168021315*PriceSeries(Price,index-213,O,L,H,C)
                -0.001661786521639*PriceSeries(Price,index-214,O,L,H,C)
                -0.001521883934414*PriceSeries(Price,index-215,O,L,H,C)
                -0.001341337714025*PriceSeries(Price,index-216,O,L,H,C)
                -0.001126089794113*PriceSeries(Price,index-217,O,L,H,C)
                -0.000882954569147*PriceSeries(Price,index-218,O,L,H,C)
                -0.000619409563012*PriceSeries(Price,index-219,O,L,H,C)
                -0.000343364621687*PriceSeries(Price,index-220,O,L,H,C)
                -0.0000629336426783*PriceSeries(Price,index-221,O,L,H,C)
                +0.0002138078701694*PriceSeries(Price,index-222,O,L,H,C)
                +0.000479044936741*PriceSeries(Price,index-223,O,L,H,C)
                +0.000725447769532*PriceSeries(Price,index-224,O,L,H,C)
                +0.000946367437514*PriceSeries(Price,index-225,O,L,H,C)
                +0.001136012266106*PriceSeries(Price,index-226,O,L,H,C)
                +0.001289597037763*PriceSeries(Price,index-227,O,L,H,C)
                +0.001403460117812*PriceSeries(Price,index-228,O,L,H,C)
                +0.001475143275322*PriceSeries(Price,index-229,O,L,H,C)
                +0.001503439886530*PriceSeries(Price,index-230,O,L,H,C)
                +0.001488403587120*PriceSeries(Price,index-231,O,L,H,C)
                +0.001431321538988*PriceSeries(Price,index-232,O,L,H,C)
                +0.001334653992821*PriceSeries(Price,index-233,O,L,H,C)
                +0.001201939017131*PriceSeries(Price,index-234,O,L,H,C)
                +0.001037670539694*PriceSeries(Price,index-235,O,L,H,C)
                +0.000847154685854*PriceSeries(Price,index-236,O,L,H,C)
                +0.000636333958158*PriceSeries(Price,index-237,O,L,H,C)
                +0.000411615014031*PriceSeries(Price,index-238,O,L,H,C)
                +0.0001796677153123*PriceSeries(Price,index-239,O,L,H,C)
                -0.0000527620683947*PriceSeries(Price,index-240,O,L,H,C)
                -0.0002790555492771*PriceSeries(Price,index-241,O,L,H,C)
                -0.000492896218582*PriceSeries(Price,index-242,O,L,H,C)
                -0.000688456149030*PriceSeries(Price,index-243,O,L,H,C)
                -0.000860537705292*PriceSeries(Price,index-244,O,L,H,C)
                -0.001004725357608*PriceSeries(Price,index-245,O,L,H,C)
                -0.001117479890850*PriceSeries(Price,index-246,O,L,H,C)
                -0.001196232754906*PriceSeries(Price,index-247,O,L,H,C)
                -0.001239432663487*PriceSeries(Price,index-248,O,L,H,C)
                -0.001246574528334*PriceSeries(Price,index-249,O,L,H,C)
                -0.001218185560429*PriceSeries(Price,index-250,O,L,H,C)
                -0.001155796886833*PriceSeries(Price,index-251,O,L,H,C)
                -0.001061871976917*PriceSeries(Price,index-252,O,L,H,C)
                -0.000939724101177*PriceSeries(Price,index-253,O,L,H,C)
                -0.000793398627309*PriceSeries(Price,index-254,O,L,H,C)
                -0.000627546314873*PriceSeries(Price,index-255,O,L,H,C)
                -0.000447276998472*PriceSeries(Price,index-256,O,L,H,C)
                -0.0002580075726098*PriceSeries(Price,index-257,O,L,H,C)
                -0.0000652930190217*PriceSeries(Price,index-258,O,L,H,C)
                +0.0001253208824334*PriceSeries(Price,index-259,O,L,H,C)
                +0.0003084704214071*PriceSeries(Price,index-260,O,L,H,C)
                +0.000479108312345*PriceSeries(Price,index-261,O,L,H,C)
                +0.000632654941780*PriceSeries(Price,index-262,O,L,H,C)
                +0.000765104113100*PriceSeries(Price,index-263,O,L,H,C)
                +0.000873140144175*PriceSeries(Price,index-264,O,L,H,C)
                +0.000954201066108*PriceSeries(Price,index-265,O,L,H,C)
                +0.001006556020606*PriceSeries(Price,index-266,O,L,H,C)
                +0.001029313303421*PriceSeries(Price,index-267,O,L,H,C)
                +0.001022450256944*PriceSeries(Price,index-268,O,L,H,C)
                +0.000986779099480*PriceSeries(Price,index-269,O,L,H,C)
                +0.000923917483146*PriceSeries(Price,index-270,O,L,H,C)
                +0.000836215563252*PriceSeries(Price,index-271,O,L,H,C)
                +0.000726683927979*PriceSeries(Price,index-272,O,L,H,C)
                +0.000598883822332*PriceSeries(Price,index-273,O,L,H,C)
                +0.000456824414682*PriceSeries(Price,index-274,O,L,H,C)
                +0.0003048288501294*PriceSeries(Price,index-275,O,L,H,C)
                +0.0001474134884726*PriceSeries(Price,index-276,O,L,H,C)
                -0.00001084836307989*PriceSeries(Price,index-277,O,L,H,C)
                -0.0001654574725482*PriceSeries(Price,index-278,O,L,H,C)
                -0.0003121169667611*PriceSeries(Price,index-279,O,L,H,C)
                -0.000446841261707*PriceSeries(Price,index-280,O,L,H,C)
                -0.000566076649396*PriceSeries(Price,index-281,O,L,H,C)
                -0.000666776816887*PriceSeries(Price,index-282,O,L,H,C)
                -0.000746494823540*PriceSeries(Price,index-283,O,L,H,C)
                -0.000803422590265*PriceSeries(Price,index-284,O,L,H,C)
                -0.000836444468900*PriceSeries(Price,index-285,O,L,H,C)
                -0.000845138839735*PriceSeries(Price,index-286,O,L,H,C)
                -0.000829792056986*PriceSeries(Price,index-287,O,L,H,C)
                -0.000791351571514*PriceSeries(Price,index-288,O,L,H,C)
                -0.000731411990689*PriceSeries(Price,index-289,O,L,H,C)
                -0.000652130879840*PriceSeries(Price,index-290,O,L,H,C)
                -0.000556172742368*PriceSeries(Price,index-291,O,L,H,C)
                -0.000446610372718*PriceSeries(Price,index-292,O,L,H,C)
                -0.000326838082494*PriceSeries(Price,index-293,O,L,H,C)
                -0.0002004607812769*PriceSeries(Price,index-294,O,L,H,C)
                -0.0000711938995511*PriceSeries(Price,index-295,O,L,H,C)
                +0.0000572525340450*PriceSeries(Price,index-296,O,L,H,C)
                +0.0001812689771974*PriceSeries(Price,index-297,O,L,H,C)
                +0.0002974525495372*PriceSeries(Price,index-298,O,L,H,C)
                +0.000402700618656*PriceSeries(Price,index-299,O,L,H,C)
                +0.000494284679975*PriceSeries(Price,index-300,O,L,H,C)
                +0.000569923644405*PriceSeries(Price,index-301,O,L,H,C)
                +0.000627840702448*PriceSeries(Price,index-302,O,L,H,C)
                +0.000666794507605*PriceSeries(Price,index-303,O,L,H,C)
                +0.000686113076942*PriceSeries(Price,index-304,O,L,H,C)
                +0.000685686284437*PriceSeries(Price,index-305,O,L,H,C)
                +0.000665970523205*PriceSeries(Price,index-306,O,L,H,C)
                +0.000627952058455*PriceSeries(Price,index-307,O,L,H,C)
                +0.000573115349433*PriceSeries(Price,index-308,O,L,H,C)
                +0.000503377247159*PriceSeries(Price,index-309,O,L,H,C)
                +0.000421044845595*PriceSeries(Price,index-310,O,L,H,C)
                +0.000328714615343*PriceSeries(Price,index-311,O,L,H,C)
                +0.0002292154757426*PriceSeries(Price,index-312,O,L,H,C)
                +0.0001255083649522*PriceSeries(Price,index-313,O,L,H,C)
                +0.00002060851032136*PriceSeries(Price,index-314,O,L,H,C)
                -0.0000825040854857*PriceSeries(Price,index-315,O,L,H,C)
                -0.0001809700685026*PriceSeries(Price,index-316,O,L,H,C)
                -0.0002721251554806*PriceSeries(Price,index-317,O,L,H,C)
                -0.000353569776152*PriceSeries(Price,index-318,O,L,H,C)
                -0.000423233941885*PriceSeries(Price,index-319,O,L,H,C)
                -0.000479431364406*PriceSeries(Price,index-320,O,L,H,C)
                -0.000520882547742*PriceSeries(Price,index-321,O,L,H,C)
                -0.000546763120950*PriceSeries(Price,index-322,O,L,H,C)
                -0.000556697628289*PriceSeries(Price,index-323,O,L,H,C)
                -0.000550772141853*PriceSeries(Price,index-324,O,L,H,C)
                -0.000529514474915*PriceSeries(Price,index-325,O,L,H,C)
                -0.000493868690548*PriceSeries(Price,index-326,O,L,H,C)
                -0.000445165745711*PriceSeries(Price,index-327,O,L,H,C)
                -0.000385070662597*PriceSeries(Price,index-328,O,L,H,C)
                -0.0003155268131650*PriceSeries(Price,index-329,O,L,H,C)
                -0.0002386997436753*PriceSeries(Price,index-330,O,L,H,C)
                -0.0001569144271998*PriceSeries(Price,index-331,O,L,H,C)
                -0.0000725700424983*PriceSeries(Price,index-332,O,L,H,C)
                +0.00001190695000004*PriceSeries(Price,index-333,O,L,H,C)
                +0.0000941498751159*PriceSeries(Price,index-334,O,L,H,C)
                +0.0001719048983617*PriceSeries(Price,index-335,O,L,H,C)
                +0.0002430949735219*PriceSeries(Price,index-336,O,L,H,C)
                +0.0003058820594497*PriceSeries(Price,index-337,O,L,H,C)
                +0.000358693913022*PriceSeries(Price,index-338,O,L,H,C)
                +0.000400280427871*PriceSeries(Price,index-339,O,L,H,C)
                +0.000429730982243*PriceSeries(Price,index-340,O,L,H,C)
                +0.000446499570198*PriceSeries(Price,index-341,O,L,H,C)
                +0.000450391536014*PriceSeries(Price,index-342,O,L,H,C)
                +0.000441597296365*PriceSeries(Price,index-343,O,L,H,C)
                +0.000420633795644*PriceSeries(Price,index-344,O,L,H,C)
                +0.000388365811131*PriceSeries(Price,index-345,O,L,H,C)
                +0.000345934806571*PriceSeries(Price,index-346,O,L,H,C)
                +0.0002947509709604*PriceSeries(Price,index-347,O,L,H,C)
                +0.0002364336268319*PriceSeries(Price,index-348,O,L,H,C)
                +0.0001727634080011*PriceSeries(Price,index-349,O,L,H,C)
                +0.0001056238805641*PriceSeries(Price,index-350,O,L,H,C)
                +0.0000369658168320*PriceSeries(Price,index-351,O,L,H,C)
                -0.00003127007062171*PriceSeries(Price,index-352,O,L,H,C)
                -0.0000971987728800*PriceSeries(Price,index-353,O,L,H,C)
                -0.0001590317886797*PriceSeries(Price,index-354,O,L,H,C)
                -0.0002151417390301*PriceSeries(Price,index-355,O,L,H,C)
                -0.0002640853027226*PriceSeries(Price,index-356,O,L,H,C)
                -0.0003046529416772*PriceSeries(Price,index-357,O,L,H,C)
                -0.000335896112506*PriceSeries(Price,index-358,O,L,H,C)
                -0.000357122797381*PriceSeries(Price,index-359,O,L,H,C)
                -0.000367952601212*PriceSeries(Price,index-360,O,L,H,C)
                -0.000368282774399*PriceSeries(Price,index-361,O,L,H,C)
                -0.000358306482653*PriceSeries(Price,index-362,O,L,H,C)
                -0.000338479320235*PriceSeries(Price,index-363,O,L,H,C)
                -0.0003095429347168*PriceSeries(Price,index-364,O,L,H,C)
                -0.0002724351626605*PriceSeries(Price,index-365,O,L,H,C)
                -0.0002283368034798*PriceSeries(Price,index-366,O,L,H,C)
                -0.0001785514905133*PriceSeries(Price,index-367,O,L,H,C)
                -0.0001245526283810*PriceSeries(Price,index-368,O,L,H,C)
                -0.0000678756364783*PriceSeries(Price,index-369,O,L,H,C)
                -0.00001010656242049*PriceSeries(Price,index-370,O,L,H,C)
                +0.0000471693527705*PriceSeries(Price,index-371,O,L,H,C)
                +0.0001023895164413*PriceSeries(Price,index-372,O,L,H,C)
                +0.0001540945182234*PriceSeries(Price,index-373,O,L,H,C)
                +0.0002009238784496*PriceSeries(Price,index-374,O,L,H,C)
                +0.0002416643667318*PriceSeries(Price,index-375,O,L,H,C)
                +0.0002752859798086*PriceSeries(Price,index-376,O,L,H,C)
                +0.0003009381396499*PriceSeries(Price,index-377,O,L,H,C)
                +0.000318008171270*PriceSeries(Price,index-378,O,L,H,C)
                +0.000326085980098*PriceSeries(Price,index-379,O,L,H,C)
                +0.000324981575073*PriceSeries(Price,index-380,O,L,H,C)
                +0.0003147654065729*PriceSeries(Price,index-381,O,L,H,C)
                +0.0002956883059742*PriceSeries(Price,index-382,O,L,H,C)
                +0.0002682253230440*PriceSeries(Price,index-383,O,L,H,C)
                +0.0002330272208091*PriceSeries(Price,index-384,O,L,H,C)
                +0.0001909361892323*PriceSeries(Price,index-385,O,L,H,C)
                +0.0001428910660666*PriceSeries(Price,index-386,O,L,H,C)
                +0.0000900015065908*PriceSeries(Price,index-387,O,L,H,C)
                +0.0000333843615045*PriceSeries(Price,index-388,O,L,H,C)
                -0.00002569410200890*PriceSeries(Price,index-389,O,L,H,C)
                -0.0000860327648501*PriceSeries(Price,index-390,O,L,H,C)
                -0.0001463949447652*PriceSeries(Price,index-391,O,L,H,C)
                -0.0002055822157687*PriceSeries(Price,index-392,O,L,H,C)
                -0.0002624558445354*PriceSeries(Price,index-393,O,L,H,C)
                -0.0003159941853037*PriceSeries(Price,index-394,O,L,H,C)
                -0.000365247161788*PriceSeries(Price,index-395,O,L,H,C)
                -0.000409407868887*PriceSeries(Price,index-396,O,L,H,C)
                -0.000447812538795*PriceSeries(Price,index-397,O,L,H,C)
                -0.000479920912879*PriceSeries(Price,index-398,O,L,H,C)
                -0.000505415542850*PriceSeries(Price,index-399,O,L,H,C)
                -0.000524025451677*PriceSeries(Price,index-400,O,L,H,C)
                -0.000535722315879*PriceSeries(Price,index-401,O,L,H,C)
                -0.000540617995424*PriceSeries(Price,index-402,O,L,H,C)
                -0.000538900704051*PriceSeries(Price,index-403,O,L,H,C)
                -0.000530936675761*PriceSeries(Price,index-404,O,L,H,C)
                -0.000517186923296*PriceSeries(Price,index-405,O,L,H,C)
                -0.000498218351439*PriceSeries(Price,index-406,O,L,H,C)
                -0.000474631169669*PriceSeries(Price,index-407,O,L,H,C)
                -0.000447149219761*PriceSeries(Price,index-408,O,L,H,C)
                -0.000416415504347*PriceSeries(Price,index-409,O,L,H,C)
                -0.000383327118179*PriceSeries(Price,index-410,O,L,H,C)
                -0.000348446865785*PriceSeries(Price,index-411,O,L,H,C)
                -0.0003126049419290*PriceSeries(Price,index-412,O,L,H,C)
                -0.0002765016665473*PriceSeries(Price,index-413,O,L,H,C)
                -0.0002407594595201*PriceSeries(Price,index-414,O,L,H,C)
                -0.0002059490076136*PriceSeries(Price,index-415,O,L,H,C)
                -0.0001726311272638*PriceSeries(Price,index-416,O,L,H,C)
                -0.0001412479204065*PriceSeries(Price,index-417,O,L,H,C)
                -0.0001121632060580*PriceSeries(Price,index-418,O,L,H,C)
                -0.0000856879781624*PriceSeries(Price,index-419,O,L,H,C)
                -0.0000618056319169*PriceSeries(Price,index-420,O,L,H,C)
                -0.0000411660103051*PriceSeries(Price,index-421,O,L,H,C)
                -0.00002319802665658*PriceSeries(Price,index-422,O,L,H,C)
                -0.00000818758744272*PriceSeries(Price,index-423,O,L,H,C)
                +0.00000385135875795*PriceSeries(Price,index-424,O,L,H,C)
                +0.00001315228805165*PriceSeries(Price,index-425,O,L,H,C)
                +0.00001994865234245*PriceSeries(Price,index-426,O,L,H,C)
                +0.00002447630553096*PriceSeries(Price,index-427,O,L,H,C)
                +0.00002693716469052*PriceSeries(Price,index-428,O,L,H,C)
                +0.00002758996577963*PriceSeries(Price,index-429,O,L,H,C)
                +0.00002669232091880*PriceSeries(Price,index-430,O,L,H,C)
                +0.0001234954420479*PriceSeries(Price,index-431,O,L,H,C)
                );

      case N40:
         return(
                0.1016391451935*PriceSeries(Price,index,O,L,H,C)
                +0.1011561693900*PriceSeries(Price,index-1,O,L,H,C)
                +0.0997155330511*PriceSeries(Price,index-2,O,L,H,C)
                +0.0973419380943*PriceSeries(Price,index-3,O,L,H,C)
                +0.0940759910275*PriceSeries(Price,index-4,O,L,H,C)
                +0.0899733721029*PriceSeries(Price,index-5,O,L,H,C)
                +0.0851036973393*PriceSeries(Price,index-6,O,L,H,C)
                +0.0795490996571*PriceSeries(Price,index-7,O,L,H,C)
                +0.0734025610232*PriceSeries(Price,index-8,O,L,H,C)
                +0.0667660333456*PriceSeries(Price,index-9,O,L,H,C)
                +0.0597483869304*PriceSeries(Price,index-10,O,L,H,C)
                +0.0524632357421*PriceSeries(Price,index-11,O,L,H,C)
                +0.0450266857043*PriceSeries(Price,index-12,O,L,H,C)
                +0.0375550539374*PriceSeries(Price,index-13,O,L,H,C)
                +0.03016261106859*PriceSeries(Price,index-14,O,L,H,C)
                +0.02295939430914*PriceSeries(Price,index-15,O,L,H,C)
                +0.01604913834940*PriceSeries(Price,index-16,O,L,H,C)
                +0.00952736600511*PriceSeries(Price,index-17,O,L,H,C)
                +0.00347968165482*PriceSeries(Price,index-18,O,L,H,C)
                -0.002019699730248*PriceSeries(Price,index-19,O,L,H,C)
                -0.00690916032368*PriceSeries(Price,index-20,O,L,H,C)
                -0.01114059788610*PriceSeries(Price,index-21,O,L,H,C)
                -0.01468004150041*PriceSeries(Price,index-22,O,L,H,C)
                -0.01750795513845*PriceSeries(Price,index-23,O,L,H,C)
                -0.01961922798166*PriceSeries(Price,index-24,O,L,H,C)
                -0.02102285517572*PriceSeries(Price,index-25,O,L,H,C)
                -0.02174132348270*PriceSeries(Price,index-26,O,L,H,C)
                -0.02180972183660*PriceSeries(Price,index-27,O,L,H,C)
                -0.02127459820437*PriceSeries(Price,index-28,O,L,H,C)
                -0.02019259705894*PriceSeries(Price,index-29,O,L,H,C)
                -0.01862891153396*PriceSeries(Price,index-30,O,L,H,C)
                -0.01665558868468*PriceSeries(Price,index-31,O,L,H,C)
                -0.01434972905688*PriceSeries(Price,index-32,O,L,H,C)
                -0.01179162487650*PriceSeries(Price,index-33,O,L,H,C)
                -0.00906288130109*PriceSeries(Price,index-34,O,L,H,C)
                -0.00624456096796*PriceSeries(Price,index-35,O,L,H,C)
                -0.00341539813015*PriceSeries(Price,index-36,O,L,H,C)
                -0.000650119934591*PriceSeries(Price,index-37,O,L,H,C)
                +0.001982089826468*PriceSeries(Price,index-38,O,L,H,C)
                +0.00441895083767*PriceSeries(Price,index-39,O,L,H,C)
                +0.00660624315530*PriceSeries(Price,index-40,O,L,H,C)
                +0.00849873879225*PriceSeries(Price,index-41,O,L,H,C)
                +0.01006089447598*PriceSeries(Price,index-42,O,L,H,C)
                +0.01126729152958*PriceSeries(Price,index-43,O,L,H,C)
                +0.01210282168823*PriceSeries(Price,index-44,O,L,H,C)
                +0.01256262235411*PriceSeries(Price,index-45,O,L,H,C)
                +0.01265176719133*PriceSeries(Price,index-46,O,L,H,C)
                +0.01238472821759*PriceSeries(Price,index-47,O,L,H,C)
                +0.01178462822465*PriceSeries(Price,index-48,O,L,H,C)
                +0.01088230891703*PriceSeries(Price,index-49,O,L,H,C)
                +0.00971523979504*PriceSeries(Price,index-50,O,L,H,C)
                +0.00832630186269*PriceSeries(Price,index-51,O,L,H,C)
                +0.00676248033424*PriceSeries(Price,index-52,O,L,H,C)
                +0.00507349772284*PriceSeries(Price,index-53,O,L,H,C)
                +0.00331042623060*PriceSeries(Price,index-54,O,L,H,C)
                +0.001524313459873*PriceSeries(Price,index-55,O,L,H,C)
                -0.0002351441061921*PriceSeries(Price,index-56,O,L,H,C)
                -0.001920849577137*PriceSeries(Price,index-57,O,L,H,C)
                -0.00348944494494*PriceSeries(Price,index-58,O,L,H,C)
                -0.00490231536699*PriceSeries(Price,index-59,O,L,H,C)
                -0.00612644030011*PriceSeries(Price,index-60,O,L,H,C)
                -0.00713506990481*PriceSeries(Price,index-61,O,L,H,C)
                -0.00790821689725*PriceSeries(Price,index-62,O,L,H,C)
                -0.00843295692190*PriceSeries(Price,index-63,O,L,H,C)
                -0.00870353505134*PriceSeries(Price,index-64,O,L,H,C)
                -0.00872128030662*PriceSeries(Price,index-65,O,L,H,C)
                -0.00849433598842*PriceSeries(Price,index-66,O,L,H,C)
                -0.00803722127629*PriceSeries(Price,index-67,O,L,H,C)
                -0.00737023571360*PriceSeries(Price,index-68,O,L,H,C)
                -0.00651872962799*PriceSeries(Price,index-69,O,L,H,C)
                -0.00551226358442*PriceSeries(Price,index-70,O,L,H,C)
                -0.00438368039974*PriceSeries(Price,index-71,O,L,H,C)
                -0.00316811758034*PriceSeries(Price,index-72,O,L,H,C)
                -0.001901987568242*PriceSeries(Price,index-73,O,L,H,C)
                -0.000621955609944*PriceSeries(Price,index-74,O,L,H,C)
                +0.000636061880057*PriceSeries(Price,index-75,O,L,H,C)
                +0.001837848696464*PriceSeries(Price,index-76,O,L,H,C)
                +0.002951765974366*PriceSeries(Price,index-77,O,L,H,C)
                +0.00394953672997*PriceSeries(Price,index-78,O,L,H,C)
                +0.00480691686022*PriceSeries(Price,index-79,O,L,H,C)
                +0.00550423882378*PriceSeries(Price,index-80,O,L,H,C)
                +0.00602681541922*PriceSeries(Price,index-81,O,L,H,C)
                +0.00636519954490*PriceSeries(Price,index-82,O,L,H,C)
                +0.00651529356350*PriceSeries(Price,index-83,O,L,H,C)
                +0.00647830989295*PriceSeries(Price,index-84,O,L,H,C)
                +0.00626059103917*PriceSeries(Price,index-85,O,L,H,C)
                +0.00587329314829*PriceSeries(Price,index-86,O,L,H,C)
                +0.00533194754803*PriceSeries(Price,index-87,O,L,H,C)
                +0.00465591474204*PriceSeries(Price,index-88,O,L,H,C)
                +0.00386774981700*PriceSeries(Price,index-89,O,L,H,C)
                +0.002992496191721*PriceSeries(Price,index-90,O,L,H,C)
                +0.002056929260664*PriceSeries(Price,index-91,O,L,H,C)
                +0.001088775043074*PriceSeries(Price,index-92,O,L,H,C)
                +0.0001159206433054*PriceSeries(Price,index-93,O,L,H,C)
                -0.000834358194713*PriceSeries(Price,index-94,O,L,H,C)
                -0.001736132707562*PriceSeries(Price,index-95,O,L,H,C)
                -0.002565501167036*PriceSeries(Price,index-96,O,L,H,C)
                -0.00330119663225*PriceSeries(Price,index-97,O,L,H,C)
                -0.00392510703954*PriceSeries(Price,index-98,O,L,H,C)
                -0.00442269311996*PriceSeries(Price,index-99,O,L,H,C)
                -0.00478330078335*PriceSeries(Price,index-100,O,L,H,C)
                -0.00500035732676*PriceSeries(Price,index-101,O,L,H,C)
                -0.00507144972407*PriceSeries(Price,index-102,O,L,H,C)
                -0.00499828738681*PriceSeries(Price,index-103,O,L,H,C)
                -0.00478655190793*PriceSeries(Price,index-104,O,L,H,C)
                -0.00444564129980*PriceSeries(Price,index-105,O,L,H,C)
                -0.00398831623228*PriceSeries(Price,index-106,O,L,H,C)
                -0.00343026474746*PriceSeries(Price,index-107,O,L,H,C)
                -0.002789594496325*PriceSeries(Price,index-108,O,L,H,C)
                -0.002086270018693*PriceSeries(Price,index-109,O,L,H,C)
                -0.001341514463622*PriceSeries(Price,index-110,O,L,H,C)
                -0.000577189245254*PriceSeries(Price,index-111,O,L,H,C)
                +0.0001848288720940*PriceSeries(Price,index-112,O,L,H,C)
                +0.000923257343095*PriceSeries(Price,index-113,O,L,H,C)
                +0.001617984075054*PriceSeries(Price,index-114,O,L,H,C)
                +0.002250599543795*PriceSeries(Price,index-115,O,L,H,C)
                +0.002804869421109*PriceSeries(Price,index-116,O,L,H,C)
                +0.00326713338971*PriceSeries(Price,index-117,O,L,H,C)
                +0.00362662581811*PriceSeries(Price,index-118,O,L,H,C)
                +0.00387570721166*PriceSeries(Price,index-119,O,L,H,C)
                +0.00401000379802*PriceSeries(Price,index-120,O,L,H,C)
                +0.00402845216777*PriceSeries(Price,index-121,O,L,H,C)
                +0.00393325262015*PriceSeries(Price,index-122,O,L,H,C)
                +0.00372973252188*PriceSeries(Price,index-123,O,L,H,C)
                +0.00342612306654*PriceSeries(Price,index-124,O,L,H,C)
                +0.003033263916875*PriceSeries(Price,index-125,O,L,H,C)
                +0.002564240260376*PriceSeries(Price,index-126,O,L,H,C)
                +0.002033965829823*PriceSeries(Price,index-127,O,L,H,C)
                +0.001458724368716*PriceSeries(Price,index-128,O,L,H,C)
                +0.000855683827901*PriceSeries(Price,index-129,O,L,H,C)
                +0.0002423968912963*PriceSeries(Price,index-130,O,L,H,C)
                -0.000363699801512*PriceSeries(Price,index-131,O,L,H,C)
                -0.000945768108375*PriceSeries(Price,index-132,O,L,H,C)
                -0.001488026256273*PriceSeries(Price,index-133,O,L,H,C)
                -0.001976166765683*PriceSeries(Price,index-134,O,L,H,C)
                -0.002397722395364*PriceSeries(Price,index-135,O,L,H,C)
                -0.002742373073830*PriceSeries(Price,index-136,O,L,H,C)
                -0.003002185981110*PriceSeries(Price,index-137,O,L,H,C)
                -0.00317178535446*PriceSeries(Price,index-138,O,L,H,C)
                -0.00324844354429*PriceSeries(Price,index-139,O,L,H,C)
                -0.00323209894097*PriceSeries(Price,index-140,O,L,H,C)
                -0.003125298354242*PriceSeries(Price,index-141,O,L,H,C)
                -0.002933066050720*PriceSeries(Price,index-142,O,L,H,C)
                -0.002662708865037*PriceSeries(Price,index-143,O,L,H,C)
                -0.002323560621827*PriceSeries(Price,index-144,O,L,H,C)
                -0.001926676254656*PriceSeries(Price,index-145,O,L,H,C)
                -0.001484482011433*PriceSeries(Price,index-146,O,L,H,C)
                -0.001010398340958*PriceSeries(Price,index-147,O,L,H,C)
                -0.000518442439022*PriceSeries(Price,index-148,O,L,H,C)
                -0.00002282037663484*PriceSeries(Price,index-149,O,L,H,C)
                +0.000462473731180*PriceSeries(Price,index-150,O,L,H,C)
                +0.000924045795710*PriceSeries(Price,index-151,O,L,H,C)
                +0.001349463402657*PriceSeries(Price,index-152,O,L,H,C)
                +0.001727583971496*PriceSeries(Price,index-153,O,L,H,C)
                +0.002048837677265*PriceSeries(Price,index-154,O,L,H,C)
                +0.002305461227383*PriceSeries(Price,index-155,O,L,H,C)
                +0.002491677635783*PriceSeries(Price,index-156,O,L,H,C)
                +0.002603811816183*PriceSeries(Price,index-157,O,L,H,C)
                +0.002640348329944*PriceSeries(Price,index-158,O,L,H,C)
                +0.002601926664485*PriceSeries(Price,index-159,O,L,H,C)
                +0.002491276253288*PriceSeries(Price,index-160,O,L,H,C)
                +0.002313093176638*PriceSeries(Price,index-161,O,L,H,C)
                +0.002073864980018*PriceSeries(Price,index-162,O,L,H,C)
                +0.001781651006141*PriceSeries(Price,index-163,O,L,H,C)
                +0.001445819240987*PriceSeries(Price,index-164,O,L,H,C)
                +0.001076756409744*PriceSeries(Price,index-165,O,L,H,C)
                +0.000685554002675*PriceSeries(Price,index-166,O,L,H,C)
                +0.0002836805837228*PriceSeries(Price,index-167,O,L,H,C)
                -0.0001173479681511*PriceSeries(Price,index-168,O,L,H,C)
                -0.000506292494962*PriceSeries(Price,index-169,O,L,H,C)
                -0.000872498808563*PriceSeries(Price,index-170,O,L,H,C)
                -0.001206186923662*PriceSeries(Price,index-171,O,L,H,C)
                -0.001498704428464*PriceSeries(Price,index-172,O,L,H,C)
                -0.001742744404771*PriceSeries(Price,index-173,O,L,H,C)
                -0.001932522206084*PriceSeries(Price,index-174,O,L,H,C)
                -0.002063903285140*PriceSeries(Price,index-175,O,L,H,C)
                -0.002134483804021*PriceSeries(Price,index-176,O,L,H,C)
                -0.002143619328648*PriceSeries(Price,index-177,O,L,H,C)
                -0.002092406013174*PriceSeries(Price,index-178,O,L,H,C)
                -0.001983609173864*PriceSeries(Price,index-179,O,L,H,C)
                -0.001821549488522*PriceSeries(Price,index-180,O,L,H,C)
                -0.001611949361645*PriceSeries(Price,index-181,O,L,H,C)
                -0.001361738768356*PriceSeries(Price,index-182,O,L,H,C)
                -0.001078834869681*PriceSeries(Price,index-183,O,L,H,C)
                -0.000771897484219*PriceSeries(Price,index-184,O,L,H,C)
                -0.000450071017285*PriceSeries(Price,index-185,O,L,H,C)
                -0.0001227151493688*PriceSeries(Price,index-186,O,L,H,C)
                +0.0002008625927192*PriceSeries(Price,index-187,O,L,H,C)
                +0.000511665717815*PriceSeries(Price,index-188,O,L,H,C)
                +0.000801257515200*PriceSeries(Price,index-189,O,L,H,C)
                +0.001061983129496*PriceSeries(Price,index-190,O,L,H,C)
                +0.001287167663396*PriceSeries(Price,index-191,O,L,H,C)
                +0.001471282113481*PriceSeries(Price,index-192,O,L,H,C)
                +0.001610074363786*PriceSeries(Price,index-193,O,L,H,C)
                +0.001700659386288*PriceSeries(Price,index-194,O,L,H,C)
                +0.001741568154351*PriceSeries(Price,index-195,O,L,H,C)
                +0.001732760886567*PriceSeries(Price,index-196,O,L,H,C)
                +0.001675593612365*PriceSeries(Price,index-197,O,L,H,C)
                +0.001572749516484*PriceSeries(Price,index-198,O,L,H,C)
                +0.001428134117121*PriceSeries(Price,index-199,O,L,H,C)
                +0.001246737716969*PriceSeries(Price,index-200,O,L,H,C)
                +0.001034471152703*PriceSeries(Price,index-201,O,L,H,C)
                +0.000797978347305*PriceSeries(Price,index-202,O,L,H,C)
                +0.000544435992615*PriceSeries(Price,index-203,O,L,H,C)
                +0.0002813359189813*PriceSeries(Price,index-204,O,L,H,C)
                +0.00001626869567554*PriceSeries(Price,index-205,O,L,H,C)
                -0.0002432901692448*PriceSeries(Price,index-206,O,L,H,C)
                -0.000490189121522*PriceSeries(Price,index-207,O,L,H,C)
                -0.000717793620461*PriceSeries(Price,index-208,O,L,H,C)
                -0.000920161952581*PriceSeries(Price,index-209,O,L,H,C)
                -0.001092193889882*PriceSeries(Price,index-210,O,L,H,C)
                -0.001229757857524*PriceSeries(Price,index-211,O,L,H,C)
                -0.001329783244105*PriceSeries(Price,index-212,O,L,H,C)
                -0.001390321509472*PriceSeries(Price,index-213,O,L,H,C)
                -0.001410578336638*PriceSeries(Price,index-214,O,L,H,C)
                -0.001390906920183*PriceSeries(Price,index-215,O,L,H,C)
                -0.001332772258593*PriceSeries(Price,index-216,O,L,H,C)
                -0.001238683388861*PriceSeries(Price,index-217,O,L,H,C)
                -0.001112102156418*PriceSeries(Price,index-218,O,L,H,C)
                -0.000957322119020*PriceSeries(Price,index-219,O,L,H,C)
                -0.000779326998447*PriceSeries(Price,index-220,O,L,H,C)
                -0.000583638140965*PriceSeries(Price,index-221,O,L,H,C)
                -0.000376143834397*PriceSeries(Price,index-222,O,L,H,C)
                -0.0001629273354777*PriceSeries(Price,index-223,O,L,H,C)
                +0.0000499090966531*PriceSeries(Price,index-224,O,L,H,C)
                +0.0002564151769598*PriceSeries(Price,index-225,O,L,H,C)
                +0.000450957714812*PriceSeries(Price,index-226,O,L,H,C)
                +0.000628371744053*PriceSeries(Price,index-227,O,L,H,C)
                +0.000784090526796*PriceSeries(Price,index-228,O,L,H,C)
                +0.000914264896674*PriceSeries(Price,index-229,O,L,H,C)
                +0.001015852535700*PriceSeries(Price,index-230,O,L,H,C)
                +0.001086683801906*PriceSeries(Price,index-231,O,L,H,C)
                +0.001125501736172*PriceSeries(Price,index-232,O,L,H,C)
                +0.001131976208697*PriceSeries(Price,index-233,O,L,H,C)
                +0.001106692513845*PriceSeries(Price,index-234,O,L,H,C)
                +0.001051110039178*PriceSeries(Price,index-235,O,L,H,C)
                +0.000967505134960*PriceSeries(Price,index-236,O,L,H,C)
                +0.000858883733598*PriceSeries(Price,index-237,O,L,H,C)
                +0.000728879233058*PriceSeries(Price,index-238,O,L,H,C)
                +0.000581638171246*PriceSeries(Price,index-239,O,L,H,C)
                +0.000421690342343*PriceSeries(Price,index-240,O,L,H,C)
                +0.0002538127421936*PriceSeries(Price,index-241,O,L,H,C)
                +0.0000828865786991*PriceSeries(Price,index-242,O,L,H,C)
                -0.0000862368477395*PriceSeries(Price,index-243,O,L,H,C)
                -0.0002488750670656*PriceSeries(Price,index-244,O,L,H,C)
                -0.000400642218484*PriceSeries(Price,index-245,O,L,H,C)
                -0.000537562114075*PriceSeries(Price,index-246,O,L,H,C)
                -0.000656173055590*PriceSeries(Price,index-247,O,L,H,C)
                -0.000753609730308*PriceSeries(Price,index-248,O,L,H,C)
                -0.000827670294256*PriceSeries(Price,index-249,O,L,H,C)
                -0.000876858702010*PriceSeries(Price,index-250,O,L,H,C)
                -0.000900414023522*PriceSeries(Price,index-251,O,L,H,C)
                -0.000898313034848*PriceSeries(Price,index-252,O,L,H,C)
                -0.000871247506493*PriceSeries(Price,index-253,O,L,H,C)
                -0.000820592193810*PriceSeries(Price,index-254,O,L,H,C)
                -0.000748346704370*PriceSeries(Price,index-255,O,L,H,C)
                -0.000657065452112*PriceSeries(Price,index-256,O,L,H,C)
                -0.000549769745876*PriceSeries(Price,index-257,O,L,H,C)
                -0.000429853790756*PriceSeries(Price,index-258,O,L,H,C)
                -0.0003009798153440*PriceSeries(Price,index-259,O,L,H,C)
                -0.0001669652354848*PriceSeries(Price,index-260,O,L,H,C)
                -0.0000316785974259*PriceSeries(Price,index-261,O,L,H,C)
                +0.0001010761269012*PriceSeries(Price,index-262,O,L,H,C)
                +0.0002276637523270*PriceSeries(Price,index-263,O,L,H,C)
                +0.000344714360313*PriceSeries(Price,index-264,O,L,H,C)
                +0.000449208935993*PriceSeries(Price,index-265,O,L,H,C)
                +0.000538555626106*PriceSeries(Price,index-266,O,L,H,C)
                +0.000610656118603*PriceSeries(Price,index-267,O,L,H,C)
                +0.000663944454956*PriceSeries(Price,index-268,O,L,H,C)
                +0.000697422906330*PriceSeries(Price,index-269,O,L,H,C)
                +0.000710672679495*PriceSeries(Price,index-270,O,L,H,C)
                +0.000703848935069*PriceSeries(Price,index-271,O,L,H,C)
                +0.000677664114597*PriceSeries(Price,index-272,O,L,H,C)
                +0.000633352316355*PriceSeries(Price,index-273,O,L,H,C)
                +0.000572623073895*PriceSeries(Price,index-274,O,L,H,C)
                +0.000497594018233*PriceSeries(Price,index-275,O,L,H,C)
                +0.000410729566656*PriceSeries(Price,index-276,O,L,H,C)
                +0.0003147604724769*PriceSeries(Price,index-277,O,L,H,C)
                +0.0002125959029135*PriceSeries(Price,index-278,O,L,H,C)
                +0.0001072412893672*PriceSeries(Price,index-279,O,L,H,C)
                +0.000001709024927508*PriceSeries(Price,index-280,O,L,H,C)
                -0.0001010619572292*PriceSeries(Price,index-281,O,L,H,C)
                -0.0001982913577903*PriceSeries(Price,index-282,O,L,H,C)
                -0.0002874247960478*PriceSeries(Price,index-283,O,L,H,C)
                -0.000366203785733*PriceSeries(Price,index-284,O,L,H,C)
                -0.000432724014734*PriceSeries(Price,index-285,O,L,H,C)
                -0.000485469580315*PriceSeries(Price,index-286,O,L,H,C)
                -0.000523351132231*PriceSeries(Price,index-287,O,L,H,C)
                -0.000545722731367*PriceSeries(Price,index-288,O,L,H,C)
                -0.000552390905065*PriceSeries(Price,index-289,O,L,H,C)
                -0.000543600866376*PriceSeries(Price,index-290,O,L,H,C)
                -0.000520020755947*PriceSeries(Price,index-291,O,L,H,C)
                -0.000482715887328*PriceSeries(Price,index-292,O,L,H,C)
                -0.000433099005123*PriceSeries(Price,index-293,O,L,H,C)
                -0.000372890359871*PriceSeries(Price,index-294,O,L,H,C)
                -0.0003040548502122*PriceSeries(Price,index-295,O,L,H,C)
                -0.0002287407135038*PriceSeries(Price,index-296,O,L,H,C)
                -0.0001492141369137*PriceSeries(Price,index-297,O,L,H,C)
                -0.0000677967017257*PriceSeries(Price,index-298,O,L,H,C)
                +0.00001319889462381*PriceSeries(Price,index-299,O,L,H,C)
                +0.0000915456969079*PriceSeries(Price,index-300,O,L,H,C)
                +0.0001651491796019*PriceSeries(Price,index-301,O,L,H,C)
                +0.0002321070411659*PriceSeries(Price,index-302,O,L,H,C)
                +0.0002907570958514*PriceSeries(Price,index-303,O,L,H,C)
                +0.000339715311883*PriceSeries(Price,index-304,O,L,H,C)
                +0.000377907799889*PriceSeries(Price,index-305,O,L,H,C)
                +0.000404587741528*PriceSeries(Price,index-306,O,L,H,C)
                +0.000419355221627*PriceSeries(Price,index-307,O,L,H,C)
                +0.000422144375067*PriceSeries(Price,index-308,O,L,H,C)
                +0.000413227050896*PriceSeries(Price,index-309,O,L,H,C)
                +0.000393197143945*PriceSeries(Price,index-310,O,L,H,C)
                +0.000362934449167*PriceSeries(Price,index-311,O,L,H,C)
                +0.000323575724719*PriceSeries(Price,index-312,O,L,H,C)
                +0.0002764728319872*PriceSeries(Price,index-313,O,L,H,C)
                +0.0002231593754260*PriceSeries(Price,index-314,O,L,H,C)
                +0.0001652886754153*PriceSeries(Price,index-315,O,L,H,C)
                +0.0001045933494060*PriceSeries(Price,index-316,O,L,H,C)
                +0.0000428347232780*PriceSeries(Price,index-317,O,L,H,C)
                -0.00001825750523000*PriceSeries(Price,index-318,O,L,H,C)
                -0.0000770180608416*PriceSeries(Price,index-319,O,L,H,C)
                -0.0001318985852249*PriceSeries(Price,index-320,O,L,H,C)
                -0.0001815030398526*PriceSeries(Price,index-321,O,L,H,C)
                -0.0002246315712843*PriceSeries(Price,index-322,O,L,H,C)
                -0.0002602935346376*PriceSeries(Price,index-323,O,L,H,C)
                -0.0002877282255136*PriceSeries(Price,index-324,O,L,H,C)
                -0.0003064371559317*PriceSeries(Price,index-325,O,L,H,C)
                -0.0003161717405395*PriceSeries(Price,index-326,O,L,H,C)
                -0.000316942917170*PriceSeries(Price,index-327,O,L,H,C)
                -0.0003090047954283*PriceSeries(Price,index-328,O,L,H,C)
                -0.0002928447540871*PriceSeries(Price,index-329,O,L,H,C)
                -0.0002691582126644*PriceSeries(Price,index-330,O,L,H,C)
                -0.0002388255337539*PriceSeries(Price,index-331,O,L,H,C)
                -0.0002028958712359*PriceSeries(Price,index-332,O,L,H,C)
                -0.0001625233075966*PriceSeries(Price,index-333,O,L,H,C)
                -0.0001189529778672*PriceSeries(Price,index-334,O,L,H,C)
                -0.0000734821887466*PriceSeries(Price,index-335,O,L,H,C)
                -0.00002741934255265*PriceSeries(Price,index-336,O,L,H,C)
                +0.00001795608663836*PriceSeries(Price,index-337,O,L,H,C)
                +0.0000614294363280*PriceSeries(Price,index-338,O,L,H,C)
                +0.0001018623893883*PriceSeries(Price,index-339,O,L,H,C)
                +0.0001382498525705*PriceSeries(Price,index-340,O,L,H,C)
                +0.0001697180690801*PriceSeries(Price,index-341,O,L,H,C)
                +0.0001955567414700*PriceSeries(Price,index-342,O,L,H,C)
                +0.0002152444253959*PriceSeries(Price,index-343,O,L,H,C)
                +0.0002284379772274*PriceSeries(Price,index-344,O,L,H,C)
                +0.0002349801225415*PriceSeries(Price,index-345,O,L,H,C)
                +0.0002348870614907*PriceSeries(Price,index-346,O,L,H,C)
                +0.0002283783966550*PriceSeries(Price,index-347,O,L,H,C)
                +0.0002158282233495*PriceSeries(Price,index-348,O,L,H,C)
                +0.0001977570677447*PriceSeries(Price,index-349,O,L,H,C)
                +0.0001748319733254*PriceSeries(Price,index-350,O,L,H,C)
                +0.0001478180062690*PriceSeries(Price,index-351,O,L,H,C)
                +0.0001175764622853*PriceSeries(Price,index-352,O,L,H,C)
                +0.0000850184566849*PriceSeries(Price,index-353,O,L,H,C)
                +0.0000511008974244*PriceSeries(Price,index-354,O,L,H,C)
                +0.00001676755874529*PriceSeries(Price,index-355,O,L,H,C)
                -0.00001704977000851*PriceSeries(Price,index-356,O,L,H,C)
                -0.0000494315321344*PriceSeries(Price,index-357,O,L,H,C)
                -0.0000795564724115*PriceSeries(Price,index-358,O,L,H,C)
                -0.0001066823489541*PriceSeries(Price,index-359,O,L,H,C)
                -0.0001301752176760*PriceSeries(Price,index-360,O,L,H,C)
                -0.0001494965666534*PriceSeries(Price,index-361,O,L,H,C)
                -0.0001642447867855*PriceSeries(Price,index-362,O,L,H,C)
                -0.0001741503288893*PriceSeries(Price,index-363,O,L,H,C)
                -0.0001790518657745*PriceSeries(Price,index-364,O,L,H,C)
                -0.0001789643767297*PriceSeries(Price,index-365,O,L,H,C)
                -0.0001739907830474*PriceSeries(Price,index-366,O,L,H,C)
                -0.0001643578718151*PriceSeries(Price,index-367,O,L,H,C)
                -0.0001504122925824*PriceSeries(Price,index-368,O,L,H,C)
                -0.0001326053121627*PriceSeries(Price,index-369,O,L,H,C)
                -0.0001114511296863*PriceSeries(Price,index-370,O,L,H,C)
                -0.0000874808748678*PriceSeries(Price,index-371,O,L,H,C)
                -0.0000613490329468*PriceSeries(Price,index-372,O,L,H,C)
                -0.0000336985617548*PriceSeries(Price,index-373,O,L,H,C)
                -0.00000519457621955*PriceSeries(Price,index-374,O,L,H,C)
                +0.00002349715414677*PriceSeries(Price,index-375,O,L,H,C)
                +0.0000517676315080*PriceSeries(Price,index-376,O,L,H,C)
                +0.0000790300347065*PriceSeries(Price,index-377,O,L,H,C)
                +0.0001047666537989*PriceSeries(Price,index-378,O,L,H,C)
                +0.0001284285645748*PriceSeries(Price,index-379,O,L,H,C)
                +0.0001496555610860*PriceSeries(Price,index-380,O,L,H,C)
                +0.0001681401425130*PriceSeries(Price,index-381,O,L,H,C)
                +0.0001835703251685*PriceSeries(Price,index-382,O,L,H,C)
                +0.0001957952598491*PriceSeries(Price,index-383,O,L,H,C)
                +0.0002047309390043*PriceSeries(Price,index-384,O,L,H,C)
                +0.0002104465209042*PriceSeries(Price,index-385,O,L,H,C)
                +0.0002129423055485*PriceSeries(Price,index-386,O,L,H,C)
                +0.0002124013124223*PriceSeries(Price,index-387,O,L,H,C)
                +0.0002089844962609*PriceSeries(Price,index-388,O,L,H,C)
                +0.0002028259976804*PriceSeries(Price,index-389,O,L,H,C)
                +0.0001944313033536*PriceSeries(Price,index-390,O,L,H,C)
                +0.0001841148536387*PriceSeries(Price,index-391,O,L,H,C)
                +0.0001722022889881*PriceSeries(Price,index-392,O,L,H,C)
                +0.0001588593173498*PriceSeries(Price,index-393,O,L,H,C)
                +0.0001446727918811*PriceSeries(Price,index-394,O,L,H,C)
                +0.0001301049843066*PriceSeries(Price,index-395,O,L,H,C)
                +0.0001151035244245*PriceSeries(Price,index-396,O,L,H,C)
                +0.0001006364574851*PriceSeries(Price,index-397,O,L,H,C)
                +0.0000868755204547*PriceSeries(Price,index-398,O,L,H,C)
                +0.0000750193300840*PriceSeries(Price,index-399,O,L,H,C)
                +0.0000669968199748*PriceSeries(Price,index-400,O,L,H,C)
                +0.0000675506346242*PriceSeries(Price,index-401,O,L,H,C)
                +0.0000882012344639*PriceSeries(Price,index-402,O,L,H,C)
                -0.0000535071711068*PriceSeries(Price,index-403,O,L,H,C)
                );

      case N41:
         return(
                0.1041346603244*PriceSeries(Price,index,O,L,H,C)
                +0.1031973499479*PriceSeries(Price,index-1,O,L,H,C)
                +0.1013379726722*PriceSeries(Price,index-2,O,L,H,C)
                +0.0985867201676*PriceSeries(Price,index-3,O,L,H,C)
                +0.0949881445222*PriceSeries(Price,index-4,O,L,H,C)
                +0.0906002959177*PriceSeries(Price,index-5,O,L,H,C)
                +0.0854935988152*PriceSeries(Price,index-6,O,L,H,C)
                +0.0797494942371*PriceSeries(Price,index-7,O,L,H,C)
                +0.0734588735103*PriceSeries(Price,index-8,O,L,H,C)
                +0.0667203415818*PriceSeries(Price,index-9,O,L,H,C)
                +0.0596383384203*PriceSeries(Price,index-10,O,L,H,C)
                +0.0523211679268*PriceSeries(Price,index-11,O,L,H,C)
                +0.0448789651598*PriceSeries(Price,index-12,O,L,H,C)
                +0.0374216529816*PriceSeries(Price,index-13,O,L,H,C)
                +0.03005692296450*PriceSeries(Price,index-14,O,L,H,C)
                +0.02288828879112*PriceSeries(Price,index-15,O,L,H,C)
                +0.01601324251850*PriceSeries(Price,index-16,O,L,H,C)
                +0.00952156303074*PriceSeries(Price,index-17,O,L,H,C)
                +0.00349379504545*PriceSeries(Price,index-18,O,L,H,C)
                -0.002000056932970*PriceSeries(Price,index-19,O,L,H,C)
                -0.00690160928106*PriceSeries(Price,index-20,O,L,H,C)
                -0.01116492207884*PriceSeries(Price,index-21,O,L,H,C)
                -0.01475706465223*PriceSeries(Price,index-22,O,L,H,C)
                -0.01765839930781*PriceSeries(Price,index-23,O,L,H,C)
                -0.01986260185921*PriceSeries(Price,index-24,O,L,H,C)
                -0.02137640053995*PriceSeries(Price,index-25,O,L,H,C)
                -0.02221906579048*PriceSeries(Price,index-26,O,L,H,C)
                -0.02242164565303*PriceSeries(Price,index-27,O,L,H,C)
                -0.02202598728430*PriceSeries(Price,index-28,O,L,H,C)
                -0.02108354872754*PriceSeries(Price,index-29,O,L,H,C)
                -0.01965405356233*PriceSeries(Price,index-30,O,L,H,C)
                -0.01780399496073*PriceSeries(Price,index-31,O,L,H,C)
                -0.01560505058036*PriceSeries(Price,index-32,O,L,H,C)
                -0.01313241951993*PriceSeries(Price,index-33,O,L,H,C)
                -0.01046314124907*PriceSeries(Price,index-34,O,L,H,C)
                -0.00767441260428*PriceSeries(Price,index-35,O,L,H,C)
                -0.00484196141170*PriceSeries(Price,index-36,O,L,H,C)
                -0.002038486334955*PriceSeries(Price,index-37,O,L,H,C)
                +0.000667777483628*PriceSeries(Price,index-38,O,L,H,C)
                +0.00321436597284*PriceSeries(Price,index-39,O,L,H,C)
                +0.00554571437581*PriceSeries(Price,index-40,O,L,H,C)
                +0.00761411120912*PriceSeries(Price,index-41,O,L,H,C)
                +0.00938043545238*PriceSeries(Price,index-42,O,L,H,C)
                +0.01081469401374*PriceSeries(Price,index-43,O,L,H,C)
                +0.01189632105842*PriceSeries(Price,index-44,O,L,H,C)
                +0.01261427275664*PriceSeries(Price,index-45,O,L,H,C)
                +0.01296688699983*PriceSeries(Price,index-46,O,L,H,C)
                +0.01296154937480*PriceSeries(Price,index-47,O,L,H,C)
                +0.01261414852223*PriceSeries(Price,index-48,O,L,H,C)
                +0.01194836846298*PriceSeries(Price,index-49,O,L,H,C)
                +0.01099480831719*PriceSeries(Price,index-50,O,L,H,C)
                +0.00978998700128*PriceSeries(Price,index-51,O,L,H,C)
                +0.00837522594560*PriceSeries(Price,index-52,O,L,H,C)
                +0.00679547118402*PriceSeries(Price,index-53,O,L,H,C)
                +0.00509805537626*PriceSeries(Price,index-54,O,L,H,C)
                +0.00333145722931*PriceSeries(Price,index-55,O,L,H,C)
                +0.001544060809044*PriceSeries(Price,index-56,O,L,H,C)
                -0.0002170269311727*PriceSeries(Price,index-57,O,L,H,C)
                -0.001907105003866*PriceSeries(Price,index-58,O,L,H,C)
                -0.00348489611418*PriceSeries(Price,index-59,O,L,H,C)
                -0.00491346313058*PriceSeries(Price,index-60,O,L,H,C)
                -0.00616097626699*PriceSeries(Price,index-61,O,L,H,C)
                -0.00720134432927*PriceSeries(Price,index-62,O,L,H,C)
                -0.00801466959100*PriceSeries(Price,index-63,O,L,H,C)
                -0.00858755241351*PriceSeries(Price,index-64,O,L,H,C)
                -0.00891320786861*PriceSeries(Price,index-65,O,L,H,C)
                -0.00899143165219*PriceSeries(Price,index-66,O,L,H,C)
                -0.00882838726806*PriceSeries(Price,index-67,O,L,H,C)
                -0.00843625529715*PriceSeries(Price,index-68,O,L,H,C)
                -0.00783272851318*PriceSeries(Price,index-69,O,L,H,C)
                -0.00704039863151*PriceSeries(Price,index-70,O,L,H,C)
                -0.00608602220247*PriceSeries(Price,index-71,O,L,H,C)
                -0.00499971862394*PriceSeries(Price,index-72,O,L,H,C)
                -0.00381409281147*PriceSeries(Price,index-73,O,L,H,C)
                -0.002563331967929*PriceSeries(Price,index-74,O,L,H,C)
                -0.001282277719012*PriceSeries(Price,index-75,O,L,H,C)
                -0.00000551813682209*PriceSeries(Price,index-76,O,L,H,C)
                +0.001233499354107*PriceSeries(Price,index-77,O,L,H,C)
                +0.002403288901302*PriceSeries(Price,index-78,O,L,H,C)
                +0.00347508715709*PriceSeries(Price,index-79,O,L,H,C)
                +0.00442351216654*PriceSeries(Price,index-80,O,L,H,C)
                +0.00522712803667*PriceSeries(Price,index-81,O,L,H,C)
                +0.00586888343437*PriceSeries(Price,index-82,O,L,H,C)
                +0.00633643685020*PriceSeries(Price,index-83,O,L,H,C)
                +0.00662234004096*PriceSeries(Price,index-84,O,L,H,C)
                +0.00672410418275*PriceSeries(Price,index-85,O,L,H,C)
                +0.00664412369829*PriceSeries(Price,index-86,O,L,H,C)
                +0.00638948790490*PriceSeries(Price,index-87,O,L,H,C)
                +0.00597166725694*PriceSeries(Price,index-88,O,L,H,C)
                +0.00540610297064*PriceSeries(Price,index-89,O,L,H,C)
                +0.00471169598513*PriceSeries(Price,index-90,O,L,H,C)
                +0.00391022915983*PriceSeries(Price,index-91,O,L,H,C)
                +0.003025720320722*PriceSeries(Price,index-92,O,L,H,C)
                +0.002083741709639*PriceSeries(Price,index-93,O,L,H,C)
                +0.001110710571861*PriceSeries(Price,index-94,O,L,H,C)
                +0.0001331792094514*PriceSeries(Price,index-95,O,L,H,C)
                -0.000822863326262*PriceSeries(Price,index-96,O,L,H,C)
                -0.001732654404382*PriceSeries(Price,index-97,O,L,H,C)
                -0.002573277310854*PriceSeries(Price,index-98,O,L,H,C)
                -0.00332421268642*PriceSeries(Price,index-99,O,L,H,C)
                -0.00396781768778*PriceSeries(Price,index-100,O,L,H,C)
                -0.00448971653354*PriceSeries(Price,index-101,O,L,H,C)
                -0.00487909773282*PriceSeries(Price,index-102,O,L,H,C)
                -0.00512890949822*PriceSeries(Price,index-103,O,L,H,C)
                -0.00523595543737*PriceSeries(Price,index-104,O,L,H,C)
                -0.00520088241443*PriceSeries(Price,index-105,O,L,H,C)
                -0.00502807361349*PriceSeries(Price,index-106,O,L,H,C)
                -0.00472544260074*PriceSeries(Price,index-107,O,L,H,C)
                -0.00430414129274*PriceSeries(Price,index-108,O,L,H,C)
                -0.00377818995438*PriceSeries(Price,index-109,O,L,H,C)
                -0.00316404067647*PriceSeries(Price,index-110,O,L,H,C)
                -0.002480086950624*PriceSeries(Price,index-111,O,L,H,C)
                -0.001746133958071*PriceSeries(Price,index-112,O,L,H,C)
                -0.000982844848440*PriceSeries(Price,index-113,O,L,H,C)
                -0.0002111739429769*PriceSeries(Price,index-114,O,L,H,C)
                +0.000548188419654*PriceSeries(Price,index-115,O,L,H,C)
                +0.001275359389777*PriceSeries(Price,index-116,O,L,H,C)
                +0.001951766177145*PriceSeries(Price,index-117,O,L,H,C)
                +0.002560608724080*PriceSeries(Price,index-118,O,L,H,C)
                +0.003087259955736*PriceSeries(Price,index-119,O,L,H,C)
                +0.00351960575087*PriceSeries(Price,index-120,O,L,H,C)
                +0.00384830396586*PriceSeries(Price,index-121,O,L,H,C)
                +0.00406697316774*PriceSeries(Price,index-122,O,L,H,C)
                +0.00417229034776*PriceSeries(Price,index-123,O,L,H,C)
                +0.00416401312230*PriceSeries(Price,index-124,O,L,H,C)
                +0.00404491530710*PriceSeries(Price,index-125,O,L,H,C)
                +0.00382064842211*PriceSeries(Price,index-126,O,L,H,C)
                +0.00349952503774*PriceSeries(Price,index-127,O,L,H,C)
                +0.003092244049556*PriceSeries(Price,index-128,O,L,H,C)
                +0.002611550035789*PriceSeries(Price,index-129,O,L,H,C)
                +0.002071855667153*PriceSeries(Price,index-130,O,L,H,C)
                +0.001488819066570*PriceSeries(Price,index-131,O,L,H,C)
                +0.000878905839006*PriceSeries(Price,index-132,O,L,H,C)
                +0.0002589305402326*PriceSeries(Price,index-133,O,L,H,C)
                -0.000354389760177*PriceSeries(Price,index-134,O,L,H,C)
                -0.000944884564168*PriceSeries(Price,index-135,O,L,H,C)
                -0.001497337922359*PriceSeries(Price,index-136,O,L,H,C)
                -0.001997879391480*PriceSeries(Price,index-137,O,L,H,C)
                -0.002434314878296*PriceSeries(Price,index-138,O,L,H,C)
                -0.002796421056967*PriceSeries(Price,index-139,O,L,H,C)
                -0.003076166626476*PriceSeries(Price,index-140,O,L,H,C)
                -0.00326788652801*PriceSeries(Price,index-141,O,L,H,C)
                -0.00336837219094*PriceSeries(Price,index-142,O,L,H,C)
                -0.00337691273245*PriceSeries(Price,index-143,O,L,H,C)
                -0.00329525323327*PriceSeries(Price,index-144,O,L,H,C)
                -0.003127501743001*PriceSeries(Price,index-145,O,L,H,C)
                -0.002879964342081*PriceSeries(Price,index-146,O,L,H,C)
                -0.002560936755683*PriceSeries(Price,index-147,O,L,H,C)
                -0.002180434880684*PriceSeries(Price,index-148,O,L,H,C)
                -0.001749900234605*PriceSeries(Price,index-149,O,L,H,C)
                -0.001281857498477*PriceSeries(Price,index-150,O,L,H,C)
                -0.000789566291452*PriceSeries(Price,index-151,O,L,H,C)
                -0.0002866466034089*PriceSeries(Price,index-152,O,L,H,C)
                +0.0002132832851046*PriceSeries(Price,index-153,O,L,H,C)
                +0.000696977775951*PriceSeries(Price,index-154,O,L,H,C)
                +0.001151897491366*PriceSeries(Price,index-155,O,L,H,C)
                +0.001566539187620*PriceSeries(Price,index-156,O,L,H,C)
                +0.001930708136915*PriceSeries(Price,index-157,O,L,H,C)
                +0.002235772329894*PriceSeries(Price,index-158,O,L,H,C)
                +0.002474849708354*PriceSeries(Price,index-159,O,L,H,C)
                +0.002642963784315*PriceSeries(Price,index-160,O,L,H,C)
                +0.002737125516293*PriceSeries(Price,index-161,O,L,H,C)
                +0.002756382540014*PriceSeries(Price,index-162,O,L,H,C)
                +0.002701790951634*PriceSeries(Price,index-163,O,L,H,C)
                +0.002576354676239*PriceSeries(Price,index-164,O,L,H,C)
                +0.002384896825775*PriceSeries(Price,index-165,O,L,H,C)
                +0.002133899935435*PriceSeries(Price,index-166,O,L,H,C)
                +0.001831292580316*PriceSeries(Price,index-167,O,L,H,C)
                +0.001486215386304*PriceSeries(Price,index-168,O,L,H,C)
                +0.001108743850949*PriceSeries(Price,index-169,O,L,H,C)
                +0.000709609301591*PriceSeries(Price,index-170,O,L,H,C)
                +0.0002998920917110*PriceSeries(Price,index-171,O,L,H,C)
                -0.0001092739536806*PriceSeries(Price,index-172,O,L,H,C)
                -0.000507006001034*PriceSeries(Price,index-173,O,L,H,C)
                -0.000882948647894*PriceSeries(Price,index-174,O,L,H,C)
                -0.001227548360411*PriceSeries(Price,index-175,O,L,H,C)
                -0.001532279558383*PriceSeries(Price,index-176,O,L,H,C)
                -0.001789862274964*PriceSeries(Price,index-177,O,L,H,C)
                -0.001994419243852*PriceSeries(Price,index-178,O,L,H,C)
                -0.002141612303722*PriceSeries(Price,index-179,O,L,H,C)
                -0.002228716888655*PriceSeries(Price,index-180,O,L,H,C)
                -0.002254670574227*PriceSeries(Price,index-181,O,L,H,C)
                -0.002220056490710*PriceSeries(Price,index-182,O,L,H,C)
                -0.002127063442764*PriceSeries(Price,index-183,O,L,H,C)
                -0.001979385034808*PriceSeries(Price,index-184,O,L,H,C)
                -0.001782096694416*PriceSeries(Price,index-185,O,L,H,C)
                -0.001541487266414*PriceSeries(Price,index-186,O,L,H,C)
                -0.001264869544168*PriceSeries(Price,index-187,O,L,H,C)
                -0.000960359536549*PriceSeries(Price,index-188,O,L,H,C)
                -0.000636649187523*PriceSeries(Price,index-189,O,L,H,C)
                -0.0003027570234131*PriceSeries(Price,index-190,O,L,H,C)
                +0.0000322140515096*PriceSeries(Price,index-191,O,L,H,C)
                +0.000359325059271*PriceSeries(Price,index-192,O,L,H,C)
                +0.000670032464428*PriceSeries(Price,index-193,O,L,H,C)
                +0.000956411050444*PriceSeries(Price,index-194,O,L,H,C)
                +0.001211346478116*PriceSeries(Price,index-195,O,L,H,C)
                +0.001428715943946*PriceSeries(Price,index-196,O,L,H,C)
                +0.001603521705310*PriceSeries(Price,index-197,O,L,H,C)
                +0.001732008026829*PriceSeries(Price,index-198,O,L,H,C)
                +0.001811729021777*PriceSeries(Price,index-199,O,L,H,C)
                +0.001841591663342*PriceSeries(Price,index-200,O,L,H,C)
                +0.001821850922239*PriceSeries(Price,index-201,O,L,H,C)
                +0.001754080548840*PriceSeries(Price,index-202,O,L,H,C)
                +0.001641096395385*PriceSeries(Price,index-203,O,L,H,C)
                +0.001486861283024*PriceSeries(Price,index-204,O,L,H,C)
                +0.001296351953762*PriceSeries(Price,index-205,O,L,H,C)
                +0.001075404796436*PriceSeries(Price,index-206,O,L,H,C)
                +0.000830543621328*PriceSeries(Price,index-207,O,L,H,C)
                +0.000568789960038*PriceSeries(Price,index-208,O,L,H,C)
                +0.0002974659882366*PriceSeries(Price,index-209,O,L,H,C)
                +0.00002399281162284*PriceSeries(Price,index-210,O,L,H,C)
                -0.0002443091520051*PriceSeries(Price,index-211,O,L,H,C)
                -0.000500414799238*PriceSeries(Price,index-212,O,L,H,C)
                -0.000737771667752*PriceSeries(Price,index-213,O,L,H,C)
                -0.000950467916043*PriceSeries(Price,index-214,O,L,H,C)
                -0.001133375281238*PriceSeries(Price,index-215,O,L,H,C)
                -0.001282267026616*PriceSeries(Price,index-216,O,L,H,C)
                -0.001393914152639*PriceSeries(Price,index-217,O,L,H,C)
                -0.001466147401795*PriceSeries(Price,index-218,O,L,H,C)
                -0.001497893708633*PriceSeries(Price,index-219,O,L,H,C)
                -0.001489181384761*PriceSeries(Price,index-220,O,L,H,C)
                -0.001441114471041*PriceSeries(Price,index-221,O,L,H,C)
                -0.001355819981274*PriceSeries(Price,index-222,O,L,H,C)
                -0.001236370794559*PriceSeries(Price,index-223,O,L,H,C)
                -0.001086682213679*PriceSeries(Price,index-224,O,L,H,C)
                -0.000911387176761*PriceSeries(Price,index-225,O,L,H,C)
                -0.000715702633435*PriceSeries(Price,index-226,O,L,H,C)
                -0.000505270147908*PriceSeries(Price,index-227,O,L,H,C)
                -0.0002860050748961*PriceSeries(Price,index-228,O,L,H,C)
                -0.0000639246218824*PriceSeries(Price,index-229,O,L,H,C)
                +0.0001550079077425*PriceSeries(Price,index-230,O,L,H,C)
                +0.000365047264249*PriceSeries(Price,index-231,O,L,H,C)
                +0.000560805758543*PriceSeries(Price,index-232,O,L,H,C)
                +0.000737400223586*PriceSeries(Price,index-233,O,L,H,C)
                +0.000890559671160*PriceSeries(Price,index-234,O,L,H,C)
                +0.001016734670640*PriceSeries(Price,index-235,O,L,H,C)
                +0.001113169470884*PriceSeries(Price,index-236,O,L,H,C)
                +0.001177961846876*PriceSeries(Price,index-237,O,L,H,C)
                +0.001210092176773*PriceSeries(Price,index-238,O,L,H,C)
                +0.001209434680059*PriceSeries(Price,index-239,O,L,H,C)
                +0.001176734415929*PriceSeries(Price,index-240,O,L,H,C)
                +0.001113575233960*PriceSeries(Price,index-241,O,L,H,C)
                +0.001022313388221*PriceSeries(Price,index-242,O,L,H,C)
                +0.000906000958203*PriceSeries(Price,index-243,O,L,H,C)
                +0.000768284976574*PriceSeries(Price,index-244,O,L,H,C)
                +0.000613303031428*PriceSeries(Price,index-245,O,L,H,C)
                +0.000445552584264*PriceSeries(Price,index-246,O,L,H,C)
                +0.0002697766254939*PriceSeries(Price,index-247,O,L,H,C)
                +0.0000908155964783*PriceSeries(Price,index-248,O,L,H,C)
                -0.0000865082096711*PriceSeries(Price,index-249,O,L,H,C)
                -0.0002575316146358*PriceSeries(Price,index-250,O,L,H,C)
                -0.000417858293991*PriceSeries(Price,index-251,O,L,H,C)
                -0.000563484765636*PriceSeries(Price,index-252,O,L,H,C)
                -0.000690880711938*PriceSeries(Price,index-253,O,L,H,C)
                -0.000797089983013*PriceSeries(Price,index-254,O,L,H,C)
                -0.000879778976915*PriceSeries(Price,index-255,O,L,H,C)
                -0.000937298408014*PriceSeries(Price,index-256,O,L,H,C)
                -0.000968702116902*PriceSeries(Price,index-257,O,L,H,C)
                -0.000973762371973*PriceSeries(Price,index-258,O,L,H,C)
                -0.000952951486080*PriceSeries(Price,index-259,O,L,H,C)
                -0.000907423503507*PriceSeries(Price,index-260,O,L,H,C)
                -0.000838956608099*PriceSeries(Price,index-261,O,L,H,C)
                -0.000749900685048*PriceSeries(Price,index-262,O,L,H,C)
                -0.000643093731270*PriceSeries(Price,index-263,O,L,H,C)
                -0.000521781239545*PriceSeries(Price,index-264,O,L,H,C)
                -0.000389513798543*PriceSeries(Price,index-265,O,L,H,C)
                -0.0002500557370003*PriceSeries(Price,index-266,O,L,H,C)
                -0.0001072634668281*PriceSeries(Price,index-267,O,L,H,C)
                +0.0000349992712317*PriceSeries(Price,index-268,O,L,H,C)
                +0.0001729834764956*PriceSeries(Price,index-269,O,L,H,C)
                +0.0003031347662995*PriceSeries(Price,index-270,O,L,H,C)
                +0.000422200017937*PriceSeries(Price,index-271,O,L,H,C)
                +0.000527288859767*PriceSeries(Price,index-272,O,L,H,C)
                +0.000615961440338*PriceSeries(Price,index-273,O,L,H,C)
                +0.000686259906869*PriceSeries(Price,index-274,O,L,H,C)
                +0.000736771985019*PriceSeries(Price,index-275,O,L,H,C)
                +0.000766636486801*PriceSeries(Price,index-276,O,L,H,C)
                +0.000775564578780*PriceSeries(Price,index-277,O,L,H,C)
                +0.000763825663124*PriceSeries(Price,index-278,O,L,H,C)
                +0.000732234691581*PriceSeries(Price,index-279,O,L,H,C)
                +0.000682107827211*PriceSeries(Price,index-280,O,L,H,C)
                +0.000615225308219*PriceSeries(Price,index-281,O,L,H,C)
                +0.000533762571287*PriceSeries(Price,index-282,O,L,H,C)
                +0.000440230560345*PriceSeries(Price,index-283,O,L,H,C)
                +0.000337397314887*PriceSeries(Price,index-284,O,L,H,C)
                +0.0002282100219148*PriceSeries(Price,index-285,O,L,H,C)
                +0.0001157055226145*PriceSeries(Price,index-286,O,L,H,C)
                +0.000002941415396124*PriceSeries(Price,index-287,O,L,H,C)
                -0.0001071037033782*PriceSeries(Price,index-288,O,L,H,C)
                -0.0002115884120925*PriceSeries(Price,index-289,O,L,H,C)
                -0.0003078985614810*PriceSeries(Price,index-290,O,L,H,C)
                -0.000393694742564*PriceSeries(Price,index-291,O,L,H,C)
                -0.000466982064685*PriceSeries(Price,index-292,O,L,H,C)
                -0.000526136860844*PriceSeries(Price,index-293,O,L,H,C)
                -0.000569963415068*PriceSeries(Price,index-294,O,L,H,C)
                -0.000597690177518*PriceSeries(Price,index-295,O,L,H,C)
                -0.000608998598388*PriceSeries(Price,index-296,O,L,H,C)
                -0.000604008278504*PriceSeries(Price,index-297,O,L,H,C)
                -0.000583268688802*PriceSeries(Price,index-298,O,L,H,C)
                -0.000547730668107*PriceSeries(Price,index-299,O,L,H,C)
                -0.000498712988750*PriceSeries(Price,index-300,O,L,H,C)
                -0.000437852879714*PriceSeries(Price,index-301,O,L,H,C)
                -0.000367060908411*PriceSeries(Price,index-302,O,L,H,C)
                -0.0002884612055764*PriceSeries(Price,index-303,O,L,H,C)
                -0.0002043240858094*PriceSeries(Price,index-304,O,L,H,C)
                -0.0001170100657374*PriceSeries(Price,index-305,O,L,H,C)
                -0.00002890116865366*PriceSeries(Price,index-306,O,L,H,C)
                +0.0000576653251505*PriceSeries(Price,index-307,O,L,H,C)
                +0.0001404485232353*PriceSeries(Price,index-308,O,L,H,C)
                +0.0002173750520676*PriceSeries(Price,index-309,O,L,H,C)
                +0.0002865748666692*PriceSeries(Price,index-310,O,L,H,C)
                +0.000346434901684*PriceSeries(Price,index-311,O,L,H,C)
                +0.000395628237119*PriceSeries(Price,index-312,O,L,H,C)
                +0.000433152991905*PriceSeries(Price,index-313,O,L,H,C)
                +0.000458331312429*PriceSeries(Price,index-314,O,L,H,C)
                +0.000470839210683*PriceSeries(Price,index-315,O,L,H,C)
                +0.000470688284020*PriceSeries(Price,index-316,O,L,H,C)
                +0.000458226404657*PriceSeries(Price,index-317,O,L,H,C)
                +0.000434119032887*PriceSeries(Price,index-318,O,L,H,C)
                +0.000399313769273*PriceSeries(Price,index-319,O,L,H,C)
                +0.000355017972320*PriceSeries(Price,index-320,O,L,H,C)
                +0.0003026546337792*PriceSeries(Price,index-321,O,L,H,C)
                +0.0002438222769296*PriceSeries(Price,index-322,O,L,H,C)
                +0.0001802378417108*PriceSeries(Price,index-323,O,L,H,C)
                +0.0001137066860448*PriceSeries(Price,index-324,O,L,H,C)
                +0.0000460493822224*PriceSeries(Price,index-325,O,L,H,C)
                -0.00002092319056208*PriceSeries(Price,index-326,O,L,H,C)
                -0.0000854755122790*PriceSeries(Price,index-327,O,L,H,C)
                -0.0001459852372450*PriceSeries(Price,index-328,O,L,H,C)
                -0.0002009775820409*PriceSeries(Price,index-329,O,L,H,C)
                -0.0002491651875536*PriceSeries(Price,index-330,O,L,H,C)
                -0.0002894787469717*PriceSeries(Price,index-331,O,L,H,C)
                -0.000321084573587*PriceSeries(Price,index-332,O,L,H,C)
                -0.000343398883302*PriceSeries(Price,index-333,O,L,H,C)
                -0.000356103779368*PriceSeries(Price,index-334,O,L,H,C)
                -0.000359134146789*PriceSeries(Price,index-335,O,L,H,C)
                -0.000352688890222*PriceSeries(Price,index-336,O,L,H,C)
                -0.000337208369457*PriceSeries(Price,index-337,O,L,H,C)
                -0.0003133473898883*PriceSeries(Price,index-338,O,L,H,C)
                -0.0002819755066264*PriceSeries(Price,index-339,O,L,H,C)
                -0.0002441223257810*PriceSeries(Price,index-340,O,L,H,C)
                -0.0002009662115416*PriceSeries(Price,index-341,O,L,H,C)
                -0.0001537784970507*PriceSeries(Price,index-342,O,L,H,C)
                -0.0001039127154736*PriceSeries(Price,index-343,O,L,H,C)
                -0.0000527328087259*PriceSeries(Price,index-344,O,L,H,C)
                -0.000001622878343367*PriceSeries(Price,index-345,O,L,H,C)
                +0.0000481050921417*PriceSeries(Price,index-346,O,L,H,C)
                +0.0000951949288004*PriceSeries(Price,index-347,O,L,H,C)
                +0.0001385046422655*PriceSeries(Price,index-348,O,L,H,C)
                +0.0001770220389518*PriceSeries(Price,index-349,O,L,H,C)
                +0.0002098961412557*PriceSeries(Price,index-350,O,L,H,C)
                +0.0002364415027645*PriceSeries(Price,index-351,O,L,H,C)
                +0.0002561661865541*PriceSeries(Price,index-352,O,L,H,C)
                +0.0002687639480455*PriceSeries(Price,index-353,O,L,H,C)
                +0.0002741243321154*PriceSeries(Price,index-354,O,L,H,C)
                +0.0002723402421500*PriceSeries(Price,index-355,O,L,H,C)
                +0.0002636755502134*PriceSeries(Price,index-356,O,L,H,C)
                +0.0002485669458279*PriceSeries(Price,index-357,O,L,H,C)
                +0.0002276206086658*PriceSeries(Price,index-358,O,L,H,C)
                +0.0002015570938551*PriceSeries(Price,index-359,O,L,H,C)
                +0.0001712311466321*PriceSeries(Price,index-360,O,L,H,C)
                +0.0001375613837292*PriceSeries(Price,index-361,O,L,H,C)
                +0.0001015460072537*PriceSeries(Price,index-362,O,L,H,C)
                +0.0000641966628078*PriceSeries(Price,index-363,O,L,H,C)
                +0.00002656171003980*PriceSeries(Price,index-364,O,L,H,C)
                -0.00001038168342675*PriceSeries(Price,index-365,O,L,H,C)
                -0.0000456488669207*PriceSeries(Price,index-366,O,L,H,C)
                -0.0000783646231145*PriceSeries(Price,index-367,O,L,H,C)
                -0.0001077187964098*PriceSeries(Price,index-368,O,L,H,C)
                -0.0001330240770650*PriceSeries(Price,index-369,O,L,H,C)
                -0.0001537064891718*PriceSeries(Price,index-370,O,L,H,C)
                -0.0001693325148960*PriceSeries(Price,index-371,O,L,H,C)
                -0.0001795899819164*PriceSeries(Price,index-372,O,L,H,C)
                -0.0001843294445246*PriceSeries(Price,index-373,O,L,H,C)
                -0.0001835415658611*PriceSeries(Price,index-374,O,L,H,C)
                -0.0001773304899724*PriceSeries(Price,index-375,O,L,H,C)
                -0.0001659570983655*PriceSeries(Price,index-376,O,L,H,C)
                -0.0001497871312465*PriceSeries(Price,index-377,O,L,H,C)
                -0.0001292880941535*PriceSeries(Price,index-378,O,L,H,C)
                -0.0001050398415391*PriceSeries(Price,index-379,O,L,H,C)
                -0.0000776547604486*PriceSeries(Price,index-380,O,L,H,C)
                -0.0000478404767083*PriceSeries(Price,index-381,O,L,H,C)
                -0.00001631919430574*PriceSeries(Price,index-382,O,L,H,C)
                +0.00001614869278514*PriceSeries(Price,index-383,O,L,H,C)
                +0.0000488559511975*PriceSeries(Price,index-384,O,L,H,C)
                +0.0000810291427570*PriceSeries(Price,index-385,O,L,H,C)
                +0.0001120265811946*PriceSeries(Price,index-386,O,L,H,C)
                +0.0001411713219606*PriceSeries(Price,index-387,O,L,H,C)
                +0.0001679209927825*PriceSeries(Price,index-388,O,L,H,C)
                +0.0001917790891078*PriceSeries(Price,index-389,O,L,H,C)
                +0.0002123314364077*PriceSeries(Price,index-390,O,L,H,C)
                +0.0002292514527575*PriceSeries(Price,index-391,O,L,H,C)
                +0.0002423423578052*PriceSeries(Price,index-392,O,L,H,C)
                +0.0002514692232151*PriceSeries(Price,index-393,O,L,H,C)
                +0.0002565761536715*PriceSeries(Price,index-394,O,L,H,C)
                +0.0002577566048322*PriceSeries(Price,index-395,O,L,H,C)
                +0.0002551024837435*PriceSeries(Price,index-396,O,L,H,C)
                +0.0002488788260299*PriceSeries(Price,index-397,O,L,H,C)
                +0.0002393517436724*PriceSeries(Price,index-398,O,L,H,C)
                +0.0002268323786302*PriceSeries(Price,index-399,O,L,H,C)
                +0.0002117586144546*PriceSeries(Price,index-400,O,L,H,C)
                +0.0001945466518491*PriceSeries(Price,index-401,O,L,H,C)
                +0.0001756449549936*PriceSeries(Price,index-402,O,L,H,C)
                +0.0001554900360129*PriceSeries(Price,index-403,O,L,H,C)
                +0.0001346127003917*PriceSeries(Price,index-404,O,L,H,C)
                +0.0001133575148749*PriceSeries(Price,index-405,O,L,H,C)
                +0.0000923081524884*PriceSeries(Price,index-406,O,L,H,C)
                +0.0000716824937686*PriceSeries(Price,index-407,O,L,H,C)
                +0.0000519302374377*PriceSeries(Price,index-408,O,L,H,C)
                +0.0000333869334250*PriceSeries(Price,index-409,O,L,H,C)
                +0.00001628190983671*PriceSeries(Price,index-410,O,L,H,C)
                +0.000000799444387830*PriceSeries(Price,index-411,O,L,H,C)
                -0.00001285223030437*PriceSeries(Price,index-412,O,L,H,C)
                -0.00002454869596557*PriceSeries(Price,index-413,O,L,H,C)
                -0.0000343089183168*PriceSeries(Price,index-414,O,L,H,C)
                -0.0000418761453913*PriceSeries(Price,index-415,O,L,H,C)
                -0.0000478412653500*PriceSeries(Price,index-416,O,L,H,C)
                -0.0000516488550317*PriceSeries(Price,index-417,O,L,H,C)
                -0.0000537058505009*PriceSeries(Price,index-418,O,L,H,C)
                -0.0000542963567442*PriceSeries(Price,index-419,O,L,H,C)
                -0.0000534827313778*PriceSeries(Price,index-420,O,L,H,C)
                -0.0000513928283308*PriceSeries(Price,index-421,O,L,H,C)
                -0.0000482169235730*PriceSeries(Price,index-422,O,L,H,C)
                -0.0000442158496341*PriceSeries(Price,index-423,O,L,H,C)
                -0.0000396025003233*PriceSeries(Price,index-424,O,L,H,C)
                -0.0001337297542324*PriceSeries(Price,index-425,O,L,H,C)
                );

      case N42:
         return(
                0.0965096262084*PriceSeries(Price,index,O,L,H,C)
                +0.0960977694904*PriceSeries(Price,index-1,O,L,H,C)
                +0.0948685466091*PriceSeries(Price,index-2,O,L,H,C)
                +0.0928408831186*PriceSeries(Price,index-3,O,L,H,C)
                +0.0900459340866*PriceSeries(Price,index-4,O,L,H,C)
                +0.0865265117181*PriceSeries(Price,index-5,O,L,H,C)
                +0.0823362999149*PriceSeries(Price,index-6,O,L,H,C)
                +0.0775388714206*PriceSeries(Price,index-7,O,L,H,C)
                +0.0722065283318*PriceSeries(Price,index-8,O,L,H,C)
                +0.0664189872654*PriceSeries(Price,index-9,O,L,H,C)
                +0.0602619377778*PriceSeries(Price,index-10,O,L,H,C)
                +0.0538255004047*PriceSeries(Price,index-11,O,L,H,C)
                +0.0472026166301*PriceSeries(Price,index-12,O,L,H,C)
                +0.0404874016899*PriceSeries(Price,index-13,O,L,H,C)
                +0.0337734922806*PriceSeries(Price,index-14,O,L,H,C)
                +0.02715242266685*PriceSeries(Price,index-15,O,L,H,C)
                +0.02071205858008*PriceSeries(Price,index-16,O,L,H,C)
                +0.01453512118340*PriceSeries(Price,index-17,O,L,H,C)
                +0.00869782672982*PriceSeries(Price,index-18,O,L,H,C)
                +0.00326866894602*PriceSeries(Price,index-19,O,L,H,C)
                -0.001692634371936*PriceSeries(Price,index-20,O,L,H,C)
                -0.00613601234622*PriceSeries(Price,index-21,O,L,H,C)
                -0.01002171347706*PriceSeries(Price,index-22,O,L,H,C)
                -0.01332077120477*PriceSeries(Price,index-23,O,L,H,C)
                -0.01601525409750*PriceSeries(Price,index-24,O,L,H,C)
                -0.01809830114446*PriceSeries(Price,index-25,O,L,H,C)
                -0.01957394329837*PriceSeries(Price,index-26,O,L,H,C)
                -0.02045671901756*PriceSeries(Price,index-27,O,L,H,C)
                -0.02077109561795*PriceSeries(Price,index-28,O,L,H,C)
                -0.02055070989725*PriceSeries(Price,index-29,O,L,H,C)
                -0.01983744879137*PriceSeries(Price,index-30,O,L,H,C)
                -0.01868038934081*PriceSeries(Price,index-31,O,L,H,C)
                -0.01713462425980*PriceSeries(Price,index-32,O,L,H,C)
                -0.01525999782428*PriceSeries(Price,index-33,O,L,H,C)
                -0.01311978017698*PriceSeries(Price,index-34,O,L,H,C)
                -0.01077930908453*PriceSeries(Price,index-35,O,L,H,C)
                -0.00830462598553*PriceSeries(Price,index-36,O,L,H,C)
                -0.00576113689205*PriceSeries(Price,index-37,O,L,H,C)
                -0.00321232298632*PriceSeries(Price,index-38,O,L,H,C)
                -0.000718528476294*PriceSeries(Price,index-39,O,L,H,C)
                +0.001664152179357*PriceSeries(Price,index-40,O,L,H,C)
                +0.00388486640599*PriceSeries(Price,index-41,O,L,H,C)
                +0.00589885631559*PriceSeries(Price,index-42,O,L,H,C)
                +0.00766815943578*PriceSeries(Price,index-43,O,L,H,C)
                +0.00916214390288*PriceSeries(Price,index-44,O,L,H,C)
                +0.01035787331396*PriceSeries(Price,index-45,O,L,H,C)
                +0.01124029595746*PriceSeries(Price,index-46,O,L,H,C)
                +0.01180225998824*PriceSeries(Price,index-47,O,L,H,C)
                +0.01204435850009*PriceSeries(Price,index-48,O,L,H,C)
                +0.01197461148666*PriceSeries(Price,index-49,O,L,H,C)
                +0.01160799788890*PriceSeries(Price,index-50,O,L,H,C)
                +0.01096584942803*PriceSeries(Price,index-51,O,L,H,C)
                +0.01007512559437*PriceSeries(Price,index-52,O,L,H,C)
                +0.00896758711026*PriceSeries(Price,index-53,O,L,H,C)
                +0.00767888977255*PriceSeries(Price,index-54,O,L,H,C)
                +0.00624762090246*PriceSeries(Price,index-55,O,L,H,C)
                +0.00471430046417*PriceSeries(Price,index-56,O,L,H,C)
                +0.003120372057336*PriceSeries(Price,index-57,O,L,H,C)
                +0.001507204019247*PriceSeries(Price,index-58,O,L,H,C)
                -0.0000848747065665*PriceSeries(Price,index-59,O,L,H,C)
                -0.001617484845465*PriceSeries(Price,index-60,O,L,H,C)
                -0.003055033345971*PriceSeries(Price,index-61,O,L,H,C)
                -0.00436545910283*PriceSeries(Price,index-62,O,L,H,C)
                -0.00552087448411*PriceSeries(Price,index-63,O,L,H,C)
                -0.00649808886907*PriceSeries(Price,index-64,O,L,H,C)
                -0.00727900803350*PriceSeries(Price,index-65,O,L,H,C)
                -0.00785090103691*PriceSeries(Price,index-66,O,L,H,C)
                -0.00820653383612*PriceSeries(Price,index-67,O,L,H,C)
                -0.00834416968298*PriceSeries(Price,index-68,O,L,H,C)
                -0.00826743952720*PriceSeries(Price,index-69,O,L,H,C)
                -0.00798509018099*PriceSeries(Price,index-70,O,L,H,C)
                -0.00751061737051*PriceSeries(Price,index-71,O,L,H,C)
                -0.00686179801354*PriceSeries(Price,index-72,O,L,H,C)
                -0.00606013287953*PriceSeries(Price,index-73,O,L,H,C)
                -0.00513021688327*PriceSeries(Price,index-74,O,L,H,C)
                -0.00409905334920*PriceSeries(Price,index-75,O,L,H,C)
                -0.002995329237588*PriceSeries(Price,index-76,O,L,H,C)
                -0.001848671009963*PriceSeries(Price,index-77,O,L,H,C)
                -0.000688897286957*PriceSeries(Price,index-78,O,L,H,C)
                +0.000454711248710*PriceSeries(Price,index-79,O,L,H,C)
                +0.001554110368043*PriceSeries(Price,index-80,O,L,H,C)
                +0.002583141677931*PriceSeries(Price,index-81,O,L,H,C)
                +0.00351811889022*PriceSeries(Price,index-82,O,L,H,C)
                +0.00433833940420*PriceSeries(Price,index-83,O,L,H,C)
                +0.00502650908631*PriceSeries(Price,index-84,O,L,H,C)
                +0.00556907441266*PriceSeries(Price,index-85,O,L,H,C)
                +0.00595645384734*PriceSeries(Price,index-86,O,L,H,C)
                +0.00618316789762*PriceSeries(Price,index-87,O,L,H,C)
                +0.00624786543822*PriceSeries(Price,index-88,O,L,H,C)
                +0.00615324845047*PriceSeries(Price,index-89,O,L,H,C)
                +0.00590590067322*PriceSeries(Price,index-90,O,L,H,C)
                +0.00551602473067*PriceSeries(Price,index-91,O,L,H,C)
                +0.00499709860716*PriceSeries(Price,index-92,O,L,H,C)
                +0.00436545928092*PriceSeries(Price,index-93,O,L,H,C)
                +0.00363982775686*PriceSeries(Price,index-94,O,L,H,C)
                +0.002840786814530*PriceSeries(Price,index-95,O,L,H,C)
                +0.001990225604399*PriceSeries(Price,index-96,O,L,H,C)
                +0.001110766749922*PriceSeries(Price,index-97,O,L,H,C)
                +0.0002251880238771*PriceSeries(Price,index-98,O,L,H,C)
                -0.000644144727861*PriceSeries(Price,index-99,O,L,H,C)
                -0.001475822133575*PriceSeries(Price,index-100,O,L,H,C)
                -0.002249898208241*PriceSeries(Price,index-101,O,L,H,C)
                -0.002948349651014*PriceSeries(Price,index-102,O,L,H,C)
                -0.00355547721008*PriceSeries(Price,index-103,O,L,H,C)
                -0.00405823919223*PriceSeries(Price,index-104,O,L,H,C)
                -0.00444651299667*PriceSeries(Price,index-105,O,L,H,C)
                -0.00471327714301*PriceSeries(Price,index-106,O,L,H,C)
                -0.00485471345021*PriceSeries(Price,index-107,O,L,H,C)
                -0.00487022668498*PriceSeries(Price,index-108,O,L,H,C)
                -0.00476238451438*PriceSeries(Price,index-109,O,L,H,C)
                -0.00453678082525*PriceSeries(Price,index-110,O,L,H,C)
                -0.00420182589788*PriceSeries(Price,index-111,O,L,H,C)
                -0.00376847299659*PriceSeries(Price,index-112,O,L,H,C)
                -0.00324988666970*PriceSeries(Price,index-113,O,L,H,C)
                -0.002661064702609*PriceSeries(Price,index-114,O,L,H,C)
                -0.002018422276037*PriceSeries(Price,index-115,O,L,H,C)
                -0.001339350552304*PriceSeries(Price,index-116,O,L,H,C)
                -0.000641761052253*PriceSeries(Price,index-117,O,L,H,C)
                +0.0000563740778548*PriceSeries(Price,index-118,O,L,H,C)
                +0.000737471408419*PriceSeries(Price,index-119,O,L,H,C)
                +0.001384767466651*PriceSeries(Price,index-120,O,L,H,C)
                +0.001982719141461*PriceSeries(Price,index-121,O,L,H,C)
                +0.002517365623585*PriceSeries(Price,index-122,O,L,H,C)
                +0.002976642795607*PriceSeries(Price,index-123,O,L,H,C)
                +0.00335064314784*PriceSeries(Price,index-124,O,L,H,C)
                +0.00363181748543*PriceSeries(Price,index-125,O,L,H,C)
                +0.00381511167562*PriceSeries(Price,index-126,O,L,H,C)
                +0.00389803989428*PriceSeries(Price,index-127,O,L,H,C)
                +0.00388069117054*PriceSeries(Price,index-128,O,L,H,C)
                +0.00376567184524*PriceSeries(Price,index-129,O,L,H,C)
                +0.00355798619996*PriceSeries(Price,index-130,O,L,H,C)
                +0.00326485932429*PriceSeries(Price,index-131,O,L,H,C)
                +0.002895509506917*PriceSeries(Price,index-132,O,L,H,C)
                +0.002460873778246*PriceSeries(Price,index-133,O,L,H,C)
                +0.001973297974703*PriceSeries(Price,index-134,O,L,H,C)
                +0.001446196901201*PriceSeries(Price,index-135,O,L,H,C)
                +0.000893695144105*PriceSeries(Price,index-136,O,L,H,C)
                +0.000330257817024*PriceSeries(Price,index-137,O,L,H,C)
                -0.0002296799722892*PriceSeries(Price,index-138,O,L,H,C)
                -0.000772074054661*PriceSeries(Price,index-139,O,L,H,C)
                -0.001283616748644*PriceSeries(Price,index-140,O,L,H,C)
                -0.001752054872299*PriceSeries(Price,index-141,O,L,H,C)
                -0.002166475843969*PriceSeries(Price,index-142,O,L,H,C)
                -0.002517554028670*PriceSeries(Price,index-143,O,L,H,C)
                -0.002797751895030*PriceSeries(Price,index-144,O,L,H,C)
                -0.003001472936938*PriceSeries(Price,index-145,O,L,H,C)
                -0.003125161599739*PriceSeries(Price,index-146,O,L,H,C)
                -0.00316735164549*PriceSeries(Price,index-147,O,L,H,C)
                -0.003128659038529*PriceSeries(Price,index-148,O,L,H,C)
                -0.003011724033204*PriceSeries(Price,index-149,O,L,H,C)
                -0.002821103556494*PriceSeries(Price,index-150,O,L,H,C)
                -0.002563117055226*PriceSeries(Price,index-151,O,L,H,C)
                -0.002245652020802*PriceSeries(Price,index-152,O,L,H,C)
                -0.001877932788069*PriceSeries(Price,index-153,O,L,H,C)
                -0.001470262140782*PriceSeries(Price,index-154,O,L,H,C)
                -0.001033739136758*PriceSeries(Price,index-155,O,L,H,C)
                -0.000579964058145*PriceSeries(Price,index-156,O,L,H,C)
                -0.0001207364994826*PriceSeries(Price,index-157,O,L,H,C)
                +0.000332246350028*PriceSeries(Price,index-158,O,L,H,C)
                +0.000767681550660*PriceSeries(Price,index-159,O,L,H,C)
                +0.001174937655182*PriceSeries(Price,index-160,O,L,H,C)
                +0.001544307864736*PriceSeries(Price,index-161,O,L,H,C)
                +0.001867236856744*PriceSeries(Price,index-162,O,L,H,C)
                +0.002136512712567*PriceSeries(Price,index-163,O,L,H,C)
                +0.002346421395752*PriceSeries(Price,index-164,O,L,H,C)
                +0.002492861303136*PriceSeries(Price,index-165,O,L,H,C)
                +0.002573413357420*PriceSeries(Price,index-166,O,L,H,C)
                +0.002587368830834*PriceSeries(Price,index-167,O,L,H,C)
                +0.002535712124370*PriceSeries(Price,index-168,O,L,H,C)
                +0.002421063048880*PriceSeries(Price,index-169,O,L,H,C)
                +0.002247577476247*PriceSeries(Price,index-170,O,L,H,C)
                +0.002020811523821*PriceSeries(Price,index-171,O,L,H,C)
                +0.001747554307239*PriceSeries(Price,index-172,O,L,H,C)
                +0.001435631245801*PriceSeries(Price,index-173,O,L,H,C)
                +0.001093686860372*PriceSeries(Price,index-174,O,L,H,C)
                +0.000730949675181*PriceSeries(Price,index-175,O,L,H,C)
                +0.000356988619419*PriceSeries(Price,index-176,O,L,H,C)
                -0.00001853567441161*PriceSeries(Price,index-177,O,L,H,C)
                -0.000386116419724*PriceSeries(Price,index-178,O,L,H,C)
                -0.000736636331048*PriceSeries(Price,index-179,O,L,H,C)
                -0.001061590975174*PriceSeries(Price,index-180,O,L,H,C)
                -0.001353290341195*PriceSeries(Price,index-181,O,L,H,C)
                -0.001605037330320*PriceSeries(Price,index-182,O,L,H,C)
                -0.001811276113709*PriceSeries(Price,index-183,O,L,H,C)
                -0.001967709965623*PriceSeries(Price,index-184,O,L,H,C)
                -0.002071384626851*PriceSeries(Price,index-185,O,L,H,C)
                -0.002120735172307*PriceSeries(Price,index-186,O,L,H,C)
                -0.002115599194465*PriceSeries(Price,index-187,O,L,H,C)
                -0.002057191909473*PriceSeries(Price,index-188,O,L,H,C)
                -0.001948048592677*PriceSeries(Price,index-189,O,L,H,C)
                -0.001791933735162*PriceSeries(Price,index-190,O,L,H,C)
                -0.001593722107575*PriceSeries(Price,index-191,O,L,H,C)
                -0.001359253698533*PriceSeries(Price,index-192,O,L,H,C)
                -0.001095166026561*PriceSeries(Price,index-193,O,L,H,C)
                -0.000808712045552*PriceSeries(Price,index-194,O,L,H,C)
                -0.000507563591514*PriceSeries(Price,index-195,O,L,H,C)
                -0.0001996101887833*PriceSeries(Price,index-196,O,L,H,C)
                +0.0001072446555555*PriceSeries(Price,index-197,O,L,H,C)
                +0.000405282882845*PriceSeries(Price,index-198,O,L,H,C)
                +0.000687163071728*PriceSeries(Price,index-199,O,L,H,C)
                +0.000946099182023*PriceSeries(Price,index-200,O,L,H,C)
                +0.001176019085451*PriceSeries(Price,index-201,O,L,H,C)
                +0.001371704849381*PriceSeries(Price,index-202,O,L,H,C)
                +0.001528906609993*PriceSeries(Price,index-203,O,L,H,C)
                +0.001644430776097*PriceSeries(Price,index-204,O,L,H,C)
                +0.001716199382637*PriceSeries(Price,index-205,O,L,H,C)
                +0.001743280002854*PriceSeries(Price,index-206,O,L,H,C)
                +0.001725887001066*PriceSeries(Price,index-207,O,L,H,C)
                +0.001665351476437*PriceSeries(Price,index-208,O,L,H,C)
                +0.001564066908765*PriceSeries(Price,index-209,O,L,H,C)
                +0.001425406487059*PriceSeries(Price,index-210,O,L,H,C)
                +0.001253618171099*PriceSeries(Price,index-211,O,L,H,C)
                +0.001053699757964*PriceSeries(Price,index-212,O,L,H,C)
                +0.000831257402268*PriceSeries(Price,index-213,O,L,H,C)
                +0.000592352760832*PriceSeries(Price,index-214,O,L,H,C)
                +0.000343339365542*PriceSeries(Price,index-215,O,L,H,C)
                +0.0000906980811465*PriceSeries(Price,index-216,O,L,H,C)
                -0.0001591302901882*PriceSeries(Price,index-217,O,L,H,C)
                -0.000399906803949*PriceSeries(Price,index-218,O,L,H,C)
                -0.000625747305510*PriceSeries(Price,index-219,O,L,H,C)
                -0.000831264058393*PriceSeries(Price,index-220,O,L,H,C)
                -0.001011690960928*PriceSeries(Price,index-221,O,L,H,C)
                -0.001162992781378*PriceSeries(Price,index-222,O,L,H,C)
                -0.001281950237243*PriceSeries(Price,index-223,O,L,H,C)
                -0.001366225726807*PriceSeries(Price,index-224,O,L,H,C)
                -0.001414404127137*PriceSeries(Price,index-225,O,L,H,C)
                -0.001426009077280*PriceSeries(Price,index-226,O,L,H,C)
                -0.001401496624886*PriceSeries(Price,index-227,O,L,H,C)
                -0.001342223861742*PriceSeries(Price,index-228,O,L,H,C)
                -0.001250397326910*PriceSeries(Price,index-229,O,L,H,C)
                -0.001128997732244*PriceSeries(Price,index-230,O,L,H,C)
                -0.000981690238819*PriceSeries(Price,index-231,O,L,H,C)
                -0.000812717828180*PriceSeries(Price,index-232,O,L,H,C)
                -0.000626781537147*PriceSeries(Price,index-233,O,L,H,C)
                -0.000428913261504*PriceSeries(Price,index-234,O,L,H,C)
                -0.0002243408365181*PriceSeries(Price,index-235,O,L,H,C)
                -0.00001835323574722*PriceSeries(Price,index-236,O,L,H,C)
                +0.0001838358413880*PriceSeries(Price,index-237,O,L,H,C)
                +0.000377216237324*PriceSeries(Price,index-238,O,L,H,C)
                +0.000557103904963*PriceSeries(Price,index-239,O,L,H,C)
                +0.000719253379261*PriceSeries(Price,index-240,O,L,H,C)
                +0.000859954254184*PriceSeries(Price,index-241,O,L,H,C)
                +0.000976114522152*PriceSeries(Price,index-242,O,L,H,C)
                +0.001065324385465*PriceSeries(Price,index-243,O,L,H,C)
                +0.001125904549310*PriceSeries(Price,index-244,O,L,H,C)
                +0.001156931797053*PriceSeries(Price,index-245,O,L,H,C)
                +0.001158246913379*PriceSeries(Price,index-246,O,L,H,C)
                +0.001130443366426*PriceSeries(Price,index-247,O,L,H,C)
                +0.001074834363374*PriceSeries(Price,index-248,O,L,H,C)
                +0.000993405947078*PriceSeries(Price,index-249,O,L,H,C)
                +0.000888751693458*PriceSeries(Price,index-250,O,L,H,C)
                +0.000763995931850*PriceSeries(Price,index-251,O,L,H,C)
                +0.000622701913016*PriceSeries(Price,index-252,O,L,H,C)
                +0.000468773169999*PriceSeries(Price,index-253,O,L,H,C)
                +0.0003063488683683*PriceSeries(Price,index-254,O,L,H,C)
                +0.0001396924407035*PriceSeries(Price,index-255,O,L,H,C)
                -0.00002691663067765*PriceSeries(Price,index-256,O,L,H,C)
                -0.0001892924852865*PriceSeries(Price,index-257,O,L,H,C)
                -0.000343445407998*PriceSeries(Price,index-258,O,L,H,C)
                -0.000485679581142*PriceSeries(Price,index-259,O,L,H,C)
                -0.000612678808966*PriceSeries(Price,index-260,O,L,H,C)
                -0.000721580911414*PriceSeries(Price,index-261,O,L,H,C)
                -0.000810042609698*PriceSeries(Price,index-262,O,L,H,C)
                -0.000876285173095*PriceSeries(Price,index-263,O,L,H,C)
                -0.000919128387201*PriceSeries(Price,index-264,O,L,H,C)
                -0.000938005908118*PriceSeries(Price,index-265,O,L,H,C)
                -0.000932966971173*PriceSeries(Price,index-266,O,L,H,C)
                -0.000904660819874*PriceSeries(Price,index-267,O,L,H,C)
                -0.000854306676904*PriceSeries(Price,index-268,O,L,H,C)
                -0.000783653073938*PriceSeries(Price,index-269,O,L,H,C)
                -0.000694919055519*PriceSeries(Price,index-270,O,L,H,C)
                -0.000590729589874*PriceSeries(Price,index-271,O,L,H,C)
                -0.000474039714246*PriceSeries(Price,index-272,O,L,H,C)
                -0.000348053730079*PriceSeries(Price,index-273,O,L,H,C)
                -0.0002161381637617*PriceSeries(Price,index-274,O,L,H,C)
                -0.0000817325002019*PriceSeries(Price,index-275,O,L,H,C)
                +0.0000517367365240*PriceSeries(Price,index-276,O,L,H,C)
                +0.0001809451431470*PriceSeries(Price,index-277,O,L,H,C)
                +0.0003027490681390*PriceSeries(Price,index-278,O,L,H,C)
                +0.000414261354665*PriceSeries(Price,index-279,O,L,H,C)
                +0.000512918178834*PriceSeries(Price,index-280,O,L,H,C)
                +0.000596537037797*PriceSeries(Price,index-281,O,L,H,C)
                +0.000663363489042*PriceSeries(Price,index-282,O,L,H,C)
                +0.000712102823389*PriceSeries(Price,index-283,O,L,H,C)
                +0.000741945684720*PriceSeries(Price,index-284,O,L,H,C)
                +0.000752574520217*PriceSeries(Price,index-285,O,L,H,C)
                +0.000744161520332*PriceSeries(Price,index-286,O,L,H,C)
                +0.000717353121862*PriceSeries(Price,index-287,O,L,H,C)
                +0.000673242452425*PriceSeries(Price,index-288,O,L,H,C)
                +0.000613331883273*PriceSeries(Price,index-289,O,L,H,C)
                +0.000539483747873*PriceSeries(Price,index-290,O,L,H,C)
                +0.000453869408262*PriceSeries(Price,index-291,O,L,H,C)
                +0.000358903834609*PriceSeries(Price,index-292,O,L,H,C)
                +0.0002571801622187*PriceSeries(Price,index-293,O,L,H,C)
                +0.0001514006609942*PriceSeries(Price,index-294,O,L,H,C)
                +0.0000443058205149*PriceSeries(Price,index-295,O,L,H,C)
                -0.0000613941778746*PriceSeries(Price,index-296,O,L,H,C)
                -0.0001630888444360*PriceSeries(Price,index-297,O,L,H,C)
                -0.0002583270938897*PriceSeries(Price,index-298,O,L,H,C)
                -0.000344879714038*PriceSeries(Price,index-299,O,L,H,C)
                -0.000420788300473*PriceSeries(Price,index-300,O,L,H,C)
                -0.000484406933654*PriceSeries(Price,index-301,O,L,H,C)
                -0.000534437436162*PriceSeries(Price,index-302,O,L,H,C)
                -0.000569952557330*PriceSeries(Price,index-303,O,L,H,C)
                -0.000590412440005*PriceSeries(Price,index-304,O,L,H,C)
                -0.000595664704546*PriceSeries(Price,index-305,O,L,H,C)
                -0.000585943061294*PriceSeries(Price,index-306,O,L,H,C)
                -0.000561849542203*PriceSeries(Price,index-307,O,L,H,C)
                -0.000524330119554*PriceSeries(Price,index-308,O,L,H,C)
                -0.000474645454289*PriceSeries(Price,index-309,O,L,H,C)
                -0.000414329386286*PriceSeries(Price,index-310,O,L,H,C)
                -0.000345145203792*PriceSeries(Price,index-311,O,L,H,C)
                -0.0002690318747188*PriceSeries(Price,index-312,O,L,H,C)
                -0.0001880563260076*PriceSeries(Price,index-313,O,L,H,C)
                -0.0001043558794645*PriceSeries(Price,index-314,O,L,H,C)
                -0.00002008240160205*PriceSeries(Price,index-315,O,L,H,C)
                +0.0000626492512163*PriceSeries(Price,index-316,O,L,H,C)
                +0.0001418168596985*PriceSeries(Price,index-317,O,L,H,C)
                +0.0002155366647047*PriceSeries(Price,index-318,O,L,H,C)
                +0.0002821099597200*PriceSeries(Price,index-319,O,L,H,C)
                +0.000340056115731*PriceSeries(Price,index-320,O,L,H,C)
                +0.000388148401675*PriceSeries(Price,index-321,O,L,H,C)
                +0.000425438748036*PriceSeries(Price,index-322,O,L,H,C)
                +0.000451270173288*PriceSeries(Price,index-323,O,L,H,C)
                +0.000465289845597*PriceSeries(Price,index-324,O,L,H,C)
                +0.000467447212187*PriceSeries(Price,index-325,O,L,H,C)
                +0.000457991362069*PriceSeries(Price,index-326,O,L,H,C)
                +0.000437453137753*PriceSeries(Price,index-327,O,L,H,C)
                +0.000406628502822*PriceSeries(Price,index-328,O,L,H,C)
                +0.000366550455094*PriceSeries(Price,index-329,O,L,H,C)
                +0.000318452204711*PriceSeries(Price,index-330,O,L,H,C)
                +0.0002637376645949*PriceSeries(Price,index-331,O,L,H,C)
                +0.0002039384107090*PriceSeries(Price,index-332,O,L,H,C)
                +0.0001406751695007*PriceSeries(Price,index-333,O,L,H,C)
                +0.0000756105226188*PriceSeries(Price,index-334,O,L,H,C)
                +0.00001041043524576*PriceSeries(Price,index-335,O,L,H,C)
                -0.0000532981202708*PriceSeries(Price,index-336,O,L,H,C)
                -0.0001139709582396*PriceSeries(Price,index-337,O,L,H,C)
                -0.0001701757288991*PriceSeries(Price,index-338,O,L,H,C)
                -0.0002206314401028*PriceSeries(Price,index-339,O,L,H,C)
                -0.0002642333340657*PriceSeries(Price,index-340,O,L,H,C)
                -0.0003000781576039*PriceSeries(Price,index-341,O,L,H,C)
                -0.000327476181124*PriceSeries(Price,index-342,O,L,H,C)
                -0.000345964341642*PriceSeries(Price,index-343,O,L,H,C)
                -0.000355317219100*PriceSeries(Price,index-344,O,L,H,C)
                -0.000355537769157*PriceSeries(Price,index-345,O,L,H,C)
                -0.000346858675223*PriceSeries(Price,index-346,O,L,H,C)
                -0.000329725092312*PriceSeries(Price,index-347,O,L,H,C)
                -0.0003047799527797*PriceSeries(Price,index-348,O,L,H,C)
                -0.0002728402307880*PriceSeries(Price,index-349,O,L,H,C)
                -0.0002348748406312*PriceSeries(Price,index-350,O,L,H,C)
                -0.0001919805679084*PriceSeries(Price,index-351,O,L,H,C)
                -0.0001453400042371*PriceSeries(Price,index-352,O,L,H,C)
                -0.0000962002830486*PriceSeries(Price,index-353,O,L,H,C)
                -0.0000458351244363*PriceSeries(Price,index-354,O,L,H,C)
                +0.00000448552576661*PriceSeries(Price,index-355,O,L,H,C)
                +0.0000535296920118*PriceSeries(Price,index-356,O,L,H,C)
                +0.0001001325362048*PriceSeries(Price,index-357,O,L,H,C)
                +0.0001432196881428*PriceSeries(Price,index-358,O,L,H,C)
                +0.0001818413991065*PriceSeries(Price,index-359,O,L,H,C)
                +0.0002151772287768*PriceSeries(Price,index-360,O,L,H,C)
                +0.0002425610937205*PriceSeries(Price,index-361,O,L,H,C)
                +0.0002634936499380*PriceSeries(Price,index-362,O,L,H,C)
                +0.0002776509119448*PriceSeries(Price,index-363,O,L,H,C)
                +0.0002848860703192*PriceSeries(Price,index-364,O,L,H,C)
                +0.0002852231902713*PriceSeries(Price,index-365,O,L,H,C)
                +0.0002788639550565*PriceSeries(Price,index-366,O,L,H,C)
                +0.0002661619261797*PriceSeries(Price,index-367,O,L,H,C)
                +0.0002476220903164*PriceSeries(Price,index-368,O,L,H,C)
                +0.0002238816643550*PriceSeries(Price,index-369,O,L,H,C)
                +0.0001956868709795*PriceSeries(Price,index-370,O,L,H,C)
                +0.0001638736923109*PriceSeries(Price,index-371,O,L,H,C)
                +0.0001293427617527*PriceSeries(Price,index-372,O,L,H,C)
                +0.0000930492337735*PriceSeries(Price,index-373,O,L,H,C)
                +0.0000559563010201*PriceSeries(Price,index-374,O,L,H,C)
                +0.00001902552710625*PriceSeries(Price,index-375,O,L,H,C)
                -0.00001681000210368*PriceSeries(Price,index-376,O,L,H,C)
                -0.0000506709023717*PriceSeries(Price,index-377,O,L,H,C)
                -0.0000817434243219*PriceSeries(Price,index-378,O,L,H,C)
                -0.0001093034971853*PriceSeries(Price,index-379,O,L,H,C)
                -0.0001327213502600*PriceSeries(Price,index-380,O,L,H,C)
                -0.0001514988190141*PriceSeries(Price,index-381,O,L,H,C)
                -0.0001652539471909*PriceSeries(Price,index-382,O,L,H,C)
                -0.0001737305847134*PriceSeries(Price,index-383,O,L,H,C)
                -0.0001768092820403*PriceSeries(Price,index-384,O,L,H,C)
                -0.0001744956149838*PriceSeries(Price,index-385,O,L,H,C)
                -0.0001669257889263*PriceSeries(Price,index-386,O,L,H,C)
                -0.0001543436693192*PriceSeries(Price,index-387,O,L,H,C)
                -0.0001371166811702*PriceSeries(Price,index-388,O,L,H,C)
                -0.0001156966563333*PriceSeries(Price,index-389,O,L,H,C)
                -0.0000906224066039*PriceSeries(Price,index-390,O,L,H,C)
                -0.0000625181244533*PriceSeries(Price,index-391,O,L,H,C)
                -0.0000320516804967*PriceSeries(Price,index-392,O,L,H,C)
                +0.000000071066506431*PriceSeries(Price,index-393,O,L,H,C)
                +0.0000331409871061*PriceSeries(Price,index-394,O,L,H,C)
                +0.0000664288619514*PriceSeries(Price,index-395,O,L,H,C)
                +0.0000992359695205*PriceSeries(Price,index-396,O,L,H,C)
                +0.0001308912870693*PriceSeries(Price,index-397,O,L,H,C)
                +0.0001607557807027*PriceSeries(Price,index-398,O,L,H,C)
                +0.0001882713653563*PriceSeries(Price,index-399,O,L,H,C)
                +0.0002129371470517*PriceSeries(Price,index-400,O,L,H,C)
                +0.0002343366469360*PriceSeries(Price,index-401,O,L,H,C)
                +0.0002521128872990*PriceSeries(Price,index-402,O,L,H,C)
                +0.0002660247881853*PriceSeries(Price,index-403,O,L,H,C)
                +0.0002759180078136*PriceSeries(Price,index-404,O,L,H,C)
                +0.0002817037395530*PriceSeries(Price,index-405,O,L,H,C)
                +0.0002834083124504*PriceSeries(Price,index-406,O,L,H,C)
                +0.0002811185100131*PriceSeries(Price,index-407,O,L,H,C)
                +0.0002750221313583*PriceSeries(Price,index-408,O,L,H,C)
                +0.0002653650939805*PriceSeries(Price,index-409,O,L,H,C)
                +0.0002524912844252*PriceSeries(Price,index-410,O,L,H,C)
                +0.0002367700987321*PriceSeries(Price,index-411,O,L,H,C)
                +0.0002185694457775*PriceSeries(Price,index-412,O,L,H,C)
                +0.0001983453108588*PriceSeries(Price,index-413,O,L,H,C)
                +0.0001765369306810*PriceSeries(Price,index-414,O,L,H,C)
                +0.0001536216494457*PriceSeries(Price,index-415,O,L,H,C)
                +0.0001300448037978*PriceSeries(Price,index-416,O,L,H,C)
                +0.0001062820940201*PriceSeries(Price,index-417,O,L,H,C)
                +0.0000827637152785*PriceSeries(Price,index-418,O,L,H,C)
                +0.0000598590652617*PriceSeries(Price,index-419,O,L,H,C)
                +0.0000380066008167*PriceSeries(Price,index-420,O,L,H,C)
                +0.00001747708877169*PriceSeries(Price,index-421,O,L,H,C)
                -0.000001476996818727*PriceSeries(Price,index-422,O,L,H,C)
                -0.00001867298226006*PriceSeries(Price,index-423,O,L,H,C)
                -0.0000338758110069*PriceSeries(Price,index-424,O,L,H,C)
                -0.0000469392970221*PriceSeries(Price,index-425,O,L,H,C)
                -0.0000578629346429*PriceSeries(Price,index-426,O,L,H,C)
                -0.0000665080387369*PriceSeries(Price,index-427,O,L,H,C)
                -0.0000730757804452*PriceSeries(Price,index-428,O,L,H,C)
                -0.0000776184383490*PriceSeries(Price,index-429,O,L,H,C)
                -0.0000802081894338*PriceSeries(Price,index-430,O,L,H,C)
                -0.0000808518982398*PriceSeries(Price,index-431,O,L,H,C)
                -0.0000798073026656*PriceSeries(Price,index-432,O,L,H,C)
                -0.0000776072359926*PriceSeries(Price,index-433,O,L,H,C)
                -0.0000738187441967*PriceSeries(Price,index-434,O,L,H,C)
                -0.0000691915461487*PriceSeries(Price,index-435,O,L,H,C)
                -0.0000636861086720*PriceSeries(Price,index-436,O,L,H,C)
                -0.0000575943910202*PriceSeries(Price,index-437,O,L,H,C)
                -0.0000511126937126*PriceSeries(Price,index-438,O,L,H,C)
                -0.0000444386447372*PriceSeries(Price,index-439,O,L,H,C)
                -0.0001269088776852*PriceSeries(Price,index-440,O,L,H,C)
                );

      case N43:
         return(
                0.0995428079507*PriceSeries(Price,index,O,L,H,C)
                +0.0987359235080*PriceSeries(Price,index-1,O,L,H,C)
                +0.0971339691408*PriceSeries(Price,index-2,O,L,H,C)
                +0.0947603657574*PriceSeries(Price,index-3,O,L,H,C)
                +0.0916497326943*PriceSeries(Price,index-4,O,L,H,C)
                +0.0878472826998*PriceSeries(Price,index-5,O,L,H,C)
                +0.0834080356743*PriceSeries(Price,index-6,O,L,H,C)
                +0.0783958602842*PriceSeries(Price,index-7,O,L,H,C)
                +0.0728823715572*PriceSeries(Price,index-8,O,L,H,C)
                +0.0669456917202*PriceSeries(Price,index-9,O,L,H,C)
                +0.0606691129024*PriceSeries(Price,index-10,O,L,H,C)
                +0.0541396729896*PriceSeries(Price,index-11,O,L,H,C)
                +0.0474466828611*PriceSeries(Price,index-12,O,L,H,C)
                +0.0406802223890*PriceSeries(Price,index-13,O,L,H,C)
                +0.0339296448570*PriceSeries(Price,index-14,O,L,H,C)
                +0.02728210388329*PriceSeries(Price,index-15,O,L,H,C)
                +0.02082114202872*PriceSeries(Price,index-16,O,L,H,C)
                +0.01462535798636*PriceSeries(Price,index-17,O,L,H,C)
                +0.00876718435950*PriceSeries(Price,index-18,O,L,H,C)
                +0.00331178704629*PriceSeries(Price,index-19,O,L,H,C)
                -0.001683882926336*PriceSeries(Price,index-20,O,L,H,C)
                -0.00617187930240*PriceSeries(Price,index-21,O,L,H,C)
                -0.01011387235588*PriceSeries(Price,index-22,O,L,H,C)
                -0.01348157924987*PriceSeries(Price,index-23,O,L,H,C)
                -0.01625700030728*PriceSeries(Price,index-24,O,L,H,C)
                -0.01843247038117*PriceSeries(Price,index-25,O,L,H,C)
                -0.02001051306428*PriceSeries(Price,index-26,O,L,H,C)
                -0.02100351893935*PriceSeries(Price,index-27,O,L,H,C)
                -0.02143324231517*PriceSeries(Price,index-28,O,L,H,C)
                -0.02133014491565*PriceSeries(Price,index-29,O,L,H,C)
                -0.02073258166265*PriceSeries(Price,index-30,O,L,H,C)
                -0.01968587063179*PriceSeries(Price,index-31,O,L,H,C)
                -0.01824124423166*PriceSeries(Price,index-32,O,L,H,C)
                -0.01645472583424*PriceSeries(Price,index-33,O,L,H,C)
                -0.01438593164101*PriceSeries(Price,index-34,O,L,H,C)
                -0.01209684995020*PriceSeries(Price,index-35,O,L,H,C)
                -0.00965059128205*PriceSeries(Price,index-36,O,L,H,C)
                -0.00711016626100*PriceSeries(Price,index-37,O,L,H,C)
                -0.00453728458280*PriceSeries(Price,index-38,O,L,H,C)
                -0.001991225361562*PriceSeries(Price,index-39,O,L,H,C)
                +0.000472226128155*PriceSeries(Price,index-40,O,L,H,C)
                +0.002801729142298*PriceSeries(Price,index-41,O,L,H,C)
                +0.00495123648672*PriceSeries(Price,index-42,O,L,H,C)
                +0.00688070262525*PriceSeries(Price,index-43,O,L,H,C)
                +0.00855666093768*PriceSeries(Price,index-44,O,L,H,C)
                +0.00995264120453*PriceSeries(Price,index-45,O,L,H,C)
                +0.01104944571782*PriceSeries(Price,index-46,O,L,H,C)
                +0.01183525865319*PriceSeries(Price,index-47,O,L,H,C)
                +0.01230561084785*PriceSeries(Price,index-48,O,L,H,C)
                +0.01246318796603*PriceSeries(Price,index-49,O,L,H,C)
                +0.01231750445170*PriceSeries(Price,index-50,O,L,H,C)
                +0.01188443825431*PriceSeries(Price,index-51,O,L,H,C)
                +0.01118565780465*PriceSeries(Price,index-52,O,L,H,C)
                +0.01024793511434*PriceSeries(Price,index-53,O,L,H,C)
                +0.00910238342348*PriceSeries(Price,index-54,O,L,H,C)
                +0.00778361726365*PriceSeries(Price,index-55,O,L,H,C)
                +0.00632887607674*PriceSeries(Price,index-56,O,L,H,C)
                +0.00477710568114*PriceSeries(Price,index-57,O,L,H,C)
                +0.00316804541820*PriceSeries(Price,index-58,O,L,H,C)
                +0.001541315050745*PriceSeries(Price,index-59,O,L,H,C)
                -0.0000644559746199*PriceSeries(Price,index-60,O,L,H,C)
                -0.001612464126426*PriceSeries(Price,index-61,O,L,H,C)
                -0.003068486545818*PriceSeries(Price,index-62,O,L,H,C)
                -0.00440157235155*PriceSeries(Price,index-63,O,L,H,C)
                -0.00558462556044*PriceSeries(Price,index-64,O,L,H,C)
                -0.00659489888887*PriceSeries(Price,index-65,O,L,H,C)
                -0.00741436477328*PriceSeries(Price,index-66,O,L,H,C)
                -0.00802998200900*PriceSeries(Price,index-67,O,L,H,C)
                -0.00843383162843*PriceSeries(Price,index-68,O,L,H,C)
                -0.00862314508592*PriceSeries(Price,index-69,O,L,H,C)
                -0.00860020825579*PriceSeries(Price,index-70,O,L,H,C)
                -0.00837216127924*PriceSeries(Price,index-71,O,L,H,C)
                -0.00795068697493*PriceSeries(Price,index-72,O,L,H,C)
                -0.00735161426908*PriceSeries(Price,index-73,O,L,H,C)
                -0.00659443195671*PriceSeries(Price,index-74,O,L,H,C)
                -0.00570173714965*PriceSeries(Price,index-75,O,L,H,C)
                -0.00469862622851*PriceSeries(Price,index-76,O,L,H,C)
                -0.00361204705349*PriceSeries(Price,index-77,O,L,H,C)
                -0.002470124004648*PriceSeries(Price,index-78,O,L,H,C)
                -0.001301478358339*PriceSeries(Price,index-79,O,L,H,C)
                -0.0001345508621294*PriceSeries(Price,index-80,O,L,H,C)
                +0.001003049991369*PriceSeries(Price,index-81,O,L,H,C)
                +0.002085166940107*PriceSeries(Price,index-82,O,L,H,C)
                +0.003087658503471*PriceSeries(Price,index-83,O,L,H,C)
                +0.00398890933515*PriceSeries(Price,index-84,O,L,H,C)
                +0.00477026367068*PriceSeries(Price,index-85,O,L,H,C)
                +0.00541638284661*PriceSeries(Price,index-86,O,L,H,C)
                +0.00591551403626*PriceSeries(Price,index-87,O,L,H,C)
                +0.00625967487381*PriceSeries(Price,index-88,O,L,H,C)
                +0.00644473890315*PriceSeries(Price,index-89,O,L,H,C)
                +0.00647043763510*PriceSeries(Price,index-90,O,L,H,C)
                +0.00634026625043*PriceSeries(Price,index-91,O,L,H,C)
                +0.00606130881612*PriceSeries(Price,index-92,O,L,H,C)
                +0.00564398196295*PriceSeries(Price,index-93,O,L,H,C)
                +0.00510170942547*PriceSeries(Price,index-94,O,L,H,C)
                +0.00445053248342*PriceSeries(Price,index-95,O,L,H,C)
                +0.00370866906449*PriceSeries(Price,index-96,O,L,H,C)
                +0.002896035175659*PriceSeries(Price,index-97,O,L,H,C)
                +0.002033734436032*PriceSeries(Price,index-98,O,L,H,C)
                +0.001143533993882*PriceSeries(Price,index-99,O,L,H,C)
                +0.0002473357835656*PriceSeries(Price,index-100,O,L,H,C)
                -0.000633339081910*PriceSeries(Price,index-101,O,L,H,C)
                -0.001477852545021*PriceSeries(Price,index-102,O,L,H,C)
                -0.002266910017046*PriceSeries(Price,index-103,O,L,H,C)
                -0.002982988867034*PriceSeries(Price,index-104,O,L,H,C)
                -0.00361070661114*PriceSeries(Price,index-105,O,L,H,C)
                -0.00413713774591*PriceSeries(Price,index-106,O,L,H,C)
                -0.00455205892298*PriceSeries(Price,index-107,O,L,H,C)
                -0.00484813286647*PriceSeries(Price,index-108,O,L,H,C)
                -0.00502101277352*PriceSeries(Price,index-109,O,L,H,C)
                -0.00506937975242*PriceSeries(Price,index-110,O,L,H,C)
                -0.00499490374427*PriceSeries(Price,index-111,O,L,H,C)
                -0.00480214093678*PriceSeries(Price,index-112,O,L,H,C)
                -0.00449835699900*PriceSeries(Price,index-113,O,L,H,C)
                -0.00409329830146*PriceSeries(Price,index-114,O,L,H,C)
                -0.00359890467127*PriceSeries(Price,index-115,O,L,H,C)
                -0.003028979255406*PriceSeries(Price,index-116,O,L,H,C)
                -0.002398819322412*PriceSeries(Price,index-117,O,L,H,C)
                -0.001724823162210*PriceSeries(Price,index-118,O,L,H,C)
                -0.001024073416589*PriceSeries(Price,index-119,O,L,H,C)
                -0.0003139211775791*PriceSeries(Price,index-120,O,L,H,C)
                +0.000388435706241*PriceSeries(Price,index-121,O,L,H,C)
                +0.001066353344566*PriceSeries(Price,index-122,O,L,H,C)
                +0.001704131378129*PriceSeries(Price,index-123,O,L,H,C)
                +0.002287358974191*PriceSeries(Price,index-124,O,L,H,C)
                +0.002803236257236*PriceSeries(Price,index-125,O,L,H,C)
                +0.00324083972743*PriceSeries(Price,index-126,O,L,H,C)
                +0.00359134834402*PriceSeries(Price,index-127,O,L,H,C)
                +0.00384820126278*PriceSeries(Price,index-128,O,L,H,C)
                +0.00400721633348*PriceSeries(Price,index-129,O,L,H,C)
                +0.00406663018717*PriceSeries(Price,index-130,O,L,H,C)
                +0.00402709952566*PriceSeries(Price,index-131,O,L,H,C)
                +0.00389162721417*PriceSeries(Price,index-132,O,L,H,C)
                +0.00366544961648*PriceSeries(Price,index-133,O,L,H,C)
                +0.00335585839324*PriceSeries(Price,index-134,O,L,H,C)
                +0.002971992359500*PriceSeries(Price,index-135,O,L,H,C)
                +0.002524575154662*PriceSeries(Price,index-136,O,L,H,C)
                +0.002025632638668*PriceSeries(Price,index-137,O,L,H,C)
                +0.001488174030332*PriceSeries(Price,index-138,O,L,H,C)
                +0.000925868969668*PriceSeries(Price,index-139,O,L,H,C)
                +0.000352700350175*PriceSeries(Price,index-140,O,L,H,C)
                -0.0002173700218663*PriceSeries(Price,index-141,O,L,H,C)
                -0.000770737691352*PriceSeries(Price,index-142,O,L,H,C)
                -0.001294470366092*PriceSeries(Price,index-143,O,L,H,C)
                -0.001776606192954*PriceSeries(Price,index-144,O,L,H,C)
                -0.002206415970867*PriceSeries(Price,index-145,O,L,H,C)
                -0.002574640394882*PriceSeries(Price,index-146,O,L,H,C)
                -0.002873676139476*PriceSeries(Price,index-147,O,L,H,C)
                -0.003097730023567*PriceSeries(Price,index-148,O,L,H,C)
                -0.00324291569682*PriceSeries(Price,index-149,O,L,H,C)
                -0.00330731620560*PriceSeries(Price,index-150,O,L,H,C)
                -0.00329098308672*PriceSeries(Price,index-151,O,L,H,C)
                -0.00319590285839*PriceSeries(Price,index-152,O,L,H,C)
                -0.003025906442143*PriceSeries(Price,index-153,O,L,H,C)
                -0.002786547560492*PriceSeries(Price,index-154,O,L,H,C)
                -0.002484927276955*PriceSeries(Price,index-155,O,L,H,C)
                -0.002129504156277*PriceSeries(Price,index-156,O,L,H,C)
                -0.001729855280970*PriceSeries(Price,index-157,O,L,H,C)
                -0.001296434602847*PriceSeries(Price,index-158,O,L,H,C)
                -0.000840298150505*PriceSeries(Price,index-159,O,L,H,C)
                -0.000372833995651*PriceSeries(Price,index-160,O,L,H,C)
                +0.0000945231979482*PriceSeries(Price,index-161,O,L,H,C)
                +0.000550560410263*PriceSeries(Price,index-162,O,L,H,C)
                +0.000984555213865*PriceSeries(Price,index-163,O,L,H,C)
                +0.001386519587685*PriceSeries(Price,index-164,O,L,H,C)
                +0.001747428872751*PriceSeries(Price,index-165,O,L,H,C)
                +0.002059413744002*PriceSeries(Price,index-166,O,L,H,C)
                +0.002315931771170*PriceSeries(Price,index-167,O,L,H,C)
                +0.002511896129402*PriceSeries(Price,index-168,O,L,H,C)
                +0.002643769158515*PriceSeries(Price,index-169,O,L,H,C)
                +0.002709618362884*PriceSeries(Price,index-170,O,L,H,C)
                +0.002709131332885*PriceSeries(Price,index-171,O,L,H,C)
                +0.002643591673797*PriceSeries(Price,index-172,O,L,H,C)
                +0.002515819686362*PriceSeries(Price,index-173,O,L,H,C)
                +0.002330073157712*PriceSeries(Price,index-174,O,L,H,C)
                +0.002091919295193*PriceSeries(Price,index-175,O,L,H,C)
                +0.001808074237996*PriceSeries(Price,index-176,O,L,H,C)
                +0.001486223678936*PriceSeries(Price,index-177,O,L,H,C)
                +0.001134816711514*PriceSeries(Price,index-178,O,L,H,C)
                +0.000762850117825*PriceSeries(Price,index-179,O,L,H,C)
                +0.000379642123749*PriceSeries(Price,index-180,O,L,H,C)
                -0.00000539530523832*PriceSeries(Price,index-181,O,L,H,C)
                -0.000382988865071*PriceSeries(Price,index-182,O,L,H,C)
                -0.000744217393324*PriceSeries(Price,index-183,O,L,H,C)
                -0.001080724683583*PriceSeries(Price,index-184,O,L,H,C)
                -0.001384904950873*PriceSeries(Price,index-185,O,L,H,C)
                -0.001650073130703*PriceSeries(Price,index-186,O,L,H,C)
                -0.001870607098374*PriceSeries(Price,index-187,O,L,H,C)
                -0.002042063019916*PriceSeries(Price,index-188,O,L,H,C)
                -0.002161259117142*PriceSeries(Price,index-189,O,L,H,C)
                -0.002226326553204*PriceSeries(Price,index-190,O,L,H,C)
                -0.002236732142643*PriceSeries(Price,index-191,O,L,H,C)
                -0.002193264025973*PriceSeries(Price,index-192,O,L,H,C)
                -0.002097987804633*PriceSeries(Price,index-193,O,L,H,C)
                -0.001954171583322*PriceSeries(Price,index-194,O,L,H,C)
                -0.001766189689678*PriceSeries(Price,index-195,O,L,H,C)
                -0.001539388638851*PriceSeries(Price,index-196,O,L,H,C)
                -0.001279948884587*PriceSeries(Price,index-197,O,L,H,C)
                -0.000994713005469*PriceSeries(Price,index-198,O,L,H,C)
                -0.000691015191386*PriceSeries(Price,index-199,O,L,H,C)
                -0.000376491294839*PriceSeries(Price,index-200,O,L,H,C)
                -0.0000588942980717*PriceSeries(Price,index-201,O,L,H,C)
                +0.0002540992127539*PriceSeries(Price,index-202,O,L,H,C)
                +0.000555067424068*PriceSeries(Price,index-203,O,L,H,C)
                +0.000837019425009*PriceSeries(Price,index-204,O,L,H,C)
                +0.001093551305566*PriceSeries(Price,index-205,O,L,H,C)
                +0.001318994598757*PriceSeries(Price,index-206,O,L,H,C)
                +0.001508531591299*PriceSeries(Price,index-207,O,L,H,C)
                +0.001658298760435*PriceSeries(Price,index-208,O,L,H,C)
                +0.001765461180979*PriceSeries(Price,index-209,O,L,H,C)
                +0.001828259900027*PriceSeries(Price,index-210,O,L,H,C)
                +0.001846033455478*PriceSeries(Price,index-211,O,L,H,C)
                +0.001819214751325*PriceSeries(Price,index-212,O,L,H,C)
                +0.001749295577955*PriceSeries(Price,index-213,O,L,H,C)
                +0.001638776384358*PriceSeries(Price,index-214,O,L,H,C)
                +0.001491081425442*PriceSeries(Price,index-215,O,L,H,C)
                +0.001310464685152*PriceSeries(Price,index-216,O,L,H,C)
                +0.001101883919298*PriceSeries(Price,index-217,O,L,H,C)
                +0.000870877051403*PriceSeries(Price,index-218,O,L,H,C)
                +0.000623411090133*PriceSeries(Price,index-219,O,L,H,C)
                +0.000365736071023*PriceSeries(Price,index-220,O,L,H,C)
                +0.0001042222851929*PriceSeries(Price,index-221,O,L,H,C)
                -0.0001547829649091*PriceSeries(Price,index-222,O,L,H,C)
                -0.000405122563355*PriceSeries(Price,index-223,O,L,H,C)
                -0.000640958709518*PriceSeries(Price,index-224,O,L,H,C)
                -0.000856920168889*PriceSeries(Price,index-225,O,L,H,C)
                -0.001048210824088*PriceSeries(Price,index-226,O,L,H,C)
                -0.001210723084840*PriceSeries(Price,index-227,O,L,H,C)
                -0.001341114212436*PriceSeries(Price,index-228,O,L,H,C)
                -0.001436881456689*PriceSeries(Price,index-229,O,L,H,C)
                -0.001496397409375*PriceSeries(Price,index-230,O,L,H,C)
                -0.001518938674709*PriceSeries(Price,index-231,O,L,H,C)
                -0.001504677983711*PriceSeries(Price,index-232,O,L,H,C)
                -0.001454673051466*PriceSeries(Price,index-233,O,L,H,C)
                -0.001370813816824*PriceSeries(Price,index-234,O,L,H,C)
                -0.001255766749121*PriceSeries(Price,index-235,O,L,H,C)
                -0.001112894561036*PriceSeries(Price,index-236,O,L,H,C)
                -0.000946161888915*PriceSeries(Price,index-237,O,L,H,C)
                -0.000760026531065*PriceSeries(Price,index-238,O,L,H,C)
                -0.000559326898801*PriceSeries(Price,index-239,O,L,H,C)
                -0.000349152116177*PriceSeries(Price,index-240,O,L,H,C)
                -0.0001347227701594*PriceSeries(Price,index-241,O,L,H,C)
                +0.0000787442495930*PriceSeries(Price,index-242,O,L,H,C)
                +0.0002861535239813*PriceSeries(Price,index-243,O,L,H,C)
                +0.000482660493698*PriceSeries(Price,index-244,O,L,H,C)
                +0.000663772873644*PriceSeries(Price,index-245,O,L,H,C)
                +0.000825458474503*PriceSeries(Price,index-246,O,L,H,C)
                +0.000964227510888*PriceSeries(Price,index-247,O,L,H,C)
                +0.001077214149722*PriceSeries(Price,index-248,O,L,H,C)
                +0.001162218650764*PriceSeries(Price,index-249,O,L,H,C)
                +0.001217764243437*PriceSeries(Price,index-250,O,L,H,C)
                +0.001243102217006*PriceSeries(Price,index-251,O,L,H,C)
                +0.001238228423783*PriceSeries(Price,index-252,O,L,H,C)
                +0.001203858152927*PriceSeries(Price,index-253,O,L,H,C)
                +0.001141402550383*PriceSeries(Price,index-254,O,L,H,C)
                +0.001052913548808*PriceSeries(Price,index-255,O,L,H,C)
                +0.000941029579998*PriceSeries(Price,index-256,O,L,H,C)
                +0.000808894489904*PriceSeries(Price,index-257,O,L,H,C)
                +0.000660075846161*PriceSeries(Price,index-258,O,L,H,C)
                +0.000498465306206*PriceSeries(Price,index-259,O,L,H,C)
                +0.000328187076241*PriceSeries(Price,index-260,O,L,H,C)
                +0.0001534877439837*PriceSeries(Price,index-261,O,L,H,C)
                -0.00002136788962980*PriceSeries(Price,index-262,O,L,H,C)
                -0.0001921938734540*PriceSeries(Price,index-263,O,L,H,C)
                -0.000354988195804*PriceSeries(Price,index-264,O,L,H,C)
                -0.000506021554480*PriceSeries(Price,index-265,O,L,H,C)
                -0.000641921914408*PriceSeries(Price,index-266,O,L,H,C)
                -0.000759749672618*PriceSeries(Price,index-267,O,L,H,C)
                -0.000857056339926*PriceSeries(Price,index-268,O,L,H,C)
                -0.000931935279547*PriceSeries(Price,index-269,O,L,H,C)
                -0.000983054311274*PriceSeries(Price,index-270,O,L,H,C)
                -0.001009680062354*PriceSeries(Price,index-271,O,L,H,C)
                -0.001011679318544*PriceSeries(Price,index-272,O,L,H,C)
                -0.000989509641148*PriceSeries(Price,index-273,O,L,H,C)
                -0.000944197492545*PriceSeries(Price,index-274,O,L,H,C)
                -0.000877305714586*PriceSeries(Price,index-275,O,L,H,C)
                -0.000790874021803*PriceSeries(Price,index-276,O,L,H,C)
                -0.000687373827024*PriceSeries(Price,index-277,O,L,H,C)
                -0.000569629309759*PriceSeries(Price,index-278,O,L,H,C)
                -0.000440748624081*PriceSeries(Price,index-279,O,L,H,C)
                -0.0003040405853989*PriceSeries(Price,index-280,O,L,H,C)
                -0.0001629313501315*PriceSeries(Price,index-281,O,L,H,C)
                -0.00002088061207206*PriceSeries(Price,index-282,O,L,H,C)
                +0.0001187022896741*PriceSeries(Price,index-283,O,L,H,C)
                +0.0002525365411684*PriceSeries(Price,index-284,O,L,H,C)
                +0.000377550509633*PriceSeries(Price,index-285,O,L,H,C)
                +0.000490948613978*PriceSeries(Price,index-286,O,L,H,C)
                +0.000590271670505*PriceSeries(Price,index-287,O,L,H,C)
                +0.000673445273796*PriceSeries(Price,index-288,O,L,H,C)
                +0.000738833689118*PriceSeries(Price,index-289,O,L,H,C)
                +0.000785250778266*PriceSeries(Price,index-290,O,L,H,C)
                +0.000811997236443*PriceSeries(Price,index-291,O,L,H,C)
                +0.000818852920198*PriceSeries(Price,index-292,O,L,H,C)
                +0.000806081935221*PriceSeries(Price,index-293,O,L,H,C)
                +0.000774408200056*PriceSeries(Price,index-294,O,L,H,C)
                +0.000724994530528*PriceSeries(Price,index-295,O,L,H,C)
                +0.000659398068860*PriceSeries(Price,index-296,O,L,H,C)
                +0.000579531850611*PriceSeries(Price,index-297,O,L,H,C)
                +0.000487606368958*PriceSeries(Price,index-298,O,L,H,C)
                +0.000386076052286*PriceSeries(Price,index-299,O,L,H,C)
                +0.0002775642498692*PriceSeries(Price,index-300,O,L,H,C)
                +0.0001648076720133*PriceSeries(Price,index-301,O,L,H,C)
                +0.0000505862079058*PriceSeries(Price,index-302,O,L,H,C)
                -0.0000623513284651*PriceSeries(Price,index-303,O,L,H,C)
                -0.0001713435257975*PriceSeries(Price,index-304,O,L,H,C)
                -0.0002738818104844*PriceSeries(Price,index-305,O,L,H,C)
                -0.000367669472995*PriceSeries(Price,index-306,O,L,H,C)
                -0.000450665412701*PriceSeries(Price,index-307,O,L,H,C)
                -0.000521136435276*PriceSeries(Price,index-308,O,L,H,C)
                -0.000577681824208*PriceSeries(Price,index-309,O,L,H,C)
                -0.000619268815231*PriceSeries(Price,index-310,O,L,H,C)
                -0.000645237341657*PriceSeries(Price,index-311,O,L,H,C)
                -0.000655321257977*PriceSeries(Price,index-312,O,L,H,C)
                -0.000649635876956*PriceSeries(Price,index-313,O,L,H,C)
                -0.000628673423528*PriceSeries(Price,index-314,O,L,H,C)
                -0.000593268588158*PriceSeries(Price,index-315,O,L,H,C)
                -0.000544597681509*PriceSeries(Price,index-316,O,L,H,C)
                -0.000484109222661*PriceSeries(Price,index-317,O,L,H,C)
                -0.000413513722443*PriceSeries(Price,index-318,O,L,H,C)
                -0.000334713578406*PriceSeries(Price,index-319,O,L,H,C)
                -0.0002497710876381*PriceSeries(Price,index-320,O,L,H,C)
                -0.0001608406751979*PriceSeries(Price,index-321,O,L,H,C)
                -0.0000701286034212*PriceSeries(Price,index-322,O,L,H,C)
                +0.00002017488668533*PriceSeries(Price,index-323,O,L,H,C)
                +0.0001079336039729*PriceSeries(Price,index-324,O,L,H,C)
                +0.0001911259325066*PriceSeries(Price,index-325,O,L,H,C)
                +0.0002678780260897*PriceSeries(Price,index-326,O,L,H,C)
                +0.000336523417262*PriceSeries(Price,index-327,O,L,H,C)
                +0.000395622381857*PriceSeries(Price,index-328,O,L,H,C)
                +0.000443992149766*PriceSeries(Price,index-329,O,L,H,C)
                +0.000480739795773*PriceSeries(Price,index-330,O,L,H,C)
                +0.000505265622541*PriceSeries(Price,index-331,O,L,H,C)
                +0.000517273312827*PriceSeries(Price,index-332,O,L,H,C)
                +0.000516775403110*PriceSeries(Price,index-333,O,L,H,C)
                +0.000504075530326*PriceSeries(Price,index-334,O,L,H,C)
                +0.000479766761505*PriceSeries(Price,index-335,O,L,H,C)
                +0.000444697524586*PriceSeries(Price,index-336,O,L,H,C)
                +0.000399957252250*PriceSeries(Price,index-337,O,L,H,C)
                +0.000346830580422*PriceSeries(Price,index-338,O,L,H,C)
                +0.0002867778172169*PriceSeries(Price,index-339,O,L,H,C)
                +0.0002213861259717*PriceSeries(Price,index-340,O,L,H,C)
                +0.0001523355863986*PriceSeries(Price,index-341,O,L,H,C)
                +0.0000813371247206*PriceSeries(Price,index-342,O,L,H,C)
                +0.00001012909286710*PriceSeries(Price,index-343,O,L,H,C)
                -0.0000596086641783*PriceSeries(Price,index-344,O,L,H,C)
                -0.0001262571394901*PriceSeries(Price,index-345,O,L,H,C)
                -0.0001883194451820*PriceSeries(Price,index-346,O,L,H,C)
                -0.0002444370205885*PriceSeries(Price,index-347,O,L,H,C)
                -0.0002934312361178*PriceSeries(Price,index-348,O,L,H,C)
                -0.000334316230623*PriceSeries(Price,index-349,O,L,H,C)
                -0.000366328546753*PriceSeries(Price,index-350,O,L,H,C)
                -0.000388929340613*PriceSeries(Price,index-351,O,L,H,C)
                -0.000401818240871*PriceSeries(Price,index-352,O,L,H,C)
                -0.000404925670815*PriceSeries(Price,index-353,O,L,H,C)
                -0.000398424369983*PriceSeries(Price,index-354,O,L,H,C)
                -0.000382711702009*PriceSeries(Price,index-355,O,L,H,C)
                -0.000358377914069*PriceSeries(Price,index-356,O,L,H,C)
                -0.000326219964742*PriceSeries(Price,index-357,O,L,H,C)
                -0.0002871885069759*PriceSeries(Price,index-358,O,L,H,C)
                -0.0002423762054496*PriceSeries(Price,index-359,O,L,H,C)
                -0.0001929853237919*PriceSeries(Price,index-360,O,L,H,C)
                -0.0001402941480820*PriceSeries(Price,index-361,O,L,H,C)
                -0.0000856289223892*PriceSeries(Price,index-362,O,L,H,C)
                -0.00003032706208351*PriceSeries(Price,index-363,O,L,H,C)
                +0.00002429217190224*PriceSeries(Price,index-364,O,L,H,C)
                +0.0000769629111148*PriceSeries(Price,index-365,O,L,H,C)
                +0.0001264958959182*PriceSeries(Price,index-366,O,L,H,C)
                +0.0001718014130159*PriceSeries(Price,index-367,O,L,H,C)
                +0.0002119168328830*PriceSeries(Price,index-368,O,L,H,C)
                +0.0002460456418677*PriceSeries(Price,index-369,O,L,H,C)
                +0.0002735244181311*PriceSeries(Price,index-370,O,L,H,C)
                +0.0002938858582775*PriceSeries(Price,index-371,O,L,H,C)
                +0.0003068312900905*PriceSeries(Price,index-372,O,L,H,C)
                +0.0003122470281564*PriceSeries(Price,index-373,O,L,H,C)
                +0.0003101997579370*PriceSeries(Price,index-374,O,L,H,C)
                +0.0003009281913186*PriceSeries(Price,index-375,O,L,H,C)
                +0.0002848372697909*PriceSeries(Price,index-376,O,L,H,C)
                +0.0002624797530565*PriceSeries(Price,index-377,O,L,H,C)
                +0.0002345448520703*PriceSeries(Price,index-378,O,L,H,C)
                +0.0002018283886750*PriceSeries(Price,index-379,O,L,H,C)
                +0.0001652176975811*PriceSeries(Price,index-380,O,L,H,C)
                +0.0001256693803573*PriceSeries(Price,index-381,O,L,H,C)
                +0.0000842037058360*PriceSeries(Price,index-382,O,L,H,C)
                +0.0000418172562207*PriceSeries(Price,index-383,O,L,H,C)
                -0.000000456093719097*PriceSeries(Price,index-384,O,L,H,C)
                -0.0000416393675241*PriceSeries(Price,index-385,O,L,H,C)
                -0.0000807917950551*PriceSeries(Price,index-386,O,L,H,C)
                -0.0001170534508073*PriceSeries(Price,index-387,O,L,H,C)
                -0.0001496460313261*PriceSeries(Price,index-388,O,L,H,C)
                -0.0001779046421809*PriceSeries(Price,index-389,O,L,H,C)
                -0.0002012741699124*PriceSeries(Price,index-390,O,L,H,C)
                -0.0002193373161338*PriceSeries(Price,index-391,O,L,H,C)
                -0.0002318043505686*PriceSeries(Price,index-392,O,L,H,C)
                -0.0002385325929859*PriceSeries(Price,index-393,O,L,H,C)
                -0.0002394974337738*PriceSeries(Price,index-394,O,L,H,C)
                -0.0002348122015367*PriceSeries(Price,index-395,O,L,H,C)
                -0.0002247499234699*PriceSeries(Price,index-396,O,L,H,C)
                -0.0002096557239965*PriceSeries(Price,index-397,O,L,H,C)
                -0.0001900088174039*PriceSeries(Price,index-398,O,L,H,C)
                -0.0001663766254349*PriceSeries(Price,index-399,O,L,H,C)
                -0.0001393954392800*PriceSeries(Price,index-400,O,L,H,C)
                -0.0001097749688365*PriceSeries(Price,index-401,O,L,H,C)
                -0.0000782543177066*PriceSeries(Price,index-402,O,L,H,C)
                -0.0000456125612679*PriceSeries(Price,index-403,O,L,H,C)
                -0.00001262140502940*PriceSeries(Price,index-404,O,L,H,C)
                +0.00001994232014917*PriceSeries(Price,index-405,O,L,H,C)
                +0.0000513490250192*PriceSeries(Price,index-406,O,L,H,C)
                +0.0000809033889786*PriceSeries(Price,index-407,O,L,H,C)
                +0.0001079807328955*PriceSeries(Price,index-408,O,L,H,C)
                +0.0001319652382862*PriceSeries(Price,index-409,O,L,H,C)
                +0.0001524283355361*PriceSeries(Price,index-410,O,L,H,C)
                +0.0001689359334864*PriceSeries(Price,index-411,O,L,H,C)
                +0.0001812049242275*PriceSeries(Price,index-412,O,L,H,C)
                +0.0001890202099593*PriceSeries(Price,index-413,O,L,H,C)
                +0.0001922882234704*PriceSeries(Price,index-414,O,L,H,C)
                +0.0001909938345399*PriceSeries(Price,index-415,O,L,H,C)
                +0.0001852387944981*PriceSeries(Price,index-416,O,L,H,C)
                +0.0001751950788648*PriceSeries(Price,index-417,O,L,H,C)
                +0.0001611417025800*PriceSeries(Price,index-418,O,L,H,C)
                +0.0001434147998348*PriceSeries(Price,index-419,O,L,H,C)
                +0.0001224403064700*PriceSeries(Price,index-420,O,L,H,C)
                +0.0000986628789470*PriceSeries(Price,index-421,O,L,H,C)
                +0.0000725569140888*PriceSeries(Price,index-422,O,L,H,C)
                +0.0000447358813613*PriceSeries(Price,index-423,O,L,H,C)
                +0.00001570068895225*PriceSeries(Price,index-424,O,L,H,C)
                -0.00001397705937462*PriceSeries(Price,index-425,O,L,H,C)
                -0.0000437370275000*PriceSeries(Price,index-426,O,L,H,C)
                -0.0000730564032298*PriceSeries(Price,index-427,O,L,H,C)
                -0.0001014149866056*PriceSeries(Price,index-428,O,L,H,C)
                -0.0001283555522735*PriceSeries(Price,index-429,O,L,H,C)
                -0.0001534396828197*PriceSeries(Price,index-430,O,L,H,C)
                -0.0001763076917124*PriceSeries(Price,index-431,O,L,H,C)
                -0.0001966306079338*PriceSeries(Price,index-432,O,L,H,C)
                -0.0002141736974234*PriceSeries(Price,index-433,O,L,H,C)
                -0.0002287553139786*PriceSeries(Price,index-434,O,L,H,C)
                -0.0002403083324248*PriceSeries(Price,index-435,O,L,H,C)
                -0.0002485958723663*PriceSeries(Price,index-436,O,L,H,C)
                -0.0002538215204938*PriceSeries(Price,index-437,O,L,H,C)
                -0.0002559551563319*PriceSeries(Price,index-438,O,L,H,C)
                -0.0002551483678454*PriceSeries(Price,index-439,O,L,H,C)
                -0.0002515521464910*PriceSeries(Price,index-440,O,L,H,C)
                -0.0002453906182601*PriceSeries(Price,index-441,O,L,H,C)
                -0.0002368937867000*PriceSeries(Price,index-442,O,L,H,C)
                -0.0002263522588595*PriceSeries(Price,index-443,O,L,H,C)
                -0.0002140499495692*PriceSeries(Price,index-444,O,L,H,C)
                -0.0002003202518602*PriceSeries(Price,index-445,O,L,H,C)
                -0.0001854813214544*PriceSeries(Price,index-446,O,L,H,C)
                -0.0001698966023957*PriceSeries(Price,index-447,O,L,H,C)
                -0.0001538927120595*PriceSeries(Price,index-448,O,L,H,C)
                -0.0001373675559957*PriceSeries(Price,index-449,O,L,H,C)
                -0.0001213340837295*PriceSeries(Price,index-450,O,L,H,C)
                -0.0001056047997711*PriceSeries(Price,index-451,O,L,H,C)
                -0.0000905079970951*PriceSeries(Price,index-452,O,L,H,C)
                -0.0000762642215664*PriceSeries(Price,index-453,O,L,H,C)
                -0.0000630412174608*PriceSeries(Price,index-454,O,L,H,C)
                -0.0000510154499374*PriceSeries(Price,index-455,O,L,H,C)
                -0.0000403084727022*PriceSeries(Price,index-456,O,L,H,C)
                -0.00003105458542250*PriceSeries(Price,index-457,O,L,H,C)
                -0.00002333903593336*PriceSeries(Price,index-458,O,L,H,C)
                -0.00001726964611184*PriceSeries(Price,index-459,O,L,H,C)
                -0.00001291835232729*PriceSeries(Price,index-460,O,L,H,C)
                -0.00001039751552499*PriceSeries(Price,index-461,O,L,H,C)
                +0.0001109543287096*PriceSeries(Price,index-462,O,L,H,C)
                );

      case N44:
         return(
                0.0965266056533*PriceSeries(Price,index,O,L,H,C)
                +0.0957803193257*PriceSeries(Price,index-1,O,L,H,C)
                +0.0942981660431*PriceSeries(Price,index-2,O,L,H,C)
                +0.0921008116224*PriceSeries(Price,index-3,O,L,H,C)
                +0.0892188231434*PriceSeries(Price,index-4,O,L,H,C)
                +0.0856921603368*PriceSeries(Price,index-5,O,L,H,C)
                +0.0815695123716*PriceSeries(Price,index-6,O,L,H,C)
                +0.0769074909162*PriceSeries(Price,index-7,O,L,H,C)
                +0.0717696947652*PriceSeries(Price,index-8,O,L,H,C)
                +0.0662256630728*PriceSeries(Price,index-9,O,L,H,C)
                +0.0603497374014*PriceSeries(Price,index-10,O,L,H,C)
                +0.0542198491824*PriceSeries(Price,index-11,O,L,H,C)
                +0.0479162592368*PriceSeries(Price,index-12,O,L,H,C)
                +0.0415202678006*PriceSeries(Price,index-13,O,L,H,C)
                +0.0351129219376*PriceSeries(Price,index-14,O,L,H,C)
                +0.02877373667600*PriceSeries(Price,index-15,O,L,H,C)
                +0.02257946302411*PriceSeries(Price,index-16,O,L,H,C)
                +0.01660291039136*PriceSeries(Price,index-17,O,L,H,C)
                +0.01091185789082*PriceSeries(Price,index-18,O,L,H,C)
                +0.00556805953752*PriceSeries(Price,index-19,O,L,H,C)
                +0.000626374093292*PriceSeries(Price,index-20,O,L,H,C)
                -0.00386598279495*PriceSeries(Price,index-21,O,L,H,C)
                -0.00787003505812*PriceSeries(Price,index-22,O,L,H,C)
                -0.01135549867902*PriceSeries(Price,index-23,O,L,H,C)
                -0.01430106885634*PriceSeries(Price,index-24,O,L,H,C)
                -0.01669455550439*PriceSeries(Price,index-25,O,L,H,C)
                -0.01853284826146*PriceSeries(Price,index-26,O,L,H,C)
                -0.01982173330364*PriceSeries(Price,index-27,O,L,H,C)
                -0.02057555085349*PriceSeries(Price,index-28,O,L,H,C)
                -0.02081671595874*PriceSeries(Price,index-29,O,L,H,C)
                -0.02057510073949*PriceSeries(Price,index-30,O,L,H,C)
                -0.01988730618997*PriceSeries(Price,index-31,O,L,H,C)
                -0.01879582315123*PriceSeries(Price,index-32,O,L,H,C)
                -0.01734811493450*PriceSeries(Price,index-33,O,L,H,C)
                -0.01559562567059*PriceSeries(Price,index-34,O,L,H,C)
                -0.01359274987521*PriceSeries(Price,index-35,O,L,H,C)
                -0.01139576482237*PriceSeries(Price,index-36,O,L,H,C)
                -0.00906176556506*PriceSeries(Price,index-37,O,L,H,C)
                -0.00664760430299*PriceSeries(Price,index-38,O,L,H,C)
                -0.00420887097693*PriceSeries(Price,index-39,O,L,H,C)
                -0.001798914770061*PriceSeries(Price,index-40,O,L,H,C)
                +0.000532053553103*PriceSeries(Price,index-41,O,L,H,C)
                +0.002737788896472*PriceSeries(Price,index-42,O,L,H,C)
                +0.00477672853636*PriceSeries(Price,index-43,O,L,H,C)
                +0.00661261212979*PriceSeries(Price,index-44,O,L,H,C)
                +0.00821497010515*PriceSeries(Price,index-45,O,L,H,C)
                +0.00955950103881*PriceSeries(Price,index-46,O,L,H,C)
                +0.01062830638200*PriceSeries(Price,index-47,O,L,H,C)
                +0.01141000649181*PriceSeries(Price,index-48,O,L,H,C)
                +0.01189971532523*PriceSeries(Price,index-49,O,L,H,C)
                +0.01209890151900*PriceSeries(Price,index-50,O,L,H,C)
                +0.01201511576746*PriceSeries(Price,index-51,O,L,H,C)
                +0.01166161950638*PriceSeries(Price,index-52,O,L,H,C)
                +0.01105690080996*PriceSeries(Price,index-53,O,L,H,C)
                +0.01022411006333*PriceSeries(Price,index-54,O,L,H,C)
                +0.00919041055283*PriceSeries(Price,index-55,O,L,H,C)
                +0.00798627794944*PriceSeries(Price,index-56,O,L,H,C)
                +0.00664474463295*PriceSeries(Price,index-57,O,L,H,C)
                +0.00520062378886*PriceSeries(Price,index-58,O,L,H,C)
                +0.00368971218311*PriceSeries(Price,index-59,O,L,H,C)
                +0.002148006806906*PriceSeries(Price,index-60,O,L,H,C)
                +0.000610930147176*PriceSeries(Price,index-61,O,L,H,C)
                -0.000887398575887*PriceSeries(Price,index-62,O,L,H,C)
                -0.002314852709891*PriceSeries(Price,index-63,O,L,H,C)
                -0.00364191673613*PriceSeries(Price,index-64,O,L,H,C)
                -0.00484224156243*PriceSeries(Price,index-65,O,L,H,C)
                -0.00589310515275*PriceSeries(Price,index-66,O,L,H,C)
                -0.00677579607428*PriceSeries(Price,index-67,O,L,H,C)
                -0.00747588899118*PriceSeries(Price,index-68,O,L,H,C)
                -0.00798343287152*PriceSeries(Price,index-69,O,L,H,C)
                -0.00829302660619*PriceSeries(Price,index-70,O,L,H,C)
                -0.00840380782357*PriceSeries(Price,index-71,O,L,H,C)
                -0.00831933355389*PriceSeries(Price,index-72,O,L,H,C)
                -0.00804737905257*PriceSeries(Price,index-73,O,L,H,C)
                -0.00759964296336*PriceSeries(Price,index-74,O,L,H,C)
                -0.00699138504875*PriceSeries(Price,index-75,O,L,H,C)
                -0.00624098675630*PriceSeries(Price,index-76,O,L,H,C)
                -0.00536946595444*PriceSeries(Price,index-77,O,L,H,C)
                -0.00439993981415*PriceSeries(Price,index-78,O,L,H,C)
                -0.00335706162621*PriceSeries(Price,index-79,O,L,H,C)
                -0.002266434229787*PriceSeries(Price,index-80,O,L,H,C)
                -0.001154023045042*PriceSeries(Price,index-81,O,L,H,C)
                -0.0000455717650683*PriceSeries(Price,index-82,O,L,H,C)
                +0.001033958728342*PriceSeries(Price,index-83,O,L,H,C)
                +0.002060923355797*PriceSeries(Price,index-84,O,L,H,C)
                +0.003013479240292*PriceSeries(Price,index-85,O,L,H,C)
                +0.00387202604064*PriceSeries(Price,index-86,O,L,H,C)
                +0.00461958058818*PriceSeries(Price,index-87,O,L,H,C)
                +0.00524208868623*PriceSeries(Price,index-88,O,L,H,C)
                +0.00572866238940*PriceSeries(Price,index-89,O,L,H,C)
                +0.00607174483268*PriceSeries(Price,index-90,O,L,H,C)
                +0.00626719252111*PriceSeries(Price,index-91,O,L,H,C)
                +0.00631428642561*PriceSeries(Price,index-92,O,L,H,C)
                +0.00621566163012*PriceSeries(Price,index-93,O,L,H,C)
                +0.00597716938988*PriceSeries(Price,index-94,O,L,H,C)
                +0.00560766598903*PriceSeries(Price,index-95,O,L,H,C)
                +0.00511874530066*PriceSeries(Price,index-96,O,L,H,C)
                +0.00452441271461*PriceSeries(Price,index-97,O,L,H,C)
                +0.00384071502787*PriceSeries(Price,index-98,O,L,H,C)
                +0.003085333238619*PriceSeries(Price,index-99,O,L,H,C)
                +0.002277148723259*PriceSeries(Price,index-100,O,L,H,C)
                +0.001435790857523*PriceSeries(Price,index-101,O,L,H,C)
                +0.000581179951411*PriceSeries(Price,index-102,O,L,H,C)
                -0.0002669254546533*PriceSeries(Price,index-103,O,L,H,C)
                -0.001089370700415*PriceSeries(Price,index-104,O,L,H,C)
                -0.001868019687371*PriceSeries(Price,index-105,O,L,H,C)
                -0.002586141765580*PriceSeries(Price,index-106,O,L,H,C)
                -0.00322875381629*PriceSeries(Price,index-107,O,L,H,C)
                -0.00378292170676*PriceSeries(Price,index-108,O,L,H,C)
                -0.00423800306425*PriceSeries(Price,index-109,O,L,H,C)
                -0.00458583853437*PriceSeries(Price,index-110,O,L,H,C)
                -0.00482087983644*PriceSeries(Price,index-111,O,L,H,C)
                -0.00494025958780*PriceSeries(Price,index-112,O,L,H,C)
                -0.00494379464522*PriceSeries(Price,index-113,O,L,H,C)
                -0.00483393586377*PriceSeries(Price,index-114,O,L,H,C)
                -0.00461565336954*PriceSeries(Price,index-115,O,L,H,C)
                -0.00429627194035*PriceSeries(Price,index-116,O,L,H,C)
                -0.00388525380829*PriceSeries(Price,index-117,O,L,H,C)
                -0.00339394128960*PriceSeries(Price,index-118,O,L,H,C)
                -0.002835258776722*PriceSeries(Price,index-119,O,L,H,C)
                -0.002223388630891*PriceSeries(Price,index-120,O,L,H,C)
                -0.001573422256155*PriceSeries(Price,index-121,O,L,H,C)
                -0.000901002177038*PriceSeries(Price,index-122,O,L,H,C)
                -0.0002219522631607*PriceSeries(Price,index-123,O,L,H,C)
                +0.000448079588825*PriceSeries(Price,index-124,O,L,H,C)
                +0.001093976527164*PriceSeries(Price,index-125,O,L,H,C)
                +0.001701481341398*PriceSeries(Price,index-126,O,L,H,C)
                +0.002257505812365*PriceSeries(Price,index-127,O,L,H,C)
                +0.002750398529456*PriceSeries(Price,index-128,O,L,H,C)
                +0.00317018629980*PriceSeries(Price,index-129,O,L,H,C)
                +0.00350876021375*PriceSeries(Price,index-130,O,L,H,C)
                +0.00376002866981*PriceSeries(Price,index-131,O,L,H,C)
                +0.00392000819606*PriceSeries(Price,index-132,O,L,H,C)
                +0.00398687925894*PriceSeries(Price,index-133,O,L,H,C)
                +0.00396097723986*PriceSeries(Price,index-134,O,L,H,C)
                +0.00384474810000*PriceSeries(Price,index-135,O,L,H,C)
                +0.00364264620209*PriceSeries(Price,index-136,O,L,H,C)
                +0.00336099844663*PriceSeries(Price,index-137,O,L,H,C)
                +0.003007817120615*PriceSeries(Price,index-138,O,L,H,C)
                +0.002592591742540*PriceSeries(Price,index-139,O,L,H,C)
                +0.002126038166267*PriceSeries(Price,index-140,O,L,H,C)
                +0.001619835768266*PriceSeries(Price,index-141,O,L,H,C)
                +0.001086338394728*PriceSeries(Price,index-142,O,L,H,C)
                +0.000538284664602*PriceSeries(Price,index-143,O,L,H,C)
                -0.00001150384973710*PriceSeries(Price,index-144,O,L,H,C)
                -0.000550412223040*PriceSeries(Price,index-145,O,L,H,C)
                -0.001066319348243*PriceSeries(Price,index-146,O,L,H,C)
                -0.001547859858740*PriceSeries(Price,index-147,O,L,H,C)
                -0.001984675082046*PriceSeries(Price,index-148,O,L,H,C)
                -0.002367622470865*PriceSeries(Price,index-149,O,L,H,C)
                -0.002688967300259*PriceSeries(Price,index-150,O,L,H,C)
                -0.002942527061298*PriceSeries(Price,index-151,O,L,H,C)
                -0.003123788398560*PriceSeries(Price,index-152,O,L,H,C)
                -0.00322997169671*PriceSeries(Price,index-153,O,L,H,C)
                -0.00326006945580*PriceSeries(Price,index-154,O,L,H,C)
                -0.00321482796273*PriceSeries(Price,index-155,O,L,H,C)
                -0.003096705389092*PriceSeries(Price,index-156,O,L,H,C)
                -0.002909775165730*PriceSeries(Price,index-157,O,L,H,C)
                -0.002659611674854*PriceSeries(Price,index-158,O,L,H,C)
                -0.002353126346635*PriceSeries(Price,index-159,O,L,H,C)
                -0.001998391999535*PriceSeries(Price,index-160,O,L,H,C)
                -0.001604431735024*PriceSeries(Price,index-161,O,L,H,C)
                -0.001181000342338*PriceSeries(Price,index-162,O,L,H,C)
                -0.000738341463392*PriceSeries(Price,index-163,O,L,H,C)
                -0.0002869517816650*PriceSeries(Price,index-164,O,L,H,C)
                +0.0001626695960280*PriceSeries(Price,index-165,O,L,H,C)
                +0.000600256171870*PriceSeries(Price,index-166,O,L,H,C)
                +0.001016008383868*PriceSeries(Price,index-167,O,L,H,C)
                +0.001400805183185*PriceSeries(Price,index-168,O,L,H,C)
                +0.001746403344041*PriceSeries(Price,index-169,O,L,H,C)
                +0.002045607017592*PriceSeries(Price,index-170,O,L,H,C)
                +0.002292415196634*PriceSeries(Price,index-171,O,L,H,C)
                +0.002482134019320*PriceSeries(Price,index-172,O,L,H,C)
                +0.002611465195264*PriceSeries(Price,index-173,O,L,H,C)
                +0.002678549732649*PriceSeries(Price,index-174,O,L,H,C)
                +0.002682989270278*PriceSeries(Price,index-175,O,L,H,C)
                +0.002625825065301*PriceSeries(Price,index-176,O,L,H,C)
                +0.002509491368162*PriceSeries(Price,index-177,O,L,H,C)
                +0.002337729968772*PriceSeries(Price,index-178,O,L,H,C)
                +0.002115486218501*PriceSeries(Price,index-179,O,L,H,C)
                +0.001848768303053*PriceSeries(Price,index-180,O,L,H,C)
                +0.001544496359205*PriceSeries(Price,index-181,O,L,H,C)
                +0.001210321550457*PriceSeries(Price,index-182,O,L,H,C)
                +0.000854444389627*PriceSeries(Price,index-183,O,L,H,C)
                +0.000485410736615*PriceSeries(Price,index-184,O,L,H,C)
                +0.0001119143549043*PriceSeries(Price,index-185,O,L,H,C)
                -0.0002574065793937*PriceSeries(Price,index-186,O,L,H,C)
                -0.000614164714580*PriceSeries(Price,index-187,O,L,H,C)
                -0.000950413764965*PriceSeries(Price,index-188,O,L,H,C)
                -0.001258818928172*PriceSeries(Price,index-189,O,L,H,C)
                -0.001532816410868*PriceSeries(Price,index-190,O,L,H,C)
                -0.001766748591442*PriceSeries(Price,index-191,O,L,H,C)
                -0.001955977275495*PriceSeries(Price,index-192,O,L,H,C)
                -0.002096972169506*PriceSeries(Price,index-193,O,L,H,C)
                -0.002187370676270*PriceSeries(Price,index-194,O,L,H,C)
                -0.002226013006943*PriceSeries(Price,index-195,O,L,H,C)
                -0.002212944121126*PriceSeries(Price,index-196,O,L,H,C)
                -0.002149393248405*PriceSeries(Price,index-197,O,L,H,C)
                -0.002037724717662*PriceSeries(Price,index-198,O,L,H,C)
                -0.001881361704982*PriceSeries(Price,index-199,O,L,H,C)
                -0.001684689442688*PriceSeries(Price,index-200,O,L,H,C)
                -0.001452938633990*PriceSeries(Price,index-201,O,L,H,C)
                -0.001192048892231*PriceSeries(Price,index-202,O,L,H,C)
                -0.000908520759800*PriceSeries(Price,index-203,O,L,H,C)
                -0.000609256934603*PriceSeries(Price,index-204,O,L,H,C)
                -0.0003013960493002*PriceSeries(Price,index-205,O,L,H,C)
                +0.00000785416326291*PriceSeries(Price,index-206,O,L,H,C)
                +0.0003113844191246*PriceSeries(Price,index-207,O,L,H,C)
                +0.000602342901345*PriceSeries(Price,index-208,O,L,H,C)
                +0.000874289652000*PriceSeries(Price,index-209,O,L,H,C)
                +0.001121337165903*PriceSeries(Price,index-210,O,L,H,C)
                +0.001338271858853*PriceSeries(Price,index-211,O,L,H,C)
                +0.001520665648329*PriceSeries(Price,index-212,O,L,H,C)
                +0.001664960363455*PriceSeries(Price,index-213,O,L,H,C)
                +0.001768535720781*PriceSeries(Price,index-214,O,L,H,C)
                +0.001829749904753*PriceSeries(Price,index-215,O,L,H,C)
                +0.001847963604718*PriceSeries(Price,index-216,O,L,H,C)
                +0.001823531089225*PriceSeries(Price,index-217,O,L,H,C)
                +0.001757780575022*PriceSeries(Price,index-218,O,L,H,C)
                +0.001652959428739*PriceSeries(Price,index-219,O,L,H,C)
                +0.001512174163446*PriceSeries(Price,index-220,O,L,H,C)
                +0.001339294328332*PriceSeries(Price,index-221,O,L,H,C)
                +0.001138858618040*PriceSeries(Price,index-222,O,L,H,C)
                +0.000915953324250*PriceSeries(Price,index-223,O,L,H,C)
                +0.000676089418321*PriceSeries(Price,index-224,O,L,H,C)
                +0.000425064231580*PriceSeries(Price,index-225,O,L,H,C)
                +0.0001688294907175*PriceSeries(Price,index-226,O,L,H,C)
                -0.0000866547233540*PriceSeries(Price,index-227,O,L,H,C)
                -0.000335550441171*PriceSeries(Price,index-228,O,L,H,C)
                -0.000572278355584*PriceSeries(Price,index-229,O,L,H,C)
                -0.000791637090274*PriceSeries(Price,index-230,O,L,H,C)
                -0.000988919350416*PriceSeries(Price,index-231,O,L,H,C)
                -0.001160007555669*PriceSeries(Price,index-232,O,L,H,C)
                -0.001301459285236*PriceSeries(Price,index-233,O,L,H,C)
                -0.001410572458369*PriceSeries(Price,index-234,O,L,H,C)
                -0.001485438119804*PriceSeries(Price,index-235,O,L,H,C)
                -0.001524961952206*PriceSeries(Price,index-236,O,L,H,C)
                -0.001528883399675*PriceSeries(Price,index-237,O,L,H,C)
                -0.001497758777848*PriceSeries(Price,index-238,O,L,H,C)
                -0.001432940064736*PriceSeries(Price,index-239,O,L,H,C)
                -0.001336522995707*PriceSeries(Price,index-240,O,L,H,C)
                -0.001211293139063*PriceSeries(Price,index-241,O,L,H,C)
                -0.001060639950185*PriceSeries(Price,index-242,O,L,H,C)
                -0.000888478340245*PriceSeries(Price,index-243,O,L,H,C)
                -0.000699138713842*PriceSeries(Price,index-244,O,L,H,C)
                -0.000497272306431*PriceSeries(Price,index-245,O,L,H,C)
                -0.0002877246682574*PriceSeries(Price,index-246,O,L,H,C)
                -0.0000754338662933*PriceSeries(Price,index-247,O,L,H,C)
                +0.0001346934543213*PriceSeries(Price,index-248,O,L,H,C)
                +0.000337887582933*PriceSeries(Price,index-249,O,L,H,C)
                +0.000529629142885*PriceSeries(Price,index-250,O,L,H,C)
                +0.000705739896960*PriceSeries(Price,index-251,O,L,H,C)
                +0.000862481458265*PriceSeries(Price,index-252,O,L,H,C)
                +0.000996623993341*PriceSeries(Price,index-253,O,L,H,C)
                +0.001105517819868*PriceSeries(Price,index-254,O,L,H,C)
                +0.001187137878407*PriceSeries(Price,index-255,O,L,H,C)
                +0.001240123817028*PriceSeries(Price,index-256,O,L,H,C)
                +0.001263794528269*PriceSeries(Price,index-257,O,L,H,C)
                +0.001258152940922*PriceSeries(Price,index-258,O,L,H,C)
                +0.001223872140018*PriceSeries(Price,index-259,O,L,H,C)
                +0.001162271533454*PriceSeries(Price,index-260,O,L,H,C)
                +0.001075266429960*PriceSeries(Price,index-261,O,L,H,C)
                +0.000965322577929*PriceSeries(Price,index-262,O,L,H,C)
                +0.000835380776543*PriceSeries(Price,index-263,O,L,H,C)
                +0.000688787379962*PriceSeries(Price,index-264,O,L,H,C)
                +0.000529204042623*PriceSeries(Price,index-265,O,L,H,C)
                +0.000360525078083*PriceSeries(Price,index-266,O,L,H,C)
                +0.0001867746521361*PriceSeries(Price,index-267,O,L,H,C)
                +0.00001202194153634*PriceSeries(Price,index-268,O,L,H,C)
                -0.0001597229349225*PriceSeries(Price,index-269,O,L,H,C)
                -0.000324587584330*PriceSeries(Price,index-270,O,L,H,C)
                -0.000478937850485*PriceSeries(Price,index-271,O,L,H,C)
                -0.000619443604454*PriceSeries(Price,index-272,O,L,H,C)
                -0.000743157605680*PriceSeries(Price,index-273,O,L,H,C)
                -0.000847570991784*PriceSeries(Price,index-274,O,L,H,C)
                -0.000930666388773*PriceSeries(Price,index-275,O,L,H,C)
                -0.000990949401671*PriceSeries(Price,index-276,O,L,H,C)
                -0.001027479769807*PriceSeries(Price,index-277,O,L,H,C)
                -0.001039875706857*PriceSeries(Price,index-278,O,L,H,C)
                -0.001028316051121*PriceSeries(Price,index-279,O,L,H,C)
                -0.000993523172496*PriceSeries(Price,index-280,O,L,H,C)
                -0.000936737871128*PriceSeries(Price,index-281,O,L,H,C)
                -0.000859680708550*PriceSeries(Price,index-282,O,L,H,C)
                -0.000764499949735*PriceSeries(Price,index-283,O,L,H,C)
                -0.000653718796804*PriceSeries(Price,index-284,O,L,H,C)
                -0.000530168850576*PriceSeries(Price,index-285,O,L,H,C)
                -0.000396916229119*PriceSeries(Price,index-286,O,L,H,C)
                -0.0002571922027719*PriceSeries(Price,index-287,O,L,H,C)
                -0.0001143112313591*PriceSeries(Price,index-288,O,L,H,C)
                +0.00002840423254256*PriceSeries(Price,index-289,O,L,H,C)
                +0.0001677005999019*PriceSeries(Price,index-290,O,L,H,C)
                +0.0003004644161983*PriceSeries(Price,index-291,O,L,H,C)
                +0.000423795067038*PriceSeries(Price,index-292,O,L,H,C)
                +0.000535062503561*PriceSeries(Price,index-293,O,L,H,C)
                +0.000631966778130*PriceSeries(Price,index-294,O,L,H,C)
                +0.000712576528948*PriceSeries(Price,index-295,O,L,H,C)
                +0.000775376525404*PriceSeries(Price,index-296,O,L,H,C)
                +0.000819284996939*PriceSeries(Price,index-297,O,L,H,C)
                +0.000843673577984*PriceSeries(Price,index-298,O,L,H,C)
                +0.000848373762309*PriceSeries(Price,index-299,O,L,H,C)
                +0.000833668519773*PriceSeries(Price,index-300,O,L,H,C)
                +0.000800278723258*PriceSeries(Price,index-301,O,L,H,C)
                +0.000749338362099*PriceSeries(Price,index-302,O,L,H,C)
                +0.000682360052459*PriceSeries(Price,index-303,O,L,H,C)
                +0.000601189943993*PriceSeries(Price,index-304,O,L,H,C)
                +0.000507963696432*PriceSeries(Price,index-305,O,L,H,C)
                +0.000405046572422*PriceSeries(Price,index-306,O,L,H,C)
                +0.0002949824280920*PriceSeries(Price,index-307,O,L,H,C)
                +0.0001804192531913*PriceSeries(Price,index-308,O,L,H,C)
                +0.0000640611691019*PriceSeries(Price,index-309,O,L,H,C)
                -0.0000514058658871*PriceSeries(Price,index-310,O,L,H,C)
                -0.0001633692614093*PriceSeries(Price,index-311,O,L,H,C)
                -0.0002693500665096*PriceSeries(Price,index-312,O,L,H,C)
                -0.000367055087369*PriceSeries(Price,index-313,O,L,H,C)
                -0.000454430609269*PriceSeries(Price,index-314,O,L,H,C)
                -0.000529696836567*PriceSeries(Price,index-315,O,L,H,C)
                -0.000591388932853*PriceSeries(Price,index-316,O,L,H,C)
                -0.000638380625873*PriceSeries(Price,index-317,O,L,H,C)
                -0.000669906227975*PriceSeries(Price,index-318,O,L,H,C)
                -0.000685567832536*PriceSeries(Price,index-319,O,L,H,C)
                -0.000685335275985*PriceSeries(Price,index-320,O,L,H,C)
                -0.000669544822255*PriceSeries(Price,index-321,O,L,H,C)
                -0.000638879403877*PriceSeries(Price,index-322,O,L,H,C)
                -0.000594344366485*PriceSeries(Price,index-323,O,L,H,C)
                -0.000537245687997*PriceSeries(Price,index-324,O,L,H,C)
                -0.000469142132942*PriceSeries(Price,index-325,O,L,H,C)
                -0.000391814721102*PriceSeries(Price,index-326,O,L,H,C)
                -0.0003072144834030*PriceSeries(Price,index-327,O,L,H,C)
                -0.0002174211570774*PriceSeries(Price,index-328,O,L,H,C)
                -0.0001245824104625*PriceSeries(Price,index-329,O,L,H,C)
                -0.00003087582690877*PriceSeries(Price,index-330,O,L,H,C)
                +0.0000615539608479*PriceSeries(Price,index-331,O,L,H,C)
                +0.0001506274481890*PriceSeries(Price,index-332,O,L,H,C)
                +0.0002343988604285*PriceSeries(Price,index-333,O,L,H,C)
                +0.0003110723152381*PriceSeries(Price,index-334,O,L,H,C)
                +0.000379061631929*PriceSeries(Price,index-335,O,L,H,C)
                +0.000437006934827*PriceSeries(Price,index-336,O,L,H,C)
                +0.000483809417899*PriceSeries(Price,index-337,O,L,H,C)
                +0.000518643579899*PriceSeries(Price,index-338,O,L,H,C)
                +0.000540981372889*PriceSeries(Price,index-339,O,L,H,C)
                +0.000550583243579*PriceSeries(Price,index-340,O,L,H,C)
                +0.000547509498037*PriceSeries(Price,index-341,O,L,H,C)
                +0.000532103279315*PriceSeries(Price,index-342,O,L,H,C)
                +0.000504985835706*PriceSeries(Price,index-343,O,L,H,C)
                +0.000467028255344*PriceSeries(Price,index-344,O,L,H,C)
                +0.000419327844947*PriceSeries(Price,index-345,O,L,H,C)
                +0.000363182379336*PriceSeries(Price,index-346,O,L,H,C)
                +0.0003000518718475*PriceSeries(Price,index-347,O,L,H,C)
                +0.0002315196316893*PriceSeries(Price,index-348,O,L,H,C)
                +0.0001592644666061*PriceSeries(Price,index-349,O,L,H,C)
                +0.0000850030455932*PriceSeries(Price,index-350,O,L,H,C)
                +0.00001046558593807*PriceSeries(Price,index-351,O,L,H,C)
                -0.0000626542309384*PriceSeries(Price,index-352,O,L,H,C)
                -0.0001327268522921*PriceSeries(Price,index-353,O,L,H,C)
                -0.0001982368357221*PriceSeries(Price,index-354,O,L,H,C)
                -0.0002577991680187*PriceSeries(Price,index-355,O,L,H,C)
                -0.0003102032721505*PriceSeries(Price,index-356,O,L,H,C)
                -0.000354416362827*PriceSeries(Price,index-357,O,L,H,C)
                -0.000389631570372*PriceSeries(Price,index-358,O,L,H,C)
                -0.000415248066587*PriceSeries(Price,index-359,O,L,H,C)
                -0.000430910052815*PriceSeries(Price,index-360,O,L,H,C)
                -0.000436488497168*PriceSeries(Price,index-361,O,L,H,C)
                -0.000432088778861*PriceSeries(Price,index-362,O,L,H,C)
                -0.000418036393322*PriceSeries(Price,index-363,O,L,H,C)
                -0.000394876186446*PriceSeries(Price,index-364,O,L,H,C)
                -0.000363339302894*PriceSeries(Price,index-365,O,L,H,C)
                -0.000324334408219*PriceSeries(Price,index-366,O,L,H,C)
                -0.0002789142579630*PriceSeries(Price,index-367,O,L,H,C)
                -0.0002282573812138*PriceSeries(Price,index-368,O,L,H,C)
                -0.0001736318482881*PriceSeries(Price,index-369,O,L,H,C)
                -0.0001163616682430*PriceSeries(Price,index-370,O,L,H,C)
                -0.0000578069939012*PriceSeries(Price,index-371,O,L,H,C)
                +0.000000681635829491*PriceSeries(Price,index-372,O,L,H,C)
                +0.0000577862242275*PriceSeries(Price,index-373,O,L,H,C)
                +0.0001122446993363*PriceSeries(Price,index-374,O,L,H,C)
                +0.0001628939903198*PriceSeries(Price,index-375,O,L,H,C)
                +0.0002086803824013*PriceSeries(Price,index-376,O,L,H,C)
                +0.0002486869716982*PriceSeries(Price,index-377,O,L,H,C)
                +0.0002821453757484*PriceSeries(Price,index-378,O,L,H,C)
                +0.0003084600074558*PriceSeries(Price,index-379,O,L,H,C)
                +0.000327206684932*PriceSeries(Price,index-380,O,L,H,C)
                +0.000338148354424*PriceSeries(Price,index-381,O,L,H,C)
                +0.000341218810077*PriceSeries(Price,index-382,O,L,H,C)
                +0.000336548443682*PriceSeries(Price,index-383,O,L,H,C)
                +0.000324420339168*PriceSeries(Price,index-384,O,L,H,C)
                +0.0003052946463264*PriceSeries(Price,index-385,O,L,H,C)
                +0.0002797727201281*PriceSeries(Price,index-386,O,L,H,C)
                +0.0002485833254581*PriceSeries(Price,index-387,O,L,H,C)
                +0.0002125663137183*PriceSeries(Price,index-388,O,L,H,C)
                +0.0001726544904406*PriceSeries(Price,index-389,O,L,H,C)
                +0.0001298420030160*PriceSeries(Price,index-390,O,L,H,C)
                +0.0000851635223517*PriceSeries(Price,index-391,O,L,H,C)
                +0.0000396702668518*PriceSeries(Price,index-392,O,L,H,C)
                -0.00000559398526922*PriceSeries(Price,index-393,O,L,H,C)
                -0.0000496120166624*PriceSeries(Price,index-394,O,L,H,C)
                -0.0000914328356367*PriceSeries(Price,index-395,O,L,H,C)
                -0.0001301597661172*PriceSeries(Price,index-396,O,L,H,C)
                -0.0001650084704446*PriceSeries(Price,index-397,O,L,H,C)
                -0.0001952896637128*PriceSeries(Price,index-398,O,L,H,C)
                -0.0002204333494423*PriceSeries(Price,index-399,O,L,H,C)
                -0.0002400046715750*PriceSeries(Price,index-400,O,L,H,C)
                -0.0002537070401476*PriceSeries(Price,index-401,O,L,H,C)
                -0.0002613782121980*PriceSeries(Price,index-402,O,L,H,C)
                -0.0002629975900278*PriceSeries(Price,index-403,O,L,H,C)
                -0.0002586809044663*PriceSeries(Price,index-404,O,L,H,C)
                -0.0002486771478994*PriceSeries(Price,index-405,O,L,H,C)
                -0.0002333560606826*PriceSeries(Price,index-406,O,L,H,C)
                -0.0002131901404605*PriceSeries(Price,index-407,O,L,H,C)
                -0.0001887648880682*PriceSeries(Price,index-408,O,L,H,C)
                -0.0001607238609037*PriceSeries(Price,index-409,O,L,H,C)
                -0.0001297939940441*PriceSeries(Price,index-410,O,L,H,C)
                -0.0000967465714139*PriceSeries(Price,index-411,O,L,H,C)
                -0.0000623683414389*PriceSeries(Price,index-412,O,L,H,C)
                -0.00002746553633713*PriceSeries(Price,index-413,O,L,H,C)
                +0.00000716720555343*PriceSeries(Price,index-414,O,L,H,C)
                +0.0000407572554129*PriceSeries(Price,index-415,O,L,H,C)
                +0.0000725844531094*PriceSeries(Price,index-416,O,L,H,C)
                +0.0001019785146871*PriceSeries(Price,index-417,O,L,H,C)
                +0.0001283484973163*PriceSeries(Price,index-418,O,L,H,C)
                +0.0001511705695595*PriceSeries(Price,index-419,O,L,H,C)
                +0.0001700408280427*PriceSeries(Price,index-420,O,L,H,C)
                +0.0001846129051808*PriceSeries(Price,index-421,O,L,H,C)
                +0.0001946919458009*PriceSeries(Price,index-422,O,L,H,C)
                +0.0002001554686019*PriceSeries(Price,index-423,O,L,H,C)
                +0.0002009957269453*PriceSeries(Price,index-424,O,L,H,C)
                +0.0001973066848129*PriceSeries(Price,index-425,O,L,H,C)
                +0.0001892919843180*PriceSeries(Price,index-426,O,L,H,C)
                +0.0001772303508721*PriceSeries(Price,index-427,O,L,H,C)
                +0.0001614934287671*PriceSeries(Price,index-428,O,L,H,C)
                +0.0001425148387687*PriceSeries(Price,index-429,O,L,H,C)
                +0.0001208023703087*PriceSeries(Price,index-430,O,L,H,C)
                +0.0000969024156252*PriceSeries(Price,index-431,O,L,H,C)
                +0.0000713937923487*PriceSeries(Price,index-432,O,L,H,C)
                +0.0000448973930235*PriceSeries(Price,index-433,O,L,H,C)
                +0.00001800202990542*PriceSeries(Price,index-434,O,L,H,C)
                -0.00000867425145053*PriceSeries(Price,index-435,O,L,H,C)
                -0.0000345345382474*PriceSeries(Price,index-436,O,L,H,C)
                -0.0000590391090715*PriceSeries(Price,index-437,O,L,H,C)
                -0.0000816683585310*PriceSeries(Price,index-438,O,L,H,C)
                -0.0001019656533012*PriceSeries(Price,index-439,O,L,H,C)
                -0.0001195194159801*PriceSeries(Price,index-440,O,L,H,C)
                -0.0001340056244295*PriceSeries(Price,index-441,O,L,H,C)
                -0.0001451553418709*PriceSeries(Price,index-442,O,L,H,C)
                -0.0001527935918546*PriceSeries(Price,index-443,O,L,H,C)
                -0.0001567935051397*PriceSeries(Price,index-444,O,L,H,C)
                -0.0001571580507737*PriceSeries(Price,index-445,O,L,H,C)
                -0.0001538784200350*PriceSeries(Price,index-446,O,L,H,C)
                -0.0001471266126687*PriceSeries(Price,index-447,O,L,H,C)
                -0.0001370642813230*PriceSeries(Price,index-448,O,L,H,C)
                -0.0001239372479699*PriceSeries(Price,index-449,O,L,H,C)
                -0.0001080395781213*PriceSeries(Price,index-450,O,L,H,C)
                -0.0000897342988115*PriceSeries(Price,index-451,O,L,H,C)
                -0.0000693948517110*PriceSeries(Price,index-452,O,L,H,C)
                -0.0000474420903086*PriceSeries(Price,index-453,O,L,H,C)
                -0.00002429566551667*PriceSeries(Price,index-454,O,L,H,C)
                -0.000000410014865019*PriceSeries(Price,index-455,O,L,H,C)
                +0.00002377702206048*PriceSeries(Price,index-456,O,L,H,C)
                +0.0000478414568930*PriceSeries(Price,index-457,O,L,H,C)
                +0.0000713191901864*PriceSeries(Price,index-458,O,L,H,C)
                +0.0000938938341342*PriceSeries(Price,index-459,O,L,H,C)
                +0.0001151621552291*PriceSeries(Price,index-460,O,L,H,C)
                +0.0001347887382353*PriceSeries(Price,index-461,O,L,H,C)
                +0.0001525216948065*PriceSeries(Price,index-462,O,L,H,C)
                +0.0001681204203215*PriceSeries(Price,index-463,O,L,H,C)
                +0.0001814093793351*PriceSeries(Price,index-464,O,L,H,C)
                +0.0001922381131758*PriceSeries(Price,index-465,O,L,H,C)
                +0.0002005386112133*PriceSeries(Price,index-466,O,L,H,C)
                +0.0002062714816990*PriceSeries(Price,index-467,O,L,H,C)
                +0.0002094742822487*PriceSeries(Price,index-468,O,L,H,C)
                +0.0002101838767632*PriceSeries(Price,index-469,O,L,H,C)
                +0.0002085980173721*PriceSeries(Price,index-470,O,L,H,C)
                +0.0002046761241815*PriceSeries(Price,index-471,O,L,H,C)
                +0.0001987844053963*PriceSeries(Price,index-472,O,L,H,C)
                +0.0001910527886051*PriceSeries(Price,index-473,O,L,H,C)
                +0.0001816947859271*PriceSeries(Price,index-474,O,L,H,C)
                +0.0001709450452939*PriceSeries(Price,index-475,O,L,H,C)
                +0.0001590871189226*PriceSeries(Price,index-476,O,L,H,C)
                +0.0001463760210681*PriceSeries(Price,index-477,O,L,H,C)
                +0.0001330869167299*PriceSeries(Price,index-478,O,L,H,C)
                +0.0001194556287074*PriceSeries(Price,index-479,O,L,H,C)
                +0.0001057367405558*PriceSeries(Price,index-480,O,L,H,C)
                +0.0000921476038251*PriceSeries(Price,index-481,O,L,H,C)
                +0.0000788056615040*PriceSeries(Price,index-482,O,L,H,C)
                +0.0000663380879067*PriceSeries(Price,index-483,O,L,H,C)
                +0.0000542009376187*PriceSeries(Price,index-484,O,L,H,C)
                +0.0000430026065462*PriceSeries(Price,index-485,O,L,H,C)
                +0.0000328520033422*PriceSeries(Price,index-486,O,L,H,C)
                +0.00002377806907943*PriceSeries(Price,index-487,O,L,H,C)
                +0.00001582497773319*PriceSeries(Price,index-488,O,L,H,C)
                +0.00000899925559270*PriceSeries(Price,index-489,O,L,H,C)
                +0.00000332918914565*PriceSeries(Price,index-490,O,L,H,C)
                -0.000001198788130260*PriceSeries(Price,index-491,O,L,H,C)
                -0.00000458189312119*PriceSeries(Price,index-492,O,L,H,C)
                -0.00000686315666128*PriceSeries(Price,index-493,O,L,H,C)
                -0.00000806982897263*PriceSeries(Price,index-494,O,L,H,C)
                -0.0001210123408918*PriceSeries(Price,index-495,O,L,H,C)
                );

      case N45:

         return(
                0.0959739501157*PriceSeries(Price,index,O,L,H,C)
                +0.0952491743491*PriceSeries(Price,index-1,O,L,H,C)
                +0.0938095173869*PriceSeries(Price,index-2,O,L,H,C)
                +0.0916746077387*PriceSeries(Price,index-3,O,L,H,C)
                +0.0888734868779*PriceSeries(Price,index-4,O,L,H,C)
                +0.0854441373477*PriceSeries(Price,index-5,O,L,H,C)
                +0.0814328632183*PriceSeries(Price,index-6,O,L,H,C)
                +0.0768935398304*PriceSeries(Price,index-7,O,L,H,C)
                +0.0718867445673*PriceSeries(Price,index-8,O,L,H,C)
                +0.0664787774205*PriceSeries(Price,index-9,O,L,H,C)
                +0.0607406000202*PriceSeries(Price,index-10,O,L,H,C)
                +0.0547467036308*PriceSeries(Price,index-11,O,L,H,C)
                +0.0485739276580*PriceSeries(Price,index-12,O,L,H,C)
                +0.0423002501070*PriceSeries(Price,index-13,O,L,H,C)
                +0.0360035739293*PriceSeries(Price,index-14,O,L,H,C)
                +0.02976052277778*PriceSeries(Price,index-15,O,L,H,C)
                +0.02364527691480*PriceSeries(Price,index-16,O,L,H,C)
                +0.01772845601671*PriceSeries(Price,index-17,O,L,H,C)
                +0.01207608526678*PriceSeries(Price,index-18,O,L,H,C)
                +0.00674864063547*PriceSeries(Price,index-19,O,L,H,C)
                +0.001800213179207*PriceSeries(Price,index-20,O,L,H,C)
                -0.002722220708842*PriceSeries(Price,index-21,O,L,H,C)
                -0.00677938784198*PriceSeries(Price,index-22,O,L,H,C)
                -0.01034017401415*PriceSeries(Price,index-23,O,L,H,C)
                -0.01338192775233*PriceSeries(Price,index-24,O,L,H,C)
                -0.01589062670153*PriceSeries(Price,index-25,O,L,H,C)
                -0.01786087882559*PriceSeries(Price,index-26,O,L,H,C)
                -0.01929579264172*PriceSeries(Price,index-27,O,L,H,C)
                -0.02020669160065*PriceSeries(Price,index-28,O,L,H,C)
                -0.02061270460557*PriceSeries(Price,index-29,O,L,H,C)
                -0.02054021992273*PriceSeries(Price,index-30,O,L,H,C)
                -0.02002223592619*PriceSeries(Price,index-31,O,L,H,C)
                -0.01909760302073*PriceSeries(Price,index-32,O,L,H,C)
                -0.01781018919167*PriceSeries(Price,index-33,O,L,H,C)
                -0.01620797001322*PriceSeries(Price,index-34,O,L,H,C)
                -0.01434207605703*PriceSeries(Price,index-35,O,L,H,C)
                -0.01226579828093*PriceSeries(Price,index-36,O,L,H,C)
                -0.01003359519139*PriceSeries(Price,index-37,O,L,H,C)
                -0.00770008905591*PriceSeries(Price,index-38,O,L,H,C)
                -0.00531909797682*PriceSeries(Price,index-39,O,L,H,C)
                -0.002942700974113*PriceSeries(Price,index-40,O,L,H,C)
                -0.000620367463765*PriceSeries(Price,index-41,O,L,H,C)
                +0.001601851678951*PriceSeries(Price,index-42,O,L,H,C)
                +0.00368203410262*PriceSeries(Price,index-43,O,L,H,C)
                +0.00558301407403*PriceSeries(Price,index-44,O,L,H,C)
                +0.00727288901485*PriceSeries(Price,index-45,O,L,H,C)
                +0.00872543004087*PriceSeries(Price,index-46,O,L,H,C)
                +0.00992035625401*PriceSeries(Price,index-47,O,L,H,C)
                +0.01084350649463*PriceSeries(Price,index-48,O,L,H,C)
                +0.01148687271810*PriceSeries(Price,index-49,O,L,H,C)
                +0.01184853100973*PriceSeries(Price,index-50,O,L,H,C)
                +0.01193244634229*PriceSeries(Price,index-51,O,L,H,C)
                +0.01174818023935*PriceSeries(Price,index-52,O,L,H,C)
                +0.01131048569686*PriceSeries(Price,index-53,O,L,H,C)
                +0.01063883164521*PriceSeries(Price,index-54,O,L,H,C)
                +0.00975683142831*PriceSeries(Price,index-55,O,L,H,C)
                +0.00869162295719*PriceSeries(Price,index-56,O,L,H,C)
                +0.00747318644108*PriceSeries(Price,index-57,O,L,H,C)
                +0.00613363745085*PriceSeries(Price,index-58,O,L,H,C)
                +0.00470648948713*PriceSeries(Price,index-59,O,L,H,C)
                +0.00322591914617*PriceSeries(Price,index-60,O,L,H,C)
                +0.001726034398767*PriceSeries(Price,index-61,O,L,H,C)
                +0.0002401730235736*PriceSeries(Price,index-62,O,L,H,C)
                -0.001199769493474*PriceSeries(Price,index-63,O,L,H,C)
                -0.002563953435658*PriceSeries(Price,index-64,O,L,H,C)
                -0.00382515922747*PriceSeries(Price,index-65,O,L,H,C)
                -0.00495926845916*PriceSeries(Price,index-66,O,L,H,C)
                -0.00594567599975*PriceSeries(Price,index-67,O,L,H,C)
                -0.00676761334324*PriceSeries(Price,index-68,O,L,H,C)
                -0.00741238601233*PriceSeries(Price,index-69,O,L,H,C)
                -0.00787151308694*PriceSeries(Price,index-70,O,L,H,C)
                -0.00814078445603*PriceSeries(Price,index-71,O,L,H,C)
                -0.00822021695298*PriceSeries(Price,index-72,O,L,H,C)
                -0.00811393316755*PriceSeries(Price,index-73,O,L,H,C)
                -0.00782994665217*PriceSeries(Price,index-74,O,L,H,C)
                -0.00737988372332*PriceSeries(Price,index-75,O,L,H,C)
                -0.00677862478227*PriceSeries(Price,index-76,O,L,H,C)
                -0.00604389642625*PriceSeries(Price,index-77,O,L,H,C)
                -0.00519580770033*PriceSeries(Price,index-78,O,L,H,C)
                -0.00425635229517*PriceSeries(Price,index-79,O,L,H,C)
                -0.00324888234647*PriceSeries(Price,index-80,O,L,H,C)
                -0.002197571509572*PriceSeries(Price,index-81,O,L,H,C)
                -0.001126865777626*PriceSeries(Price,index-82,O,L,H,C)
                -0.0000609530077839*PriceSeries(Price,index-83,O,L,H,C)
                +0.000976753278347*PriceSeries(Price,index-84,O,L,H,C)
                +0.001964100134851*PriceSeries(Price,index-85,O,L,H,C)
                +0.002880639746836*PriceSeries(Price,index-86,O,L,H,C)
                +0.00370802813107*PriceSeries(Price,index-87,O,L,H,C)
                +0.00443036527347*PriceSeries(Price,index-88,O,L,H,C)
                +0.00503447943910*PriceSeries(Price,index-89,O,L,H,C)
                +0.00551013910519*PriceSeries(Price,index-90,O,L,H,C)
                +0.00585020131315*PriceSeries(Price,index-91,O,L,H,C)
                +0.00605068674743*PriceSeries(Price,index-92,O,L,H,C)
                +0.00611078569489*PriceSeries(Price,index-93,O,L,H,C)
                +0.00603279524811*PriceSeries(Price,index-94,O,L,H,C)
                +0.00582199325013*PriceSeries(Price,index-95,O,L,H,C)
                +0.00548644252166*PriceSeries(Price,index-96,O,L,H,C)
                +0.00503675088645*PriceSeries(Price,index-97,O,L,H,C)
                +0.00448577392813*PriceSeries(Price,index-98,O,L,H,C)
                +0.00384827855419*PriceSeries(Price,index-99,O,L,H,C)
                +0.003140572419344*PriceSeries(Price,index-100,O,L,H,C)
                +0.002380110202323*PriceSeries(Price,index-101,O,L,H,C)
                +0.001585082386669*PriceSeries(Price,index-102,O,L,H,C)
                +0.000773998968732*PriceSeries(Price,index-103,O,L,H,C)
                -0.0000347253235652*PriceSeries(Price,index-104,O,L,H,C)
                -0.000823170340703*PriceSeries(Price,index-105,O,L,H,C)
                -0.001574296662318*PriceSeries(Price,index-106,O,L,H,C)
                -0.002272294145509*PriceSeries(Price,index-107,O,L,H,C)
                -0.002902906151931*PriceSeries(Price,index-108,O,L,H,C)
                -0.00345370257139*PriceSeries(Price,index-109,O,L,H,C)
                -0.00391431242400*PriceSeries(Price,index-110,O,L,H,C)
                -0.00427660287902*PriceSeries(Price,index-111,O,L,H,C)
                -0.00453481190805*PriceSeries(Price,index-112,O,L,H,C)
                -0.00468561227623*PriceSeries(Price,index-113,O,L,H,C)
                -0.00472813756819*PriceSeries(Price,index-114,O,L,H,C)
                -0.00466393693680*PriceSeries(Price,index-115,O,L,H,C)
                -0.00449689485887*PriceSeries(Price,index-116,O,L,H,C)
                -0.00423308273728*PriceSeries(Price,index-117,O,L,H,C)
                -0.00388058474552*PriceSeries(Price,index-118,O,L,H,C)
                -0.00344926622759*PriceSeries(Price,index-119,O,L,H,C)
                -0.002950521814647*PriceSeries(Price,index-120,O,L,H,C)
                -0.002396983470963*PriceSeries(Price,index-121,O,L,H,C)
                -0.001802219988823*PriceSeries(Price,index-122,O,L,H,C)
                -0.001180408138196*PriceSeries(Price,index-123,O,L,H,C)
                -0.000546015637152*PriceSeries(Price,index-124,O,L,H,C)
                +0.0000865362891287*PriceSeries(Price,index-125,O,L,H,C)
                +0.000703183832675*PriceSeries(Price,index-126,O,L,H,C)
                +0.001290528115088*PriceSeries(Price,index-127,O,L,H,C)
                +0.001836113782905*PriceSeries(Price,index-128,O,L,H,C)
                +0.002328689672727*PriceSeries(Price,index-129,O,L,H,C)
                +0.002758427453525*PriceSeries(Price,index-130,O,L,H,C)
                +0.003117112305456*PriceSeries(Price,index-131,O,L,H,C)
                +0.00339828619935*PriceSeries(Price,index-132,O,L,H,C)
                +0.00359735929714*PriceSeries(Price,index-133,O,L,H,C)
                +0.00371166350797*PriceSeries(Price,index-134,O,L,H,C)
                +0.00374047931378*PriceSeries(Price,index-135,O,L,H,C)
                +0.00368500219153*PriceSeries(Price,index-136,O,L,H,C)
                +0.00354828130553*PriceSeries(Price,index-137,O,L,H,C)
                +0.00333510808805*PriceSeries(Price,index-138,O,L,H,C)
                +0.003051876314474*PriceSeries(Price,index-139,O,L,H,C)
                +0.002706399244174*PriceSeries(Price,index-140,O,L,H,C)
                +0.002307717047055*PriceSeries(Price,index-141,O,L,H,C)
                +0.001865857978214*PriceSeries(Price,index-142,O,L,H,C)
                +0.001391604240869*PriceSeries(Price,index-143,O,L,H,C)
                +0.000896227013993*PriceSeries(Price,index-144,O,L,H,C)
                +0.000391236067849*PriceSeries(Price,index-145,O,L,H,C)
                -0.0001118917224497*PriceSeries(Price,index-146,O,L,H,C)
                -0.000601958865400*PriceSeries(Price,index-147,O,L,H,C)
                -0.001068296588957*PriceSeries(Price,index-148,O,L,H,C)
                -0.001500986532709*PriceSeries(Price,index-149,O,L,H,C)
                -0.001891071367467*PriceSeries(Price,index-150,O,L,H,C)
                -0.002230726975600*PriceSeries(Price,index-151,O,L,H,C)
                -0.002513422034255*PriceSeries(Price,index-152,O,L,H,C)
                -0.002734027424221*PriceSeries(Price,index-153,O,L,H,C)
                -0.002888907735209*PriceSeries(Price,index-154,O,L,H,C)
                -0.002975970130383*PriceSeries(Price,index-155,O,L,H,C)
                -0.002994678071417*PriceSeries(Price,index-156,O,L,H,C)
                -0.002946030103538*PriceSeries(Price,index-157,O,L,H,C)
                -0.002832508090236*PriceSeries(Price,index-158,O,L,H,C)
                -0.002657990548000*PriceSeries(Price,index-159,O,L,H,C)
                -0.002427637577106*PriceSeries(Price,index-160,O,L,H,C)
                -0.002147747165497*PriceSeries(Price,index-161,O,L,H,C)
                -0.001825595565957*PriceSeries(Price,index-162,O,L,H,C)
                -0.001469250163722*PriceSeries(Price,index-163,O,L,H,C)
                -0.001087376977875*PriceSeries(Price,index-164,O,L,H,C)
                -0.000689033515943*PriceSeries(Price,index-165,O,L,H,C)
                -0.0002834581568741*PriceSeries(Price,index-166,O,L,H,C)
                +0.0001201388756289*PriceSeries(Price,index-167,O,L,H,C)
                +0.000512779193718*PriceSeries(Price,index-168,O,L,H,C)
                +0.000885917516909*PriceSeries(Price,index-169,O,L,H,C)
                +0.001231615279464*PriceSeries(Price,index-170,O,L,H,C)
                +0.001542711637979*PriceSeries(Price,index-171,O,L,H,C)
                +0.001812963780873*PriceSeries(Price,index-172,O,L,H,C)
                +0.002037171792831*PriceSeries(Price,index-173,O,L,H,C)
                +0.002211268699295*PriceSeries(Price,index-174,O,L,H,C)
                +0.002332390072634*PriceSeries(Price,index-175,O,L,H,C)
                +0.002398914753606*PriceSeries(Price,index-176,O,L,H,C)
                +0.002410473499989*PriceSeries(Price,index-177,O,L,H,C)
                +0.002367932737464*PriceSeries(Price,index-178,O,L,H,C)
                +0.002273350515755*PriceSeries(Price,index-179,O,L,H,C)
                +0.002129904214835*PriceSeries(Price,index-180,O,L,H,C)
                +0.001941798016771*PriceSeries(Price,index-181,O,L,H,C)
                +0.001714149858993*PriceSeries(Price,index-182,O,L,H,C)
                +0.001452851892628*PriceSeries(Price,index-183,O,L,H,C)
                +0.001164432900804*PriceSeries(Price,index-184,O,L,H,C)
                +0.000855890370086*PriceSeries(Price,index-185,O,L,H,C)
                +0.000534530739851*PriceSeries(Price,index-186,O,L,H,C)
                +0.0002077930041309*PriceSeries(Price,index-187,O,L,H,C)
                -0.0001169115686187*PriceSeries(Price,index-188,O,L,H,C)
                -0.000432371288665*PriceSeries(Price,index-189,O,L,H,C)
                -0.000731728103972*PriceSeries(Price,index-190,O,L,H,C)
                -0.001008625965413*PriceSeries(Price,index-191,O,L,H,C)
                -0.001257338070520*PriceSeries(Price,index-192,O,L,H,C)
                -0.001472889222372*PriceSeries(Price,index-193,O,L,H,C)
                -0.001651142456082*PriceSeries(Price,index-194,O,L,H,C)
                -0.001788883405709*PriceSeries(Price,index-195,O,L,H,C)
                -0.001883867370334*PriceSeries(Price,index-196,O,L,H,C)
                -0.001934850753167*PriceSeries(Price,index-197,O,L,H,C)
                -0.001941599988274*PriceSeries(Price,index-198,O,L,H,C)
                -0.001904875365556*PriceSeries(Price,index-199,O,L,H,C)
                -0.001826390353916*PriceSeries(Price,index-200,O,L,H,C)
                -0.001708758158329*PriceSeries(Price,index-201,O,L,H,C)
                -0.001555412121186*PriceSeries(Price,index-202,O,L,H,C)
                -0.001370515828578*PriceSeries(Price,index-203,O,L,H,C)
                -0.001158846214042*PriceSeries(Price,index-204,O,L,H,C)
                -0.000925684896399*PriceSeries(Price,index-205,O,L,H,C)
                -0.000676680877809*PriceSeries(Price,index-206,O,L,H,C)
                -0.000417722612190*PriceSeries(Price,index-207,O,L,H,C)
                -0.0001547967867774*PriceSeries(Price,index-208,O,L,H,C)
                +0.0001061425304997*PriceSeries(Price,index-209,O,L,H,C)
                +0.000359315093560*PriceSeries(Price,index-210,O,L,H,C)
                +0.000599225709423*PriceSeries(Price,index-211,O,L,H,C)
                +0.000820799474048*PriceSeries(Price,index-212,O,L,H,C)
                +0.001019468869813*PriceSeries(Price,index-213,O,L,H,C)
                +0.001191279352220*PriceSeries(Price,index-214,O,L,H,C)
                +0.001332953268649*PriceSeries(Price,index-215,O,L,H,C)
                +0.001441962201416*PriceSeries(Price,index-216,O,L,H,C)
                +0.001516554267012*PriceSeries(Price,index-217,O,L,H,C)
                +0.001555786121420*PriceSeries(Price,index-218,O,L,H,C)
                +0.001559521178432*PriceSeries(Price,index-219,O,L,H,C)
                +0.001528424239017*PriceSeries(Price,index-220,O,L,H,C)
                +0.001463917543477*PriceSeries(Price,index-221,O,L,H,C)
                +0.001368146418396*PriceSeries(Price,index-222,O,L,H,C)
                +0.001243903487389*PriceSeries(Price,index-223,O,L,H,C)
                +0.001094561587278*PriceSeries(Price,index-224,O,L,H,C)
                +0.000923982823477*PriceSeries(Price,index-225,O,L,H,C)
                +0.000736420679732*PriceSeries(Price,index-226,O,L,H,C)
                +0.000536417335573*PriceSeries(Price,index-227,O,L,H,C)
                +0.000328699024063*PriceSeries(Price,index-228,O,L,H,C)
                +0.0001180604765963*PriceSeries(Price,index-229,O,L,H,C)
                -0.0000907383558076*PriceSeries(Price,index-230,O,L,H,C)
                -0.0002930826528592*PriceSeries(Price,index-231,O,L,H,C)
                -0.000484594594338*PriceSeries(Price,index-232,O,L,H,C)
                -0.000661238732802*PriceSeries(Price,index-233,O,L,H,C)
                -0.000819394732248*PriceSeries(Price,index-234,O,L,H,C)
                -0.000955933989910*PriceSeries(Price,index-235,O,L,H,C)
                -0.001068275875117*PriceSeries(Price,index-236,O,L,H,C)
                -0.001154438762270*PriceSeries(Price,index-237,O,L,H,C)
                -0.001213062637618*PriceSeries(Price,index-238,O,L,H,C)
                -0.001243440583211*PriceSeries(Price,index-239,O,L,H,C)
                -0.001245501378951*PriceSeries(Price,index-240,O,L,H,C)
                -0.001219815703596*PriceSeries(Price,index-241,O,L,H,C)
                -0.001167555633441*PriceSeries(Price,index-242,O,L,H,C)
                -0.001090465362493*PriceSeries(Price,index-243,O,L,H,C)
                -0.000990799880966*PriceSeries(Price,index-244,O,L,H,C)
                -0.000871273640217*PriceSeries(Price,index-245,O,L,H,C)
                -0.000734983022789*PriceSeries(Price,index-246,O,L,H,C)
                -0.000585330054224*PriceSeries(Price,index-247,O,L,H,C)
                -0.000425937793325*PriceSeries(Price,index-248,O,L,H,C)
                -0.0002605728779140*PriceSeries(Price,index-249,O,L,H,C)
                -0.0000930471163625*PriceSeries(Price,index-250,O,L,H,C)
                +0.0000728617498690*PriceSeries(Price,index-251,O,L,H,C)
                +0.0002334952085702*PriceSeries(Price,index-252,O,L,H,C)
                +0.000385397961904*PriceSeries(Price,index-253,O,L,H,C)
                +0.000525379815749*PriceSeries(Price,index-254,O,L,H,C)
                +0.000650592039882*PriceSeries(Price,index-255,O,L,H,C)
                +0.000758577440931*PriceSeries(Price,index-256,O,L,H,C)
                +0.000847318358227*PriceSeries(Price,index-257,O,L,H,C)
                +0.000915269908698*PriceSeries(Price,index-258,O,L,H,C)
                +0.000961387348232*PriceSeries(Price,index-259,O,L,H,C)
                +0.000985136870126*PriceSeries(Price,index-260,O,L,H,C)
                +0.000986492139718*PriceSeries(Price,index-261,O,L,H,C)
                +0.000965927460654*PriceSeries(Price,index-262,O,L,H,C)
                +0.000924399164335*PriceSeries(Price,index-263,O,L,H,C)
                +0.000863304230531*PriceSeries(Price,index-264,O,L,H,C)
                +0.000784444457307*PriceSeries(Price,index-265,O,L,H,C)
                +0.000689978777549*PriceSeries(Price,index-266,O,L,H,C)
                +0.000582359388213*PriceSeries(Price,index-267,O,L,H,C)
                +0.000464283058607*PriceSeries(Price,index-268,O,L,H,C)
                +0.000338611804150*PriceSeries(Price,index-269,O,L,H,C)
                +0.0002083118275927*PriceSeries(Price,index-270,O,L,H,C)
                +0.0000763849375597*PriceSeries(Price,index-271,O,L,H,C)
                -0.0000542006201001*PriceSeries(Price,index-272,O,L,H,C)
                -0.0001805751971543*PriceSeries(Price,index-273,O,L,H,C)
                -0.0003000322949187*PriceSeries(Price,index-274,O,L,H,C)
                -0.000410076501516*PriceSeries(Price,index-275,O,L,H,C)
                -0.000508485086307*PriceSeries(Price,index-276,O,L,H,C)
                -0.000593346644976*PriceSeries(Price,index-277,O,L,H,C)
                -0.000663094527455*PriceSeries(Price,index-278,O,L,H,C)
                -0.000716531739331*PriceSeries(Price,index-279,O,L,H,C)
                -0.000752861717851*PriceSeries(Price,index-280,O,L,H,C)
                -0.000771675767654*PriceSeries(Price,index-281,O,L,H,C)
                -0.000772978749484*PriceSeries(Price,index-282,O,L,H,C)
                -0.000757150930151*PriceSeries(Price,index-283,O,L,H,C)
                -0.000724953276597*PriceSeries(Price,index-284,O,L,H,C)
                -0.000677487085541*PriceSeries(Price,index-285,O,L,H,C)
                -0.000616173963517*PriceSeries(Price,index-286,O,L,H,C)
                -0.000542701481713*PriceSeries(Price,index-287,O,L,H,C)
                -0.000458992481489*PriceSeries(Price,index-288,O,L,H,C)
                -0.000367148169306*PriceSeries(Price,index-289,O,L,H,C)
                -0.0002694032462215*PriceSeries(Price,index-290,O,L,H,C)
                -0.0001680598205450*PriceSeries(Price,index-291,O,L,H,C)
                -0.0000654562511066*PriceSeries(Price,index-292,O,L,H,C)
                +0.0000361052419820*PriceSeries(Price,index-293,O,L,H,C)
                +0.0001344026412960*PriceSeries(Price,index-294,O,L,H,C)
                +0.0002273373784338*PriceSeries(Price,index-295,O,L,H,C)
                +0.0003129858148124*PriceSeries(Price,index-296,O,L,H,C)
                +0.000389629584301*PriceSeries(Price,index-297,O,L,H,C)
                +0.000455792088773*PriceSeries(Price,index-298,O,L,H,C)
                +0.000510272711275*PriceSeries(Price,index-299,O,L,H,C)
                +0.000552154451081*PriceSeries(Price,index-300,O,L,H,C)
                +0.000580826479588*PriceSeries(Price,index-301,O,L,H,C)
                +0.000595979437577*PriceSeries(Price,index-302,O,L,H,C)
                +0.000597622194074*PriceSeries(Price,index-303,O,L,H,C)
                +0.000586053330077*PriceSeries(Price,index-304,O,L,H,C)
                +0.000561861181197*PriceSeries(Price,index-305,O,L,H,C)
                +0.000525899216929*PriceSeries(Price,index-306,O,L,H,C)
                +0.000479265671765*PriceSeries(Price,index-307,O,L,H,C)
                +0.000423251134966*PriceSeries(Price,index-308,O,L,H,C)
                +0.000359342422781*PriceSeries(Price,index-309,O,L,H,C)
                +0.0002891425550520*PriceSeries(Price,index-310,O,L,H,C)
                +0.0002143721171816*PriceSeries(Price,index-311,O,L,H,C)
                +0.0001367931300240*PriceSeries(Price,index-312,O,L,H,C)
                +0.0000581928156218*PriceSeries(Price,index-313,O,L,H,C)
                -0.00001967247123713*PriceSeries(Price,index-314,O,L,H,C)
                -0.0000950970377985*PriceSeries(Price,index-315,O,L,H,C)
                -0.0001664827290190*PriceSeries(Price,index-316,O,L,H,C)
                -0.0002323596452236*PriceSeries(Price,index-317,O,L,H,C)
                -0.0002914223160233*PriceSeries(Price,index-318,O,L,H,C)
                -0.000342540229951*PriceSeries(Price,index-319,O,L,H,C)
                -0.000384803360078*PriceSeries(Price,index-320,O,L,H,C)
                -0.000417511441667*PriceSeries(Price,index-321,O,L,H,C)
                -0.000440190520196*PriceSeries(Price,index-322,O,L,H,C)
                -0.000452613431581*PriceSeries(Price,index-323,O,L,H,C)
                -0.000454775082633*PriceSeries(Price,index-324,O,L,H,C)
                -0.000446904998124*PriceSeries(Price,index-325,O,L,H,C)
                -0.000429444319313*PriceSeries(Price,index-326,O,L,H,C)
                -0.000403031027670*PriceSeries(Price,index-327,O,L,H,C)
                -0.000368490648707*PriceSeries(Price,index-328,O,L,H,C)
                -0.000326803150850*PriceSeries(Price,index-329,O,L,H,C)
                -0.0002790809626440*PriceSeries(Price,index-330,O,L,H,C)
                -0.0002265305482855*PriceSeries(Price,index-331,O,L,H,C)
                -0.0001704420216391*PriceSeries(Price,index-332,O,L,H,C)
                -0.0001121474195642*PriceSeries(Price,index-333,O,L,H,C)
                -0.0000529857329420*PriceSeries(Price,index-334,O,L,H,C)
                +0.00000572220193234*PriceSeries(Price,index-335,O,L,H,C)
                +0.0000626868760196*PriceSeries(Price,index-336,O,L,H,C)
                +0.0001167217612014*PriceSeries(Price,index-337,O,L,H,C)
                +0.0001667108864316*PriceSeries(Price,index-338,O,L,H,C)
                +0.0002116777164992*PriceSeries(Price,index-339,O,L,H,C)
                +0.0002507691416733*PriceSeries(Price,index-340,O,L,H,C)
                +0.0002832924609749*PriceSeries(Price,index-341,O,L,H,C)
                +0.0003087191296993*PriceSeries(Price,index-342,O,L,H,C)
                +0.000326694129187*PriceSeries(Price,index-343,O,L,H,C)
                +0.000337030376622*PriceSeries(Price,index-344,O,L,H,C)
                +0.000339712882387*PriceSeries(Price,index-345,O,L,H,C)
                +0.000334902689266*PriceSeries(Price,index-346,O,L,H,C)
                +0.000322923412888*PriceSeries(Price,index-347,O,L,H,C)
                +0.0003042344531591*PriceSeries(Price,index-348,O,L,H,C)
                +0.0002794326761836*PriceSeries(Price,index-349,O,L,H,C)
                +0.0002492488895618*PriceSeries(Price,index-350,O,L,H,C)
                +0.0002144762064151*PriceSeries(Price,index-351,O,L,H,C)
                +0.0001760226866412*PriceSeries(Price,index-352,O,L,H,C)
                +0.0001348262967919*PriceSeries(Price,index-353,O,L,H,C)
                +0.0000918739659838*PriceSeries(Price,index-354,O,L,H,C)
                +0.0000481506956949*PriceSeries(Price,index-355,O,L,H,C)
                +0.00000463262842481*PriceSeries(Price,index-356,O,L,H,C)
                -0.0000377400601413*PriceSeries(Price,index-357,O,L,H,C)
                -0.0000780690624605*PriceSeries(Price,index-358,O,L,H,C)
                -0.0001155329943213*PriceSeries(Price,index-359,O,L,H,C)
                -0.0001494002604293*PriceSeries(Price,index-360,O,L,H,C)
                -0.0001790453274663*PriceSeries(Price,index-361,O,L,H,C)
                -0.0002039294344878*PriceSeries(Price,index-362,O,L,H,C)
                -0.0002236492307833*PriceSeries(Price,index-363,O,L,H,C)
                -0.0002379408292970*PriceSeries(Price,index-364,O,L,H,C)
                -0.0002466279828967*PriceSeries(Price,index-365,O,L,H,C)
                -0.0002497024049873*PriceSeries(Price,index-366,O,L,H,C)
                -0.0002472535073064*PriceSeries(Price,index-367,O,L,H,C)
                -0.0002394924617989*PriceSeries(Price,index-368,O,L,H,C)
                -0.0002267410007877*PriceSeries(Price,index-369,O,L,H,C)
                -0.0002094106574145*PriceSeries(Price,index-370,O,L,H,C)
                -0.0001880160824112*PriceSeries(Price,index-371,O,L,H,C)
                -0.0001631363278817*PriceSeries(Price,index-372,O,L,H,C)
                -0.0001354164470455*PriceSeries(Price,index-373,O,L,H,C)
                -0.0001055197850230*PriceSeries(Price,index-374,O,L,H,C)
                -0.0000741560209528*PriceSeries(Price,index-375,O,L,H,C)
                -0.0000420508486190*PriceSeries(Price,index-376,O,L,H,C)
                -0.00000992476445621*PriceSeries(Price,index-377,O,L,H,C)
                +0.00002157065038211*PriceSeries(Price,index-378,O,L,H,C)
                +0.0000517246443424*PriceSeries(Price,index-379,O,L,H,C)
                +0.0000799691662899*PriceSeries(Price,index-380,O,L,H,C)
                +0.0001057219571702*PriceSeries(Price,index-381,O,L,H,C)
                +0.0001285113516765*PriceSeries(Price,index-382,O,L,H,C)
                +0.0001479151854924*PriceSeries(Price,index-383,O,L,H,C)
                +0.0001636182819069*PriceSeries(Price,index-384,O,L,H,C)
                +0.0001753743014225*PriceSeries(Price,index-385,O,L,H,C)
                +0.0001830432178398*PriceSeries(Price,index-386,O,L,H,C)
                +0.0001865420265335*PriceSeries(Price,index-387,O,L,H,C)
                +0.0001858890508922*PriceSeries(Price,index-388,O,L,H,C)
                +0.0001811779129853*PriceSeries(Price,index-389,O,L,H,C)
                +0.0001726259165076*PriceSeries(Price,index-390,O,L,H,C)
                +0.0001604705070323*PriceSeries(Price,index-391,O,L,H,C)
                +0.0001449859417388*PriceSeries(Price,index-392,O,L,H,C)
                +0.0001266110432485*PriceSeries(Price,index-393,O,L,H,C)
                +0.0001057110098238*PriceSeries(Price,index-394,O,L,H,C)
                +0.0000827528109615*PriceSeries(Price,index-395,O,L,H,C)
                +0.0000582113061360*PriceSeries(Price,index-396,O,L,H,C)
                +0.0000325592450299*PriceSeries(Price,index-397,O,L,H,C)
                +0.00000629623615223*PriceSeries(Price,index-398,O,L,H,C)
                -0.00002010981234594*PriceSeries(Price,index-399,O,L,H,C)
                -0.0000461736744104*PriceSeries(Price,index-400,O,L,H,C)
                -0.0000714577992922*PriceSeries(Price,index-401,O,L,H,C)
                -0.0000955344951531*PriceSeries(Price,index-402,O,L,H,C)
                -0.0001180687353046*PriceSeries(Price,index-403,O,L,H,C)
                -0.0001387590564222*PriceSeries(Price,index-404,O,L,H,C)
                -0.0001573291412013*PriceSeries(Price,index-405,O,L,H,C)
                -0.0001734349511610*PriceSeries(Price,index-406,O,L,H,C)
                -0.0001871089547519*PriceSeries(Price,index-407,O,L,H,C)
                -0.0001980829756904*PriceSeries(Price,index-408,O,L,H,C)
                -0.0002063794978140*PriceSeries(Price,index-409,O,L,H,C)
                -0.0002119624575729*PriceSeries(Price,index-410,O,L,H,C)
                -0.0002148988051442*PriceSeries(Price,index-411,O,L,H,C)
                -0.0002152680353365*PriceSeries(Price,index-412,O,L,H,C)
                -0.0002132264789162*PriceSeries(Price,index-413,O,L,H,C)
                -0.0002089342711719*PriceSeries(Price,index-414,O,L,H,C)
                -0.0002026115780819*PriceSeries(Price,index-415,O,L,H,C)
                -0.0001944563958183*PriceSeries(Price,index-416,O,L,H,C)
                -0.0001847013104955*PriceSeries(Price,index-417,O,L,H,C)
                -0.0001735617951082*PriceSeries(Price,index-418,O,L,H,C)
                -0.0001614011647124*PriceSeries(Price,index-419,O,L,H,C)
                -0.0001488006031460*PriceSeries(Price,index-420,O,L,H,C)
                -0.0001353359017328*PriceSeries(Price,index-421,O,L,H,C)
                -0.0001218139328583*PriceSeries(Price,index-422,O,L,H,C)
                -0.0001082878982586*PriceSeries(Price,index-423,O,L,H,C)
                -0.0000950202039375*PriceSeries(Price,index-424,O,L,H,C)
                -0.0000822538897598*PriceSeries(Price,index-425,O,L,H,C)
                -0.0000701829847161*PriceSeries(Price,index-426,O,L,H,C)
                -0.0000590235493266*PriceSeries(Price,index-427,O,L,H,C)
                -0.0000489434684886*PriceSeries(Price,index-428,O,L,H,C)
                -0.0000401404564171*PriceSeries(Price,index-429,O,L,H,C)
                -0.0000327765198687*PriceSeries(Price,index-430,O,L,H,C)
                -0.00002706299667248*PriceSeries(Price,index-431,O,L,H,C)
                -0.00002320305435842*PriceSeries(Price,index-432,O,L,H,C)
                -0.00002148667784209*PriceSeries(Price,index-433,O,L,H,C)
                +0.0001065965578497*PriceSeries(Price,index-434,O,L,H,C)
                );

      case N46:
         return(
                0.0896023048483*PriceSeries(Price,index,O,L,H,C)
                +0.0892794449379*PriceSeries(Price,index-1,O,L,H,C)
                +0.0883150689828*PriceSeries(Price,index-2,O,L,H,C)
                +0.0867217225709*PriceSeries(Price,index-3,O,L,H,C)
                +0.0845200980501*PriceSeries(Price,index-4,O,L,H,C)
                +0.0817387129402*PriceSeries(Price,index-5,O,L,H,C)
                +0.0784134674371*PriceSeries(Price,index-6,O,L,H,C)
                +0.0745870885765*PriceSeries(Price,index-7,O,L,H,C)
                +0.0703084701678*PriceSeries(Price,index-8,O,L,H,C)
                +0.0656319203821*PriceSeries(Price,index-9,O,L,H,C)
                +0.0606163286394*PriceSeries(Price,index-10,O,L,H,C)
                +0.0553242668032*PriceSeries(Price,index-11,O,L,H,C)
                +0.0498210393388*PriceSeries(Price,index-12,O,L,H,C)
                +0.0441736983037*PriceSeries(Price,index-13,O,L,H,C)
                +0.0384500397739*PriceSeries(Price,index-14,O,L,H,C)
                +0.0327175979461*PriceSeries(Price,index-15,O,L,H,C)
                +0.02704265434759*PriceSeries(Price,index-16,O,L,H,C)
                +0.02148927726741*PriceSeries(Price,index-17,O,L,H,C)
                +0.01611840779657*PriceSeries(Price,index-18,O,L,H,C)
                +0.01098700683036*PriceSeries(Price,index-19,O,L,H,C)
                +0.00614727636077*PriceSeries(Price,index-20,O,L,H,C)
                +0.001645967517547*PriceSeries(Price,index-21,O,L,H,C)
                -0.002476214654869*PriceSeries(Price,index-22,O,L,H,C)
                -0.00618510003152*PriceSeries(Price,index-23,O,L,H,C)
                -0.00945343015114*PriceSeries(Price,index-24,O,L,H,C)
                -0.01226111737771*PriceSeries(Price,index-25,O,L,H,C)
                -0.01459538383815*PriceSeries(Price,index-26,O,L,H,C)
                -0.01645077981092*PriceSeries(Price,index-27,O,L,H,C)
                -0.01782908258338*PriceSeries(Price,index-28,O,L,H,C)
                -0.01873907997930*PriceSeries(Price,index-29,O,L,H,C)
                -0.01919624308765*PriceSeries(Price,index-30,O,L,H,C)
                -0.01922229657361*PriceSeries(Price,index-31,O,L,H,C)
                -0.01884469504072*PriceSeries(Price,index-32,O,L,H,C)
                -0.01809601588075*PriceSeries(Price,index-33,O,L,H,C)
                -0.01701328096674*PriceSeries(Price,index-34,O,L,H,C)
                -0.01563721961183*PriceSeries(Price,index-35,O,L,H,C)
                -0.01401148734232*PriceSeries(Price,index-36,O,L,H,C)
                -0.01218185379124*PriceSeries(Price,index-37,O,L,H,C)
                -0.01019537526890*PriceSeries(Price,index-38,O,L,H,C)
                -0.00809956631404*PriceSeries(Price,index-39,O,L,H,C)
                -0.00594158439332*PriceSeries(Price,index-40,O,L,H,C)
                -0.00376744237740*PriceSeries(Price,index-41,O,L,H,C)
                -0.001621261388732*PriceSeries(Price,index-42,O,L,H,C)
                +0.000455422898788*PriceSeries(Price,index-43,O,L,H,C)
                +0.002424290448880*PriceSeries(Price,index-44,O,L,H,C)
                +0.00425079297051*PriceSeries(Price,index-45,O,L,H,C)
                +0.00590462783686*PriceSeries(Price,index-46,O,L,H,C)
                +0.00736012372895*PriceSeries(Price,index-47,O,L,H,C)
                +0.00859653241005*PriceSeries(Price,index-48,O,L,H,C)
                +0.00959822434417*PriceSeries(Price,index-49,O,L,H,C)
                +0.01035478606696*PriceSeries(Price,index-50,O,L,H,C)
                +0.01086102084038*PriceSeries(Price,index-51,O,L,H,C)
                +0.01111685424132*PriceSeries(Price,index-52,O,L,H,C)
                +0.01112714863959*PriceSeries(Price,index-53,O,L,H,C)
                +0.01090143296753*PriceSeries(Price,index-54,O,L,H,C)
                +0.01045355404361*PriceSeries(Price,index-55,O,L,H,C)
                +0.00980125864398*PriceSeries(Price,index-56,O,L,H,C)
                +0.00896571492188*PriceSeries(Price,index-57,O,L,H,C)
                +0.00797098447032*PriceSeries(Price,index-58,O,L,H,C)
                +0.00684345569383*PriceSeries(Price,index-59,O,L,H,C)
                +0.00561124979345*PriceSeries(Price,index-60,O,L,H,C)
                +0.00430361218286*PriceSeries(Price,index-61,O,L,H,C)
                +0.002950300249790*PriceSeries(Price,index-62,O,L,H,C)
                +0.001580979952117*PriceSeries(Price,index-63,O,L,H,C)
                +0.0002246416662596*PriceSeries(Price,index-64,O,L,H,C)
                -0.001090953268873*PriceSeries(Price,index-65,O,L,H,C)
                -0.002339785714734*PriceSeries(Price,index-66,O,L,H,C)
                -0.00349804339969*PriceSeries(Price,index-67,O,L,H,C)
                -0.00454452833866*PriceSeries(Price,index-68,O,L,H,C)
                -0.00546100164715*PriceSeries(Price,index-69,O,L,H,C)
                -0.00623245985836*PriceSeries(Price,index-70,O,L,H,C)
                -0.00684733984386*PriceSeries(Price,index-71,O,L,H,C)
                -0.00729764953734*PriceSeries(Price,index-72,O,L,H,C)
                -0.00757902380067*PriceSeries(Price,index-73,O,L,H,C)
                -0.00769070715649*PriceSeries(Price,index-74,O,L,H,C)
                -0.00763546437267*PriceSeries(Price,index-75,O,L,H,C)
                -0.00741942351533*PriceSeries(Price,index-76,O,L,H,C)
                -0.00705185550648*PriceSeries(Price,index-77,O,L,H,C)
                -0.00654489680028*PriceSeries(Price,index-78,O,L,H,C)
                -0.00591322173295*PriceSeries(Price,index-79,O,L,H,C)
                -0.00517367205497*PriceSeries(Price,index-80,O,L,H,C)
                -0.00434485320794*PriceSeries(Price,index-81,O,L,H,C)
                -0.00344670485438*PriceSeries(Price,index-82,O,L,H,C)
                -0.002500055906751*PriceSeries(Price,index-83,O,L,H,C)
                -0.001526172753573*PriceSeries(Price,index-84,O,L,H,C)
                -0.000546310468773*PriceSeries(Price,index-85,O,L,H,C)
                +0.000418724201858*PriceSeries(Price,index-86,O,L,H,C)
                +0.001348990168950*PriceSeries(Price,index-87,O,L,H,C)
                +0.002225800385371*PriceSeries(Price,index-88,O,L,H,C)
                +0.003032075548962*PriceSeries(Price,index-89,O,L,H,C)
                +0.00375265578732*PriceSeries(Price,index-90,O,L,H,C)
                +0.00437456543693*PriceSeries(Price,index-91,O,L,H,C)
                +0.00488722633991*PriceSeries(Price,index-92,O,L,H,C)
                +0.00528261648830*PriceSeries(Price,index-93,O,L,H,C)
                +0.00555537296661*PriceSeries(Price,index-94,O,L,H,C)
                +0.00570283684946*PriceSeries(Price,index-95,O,L,H,C)
                +0.00572504189839*PriceSeries(Price,index-96,O,L,H,C)
                +0.00562464777175*PriceSeries(Price,index-97,O,L,H,C)
                +0.00540682070886*PriceSeries(Price,index-98,O,L,H,C)
                +0.00507906529430*PriceSeries(Price,index-99,O,L,H,C)
                +0.00465101150731*PriceSeries(Price,index-100,O,L,H,C)
                +0.00413416354435*PriceSeries(Price,index-101,O,L,H,C)
                +0.00354161473659*PriceSeries(Price,index-102,O,L,H,C)
                +0.002887736612442*PriceSeries(Price,index-103,O,L,H,C)
                +0.002187848546737*PriceSeries(Price,index-104,O,L,H,C)
                +0.001457875325970*PriceSeries(Price,index-105,O,L,H,C)
                +0.000714000130723*PriceSeries(Price,index-106,O,L,H,C)
                -0.00002768047593952*PriceSeries(Price,index-107,O,L,H,C)
                -0.000751491101426*PriceSeries(Price,index-108,O,L,H,C)
                -0.001442496652742*PriceSeries(Price,index-109,O,L,H,C)
                -0.002086798449071*PriceSeries(Price,index-110,O,L,H,C)
                -0.002671802008222*PriceSeries(Price,index-111,O,L,H,C)
                -0.00318645183487*PriceSeries(Price,index-112,O,L,H,C)
                -0.00362142862606*PriceSeries(Price,index-113,O,L,H,C)
                -0.00396930649576*PriceSeries(Price,index-114,O,L,H,C)
                -0.00422466619261*PriceSeries(Price,index-115,O,L,H,C)
                -0.00438416465534*PriceSeries(Price,index-116,O,L,H,C)
                -0.00444655935749*PriceSeries(Price,index-117,O,L,H,C)
                -0.00441268796163*PriceSeries(Price,index-118,O,L,H,C)
                -0.00428540520855*PriceSeries(Price,index-119,O,L,H,C)
                -0.00406947848325*PriceSeries(Price,index-120,O,L,H,C)
                -0.00377144618855*PriceSeries(Price,index-121,O,L,H,C)
                -0.00339944095922*PriceSeries(Price,index-122,O,L,H,C)
                -0.002962983915981*PriceSeries(Price,index-123,O,L,H,C)
                -0.002472754151251*PriceSeries(Price,index-124,O,L,H,C)
                -0.001940338430468*PriceSeries(Price,index-125,O,L,H,C)
                -0.001377967580127*PriceSeries(Price,index-126,O,L,H,C)
                -0.000798244331484*PriceSeries(Price,index-127,O,L,H,C)
                -0.0002138698315648*PriceSeries(Price,index-128,O,L,H,C)
                +0.000362627144256*PriceSeries(Price,index-129,O,L,H,C)
                +0.000919151091510*PriceSeries(Price,index-130,O,L,H,C)
                +0.001444285954445*PriceSeries(Price,index-131,O,L,H,C)
                +0.001927522511810*PriceSeries(Price,index-132,O,L,H,C)
                +0.002359461367322*PriceSeries(Price,index-133,O,L,H,C)
                +0.002731988923115*PriceSeries(Price,index-134,O,L,H,C)
                +0.003038421704843*PriceSeries(Price,index-135,O,L,H,C)
                +0.00327361841825*PriceSeries(Price,index-136,O,L,H,C)
                +0.00343405681289*PriceSeries(Price,index-137,O,L,H,C)
                +0.00351787445981*PriceSeries(Price,index-138,O,L,H,C)
                +0.00352487446736*PriceSeries(Price,index-139,O,L,H,C)
                +0.00345649515087*PriceSeries(Price,index-140,O,L,H,C)
                +0.00331574635433*PriceSeries(Price,index-141,O,L,H,C)
                +0.003107112993841*PriceSeries(Price,index-142,O,L,H,C)
                +0.002836430204013*PriceSeries(Price,index-143,O,L,H,C)
                +0.002510732360525*PriceSeries(Price,index-144,O,L,H,C)
                +0.002138079130151*PriceSeries(Price,index-145,O,L,H,C)
                +0.001727364253232*PriceSeries(Price,index-146,O,L,H,C)
                +0.001288109694088*PriceSeries(Price,index-147,O,L,H,C)
                +0.000830251290078*PriceSeries(Price,index-148,O,L,H,C)
                +0.000363919183060*PriceSeries(Price,index-149,O,L,H,C)
                -0.0001007808489142*PriceSeries(Price,index-150,O,L,H,C)
                -0.000553981118276*PriceSeries(Price,index-151,O,L,H,C)
                -0.000986257417720*PriceSeries(Price,index-152,O,L,H,C)
                -0.001388819791129*PriceSeries(Price,index-153,O,L,H,C)
                -0.001753686802988*PriceSeries(Price,index-154,O,L,H,C)
                -0.002073838520692*PriceSeries(Price,index-155,O,L,H,C)
                -0.002343346761279*PriceSeries(Price,index-156,O,L,H,C)
                -0.002557479268274*PriceSeries(Price,index-157,O,L,H,C)
                -0.002712776125898*PriceSeries(Price,index-158,O,L,H,C)
                -0.002807098817964*PriceSeries(Price,index-159,O,L,H,C)
                -0.002839648976552*PriceSeries(Price,index-160,O,L,H,C)
                -0.002810959052900*PriceSeries(Price,index-161,O,L,H,C)
                -0.002722854408842*PriceSeries(Price,index-162,O,L,H,C)
                -0.002578389255499*PriceSeries(Price,index-163,O,L,H,C)
                -0.002381757581101*PriceSeries(Price,index-164,O,L,H,C)
                -0.002138180870652*PriceSeries(Price,index-165,O,L,H,C)
                -0.001853777541311*PriceSeries(Price,index-166,O,L,H,C)
                -0.001535414612275*PriceSeries(Price,index-167,O,L,H,C)
                -0.001190547132397*PriceSeries(Price,index-168,O,L,H,C)
                -0.000827047905013*PriceSeries(Price,index-169,O,L,H,C)
                -0.000453031920337*PriceSeries(Price,index-170,O,L,H,C)
                -0.0000766790836294*PriceSeries(Price,index-171,O,L,H,C)
                +0.0002939419899150*PriceSeries(Price,index-172,O,L,H,C)
                +0.000651042744678*PriceSeries(Price,index-173,O,L,H,C)
                +0.000987275394830*PriceSeries(Price,index-174,O,L,H,C)
                +0.001295880563273*PriceSeries(Price,index-175,O,L,H,C)
                +0.001570819762744*PriceSeries(Price,index-176,O,L,H,C)
                +0.001806889964115*PriceSeries(Price,index-177,O,L,H,C)
                +0.001999817775159*PriceSeries(Price,index-178,O,L,H,C)
                +0.002146333192865*PriceSeries(Price,index-179,O,L,H,C)
                +0.002244218814017*PriceSeries(Price,index-180,O,L,H,C)
                +0.002292336879030*PriceSeries(Price,index-181,O,L,H,C)
                +0.002290632525683*PriceSeries(Price,index-182,O,L,H,C)
                +0.002240113836746*PriceSeries(Price,index-183,O,L,H,C)
                +0.002142809766893*PriceSeries(Price,index-184,O,L,H,C)
                +0.002001706414332*PriceSeries(Price,index-185,O,L,H,C)
                +0.001820665649446*PriceSeries(Price,index-186,O,L,H,C)
                +0.001604325012515*PriceSeries(Price,index-187,O,L,H,C)
                +0.001357984114812*PriceSeries(Price,index-188,O,L,H,C)
                +0.001087479064661*PriceSeries(Price,index-189,O,L,H,C)
                +0.000799047398710*PriceSeries(Price,index-190,O,L,H,C)
                +0.000499187456879*PriceSeries(Price,index-191,O,L,H,C)
                +0.0001945140235134*PriceSeries(Price,index-192,O,L,H,C)
                -0.0001083839549990*PriceSeries(Price,index-193,O,L,H,C)
                -0.000403084002137*PriceSeries(Price,index-194,O,L,H,C)
                -0.000683463737311*PriceSeries(Price,index-195,O,L,H,C)
                -0.000943825257723*PriceSeries(Price,index-196,O,L,H,C)
                -0.001179008756579*PriceSeries(Price,index-197,O,L,H,C)
                -0.001384491667621*PriceSeries(Price,index-198,O,L,H,C)
                -0.001556473384857*PriceSeries(Price,index-199,O,L,H,C)
                -0.001691941194317*PriceSeries(Price,index-200,O,L,H,C)
                -0.001788719788227*PriceSeries(Price,index-201,O,L,H,C)
                -0.001845501563091*PriceSeries(Price,index-202,O,L,H,C)
                -0.001861857034541*PriceSeries(Price,index-203,O,L,H,C)
                -0.001838227239669*PriceSeries(Price,index-204,O,L,H,C)
                -0.001775896744132*PriceSeries(Price,index-205,O,L,H,C)
                -0.001676950585268*PriceSeries(Price,index-206,O,L,H,C)
                -0.001544213298141*PriceSeries(Price,index-207,O,L,H,C)
                -0.001381174721535*PriceSeries(Price,index-208,O,L,H,C)
                -0.001191902938701*PriceSeries(Price,index-209,O,L,H,C)
                -0.000980945314853*PriceSeries(Price,index-210,O,L,H,C)
                -0.000753222563210*PriceSeries(Price,index-211,O,L,H,C)
                -0.000513915867924*PriceSeries(Price,index-212,O,L,H,C)
                -0.0002683521233045*PriceSeries(Price,index-213,O,L,H,C)
                -0.00002188658191332*PriceSeries(Price,index-214,O,L,H,C)
                +0.0002202118219115*PriceSeries(Price,index-215,O,L,H,C)
                +0.000452870581276*PriceSeries(Price,index-216,O,L,H,C)
                +0.000671318885899*PriceSeries(Price,index-217,O,L,H,C)
                +0.000871182711680*PriceSeries(Price,index-218,O,L,H,C)
                +0.001048570839273*PriceSeries(Price,index-219,O,L,H,C)
                +0.001200147599352*PriceSeries(Price,index-220,O,L,H,C)
                +0.001323193920817*PriceSeries(Price,index-221,O,L,H,C)
                +0.001415653307928*PriceSeries(Price,index-222,O,L,H,C)
                +0.001476161590780*PriceSeries(Price,index-223,O,L,H,C)
                +0.001504063240884*PriceSeries(Price,index-224,O,L,H,C)
                +0.001499410497800*PriceSeries(Price,index-225,O,L,H,C)
                +0.001462948784957*PriceSeries(Price,index-226,O,L,H,C)
                +0.001396086393311*PriceSeries(Price,index-227,O,L,H,C)
                +0.001300851779052*PriceSeries(Price,index-228,O,L,H,C)
                +0.001179838218946*PriceSeries(Price,index-229,O,L,H,C)
                +0.001036135915483*PriceSeries(Price,index-230,O,L,H,C)
                +0.000873257349818*PriceSeries(Price,index-231,O,L,H,C)
                +0.000695053283661*PriceSeries(Price,index-232,O,L,H,C)
                +0.000505624331520*PriceSeries(Price,index-233,O,L,H,C)
                +0.0003092278081291*PriceSeries(Price,index-234,O,L,H,C)
                +0.0001101839168421*PriceSeries(Price,index-235,O,L,H,C)
                -0.0000872170197021*PriceSeries(Price,index-236,O,L,H,C)
                -0.0002788068461735*PriceSeries(Price,index-237,O,L,H,C)
                -0.000460624661344*PriceSeries(Price,index-238,O,L,H,C)
                -0.000628997785542*PriceSeries(Price,index-239,O,L,H,C)
                -0.000780614142801*PriceSeries(Price,index-240,O,L,H,C)
                -0.000912586174070*PriceSeries(Price,index-241,O,L,H,C)
                -0.001022503826850*PriceSeries(Price,index-242,O,L,H,C)
                -0.001108475119585*PriceSeries(Price,index-243,O,L,H,C)
                -0.001169157499229*PriceSeries(Price,index-244,O,L,H,C)
                -0.001203774019401*PriceSeries(Price,index-245,O,L,H,C)
                -0.001212118931148*PriceSeries(Price,index-246,O,L,H,C)
                -0.001194550343071*PriceSeries(Price,index-247,O,L,H,C)
                -0.001151971164743*PriceSeries(Price,index-248,O,L,H,C)
                -0.001085798917818*PriceSeries(Price,index-249,O,L,H,C)
                -0.000997923664232*PriceSeries(Price,index-250,O,L,H,C)
                -0.000890659912871*PriceSeries(Price,index-251,O,L,H,C)
                -0.000766687365605*PriceSeries(Price,index-252,O,L,H,C)
                -0.000628986327602*PriceSeries(Price,index-253,O,L,H,C)
                -0.000480767853439*PriceSeries(Price,index-254,O,L,H,C)
                -0.000325400262471*PriceSeries(Price,index-255,O,L,H,C)
                -0.0001663347105924*PriceSeries(Price,index-256,O,L,H,C)
                -0.00000702844862647*PriceSeries(Price,index-257,O,L,H,C)
                +0.0001491270798041*PriceSeries(Price,index-258,O,L,H,C)
                +0.0002988783472320*PriceSeries(Price,index-259,O,L,H,C)
                +0.000439176514108*PriceSeries(Price,index-260,O,L,H,C)
                +0.000567237752171*PriceSeries(Price,index-261,O,L,H,C)
                +0.000680597303555*PriceSeries(Price,index-262,O,L,H,C)
                +0.000777154315566*PriceSeries(Price,index-263,O,L,H,C)
                +0.000855210782969*PriceSeries(Price,index-264,O,L,H,C)
                +0.000913497473934*PriceSeries(Price,index-265,O,L,H,C)
                +0.000951192751453*PriceSeries(Price,index-266,O,L,H,C)
                +0.000967931022610*PriceSeries(Price,index-267,O,L,H,C)
                +0.000963799959365*PriceSeries(Price,index-268,O,L,H,C)
                +0.000939329667212*PriceSeries(Price,index-269,O,L,H,C)
                +0.000895470993439*PriceSeries(Price,index-270,O,L,H,C)
                +0.000833568369381*PriceSeries(Price,index-271,O,L,H,C)
                +0.000755320871918*PriceSeries(Price,index-272,O,L,H,C)
                +0.000662738539054*PriceSeries(Price,index-273,O,L,H,C)
                +0.000558093592633*PriceSeries(Price,index-274,O,L,H,C)
                +0.000443865275028*PriceSeries(Price,index-275,O,L,H,C)
                +0.000322683677930*PriceSeries(Price,index-276,O,L,H,C)
                +0.0001972692674747*PriceSeries(Price,index-277,O,L,H,C)
                +0.0000703749158858*PriceSeries(Price,index-278,O,L,H,C)
                -0.0000552752082041*PriceSeries(Price,index-279,O,L,H,C)
                -0.0001770432397274*PriceSeries(Price,index-280,O,L,H,C)
                -0.0002924304172861*PriceSeries(Price,index-281,O,L,H,C)
                -0.000399128669224*PriceSeries(Price,index-282,O,L,H,C)
                -0.000495064558183*PriceSeries(Price,index-283,O,L,H,C)
                -0.000578439914938*PriceSeries(Price,index-284,O,L,H,C)
                -0.000647762195402*PriceSeries(Price,index-285,O,L,H,C)
                -0.000701870618236*PriceSeries(Price,index-286,O,L,H,C)
                -0.000739953967516*PriceSeries(Price,index-287,O,L,H,C)
                -0.000761558056924*PriceSeries(Price,index-288,O,L,H,C)
                -0.000766589460431*PriceSeries(Price,index-289,O,L,H,C)
                -0.000755308532798*PriceSeries(Price,index-290,O,L,H,C)
                -0.000728317514799*PriceSeries(Price,index-291,O,L,H,C)
                -0.000686538071808*PriceSeries(Price,index-292,O,L,H,C)
                -0.000631185061409*PriceSeries(Price,index-293,O,L,H,C)
                -0.000563735392372*PriceSeries(Price,index-294,O,L,H,C)
                -0.000485888377663*PriceSeries(Price,index-295,O,L,H,C)
                -0.000399526770259*PriceSeries(Price,index-296,O,L,H,C)
                -0.0003066712598369*PriceSeries(Price,index-297,O,L,H,C)
                -0.0002094354727504*PriceSeries(Price,index-298,O,L,H,C)
                -0.0001099772171064*PriceSeries(Price,index-299,O,L,H,C)
                -0.00001045183286322*PriceSeries(Price,index-300,O,L,H,C)
                +0.0000870314677697*PriceSeries(Price,index-301,O,L,H,C)
                +0.0001804565271792*PriceSeries(Price,index-302,O,L,H,C)
                +0.0002679390760318*PriceSeries(Price,index-303,O,L,H,C)
                +0.000347765042696*PriceSeries(Price,index-304,O,L,H,C)
                +0.000418421789272*PriceSeries(Price,index-305,O,L,H,C)
                +0.000478626320889*PriceSeries(Price,index-306,O,L,H,C)
                +0.000527347430174*PriceSeries(Price,index-307,O,L,H,C)
                +0.000563819105665*PriceSeries(Price,index-308,O,L,H,C)
                +0.000587554480911*PriceSeries(Price,index-309,O,L,H,C)
                +0.000598347713856*PriceSeries(Price,index-310,O,L,H,C)
                +0.000596272476739*PriceSeries(Price,index-311,O,L,H,C)
                +0.000581672812888*PriceSeries(Price,index-312,O,L,H,C)
                +0.000555149942563*PriceSeries(Price,index-313,O,L,H,C)
                +0.000517544795869*PriceSeries(Price,index-314,O,L,H,C)
                +0.000469911123800*PriceSeries(Price,index-315,O,L,H,C)
                +0.000413491810174*PriceSeries(Price,index-316,O,L,H,C)
                +0.000349685722748*PriceSeries(Price,index-317,O,L,H,C)
                +0.0002800144975989*PriceSeries(Price,index-318,O,L,H,C)
                +0.0002060872755635*PriceSeries(Price,index-319,O,L,H,C)
                +0.0001295647033017*PriceSeries(Price,index-320,O,L,H,C)
                +0.0000521245062946*PriceSeries(Price,index-321,O,L,H,C)
                -0.00002457910559967*PriceSeries(Price,index-322,O,L,H,C)
                -0.0000989463681593*PriceSeries(Price,index-323,O,L,H,C)
                -0.0001694661938145*PriceSeries(Price,index-324,O,L,H,C)
                -0.0002347460356758*PriceSeries(Price,index-325,O,L,H,C)
                -0.0002935377261475*PriceSeries(Price,index-326,O,L,H,C)
                -0.000344761238758*PriceSeries(Price,index-327,O,L,H,C)
                -0.000387521042866*PriceSeries(Price,index-328,O,L,H,C)
                -0.000421125732598*PriceSeries(Price,index-329,O,L,H,C)
                -0.000445093589939*PriceSeries(Price,index-330,O,L,H,C)
                -0.000459158172047*PriceSeries(Price,index-331,O,L,H,C)
                -0.000463269656737*PriceSeries(Price,index-332,O,L,H,C)
                -0.000457589425827*PriceSeries(Price,index-333,O,L,H,C)
                -0.000442483092643*PriceSeries(Price,index-334,O,L,H,C)
                -0.000418503878627*PriceSeries(Price,index-335,O,L,H,C)
                -0.000386381074881*PriceSeries(Price,index-336,O,L,H,C)
                -0.000346996208839*PriceSeries(Price,index-337,O,L,H,C)
                -0.0003013607326119*PriceSeries(Price,index-338,O,L,H,C)
                -0.0002505942187174*PriceSeries(Price,index-339,O,L,H,C)
                -0.0001958960898303*PriceSeries(Price,index-340,O,L,H,C)
                -0.0001385201130563*PriceSeries(Price,index-341,O,L,H,C)
                -0.0000797414646674*PriceSeries(Price,index-342,O,L,H,C)
                -0.00002083444553261*PriceSeries(Price,index-343,O,L,H,C)
                +0.0000369572735468*PriceSeries(Price,index-344,O,L,H,C)
                +0.0000924470396086*PriceSeries(Price,index-345,O,L,H,C)
                +0.0001445250602596*PriceSeries(Price,index-346,O,L,H,C)
                +0.0001921831981926*PriceSeries(Price,index-347,O,L,H,C)
                +0.0002345309602687*PriceSeries(Price,index-348,O,L,H,C)
                +0.0002708159691190*PriceSeries(Price,index-349,O,L,H,C)
                +0.0003004301911761*PriceSeries(Price,index-350,O,L,H,C)
                +0.000322920913408*PriceSeries(Price,index-351,O,L,H,C)
                +0.000337999640005*PriceSeries(Price,index-352,O,L,H,C)
                +0.000345539292739*PriceSeries(Price,index-353,O,L,H,C)
                +0.000345576612506*PriceSeries(Price,index-354,O,L,H,C)
                +0.000338302987791*PriceSeries(Price,index-355,O,L,H,C)
                +0.000324060974751*PriceSeries(Price,index-356,O,L,H,C)
                +0.0003033279259446*PriceSeries(Price,index-357,O,L,H,C)
                +0.0002767037573119*PriceSeries(Price,index-358,O,L,H,C)
                +0.0002449006695365*PriceSeries(Price,index-359,O,L,H,C)
                +0.0002087180706149*PriceSeries(Price,index-360,O,L,H,C)
                +0.0001690271323410*PriceSeries(Price,index-361,O,L,H,C)
                +0.0001267459758027*PriceSeries(Price,index-362,O,L,H,C)
                +0.0000828243981602*PriceSeries(Price,index-363,O,L,H,C)
                +0.0000382190833003*PriceSeries(Price,index-364,O,L,H,C)
                -0.00000612773674554*PriceSeries(Price,index-365,O,L,H,C)
                -0.0000493005311795*PriceSeries(Price,index-366,O,L,H,C)
                -0.0000904378207052*PriceSeries(Price,index-367,O,L,H,C)
                -0.0001287432507599*PriceSeries(Price,index-368,O,L,H,C)
                -0.0001635034648825*PriceSeries(Price,index-369,O,L,H,C)
                -0.0001940955247709*PriceSeries(Price,index-370,O,L,H,C)
                -0.0002200013302001*PriceSeries(Price,index-371,O,L,H,C)
                -0.0002408204888702*PriceSeries(Price,index-372,O,L,H,C)
                -0.0002562655407857*PriceSeries(Price,index-373,O,L,H,C)
                -0.0002661742679175*PriceSeries(Price,index-374,O,L,H,C)
                -0.0002705029796269*PriceSeries(Price,index-375,O,L,H,C)
                -0.0002693268767804*PriceSeries(Price,index-376,O,L,H,C)
                -0.0002628319879372*PriceSeries(Price,index-377,O,L,H,C)
                -0.0002513106208954*PriceSeries(Price,index-378,O,L,H,C)
                -0.0002351594001466*PriceSeries(Price,index-379,O,L,H,C)
                -0.0002148536000677*PriceSeries(Price,index-380,O,L,H,C)
                -0.0001909459825473*PriceSeries(Price,index-381,O,L,H,C)
                -0.0001640483791728*PriceSeries(Price,index-382,O,L,H,C)
                -0.0001348200110852*PriceSeries(Price,index-383,O,L,H,C)
                -0.0001039502977147*PriceSeries(Price,index-384,O,L,H,C)
                -0.0000721415979301*PriceSeries(Price,index-385,O,L,H,C)
                -0.0000401040845164*PriceSeries(Price,index-386,O,L,H,C)
                -0.00000852358028289*PriceSeries(Price,index-387,O,L,H,C)
                +0.00002193773573205*PriceSeries(Price,index-388,O,L,H,C)
                +0.0000506567748192*PriceSeries(Price,index-389,O,L,H,C)
                +0.0000770622126682*PriceSeries(Price,index-390,O,L,H,C)
                +0.0001006466152481*PriceSeries(Price,index-391,O,L,H,C)
                +0.0001209809078233*PriceSeries(Price,index-392,O,L,H,C)
                +0.0001377043011255*PriceSeries(Price,index-393,O,L,H,C)
                +0.0001505487225852*PriceSeries(Price,index-394,O,L,H,C)
                +0.0001593267506164*PriceSeries(Price,index-395,O,L,H,C)
                +0.0001639344124008*PriceSeries(Price,index-396,O,L,H,C)
                +0.0001643566053446*PriceSeries(Price,index-397,O,L,H,C)
                +0.0001606621007694*PriceSeries(Price,index-398,O,L,H,C)
                +0.0001530080648826*PriceSeries(Price,index-399,O,L,H,C)
                +0.0001416116977086*PriceSeries(Price,index-400,O,L,H,C)
                +0.0001267702709987*PriceSeries(Price,index-401,O,L,H,C)
                +0.0001088418988501*PriceSeries(Price,index-402,O,L,H,C)
                +0.0000882328728239*PriceSeries(Price,index-403,O,L,H,C)
                +0.0000653957890450*PriceSeries(Price,index-404,O,L,H,C)
                +0.0000408077190790*PriceSeries(Price,index-405,O,L,H,C)
                +0.00001497394297904*PriceSeries(Price,index-406,O,L,H,C)
                -0.00001160974325223*PriceSeries(Price,index-407,O,L,H,C)
                -0.0000384334257981*PriceSeries(Price,index-408,O,L,H,C)
                -0.0000649925370974*PriceSeries(Price,index-409,O,L,H,C)
                -0.0000908128632768*PriceSeries(Price,index-410,O,L,H,C)
                -0.0001154434874346*PriceSeries(Price,index-411,O,L,H,C)
                -0.0001384796287750*PriceSeries(Price,index-412,O,L,H,C)
                -0.0001595428870728*PriceSeries(Price,index-413,O,L,H,C)
                -0.0001783230286857*PriceSeries(Price,index-414,O,L,H,C)
                -0.0001945485243899*PriceSeries(Price,index-415,O,L,H,C)
                -0.0002079964407142*PriceSeries(Price,index-416,O,L,H,C)
                -0.0002185234782178*PriceSeries(Price,index-417,O,L,H,C)
                -0.0002260320928319*PriceSeries(Price,index-418,O,L,H,C)
                -0.0002304919691405*PriceSeries(Price,index-419,O,L,H,C)
                -0.0002319054619278*PriceSeries(Price,index-420,O,L,H,C)
                -0.0002303607965575*PriceSeries(Price,index-421,O,L,H,C)
                -0.0002259939001420*PriceSeries(Price,index-422,O,L,H,C)
                -0.0002189691702930*PriceSeries(Price,index-423,O,L,H,C)
                -0.0002095191843229*PriceSeries(Price,index-424,O,L,H,C)
                -0.0001978790693444*PriceSeries(Price,index-425,O,L,H,C)
                -0.0001843228977008*PriceSeries(Price,index-426,O,L,H,C)
                -0.0001691179574327*PriceSeries(Price,index-427,O,L,H,C)
                -0.0001525915715253*PriceSeries(Price,index-428,O,L,H,C)
                -0.0001350837183125*PriceSeries(Price,index-429,O,L,H,C)
                -0.0001168886630156*PriceSeries(Price,index-430,O,L,H,C)
                -0.0000983483914985*PriceSeries(Price,index-431,O,L,H,C)
                -0.0000797594889536*PriceSeries(Price,index-432,O,L,H,C)
                -0.0000614348378328*PriceSeries(Price,index-433,O,L,H,C)
                -0.0000436230263309*PriceSeries(Price,index-434,O,L,H,C)
                -0.00002658386181677*PriceSeries(Price,index-435,O,L,H,C)
                -0.00001055545875024*PriceSeries(Price,index-436,O,L,H,C)
                +0.00000435916059144*PriceSeries(Price,index-437,O,L,H,C)
                +0.00001796076256641*PriceSeries(Price,index-438,O,L,H,C)
                +0.00003011783535698*PriceSeries(Price,index-439,O,L,H,C)
                +0.0000406864939783*PriceSeries(Price,index-440,O,L,H,C)
                +0.0000496563105366*PriceSeries(Price,index-441,O,L,H,C)
                +0.0000570299513849*PriceSeries(Price,index-442,O,L,H,C)
                +0.0000627481950294*PriceSeries(Price,index-443,O,L,H,C)
                +0.0000670184266447*PriceSeries(Price,index-444,O,L,H,C)
                +0.0000697674950772*PriceSeries(Price,index-445,O,L,H,C)
                +0.0000710550592887*PriceSeries(Price,index-446,O,L,H,C)
                +0.0000709402797966*PriceSeries(Price,index-447,O,L,H,C)
                +0.0000697115019220*PriceSeries(Price,index-448,O,L,H,C)
                +0.0000676387628773*PriceSeries(Price,index-449,O,L,H,C)
                +0.0000642888543852*PriceSeries(Price,index-450,O,L,H,C)
                +0.0000604559558535*PriceSeries(Price,index-451,O,L,H,C)
                +0.0000559103339764*PriceSeries(Price,index-452,O,L,H,C)
                +0.0000509348300305*PriceSeries(Price,index-453,O,L,H,C)
                +0.0000456496499364*PriceSeries(Price,index-454,O,L,H,C)
                +0.0000401958520549*PriceSeries(Price,index-455,O,L,H,C)
                +0.0001279015579719*PriceSeries(Price,index-456,O,L,H,C)
                );

      case N47:
         return(
                0.0910645059930*PriceSeries(Price,index,O,L,H,C)
                +0.0904379604772*PriceSeries(Price,index-1,O,L,H,C)
                +0.0891926592003*PriceSeries(Price,index-2,O,L,H,C)
                +0.0873440664447*PriceSeries(Price,index-3,O,L,H,C)
                +0.0849150907330*PriceSeries(Price,index-4,O,L,H,C)
                +0.0819357458926*PriceSeries(Price,index-5,O,L,H,C)
                +0.0784427047475*PriceSeries(Price,index-6,O,L,H,C)
                +0.0744787605971*PriceSeries(Price,index-7,O,L,H,C)
                +0.0700921930897*PriceSeries(Price,index-8,O,L,H,C)
                +0.0653360619484*PriceSeries(Price,index-9,O,L,H,C)
                +0.0602674290191*PriceSeries(Price,index-10,O,L,H,C)
                +0.0549465295286*PriceSeries(Price,index-11,O,L,H,C)
                +0.0494358981058*PriceSeries(Price,index-12,O,L,H,C)
                +0.0437994715690*PriceSeries(Price,index-13,O,L,H,C)
                +0.0381016747732*PriceSeries(Price,index-14,O,L,H,C)
                +0.0324065119285*PriceSeries(Price,index-15,O,L,H,C)
                +0.02677666866351*PriceSeries(Price,index-16,O,L,H,C)
                +0.02127264855847*PriceSeries(Price,index-17,O,L,H,C)
                +0.01595194959645*PriceSeries(Price,index-18,O,L,H,C)
                +0.01086829785193*PriceSeries(Price,index-19,O,L,H,C)
                +0.00607094607444*PriceSeries(Price,index-20,O,L,H,C)
                +0.001604054097673*PriceSeries(Price,index-21,O,L,H,C)
                -0.002493850171236*PriceSeries(Price,index-22,O,L,H,C)
                -0.00619030914814*PriceSeries(Price,index-23,O,L,H,C)
                -0.00945928126210*PriceSeries(Price,index-24,O,L,H,C)
                -0.01228137429404*PriceSeries(Price,index-25,O,L,H,C)
                -0.01464398109248*PriceSeries(Price,index-26,O,L,H,C)
                -0.01654129960857*PriceSeries(Price,index-27,O,L,H,C)
                -0.01797425606425*PriceSeries(Price,index-28,O,L,H,C)
                -0.01895031376177*PriceSeries(Price,index-29,O,L,H,C)
                -0.01948319709645*PriceSeries(Price,index-30,O,L,H,C)
                -0.01959250902074*PriceSeries(Price,index-31,O,L,H,C)
                -0.01930327673085*PriceSeries(Price,index-32,O,L,H,C)
                -0.01864540998614*PriceSeries(Price,index-33,O,L,H,C)
                -0.01765310482763*PriceSeries(Price,index-34,O,L,H,C)
                -0.01636418182282*PriceSeries(Price,index-35,O,L,H,C)
                -0.01481939126973*PriceSeries(Price,index-36,O,L,H,C)
                -0.01306167809199*PriceSeries(Price,index-37,O,L,H,C)
                -0.01113543935795*PriceSeries(Price,index-38,O,L,H,C)
                -0.00908576557317*PriceSeries(Price,index-39,O,L,H,C)
                -0.00695769906403*PriceSeries(Price,index-40,O,L,H,C)
                -0.00479550446139*PriceSeries(Price,index-41,O,L,H,C)
                -0.002641977563154*PriceSeries(Price,index-42,O,L,H,C)
                -0.000537788473288*PriceSeries(Price,index-43,O,L,H,C)
                +0.001479112878448*PriceSeries(Price,index-44,O,L,H,C)
                +0.00337404017818*PriceSeries(Price,index-45,O,L,H,C)
                +0.00511603356599*PriceSeries(Price,index-46,O,L,H,C)
                +0.00667825905734*PriceSeries(Price,index-47,O,L,H,C)
                +0.00803831420989*PriceSeries(Price,index-48,O,L,H,C)
                +0.00917846165607*PriceSeries(Price,index-49,O,L,H,C)
                +0.01008576467186*PriceSeries(Price,index-50,O,L,H,C)
                +0.01075214872866*PriceSeries(Price,index-51,O,L,H,C)
                +0.01117436217058*PriceSeries(Price,index-52,O,L,H,C)
                +0.01135387039824*PriceSeries(Price,index-53,O,L,H,C)
                +0.01129665498102*PriceSeries(Price,index-54,O,L,H,C)
                +0.01101295352733*PriceSeries(Price,index-55,O,L,H,C)
                +0.01051691840893*PriceSeries(Price,index-56,O,L,H,C)
                +0.00982622857330*PriceSeries(Price,index-57,O,L,H,C)
                +0.00896163862978*PriceSeries(Price,index-58,O,L,H,C)
                +0.00794649619119*PriceSeries(Price,index-59,O,L,H,C)
                +0.00680621609823*PriceSeries(Price,index-60,O,L,H,C)
                +0.00556774392937*PriceSeries(Price,index-61,O,L,H,C)
                +0.00425899682605*PriceSeries(Price,index-62,O,L,H,C)
                +0.002908310966468*PriceSeries(Price,index-63,O,L,H,C)
                +0.001543891112324*PriceSeries(Price,index-64,O,L,H,C)
                +0.0001932849572595*PriceSeries(Price,index-65,O,L,H,C)
                -0.001117122671276*PriceSeries(Price,index-66,O,L,H,C)
                -0.002362571445175*PriceSeries(Price,index-67,O,L,H,C)
                -0.00352035260401*PriceSeries(Price,index-68,O,L,H,C)
                -0.00457017547922*PriceSeries(Price,index-69,O,L,H,C)
                -0.00549448945182*PriceSeries(Price,index-70,O,L,H,C)
                -0.00627873488509*PriceSeries(Price,index-71,O,L,H,C)
                -0.00691153963362*PriceSeries(Price,index-72,O,L,H,C)
                -0.00738484104495*PriceSeries(Price,index-73,O,L,H,C)
                -0.00769395244986*PriceSeries(Price,index-74,O,L,H,C)
                -0.00783755140199*PriceSeries(Price,index-75,O,L,H,C)
                -0.00781761634695*PriceSeries(Price,index-76,O,L,H,C)
                -0.00763929069782*PriceSeries(Price,index-77,O,L,H,C)
                -0.00731070018160*PriceSeries(Price,index-78,O,L,H,C)
                -0.00684270858851*PriceSeries(Price,index-79,O,L,H,C)
                -0.00624863461156*PriceSeries(Price,index-80,O,L,H,C)
                -0.00554392335825*PriceSeries(Price,index-81,O,L,H,C)
                -0.00474579034752*PriceSeries(Price,index-82,O,L,H,C)
                -0.00387283435077*PriceSeries(Price,index-83,O,L,H,C)
                -0.002944639203592*PriceSeries(Price,index-84,O,L,H,C)
                -0.001981362806835*PriceSeries(Price,index-85,O,L,H,C)
                -0.001003326500282*PriceSeries(Price,index-86,O,L,H,C)
                -0.00003061136319313*PriceSeries(Price,index-87,O,L,H,C)
                +0.000917330624943*PriceSeries(Price,index-88,O,L,H,C)
                +0.001822044103020*PriceSeries(Price,index-89,O,L,H,C)
                +0.002666408583720*PriceSeries(Price,index-90,O,L,H,C)
                +0.00343494468436*PriceSeries(Price,index-91,O,L,H,C)
                +0.00411407685219*PriceSeries(Price,index-92,O,L,H,C)
                +0.00469235661544*PriceSeries(Price,index-93,O,L,H,C)
                +0.00516063640191*PriceSeries(Price,index-94,O,L,H,C)
                +0.00551219537363*PriceSeries(Price,index-95,O,L,H,C)
                +0.00574281249566*PriceSeries(Price,index-96,O,L,H,C)
                +0.00585079254798*PriceSeries(Price,index-97,O,L,H,C)
                +0.00583693731745*PriceSeries(Price,index-98,O,L,H,C)
                +0.00570447208348*PriceSeries(Price,index-99,O,L,H,C)
                +0.00545892293335*PriceSeries(Price,index-100,O,L,H,C)
                +0.00510795366925*PriceSeries(Price,index-101,O,L,H,C)
                +0.00466116406922*PriceSeries(Price,index-102,O,L,H,C)
                +0.00412985178527*PriceSeries(Price,index-103,O,L,H,C)
                +0.00352674988521*PriceSeries(Price,index-104,O,L,H,C)
                +0.002865738709970*PriceSeries(Price,index-105,O,L,H,C)
                +0.002161543806872*PriceSeries(Price,index-106,O,L,H,C)
                +0.001429420255180*PriceSeries(Price,index-107,O,L,H,C)
                +0.000684839568193*PriceSeries(Price,index-108,O,L,H,C)
                -0.0000568287925927*PriceSeries(Price,index-109,O,L,H,C)
                -0.000780618356282*PriceSeries(Price,index-110,O,L,H,C)
                -0.001472260973465*PriceSeries(Price,index-111,O,L,H,C)
                -0.002118452622206*PriceSeries(Price,index-112,O,L,H,C)
                -0.002707102219579*PriceSeries(Price,index-113,O,L,H,C)
                -0.00322754526635*PriceSeries(Price,index-114,O,L,H,C)
                -0.00367072886684*PriceSeries(Price,index-115,O,L,H,C)
                -0.00402935523966*PriceSeries(Price,index-116,O,L,H,C)
                -0.00429799421726*PriceSeries(Price,index-117,O,L,H,C)
                -0.00447314894524*PriceSeries(Price,index-118,O,L,H,C)
                -0.00455328697477*PriceSeries(Price,index-119,O,L,H,C)
                -0.00453882718754*PriceSeries(Price,index-120,O,L,H,C)
                -0.00443209212357*PriceSeries(Price,index-121,O,L,H,C)
                -0.00423721893561*PriceSeries(Price,index-122,O,L,H,C)
                -0.00396004035675*PriceSeries(Price,index-123,O,L,H,C)
                -0.00360792790266*PriceSeries(Price,index-124,O,L,H,C)
                -0.00318961683312*PriceSeries(Price,index-125,O,L,H,C)
                -0.002714995484488*PriceSeries(Price,index-126,O,L,H,C)
                -0.002194887662274*PriceSeries(Price,index-127,O,L,H,C)
                -0.001640810191936*PriceSeries(Price,index-128,O,L,H,C)
                -0.001064732007726*PriceSeries(Price,index-129,O,L,H,C)
                -0.000478816659110*PriceSeries(Price,index-130,O,L,H,C)
                +0.0001048197324317*PriceSeries(Price,index-131,O,L,H,C)
                +0.000674359739728*PriceSeries(Price,index-132,O,L,H,C)
                +0.001218508944186*PriceSeries(Price,index-133,O,L,H,C)
                +0.001726721844507*PriceSeries(Price,index-134,O,L,H,C)
                +0.002189392212431*PriceSeries(Price,index-135,O,L,H,C)
                +0.002598034088469*PriceSeries(Price,index-136,O,L,H,C)
                +0.002945425913290*PriceSeries(Price,index-137,O,L,H,C)
                +0.00322573683400*PriceSeries(Price,index-138,O,L,H,C)
                +0.00343461030975*PriceSeries(Price,index-139,O,L,H,C)
                +0.00356922909778*PriceSeries(Price,index-140,O,L,H,C)
                +0.00362833639294*PriceSeries(Price,index-141,O,L,H,C)
                +0.00361223504577*PriceSeries(Price,index-142,O,L,H,C)
                +0.00352274622304*PriceSeries(Price,index-143,O,L,H,C)
                +0.00336314655900*PriceSeries(Price,index-144,O,L,H,C)
                +0.003138069632807*PriceSeries(Price,index-145,O,L,H,C)
                +0.002853389861917*PriceSeries(Price,index-146,O,L,H,C)
                +0.002516072785121*PriceSeries(Price,index-147,O,L,H,C)
                +0.002134020489789*PriceSeries(Price,index-148,O,L,H,C)
                +0.001715885711033*PriceSeries(Price,index-149,O,L,H,C)
                +0.001270888495679*PriceSeries(Price,index-150,O,L,H,C)
                +0.000808611614214*PriceSeries(Price,index-151,O,L,H,C)
                +0.000338806635236*PriceSeries(Price,index-152,O,L,H,C)
                -0.0001288151354028*PriceSeries(Price,index-153,O,L,H,C)
                -0.000584770599924*PriceSeries(Price,index-154,O,L,H,C)
                -0.001020001624706*PriceSeries(Price,index-155,O,L,H,C)
                -0.001426041189023*PriceSeries(Price,index-156,O,L,H,C)
                -0.001795182836063*PriceSeries(Price,index-157,O,L,H,C)
                -0.002120615691286*PriceSeries(Price,index-158,O,L,H,C)
                -0.002396550681905*PriceSeries(Price,index-159,O,L,H,C)
                -0.002618313583380*PriceSeries(Price,index-160,O,L,H,C)
                -0.002782424449855*PriceSeries(Price,index-161,O,L,H,C)
                -0.002886639617875*PriceSeries(Price,index-162,O,L,H,C)
                -0.002929978966199*PriceSeries(Price,index-163,O,L,H,C)
                -0.002912717483433*PriceSeries(Price,index-164,O,L,H,C)
                -0.002836359883023*PriceSeries(Price,index-165,O,L,H,C)
                -0.002703583598587*PriceSeries(Price,index-166,O,L,H,C)
                -0.002518164053884*PriceSeries(Price,index-167,O,L,H,C)
                -0.002284875364666*PriceSeries(Price,index-168,O,L,H,C)
                -0.002009378071220*PriceSeries(Price,index-169,O,L,H,C)
                -0.001698081835569*PriceSeries(Price,index-170,O,L,H,C)
                -0.001358006985052*PriceSeries(Price,index-171,O,L,H,C)
                -0.000996625148904*PriceSeries(Price,index-172,O,L,H,C)
                -0.000621703371170*PriceSeries(Price,index-173,O,L,H,C)
                -0.0002411355984559*PriceSeries(Price,index-174,O,L,H,C)
                +0.0001372148323128*PriceSeries(Price,index-175,O,L,H,C)
                +0.000505679996408*PriceSeries(Price,index-176,O,L,H,C)
                +0.000856933771167*PriceSeries(Price,index-177,O,L,H,C)
                +0.001184141659722*PriceSeries(Price,index-178,O,L,H,C)
                +0.001481083490445*PriceSeries(Price,index-179,O,L,H,C)
                +0.001742273884192*PriceSeries(Price,index-180,O,L,H,C)
                +0.001963057422892*PriceSeries(Price,index-181,O,L,H,C)
                +0.002139689403855*PriceSeries(Price,index-182,O,L,H,C)
                +0.002269393261027*PriceSeries(Price,index-183,O,L,H,C)
                +0.002350401264927*PriceSeries(Price,index-184,O,L,H,C)
                +0.002381970191174*PriceSeries(Price,index-185,O,L,H,C)
                +0.002364378307168*PriceSeries(Price,index-186,O,L,H,C)
                +0.002298900029227*PriceSeries(Price,index-187,O,L,H,C)
                +0.002187761155378*PriceSeries(Price,index-188,O,L,H,C)
                +0.002034077912582*PriceSeries(Price,index-189,O,L,H,C)
                +0.001841773795532*PriceSeries(Price,index-190,O,L,H,C)
                +0.001615486847100*PriceSeries(Price,index-191,O,L,H,C)
                +0.001360462031516*PriceSeries(Price,index-192,O,L,H,C)
                +0.001082431659551*PriceSeries(Price,index-193,O,L,H,C)
                +0.000787490439677*PriceSeries(Price,index-194,O,L,H,C)
                +0.000481964387455*PriceSeries(Price,index-195,O,L,H,C)
                +0.0001722779512764*PriceSeries(Price,index-196,O,L,H,C)
                -0.0001351791522117*PriceSeries(Price,index-197,O,L,H,C)
                -0.000434181307960*PriceSeries(Price,index-198,O,L,H,C)
                -0.000718791441601*PriceSeries(Price,index-199,O,L,H,C)
                -0.000983474671872*PriceSeries(Price,index-200,O,L,H,C)
                -0.001223206873226*PriceSeries(Price,index-201,O,L,H,C)
                -0.001433565376353*PriceSeries(Price,index-202,O,L,H,C)
                -0.001610807215156*PriceSeries(Price,index-203,O,L,H,C)
                -0.001751935818834*PriceSeries(Price,index-204,O,L,H,C)
                -0.001854744872129*PriceSeries(Price,index-205,O,L,H,C)
                -0.001917851929193*PriceSeries(Price,index-206,O,L,H,C)
                -0.001940707521081*PriceSeries(Price,index-207,O,L,H,C)
                -0.001923595101653*PriceSeries(Price,index-208,O,L,H,C)
                -0.001867605456183*PriceSeries(Price,index-209,O,L,H,C)
                -0.001774604253180*PriceSeries(Price,index-210,O,L,H,C)
                -0.001647172942158*PriceSeries(Price,index-211,O,L,H,C)
                -0.001488551677730*PriceSeries(Price,index-212,O,L,H,C)
                -0.001302552082661*PriceSeries(Price,index-213,O,L,H,C)
                -0.001093475380428*PriceSeries(Price,index-214,O,L,H,C)
                -0.000866011130185*PriceSeries(Price,index-215,O,L,H,C)
                -0.000625138382396*PriceSeries(Price,index-216,O,L,H,C)
                -0.000376014315978*PriceSeries(Price,index-217,O,L,H,C)
                -0.0001238702300336*PriceSeries(Price,index-218,O,L,H,C)
                +0.0001261009806815*PriceSeries(Price,index-219,O,L,H,C)
                +0.000368845174763*PriceSeries(Price,index-220,O,L,H,C)
                +0.000599552608625*PriceSeries(Price,index-221,O,L,H,C)
                +0.000813747832881*PriceSeries(Price,index-222,O,L,H,C)
                +0.001007375951665*PriceSeries(Price,index-223,O,L,H,C)
                +0.001176876525968*PriceSeries(Price,index-224,O,L,H,C)
                +0.001319250255953*PriceSeries(Price,index-225,O,L,H,C)
                +0.001432103543503*PriceSeries(Price,index-226,O,L,H,C)
                +0.001513693404980*PriceSeries(Price,index-227,O,L,H,C)
                +0.001562943097379*PriceSeries(Price,index-228,O,L,H,C)
                +0.001579459608170*PriceSeries(Price,index-229,O,L,H,C)
                +0.001563520132475*PriceSeries(Price,index-230,O,L,H,C)
                +0.001516062181507*PriceSeries(Price,index-231,O,L,H,C)
                +0.001438644017540*PriceSeries(Price,index-232,O,L,H,C)
                +0.001333410768127*PriceSeries(Price,index-233,O,L,H,C)
                +0.001203026998678*PriceSeries(Price,index-234,O,L,H,C)
                +0.001050626322120*PriceSeries(Price,index-235,O,L,H,C)
                +0.000879726439918*PriceSeries(Price,index-236,O,L,H,C)
                +0.000694159415562*PriceSeries(Price,index-237,O,L,H,C)
                +0.000497979912133*PriceSeries(Price,index-238,O,L,H,C)
                +0.0002953856328295*PriceSeries(Price,index-239,O,L,H,C)
                +0.0000906219066976*PriceSeries(Price,index-240,O,L,H,C)
                -0.0001120993418424*PriceSeries(Price,index-241,O,L,H,C)
                -0.0003086920661791*PriceSeries(Price,index-242,O,L,H,C)
                -0.000495268921880*PriceSeries(Price,index-243,O,L,H,C)
                -0.000668223740895*PriceSeries(Price,index-244,O,L,H,C)
                -0.000824295774973*PriceSeries(Price,index-245,O,L,H,C)
                -0.000960631528503*PriceSeries(Price,index-246,O,L,H,C)
                -0.001074832295538*PriceSeries(Price,index-247,O,L,H,C)
                -0.001165000227930*PriceSeries(Price,index-248,O,L,H,C)
                -0.001229759471631*PriceSeries(Price,index-249,O,L,H,C)
                -0.001268282684717*PriceSeries(Price,index-250,O,L,H,C)
                -0.001280288120249*PriceSeries(Price,index-251,O,L,H,C)
                -0.001266044880325*PriceSeries(Price,index-252,O,L,H,C)
                -0.001226347443458*PriceSeries(Price,index-253,O,L,H,C)
                -0.001162497399894*PriceSeries(Price,index-254,O,L,H,C)
                -0.001076258327897*PriceSeries(Price,index-255,O,L,H,C)
                -0.000969822565540*PriceSeries(Price,index-256,O,L,H,C)
                -0.000845743549061*PriceSeries(Price,index-257,O,L,H,C)
                -0.000706890957345*PriceSeries(Price,index-258,O,L,H,C)
                -0.000556374853213*PriceSeries(Price,index-259,O,L,H,C)
                -0.000397486110656*PriceSeries(Price,index-260,O,L,H,C)
                -0.0002336183607625*PriceSeries(Price,index-261,O,L,H,C)
                -0.0000682027297155*PriceSeries(Price,index-262,O,L,H,C)
                +0.0000953676176825*PriceSeries(Price,index-263,O,L,H,C)
                +0.0002538009166955*PriceSeries(Price,index-264,O,L,H,C)
                +0.000403978311776*PriceSeries(Price,index-265,O,L,H,C)
                +0.000543007732457*PriceSeries(Price,index-266,O,L,H,C)
                +0.000668281644601*PriceSeries(Price,index-267,O,L,H,C)
                +0.000777525335194*PriceSeries(Price,index-268,O,L,H,C)
                +0.000868835214662*PriceSeries(Price,index-269,O,L,H,C)
                +0.000940709316246*PriceSeries(Price,index-270,O,L,H,C)
                +0.000992073240009*PriceSeries(Price,index-271,O,L,H,C)
                +0.001022288953115*PriceSeries(Price,index-272,O,L,H,C)
                +0.001031165029628*PriceSeries(Price,index-273,O,L,H,C)
                +0.001018944523139*PriceSeries(Price,index-274,O,L,H,C)
                +0.000986298154750*PriceSeries(Price,index-275,O,L,H,C)
                +0.000934297260863*PriceSeries(Price,index-276,O,L,H,C)
                +0.000864387434468*PriceSeries(Price,index-277,O,L,H,C)
                +0.000778345482870*PriceSeries(Price,index-278,O,L,H,C)
                +0.000678246802487*PriceSeries(Price,index-279,O,L,H,C)
                +0.000566405474088*PriceSeries(Price,index-280,O,L,H,C)
                +0.000445331594041*PriceSeries(Price,index-281,O,L,H,C)
                +0.000317669705435*PriceSeries(Price,index-282,O,L,H,C)
                +0.0001861462503013*PriceSeries(Price,index-283,O,L,H,C)
                +0.0000535104134367*PriceSeries(Price,index-284,O,L,H,C)
                -0.0000775228362084*PriceSeries(Price,index-285,O,L,H,C)
                -0.0002043258785399*PriceSeries(Price,index-286,O,L,H,C)
                -0.000324410012709*PriceSeries(Price,index-287,O,L,H,C)
                -0.000435475080136*PriceSeries(Price,index-288,O,L,H,C)
                -0.000535453366680*PriceSeries(Price,index-289,O,L,H,C)
                -0.000622540901930*PriceSeries(Price,index-290,O,L,H,C)
                -0.000695237727729*PriceSeries(Price,index-291,O,L,H,C)
                -0.000752363979345*PriceSeries(Price,index-292,O,L,H,C)
                -0.000793083073747*PriceSeries(Price,index-293,O,L,H,C)
                -0.000816907888817*PriceSeries(Price,index-294,O,L,H,C)
                -0.000823705394503*PriceSeries(Price,index-295,O,L,H,C)
                -0.000813692523581*PriceSeries(Price,index-296,O,L,H,C)
                -0.000787422695543*PriceSeries(Price,index-297,O,L,H,C)
                -0.000745766690919*PriceSeries(Price,index-298,O,L,H,C)
                -0.000689892067947*PriceSeries(Price,index-299,O,L,H,C)
                -0.000621230495727*PriceSeries(Price,index-300,O,L,H,C)
                -0.000541441084987*PriceSeries(Price,index-301,O,L,H,C)
                -0.000452377239571*PriceSeries(Price,index-302,O,L,H,C)
                -0.000356039631754*PriceSeries(Price,index-303,O,L,H,C)
                -0.0002545345490136*PriceSeries(Price,index-304,O,L,H,C)
                -0.0001500291685659*PriceSeries(Price,index-305,O,L,H,C)
                -0.0000447031175237*PriceSeries(Price,index-306,O,L,H,C)
                +0.0000592890132543*PriceSeries(Price,index-307,O,L,H,C)
                +0.0001598709694807*PriceSeries(Price,index-308,O,L,H,C)
                +0.0002550770282077*PriceSeries(Price,index-309,O,L,H,C)
                +0.000343095114855*PriceSeries(Price,index-310,O,L,H,C)
                +0.000422294161797*PriceSeries(Price,index-311,O,L,H,C)
                +0.000491264774819*PriceSeries(Price,index-312,O,L,H,C)
                +0.000548826205323*PriceSeries(Price,index-313,O,L,H,C)
                +0.000594063756996*PriceSeries(Price,index-314,O,L,H,C)
                +0.000626325237731*PriceSeries(Price,index-315,O,L,H,C)
                +0.000645243111776*PriceSeries(Price,index-316,O,L,H,C)
                +0.000650723456161*PriceSeries(Price,index-317,O,L,H,C)
                +0.000642949631204*PriceSeries(Price,index-318,O,L,H,C)
                +0.000622368007877*PriceSeries(Price,index-319,O,L,H,C)
                +0.000589678882089*PriceSeries(Price,index-320,O,L,H,C)
                +0.000545806724453*PriceSeries(Price,index-321,O,L,H,C)
                +0.000491887711449*PriceSeries(Price,index-322,O,L,H,C)
                +0.000429234847809*PriceSeries(Price,index-323,O,L,H,C)
                +0.000359308254569*PriceSeries(Price,index-324,O,L,H,C)
                +0.0002836831781396*PriceSeries(Price,index-325,O,L,H,C)
                +0.0002040160858467*PriceSeries(Price,index-326,O,L,H,C)
                +0.0001220066857192*PriceSeries(Price,index-327,O,L,H,C)
                +0.0000393678676574*PriceSeries(Price,index-328,O,L,H,C)
                -0.0000422205095391*PriceSeries(Price,index-329,O,L,H,C)
                -0.0001211288105400*PriceSeries(Price,index-330,O,L,H,C)
                -0.0001958262567738*PriceSeries(Price,index-331,O,L,H,C)
                -0.0002648973129897*PriceSeries(Price,index-332,O,L,H,C)
                -0.000327077579703*PriceSeries(Price,index-333,O,L,H,C)
                -0.000381262036910*PriceSeries(Price,index-334,O,L,H,C)
                -0.000426545240793*PriceSeries(Price,index-335,O,L,H,C)
                -0.000462210141600*PriceSeries(Price,index-336,O,L,H,C)
                -0.000487763259074*PriceSeries(Price,index-337,O,L,H,C)
                -0.000502915448538*PriceSeries(Price,index-338,O,L,H,C)
                -0.000507604495423*PriceSeries(Price,index-339,O,L,H,C)
                -0.000501975374795*PriceSeries(Price,index-340,O,L,H,C)
                -0.000486381462443*PriceSeries(Price,index-341,O,L,H,C)
                -0.000461365778386*PriceSeries(Price,index-342,O,L,H,C)
                -0.000427656901003*PriceSeries(Price,index-343,O,L,H,C)
                -0.000386133957651*PriceSeries(Price,index-344,O,L,H,C)
                -0.000337817846223*PriceSeries(Price,index-345,O,L,H,C)
                -0.0002838422092374*PriceSeries(Price,index-346,O,L,H,C)
                -0.0002254277740896*PriceSeries(Price,index-347,O,L,H,C)
                -0.0001638568913644*PriceSeries(Price,index-348,O,L,H,C)
                -0.0001004450594986*PriceSeries(Price,index-349,O,L,H,C)
                -0.0000365123894067*PriceSeries(Price,index-350,O,L,H,C)
                +0.00002663645397605*PriceSeries(Price,index-351,O,L,H,C)
                +0.0000877541821238*PriceSeries(Price,index-352,O,L,H,C)
                +0.0001456544033864*PriceSeries(Price,index-353,O,L,H,C)
                +0.0001992499214760*PriceSeries(Price,index-354,O,L,H,C)
                +0.0002475627897895*PriceSeries(Price,index-355,O,L,H,C)
                +0.0002897526777870*PriceSeries(Price,index-356,O,L,H,C)
                +0.000325111993387*PriceSeries(Price,index-357,O,L,H,C)
                +0.000353102167526*PriceSeries(Price,index-358,O,L,H,C)
                +0.000373332480281*PriceSeries(Price,index-359,O,L,H,C)
                +0.000385592537889*PriceSeries(Price,index-360,O,L,H,C)
                +0.000389824691896*PriceSeries(Price,index-361,O,L,H,C)
                +0.000386142953768*PriceSeries(Price,index-362,O,L,H,C)
                +0.000374816732930*PriceSeries(Price,index-363,O,L,H,C)
                +0.000356263389269*PriceSeries(Price,index-364,O,L,H,C)
                +0.000331030966564*PriceSeries(Price,index-365,O,L,H,C)
                +0.0002997957168652*PriceSeries(Price,index-366,O,L,H,C)
                +0.0002633331621639*PriceSeries(Price,index-367,O,L,H,C)
                +0.0002225042344805*PriceSeries(Price,index-368,O,L,H,C)
                +0.0001782406439472*PriceSeries(Price,index-369,O,L,H,C)
                +0.0001315145235791*PriceSeries(Price,index-370,O,L,H,C)
                +0.0000833297402575*PriceSeries(Price,index-371,O,L,H,C)
                +0.0000346867450509*PriceSeries(Price,index-372,O,L,H,C)
                -0.00001342828557864*PriceSeries(Price,index-373,O,L,H,C)
                -0.0000600586650557*PriceSeries(Price,index-374,O,L,H,C)
                -0.0001043107334988*PriceSeries(Price,index-375,O,L,H,C)
                -0.0001453568626293*PriceSeries(Price,index-376,O,L,H,C)
                -0.0001824552395480*PriceSeries(Price,index-377,O,L,H,C)
                -0.0002149618895189*PriceSeries(Price,index-378,O,L,H,C)
                -0.0002423483224716*PriceSeries(Price,index-379,O,L,H,C)
                -0.0002641918651860*PriceSeries(Price,index-380,O,L,H,C)
                -0.0002802038930329*PriceSeries(Price,index-381,O,L,H,C)
                -0.0002902061622440*PriceSeries(Price,index-382,O,L,H,C)
                -0.0002941615320774*PriceSeries(Price,index-383,O,L,H,C)
                -0.0002921456545638*PriceSeries(Price,index-384,O,L,H,C)
                -0.0002843514563174*PriceSeries(Price,index-385,O,L,H,C)
                -0.0002710894489131*PriceSeries(Price,index-386,O,L,H,C)
                -0.0002527674472957*PriceSeries(Price,index-387,O,L,H,C)
                -0.0002298821018615*PriceSeries(Price,index-388,O,L,H,C)
                -0.0002030106195836*PriceSeries(Price,index-389,O,L,H,C)
                -0.0001728000595274*PriceSeries(Price,index-390,O,L,H,C)
                -0.0001399367864400*PriceSeries(Price,index-391,O,L,H,C)
                -0.0001051552650775*PriceSeries(Price,index-392,O,L,H,C)
                -0.0000691903667430*PriceSeries(Price,index-393,O,L,H,C)
                -0.0000328030705286*PriceSeries(Price,index-394,O,L,H,C)
                +0.00000327526623499*PriceSeries(Price,index-395,O,L,H,C)
                +0.0000383330134127*PriceSeries(Price,index-396,O,L,H,C)
                +0.0000716944807846*PriceSeries(Price,index-397,O,L,H,C)
                +0.0001027384998172*PriceSeries(Price,index-398,O,L,H,C)
                +0.0001309139988795*PriceSeries(Price,index-399,O,L,H,C)
                +0.0001557332902827*PriceSeries(Price,index-400,O,L,H,C)
                +0.0001767913411095*PriceSeries(Price,index-401,O,L,H,C)
                +0.0001937718806825*PriceSeries(Price,index-402,O,L,H,C)
                +0.0002064421383331*PriceSeries(Price,index-403,O,L,H,C)
                +0.0002146743194906*PriceSeries(Price,index-404,O,L,H,C)
                +0.0002184144579591*PriceSeries(Price,index-405,O,L,H,C)
                +0.0002177150881112*PriceSeries(Price,index-406,O,L,H,C)
                +0.0002127148735465*PriceSeries(Price,index-407,O,L,H,C)
                +0.0002036182598683*PriceSeries(Price,index-408,O,L,H,C)
                +0.0001907232763816*PriceSeries(Price,index-409,O,L,H,C)
                +0.0001743878685490*PriceSeries(Price,index-410,O,L,H,C)
                +0.0001550335148409*PriceSeries(Price,index-411,O,L,H,C)
                +0.0001331194210833*PriceSeries(Price,index-412,O,L,H,C)
                +0.0001091612370896*PriceSeries(Price,index-413,O,L,H,C)
                +0.0000836767540364*PriceSeries(Price,index-414,O,L,H,C)
                +0.0000572334757107*PriceSeries(Price,index-415,O,L,H,C)
                +0.00003035882991658*PriceSeries(Price,index-416,O,L,H,C)
                +0.00000362240241828*PriceSeries(Price,index-417,O,L,H,C)
                -0.00002245393796179*PriceSeries(Price,index-418,O,L,H,C)
                -0.0000473683829450*PriceSeries(Price,index-419,O,L,H,C)
                -0.0000706562436212*PriceSeries(Price,index-420,O,L,H,C)
                -0.0000918835986631*PriceSeries(Price,index-421,O,L,H,C)
                -0.0001106866214789*PriceSeries(Price,index-422,O,L,H,C)
                -0.0001267412456367*PriceSeries(Price,index-423,O,L,H,C)
                -0.0001397916568547*PriceSeries(Price,index-424,O,L,H,C)
                -0.0001496459260728*PriceSeries(Price,index-425,O,L,H,C)
                -0.0001561684207217*PriceSeries(Price,index-426,O,L,H,C)
                -0.0001593176540291*PriceSeries(Price,index-427,O,L,H,C)
                -0.0001590783525690*PriceSeries(Price,index-428,O,L,H,C)
                -0.0001555153433121*PriceSeries(Price,index-429,O,L,H,C)
                -0.0001487719344112*PriceSeries(Price,index-430,O,L,H,C)
                -0.0001390138423910*PriceSeries(Price,index-431,O,L,H,C)
                -0.0001264816660505*PriceSeries(Price,index-432,O,L,H,C)
                -0.0001114472619032*PriceSeries(Price,index-433,O,L,H,C)
                -0.0000942341027305*PriceSeries(Price,index-434,O,L,H,C)
                -0.0000751674980236*PriceSeries(Price,index-435,O,L,H,C)
                -0.0000546319609859*PriceSeries(Price,index-436,O,L,H,C)
                -0.0000329777775590*PriceSeries(Price,index-437,O,L,H,C)
                -0.00001064639574074*PriceSeries(Price,index-438,O,L,H,C)
                +0.00001203007567341*PriceSeries(Price,index-439,O,L,H,C)
                +0.0000346405834813*PriceSeries(Price,index-440,O,L,H,C)
                +0.0000568245529685*PriceSeries(Price,index-441,O,L,H,C)
                +0.0000782375147133*PriceSeries(Price,index-442,O,L,H,C)
                +0.0000985692477136*PriceSeries(Price,index-443,O,L,H,C)
                +0.0001175079125688*PriceSeries(Price,index-444,O,L,H,C)
                +0.0001348087582413*PriceSeries(Price,index-445,O,L,H,C)
                +0.0001502511914516*PriceSeries(Price,index-446,O,L,H,C)
                +0.0001636642387044*PriceSeries(Price,index-447,O,L,H,C)
                +0.0001749278252606*PriceSeries(Price,index-448,O,L,H,C)
                +0.0001838948181943*PriceSeries(Price,index-449,O,L,H,C)
                +0.0001905832226184*PriceSeries(Price,index-450,O,L,H,C)
                +0.0001949473082035*PriceSeries(Price,index-451,O,L,H,C)
                +0.0001970088795250*PriceSeries(Price,index-452,O,L,H,C)
                +0.0001968768586395*PriceSeries(Price,index-453,O,L,H,C)
                +0.0001946407058112*PriceSeries(Price,index-454,O,L,H,C)
                +0.0001904337448674*PriceSeries(Price,index-455,O,L,H,C)
                +0.0001843999661410*PriceSeries(Price,index-456,O,L,H,C)
                +0.0001767461602593*PriceSeries(Price,index-457,O,L,H,C)
                +0.0001676578688916*PriceSeries(Price,index-458,O,L,H,C)
                +0.0001574060029231*PriceSeries(Price,index-459,O,L,H,C)
                +0.0001460775565641*PriceSeries(Price,index-460,O,L,H,C)
                +0.0001340888050855*PriceSeries(Price,index-461,O,L,H,C)
                +0.0001215042233181*PriceSeries(Price,index-462,O,L,H,C)
                +0.0001085845436687*PriceSeries(Price,index-463,O,L,H,C)
                +0.0000955771243901*PriceSeries(Price,index-464,O,L,H,C)
                +0.0000826982830815*PriceSeries(Price,index-465,O,L,H,C)
                +0.0000700979129007*PriceSeries(Price,index-466,O,L,H,C)
                +0.0000579497856751*PriceSeries(Price,index-467,O,L,H,C)
                +0.0000463957322436*PriceSeries(Price,index-468,O,L,H,C)
                +0.0000355867457577*PriceSeries(Price,index-469,O,L,H,C)
                +0.00002569901514668*PriceSeries(Price,index-470,O,L,H,C)
                +0.00001650132153351*PriceSeries(Price,index-471,O,L,H,C)
                +0.00000869631896990*PriceSeries(Price,index-472,O,L,H,C)
                +0.000001696013822860*PriceSeries(Price,index-473,O,L,H,C)
                -0.00000433525039696*PriceSeries(Price,index-474,O,L,H,C)
                -0.00000927513272360*PriceSeries(Price,index-475,O,L,H,C)
                -0.00001314978576029*PriceSeries(Price,index-476,O,L,H,C)
                -0.00001601298357276*PriceSeries(Price,index-477,O,L,H,C)
                -0.00001796087823890*PriceSeries(Price,index-478,O,L,H,C)
                -0.00001905099520419*PriceSeries(Price,index-479,O,L,H,C)
                -0.00001936460788571*PriceSeries(Price,index-480,O,L,H,C)
                -0.00001895217675961*PriceSeries(Price,index-481,O,L,H,C)
                -0.0001273865316678*PriceSeries(Price,index-482,O,L,H,C)
                );

      case N48:
         return(
                0.0857079166333*PriceSeries(Price,index,O,L,H,C)
                +0.0854275157934*PriceSeries(Price,index-1,O,L,H,C)
                +0.0845896275300*PriceSeries(Price,index-2,O,L,H,C)
                +0.0832041472995*PriceSeries(Price,index-3,O,L,H,C)
                +0.0812874122244*PriceSeries(Price,index-4,O,L,H,C)
                +0.0788619707219*PriceSeries(Price,index-5,O,L,H,C)
                +0.0759562648350*PriceSeries(Price,index-6,O,L,H,C)
                +0.0726042304250*PriceSeries(Price,index-7,O,L,H,C)
                +0.0688448207463*PriceSeries(Price,index-8,O,L,H,C)
                +0.0647214621748*PriceSeries(Price,index-9,O,L,H,C)
                +0.0602814486596*PriceSeries(Price,index-10,O,L,H,C)
                +0.0555752851299*PriceSeries(Price,index-11,O,L,H,C)
                +0.0506559899853*PriceSeries(Price,index-12,O,L,H,C)
                +0.0455783667154*PriceSeries(Price,index-13,O,L,H,C)
                +0.0403982564148*PriceSeries(Price,index-14,O,L,H,C)
                +0.0351717812864*PriceSeries(Price,index-15,O,L,H,C)
                +0.02995459214635*PriceSeries(Price,index-16,O,L,H,C)
                +0.02480112994294*PriceSeries(Price,index-17,O,L,H,C)
                +0.01976391218543*PriceSeries(Price,index-18,O,L,H,C)
                +0.01489285561226*PriceSeries(Price,index-19,O,L,H,C)
                +0.01023464399805*PriceSeries(Price,index-20,O,L,H,C)
                +0.00583215118242*PriceSeries(Price,index-21,O,L,H,C)
                +0.001723926009840*PriceSeries(Price,index-22,O,L,H,C)
                -0.002056252470374*PriceSeries(Price,index-23,O,L,H,C)
                -0.00547974379361*PriceSeries(Price,index-24,O,L,H,C)
                -0.00852333514584*PriceSeries(Price,index-25,O,L,H,C)
                -0.01116944606749*PriceSeries(Price,index-26,O,L,H,C)
                -0.01340624782523*PriceSeries(Price,index-27,O,L,H,C)
                -0.01522769568518*PriceSeries(Price,index-28,O,L,H,C)
                -0.01663347598901*PriceSeries(Price,index-29,O,L,H,C)
                -0.01762886970094*PriceSeries(Price,index-30,O,L,H,C)
                -0.01822453483776*PriceSeries(Price,index-31,O,L,H,C)
                -0.01843621386996*PriceSeries(Price,index-32,O,L,H,C)
                -0.01828437057405*PriceSeries(Price,index-33,O,L,H,C)
                -0.01779376402079*PriceSeries(Price,index-34,O,L,H,C)
                -0.01699296647110*PriceSeries(Price,index-35,O,L,H,C)
                -0.01591383409506*PriceSeries(Price,index-36,O,L,H,C)
                -0.01459094030199*PriceSeries(Price,index-37,O,L,H,C)
                -0.01306097957282*PriceSeries(Price,index-38,O,L,H,C)
                -0.01136215318968*PriceSeries(Price,index-39,O,L,H,C)
                -0.00953354601583*PriceSeries(Price,index-40,O,L,H,C)
                -0.00761450491422*PriceSeries(Price,index-41,O,L,H,C)
                -0.00564402824627*PriceSeries(Price,index-42,O,L,H,C)
                -0.00366017541313*PriceSeries(Price,index-43,O,L,H,C)
                -0.001699507018710*PriceSeries(Price,index-44,O,L,H,C)
                +0.0002034377565129*PriceSeries(Price,index-45,O,L,H,C)
                +0.002016617943378*PriceSeries(Price,index-46,O,L,H,C)
                +0.00371091533799*PriceSeries(Price,index-47,O,L,H,C)
                +0.00526050099785*PriceSeries(Price,index-48,O,L,H,C)
                +0.00664313862667*PriceSeries(Price,index-49,O,L,H,C)
                +0.00784042268146*PriceSeries(Price,index-50,O,L,H,C)
                +0.00883794688702*PriceSeries(Price,index-51,O,L,H,C)
                +0.00962540318029*PriceSeries(Price,index-52,O,L,H,C)
                +0.01019661079800*PriceSeries(Price,index-53,O,L,H,C)
                +0.01054947638973*PriceSeries(Price,index-54,O,L,H,C)
                +0.01068588788802*PriceSeries(Price,index-55,O,L,H,C)
                +0.01061154431504*PriceSeries(Price,index-56,O,L,H,C)
                +0.01033572766288*PriceSeries(Price,index-57,O,L,H,C)
                +0.00987102055392*PriceSeries(Price,index-58,O,L,H,C)
                +0.00923297603501*PriceSeries(Price,index-59,O,L,H,C)
                +0.00843974676386*PriceSeries(Price,index-60,O,L,H,C)
                +0.00751168014060*PriceSeries(Price,index-61,O,L,H,C)
                +0.00647088806390*PriceSeries(Price,index-62,O,L,H,C)
                +0.00534079766144*PriceSeries(Price,index-63,O,L,H,C)
                +0.00414569270347*PriceSeries(Price,index-64,O,L,H,C)
                +0.002910253266015*PriceSeries(Price,index-65,O,L,H,C)
                +0.001659100970502*PriceSeries(Price,index-66,O,L,H,C)
                +0.000416358591397*PriceSeries(Price,index-67,O,L,H,C)
                -0.000794769699954*PriceSeries(Price,index-68,O,L,H,C)
                -0.001952389377908*PriceSeries(Price,index-69,O,L,H,C)
                -0.003036273297710*PriceSeries(Price,index-70,O,L,H,C)
                -0.00402817993522*PriceSeries(Price,index-71,O,L,H,C)
                -0.00491212689785*PriceSeries(Price,index-72,O,L,H,C)
                -0.00567461732659*PriceSeries(Price,index-73,O,L,H,C)
                -0.00630481511256*PriceSeries(Price,index-74,O,L,H,C)
                -0.00679466818939*PriceSeries(Price,index-75,O,L,H,C)
                -0.00713897772882*PriceSeries(Price,index-76,O,L,H,C)
                -0.00733541416738*PriceSeries(Price,index-77,O,L,H,C)
                -0.00738448145712*PriceSeries(Price,index-78,O,L,H,C)
                -0.00728942991344*PriceSeries(Price,index-79,O,L,H,C)
                -0.00705612202382*PriceSeries(Price,index-80,O,L,H,C)
                -0.00669285370037*PriceSeries(Price,index-81,O,L,H,C)
                -0.00621013621096*PriceSeries(Price,index-82,O,L,H,C)
                -0.00562044288021*PriceSeries(Price,index-83,O,L,H,C)
                -0.00493792575716*PriceSeries(Price,index-84,O,L,H,C)
                -0.00417810953994*PriceSeries(Price,index-85,O,L,H,C)
                -0.00335756700244*PriceSeries(Price,index-86,O,L,H,C)
                -0.002493583532331*PriceSeries(Price,index-87,O,L,H,C)
                -0.001603816481991*PriceSeries(Price,index-88,O,L,H,C)
                -0.000705956172885*PriceSeries(Price,index-89,O,L,H,C)
                +0.0001826052211793*PriceSeries(Price,index-90,O,L,H,C)
                +0.001045092309430*PriceSeries(Price,index-91,O,L,H,C)
                +0.001865645057175*PriceSeries(Price,index-92,O,L,H,C)
                +0.002629593788922*PriceSeries(Price,index-93,O,L,H,C)
                +0.00332370548630*PriceSeries(Price,index-94,O,L,H,C)
                +0.00393639764836*PriceSeries(Price,index-95,O,L,H,C)
                +0.00445791666863*PriceSeries(Price,index-96,O,L,H,C)
                +0.00488047718427*PriceSeries(Price,index-97,O,L,H,C)
                +0.00519836263370*PriceSeries(Price,index-98,O,L,H,C)
                +0.00540798416421*PriceSeries(Price,index-99,O,L,H,C)
                +0.00550789842246*PriceSeries(Price,index-100,O,L,H,C)
                +0.00549878497346*PriceSeries(Price,index-101,O,L,H,C)
                +0.00538338424708*PriceSeries(Price,index-102,O,L,H,C)
                +0.00516639893287*PriceSeries(Price,index-103,O,L,H,C)
                +0.00485435966922*PriceSeries(Price,index-104,O,L,H,C)
                +0.00445546024507*PriceSeries(Price,index-105,O,L,H,C)
                +0.00397936505816*PriceSeries(Price,index-106,O,L,H,C)
                +0.00343699273210*PriceSeries(Price,index-107,O,L,H,C)
                +0.002840281270215*PriceSeries(Price,index-108,O,L,H,C)
                +0.002201938587775*PriceSeries(Price,index-109,O,L,H,C)
                +0.001535184884743*PriceSeries(Price,index-110,O,L,H,C)
                +0.000853489922491*PriceSeries(Price,index-111,O,L,H,C)
                +0.0001703114765228*PriceSeries(Price,index-112,O,L,H,C)
                -0.000501159897863*PriceSeries(Price,index-113,O,L,H,C)
                -0.001148246252720*PriceSeries(Price,index-114,O,L,H,C)
                -0.001759012175723*PriceSeries(Price,index-115,O,L,H,C)
                -0.002322476583285*PriceSeries(Price,index-116,O,L,H,C)
                -0.002828801099594*PriceSeries(Price,index-117,O,L,H,C)
                -0.00326945331585*PriceSeries(Price,index-118,O,L,H,C)
                -0.00363734233834*PriceSeries(Price,index-119,O,L,H,C)
                -0.00392692326421*PriceSeries(Price,index-120,O,L,H,C)
                -0.00413427082119*PriceSeries(Price,index-121,O,L,H,C)
                -0.00425712011966*PriceSeries(Price,index-122,O,L,H,C)
                -0.00429487580197*PriceSeries(Price,index-123,O,L,H,C)
                -0.00424858875032*PriceSeries(Price,index-124,O,L,H,C)
                -0.00412090165990*PriceSeries(Price,index-125,O,L,H,C)
                -0.00391596640895*PriceSeries(Price,index-126,O,L,H,C)
                -0.00363933340514*PriceSeries(Price,index-127,O,L,H,C)
                -0.00329781710370*PriceSeries(Price,index-128,O,L,H,C)
                -0.002899339620022*PriceSeries(Price,index-129,O,L,H,C)
                -0.002452756859136*PriceSeries(Price,index-130,O,L,H,C)
                -0.001967670410388*PriceSeries(Price,index-131,O,L,H,C)
                -0.001454227945817*PriceSeries(Price,index-132,O,L,H,C)
                -0.000922918311780*PriceSeries(Price,index-133,O,L,H,C)
                -0.000384363466376*PriceSeries(Price,index-134,O,L,H,C)
                +0.0001508876512869*PriceSeries(Price,index-135,O,L,H,C)
                +0.000672560107335*PriceSeries(Price,index-136,O,L,H,C)
                +0.001170844830330*PriceSeries(Price,index-137,O,L,H,C)
                +0.001636577030153*PriceSeries(Price,index-138,O,L,H,C)
                +0.002061400161731*PriceSeries(Price,index-139,O,L,H,C)
                +0.002437910303913*PriceSeries(Price,index-140,O,L,H,C)
                +0.002759779749599*PriceSeries(Price,index-141,O,L,H,C)
                +0.003021857516372*PriceSeries(Price,index-142,O,L,H,C)
                +0.00322024532195*PriceSeries(Price,index-143,O,L,H,C)
                +0.00335234876519*PriceSeries(Price,index-144,O,L,H,C)
                +0.00341690125998*PriceSeries(Price,index-145,O,L,H,C)
                +0.00341396320736*PriceSeries(Price,index-146,O,L,H,C)
                +0.00334489535194*PriceSeries(Price,index-147,O,L,H,C)
                +0.00321230752402*PriceSeries(Price,index-148,O,L,H,C)
                +0.003019984663105*PriceSeries(Price,index-149,O,L,H,C)
                +0.002772791195158*PriceSeries(Price,index-150,O,L,H,C)
                +0.002476557634244*PriceSeries(Price,index-151,O,L,H,C)
                +0.002137949442312*PriceSeries(Price,index-152,O,L,H,C)
                +0.001764322845956*PriceSeries(Price,index-153,O,L,H,C)
                +0.001363570365603*PriceSeries(Price,index-154,O,L,H,C)
                +0.000943958434631*PriceSeries(Price,index-155,O,L,H,C)
                +0.000513961463056*PriceSeries(Price,index-156,O,L,H,C)
                +0.0000820940919939*PriceSeries(Price,index-157,O,L,H,C)
                -0.000343252948222*PriceSeries(Price,index-158,O,L,H,C)
                -0.000753972375375*PriceSeries(Price,index-159,O,L,H,C)
                -0.001142391733792*PriceSeries(Price,index-160,O,L,H,C)
                -0.001501412783683*PriceSeries(Price,index-161,O,L,H,C)
                -0.001824637957465*PriceSeries(Price,index-162,O,L,H,C)
                -0.002106480202149*PriceSeries(Price,index-163,O,L,H,C)
                -0.002342256307803*PriceSeries(Price,index-164,O,L,H,C)
                -0.002528260209647*PriceSeries(Price,index-165,O,L,H,C)
                -0.002661816062319*PriceSeries(Price,index-166,O,L,H,C)
                -0.002741311412618*PriceSeries(Price,index-167,O,L,H,C)
                -0.002766208225661*PriceSeries(Price,index-168,O,L,H,C)
                -0.002737033777876*PriceSeries(Price,index-169,O,L,H,C)
                -0.002655350367421*PriceSeries(Price,index-170,O,L,H,C)
                -0.002523706556079*PriceSeries(Price,index-171,O,L,H,C)
                -0.002345570121496*PriceSeries(Price,index-172,O,L,H,C)
                -0.002125243527234*PriceSeries(Price,index-173,O,L,H,C)
                -0.001867766101235*PriceSeries(Price,index-174,O,L,H,C)
                -0.001578802850968*PriceSeries(Price,index-175,O,L,H,C)
                -0.001264523930554*PriceSeries(Price,index-176,O,L,H,C)
                -0.000931475905042*PriceSeries(Price,index-177,O,L,H,C)
                -0.000586448392956*PriceSeries(Price,index-178,O,L,H,C)
                -0.0002363391773427*PriceSeries(Price,index-179,O,L,H,C)
                +0.0001119818545080*PriceSeries(Price,index-180,O,L,H,C)
                +0.000451804560526*PriceSeries(Price,index-181,O,L,H,C)
                +0.000776705493496*PriceSeries(Price,index-182,O,L,H,C)
                +0.001080666584585*PriceSeries(Price,index-183,O,L,H,C)
                +0.001358184115436*PriceSeries(Price,index-184,O,L,H,C)
                +0.001604366372700*PriceSeries(Price,index-185,O,L,H,C)
                +0.001815016237650*PriceSeries(Price,index-186,O,L,H,C)
                +0.001986700352075*PriceSeries(Price,index-187,O,L,H,C)
                +0.002116801503293*PriceSeries(Price,index-188,O,L,H,C)
                +0.002203554410342*PriceSeries(Price,index-189,O,L,H,C)
                +0.002246064387885*PriceSeries(Price,index-190,O,L,H,C)
                +0.002244308497608*PriceSeries(Price,index-191,O,L,H,C)
                +0.002199121209534*PriceSeries(Price,index-192,O,L,H,C)
                +0.002112162027690*PriceSeries(Price,index-193,O,L,H,C)
                +0.001985868679886*PriceSeries(Price,index-194,O,L,H,C)
                +0.001823396030076*PriceSeries(Price,index-195,O,L,H,C)
                +0.001628541934826*PriceSeries(Price,index-196,O,L,H,C)
                +0.001405662487332*PriceSeries(Price,index-197,O,L,H,C)
                +0.001159576921986*PriceSeries(Price,index-198,O,L,H,C)
                +0.000895466979799*PriceSeries(Price,index-199,O,L,H,C)
                +0.000618769750296*PriceSeries(Price,index-200,O,L,H,C)
                +0.000335067578488*PriceSeries(Price,index-201,O,L,H,C)
                +0.0000499777742580*PriceSeries(Price,index-202,O,L,H,C)
                -0.0002309570043982*PriceSeries(Price,index-203,O,L,H,C)
                -0.000502374006586*PriceSeries(Price,index-204,O,L,H,C)
                -0.000759191847588*PriceSeries(Price,index-205,O,L,H,C)
                -0.000996703272357*PriceSeries(Price,index-206,O,L,H,C)
                -0.001210659357671*PriceSeries(Price,index-207,O,L,H,C)
                -0.001397344079089*PriceSeries(Price,index-208,O,L,H,C)
                -0.001553636111112*PriceSeries(Price,index-209,O,L,H,C)
                -0.001677058909928*PriceSeries(Price,index-210,O,L,H,C)
                -0.001765816178019*PriceSeries(Price,index-211,O,L,H,C)
                -0.001818815073226*PriceSeries(Price,index-212,O,L,H,C)
                -0.001835674803760*PriceSeries(Price,index-213,O,L,H,C)
                -0.001816720478238*PriceSeries(Price,index-214,O,L,H,C)
                -0.001762964751624*PriceSeries(Price,index-215,O,L,H,C)
                -0.001676075298217*PriceSeries(Price,index-216,O,L,H,C)
                -0.001558331259646*PriceSeries(Price,index-217,O,L,H,C)
                -0.001412567409090*PriceSeries(Price,index-218,O,L,H,C)
                -0.001242109386869*PriceSeries(Price,index-219,O,L,H,C)
                -0.001050701146337*PriceSeries(Price,index-220,O,L,H,C)
                -0.000842423912546*PriceSeries(Price,index-221,O,L,H,C)
                -0.000621611613979*PriceSeries(Price,index-222,O,L,H,C)
                -0.000392761999546*PriceSeries(Price,index-223,O,L,H,C)
                -0.0001604471932815*PriceSeries(Price,index-224,O,L,H,C)
                +0.0000707763701839*PriceSeries(Price,index-225,O,L,H,C)
                +0.0002964564523255*PriceSeries(Price,index-226,O,L,H,C)
                +0.000512328289282*PriceSeries(Price,index-227,O,L,H,C)
                +0.000714394689431*PriceSeries(Price,index-228,O,L,H,C)
                +0.000898998242381*PriceSeries(Price,index-229,O,L,H,C)
                +0.001062886200447*PriceSeries(Price,index-230,O,L,H,C)
                +0.001203265766885*PriceSeries(Price,index-231,O,L,H,C)
                +0.001317849394536*PriceSeries(Price,index-232,O,L,H,C)
                +0.001404891039144*PriceSeries(Price,index-233,O,L,H,C)
                +0.001463209041791*PriceSeries(Price,index-234,O,L,H,C)
                +0.001492199170414*PriceSeries(Price,index-235,O,L,H,C)
                +0.001491835656795*PriceSeries(Price,index-236,O,L,H,C)
                +0.001462661149200*PriceSeries(Price,index-237,O,L,H,C)
                +0.001405766025970*PriceSeries(Price,index-238,O,L,H,C)
                +0.001322756290861*PriceSeries(Price,index-239,O,L,H,C)
                +0.001215714343000*PriceSeries(Price,index-240,O,L,H,C)
                +0.001087149190863*PriceSeries(Price,index-241,O,L,H,C)
                +0.000939939910325*PriceSeries(Price,index-242,O,L,H,C)
                +0.000777273244596*PriceSeries(Price,index-243,O,L,H,C)
                +0.000602576050399*PriceSeries(Price,index-244,O,L,H,C)
                +0.000419445424445*PriceSeries(Price,index-245,O,L,H,C)
                +0.0002315746839731*PriceSeries(Price,index-246,O,L,H,C)
                +0.0000426810389813*PriceSeries(Price,index-247,O,L,H,C)
                -0.0001435669257992*PriceSeries(Price,index-248,O,L,H,C)
                -0.000323619956107*PriceSeries(Price,index-249,O,L,H,C)
                -0.000494114230864*PriceSeries(Price,index-250,O,L,H,C)
                -0.000651933602175*PriceSeries(Price,index-251,O,L,H,C)
                -0.000794264063932*PriceSeries(Price,index-252,O,L,H,C)
                -0.000918643757580*PriceSeries(Price,index-253,O,L,H,C)
                -0.001023003883007*PriceSeries(Price,index-254,O,L,H,C)
                -0.001105700781153*PriceSeries(Price,index-255,O,L,H,C)
                -0.001165540513942*PriceSeries(Price,index-256,O,L,H,C)
                -0.001201792895624*PriceSeries(Price,index-257,O,L,H,C)
                -0.001214197868474*PriceSeries(Price,index-258,O,L,H,C)
                -0.001202960594636*PriceSeries(Price,index-259,O,L,H,C)
                -0.001168739362588*PriceSeries(Price,index-260,O,L,H,C)
                -0.001112625039778*PriceSeries(Price,index-261,O,L,H,C)
                -0.001036110690601*PriceSeries(Price,index-262,O,L,H,C)
                -0.000941055785779*PriceSeries(Price,index-263,O,L,H,C)
                -0.000829642516900*PriceSeries(Price,index-264,O,L,H,C)
                -0.000704328560392*PriceSeries(Price,index-265,O,L,H,C)
                -0.000567793726597*PriceSeries(Price,index-266,O,L,H,C)
                -0.000422883508672*PriceSeries(Price,index-267,O,L,H,C)
                -0.0002725521695018*PriceSeries(Price,index-268,O,L,H,C)
                -0.0001198022710696*PriceSeries(Price,index-269,O,L,H,C)
                +0.0000323737478303*PriceSeries(Price,index-270,O,L,H,C)
                +0.0001810520046362*PriceSeries(Price,index-271,O,L,H,C)
                +0.000323431631652*PriceSeries(Price,index-272,O,L,H,C)
                +0.000456886366120*PriceSeries(Price,index-273,O,L,H,C)
                +0.000579013407109*PriceSeries(Price,index-274,O,L,H,C)
                +0.000687674136953*PriceSeries(Price,index-275,O,L,H,C)
                +0.000781031241521*PriceSeries(Price,index-276,O,L,H,C)
                +0.000857577905970*PriceSeries(Price,index-277,O,L,H,C)
                +0.000916161019639*PriceSeries(Price,index-278,O,L,H,C)
                +0.000955996635544*PriceSeries(Price,index-279,O,L,H,C)
                +0.000976676901263*PriceSeries(Price,index-280,O,L,H,C)
                +0.000978172627635*PriceSeries(Price,index-281,O,L,H,C)
                +0.000960825360833*PriceSeries(Price,index-282,O,L,H,C)
                +0.000925333788744*PriceSeries(Price,index-283,O,L,H,C)
                +0.000872732952560*PriceSeries(Price,index-284,O,L,H,C)
                +0.000804367626266*PriceSeries(Price,index-285,O,L,H,C)
                +0.000721861267525*PriceSeries(Price,index-286,O,L,H,C)
                +0.000627077400371*PriceSeries(Price,index-287,O,L,H,C)
                +0.000522080569865*PriceSeries(Price,index-288,O,L,H,C)
                +0.000409092026354*PriceSeries(Price,index-289,O,L,H,C)
                +0.0002904434168425*PriceSeries(Price,index-290,O,L,H,C)
                +0.0001685297454601*PriceSeries(Price,index-291,O,L,H,C)
                +0.0000457612011851*PriceSeries(Price,index-292,O,L,H,C)
                -0.0000754818819056*PriceSeries(Price,index-293,O,L,H,C)
                -0.0001928963966812*PriceSeries(Price,index-294,O,L,H,C)
                -0.0003042987884239*PriceSeries(Price,index-295,O,L,H,C)
                -0.000407664509578*PriceSeries(Price,index-296,O,L,H,C)
                -0.000501164591763*PriceSeries(Price,index-297,O,L,H,C)
                -0.000583196227186*PriceSeries(Price,index-298,O,L,H,C)
                -0.000652410513344*PriceSeries(Price,index-299,O,L,H,C)
                -0.000707731349856*PriceSeries(Price,index-300,O,L,H,C)
                -0.000748372071120*PriceSeries(Price,index-301,O,L,H,C)
                -0.000773845389997*PriceSeries(Price,index-302,O,L,H,C)
                -0.000783965614778*PriceSeries(Price,index-303,O,L,H,C)
                -0.000778846952388*PriceSeries(Price,index-304,O,L,H,C)
                -0.000758893882867*PriceSeries(Price,index-305,O,L,H,C)
                -0.000724789318850*PriceSeries(Price,index-306,O,L,H,C)
                -0.000677474329925*PriceSeries(Price,index-307,O,L,H,C)
                -0.000618124719642*PriceSeries(Price,index-308,O,L,H,C)
                -0.000548125117206*PriceSeries(Price,index-309,O,L,H,C)
                -0.000469036443586*PriceSeries(Price,index-310,O,L,H,C)
                -0.000382563247679*PriceSeries(Price,index-311,O,L,H,C)
                -0.0002905163935274*PriceSeries(Price,index-312,O,L,H,C)
                -0.0001947777128846*PriceSeries(Price,index-313,O,L,H,C)
                -0.0000972620070985*PriceSeries(Price,index-314,O,L,H,C)
                +0.000000122310711450*PriceSeries(Price,index-315,O,L,H,C)
                +0.0000955080197844*PriceSeries(Price,index-316,O,L,H,C)
                +0.0001871057911534*PriceSeries(Price,index-317,O,L,H,C)
                +0.0002732358509343*PriceSeries(Price,index-318,O,L,H,C)
                +0.000352359284663*PriceSeries(Price,index-319,O,L,H,C)
                +0.000423103925950*PriceSeries(Price,index-320,O,L,H,C)
                +0.000484285924277*PriceSeries(Price,index-321,O,L,H,C)
                +0.000534931390805*PriceSeries(Price,index-322,O,L,H,C)
                +0.000574288925399*PriceSeries(Price,index-323,O,L,H,C)
                +0.000601840376482*PriceSeries(Price,index-324,O,L,H,C)
                +0.000617304779203*PriceSeries(Price,index-325,O,L,H,C)
                +0.000620639333998*PriceSeries(Price,index-326,O,L,H,C)
                +0.000612036181091*PriceSeries(Price,index-327,O,L,H,C)
                +0.000591911019260*PriceSeries(Price,index-328,O,L,H,C)
                +0.000560893110507*PriceSeries(Price,index-329,O,L,H,C)
                +0.000519807299467*PriceSeries(Price,index-330,O,L,H,C)
                +0.000469654185393*PriceSeries(Price,index-331,O,L,H,C)
                +0.000411586614984*PriceSeries(Price,index-332,O,L,H,C)
                +0.000346883746498*PriceSeries(Price,index-333,O,L,H,C)
                +0.0002769265933261*PriceSeries(Price,index-334,O,L,H,C)
                +0.0002031659951093*PriceSeries(Price,index-335,O,L,H,C)
                +0.0001270948240573*PriceSeries(Price,index-336,O,L,H,C)
                +0.0000502179942104*PriceSeries(Price,index-337,O,L,H,C)
                -0.00002597711899755*PriceSeries(Price,index-338,O,L,H,C)
                -0.0001000481917022*PriceSeries(Price,index-339,O,L,H,C)
                -0.0001706266402352*PriceSeries(Price,index-340,O,L,H,C)
                -0.0002364384929598*PriceSeries(Price,index-341,O,L,H,C)
                -0.0002963294922857*PriceSeries(Price,index-342,O,L,H,C)
                -0.000349284738730*PriceSeries(Price,index-343,O,L,H,C)
                -0.000394444265882*PriceSeries(Price,index-344,O,L,H,C)
                -0.000431117065677*PriceSeries(Price,index-345,O,L,H,C)
                -0.000458788618925*PriceSeries(Price,index-346,O,L,H,C)
                -0.000477130310852*PriceSeries(Price,index-347,O,L,H,C)
                -0.000485998401394*PriceSeries(Price,index-348,O,L,H,C)
                -0.000485433507886*PriceSeries(Price,index-349,O,L,H,C)
                -0.000475657287989*PriceSeries(Price,index-350,O,L,H,C)
                -0.000457062002189*PriceSeries(Price,index-351,O,L,H,C)
                -0.000430200637023*PriceSeries(Price,index-352,O,L,H,C)
                -0.000395769627309*PriceSeries(Price,index-353,O,L,H,C)
                -0.000354596261873*PriceSeries(Price,index-354,O,L,H,C)
                -0.0003076187314446*PriceSeries(Price,index-355,O,L,H,C)
                -0.0002558639563284*PriceSeries(Price,index-356,O,L,H,C)
                -0.0002004285710822*PriceSeries(Price,index-357,O,L,H,C)
                -0.0001424536490779*PriceSeries(Price,index-358,O,L,H,C)
                -0.0000831041579550*PriceSeries(Price,index-359,O,L,H,C)
                -0.00002354274400530*PriceSeries(Price,index-360,O,L,H,C)
                +0.0000350899203568*PriceSeries(Price,index-361,O,L,H,C)
                +0.0000916949880042*PriceSeries(Price,index-362,O,L,H,C)
                +0.0001452396031624*PriceSeries(Price,index-363,O,L,H,C)
                +0.0001947719879067*PriceSeries(Price,index-364,O,L,H,C)
                +0.0002394400950544*PriceSeries(Price,index-365,O,L,H,C)
                +0.0002785024459670*PriceSeries(Price,index-366,O,L,H,C)
                +0.0003113420758463*PriceSeries(Price,index-367,O,L,H,C)
                +0.000337476056844*PriceSeries(Price,index-368,O,L,H,C)
                +0.000356557490247*PriceSeries(Price,index-369,O,L,H,C)
                +0.000368384054303*PriceSeries(Price,index-370,O,L,H,C)
                +0.000372895523149*PriceSeries(Price,index-371,O,L,H,C)
                +0.000370173192378*PriceSeries(Price,index-372,O,L,H,C)
                +0.000360432358354*PriceSeries(Price,index-373,O,L,H,C)
                +0.000344015296757*PriceSeries(Price,index-374,O,L,H,C)
                +0.000321386513617*PriceSeries(Price,index-375,O,L,H,C)
                +0.0002931152526521*PriceSeries(Price,index-376,O,L,H,C)
                +0.0002598663460833*PriceSeries(Price,index-377,O,L,H,C)
                +0.0002223832624902*PriceSeries(Price,index-378,O,L,H,C)
                +0.0001814728019811*PriceSeries(Price,index-379,O,L,H,C)
                +0.0001379876388053*PriceSeries(Price,index-380,O,L,H,C)
                +0.0000928056151105*PriceSeries(Price,index-381,O,L,H,C)
                +0.0000468198146134*PriceSeries(Price,index-382,O,L,H,C)
                +0.000000915138400135*PriceSeries(Price,index-383,O,L,H,C)
                -0.0000440467921386*PriceSeries(Price,index-384,O,L,H,C)
                -0.0000872435371605*PriceSeries(Price,index-385,O,L,H,C)
                -0.0001279064992654*PriceSeries(Price,index-386,O,L,H,C)
                -0.0001653307976397*PriceSeries(Price,index-387,O,L,H,C)
                -0.0001988940538780*PriceSeries(Price,index-388,O,L,H,C)
                -0.0002280586351726*PriceSeries(Price,index-389,O,L,H,C)
                -0.0002523836962807*PriceSeries(Price,index-390,O,L,H,C)
                -0.0002715328777800*PriceSeries(Price,index-391,O,L,H,C)
                -0.0002852759783912*PriceSeries(Price,index-392,O,L,H,C)
                -0.0002934927185322*PriceSeries(Price,index-393,O,L,H,C)
                -0.0002961651030831*PriceSeries(Price,index-394,O,L,H,C)
                -0.0002933846172399*PriceSeries(Price,index-395,O,L,H,C)
                -0.0002853432199949*PriceSeries(Price,index-396,O,L,H,C)
                -0.0002723263840292*PriceSeries(Price,index-397,O,L,H,C)
                -0.0002547096708004*PriceSeries(Price,index-398,O,L,H,C)
                -0.0002329451072777*PriceSeries(Price,index-399,O,L,H,C)
                -0.0002075563929615*PriceSeries(Price,index-400,O,L,H,C)
                -0.0001791180674809*PriceSeries(Price,index-401,O,L,H,C)
                -0.0001482517577925*PriceSeries(Price,index-402,O,L,H,C)
                -0.0001156141734484*PriceSeries(Price,index-403,O,L,H,C)
                -0.0000818769672104*PriceSeries(Price,index-404,O,L,H,C)
                -0.0000477196339248*PriceSeries(Price,index-405,O,L,H,C)
                -0.00001381060066328*PriceSeries(Price,index-406,O,L,H,C)
                +0.00001919548009639*PriceSeries(Price,index-407,O,L,H,C)
                +0.0000506778704440*PriceSeries(Price,index-408,O,L,H,C)
                +0.0000800584492687*PriceSeries(Price,index-409,O,L,H,C)
                +0.0001068040336938*PriceSeries(Price,index-410,O,L,H,C)
                +0.0001304468167667*PriceSeries(Price,index-411,O,L,H,C)
                +0.0001505844353134*PriceSeries(Price,index-412,O,L,H,C)
                +0.0001668926150285*PriceSeries(Price,index-413,O,L,H,C)
                +0.0001791181355979*PriceSeries(Price,index-414,O,L,H,C)
                +0.0001870848167601*PriceSeries(Price,index-415,O,L,H,C)
                +0.0001907030204796*PriceSeries(Price,index-416,O,L,H,C)
                +0.0001899550021767*PriceSeries(Price,index-417,O,L,H,C)
                +0.0001849054051979*PriceSeries(Price,index-418,O,L,H,C)
                +0.0001756904426101*PriceSeries(Price,index-419,O,L,H,C)
                +0.0001625209945995*PriceSeries(Price,index-420,O,L,H,C)
                +0.0001456711715549*PriceSeries(Price,index-421,O,L,H,C)
                +0.0001254663220001*PriceSeries(Price,index-422,O,L,H,C)
                +0.0001022959256602*PriceSeries(Price,index-423,O,L,H,C)
                +0.0000765869161187*PriceSeries(Price,index-424,O,L,H,C)
                +0.0000488024304524*PriceSeries(Price,index-425,O,L,H,C)
                +0.00001942536788513*PriceSeries(Price,index-426,O,L,H,C)
                -0.00001104594807526*PriceSeries(Price,index-427,O,L,H,C)
                -0.0000421010138682*PriceSeries(Price,index-428,O,L,H,C)
                -0.0000732455220635*PriceSeries(Price,index-429,O,L,H,C)
                -0.0001039826759940*PriceSeries(Price,index-430,O,L,H,C)
                -0.0001338377403416*PriceSeries(Price,index-431,O,L,H,C)
                -0.0001623647664888*PriceSeries(Price,index-432,O,L,H,C)
                -0.0001891552383327*PriceSeries(Price,index-433,O,L,H,C)
                -0.0002138461756585*PriceSeries(Price,index-434,O,L,H,C)
                -0.0002361010722059*PriceSeries(Price,index-435,O,L,H,C)
                -0.0002556487331882*PriceSeries(Price,index-436,O,L,H,C)
                -0.0002722624298207*PriceSeries(Price,index-437,O,L,H,C)
                -0.0002857670198958*PriceSeries(Price,index-438,O,L,H,C)
                -0.0002960466406008*PriceSeries(Price,index-439,O,L,H,C)
                -0.0003030354296228*PriceSeries(Price,index-440,O,L,H,C)
                -0.0003067365898131*PriceSeries(Price,index-441,O,L,H,C)
                -0.0003071783625903*PriceSeries(Price,index-442,O,L,H,C)
                -0.0003044551634703*PriceSeries(Price,index-443,O,L,H,C)
                -0.0002987176515600*PriceSeries(Price,index-444,O,L,H,C)
                -0.0002901504916031*PriceSeries(Price,index-445,O,L,H,C)
                -0.0002789818659712*PriceSeries(Price,index-446,O,L,H,C)
                -0.0002654486586463*PriceSeries(Price,index-447,O,L,H,C)
                -0.0002498396308944*PriceSeries(Price,index-448,O,L,H,C)
                -0.0002324352830962*PriceSeries(Price,index-449,O,L,H,C)
                -0.0002135318983023*PriceSeries(Price,index-450,O,L,H,C)
                -0.0001934645100042*PriceSeries(Price,index-451,O,L,H,C)
                -0.0001725534503455*PriceSeries(Price,index-452,O,L,H,C)
                -0.0001511324462286*PriceSeries(Price,index-453,O,L,H,C)
                -0.0001294870352812*PriceSeries(Price,index-454,O,L,H,C)
                -0.0001079342631952*PriceSeries(Price,index-455,O,L,H,C)
                -0.0000867712440244*PriceSeries(Price,index-456,O,L,H,C)
                -0.0000662359079124*PriceSeries(Price,index-457,O,L,H,C)
                -0.0000465849285898*PriceSeries(Price,index-458,O,L,H,C)
                -0.00002800666846769*PriceSeries(Price,index-459,O,L,H,C)
                -0.00001069529870164*PriceSeries(Price,index-460,O,L,H,C)
                +0.00000524276204490*PriceSeries(Price,index-461,O,L,H,C)
                +0.00001968544216646*PriceSeries(Price,index-462,O,L,H,C)
                +0.0000324682929462*PriceSeries(Price,index-463,O,L,H,C)
                +0.0000435717817691*PriceSeries(Price,index-464,O,L,H,C)
                +0.0000529513850205*PriceSeries(Price,index-465,O,L,H,C)
                +0.0000606652152408*PriceSeries(Price,index-466,O,L,H,C)
                +0.0000667094909635*PriceSeries(Price,index-467,O,L,H,C)
                +0.0000711553105889*PriceSeries(Price,index-468,O,L,H,C)
                +0.0000741563477178*PriceSeries(Price,index-469,O,L,H,C)
                +0.0000756146744642*PriceSeries(Price,index-470,O,L,H,C)
                +0.0000757246205836*PriceSeries(Price,index-471,O,L,H,C)
                +0.0000746190414729*PriceSeries(Price,index-472,O,L,H,C)
                +0.0000725767239519*PriceSeries(Price,index-473,O,L,H,C)
                +0.0000696537163846*PriceSeries(Price,index-474,O,L,H,C)
                +0.0000656417541866*PriceSeries(Price,index-475,O,L,H,C)
                +0.0000613475582762*PriceSeries(Price,index-476,O,L,H,C)
                +0.0000563781815306*PriceSeries(Price,index-477,O,L,H,C)
                +0.0000511231277541*PriceSeries(Price,index-478,O,L,H,C)
                +0.0000456484587369*PriceSeries(Price,index-479,O,L,H,C)
                +0.0000400885672669*PriceSeries(Price,index-480,O,L,H,C)
                +0.0001267291159714*PriceSeries(Price,index-481,O,L,H,C)
                );

      case N49:
         return(
                0.0838068075164*PriceSeries(Price,index,O,L,H,C)
                +0.0835447600630*PriceSeries(Price,index-1,O,L,H,C)
                +0.0827615769961*PriceSeries(Price,index-2,O,L,H,C)
                +0.0814660959047*PriceSeries(Price,index-3,O,L,H,C)
                +0.0796729138369*PriceSeries(Price,index-4,O,L,H,C)
                +0.0774021903839*PriceSeries(Price,index-5,O,L,H,C)
                +0.0746793763301*PriceSeries(Price,index-6,O,L,H,C)
                +0.0715348719777*PriceSeries(Price,index-7,O,L,H,C)
                +0.0680036192822*PriceSeries(Price,index-8,O,L,H,C)
                +0.0641246351633*PriceSeries(Price,index-9,O,L,H,C)
                +0.0599404912941*PriceSeries(Price,index-10,O,L,H,C)
                +0.0554967493640*PriceSeries(Price,index-11,O,L,H,C)
                +0.0508413589585*PriceSeries(Price,index-12,O,L,H,C)
                +0.0460240273988*PriceSeries(Price,index-13,O,L,H,C)
                +0.0410955709108*PriceSeries(Price,index-14,O,L,H,C)
                +0.0361072554094*PriceSeries(Price,index-15,O,L,H,C)
                +0.03111013787566*PriceSeries(Price,index-16,O,L,H,C)
                +0.02615441622536*PriceSeries(Price,index-17,O,L,H,C)
                +0.02128879821239*PriceSeries(Price,index-18,O,L,H,C)
                +0.01655989726685*PriceSeries(Price,index-19,O,L,H,C)
                +0.01201166403515*PriceSeries(Price,index-20,O,L,H,C)
                +0.00768486184649*PriceSeries(Price,index-21,O,L,H,C)
                +0.00361659204367*PriceSeries(Price,index-22,O,L,H,C)
                -0.0001601228938565*PriceSeries(Price,index-23,O,L,H,C)
                -0.00361669460372*PriceSeries(Price,index-24,O,L,H,C)
                -0.00672925686441*PriceSeries(Price,index-25,O,L,H,C)
                -0.00947888379283*PriceSeries(Price,index-26,O,L,H,C)
                -0.01185173569243*PriceSeries(Price,index-27,O,L,H,C)
                -0.01383913078037*PriceSeries(Price,index-28,O,L,H,C)
                -0.01543754406349*PriceSeries(Price,index-29,O,L,H,C)
                -0.01664853274941*PriceSeries(Price,index-30,O,L,H,C)
                -0.01747859186945*PriceSeries(Price,index-31,O,L,H,C)
                -0.01793894214682*PriceSeries(Price,index-32,O,L,H,C)
                -0.01804525481344*PriceSeries(Price,index-33,O,L,H,C)
                -0.01781731842305*PriceSeries(Price,index-34,O,L,H,C)
                -0.01727865282410*PriceSeries(Price,index-35,O,L,H,C)
                -0.01645607828577*PriceSeries(Price,index-36,O,L,H,C)
                -0.01537924518340*PriceSeries(Price,index-37,O,L,H,C)
                -0.01408013342310*PriceSeries(Price,index-38,O,L,H,C)
                -0.01259252868457*PriceSeries(Price,index-39,O,L,H,C)
                -0.01095148416595*PriceSeries(Price,index-40,O,L,H,C)
                -0.00919277640142*PriceSeries(Price,index-41,O,L,H,C)
                -0.00735236259266*PriceSeries(Price,index-42,O,L,H,C)
                -0.00546584909284*PriceSeries(Price,index-43,O,L,H,C)
                -0.00356797714956*PriceSeries(Price,index-44,O,L,H,C)
                -0.001692134898664*PriceSeries(Price,index-45,O,L,H,C)
                +0.0001300982750780*PriceSeries(Price,index-46,O,L,H,C)
                +0.001869368545133*PriceSeries(Price,index-47,O,L,H,C)
                +0.00349891961728*PriceSeries(Price,index-48,O,L,H,C)
                +0.00499491603018*PriceSeries(Price,index-49,O,L,H,C)
                +0.00633671223398*PriceSeries(Price,index-50,O,L,H,C)
                +0.00750706617803*PriceSeries(Price,index-51,O,L,H,C)
                +0.00849229388839*PriceSeries(Price,index-52,O,L,H,C)
                +0.00928236461454*PriceSeries(Price,index-53,O,L,H,C)
                +0.00987093641217*PriceSeries(Price,index-54,O,L,H,C)
                +0.01025533227607*PriceSeries(Price,index-55,O,L,H,C)
                +0.01043645963701*PriceSeries(Price,index-56,O,L,H,C)
                +0.01041867424794*PriceSeries(Price,index-57,O,L,H,C)
                +0.01020959365947*PriceSeries(Price,index-58,O,L,H,C)
                +0.00981986305815*PriceSeries(Price,index-59,O,L,H,C)
                +0.00926287882101*PriceSeries(Price,index-60,O,L,H,C)
                +0.00855447548782*PriceSeries(Price,index-61,O,L,H,C)
                +0.00771258125493*PriceSeries(Price,index-62,O,L,H,C)
                +0.00675684957552*PriceSeries(Price,index-63,O,L,H,C)
                +0.00570827184741*PriceSeries(Price,index-64,O,L,H,C)
                +0.00458877960672*PriceSeries(Price,index-65,O,L,H,C)
                +0.00342084171264*PriceSeries(Price,index-66,O,L,H,C)
                +0.002227063671824*PriceSeries(Price,index-67,O,L,H,C)
                +0.001029796176589*PriceSeries(Price,index-68,O,L,H,C)
                -0.0001492419638887*PriceSeries(Price,index-69,O,L,H,C)
                -0.001289319284917*PriceSeries(Price,index-70,O,L,H,C)
                -0.002371021684976*PriceSeries(Price,index-71,O,L,H,C)
                -0.00337655046845*PriceSeries(Price,index-72,O,L,H,C)
                -0.00428998530097*PriceSeries(Price,index-73,O,L,H,C)
                -0.00509750826099*PriceSeries(Price,index-74,O,L,H,C)
                -0.00578758547531*PriceSeries(Price,index-75,O,L,H,C)
                -0.00635110557647*PriceSeries(Price,index-76,O,L,H,C)
                -0.00678147218443*PriceSeries(Price,index-77,O,L,H,C)
                -0.00707465141740*PriceSeries(Price,index-78,O,L,H,C)
                -0.00722917321857*PriceSeries(Price,index-79,O,L,H,C)
                -0.00724608862327*PriceSeries(Price,index-80,O,L,H,C)
                -0.00712888464836*PriceSeries(Price,index-81,O,L,H,C)
                -0.00688335831733*PriceSeries(Price,index-82,O,L,H,C)
                -0.00651745437632*PriceSeries(Price,index-83,O,L,H,C)
                -0.00604106877385*PriceSeries(Price,index-84,O,L,H,C)
                -0.00546582359178*PriceSeries(Price,index-85,O,L,H,C)
                -0.00480481667861*PriceSeries(Price,index-86,O,L,H,C)
                -0.00407235173604*PriceSeries(Price,index-87,O,L,H,C)
                -0.00328365400412*PriceSeries(Price,index-88,O,L,H,C)
                -0.002454575745567*PriceSeries(Price,index-89,O,L,H,C)
                -0.001601298612811*PriceSeries(Price,index-90,O,L,H,C)
                -0.000740036514836*PriceSeries(Price,index-91,O,L,H,C)
                +0.0001132544629937*PriceSeries(Price,index-92,O,L,H,C)
                +0.000943155346632*PriceSeries(Price,index-93,O,L,H,C)
                +0.001735047447410*PriceSeries(Price,index-94,O,L,H,C)
                +0.002475354909827*PriceSeries(Price,index-95,O,L,H,C)
                +0.003151764018500*PriceSeries(Price,index-96,O,L,H,C)
                +0.00375341408029*PriceSeries(Price,index-97,O,L,H,C)
                +0.00427105894125*PriceSeries(Price,index-98,O,L,H,C)
                +0.00469719559072*PriceSeries(Price,index-99,O,L,H,C)
                +0.00502615916686*PriceSeries(Price,index-100,O,L,H,C)
                +0.00525418293910*PriceSeries(Price,index-101,O,L,H,C)
                +0.00537942262419*PriceSeries(Price,index-102,O,L,H,C)
                +0.00540194677330*PriceSeries(Price,index-103,O,L,H,C)
                +0.00532369212901*PriceSeries(Price,index-104,O,L,H,C)
                +0.00514838728448*PriceSeries(Price,index-105,O,L,H,C)
                +0.00488144536918*PriceSeries(Price,index-106,O,L,H,C)
                +0.00452982902403*PriceSeries(Price,index-107,O,L,H,C)
                +0.00410189051936*PriceSeries(Price,index-108,O,L,H,C)
                +0.00360718986416*PriceSeries(Price,index-109,O,L,H,C)
                +0.003056296032049*PriceSeries(Price,index-110,O,L,H,C)
                +0.002460573073755*PriceSeries(Price,index-111,O,L,H,C)
                +0.001831957198039*PriceSeries(Price,index-112,O,L,H,C)
                +0.001182727870649*PriceSeries(Price,index-113,O,L,H,C)
                +0.000525277602135*PriceSeries(Price,index-114,O,L,H,C)
                -0.0001281153606404*PriceSeries(Price,index-115,O,L,H,C)
                -0.000765508176439*PriceSeries(Price,index-116,O,L,H,C)
                -0.001375502972369*PriceSeries(Price,index-117,O,L,H,C)
                -0.001947443392168*PriceSeries(Price,index-118,O,L,H,C)
                -0.002471592872559*PriceSeries(Price,index-119,O,L,H,C)
                -0.002939292942642*PriceSeries(Price,index-120,O,L,H,C)
                -0.00334309894475*PriceSeries(Price,index-121,O,L,H,C)
                -0.00367689072697*PriceSeries(Price,index-122,O,L,H,C)
                -0.00393595765669*PriceSeries(Price,index-123,O,L,H,C)
                -0.00411705529870*PriceSeries(Price,index-124,O,L,H,C)
                -0.00421843550798*PriceSeries(Price,index-125,O,L,H,C)
                -0.00423984799749*PriceSeries(Price,index-126,O,L,H,C)
                -0.00418251491459*PriceSeries(Price,index-127,O,L,H,C)
                -0.00404907941437*PriceSeries(Price,index-128,O,L,H,C)
                -0.00384352887548*PriceSeries(Price,index-129,O,L,H,C)
                -0.00357109580996*PriceSeries(Price,index-130,O,L,H,C)
                -0.00323813708139*PriceSeries(Price,index-131,O,L,H,C)
                -0.002851996148069*PriceSeries(Price,index-132,O,L,H,C)
                -0.002420849158403*PriceSeries(Price,index-133,O,L,H,C)
                -0.001953538908512*PriceSeries(Price,index-134,O,L,H,C)
                -0.001459400271323*PriceSeries(Price,index-135,O,L,H,C)
                -0.000948079398913*PriceSeries(Price,index-136,O,L,H,C)
                -0.000429351474539*PriceSeries(Price,index-137,O,L,H,C)
                +0.0000870614011472*PriceSeries(Price,index-138,O,L,H,C)
                +0.000591666878254*PriceSeries(Price,index-139,O,L,H,C)
                +0.001075372273563*PriceSeries(Price,index-140,O,L,H,C)
                +0.001529643872672*PriceSeries(Price,index-141,O,L,H,C)
                +0.001946652379258*PriceSeries(Price,index-142,O,L,H,C)
                +0.002319403611639*PriceSeries(Price,index-143,O,L,H,C)
                +0.002641850733717*PriceSeries(Price,index-144,O,L,H,C)
                +0.002908987989778*PriceSeries(Price,index-145,O,L,H,C)
                +0.003116922600568*PriceSeries(Price,index-146,O,L,H,C)
                +0.00326292560713*PriceSeries(Price,index-147,O,L,H,C)
                +0.00334546047167*PriceSeries(Price,index-148,O,L,H,C)
                +0.00336418862118*PriceSeries(Price,index-149,O,L,H,C)
                +0.00331995396662*PriceSeries(Price,index-150,O,L,H,C)
                +0.00321474508998*PriceSeries(Price,index-151,O,L,H,C)
                +0.003051637947882*PriceSeries(Price,index-152,O,L,H,C)
                +0.002834718835309*PriceSeries(Price,index-153,O,L,H,C)
                +0.002568990912344*PriceSeries(Price,index-154,O,L,H,C)
                +0.002260265688288*PriceSeries(Price,index-155,O,L,H,C)
                +0.001915040712892*PriceSeries(Price,index-156,O,L,H,C)
                +0.001540367994923*PriceSeries(Price,index-157,O,L,H,C)
                +0.001143713627892*PriceSeries(Price,index-158,O,L,H,C)
                +0.000732813216331*PriceSeries(Price,index-159,O,L,H,C)
                +0.0003155242912068*PriceSeries(Price,index-160,O,L,H,C)
                -0.0001003203830664*PriceSeries(Price,index-161,O,L,H,C)
                -0.000507056344059*PriceSeries(Price,index-162,O,L,H,C)
                -0.000897326266073*PriceSeries(Price,index-163,O,L,H,C)
                -0.001264209285058*PriceSeries(Price,index-164,O,L,H,C)
                -0.001601341071411*PriceSeries(Price,index-165,O,L,H,C)
                -0.001903020842209*PriceSeries(Price,index-166,O,L,H,C)
                -0.002164304864865*PriceSeries(Price,index-167,O,L,H,C)
                -0.002381084006260*PriceSeries(Price,index-168,O,L,H,C)
                -0.002550144264863*PriceSeries(Price,index-169,O,L,H,C)
                -0.002669210737832*PriceSeries(Price,index-170,O,L,H,C)
                -0.002736972104836*PriceSeries(Price,index-171,O,L,H,C)
                -0.002753088215286*PriceSeries(Price,index-172,O,L,H,C)
                -0.002718178972289*PriceSeries(Price,index-173,O,L,H,C)
                -0.002633795996634*PriceSeries(Price,index-174,O,L,H,C)
                -0.002502377417597*PriceSeries(Price,index-175,O,L,H,C)
                -0.002327186881851*PriceSeries(Price,index-176,O,L,H,C)
                -0.002112239592619*PriceSeries(Price,index-177,O,L,H,C)
                -0.001862214264934*PriceSeries(Price,index-178,O,L,H,C)
                -0.001582355623059*PriceSeries(Price,index-179,O,L,H,C)
                -0.001278367454009*PriceSeries(Price,index-180,O,L,H,C)
                -0.000956299210466*PriceSeries(Price,index-181,O,L,H,C)
                -0.000622428347843*PriceSeries(Price,index-182,O,L,H,C)
                -0.0002831401179087*PriceSeries(Price,index-183,O,L,H,C)
                +0.0000551914820892*PriceSeries(Price,index-184,O,L,H,C)
                +0.000386322121069*PriceSeries(Price,index-185,O,L,H,C)
                +0.000704249663576*PriceSeries(Price,index-186,O,L,H,C)
                +0.001003320800972*PriceSeries(Price,index-187,O,L,H,C)
                +0.001278329469672*PriceSeries(Price,index-188,O,L,H,C)
                +0.001524605082672*PriceSeries(Price,index-189,O,L,H,C)
                +0.001738089978272*PriceSeries(Price,index-190,O,L,H,C)
                +0.001915403072410*PriceSeries(Price,index-191,O,L,H,C)
                +0.002053891421453*PriceSeries(Price,index-192,O,L,H,C)
                +0.002151665966775*PriceSeries(Price,index-193,O,L,H,C)
                +0.002207623196012*PriceSeries(Price,index-194,O,L,H,C)
                +0.002221452279793*PriceSeries(Price,index-195,O,L,H,C)
                +0.002193626826127*PriceSeries(Price,index-196,O,L,H,C)
                +0.002125382911356*PriceSeries(Price,index-197,O,L,H,C)
                +0.002018682254605*PriceSeries(Price,index-198,O,L,H,C)
                +0.001876164244533*PriceSeries(Price,index-199,O,L,H,C)
                +0.001701084902734*PriceSeries(Price,index-200,O,L,H,C)
                +0.001497246046404*PriceSeries(Price,index-201,O,L,H,C)
                +0.001268915968496*PriceSeries(Price,index-202,O,L,H,C)
                +0.001020741932116*PriceSeries(Price,index-203,O,L,H,C)
                +0.000757658146154*PriceSeries(Price,index-204,O,L,H,C)
                +0.000484788997913*PriceSeries(Price,index-205,O,L,H,C)
                +0.0002073518827043*PriceSeries(Price,index-206,O,L,H,C)
                -0.0000694415259049*PriceSeries(Price,index-207,O,L,H,C)
                -0.000340481717735*PriceSeries(Price,index-208,O,L,H,C)
                -0.000600853516619*PriceSeries(Price,index-209,O,L,H,C)
                -0.000845924142876*PriceSeries(Price,index-210,O,L,H,C)
                -0.001071423400811*PriceSeries(Price,index-211,O,L,H,C)
                -0.001273517003782*PriceSeries(Price,index-212,O,L,H,C)
                -0.001448869341983*PriceSeries(Price,index-213,O,L,H,C)
                -0.001594697233520*PriceSeries(Price,index-214,O,L,H,C)
                -0.001708811958429*PriceSeries(Price,index-215,O,L,H,C)
                -0.001789648776111*PriceSeries(Price,index-216,O,L,H,C)
                -0.001836285929693*PriceSeries(Pr