//+------------------------------------------------------------------+ 
//|                                                     KC_Cloud.mq5 | 
//|                                     Copyright  2007, John Smith | 
//|                                                                  | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2007, John Smith"
#property link ""
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----    2
#property indicator_buffers 2 
//----    
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----      
#property indicator_type1   DRAW_FILLING
//----     
#property indicator_color1  clrPaleGreen
//----   
#property indicator_label1  "KC_Cloud"
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET  0 //        
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum PriceMode
  {
   MODE_CLOSE,    //Close
   MODE_HIGHLOW   //High/Low
  };
//---
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|   CXMA              |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//|         |
//+-----------------------------------+
input PriceMode Mode=MODE_HIGHLOW; //   
//----   
input Smooth_Method XMA_Method=MODE_SMA; //  
input int XLength=12; //                      
input int XPhase=15;  //  
                      //  JJMA    -100 ... +100,     
                      //  VIDIA   CMO,  AMA    
//----  ATR
input uint              ATRPeriod=13;
input double            ATRFactor=1.5;
input int               Shift=0;      //      
//+-----------------------------------+
//----      
int ATR_Handle;
//----      
int  min_rates_total;
//----   ,    
//----      
double ExtHBuffer[],ExtLBuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//----    ATR
   ATR_Handle=iATR(NULL,0,ATRPeriod);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//----     
   min_rates_total=int(MathMax(GetStartBars(XMA_Method,XLength,XPhase),ATRPeriod));
//----      
   SetIndexBuffer(0,ExtHBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   SetIndexBuffer(1,ExtLBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   string shortname="KC_Cloud";
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//----       
   double ATR[1];
//----        
   int first,bar;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=0; //      
   else first=prev_calculated-1; //      
//---
   if(Mode==MODE_HIGHLOW)
     {
      static CXMA HXMA,LXMA;
      //----    
      for(bar=first; bar<rates_total && !IsStopped(); bar++)
        {
         //----       ATR[]
         if(CopyBuffer(ATR_Handle,0,time[bar],1,ATR)<=0) return(RESET);
         double res=ATRFactor*ATR[0];
         ExtHBuffer[bar]=HXMA.XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,XLength,high[bar],bar,false)+res;
         ExtLBuffer[bar]=LXMA.XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,XLength,low[bar],bar,false)-res;
        }
     }
   else
     {
      static CXMA XMA;
      //----    
      for(bar=first; bar<rates_total && !IsStopped(); bar++)
        {
         //----       ATR[]
         if(CopyBuffer(ATR_Handle,0,time[bar],1,ATR)<=0) return(RESET);
         double xma=XMA.XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,XLength,close[bar],bar,false);
         double res=ATRFactor*ATR[0];
         ExtHBuffer[bar]=xma+res;
         ExtLBuffer[bar]=xma-res;
        }
     }
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+
