//+------------------------------------------------------------------+
//|                                                 TimeToDouble.mq4 |
//|                        Copyright 2015, MetaQuotes Software Corp. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property library
#property copyright "Copyright 2015, MetaQuotes Software Corp."
#property link      "https://www.mql5.com"
#property version   "1.00"
#property strict
//+------------------------------------------------------------------+
//| My function                                                      |
//+------------------------------------------------------------------+
//--- datetime to double
double TimeToDouble(datetime date)
  {
   string event_date   = TimeToString(date,TIME_DATE);
   string event_time   = TimeToString(date,TIME_MINUTES);
   string Totime=event_date+event_time;
   string year= StringSubstr(Totime,2,2);
   string mon =  StringSubstr(Totime,5,2);
   string day =  StringSubstr(Totime,8,2);
   string hour=  StringSubstr(Totime,10,2);
   string min =  StringSubstr(Totime,13,2);
   double i_date=StrToDouble(Plus10(year)+Plus10(mon)+Plus10(day)+Plus10(hour)+Plus10(min));
   return (i_date);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//--- double to datetime
datetime DoubleToTime(double d_time)
  {
   string s_time=DoubleToStr(d_time,0);
   string year= StringSubstr(s_time,0,2);
   string mon =  StringSubstr(s_time,2,2);
   string day =  StringSubstr(s_time,4,2);
   string hour=  StringSubstr(s_time,6,2);
   string min =  StringSubstr(s_time,8,2);
   return(StrToTime("20"+minus10(year)+"."+minus10(mon)+"."+minus10(day)+" "+minus10(hour)+":"+minus10(min)));
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
string Plus10(string plus)
  {
   return (IntegerToString(StringToInteger(plus)+10));
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
string minus10(string plus)
  {
   return (IntegerToString(StringToInteger(plus)-10));
  }
//+------------------------------------------------------------------+
