//+------------------------------------------------------------------+ 
//|                                           Rainbow_Clouds_HTF.mq5 | 
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---   
#property version   "1.60"
#property description "Rainbow_Clouds       "
//---     
#property indicator_chart_window
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                          //        
#define INDICATOR_NAME "Rainbow_Clouds"  //    
#define SIZE 5                           //      CountIndicator 
//+----------------------------------------------+
//---    10
#property indicator_buffers 10
//---    
#property indicator_plots   SIZE
//+----------------------------------------------+
//|    1             |
//+----------------------------------------------+
//---      
#property indicator_type1   DRAW_FILLING
//---     
#property indicator_color1  clrGold,clrGold
//---   
#property indicator_label1  "Rainbow_Cloud 1"
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//---      
#property indicator_type2   DRAW_FILLING
//---     
#property indicator_color2  clrDodgerBlue,clrDodgerBlue
//---   
#property indicator_label2  "Rainbow_Cloud 2"
//+----------------------------------------------+
//|    3             |
//+----------------------------------------------+
//---      
#property indicator_type3   DRAW_FILLING
//---     
#property indicator_color3  clrLimeGreen,clrLimeGreen
//---   
#property indicator_label3  "Rainbow_Cloud 3"
//+----------------------------------------------+
//|    4             |
//+----------------------------------------------+
//---      
#property indicator_type4   DRAW_FILLING
//---     
#property indicator_color4  clrRed,clrRed
//---   
#property indicator_label4  "Rainbow_Cloud 4"
//+----------------------------------------------+
//|    5             |
//+----------------------------------------------+
//---      
#property indicator_type5   DRAW_FILLING
//---     
#property indicator_color5  clrDarkOrchid,clrDarkOrchid
//---   
#property indicator_label5  "Rainbow_Cloud 5"
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price
  };
//---
enum Smooth_Method
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4; //    ()
input Smooth_Method XMA_Method=MODE_EMA;   //  
input uint StartLength=2; //   
input uint StartStep=2;   //     
input uint EndStep=6;     //                                             
input int XPhase=15;      //  
                          //  JJMA    -100 ... +100,     
                          //  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_QUARTER_; //  
input int Shift=0;      //      
input int PriceShift=0; //      
//+----------------------------------------------+
//---      
int min_rates_total;
//---      
int Ind_Handle;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+
//|                                          |
//+------------------------------------------------------------------+  
class CIndBuffers
  {
public:
   double            m_UpBuffer[];
   double            m_DnBuffer[];
  };
//---   ,   
//---      
CIndBuffers Ind[SIZE];
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   if(!TimeFramesCheck(INDICATOR_NAME,TimeFrame)) return(INIT_FAILED);
//---   
   min_rates_total=2;
//---    Rainbow_Clouds
   Ind_Handle=iCustom(Symbol(),TimeFrame,"Rainbow_Clouds",XMA_Method,StartLength,StartStep,EndStep,XPhase,IPC,0,PriceShift);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      Rainbow_Clouds");
      return(INIT_FAILED);
     }
//---
   for(int numb=0; numb<SIZE; numb++)
     {
      int count=numb*2;
      //----      
      SetIndexBuffer(count,Ind[numb].m_UpBuffer,INDICATOR_DATA);
      SetIndexBuffer(count+1,Ind[numb].m_DnBuffer,INDICATOR_DATA);
      //----     
      PlotIndexSetInteger(numb,PLOT_SHIFT,Shift);
      //----   ,      
      PlotIndexSetDouble(numb,PLOT_EMPTY_VALUE,EMPTY_VALUE);
      //----   
      PlotIndexSetString(numb,PLOT_LABEL,"Rainbow_Cloud "+string(numb+1));
      //---       
      ArraySetAsSeries(Ind[numb].m_UpBuffer,true);
      ArraySetAsSeries(Ind[numb].m_DnBuffer,true);
     }
//---           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME,"(",GetStringTimeframe(TimeFrame),")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//---         
   ArraySetAsSeries(time,true);
//---
   for(int numb=0; numb<SIZE; numb++)
      if(!CountIndicator(0,NULL,TimeFrame,Ind_Handle,numb*2,Ind[numb].m_UpBuffer,numb*2+1,Ind[numb].m_DnBuffer,time,rates_total,prev_calculated,min_rates_total))
         return(RESET);
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//| CountLine                                                        |
//+------------------------------------------------------------------+
bool CountIndicator(uint     Numb,            //   CountLine      (  - 0)
                    string   Symb,            //  
                    ENUM_TIMEFRAMES TFrame,   //  
                    int      IndHandle,       //   
                    uint     UpBuffNumb,      //       
                    double&  UpIndBuf[],      //      
                    uint     DnBuffNumb,      //       
                    double&  DnIndBuf[],      //      
                    const datetime& iTime[],  //  
                    const int Rates_Total,    //       
                    const int Prev_Calculated,//       
                    const int Min_Rates_Total)//       
  {
//---
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;
//---     
//---    limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---       IndTime
      if(CopyTime(Symbol(),TFrame,iTime[bar],1,IndTime)<=0) return(RESET);
      //---
      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double UpArr[1],DnArr[1];
         //---      
         if(CopyBuffer(IndHandle,UpBuffNumb,iTime[bar],1,UpArr)<=0) return(RESET);
         if(CopyBuffer(IndHandle,DnBuffNumb,iTime[bar],1,DnArr)<=0) return(RESET);
         //---
         UpIndBuf[bar]=UpArr[0];
         DnIndBuf[bar]=DnArr[0];
        }
      else
        {
         UpIndBuf[bar]=UpIndBuf[bar+1];
         DnIndBuf[bar]=DnIndBuf[bar+1];
        }
     }
//---     
   return(true);
  }
//+------------------------------------------------------------------+
//| TimeFramesCheck()                                                |
//+------------------------------------------------------------------+    
bool TimeFramesCheck(string IndName,
                     ENUM_TIMEFRAMES TFrame) //   ()
  {
//---     
   if(TFrame<Period() && TFrame!=PERIOD_CURRENT)
     {
      Print("    "+IndName+"       !");
      Print("    !");
      return(RESET);
     }
//---
   return(true);
  }
//+------------------------------------------------------------------+
