//+---------------------------------------------------------------------+
//|                                                  Rainbow_Clouds.mq5 | 
//|                                  Copyright  2015, Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define INDTOTAL 5            //     
#define STEPTOTAL INDTOTAL*12 //     
//+----------------------------------------------+
//----   
#property indicator_buffers 10//INDTOTAL*2 
//----     
#property indicator_plots   INDTOTAL
//+----------------------------------------------+
//|    1             |
//+----------------------------------------------+
//---      
#property indicator_type1   DRAW_FILLING
//---     
#property indicator_color1  clrGold,clrGold
//---   
#property indicator_label1  "Rainbow_Cloud 1"
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//---      
#property indicator_type2   DRAW_FILLING
//---     
#property indicator_color2  clrDodgerBlue,clrDodgerBlue
//---   
#property indicator_label2  "Rainbow_Cloud 2"
//+----------------------------------------------+
//|    3             |
//+----------------------------------------------+
//---      
#property indicator_type3   DRAW_FILLING
//---     
#property indicator_color3  clrLimeGreen,clrLimeGreen
//---   
#property indicator_label3  "Rainbow_Cloud 3"
//+----------------------------------------------+
//|    4             |
//+----------------------------------------------+
//---      
#property indicator_type4   DRAW_FILLING
//---     
#property indicator_color4  clrRed,clrRed
//---   
#property indicator_label4  "Rainbow_Cloud 4"
//+----------------------------------------------+
//|    5             |
//+----------------------------------------------+
//---      
#property indicator_type5   DRAW_FILLING
//---     
#property indicator_color5  clrDarkOrchid,clrDarkOrchid
//---   
#property indicator_label5  "Rainbow_Cloud 5"
//+----------------------------------------------+
//|   CXMA                         |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1[INDTOTAL+1];
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input Smooth_Method XMA_Method=MODE_EMA; //  
input uint StartLength=2; //   
input uint StartStep=2;   //     
input uint EndStep=6;     //                                             
input int XPhase=15;      //  
                          //  JJMA    -100 ... +100,     
//  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_QUARTER_; //  
input int Shift=0;      //      
input int PriceShift=0; //      
//+----------------------------------------------+
//----       
double dPriceShift;
//----      
int min_rates_total;
int length[INDTOTAL+1];
//+------------------------------------------------------------------+
//|                                          |
//+------------------------------------------------------------------+  
class CIndBuffers
  {
public:
   double            m_UpBuffer[];
   double            m_DnBuffer[];
  };
//---   ,   
//---      
CIndBuffers Ind[INDTOTAL];
//+------------------------------------------------------------------+   
//| Rainbow_Clouds indicator initialization function                 | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   int period[STEPTOTAL+1];
   double ratio=(EndStep-StartStep)/(STEPTOTAL-1);
   period[0]=int(StartLength);
   for(int count=1; count<=STEPTOTAL; count++) period[count]=period[count-1]+int(StartStep+count*ratio);
   min_rates_total=int(GetStartBars(XMA_Method,int(period[STEPTOTAL]),XPhase));
   for(int numb=0; numb<=INDTOTAL; numb++) length[numb]=period[numb*12];
//----    
   dPriceShift=_Point*PriceShift;
//---
   for(int numb=0; numb<INDTOTAL; numb++)
     {
      int count=numb*2;
      //----      
      SetIndexBuffer(count,Ind[numb].m_UpBuffer,INDICATOR_DATA);
      SetIndexBuffer(count+1,Ind[numb].m_DnBuffer,INDICATOR_DATA);
      //----     
      PlotIndexSetInteger(numb,PLOT_SHIFT,Shift);
      //----   ,      
      PlotIndexSetDouble(numb,PLOT_EMPTY_VALUE,EMPTY_VALUE);
      //----   
      PlotIndexSetString(numb,PLOT_LABEL,"Rainbow_Cloud "+string(numb+1));
     }
//----      
   string shortname;
   string Smooth1=XMA1[0].GetString_MA_Method(XMA_Method);
   StringConcatenate(shortname,"Rainbow(",StartLength,", ",Smooth1,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
  }
//+------------------------------------------------------------------+ 
//| Rainbow_Clouds iteration function                                | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----       
   double price;
//----        
   int first,bar;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=0; //      
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      price=PriceSeries(IPC,bar,open,low,high,close);
      Ind[0].m_UpBuffer[bar]=XMA1[0].XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,length[0],price,bar,false)+dPriceShift;
      Ind[0].m_DnBuffer[bar]=XMA1[1].XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,length[1],price,bar,false)+dPriceShift;
      Ind[1].m_UpBuffer[bar]=Ind[0].m_DnBuffer[bar];
      Ind[1].m_DnBuffer[bar]=XMA1[2].XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,length[2],price,bar,false)+dPriceShift;
      Ind[2].m_UpBuffer[bar]=Ind[1].m_DnBuffer[bar];
      Ind[2].m_DnBuffer[bar]=XMA1[3].XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,length[3],price,bar,false)+dPriceShift;
      Ind[3].m_UpBuffer[bar]=Ind[2].m_DnBuffer[bar];
      Ind[3].m_DnBuffer[bar]=XMA1[4].XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,length[4],price,bar,false)+dPriceShift;
      Ind[4].m_UpBuffer[bar]=Ind[3].m_DnBuffer[bar];
      Ind[4].m_DnBuffer[bar]=XMA1[5].XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,length[5],price,bar,false)+dPriceShift;
     }
//----         
   return(rates_total);
  }
//+------------------------------------------------------------------+
