//+---------------------------------------------------------------------+
//|                                                 CenterOfGravity.mq4 |
//|                         Copyright  2007, MetaQuotes Software Corp. |
//|                                           http://www.metaquotes.net |
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2007, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"
//----   
#property version   "1.11"
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 3
//----    
#property indicator_plots   2
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----   1    
#property indicator_type1 DRAW_COLOR_LINE
//----      
#property indicator_color1 clrGray,clrLime,clrRed
//----   1 -  
#property indicator_style1  STYLE_SOLID
//----    1  1
#property indicator_width1  1
//----    1
#property indicator_label1  "Center of Gravity"
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----        
#property indicator_color2  clrBlue
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  1
#property indicator_width2  1
//----    2
#property indicator_label2  "Signal Line"
//----   -  
#property indicator_style2 STYLE_DASHDOTDOT
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //PRICE_CLOSE
   PRICE_OPEN_,          //PRICE_OPEN
   PRICE_HIGH_,          //PRICE_HIGH
   PRICE_LOW_,           //PRICE_LOW
   PRICE_MEDIAN_,        //PRICE_MEDIAN
   PRICE_TYPICAL_,       //PRICE_TYPICAL
   PRICE_WEIGHTED_,      //PRICE_WEIGHTED
   PRICE_SIMPL_,         //PRICE_SIMPL_
   PRICE_QUARTER_,       //PRICE_QUARTER_
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price
  };
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint Period_=10; //   
input uint SmoothPeriod=3; //    
input ENUM_MA_METHOD MA_Method_=MODE_SMA; //    
input Applied_price_ AppliedPrice=PRICE_CLOSE_;//  
//----   ,    
//----      
double Ext1Buffer[];
double Ext2Buffer[];
double ColorExt2Buffer[];
//----      
int min_rates_total;
//---
#include <SmoothAlgorithms.mqh> 
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----  
   min_rates_total=int(Period_+1+SmoothPeriod+2);
//----    MAMABuffer   
   SetIndexBuffer(0,Ext1Buffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total+1);
//----     ,     
   SetIndexBuffer(1,ColorExt2Buffer,INDICATOR_COLOR_INDEX);
//----    FAMABuffer   
   SetIndexBuffer(2,Ext2Buffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total+1);
//----      
   string shortname;
   StringConcatenate(shortname,"Center of Gravity(",Period_,")");
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----       
   double price_,sma,lwma;
//----   
   int first1,first2,first3,bar;
   static int startbar;
//----     OnCalculate()
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      first1=0; //        
      first2=int(Period_+1); //        
      first3=int(Period_+SmoothPeriod+3); //        
      startbar=int(Period_+1);
     }
   else //      
     {
      first1=prev_calculated-1;
      first2=first1;
      first3=first1;
     }
//----    Moving_Average
   static CMoving_Average MA,LWMA,SIGN;
//----      
   for(bar=first1; bar<rates_total; bar++)
     {
      //----   PriceSeries     Series
      price_=PriceSeries(AppliedPrice,bar,open,low,high,close);
      //----
      sma=MA.MASeries(0,prev_calculated,rates_total,Period_,MODE_SMA,price_,bar,false);
      lwma=LWMA.MASeries(0,prev_calculated,rates_total,Period_,MODE_LWMA,price_,bar,false);
      //----
      Ext1Buffer[bar]=sma*lwma/_Point;
      Ext2Buffer[bar]=SIGN.MASeries(startbar,prev_calculated,rates_total,SmoothPeriod,MA_Method_,Ext1Buffer[bar],bar,false);
     }
//----     
   for(bar=first3; bar<rates_total; bar++)
     {
      ColorExt2Buffer[bar]=0;
      if(Ext1Buffer[bar]<Ext2Buffer[bar])
         ColorExt2Buffer[bar]=2;
      else ColorExt2Buffer[bar]=1;
     }
//----
   return(rates_total);
  }
//+------------------------------------------------------------------+
