//+------------------------------------------------------------------+
//|                                                    ATR ratio.mq5 |
//|                         Copyright  2005, Luis Guilherme Damiani |
//|                                      http://www.damianifx.com.br |
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2005, Luis Guilherme Damiani"
//----    
#property link      "http://www.damianifx.com.br"
#property description "ATR ratio"
//----   
#property version   "1.01"
//----     
#property indicator_separate_window
//----    1
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type1 DRAW_LINE
//----      MediumOrchid 
#property indicator_color1 clrMediumOrchid
//----   - 
#property indicator_style1 STYLE_SOLID
//----     2
#property indicator_width1 2
//----    
#property indicator_label1  "ATR ratio"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 1
#property indicator_levelcolor clrGray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int Short_ATRPeriod=7; //   ATR
input int Long_ATRPeriod=49; //   ATR
input int ATRShift=0; //       
//----   ,    
//----      
double ExtLineBuffer[];
//----      
int SATR_Handle,LATR_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----    ATR
   SATR_Handle=iATR(NULL,PERIOD_CURRENT,Short_ATRPeriod);
   if(SATR_Handle==INVALID_HANDLE)Print("      ATR");
//----    ATR
   LATR_Handle=iATR(NULL,PERIOD_CURRENT,Long_ATRPeriod);
   if(LATR_Handle==INVALID_HANDLE)Print("      ATR");
//----     
   min_rates_total=MathMax(Short_ATRPeriod,Long_ATRPeriod);
//----    ExtLineBuffer   
   SetIndexBuffer(0,ExtLineBuffer,INDICATOR_DATA);
//----      
   string shortname;
   StringConcatenate(shortname,"ATR ratio(",Short_ATRPeriod," ",Long_ATRPeriod,")");
//----    1    ATRShift
   PlotIndexSetInteger(0,PLOT_SHIFT,ATRShift);
//----       
   PlotIndexSetString(0,PLOT_LABEL,shortname);
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----          
   ArraySetAsSeries(ExtLineBuffer,true);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,2);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(SATR_Handle)<rates_total
      || BarsCalculated(LATR_Handle)<rates_total
      || rates_total<min_rates_total)
      return(RESET);
//----    
   int to_copy,limit,bar;
   double SRange[],LRange[];
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      limit=rates_total-1; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
   to_copy=limit+1;
//----       SRange[]  LRange[]
   if(CopyBuffer(SATR_Handle,0,0,to_copy,SRange)<=0) return(RESET);
   if(CopyBuffer(LATR_Handle,0,0,to_copy,LRange)<=0) return(RESET);
//----         
   ArraySetAsSeries(SRange,true);
   ArraySetAsSeries(LRange,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      if(LRange[bar]!=0.0 && LRange[bar]!=EMPTY_VALUE) ExtLineBuffer[bar]=SRange[bar]/LRange[bar];
      else ExtLineBuffer[bar]=0;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
