//+---------------------------------------------------------------------+ 
//|                                                   2pbIdealXOSMA.mq5 | 
//|                                  Copyright  2012, Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2012, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//---   
#property version   "1.02"
//---     
#property indicator_separate_window 
//---    2
#property indicator_buffers 2 
//---     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//---      
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//---      
#property indicator_color1 clrGray,clrOliveDrab,clrDodgerBlue,clrDeepPink,clrMagenta
//---   - 
#property indicator_style1 STYLE_SOLID
//---     2
#property indicator_width1 2
//---   
#property indicator_label1 "2pbIdealXOSMA"
//+-----------------------------------+
//|          |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//---    CXMA   SmoothAlgorithms.mqh
CXMA XMA1;
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input int Period1 = 10;                     //  
input int Period2 = 10;                     //  
input int PeriodX1 = 10;                    //   
input int PeriodX2 = 10;                    //   
input int PeriodY1 = 10;                    //   
input int PeriodY2 = 10;                    //   
input int PeriodZ1 = 10;                    //   
input int PeriodZ2 = 10;                    //   
input Smooth_Method SmoothMethod=MODE_JJMA; //  
input int Smooth_XMA=9;                     //  
input int Smooth_Phase=100;                 //  
//--- Smooth_Phase:  JJMA    -100 ... +100,     ;
//--- Smooth_Phase:  VIDIA   CMO,  AMA    
//+-----------------------------------+
//---      
int min_rates_total;
//---   ,   
//---      
double IndBuffer[],ColorIndBuffer[];
//---     
double w1,w2,wX1,wX2,wY1,wY2,wZ1,wZ2;
//---      
double Moving0_,Moving01_,Moving11_,Moving21_;
//+------------------------------------------------------------------+
//|   iPriceSeries                                    |
//|   Moving_Average                                   |
//+------------------------------------------------------------------+ 
#include <SmoothAlgorithms.mqh>
//+------------------------------------------------------------------+
//|   Neutron                                            |
//+------------------------------------------------------------------+
double GetIdealMASmooth(double W1_,     //  
                        double W2_,     //  
                        double Series1, //     
                        double Series0, //     
                        double Result1) //    
  {
//---
   double Result0,dSeries,dSeries2;
   dSeries=Series0-Series1;
   dSeries2=dSeries*dSeries-1.0;
//---
   Result0=(W1_ *(Series0-Result1)+
            Result1+W2_*Result1*dSeries2)
   /(1.0+W2_*dSeries2);
//---
   return(Result0);
  }
//+------------------------------------------------------------------+    
//| 2pbIdealXOSMA indicator initialization function                  | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//---     
   min_rates_total=2+XMA1.GetStartBars(SmoothMethod,Smooth_XMA,Smooth_Phase);
//---  
   w1=1.0/Period1;
   w2=1.0/Period2;
   wX1=1.0/PeriodX1;
   wX2=1.0/PeriodX2;
   wY1=1.0/PeriodY1;
   wY2=1.0/PeriodY2;
   wZ1=1.0/PeriodZ1;
   wZ2=1.0/PeriodZ2;
//---    IndBuffer   
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---      DataWindow
   PlotIndexSetString(0,PLOT_LABEL,"Ind");
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//---     ,     
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//---       
   XMA1.XMALengthCheck("Smooth_XMA",Smooth_XMA);
//---       
   XMA1.XMAPhaseCheck("Smooth_Phase",Smooth_Phase,SmoothMethod);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"2pbIdealXOSMA");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//---  
  }
//+------------------------------------------------------------------+  
//| 2pbIdealXOSMA iteration function                                 | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,     //       
                const int prev_calculated, //       
                const int begin,           //     
                const double &price[])     //     
  {
//---       
   if(rates_total<min_rates_total+begin) return(0);
///---    
   int first,bar;
   double Moving0,SlowMA,FastMA,macd;
   double Moving00,Moving10,Moving20;
   double Moving01,Moving11,Moving21;
//---    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=1+begin;  //      
      //---      begin ,      
      if(begin>0) PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total+begin);
      //---    
      Moving0_=price[begin];
      Moving01_=price[begin];
      Moving11_=price[begin];
      Moving21_=price[begin];
     }
   else first=prev_calculated-1; //      
//---   
   Moving0=Moving0_;
   Moving01=Moving01_;
   Moving11=Moving11_;
   Moving21=Moving21_;
//---    
   for(bar=first; bar<rates_total; bar++)
     {
      Moving0=GetIdealMASmooth(w1,w2,price[bar-1],price[bar],Moving0);
      Moving00=GetIdealMASmooth(wX1,wX2,price[bar-1],price[bar],Moving01);
      Moving10=GetIdealMASmooth(wY1,wY2,Moving01,    Moving00,  Moving11);
      Moving20=GetIdealMASmooth(wZ1,wZ2,Moving11,    Moving10,  Moving21);
      //---
      Moving01 = Moving00;
      Moving11 = Moving10;
      Moving21 = Moving20;
      //---
      SlowMA=Moving20;
      FastMA=Moving0;
      macd=FastMA-SlowMA;
      IndBuffer[bar]=XMA1.XMASeries(1+begin,prev_calculated,rates_total,SmoothMethod,Smooth_Phase,Smooth_XMA,macd,bar,false);
      //---
      if(bar==rates_total-2)
        {
         Moving0_=Moving0;
         Moving01_=Moving01;
         Moving11_=Moving11;
         Moving21_=Moving21;
        }
     }

   if(prev_calculated>rates_total || prev_calculated<=0) first++;
//---     Ind
   for(bar=first; bar<rates_total; bar++)
     {
      ColorIndBuffer[bar]=0;
      //---
      if(IndBuffer[bar]>0)
        {
         if(IndBuffer[bar]>IndBuffer[bar-1]) ColorIndBuffer[bar]=1;
         if(IndBuffer[bar]<IndBuffer[bar-1]) ColorIndBuffer[bar]=2;
        }
      //---
      if(IndBuffer[bar]<0)
        {
         if(IndBuffer[bar]<IndBuffer[bar-1]) ColorIndBuffer[bar]=3;
         if(IndBuffer[bar]>IndBuffer[bar-1]) ColorIndBuffer[bar]=4;
        }
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
