//+------------------------------------------------------------------+ 
//|                                    ColorCoeffofLine_true_HTF.mq5 | 
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//---   
#property version   "1.60"
//---     
#property indicator_separate_window
//---    2
#property indicator_buffers 2 
//---     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//---      
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//---       
#property indicator_color1 clrGray,clrLime,clrBlue,clrRed,clrMagenta
//---   - 
#property indicator_style1 STYLE_SOLID
//---     2
#property indicator_width1 2
//---   
#property indicator_label1 "ColorCoeffofLine_true HTF"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4; //  
input int SMMAPeriod=5;                    //  
input bool ReDraw=true;                    //      
//+----------------------------------------------+
//---      
int min_rates_total;
//---      
int Ind_Handle;
//---   ,    
//---      
double IndBuffer[],ColorIndBuffer[];
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {
//---
   return(StringSubstr(EnumToString(timeframe),7,-1));
//---
  }
//+------------------------------------------------------------------+    
//| Ind indicator initialization function                            | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   min_rates_total=3;
//---     
   if(TimeFrame<Period() && TimeFrame!=PERIOD_CURRENT)
     {
      Print("    ColorCoeffofLine_true       ");
      return(INIT_FAILED);
     }
//---    ColorCoeffofLine_true
   Ind_Handle=iCustom(Symbol(),TimeFrame,"ColorCoeffofLine_true",SMMAPeriod);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      ColorCoeffofLine_true");
      return(INIT_FAILED);
     }
//---    IndBuffer   
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       
   ArraySetAsSeries(IndBuffer,true);
//---     ,     
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//---      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---       
   ArraySetAsSeries(ColorIndBuffer,true);
//---      
   string shortname;
   StringConcatenate(shortname,"ColorCoeffofLine_true HTF( ",GetStringTimeframe(TimeFrame),", ",SMMAPeriod," )");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Ind iteration function                                           | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//---   
   int limit,bar;
//---       
   double Ind[2];
   datetime IndTime[1];
   static uint LastCountBar;
//---     
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      LastCountBar=rates_total;
     }
   else limit=int(LastCountBar)+rates_total-prev_calculated; //       
//---         
   ArraySetAsSeries(time,true);
//---    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---      
      IndBuffer[bar]=EMPTY_VALUE;
      ColorIndBuffer[bar]=0;
      //---      
      if(CopyTime(Symbol(),TimeFrame,time[bar],1,IndTime)<=0) return(RESET);
      //---
      if(time[bar]>=IndTime[0] && time[bar+1]<IndTime[0])
        {
         LastCountBar=bar;
         //---      
         if(CopyBuffer(Ind_Handle,0,time[bar],2,Ind)<=0) return(RESET);
         //---      
         IndBuffer[bar]=Ind[1];
         //---         
         if(IndBuffer[bar]>0)
           {
            if(Ind[1]>Ind[0]) ColorIndBuffer[bar]=1;
            if(Ind[1]<Ind[0]) ColorIndBuffer[bar]=2;
           }
         //---
         if(IndBuffer[bar]<0)
           {
            if(Ind[1]<Ind[0]) ColorIndBuffer[bar]=3;
            if(Ind[1]>Ind[0]) ColorIndBuffer[bar]=4;
           }
        }
      //---
      if(ReDraw)
        {
         if(IndBuffer[bar+1]!=EMPTY_VALUE && IndBuffer[bar]==EMPTY_VALUE)
           {
            IndBuffer[bar]=IndBuffer[bar+1];
            ColorIndBuffer[bar]=ColorIndBuffer[bar+1];
           }
        }
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
