//+------------------------------------------------------------------+
//|                                        ColorCoeffofLine_true.mq5 |
//|                                       Ramdass - Conversion only  |
//+------------------------------------------------------------------+
#property copyright "Ramdass - Conversion only"
#property link ""
//---   
#property version   "1.00"
//---     
#property indicator_separate_window
//---    2
#property indicator_buffers 2 
//---     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//---      
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//---       
#property indicator_color1 clrGray,clrLime,clrBlue,clrRed,clrMagenta
//---   - 
#property indicator_style1 STYLE_SOLID
//---     2
#property indicator_width1 2
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int SMMAPeriod=5;  //  
//+----------------------------------------------+
//---   ,    
//---        
double ExtBuffer[],ColorExtBuffer[];
//---      
int Handle;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//---    ExtBuffer   
   SetIndexBuffer(0,ExtBuffer,INDICATOR_DATA);
//---       
   ArraySetAsSeries(ExtBuffer,true);
//---     ,     
   SetIndexBuffer(1,ColorExtBuffer,INDICATOR_COLOR_INDEX);
//---       
   ArraySetAsSeries(ColorExtBuffer,true);
//---       MAPeriod
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,2*SMMAPeriod+4);
//---   
   Handle=iMA(NULL,0,SMMAPeriod,3,MODE_SMMA,PRICE_MEDIAN);
   if(Handle==INVALID_HANDLE)
     {
      Print("      SMMA");
      return(INIT_FAILED);
     }
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(Handle)<rates_total || rates_total<2*SMMAPeriod-1)
      return(0);
//---    
   int to_copy,limit1,limit2,Count,bar,cnt,iii,ndot=SMMAPeriod;
   double Sum,SMMA[],TYVar,ZYVar,TIndicatorVar,ZIndicatorVar,M,N,AY,AIndicator;
//---       
   ArraySetAsSeries(SMMA,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      limit1=rates_total-SMMAPeriod-ndot-1; //      
      limit2=limit1-1;
      to_copy=rates_total-SMMAPeriod;
     }
   else
     {
      limit1=rates_total-prev_calculated; //      
      limit2=limit1; //      
      to_copy=limit1+ndot+1;
     }
//---       SMMA[]
   if(CopyBuffer(Handle,0,0,to_copy,SMMA)<=0) return(0);
//---    
   for(bar=limit1; bar>=0; bar--)
     {
      TYVar = 0;
      ZYVar = 0;
      N = 0;
      M = 0;
      TIndicatorVar = 0;
      ZIndicatorVar = 0;
      //---   
      for(cnt=ndot; cnt>=1; cnt--) // n=5 -    
        {
         iii = bar + cnt - 1;
         Sum = (high[iii] + low[iii]) / 2;
         Count=SMMAPeriod+1-cnt;
         //ZYVar += Sum * Count; 
         ZYVar+=((high[bar+cnt-1]+low[bar+cnt-1])/2)*(6-cnt);
         TYVar+= Sum;
         N+=cnt*cnt; // 55
         M+=cnt; // 15
         ZIndicatorVar += SMMA[iii] * Count;
         TIndicatorVar += SMMA[iii];
        }
      //---
      AY=(TYVar+(N-2*ZYVar)*ndot/M)/M;
      AIndicator=(TIndicatorVar+(N-2*ZIndicatorVar)*ndot/M)/M;
      //---
      if(Symbol()=="EURUSD" || Symbol()=="GBPUSD" || Symbol()=="USDCAD" || Symbol()=="USDCHF"
         || Symbol()=="EURGBP" || Symbol()=="EURCHF" || Symbol()=="AUDUSD"
         || Symbol()=="GBPCHF")
        {ExtBuffer[bar]=(-1000)*MathLog(AY/AIndicator);}
      else {ExtBuffer[bar]=(1000)*MathLog(AY/AIndicator);}
     }
//---    
   for(bar=limit2; bar>=0; bar--)
     {
      ColorExtBuffer[bar]=0;
      //---
      if(ExtBuffer[bar]>0)
        {
         if(ExtBuffer[bar]>ExtBuffer[bar+1]) ColorExtBuffer[bar]=1;
         if(ExtBuffer[bar]<ExtBuffer[bar+1]) ColorExtBuffer[bar]=2;
        }
      //---
      if(ExtBuffer[bar]<0)
        {
         if(ExtBuffer[bar]<ExtBuffer[bar+1]) ColorExtBuffer[bar]=3;
         if(ExtBuffer[bar]>ExtBuffer[bar+1]) ColorExtBuffer[bar]=4;
        }
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
