//+------------------------------------------------------------------+
//|                                                      ExTrend.mq5 |
//|                           Copyright  2006, Alex Sidd (Executer) | 
//|                                           mailto:work_st@mail.ru | 
//+------------------------------------------------------------------+ 
//---  
#property copyright "Copyright  2006, Alex Sidd (Executer)k"
//---  
#property link      "mailto:work_st@mail.ru"
//---   
#property version   "1.01"
//---     
#property indicator_separate_window
//---        
#property indicator_buffers 2
//---    
#property indicator_plots   2
//+----------------------------------------------+
//|    1             |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_LINE
//---         Lime
#property indicator_color1  clrLime
//---   1 -  
#property indicator_style1  STYLE_SOLID
//---    1  1
#property indicator_width1  1
//---    
#property indicator_label1  "Up Line"
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_LINE
//---         Magenta
#property indicator_color2  clrMagenta
//---   2 -  
#property indicator_style2  STYLE_SOLID
//---    2  1
#property indicator_width2  1
//---    
#property indicator_label2  "Down Line"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 0.0
#property indicator_levelcolor clrGray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0     //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+ 
input color UpLineColor=clrTeal;     //    
input color DnLineColor=clrMagenta;  //    
input int Shift=0;                   //       
//+----------------------------------------------+
//---   ,   
//---      
double UpBuffer[];
double DnBuffer[];
//---      
int FRA_Handle;
//---      
int min_rates_total;
//---
string Up_level_name,Dn_level_name;
double FractUp1,FractUp2,FractDn1,FractDn2;
datetime FTimeUp1,FTimeUp2,FTimeDn1,FTimeDn2,curTime;
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
void CreateTline(long     chart_id,      //  
                 string   name,          //  
                 int      nwin,          //  
                 datetime time1,         //  1  
                 double   price1,        // 1  
                 datetime time2,         //  2  
                 double   price2,        // 2  
                 color    Color,         //  
                 int      style,         //  
                 int      width,         //  
                 string   text)          // 
  {
//---
   ObjectCreate(chart_id,name,OBJ_TREND,nwin,time1,price1,time2,price2);
   ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
   ObjectSetInteger(chart_id,name,OBJPROP_STYLE,style);
   ObjectSetInteger(chart_id,name,OBJPROP_WIDTH,width);
   ObjectSetString(chart_id,name,OBJPROP_TEXT,text);
   ObjectSetInteger(chart_id,name,OBJPROP_BACK,false);
   ObjectSetInteger(chart_id,name,OBJPROP_RAY_RIGHT,true);
   ObjectSetInteger(chart_id,name,OBJPROP_RAY,true);
   ObjectSetInteger(chart_id,name,OBJPROP_SELECTED,true);
   ObjectSetInteger(chart_id,name,OBJPROP_SELECTABLE,true);
   ObjectSetInteger(chart_id,name,OBJPROP_ZORDER,true);
//---
  }
//+------------------------------------------------------------------+
//|                                       |
//+------------------------------------------------------------------+
void SetTline(long     chart_id,      //  
              string   name,          //  
              int      nwin,          //  
              datetime time1,         //  1  
              double   price1,        // 1  
              datetime time2,         //  2  
              double   price2,        // 2  
              color    Color,         //  
              int      style,         //  
              int      width,         //  
              string   text)          // 
  {
//---
   if(ObjectFind(chart_id,name)==-1) CreateTline(chart_id,name,nwin,time1,price1,time2,price2,Color,style,width,text);
   else
     {
      ObjectSetString(chart_id,name,OBJPROP_TEXT,text);
      ObjectMove(chart_id,name,0,time1,price1);
      ObjectMove(chart_id,name,1,time2,price2);
      ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
     }
//---
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   min_rates_total=10;
   FractUp1=0.0;
   FractUp2=0.0;
   FractDn1=0.0;
   FractDn2=0.0;
//---    ATR
   FRA_Handle=iFractals(NULL,0);
   if(FRA_Handle==INVALID_HANDLE)
     {
      Print("      iFractals");
      return(INIT_FAILED);
     }
//---    UpBuffer[]   
   SetIndexBuffer(0,UpBuffer,INDICATOR_DATA);
//---    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---       1  min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       
   ArraySetAsSeries(UpBuffer,true);
//---    DnBuffer[]   
   SetIndexBuffer(1,DnBuffer,INDICATOR_DATA);
//---    2    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//---       2  min_rates_total
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       
   ArraySetAsSeries(DnBuffer,true);
//---      
   string shortname;
   StringConcatenate(shortname,"ExTrend(",Shift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,2);
//---  
   Up_level_name=shortname+" Up_level";
   Dn_level_name=shortname+" Dn_level";
   if(ObjectFind(0,Up_level_name)==-1) SetTline(0,Up_level_name,0,0,0,0,0,UpLineColor,0,1,Up_level_name);
   if(ObjectFind(0,Dn_level_name)==-1) SetTline(0,Dn_level_name,0,0,0,0,0,DnLineColor,0,1,Dn_level_name);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+    
void OnDeinit(const int reason)
  {
//---     
   ObjectDelete(0,Up_level_name);
   ObjectDelete(0,Dn_level_name);
//---
   ChartRedraw(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(FRA_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//---    
   int to_copy,limit;
   double UpFr[],DnFr[];
//---     
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      to_copy=rates_total; //     
      limit=rates_total-min_rates_total-1; //      
     }
   else
     {
      to_copy=rates_total-prev_calculated+6; //      
      limit=rates_total-prev_calculated+2; //      
     }
//---       UpFr[]  DnFr[]
   if(CopyBuffer(FRA_Handle,0,0,to_copy,UpFr)<=0) return(RESET);
   if(CopyBuffer(FRA_Handle,1,0,to_copy,DnFr)<=0) return(RESET);
//---         
   ArraySetAsSeries(UpFr,true);
   ArraySetAsSeries(DnFr,true);
   ArraySetAsSeries(time,true);
//---    
   for(int bar=2; bar>=0 && !IsStopped(); bar--)
     {
      UpBuffer[bar]=EMPTY_VALUE;
      DnBuffer[bar]=EMPTY_VALUE;
     }
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      double negative=0;
      double positive=0;
      double Fup=UpFr[bar+3];
      double Fdn=DnFr[bar+3];
      //---
      if(Fup && Fup!=EMPTY_VALUE)
        {
         if(!FractUp1 && !FractUp2)
           {
            FractUp1 = Fup;
            FTimeUp1 = time[bar+3];
           }
         //---
         if(FractUp1 && !FractUp2 && FTimeUp1!=time[bar+3])
           {
            FractUp2 = Fup;
            FTimeUp2 = time[bar+3];
           }
         //---
         if(FractUp1 && FractUp2 && FTimeUp2!=time[bar+3])
           {
            FractUp1 = FractUp2;
            FTimeUp1 = FTimeUp2;
            FractUp2 = Fup;
            FTimeUp2 = time[bar+3];
           }
        }
      //---
      if(Fdn && Fdn!=EMPTY_VALUE)
        {
         if(!FractDn1 && !FractDn2)
           {
            FractDn1 = Fdn;
            FTimeDn1 = time[bar+3];
           }
         //---
         if(FractDn1 && !FractDn2 && FTimeDn1!=time[bar+3])
           {
            FractDn2 = Fdn;
            FTimeDn2 = time[bar+3];
           }
         //---
         if(FractDn1 && FractDn2 && FTimeDn2!=time[bar+3])
           {
            FractDn1 = FractDn2;
            FTimeDn1 = FTimeDn2;
            FractDn2 = Fdn;
            FTimeDn2 = time[bar+3];
           }
        }
      //---
      if(FractUp1 && FractUp2)
        {
         SetTline(0,Up_level_name,0,FTimeUp1,FractUp1,FTimeUp2,FractUp2,UpLineColor,0,1,Up_level_name);
         double y = double((FTimeUp2 - FTimeUp1) / (240*60.0));
         double x = (FractUp2 - FractUp1)*(240.0);
         if(!y) y=double(1/(240*60.0));
         positive=MathArctan(x/y);
        }
      //---
      if(FractDn1 && FractDn2)
        {
         SetTline(0,Dn_level_name,0,FTimeDn1,FractDn1,FTimeDn2,FractDn2,DnLineColor,0,1,Dn_level_name);
         double a = double((FTimeDn2 - FTimeDn1) / (240*60.0));
         double b = (FractDn2 - FractDn1)*(240.0);
         if(!a) a=double(1/(240*60.0));
         negative=MathArctan(b/a);
        }
      UpBuffer[bar+3]=positive;
      DnBuffer[bar+3]=negative;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
