//+------------------------------------------------------------------+
//|                                               Leading_Signal.mq5 | 
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
#property description ""
//---   
#property version   "1.60"
//---     
#property indicator_separate_window
//---       
#property indicator_height 20
//---        
#property indicator_maximum +1.9
#property indicator_minimum +0.3
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                       //        
#define INDTOTAL 1                    //     
#define INDICATOR_NAME "Leading"      //    
//+----------------------------------------------+
//---   
#property indicator_buffers 4 // INDTOTAL*4
//---    
#property indicator_plots   2 // INDTOTAL*2
//+----------------------------------------------+
//|    1             |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_COLOR_LINE
//---      
#property indicator_color1 clrHotPink,clrLime
//---   - 
#property indicator_style1  STYLE_SOLID
//---     3
#property indicator_width1  3
//---   
#property indicator_label1  "Signal line"
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//---      
#property indicator_type2 DRAW_COLOR_ARROW
//---      
#property indicator_color2 clrMagenta,clrMediumSeaGreen
//---   - 
#property indicator_style2 STYLE_SOLID
//---     2
#property indicator_width2 2
//---   
#property indicator_label2  "Signal Arrow"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;  //  
input double Alpha1 = 0.25;                 // 1  
input double Alpha2 = 0.33;                 // 2   
//+----------------------------------------------+
//---      
int min_rates_total;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+
//|                                          |
//+------------------------------------------------------------------+  
class CIndBuffers
  {
   //---
public:
   double            m_LineBuffer[];
   double            m_ColorLineBuffer[];
   double            m_ArrowBuffer[];
   double            m_ColorArrowBuffer[];
   int               m_Handle;
   ENUM_TIMEFRAMES   m_TimeFrame;
   //--- 
  };
//---   ,   
//---      
CIndBuffers Ind[INDTOTAL];
//+------------------------------------------------------------------+   
//| Leading indicator initialization function                        | 
//+------------------------------------------------------------------+ 
bool IndInit(uint Number)
  {
//---     
   if(Ind[Number].m_TimeFrame<Period() && Ind[Number].m_TimeFrame!=PERIOD_CURRENT)
     {
      Print("IndInit(",Number,"):     Leading       ");
      return(false);
     }
//---     
   Ind[Number].m_Handle=iCustom(Symbol(),Ind[Number].m_TimeFrame,"Leading",Alpha1,Alpha2,0);
   if(Ind[Number].m_Handle==INVALID_HANDLE)
     {
      Print("IndInit(",Number,"):      Leading");
      return(false);
     }
   uint BIndex=Number*4+0;
   uint PIndex=Number*2+0;
   InitTsIndBuffer(BIndex,PIndex,Ind[Number].m_LineBuffer,EMPTY_VALUE,min_rates_total);
   InitTsIndColorBuffer(BIndex+1,Ind[Number].m_ColorLineBuffer);
   InitTsIndArrBuffer(BIndex+2,PIndex+1,Ind[Number].m_ArrowBuffer,EMPTY_VALUE,min_rates_total);
   InitTsIndColorBuffer(BIndex+3,Ind[Number].m_ColorArrowBuffer);
//----   
   string tmf=GetStringTimeframe(Ind[Number].m_TimeFrame);
   PlotIndexSetString(PIndex+0,PLOT_LABEL,INDICATOR_NAME+"Line("+tmf+")");
   PlotIndexSetString(PIndex+1,PLOT_LABEL,INDICATOR_NAME+"Arrow("+tmf+")");
//---    
   return(true);
  }
//+------------------------------------------------------------------+
//|                         |
//+------------------------------------------------------------------+  
void InitTsIndBuffer(uint Number,uint Plot,double &IndBuffer[],double Empty_Value,uint Draw_Begin)
  {
//---      
   SetIndexBuffer(Number,IndBuffer,INDICATOR_DATA);
//---      
   PlotIndexSetInteger(Plot,PLOT_DRAW_BEGIN,Draw_Begin);
//---   ,      
   PlotIndexSetDouble(Plot,PLOT_EMPTY_VALUE,Empty_Value);
//---       
   ArraySetAsSeries(IndBuffer,true);
//---
  }
//+------------------------------------------------------------------+
//|                         |
//+------------------------------------------------------------------+  
void InitTsIndArrBuffer(uint Number,uint Plot,double &IndBuffer[],double Empty_Value,uint Draw_Begin)
  {
//---      
   SetIndexBuffer(Number,IndBuffer,INDICATOR_DATA);
//---      
   PlotIndexSetInteger(Plot,PLOT_DRAW_BEGIN,Draw_Begin);
//---   ,      
   PlotIndexSetDouble(Plot,PLOT_EMPTY_VALUE,Empty_Value);
//---    
   PlotIndexSetInteger(Plot,PLOT_ARROW,171);
//---       
   ArraySetAsSeries(IndBuffer,true);
//---
  }
//+------------------------------------------------------------------+
//|                    |
//+------------------------------------------------------------------+  
void InitTsIndColorBuffer(uint Number,double &IndColorBuffer[])
  {
//---          
   SetIndexBuffer(Number,IndColorBuffer,INDICATOR_COLOR_INDEX);
//---       
   ArraySetAsSeries(IndColorBuffer,true);
//---
  }
//+------------------------------------------------------------------+ 
//| IndOnCalculate                                                   | 
//+------------------------------------------------------------------+ 
bool IndOnCalculate(int Number,int Limit,const datetime &Time[],uint Rates_Total,uint Prev_Calculated)
  {
//---   
   int limit_;
//---   
   datetime Time_[1],Time0;
   static int LastCountBar[INDTOTAL];
//---     
//---    limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit_=Limit;
      LastCountBar[Number]=limit_;
     }
   else limit_=int(MathMin(LastCountBar[Number]+Limit,Rates_Total-2)); //      
//---    
   for(int bar=int(limit_); bar>=0 && !IsStopped(); bar--)
     {
      //---      
      Ind[Number].m_LineBuffer[bar]=Number+1.0;
      Ind[Number].m_ArrowBuffer[bar]=EMPTY_VALUE;
      Ind[Number].m_ColorLineBuffer[bar]=EMPTY_VALUE;
      //---
      Time0=Time[bar];
      //---      
      if(CopyTime(Symbol(),Ind[Number].m_TimeFrame,Time0,1,Time_)<=0) return(RESET);
      //---
      if(Time0>=Time_[0] && Time[bar+1]<Time_[0])
        {
         LastCountBar[Number]=bar;

         double Arr[2],Sig[2];
         //---      
         if(CopyBuffer(Ind[Number].m_Handle,0,Time0,2,Arr)<=0) return(RESET);
         if(CopyBuffer(Ind[Number].m_Handle,1,Time0,2,Sig)<=0) return(RESET);
         //---
         if(Sig[0]>=Arr[0] && Sig[1]<Arr[1])
           {
            Ind[Number].m_ArrowBuffer[bar]=Number+1.0;
            Ind[Number].m_ColorArrowBuffer[bar]=1;
            Ind[Number].m_ColorLineBuffer[bar]=1;
           }
         //---
         if(Sig[0]<=Arr[0] && Sig[1]>Arr[1])
           {
            Ind[Number].m_ArrowBuffer[bar]=Number+1.0;
            Ind[Number].m_ColorArrowBuffer[bar]=0;
            Ind[Number].m_ColorLineBuffer[bar]=0;
           }
        }
      //---
      if(Ind[Number].m_ColorLineBuffer[bar+1]!=EMPTY_VALUE && Ind[Number].m_ColorLineBuffer[bar]==EMPTY_VALUE)
        {
         Ind[Number].m_ColorLineBuffer[bar]=Ind[Number].m_ColorLineBuffer[bar+1];
        }
     }
//---        
   return(true);
  }
//+------------------------------------------------------------------+   
//| Leading indicator initialization function                        | 
//+------------------------------------------------------------------+ 
int OnInit()
  {
//---     
   min_rates_total=3;
//---   
   Ind[0].m_TimeFrame=TimeFrame;
//---   
   for(int count=0; count<INDTOTAL; count++) if(!IndInit(count)) return(INIT_FAILED);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"Leading_Signal");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+ 
//| Leading iteration function                                       | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
   for(int count=0; count<INDTOTAL; count++)
      if(BarsCalculated(Ind[count].m_Handle)<Bars(Symbol(),Ind[count].m_TimeFrame))
         return(prev_calculated);
//---   
   int limit;
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
      limit=rates_total-min_rates_total-1; //      
   else limit=rates_total-prev_calculated; //       
//---         
   ArraySetAsSeries(time,true);
   for(int count=0; count<INDTOTAL; count++) if(!IndOnCalculate(count,limit,time,rates_total,prev_calculated)) return(RESET);
//---   
   return(rates_total);
  }
//+------------------------------------------------------------------+
