//+------------------------------------------------------------------+
//|                                                     i-3CCI-h.mq4 |
//|                                               johnfantom & KimIV |
//|                                              http://www.kimiv.ru |
//+------------------------------------------------------------------+
#property copyright "johnfantom & KimIV"
#property link      "http://www.kimiv.ru"

#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 DodgerBlue
#property indicator_maximum 1.4
#property indicator_level1  0
#property indicator_minimum -1.2

//-------    -------------------------------
extern int CCI_Period_0 = 14;     //  CCI   
extern int Level_0      = 100;    //  CCI   
extern int TF_1         = 60;     //    
extern int CCI_Period_1 = 14;     //  CCI   
extern int Level_1      = 100;    //  CCI   
extern int TF_2         = 240;    //    
extern int CCI_Period_2 = 14;     //  CCI   
extern int Level_2      = 100;    //  CCI   
extern int NumberOfBars = 10000;  //    (0-)

//-------   ------------------------------------------
double buf0[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void init() 
  {
   IndicatorDigits(1);

   SetIndexBuffer(0,buf0);
   SetIndexLabel(0,"i-3CCI-h");
   SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_SOLID,2);
   SetIndexEmptyValue(0,0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
void deinit() 
  {
   Comment("");
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
void start() 
  {
   double cci0,cci1,cci2;
   int    nb1,nb2;
   int    LoopBegin,sh;

   if(NumberOfBars==0) LoopBegin=Bars-1;
   else LoopBegin=NumberOfBars-1;
   LoopBegin=MathMin(Bars-1,LoopBegin);

   for(sh=LoopBegin; sh>=0; sh--) 
     {
      nb1=iBarShift(NULL, TF_1, Time[sh], False);
      nb2=iBarShift(NULL, TF_2, Time[sh], False);

      cci0=iCCI(NULL, 0   , CCI_Period_0, PRICE_CLOSE, sh);
      cci1=iCCI(NULL, TF_1, CCI_Period_1, PRICE_CLOSE, nb1);
      cci2=iCCI(NULL, TF_2, CCI_Period_2, PRICE_CLOSE, nb2);

      if(cci0>Level_0 && cci1>Level_1 && cci2>Level_2) buf0[sh]=1;
      if(cci0<-Level_0 && cci1<-Level_1 && cci2<-Level_2) buf0[sh]=-1;
     }
  }
//+------------------------------------------------------------------+
