//+----------------------------------------------------------------------------+
//|                                                          e-MovingInWL.mq4  |
//|                                                      . aka KimIV  |
//|                                                       http://www.kimiv.ru  |
//+----------------------------------------------------------------------------+
#property copyright "  . aka KimIV"
#property link      "http://www.kimiv.ru"

//-------   ----------------------------------------------------
extern int  LevelWLoss  = 1;      //  
extern int  LevelProfit = 10;     //  
extern bool ShowComment = True;   //  
extern bool SoundAlert  = True;   // 

//+----------------------------------------------------------------------------+
//|  Custor expert deinitialization function                                   |
//+----------------------------------------------------------------------------+
void deinit() { Comment(""); }
//+----------------------------------------------------------------------------+
//|  expert start function                                                     |
//+----------------------------------------------------------------------------+
void start() 
  {
   bool   fm;
   double pBid,pAsk,pp;
   int    i,nd,o=OrdersTotal();
   string comm="";

   for(i=0; i<o; i++) 
     {
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES)) 
        {
         nd=MarketInfo(OrderSymbol(), MODE_DIGITS);
         pp=MarketInfo(OrderSymbol(), MODE_POINT);
         comm=comm+OrderSymbol()+"  : "+DoubleToStr(OrderOpenPrice(),nd)+
              "  SL="+DoubleToStr(OrderStopLoss(),nd);
         if(OrderType()==OP_BUY) 
           {
            comm=comm+"("+DoubleToStr((OrderStopLoss()-OrderOpenPrice())/pp,0)+")\n";
            if(OrderStopLoss()-OrderOpenPrice()<LevelWLoss*pp) 
              {
               pBid=MarketInfo(OrderSymbol(),MODE_BID);
               if(pBid-OrderOpenPrice()>LevelProfit*pp) 
                 {
                  fm=OrderModify(OrderTicket(),OrderOpenPrice(),OrderOpenPrice()+LevelWLoss*pp,OrderTakeProfit(),CLR_NONE);
                 }
              }
           }
         if(OrderType()==OP_SELL) 
           {
            comm=comm+"("+DoubleToStr((OrderOpenPrice()-OrderStopLoss())/pp,0)+")\n";
            if(OrderStopLoss()==0 || OrderOpenPrice()-OrderStopLoss()<LevelWLoss*pp) 
              {
               pAsk=MarketInfo(OrderSymbol(),MODE_ASK);
               if(OrderOpenPrice()-pAsk>LevelProfit*pp) 
                 {
                  fm=OrderModify(OrderTicket(),OrderOpenPrice(),OrderOpenPrice()-LevelWLoss*pp,OrderTakeProfit(),CLR_NONE);
                 }
              }
           }
         if(fm) 
           {
            if(SoundAlert) PlaySound("alert2");
            break;
           }
        }
     }
   if(ShowComment) Comment(comm);
  }
//+------------------------------------------------------------------+
