//+----------------------------------------------------------------------------+
//|                                            e-CloseByLossPosInCurrency.mq4  |
//|                                                                            |
//|                                                      . aka KimIV  |
//|                                                       http://www.kimiv.ru  |
//|                                                                            |
//+----------------------------------------------------------------------------+
#property copyright "  . aka KimIV"
#property link      "http://www.kimiv.ru"


//-------    -----------------------------------------+
string _P_Expert="----------  ";
extern int    NumberAccount = 0;       //   
extern string symbol        = "";      //  
                                       //   ""  - 
//   "0" - 
extern int    Operation     = -1;      //  :
                                       //   -1 - 
//    0 - OP_BUY
//    1 - OP_SELL
extern double TargetLoss    = 50;      //    
extern int    MagicNumber   = 0;       // MagicNumber
extern bool   ShowComment   = True;    //  


//-------    -------------------------------------+
bool   gbNoInit      = False;          //   
int    Slippage      = 3;              //  
int    NumberOfTry   = 5;              //   
bool   UseSound      = True;           //   
string NameFileSound = "expert.wav";   //   
color  clCloseBuy    = Blue;           //    
color  clCloseSell   = Red;            //    

//-------    -----------------------------------------+
#include <stdlib.mqh>             //  
//+----------------------------------------------------------------------------+
//|                                                                            |
//|  ˨                                                   |
//|                                                                            |
//+----------------------------------------------------------------------------+
//|  expert initialization function                                            |
//+----------------------------------------------------------------------------+
void init() 
  {
   gbNoInit=False;
   if(!IsTradeAllowed()) 
     {
      Message("    \n"+
              "  ");
      gbNoInit=True; return;
     }
   if(!IsLibrariesAllowed()) 
     {
      Message("    \n"+
              "    ");
      gbNoInit=True; return;
     }
   if(Operation<-1 || Operation>1) 
     {
      Message("    Operation");
      gbNoInit=True; return;
     }
   if(symbol!="0" && symbol!="") 
     {
      if(MarketInfo(StringUpper(symbol),MODE_BID)==0) 
        {
         Message("     "+symbol);
         gbNoInit=True; return;
        }
     }
   if(!IsTesting()) 
     {
      if(IsExpertEnabled()) Message("    ");
      else Message("  \"  \"");
     }
   start();
  }

//+----------------------------------------------------------------------------+
//|  expert deinitialization function                                          |
//+----------------------------------------------------------------------------+
void deinit() { if(!IsTesting()) Comment(""); }
//+----------------------------------------------------------------------------+
//|  expert start function                                                     |
//+----------------------------------------------------------------------------+
void start() 
  {
   if(gbNoInit) 
     {
      Comment("   !"); return;
     }
   if(!IsTesting()) 
     {
      if(NumberAccount>0 && NumberAccount!=AccountNumber()) 
        {
         Comment("  : "+AccountNumber()+" !");
         return;
        }
      else Comment("");
      if(ShowComment) 
        {
         string st="NumberAccount="+DoubleToStr(NumberAccount,0)
                   +"  Symbol="+IIFs(symbol=="","All",IIFs(symbol=="0",Symbol(),StringUpper(symbol)))
                   +"  Operation="+IIFs(Operation<0,"All",GetNameOP(Operation))
                   +"  TargetLoss="+DoubleToStr(TargetLoss,2)+" "+AccountCurrency()
                   +"  MagicNumber="+DoubleToStr(MagicNumber,0)
                   ;
         Comment(st);
        }
      else Comment("");
     }

   ClosePosBySizeLossInCurrency(StringUpper(symbol),Operation,MagicNumber,TargetLoss);
  }
//+----------------------------------------------------------------------------+
//|                                                                            |
//|                                                     |
//|                                                                            |
//+----------------------------------------------------------------------------+
//|      :   . aka KimIV,  http://www.kimiv.ru                   |
//+----------------------------------------------------------------------------+
//|    : 19.02.2008                                                      |
//|  :                      |
//+----------------------------------------------------------------------------+
void ClosePosBySelect() 
  {
   bool   fc;
   color  clClose;
   double ll,pa,pb,pp;
   int    err,it;

   if(OrderType()==OP_BUY || OrderType()==OP_SELL) 
     {
      for(it=1; it<=NumberOfTry; it++) 
        {
         if(!IsTesting() && (!IsExpertEnabled() || IsStopped())) break;
         while(!IsTradeAllowed()) Sleep(5000);
         RefreshRates();
         pa=MarketInfo(OrderSymbol(), MODE_ASK);
         pb=MarketInfo(OrderSymbol(), MODE_BID);
         if(OrderType()==OP_BUY) 
           {
            pp=pb; clClose=clCloseBuy;
              } else {
            pp=pa; clClose=clCloseSell;
           }
         ll=OrderLots();
         fc=OrderClose(OrderTicket(), ll, pp, Slippage, clClose);
         if(fc) 
           {
            if(UseSound) PlaySound(NameFileSound); break;
              } else {
            err=GetLastError();
            if(err==146) while(IsTradeContextBusy()) Sleep(1000*11);
            Print("Error(",err,") Close ",GetNameOP(OrderType())," ",
                  ErrorDescription(err),", try ",it);
            Print(OrderTicket(),"  Ask=",pa,"  Bid=",pb,"  pp=",pp);
            Print("sy=",OrderSymbol(),"  ll=",ll,"  sl=",OrderStopLoss(),
                  "  tp=",OrderTakeProfit(),"  mn=",OrderMagicNumber());
            Sleep(1000*5);
           }
        }
     }
   else Print("  . Close ",GetNameOP(OrderType()));
  }
//+----------------------------------------------------------------------------+
//|      :   . aka KimIV,  http://www.kimiv.ru                   |
//+----------------------------------------------------------------------------+
//|     : 25.04.2008                                                     |
//|   :   ,             |
//|                                                   |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    sy -     (""   -  ,                   |
//|                                     NULL -  )                 |
//|    op -                    (-1   -  )                  |
//|    mn - MagicNumber                (-1   -  )                    |
//|    pr - /                                                      |
//+----------------------------------------------------------------------------+
void ClosePosBySizeLossInCurrency(string sy="",int op=-1,int mn=-1,double pr=0) 
  {
   int i,k=OrdersTotal();

   if(sy=="0") sy=Symbol();
   for(i=k-1; i>=0; i--) 
     {
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES)) 
        {
         if((OrderSymbol()==sy || sy=="") && (op<0 || OrderType()==op)) 
           {
            if(OrderType()==OP_BUY || OrderType()==OP_SELL) 
              {
               if(mn<0 || OrderMagicNumber()==mn) 
                 {
                  if(OrderProfit()+OrderSwap()<-MathAbs(pr)) ClosePosBySelect();
                 }
              }
           }
        }
     }
  }
//+----------------------------------------------------------------------------+
//|      :   . aka KimIV,  http://www.kimiv.ru                   |
//+----------------------------------------------------------------------------+
//|     : 01.09.2005                                                     |
//|   :                          |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    op -                                       |
//+----------------------------------------------------------------------------+
string GetNameOP(int op) 
  {
   switch(op) 
     {
      case OP_BUY      : return("Buy");
      case OP_SELL     : return("Sell");
      case OP_BUYLIMIT : return("Buy Limit");
      case OP_SELLLIMIT: return("Sell Limit");
      case OP_BUYSTOP  : return("Buy Stop");
      case OP_SELLSTOP : return("Sell Stop");
      default          : return("Unknown Operation");
     }
  }
//+----------------------------------------------------------------------------+
//|      :   . aka KimIV,  http://www.kimiv.ru                   |
//+----------------------------------------------------------------------------+
//|     : 01.02.2008                                                     |
//|   :        .      |
//+----------------------------------------------------------------------------+
string IIFs(bool condition,string ifTrue,string ifFalse) 
  {
   if(condition) return(ifTrue); else return(ifFalse);
  }
//+----------------------------------------------------------------------------+
//|      :   . aka KimIV,  http://www.kimiv.ru                   |
//+----------------------------------------------------------------------------+
//|     : 01.09.2005                                                     |
//|   :                                  |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    m -                                                       |
//+----------------------------------------------------------------------------+
void Message(string m) 
  {
   Comment(m);
   if(StringLen(m)>0) Print(m);
  }
//+----------------------------------------------------------------------------+
//|      :   . aka KimIV,  http://www.kimiv.ru                   |
//+----------------------------------------------------------------------------+
//|     : 01.09.2005                                                     |
//|   :                                |
//+----------------------------------------------------------------------------+
string StringUpper(string s) 
  {
   int c,i,k=StringLen(s),n;
   for(i=0; i<k; i++) 
     {
      n=0;
      c=StringGetChar(s, i);
      if(c>96 && c<123) n=c-32;    // a-z -> A-Z
      if(c>223 && c<256) n=c-32;   // - -> -
      if(c==184) n=168;            //    ->  
      if(n>0) s=StringSetChar(s,i,n);
     }
   return(s);
  }
//+----------------------------------------------------------------------------+
