//+----------------------------------------------------------------------------+
//|                                                          e-LOTrailing.mq4  |
//|                                                                            |
//|                                                      . aka KimIV  |
//|                                                       http://www.kimiv.ru  |
//+----------------------------------------------------------------------------+
#property copyright "  . aka KimIV"
#property link      "http://www.kimiv.ru"

//-------    -----------------------------------------+
extern bool  AllSymbols   = True;      //    
extern int   TrailingStop = 120;       //   
extern int   TrailingStep = 20;        //  
extern bool  UseSound     = True;      //   
extern bool  ShowComment  = True;      //  
extern color clModifyBuy  = Aqua;      //    
extern color clModifySell = Tomato;    //    

//-------    -------------------------------------+
bool   gbNoInit     = False;           //   
string SoundSuccess = "ok.wav";        //  
string SoundError   = "timeout.wav";   //  
int    NumberOfTry  = 3;               //   

//-------    -----------------------------------------+
#include <stdlib.mqh>             //  
//+----------------------------------------------------------------------------+
//|                                                                            |
//|  ˨                                                   |
//|                                                                            |
//+----------------------------------------------------------------------------+
//|  expert initialization function                                            |
//+----------------------------------------------------------------------------+
void init() 
  {
   gbNoInit=False;
   if(!IsTradeAllowed()) 
     {
      Comment("    \n"+
              "  ");
      gbNoInit=True; return;
     }
   if(!IsLibrariesAllowed()) 
     {
      Comment("    \n"+
              "    ");
      gbNoInit=True; return;
     }
   if(!IsTesting()) 
     {
      if(IsExpertEnabled()) Comment("    ");
      else Comment("  \"  \"");
     }
   start();
  }

//+----------------------------------------------------------------------------+
//|  expert deinitialization function                                          |
//+----------------------------------------------------------------------------+
void deinit() { if(!IsTesting()) Comment(""); }
//+----------------------------------------------------------------------------+
//|  expert start function                                                     |
//+----------------------------------------------------------------------------+
void start() 
  {
   if(gbNoInit) 
     {
      Comment("   !"); return;
     }
   if(!IsTesting()) 
     {
      if(ShowComment) 
        {
         Comment(IIFs(AllSymbols,"AllSymbols  ","")
                 ,"TrailingStop=",DoubleToStr(TrailingStop,0),".  "
                 ,"TrailingStep=",DoubleToStr(TrailingStep,0),".  "
                 ,IIFs(UseSound,"UseSound  ","")
                 );
        }
      else Comment("");
     }
   for(int i=0; i<OrdersTotal(); i++) 
     {
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES)) 
        {
         if(AllSymbols ||  OrderSymbol()==Symbol()) 
           {
            TrailingOrders();
           }
        }
     }
  }
//+----------------------------------------------------------------------------+
//|      :   . aka KimIV,  http://www.kimiv.ru                   |
//+----------------------------------------------------------------------------+
//|     : 01.09.2005                                                     |
//|   :                          |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    op -                                       |
//+----------------------------------------------------------------------------+
string GetNameOP(int op) 
  {
   switch(op) 
     {
      case OP_BUY      : return("Buy");
      case OP_SELL     : return("Sell");
      case OP_BUYLIMIT : return("BuyLimit");
      case OP_SELLLIMIT: return("SellLimit");
      case OP_BUYSTOP  : return("BuyStop");
      case OP_SELLSTOP : return("SellStop");
      default          : return("Unknown Operation");
     }
  }
//+----------------------------------------------------------------------------+
//|      :   . aka KimIV,  http://www.kimiv.ru                   |
//+----------------------------------------------------------------------------+
//|     : 18.07.2008                                                     |
//|   :        .      |
//+----------------------------------------------------------------------------+
color IIFc(bool condition,color ifTrue,color ifFalse) 
  {
   if(condition) return(ifTrue); else return(ifFalse);
  }
//+----------------------------------------------------------------------------+
//|      :   . aka KimIV,  http://www.kimiv.ru                   |
//+----------------------------------------------------------------------------+
//|     : 01.02.2008                                                     |
//|   :        .      |
//+----------------------------------------------------------------------------+
string IIFs(bool condition,string ifTrue,string ifFalse) 
  {
   if(condition) return(ifTrue); else return(ifFalse);
  }
//+----------------------------------------------------------------------------+
//|      :   . aka KimIV,  http://www.kimiv.ru                   |
//+----------------------------------------------------------------------------+
//|     : 28.11.2006                                                     |
//|   :     .           |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    pp -                                                 |
//|    sl -                                                 |
//|    tp -                                                 |
//|    ex -                                                       |
//+----------------------------------------------------------------------------+
void ModifyOrder(double pp=-1,double sl=0,double tp=0,datetime ex=0) 
  {
   bool   fm;
   color  cl=IIFc(OrderType()==OP_BUY
                  || OrderType()==OP_BUYLIMIT
                  || OrderType()==OP_BUYSTOP, clModifyBuy, clModifySell);
   double op,pa,pb,os,ot;
   int    dg=MarketInfo(OrderSymbol(),MODE_DIGITS),er,it;

   if(pp<=0) pp=OrderOpenPrice();
   if(sl<0 ) sl=OrderStopLoss();
   if(tp<0 ) tp=OrderTakeProfit();

   pp=NormalizeDouble(pp, dg);
   sl=NormalizeDouble(sl, dg);
   tp=NormalizeDouble(tp, dg);
   op=NormalizeDouble(OrderOpenPrice() , dg);
   os=NormalizeDouble(OrderStopLoss()  , dg);
   ot=NormalizeDouble(OrderTakeProfit(), dg);

   if(pp!=op || sl!=os || tp!=ot) 
     {
      for(it=1; it<=NumberOfTry; it++) 
        {
         if(!IsTesting() && (!IsExpertEnabled() || IsStopped())) break;
         while(!IsTradeAllowed()) Sleep(5000);
         RefreshRates();
         fm=OrderModify(OrderTicket(),pp,sl,tp,ex,cl);
         if(fm) 
           {
            if(UseSound) PlaySound(SoundSuccess); break;
              } else {
            er=GetLastError();
            if(UseSound) PlaySound(SoundError);
            pa=MarketInfo(OrderSymbol(), MODE_ASK);
            pb=MarketInfo(OrderSymbol(), MODE_BID);
            Print("Error(",er,") modifying order: ",ErrorDescription(er),", try ",it);
            Print("Ask=",pa,"  Bid=",pb,"  sy=",OrderSymbol(),
                  "  op="+GetNameOP(OrderType()),"  pp=",pp,"  sl=",sl,"  tp=",tp);
            Sleep(1000*10);
           }
        }
     }
  }
//+----------------------------------------------------------------------------+
//|                                           |
//+----------------------------------------------------------------------------+
void TrailingOrders() 
  {
   double di,pa,pb,pp,sl,tp;

   pp=MarketInfo(OrderSymbol(),MODE_POINT);
   if(OrderType()==OP_SELLLIMIT) 
     {
      pa=MarketInfo(OrderSymbol(),MODE_BID);
      if(OrderOpenPrice()-pa>(TrailingStop+TrailingStep-1)*pp) 
        {
         di=OrderOpenPrice()-pa-TrailingStop*pp;
         if(OrderStopLoss()  >0) sl=OrderStopLoss()  -di; else sl=0;
         if(OrderTakeProfit()>0) tp=OrderTakeProfit()-di; else tp=0;
         ModifyOrder(pa+TrailingStop*pp,sl,tp);
        }
     }
   if(OrderType()==OP_BUYLIMIT) 
     {
      pb=MarketInfo(OrderSymbol(),MODE_ASK);
      if(pb-OrderOpenPrice()>(TrailingStop+TrailingStep-1)*pp) 
        {
         di=pb-OrderOpenPrice()-TrailingStop*pp;
         if(OrderStopLoss()  >0) sl=OrderStopLoss()  +di; else sl=0;
         if(OrderTakeProfit()>0) tp=OrderTakeProfit()+di; else tp=0;
         ModifyOrder(pb-TrailingStop*pp,sl,tp);
        }
     }
  }
//+------------------------------------------------------------------+
