//+----------------------------------------------------------------------------+
//|                                                            i-AnyRange.mq4  |
//|                                                      . aka KimIV  |
//|                                                       http://www.kimiv.ru  |
//|                                                                            |
//|                                                                            |
//+----------------------------------------------------------------------------+
#property copyright "  . aka KimIV"
#property link      "http://www.kimiv.ru"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 LightBlue
#property indicator_color2 Salmon
#property indicator_width1 2
#property indicator_width2 2

//-------    -----------------------------------------
extern string Time1 = "02:00";    //   1
extern string Time2 = "07:00";    //   2
extern int    nDays = 2;          //    (0-)

//-------   ------------------------------------------------

//-------    -------------------------------------------

//-------   ----------------------------------------------------
double dBuf0[],dBuf1[];
//+----------------------------------------------------------------------------+
//|  Custom indicator initialization function                                  |
//+----------------------------------------------------------------------------+
void init() 
  {
   SetIndexBuffer(0,dBuf0);
   SetIndexEmptyValue(0,EMPTY_VALUE);
   SetIndexStyle(0,DRAW_LINE);

   SetIndexBuffer(1,dBuf1);
   SetIndexEmptyValue(1,EMPTY_VALUE);
   SetIndexStyle(1,DRAW_LINE);
  }

//+----------------------------------------------------------------------------+
//|  Custom indicator deinitialization function                                |
//+----------------------------------------------------------------------------+
void deinit() { Comment(""); }
//+----------------------------------------------------------------------------+
//|  Custom indicator iteration function                                       |
//+----------------------------------------------------------------------------+
void start() 
  {
   double up,dn;
   int    i,LoopBegin,kd=0,nb1,nb2,nd=0;
   string sdt;

   if(Period()>PERIOD_H1) 
     {
      Comment(" i-AnyRange    H4!"); return;
     }
   else Comment("");

   if(nDays==0) LoopBegin=Bars-10;
   else LoopBegin=nDays*1440/Period();
   LoopBegin=MathMin(Bars-10,LoopBegin);

   for(i=0; i<LoopBegin; i++) 
     {
      if(nd!=TimeDay(Time[i])) 
        {
         nd=TimeDay(Time[i]);
         kd++;
         if(kd>nDays && nDays>0) return;
         sdt=TimeToStr(Time[i], TIME_DATE);
         nb1=iBarShift(NULL, 0, StrToTime(sdt+" "+Time1));
         nb2=iBarShift(NULL, 0, StrToTime(sdt+" "+Time2));
         if(nb1>nb2+1) 
           {
            up=High[iHighest(NULL, 0, MODE_HIGH, nb1-nb2, nb2+1)];
            dn=Low [iLowest (NULL, 0, MODE_LOW , nb1-nb2, nb2+1)];
           }
         if(nb2>nb1+1) 
           {
            up=High[iHighest(NULL, 0, MODE_HIGH, nb2-nb1, nb1+1)];
            dn=Low [iLowest (NULL, 0, MODE_LOW , nb2-nb1, nb1+1)];
           }
        }
      if((nb1>=i && i>nb2) || (nb2>=i && i>nb1)) 
        {
         dBuf0[i]=up;
         dBuf1[i]=dn;
           } else {
         dBuf0[i]=EMPTY_VALUE;
         dBuf1[i]=EMPTY_VALUE;
        }
     }
  }
//+----------------------------------------------------------------------------+
