//+------------------------------------------------------------------+
//|                                                      TestLib.mq5 |
//|                        Copyright 2014, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2014, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
#include <tallyup.mqh>
//+------------------------------------------------------------------+
//| Scan Closed Trades                                               |
//+------------------------------------------------------------------+
double ScanClosedTrades()
  {
   CTallyUp Tally;

   HistorySelect(0,TimeCurrent());
   int  a = 0;
   int  b = 0;
   int  c;
   int  d;
   int    deals      = HistoryDealsTotal();
   ulong  ticket     = HistoryDealGetTicket(deals-1);
   double profit     = 0;
   if(ticket>0)
     {
      profit=HistoryDealGetDouble(ticket,DEAL_PROFIT);

      if(profit<0)
        {
         a++;
           {
            Print("Losses Value :",a);//losses)
            Print("Loss Added, Profit:",profit);//profit);
           }
        }
      else
        {
         b++;
           {
            Print("Wins Value :",b);//wins)
            Print("Win Added, Profit:",profit);//profit);
           }
        }
      if(a==1)
        {
         Tally.AddLoss();
         c=Tally.GetLoss();
         Print("Current Loss Tally :",c);//Loss Tally)
        }
      if(b==1)
        {
         Tally.AddWin();
         d=Tally.GetWin();
         Print("Current Win Tally :",d);//Win Tally)
        }
     }
   else
     {
      PrintFormat("In total, in the history %d of deals, we couldn't select a deal"+
                  " with the index %d. Error %d",deals,ticket,GetLastError());
     }

   return(profit);
  }
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   ScanClosedTrades();
  }
//+------------------------------------------------------------------+
