//+------------------------------------------------------------------+
//|                                          #!Postzigzagv2Close.mq4 |
//|                                    Copyright @2011, Rockyhoangdn |
//|                                           rockyhoangdn@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2011, rockyhoangdn"
#property link      "mailto:rockyhoangdn@gmail.com"
#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1 Red
#property indicator_color2 RoyalBlue
#property indicator_color3 Yellow
#property indicator_width1  2
#property indicator_width2  1
#property indicator_width3  1

//---- indicator parameters
extern int ExtDepth=12;
extern int ExtDeviation=5;
extern int ExtBackstep=3;
//---- indicator buffers
double ZigzagBuffer[];
double HighMapBuffer[];
double LowMapBuffer[];
double TopBuffer[];
double BotomBuffer[];
int level=3; // recounting's depth 
bool downloadhistory=false;
string trend="";
string TOP_BOTText[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   IndicatorBuffers(5);
//---- drawing settings
   SetIndexStyle(0,DRAW_SECTION);
   SetIndexStyle(3,DRAW_SECTION);
   SetIndexStyle(4,DRAW_SECTION);

//---- indicator buffers mapping
   SetIndexBuffer(0,ZigzagBuffer);
   SetIndexBuffer(1,HighMapBuffer);
   SetIndexBuffer(2,LowMapBuffer);
   SetIndexBuffer(3,BotomBuffer);
   SetIndexBuffer(4,TopBuffer);
   SetIndexEmptyValue(0,0.0);

//---- indicator short name
   IndicatorShortName("ZigZag("+ExtDepth+","+ExtDeviation+","+ExtBackstep+")");
//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit() 
  {
   ObjectsDeleteAll(0,OBJ_TEXT);
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int start()
  {
//----
   int i,counted_bars=IndicatorCounted();
   int limit,counterZ,whatlookfor;
   int shift,back,lasthighpos,lastlowpos;
   double val,res;
   double curlow,curhigh,lasthigh,lastlow;

   if(counted_bars==0 && downloadhistory) // history was downloaded
     {
      ArrayInitialize(ZigzagBuffer,0.0);
      ArrayInitialize(HighMapBuffer,0.0);
      ArrayInitialize(LowMapBuffer,0.0);
      //ArrayInitialize(TopBuffer,0.0);
      //ArrayInitialize(BotomBuffer,0.0);
     }
   if(counted_bars==0)
     {
      limit=Bars-ExtDepth;
      downloadhistory=true;
     }
   if(counted_bars>0)
     {
      while(counterZ<level && i<100)
        {
         res=ZigzagBuffer[i];
         if(res!=0) counterZ++;
         i++;
        }
      i--;
      limit=i;
      if(LowMapBuffer[i]!=0)
        {
         curlow=LowMapBuffer[i];
         whatlookfor=1;
        }
      else
        {
         curhigh=HighMapBuffer[i];
         whatlookfor=-1;
        }
      for(i=limit-1;i>=0;i--)
        {
         ZigzagBuffer[i]=0.0;
         LowMapBuffer[i]=0.0;
         HighMapBuffer[i]=0.0;
        }
     }

   for(shift=limit; shift>=0; shift--)
     {
      val=Low[iLowest(NULL,0,MODE_CLOSE,ExtDepth,shift)];
      if(val==lastlow) val=0.0;
      else
        {
         lastlow=val;
         if((Low[shift]-val)>(ExtDeviation*Point)) val=0.0;
         else
           {
            for(back=1; back<=ExtBackstep; back++)
              {
               res=LowMapBuffer[shift+back];
               if((res!=0) && (res>val)) LowMapBuffer[shift+back]=0.0;
              }
           }
        }
      if(Low[shift]==val) LowMapBuffer[shift]=val; else LowMapBuffer[shift]=0.0;
      //--- high
      val=High[iHighest(NULL,0,MODE_CLOSE,ExtDepth,shift)];
      if(val==lasthigh) val=0.0;
      else
        {
         lasthigh=val;
         if((val-High[shift])>(ExtDeviation*Point)) val=0.0;
         else
           {
            for(back=1; back<=ExtBackstep; back++)
              {
               res=HighMapBuffer[shift+back];
               if((res!=0) && (res<val)) HighMapBuffer[shift+back]=0.0;
              }
           }
        }
      if(High[shift]==val) HighMapBuffer[shift]=val; else HighMapBuffer[shift]=0.0;
     }

// final cutting 
   if(whatlookfor==0)
     {
      lastlow=0;
      lasthigh=0;
     }
   else
     {
      lastlow=curlow;
      lasthigh=curhigh;
     }
   for(shift=limit;shift>=0;shift--)
     {
      res=0.0;
      switch(whatlookfor)
        {
         case 0: // look for peak or lawn 
            if(lastlow==0 && lasthigh==0)
              {
               if(HighMapBuffer[shift]!=0)
                 {
                  lasthigh=High[shift];
                  lasthighpos=shift;
                  whatlookfor=-1;
                  ZigzagBuffer[shift]=lasthigh;
                  TopBuffer[shift]=lasthigh+0;
                  trend="down";
                  res=1;
                 }
               if(LowMapBuffer[shift]!=0)
                 {
                  lastlow=Low[shift];
                  lastlowpos=shift;
                  whatlookfor=1;
                  ZigzagBuffer[shift]=lastlow;
                  BotomBuffer[shift]=lastlow+0;
                  trend="up";
                  res=1;
                 }
              }
            break;
         case 1: // look for peak
            if(LowMapBuffer[shift]!=0.0 && LowMapBuffer[shift]<lastlow && HighMapBuffer[shift]==0.0)
              {
               ZigzagBuffer[lastlowpos]=0.0;
               //BotomBuffer[lastlowpos]=0.0;
               lastlowpos=shift;
               lastlow=LowMapBuffer[shift];
               ZigzagBuffer[shift]=lastlow;
               BotomBuffer[shift]=lastlow+0;
               trend="up";
               res=1;
              }
            if(HighMapBuffer[shift]!=0.0 && LowMapBuffer[shift]==0.0)
              {
               lasthigh=HighMapBuffer[shift];
               lasthighpos=shift;
               ZigzagBuffer[shift]=lasthigh;
               TopBuffer[shift]=lasthigh+0;
               trend="down";
               whatlookfor=-1;
               res=1;
              }
            break;
         case -1: // look for lawn
            if(HighMapBuffer[shift]!=0.0 && HighMapBuffer[shift]>lasthigh && LowMapBuffer[shift]==0.0)
              {
               ZigzagBuffer[lasthighpos]=0.0;
               //TopBuffer[lasthighpos]=0.0;

               lasthighpos=shift;
               lasthigh=HighMapBuffer[shift];
               ZigzagBuffer[shift]=lasthigh;
               TopBuffer[shift]=lasthigh+0;
               trend="down";
              }
            if(LowMapBuffer[shift]!=0.0 && HighMapBuffer[shift]==0.0)
              {
               lastlow=LowMapBuffer[shift];
               lastlowpos=shift;
               ZigzagBuffer[shift]=lastlow;

               BotomBuffer[shift]=lastlow+0;
               trend="up";
               whatlookfor=1;
              }
            break;
         default: return(0);
        }
     }

   ArrayResize(TOP_BOTText,Bars);
   for(int j=0; j<Bars; j++)
     {
      TOP_BOTText[j]="pattern-"+j;
     }
   for(shift=limit;shift>=0;shift--)
     {
      if((BotomBuffer[shift]==0 && TopBuffer[shift]!=0) || BotomBuffer[shift]==LowMapBuffer[shift])
        {
         ObjectCreate(TOP_BOTText[shift],OBJ_TEXT,0,Time[shift],Low[shift]-(High[shift]-Low[shift])/2);
         ObjectSetText(TOP_BOTText[shift]," Lawn ",9,"Times New Roman",Lime);
        }

      if((BotomBuffer[shift]!=0 && TopBuffer[shift]==0) || TopBuffer[shift]==HighMapBuffer[shift])
        {
         ObjectCreate(TOP_BOTText[shift],OBJ_TEXT,0,Time[shift],High[shift]+(High[shift]-Low[shift])/2);
         ObjectSetText(TOP_BOTText[shift]," Peak ",9,"Times New Roman",Red);
        }
     }
   WindowRedraw();
//----
   return(0);
  }
//+------------------------------------------------------------------+
