//+------------------------------------------------------------------+
//|                                             MultiSignals_PCH.mq5 |
//+------------------------------------------------------------------+
#property copyright   "Copyright 2012, tol64."
#property link        "https://login.mql5.com/ru/users/tol64"
#property description "email: hello.tol64@gmail.com"
#property version     "1.00"
//#property icon        "\\Images\\logoMultiSignals_PCH_64x64.ico"

// Properties
#property indicator_chart_window
//---
#property indicator_buffers 5
#property indicator_plots   5

// LEVELS
#property indicator_type1   DRAW_LINE
#property indicator_type2   DRAW_LINE
#property indicator_type3   DRAW_LINE
#property indicator_type4   DRAW_LINE
#property indicator_type5   DRAW_LINE

// STYLES
#property indicator_style1 STYLE_SOLID
#property indicator_style2 STYLE_SOLID
#property indicator_style3 STYLE_DOT
#property indicator_style4 STYLE_DOT
#property indicator_style5 STYLE_DOT

// COLORS MAIN LEVELS
#property indicator_color1 clrGold        // H
#property indicator_color2 clrGreenYellow // L
#property indicator_color3 clrSilver
#property indicator_color4 clrSilver
#property indicator_color5 clrSilver

//---------------------------------------------------------------
#property indicator_label1  "Channel upper"
#property indicator_label2  "Channel lower"
#property indicator_label3  "Channel median"
#property indicator_label4  "Channel UPmedian"
#property indicator_label5  "Channel DWmedian"
//---
#define szArr 5

//--- input parameters
input int  Period_PCH=10; // Period
//---
int j=0;
//---
double High_Buffer[],Low_Buffer[],Mid_Buffer[],High_Mid_Buffer[],Low_Mid_Buffer[]; // Buffers of Lines
//---
int ArrayPlotShift[szArr],ArrayPlotDrawBegin[szArr],ArrayPlotEmptyValue[szArr],ArrayPlotLineWidth[szArr];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,High_Buffer,INDICATOR_DATA);
   SetIndexBuffer(1,Low_Buffer,INDICATOR_DATA);
   SetIndexBuffer(2,Mid_Buffer,INDICATOR_DATA);
   SetIndexBuffer(3,High_Mid_Buffer,INDICATOR_DATA);
   SetIndexBuffer(4,Low_Mid_Buffer,INDICATOR_DATA);
   
//---

// Accuracy of values
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits-1);

// Starting point for drawing
   for(j=0; j<szArr; j++) { PlotIndexSetInteger(j,PLOT_DRAW_BEGIN,Period_PCH); }

// Shifting lines along the X-axis
   for(j=0; j<szArr; j++) { PlotIndexSetInteger(j,PLOT_SHIFT,1); }

// Line thickness
   for(j=0; j<szArr; j++) { PlotIndexSetInteger(j,PLOT_LINE_WIDTH,1); }
//---
//--- name for DataWindow and indicator label
   IndicatorSetString(INDICATOR_SHORTNAME,"MultiRanges_PCH ("+string(Period_PCH)+")");
//---
   PlotIndexSetString(0,PLOT_LABEL,"H_PCH (0)");
   PlotIndexSetString(1,PLOT_LABEL,"L_PCH (1)");
   PlotIndexSetString(2,PLOT_LABEL,"M_PCH (2)");
   PlotIndexSetString(3,PLOT_LABEL,"MH_PCH (3)");
   PlotIndexSetString(4,PLOT_LABEL,"ML_PCH (4)");
//---
// Clear dots with empty values
   for(j=0; j<szArr; j++) { PlotIndexSetDouble(j,PLOT_EMPTY_VALUE,EMPTY_VALUE); }
  }
//+------------------------------------------------------------------+
//| Price Channel                                                    |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &Time[],
                const double &Open[],
                const double &High[],
                const double &Low[],
                const double &Close[],
                const long &TickVolume[],
                const long &Volume[],
                const int &Spread[])
  {
   int i=0,limit=0;

//--- check for rates
   if(rates_total<Period_PCH) { return(0); }

//--- preliminary calculations
   if(prev_calculated==0) { limit=Period_PCH; } else { limit=prev_calculated-1; }

//--- the main loop of calculations
   for(i=limit; i<rates_total; i++)
     {
      //+------------------------------------------------------------------+
      //| INDICATORS_BUFFERS                                               |
      //+------------------------------------------------------------------+
      High_Buffer[i]=Highest(High,Period_PCH,i);
      Low_Buffer[i]=Lowest(Low,Period_PCH,i);
      Mid_Buffer[i]=(High_Buffer[i]+Low_Buffer[i])/2.0;
      //---
      High_Mid_Buffer[i]=(Mid_Buffer[i]+High_Buffer[i])/2.0;
      Low_Mid_Buffer[i]=(Low_Buffer[i]+Mid_Buffer[i])/2.0;
     }
//--- OnCalculate done. Return new prev_calculated.
   return(rates_total);
  }
//+------------------------------------------------------------------+
//| get highest value for range                                      |
//+------------------------------------------------------------------+
double Highest(const double &array[],int range,int fromIndex)
  {
   int i=0;
   double res;
//---
   res=array[fromIndex];
//---
   for(i=fromIndex; i>fromIndex-range && i>=0; i--)
     {
      if(res<array[i]) res=array[i];
     }
//---
   return(res);
  }
//+------------------------------------------------------------------+
//| get lowest value for range                                       |
//+------------------------------------------------------------------+
double Lowest(const double &array[],int range,int fromIndex)
  {
   int i=0;
   double res;
//---
   res=array[fromIndex];
//---
   for(i=fromIndex;i>fromIndex-range && i>=0;i--)
     {
      if(res>array[i]) res=array[i];
     }
//---
   return(res);
  }
//+------------------------------------------------------------------+
//| ADJUSTING THE VALUE BASED ON THE NUMBER OF DIGITS IN THE PRICE   |
//| MULTIPLICATION                                                   |
//+------------------------------------------------------------------+
//| [] - int value                                                   |
//+------------------------------------------------------------------+
int vDgtMlt(int value)
  {
   if(_Digits==3 || _Digits==5) { return(value*=10); } else { return(value); }
  }
//+------------------------------------------------------------------+
