//+------------------------------------------------------------------------------+
//|                                                      GetIndicatorBuffers.mqh |
//|                                                       Copyright 2010, DC2008 |
//|                                       https://login.mql5.com/ru/users/DC2008 |
//+------------------------------------------------------------------------------+
#property copyright "Copyright 2010, DC2008"
#property link      "https://login.mql5.com/ru/users/DC2008"
//+------------------------------------------------------------------------------+
//| copying indicator values to an array based on the index order                |
//+------------------------------------------------------------------------------+
bool CopyBufferAsSeries(
                        int handle,      // indicator handle
                        int bufer,       // number of the indicator buffer
                        int start,       // from where to start
                        int number,      // how many to copy
                        bool asSeries,   // array index order
                        double &M[]      // array to which data will be copied
                        )
  {
//--- filling the M array with current indicator values
   if(CopyBuffer(handle,bufer,start,number,M)<=0) return(false);
//--- set the M array index order
//--- if asSeries=true, the M array index order is as time series
//--- if asSeries=false, the M array has default index order
   ArraySetAsSeries(M,asSeries);
//---
   return(true);
  }
//+------------------------------------------------------------------------------+
//| copying ADX indicator values to arrays based on indexing                     |
//+------------------------------------------------------------------------------+
bool GetADXBuffers(int ADX_handle,
                   int start,
                   int number,
                   double &Main[],
                   double &PlusDI[],
                   double &MinusDI[],
                   bool asSeries=true  // indexing as time series
                   )
  {
//--- filling the Main array with the current values of MAIN_LINE
   if(!CopyBufferAsSeries(ADX_handle,0,start,number,asSeries,Main)) return(false);
//--- filling the PlusDI array with the current values of PLUSDI_LINE
   if(!CopyBufferAsSeries(ADX_handle,1,start,number,asSeries,PlusDI)) return(false);
//--- filling the MinusDI array with the current values of MINUSDI_LINE
   if(!CopyBufferAsSeries(ADX_handle,2,start,number,asSeries,MinusDI)) return(false);
//---
   return(true);
  }
//+------------------------------------------------------------------------------+
//| copying ADXWilder indicator values to arrays based on indexing               |
//+------------------------------------------------------------------------------+
bool GetADXWilderBuffers(int ADXWilder_handle,
                         int start,
                         int number,
                         double &Main[],
                         double &PlusDI[],
                         double &MinusDI[],
                         bool asSeries=true  // indexing as time series
                         )
  {
//--- filling the Main array with the current values of MAIN_LINE
   if(!CopyBufferAsSeries(ADXWilder_handle,0,start,number,asSeries,Main)) return(false);
//--- filling the PlusDI array with the current values of PLUSDI_LINE
   if(!CopyBufferAsSeries(ADXWilder_handle,1,start,number,asSeries,PlusDI)) return(false);
//--- filling the MinusDI array with the current values of MINUSDI_LINE
   if(!CopyBufferAsSeries(ADXWilder_handle,2,start,number,asSeries,MinusDI)) return(false);
//---
   return(true);
  }
//+------------------------------------------------------------------------------+
//| copying Alligator indicator values to arrays based on indexing               |
//+------------------------------------------------------------------------------+
bool GetAlligatorBuffers(int Alligator_handle,
                         int start,
                         int number,
                         double &Jaws[],
                         double &Teeth[],
                         double &Lips[],
                         bool asSeries=true  // indexing as time series
                         )
  {
//--- filling the Jaws array with the current values of GATORJAW_LINE
   if(!CopyBufferAsSeries(Alligator_handle,0,start,number,asSeries,Jaws)) return(false);
//--- filling the Teeth array with the current values of GATORTEETH_LINE
   if(!CopyBufferAsSeries(Alligator_handle,1,start,number,asSeries,Teeth)) return(false);
//--- filling the Lips array with the current values of GATORLIPS_LINE
   if(!CopyBufferAsSeries(Alligator_handle,2,start,number,asSeries,Lips)) return(false);
//---
   return(true);
  }
//+------------------------------------------------------------------------------+
//| copying Bands indicator values to arrays based on indexing                   |
//+------------------------------------------------------------------------------+
bool GetBandsBuffers(int Bands_handle,
                     int start,
                     int number,
                     double &Base[],
                     double &Upper[],
                     double &Lower[],
                     bool asSeries=true  // indexing as time series
                     )
  {
//--- filling the Base array with the current values of BASE_LINE
   if(!CopyBufferAsSeries(Bands_handle,0,start,number,asSeries,Base)) return(false);
//--- filling the Upper array with the current values of UPPER_BAND
   if(!CopyBufferAsSeries(Bands_handle,1,start,number,asSeries,Upper)) return(false);
//--- filling the Lower array with the current values of LOWER_BAND
   if(!CopyBufferAsSeries(Bands_handle,2,start,number,asSeries,Lower)) return(false);
//---
   return(true);
  }
//+------------------------------------------------------------------------------+
//| copying Envelopes indicator values to arrays based on indexing               |
//+------------------------------------------------------------------------------+
bool GetEnvelopesBuffers(int Envelopes_handle,
                         int start,
                         int number,
                         double &Upper[],
                         double &Lower[],
                         bool asSeries=true       // indexing as time series
                         )
  {
//--- filling the Upper array with the current values of UPPER_LINE
   if(!CopyBufferAsSeries(Envelopes_handle,0,start,number,asSeries,Upper)) return(false);
//--- filling the Lower array with the current values of LOWER_LINE
   if(!CopyBufferAsSeries(Envelopes_handle,1,start,number,asSeries,Lower)) return(false);
//---
   return(true);
  }
//+------------------------------------------------------------------------------+
//| copying Fractals indicator values to arrays based on indexing                |
//+------------------------------------------------------------------------------+
bool GetFractalsBuffers(int Fractals_handle,
                        int start,
                        int number,
                        double &Upper[],
                        double &Lower[],
                        bool asSeries=true       // indexing as time series
                        )
  {
//--- filling the Upper array with the current values of UPPER_LINE
   if(!CopyBufferAsSeries(Fractals_handle,0,start,number,asSeries,Upper)) return(false);
//--- filling the Lower array with the current values of LOWER_LINE
   if(!CopyBufferAsSeries(Fractals_handle,1,start,number,asSeries,Lower)) return(false);
//---
   return(true);
  }
//+------------------------------------------------------------------------------+
//| copying Gator indicator values to arrays based on indexing                   |
//+------------------------------------------------------------------------------+
bool GetGatorBuffers(int Gator_handle,
                     int start,
                     int number,
                     double &Upper[],
                     double &Lower[],
                     bool asSeries=true       // indexing as time series
                     )
  {
//--- filling the Upper array with the current values of UPPER_LINE
   if(!CopyBufferAsSeries(Gator_handle,0,start,number,asSeries,Upper)) return(false);
//--- filling the Lower array with the current values of LOWER_LINE
   if(!CopyBufferAsSeries(Gator_handle,1,start,number,asSeries,Lower)) return(false);
//---
   return(true);
  }
//+------------------------------------------------------------------------------+
//| copying Ichimoku indicator values to arrays based on indexing                |
//+------------------------------------------------------------------------------+
bool GetIchimokuBuffers(int Ichimoku_handle,
                        int start,
                        int number,
                        double &Tenkansen[],
                        double &Kijunsen[],
                        double &SenkouspanA[],
                        double &SenkouspanB[],
                        double &Chinkouspan[],
                        bool asSeries=true       // indexing as time series
                        )
  {
//--- filling the Tenkansen array with the current values of TENKANSEN_LINE
   if(!CopyBufferAsSeries(Ichimoku_handle,0,start,number,asSeries,Tenkansen)) return(false);
//--- filling the Kijunsen array with the current values of KIJUNSEN_LINE
   if(!CopyBufferAsSeries(Ichimoku_handle,1,start,number,asSeries,Kijunsen)) return(false);
//--- filling the SenkouspanA array with the current values of SENKOUSPANA_LINE
   if(!CopyBufferAsSeries(Ichimoku_handle,2,start,number,asSeries,SenkouspanA)) return(false);
//--- filling the SenkouspanB array with the current values of SENKOUSPANB_LINE
   if(!CopyBufferAsSeries(Ichimoku_handle,3,start,number,asSeries,SenkouspanB)) return(false);
//--- filling the Chinkouspan array with the current values of CHINKOUSPAN_LINE
   if(!CopyBufferAsSeries(Ichimoku_handle,4,start,number,asSeries,Chinkouspan)) return(false);
//---
   return(true);
  }
//+------------------------------------------------------------------------------+
//| copying MACD indicator values to arrays based on indexing                    |
//+------------------------------------------------------------------------------+
bool GetMACDBuffers(int MACD_handle,
                    int start,
                    int number,
                    double &Main[],
                    double &Signal[],
                    bool asSeries=true       // indexing as time series
                    )
  {
//--- filling the Main array with the current values of MAIN_LINE
   if(!CopyBufferAsSeries(MACD_handle,0,start,number,asSeries,Main)) return(false);
//--- filling the Signal array with the current values of SIGNAL_LINE
   if(!CopyBufferAsSeries(MACD_handle,1,start,number,asSeries,Signal)) return(false);
//---
   return(true);
  }
//+------------------------------------------------------------------------------+
//| copying RVI indicator values to arrays based on indexing                     |
//+------------------------------------------------------------------------------+
bool GetRVIBuffers(int RVI_handle,
                   int start,
                   int number,
                   double &Main[],
                   double &Signal[],
                   bool asSeries=true       // indexing as time series
                   )
  {
//--- filling the Main array with the current values of MAIN_LINE
   if(!CopyBufferAsSeries(RVI_handle,0,start,number,asSeries,Main)) return(false);
//--- filling the Signal array with the current values of SIGNAL_LINE
   if(!CopyBufferAsSeries(RVI_handle,1,start,number,asSeries,Signal)) return(false);
//---
   return(true);
  }
//+------------------------------------------------------------------------------+
//| copying Stochastic indicator values to arrays based on indexing              |
//+------------------------------------------------------------------------------+
bool GetStochasticBuffers(int Stochastic_handle,
                          int start,
                          int number,
                          double &Main[],
                          double &Signal[],
                          bool asSeries=true       // indexing as time series
                          )
  {
//--- filling the Main array with the current values of MAIN_LINE
   if(!CopyBufferAsSeries(Stochastic_handle,0,start,number,asSeries,Main)) return(false);
//--- filling the Signal array with the current values of SIGNAL_LINE
   if(!CopyBufferAsSeries(Stochastic_handle,1,start,number,asSeries,Signal)) return(false);
//---
   return(true);
  }
//+------------------------------------------------------------------------------+
