//+------------------------------------------------------------------+
//|                                                     ClassWin.mqh |
//|                                                 Copyright DC2008 |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "DC2008"
#property link      "http://www.mql5.com"
//--- Declaration of constants
#define  B_WIN       150   // default window width
//--- include classes
#include <ClassRow.mqh>
//+------------------------------------------------------------------+
///Base CWin class (WINDOW)
//+------------------------------------------------------------------+
class CWin
  {
private:
   void              SetXY(int m_corner); //Coordinates
protected:
   bool              on_event;   // event processing flag
public:
   string            name;       // window name
   int               w_corner;   // window corner
   int               w_xdelta;   // vertical delta
   int               w_ydelta;   // horizontal detla
   int               w_xpos;     // X coordinate
   int               w_ypos;     // Y coordinate
   int               w_bsize;    // Window width
   int               w_hsize;    // Window height
   int               w_h_corner; // hide mode corner
   WinCell           Property;   // Property
   //---
   CRowType1         STR1;       // CRowType1
   CRowType2         STR2;       // CRowType2
   CRowType3         STR3;       // CRowType3
   CRowType4         STR4;       // CRowType4
   CRowType5         STR5;       // CRowType5
   CRowType6         STR6;       // CRowType6
   //+---------------------------------------------------------------+
   ///Class constructor
   void              CWin();
   ///Set window properties
   void              SetWin(string m_name,
                            int m_xdelta,
                            int m_ydelta,
                            int m_bsize,
                            int m_corner);
   virtual     ///Draw window method
   void              Draw(int &MMint[][3],
                          string &MMstr[][3],
                          int count);
   virtual     ///OnEventTick handler
   void              OnEventTick();
   virtual     ///OnChartEvent handler
   void              OnEvent(const int id,
                             const long &lparam,
                             const double &dparam,
                             const string &sparam);
  };
//+------------------------------------------------------------------+
///CWin class constructor
//+------------------------------------------------------------------+
void CWin::CWin()
  {
   Property.TextColor=White;
   Property.BGColor=SteelBlue;
   Property.BGEditColor=DimGray;
   Property.Corner=CORNER_LEFT_UPPER;
   Property.Corn=1;
   Property.H=18;
   on_event=false;   //disable events processing
  }
//+------------------------------------------------------------------+
///CWin class Draw method
//+------------------------------------------------------------------+
void CWin::SetWin(string m_name,
                  int m_xdelta,
                  int m_ydelta,
                  int m_bsize,
                  int m_corner)
  {
   name=m_name;
//---
   if(m_corner==CORNER_LEFT_UPPER) w_corner=m_corner;
   else
      if(m_corner==CORNER_RIGHT_UPPER) w_corner=m_corner;
   else
      if(m_corner==CORNER_LEFT_LOWER) w_corner=CORNER_LEFT_UPPER;
   else
      if(m_corner==CORNER_RIGHT_LOWER) w_corner=CORNER_RIGHT_UPPER;
   else
     {
      Print("Invalid corner = ",m_corner);
      w_corner=CORNER_LEFT_UPPER;
     }
   if(m_xdelta>=0)w_xdelta=m_xdelta;
   else
     {
      Print("Invalid X delta = ",m_xdelta);
      w_xdelta=0;
     }
   if(m_ydelta>=0)w_ydelta=m_ydelta;
   else
     {
      Print("Invalid Y delta = ",m_ydelta);
      w_ydelta=0;
     }
   if(m_bsize>0)w_bsize=m_bsize;
   else
     {
      Print("Invalid window width = ",m_bsize);
      w_bsize=B_WIN;
     }
   Property.Corner=(ENUM_BASE_CORNER) w_corner;
   SetXY(w_corner);
  }
//+------------------------------------------------------------------+
///Set coordinates depending on specified corner
//+------------------------------------------------------------------+
void CWin::SetXY(int m_corner)
  {
   if(m_corner==CORNER_LEFT_UPPER)
     {
      w_xpos=w_xdelta;
      w_ypos=w_ydelta;
      Property.Corn=1;
     }
   else
   if(m_corner==CORNER_RIGHT_UPPER)
     {
      w_xpos=w_xdelta+w_bsize;
      w_ypos=w_ydelta;
      Property.Corn=-1;
     }
   else
   if(m_corner==CORNER_LEFT_LOWER)
     {
      w_xpos=w_xdelta;
      w_ypos=w_ydelta+w_hsize+Property.H;
      Property.Corn=1;
     }
   else
   if(m_corner==CORNER_RIGHT_LOWER)
     {
      w_xpos=w_xdelta+w_bsize;
      w_ypos=w_ydelta+w_hsize+Property.H;
      Property.Corn=-1;
     }
   else
     {
      Print("Invalid corner = ",m_corner);
      w_corner=CORNER_LEFT_UPPER;
      w_xpos=0;
      w_ypos=0;
      Property.Corn=1;
     }
//---
   if(w_corner==CORNER_LEFT_UPPER) w_h_corner=CORNER_LEFT_LOWER;
   if(w_corner==CORNER_LEFT_LOWER) w_h_corner=CORNER_LEFT_LOWER;
   if(w_corner==CORNER_RIGHT_UPPER) w_h_corner=CORNER_RIGHT_LOWER;
   if(w_corner==CORNER_RIGHT_LOWER) w_h_corner=CORNER_RIGHT_LOWER;
//---
  }
//+------------------------------------------------------------------+
///CWin class event handler
//+------------------------------------------------------------------+
void CWin::OnEventTick()
  {
//---
  }
//+------------------------------------------------------------------+
///CWin class event handler
//+------------------------------------------------------------------+
void CWin::OnEvent(const int id,
                   const long &lparam,
                   const double &dparam,
                   const string &sparam)
  {
   if(on_event) //event processing is enabled
     {
      //---
     }
  }
//+------------------------------------------------------------------+
///CWin class Draw method
//+------------------------------------------------------------------+
void CWin::Draw(int &MMint[][3],
                string &MMstr[][3],
                int count)
  {
   STR1.Property=Property;
   STR2.Property=Property;
   STR3.Property=Property;
   STR4.Property=Property;
   STR5.Property=Property;
   STR6.Property=Property;
//---
   int X,Y,B;
   string   strname;
   X=w_xpos;
   Y=w_ypos;
   B=w_bsize;
   for(int i=0; i<=count; i++)
     {
      strname=".STR"+(string)i;
      if(MMint[i][0]==1) STR1.Draw(name+strname,X,Y,B,
         MMint[i][1],MMstr[i][0]);
      if(MMint[i][0]==2) STR2.Draw(name+strname,X,Y,B,
         MMint[i][1],MMstr[i][0],MMstr[i][1]);
      if(MMint[i][0]==3) STR3.Draw(name+strname,X,Y,B,
         MMint[i][1],MMstr[i][0],MMstr[i][1]);
      if(MMint[i][0]==4) STR4.Draw(name+strname,X,Y,B,
         MMint[i][1],MMstr[i][0],MMstr[i][1]);
      if(MMint[i][0]==5) STR5.Draw(name+strname,X,Y,B,
         MMint[i][1],MMstr[i][0],MMstr[i][1]);
      if(MMint[i][0]==6) STR6.Draw(name+strname,X,Y,B,
         MMint[i][1],MMint[i][2],MMstr[i][0],MMstr[i][1],MMstr[i][2]);
      Y=Y+Property.H+DELTA;
     }
//---
   ChartRedraw();
   on_event=true;   //enable events processing
  }
//+------------------------------------------------------------------+
