//+------------------------------------------------------------------+
//|                                        ClassMasterWindowsEXE.mqh |
//|                                                 Copyright DC2008 |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "DC2008"
#property link      "http://www.mql5.com"
//--- Include files with classes
#include <Arrays\ArrayString.mqh>
#include <ClassUnit.mqh>
#include <ClassWin.mqh>
#include <InitMasterWindows.mqh>
#include <Files\FileTxt.mqh>
#include <ClassMasterFile.mqh>
//+------------------------------------------------------------------+
///CMasterWindowsEXE class
//+------------------------------------------------------------------+
class CMasterWindowsEXE:public CWin
  {
private:
   long              Y_hide;        // Window shift vertical in hide mode
   long              Y_obj;         // Window shift vertical
   long              H_obj;         // Window shift horizontal
   int               Nstr;          // number of rows created
   int               Focstr;        // focus on the row
   int               Xset,Yset,Bset;// input parameters
   int               buf_WinType;   // input parameters
   int               buf_StrType;   // input parameters
   int               buf_R_L;       // input parameters
protected:
   CMasterFile       MF;
   bool              on_event;      // event handler flag
   int               on_hide;       // HIDE mode flag
   CArrayString      stroki;        // Main window lines
   CArrayString      strNEW;        // New window lines
   void              Hide();        // Hide window method
   void              Generator();   // Generator method
   string            name;          // Window name
   int               corner;        // Window corner
public:
   string            nameFile;      // Project file name
   //+---------------------------------------------------------------+
   ///Class constructor
   void              CMasterWindowsEXE();
   ///Initialization method
   void              Init(const string w_name,
                          const long Y,
                          const long H);
   ///Event processing method
   void              OnEvent(const int id,
                             const long &lparam,
                             const double &dparam,
                             const string &sparam);
   void              Run();         // Run method
  };
//+------------------------------------------------------------------+
///CMasterWindowsEXE class constructor
//+------------------------------------------------------------------+
void CMasterWindowsEXE::CMasterWindowsEXE()
  {
   stroki.Clear();
   strNEW.Clear();
   Nstr=1;
   Focstr=0;
   corner=CORNER_LEFT_UPPER;
   on_hide=false;
   on_event=true;   //enable event processing
  }
//+------------------------------------------------------------------+
///CMasterWindowsEXE class initialization metho
//+------------------------------------------------------------------+
void CMasterWindowsEXE::Init(const string w_name,
                             const long Y,
                             const long H)
  {//data initialization
   name=w_name;
   Y_obj=Y;
   H_obj=H;
   buf_R_L=0;
  }
//+------------------------------------------------------------------+
///CMasterWindowsEXE class Run method
//+------------------------------------------------------------------+
void CMasterWindowsEXE::Run()
  {
//--- base class method
   SetWin(name,50,100,250,CORNER_LEFT_UPPER);
   Xset=w_xdelta;
   Yset=w_ydelta;
   buf_WinType=MintNEW[0][1];
   Draw(MintNEW,MstrNEW,Nstr);
  }
//+------------------------------------------------------------------+
///CMasterWindowsEXE class Generator method
//+------------------------------------------------------------------+
void CMasterWindowsEXE::Generator()
  {
//---
   MF.Run(nameFile,nameFile,w_xdelta,w_ydelta,w_bsize,CORNER_LEFT_UPPER,Nstr);
//   MF.Run(nameFile,"CWin1",w_xdelta,w_ydelta,w_bsize,CORNER_LEFT_UPPER,Nstr);
  }
//+------------------------------------------------------------------+
///CMasterWindowsEXE class Hide method
//+------------------------------------------------------------------+
void CMasterWindowsEXE::Hide()
  {
   Y_hide=ChartGetInteger(0,CHART_HEIGHT_IN_PIXELS,0)-Y_obj-H_obj;
//---
   if(on_hide==false)
     {
      int n_str=stroki.Total();
      for(int i=0; i<n_str; i++)
        {
         long y_obj=ObjectGetInteger(0,stroki.At(i),OBJPROP_YDISTANCE);
         ObjectSetInteger(0,stroki.At(i),OBJPROP_YDISTANCE,(int)y_obj+(int)Y_hide);
         if(StringFind(stroki.At(i),".Button0",0)>0)
            ObjectSetString(0,stroki.At(i),OBJPROP_TEXT,CharToString(MAX_WIN));
        }
     }
   else
     {
      int n_str=stroki.Total();
      for(int i=0; i<n_str; i++)
        {
         long y_obj=ObjectGetInteger(0,stroki.At(i),OBJPROP_YDISTANCE);
         ObjectSetInteger(0,stroki.At(i),OBJPROP_YDISTANCE,(int)y_obj-(int)Y_hide);
         if(StringFind(stroki.At(i),".Button0",0)>0)
            ObjectSetString(0,stroki.At(i),OBJPROP_TEXT,CharToString(MIN_WIN));
        }
     }
//---
   ChartRedraw();
   on_hide=!on_hide;
  }
//+------------------------------------------------------------------+
///CMasterWindowsEXE class event handler method
//+------------------------------------------------------------------+
void CMasterWindowsEXE::OnEvent(const int id,
                                const long &lparam,
                                const double &dparam,
                                const string &sparam)
  {
   if(on_event // event processing is enabled
      && StringFind(sparam,"CWin1",0)>=0)
     {
      //--- START button of the main window has pressed
      if(id==CHARTEVENT_OBJECT_CLICK
         && StringFind(sparam,"STR19",0)>0
         && StringFind(sparam,".Button",0)>0)
        {
         Generator();
         MessageBox("Files generated successfully!\n\nExpert Advisor:    "+
                    nameFile+".mq5\n\nIndicator:  "+
                    nameFile+"_ind.mq5","MasterWindows file generator",MB_OK);
        }
      //--- Edit of STR18
      if(id==CHARTEVENT_OBJECT_ENDEDIT
         && StringFind(sparam,"STR18",0)>0)
        {
         string textedit=ObjectGetString(0,sparam,OBJPROP_TEXT);
         if(StringFind(textedit,".",0)>=0)
           {
            ObjectSetString(0,sparam,OBJPROP_TEXT,"");
            ChartRedraw();
            MessageBox("Enter file name without dot!","Error in file name",MB_OK);
           }
         else nameFile=textedit;
        }
      //--- Edit of STR17
      if(id==CHARTEVENT_OBJECT_ENDEDIT
         && StringFind(sparam,"STR17",0)>0)
        {
         if(Focstr>=1)
           {
            string textedit=ObjectGetString(0,sparam,OBJPROP_TEXT);
            MintNEW[Focstr][2]=(int)textedit;
            Draw(MintNEW,MstrNEW,Nstr);
           }
        }
      //--- Edit of STR16
      if(id==CHARTEVENT_OBJECT_ENDEDIT
         && StringFind(sparam,"STR16",0)>0)
        {
         if(Focstr>=1)
           {
            string textedit=ObjectGetString(0,sparam,OBJPROP_TEXT);
            MintNEW[Focstr][1]=(int)textedit;
            Draw(MintNEW,MstrNEW,Nstr);
           }
        }
      //--- Edit of STR15
      if(id==CHARTEVENT_OBJECT_ENDEDIT
         && StringFind(sparam,"STR15",0)>0)
        {
         if(Focstr>=1)
           {
            string textedit=ObjectGetString(0,sparam,OBJPROP_TEXT);
            MstrNEW[Focstr][2]=textedit;
            Draw(MintNEW,MstrNEW,Nstr);
           }
        }
      //--- Edit of STR14
      if(id==CHARTEVENT_OBJECT_ENDEDIT
         && StringFind(sparam,"STR14",0)>0)
        {
         if(Focstr>=1)
           {
            string textedit=ObjectGetString(0,sparam,OBJPROP_TEXT);
            MstrNEW[Focstr][1]=textedit;
            Draw(MintNEW,MstrNEW,Nstr);
           }
        }
      //--- Edit of STR13
      if(id==CHARTEVENT_OBJECT_ENDEDIT
         && StringFind(sparam,"STR13",0)>0)
        {
         if(Focstr>=1)
           {
            string textedit=ObjectGetString(0,sparam,OBJPROP_TEXT);
            MstrNEW[Focstr][0]=textedit;
            Draw(MintNEW,MstrNEW,Nstr);
           }
        }
      //--- Minus button click in STR12
      if(id==CHARTEVENT_OBJECT_CLICK
         && StringFind(sparam,"STR12",0)>0
         && StringFind(sparam,".Button4",0)>0)
        {
         if(Focstr>=1)
           {
            int n_str=strNEW.Total();
            for(int i=0; i<n_str; i++)
              {
               ObjectDelete(0,strNEW.At(i));
              }
            buf_StrType=MintNEW[Focstr][0];
            if(buf_StrType>1) buf_StrType--;
            else buf_StrType=6;
            MintNEW[Focstr][0]=buf_StrType;
            if(buf_StrType==6 && MintNEW[Focstr][2]<5)MintNEW[Focstr][2]=50;
            Draw(MintNEW,MstrNEW,Nstr);
            //---
            ObjectSetString(0,stroki.At(32),OBJPROP_TEXT,"CRowType"
                            +(string)MintNEW[Focstr][0]);
            ObjectSetString(0,stroki.At(36),OBJPROP_TEXT,MstrNEW[Focstr][0]);
            ObjectSetString(0,stroki.At(38),OBJPROP_TEXT,MstrNEW[Focstr][1]);
            ObjectSetString(0,stroki.At(40),OBJPROP_TEXT,MstrNEW[Focstr][2]);
            ObjectSetString(0,stroki.At(42),OBJPROP_TEXT,(string)MintNEW[Focstr][1]);
            ObjectSetString(0,stroki.At(44),OBJPROP_TEXT,(string)MintNEW[Focstr][2]);
            //---
            ChartRedraw();
           }
        }
      //--- Plus button click in STR 12
      if(id==CHARTEVENT_OBJECT_CLICK
         && StringFind(sparam,"STR12",0)>0
         && StringFind(sparam,".Button3",0)>0)
        {
         if(Focstr>=1)
           {
            int n_str=strNEW.Total();
            for(int i=0; i<n_str; i++)
              {
               ObjectDelete(0,strNEW.At(i));
              }
            buf_StrType=MintNEW[Focstr][0];
            if(buf_StrType<6) buf_StrType++;
            else buf_StrType=1;
            MintNEW[Focstr][0]=buf_StrType;
            if(buf_StrType==6 && MintNEW[Focstr][2]<5)MintNEW[Focstr][2]=50;
            Draw(MintNEW,MstrNEW,Nstr);
            //---
            ObjectSetString(0,stroki.At(32),OBJPROP_TEXT,"CRowType"
                            +(string)MintNEW[Focstr][0]);
            ObjectSetString(0,stroki.At(36),OBJPROP_TEXT,MstrNEW[Focstr][0]);
            ObjectSetString(0,stroki.At(38),OBJPROP_TEXT,MstrNEW[Focstr][1]);
            ObjectSetString(0,stroki.At(40),OBJPROP_TEXT,MstrNEW[Focstr][2]);
            ObjectSetString(0,stroki.At(42),OBJPROP_TEXT,(string)MintNEW[Focstr][1]);
            ObjectSetString(0,stroki.At(44),OBJPROP_TEXT,(string)MintNEW[Focstr][2]);
            //---
            ChartRedraw();
           }
        }
      //--- INSERT button click in the main window strNEW
      if(id==CHARTEVENT_OBJECT_CLICK
         && StringFind(sparam,"STR10",0)>0
         && StringFind(sparam,"(2)",0)>0)
        {
         if(Focstr>=1)
           {
            int n_str=strNEW.Total();
            for(int i=0; i<n_str; i++)
              {
               ObjectDelete(0,strNEW.At(i));
              }
            for(int i=Nstr; i>=Focstr; i--)
              {
               MintNEW[i+1][0]=MintNEW[i][0];
               MintNEW[i+1][1]=MintNEW[i][1];
               MintNEW[i+1][2]=MintNEW[i][2];
               MstrNEW[i+1][0]=MstrNEW[i][0];
               MstrNEW[i+1][1]=MstrNEW[i][1];
               MstrNEW[i+1][2]=MstrNEW[i][2];
              }
            MintNEW[Focstr][0]=2;
            MintNEW[Focstr][1]=100;
            MstrNEW[Focstr][0]="NEW"+(string)Nstr;
            MstrNEW[Focstr][1]="new"+(string)Nstr;
            Draw(MintNEW,MstrNEW,Nstr);
            Nstr++;
            //---
            ObjectSetString(0,stroki.At(32),OBJPROP_TEXT,"CRowType"
                            +(string)MintNEW[Focstr][0]);
            ObjectSetString(0,stroki.At(36),OBJPROP_TEXT,MstrNEW[Focstr][0]);
            ObjectSetString(0,stroki.At(38),OBJPROP_TEXT,MstrNEW[Focstr][1]);
            ObjectSetString(0,stroki.At(40),OBJPROP_TEXT,MstrNEW[Focstr][2]);
            ObjectSetString(0,stroki.At(42),OBJPROP_TEXT,(string)MintNEW[Focstr][1]);
            ObjectSetString(0,stroki.At(44),OBJPROP_TEXT,(string)MintNEW[Focstr][2]);
            //---
            ChartRedraw();
           }
        }
      //--- DELETE button click in the main window strNEW
      if(id==CHARTEVENT_OBJECT_CLICK
         && StringFind(sparam,"STR10",0)>0
         && StringFind(sparam,"(3)",0)>0)
        {
         if(Focstr>=1)
           {
            int n_str=strNEW.Total();
            for(int i=0; i<n_str; i++)
              {
               ObjectDelete(0,strNEW.At(i));
              }
            for(int i=Focstr; i<Nstr; i++)
              {
               MintNEW[i][0]=MintNEW[i+1][0];
               MintNEW[i][1]=MintNEW[i+1][1];
               MintNEW[i][2]=MintNEW[i+1][2];
               MstrNEW[i][0]=MstrNEW[i+1][0];
               MstrNEW[i][1]=MstrNEW[i+1][1];
               MstrNEW[i][2]=MstrNEW[i+1][2];
              }
            Draw(MintNEW,MstrNEW,Nstr);
            if(Nstr>1) Nstr--;
            else Nstr=1;
            if(Focstr>=Nstr) Focstr=Nstr-1;
            if(Focstr<0) Focstr=0;
            ObjectSetString(0,stroki.At(22),OBJPROP_TEXT,(string)Focstr);
            //---
            ObjectSetString(0,stroki.At(32),OBJPROP_TEXT,"CRowType"
                            +(string)MintNEW[Focstr][0]);
            ObjectSetString(0,stroki.At(36),OBJPROP_TEXT,MstrNEW[Focstr][0]);
            ObjectSetString(0,stroki.At(38),OBJPROP_TEXT,MstrNEW[Focstr][1]);
            ObjectSetString(0,stroki.At(40),OBJPROP_TEXT,MstrNEW[Focstr][2]);
            ObjectSetString(0,stroki.At(42),OBJPROP_TEXT,(string)MintNEW[Focstr][1]);
            ObjectSetString(0,stroki.At(44),OBJPROP_TEXT,(string)MintNEW[Focstr][2]);
            //---
            ChartRedraw();
           }
        }
      //--- ADD button click in the main window strNEW
      if(id==CHARTEVENT_OBJECT_CLICK
         && StringFind(sparam,"STR10",0)>0
         && StringFind(sparam,"(1)",0)>0)
        {
         MintNEW[Nstr][0]=2;
         MintNEW[Nstr][1]=100;
         MstrNEW[Nstr][0]="NEW"+(string)Nstr;
         MstrNEW[Nstr][1]="new"+(string)Nstr;
         ObjectSetString(0,stroki.At(22),OBJPROP_TEXT,(string)Nstr);
         Draw(MintNEW,MstrNEW,Nstr);
         Nstr++;
         Focstr=Nstr-1;
         //---
         ObjectSetString(0,stroki.At(32),OBJPROP_TEXT,"CRowType"
                         +(string)MintNEW[Focstr][0]);
         ObjectSetString(0,stroki.At(36),OBJPROP_TEXT,MstrNEW[Focstr][0]);
         ObjectSetString(0,stroki.At(38),OBJPROP_TEXT,MstrNEW[Focstr][1]);
         ObjectSetString(0,stroki.At(40),OBJPROP_TEXT,MstrNEW[Focstr][2]);
         ObjectSetString(0,stroki.At(42),OBJPROP_TEXT,(string)MintNEW[Focstr][1]);
         ObjectSetString(0,stroki.At(44),OBJPROP_TEXT,(string)MintNEW[Focstr][2]);
         //---
         ChartRedraw();
        }
      //--- Up button click in STR9
      if(id==CHARTEVENT_OBJECT_CLICK
         && StringFind(sparam,"STR9",0)>0
         && StringFind(sparam,".Button5",0)>0)
        {
         if(Focstr>=1)
           {
            Focstr=1;
            ObjectSetString(0,stroki.At(22),OBJPROP_TEXT,(string)Focstr);
            //---
            ObjectSetString(0,stroki.At(32),OBJPROP_TEXT,"CRowType"
                            +(string)MintNEW[Focstr][0]);
            ObjectSetString(0,stroki.At(36),OBJPROP_TEXT,MstrNEW[Focstr][0]);
            ObjectSetString(0,stroki.At(38),OBJPROP_TEXT,MstrNEW[Focstr][1]);
            ObjectSetString(0,stroki.At(40),OBJPROP_TEXT,MstrNEW[Focstr][2]);
            ObjectSetString(0,stroki.At(42),OBJPROP_TEXT,(string)MintNEW[Focstr][1]);
            ObjectSetString(0,stroki.At(44),OBJPROP_TEXT,(string)MintNEW[Focstr][2]);
            //---
            ChartRedraw();
           }
        }
      //--- Down button click in STR9
      if(id==CHARTEVENT_OBJECT_CLICK
         && StringFind(sparam,"STR9",0)>0
         && StringFind(sparam,".Button6",0)>0)
        {
         if(Focstr>=1)
           {
            Focstr=Nstr-1;
            ObjectSetString(0,stroki.At(22),OBJPROP_TEXT,(string)Focstr);
            //---
            ObjectSetString(0,stroki.At(32),OBJPROP_TEXT,"CRowType"
                            +(string)MintNEW[Focstr][0]);
            ObjectSetString(0,stroki.At(36),OBJPROP_TEXT,MstrNEW[Focstr][0]);
            ObjectSetString(0,stroki.At(38),OBJPROP_TEXT,MstrNEW[Focstr][1]);
            ObjectSetString(0,stroki.At(40),OBJPROP_TEXT,MstrNEW[Focstr][2]);
            ObjectSetString(0,stroki.At(42),OBJPROP_TEXT,(string)MintNEW[Focstr][1]);
            ObjectSetString(0,stroki.At(44),OBJPROP_TEXT,(string)MintNEW[Focstr][2]);
            //---
            ChartRedraw();
           }
        }
      //--- Minus button click in STR9
      if(id==CHARTEVENT_OBJECT_CLICK
         && StringFind(sparam,"STR9",0)>0
         && StringFind(sparam,".Button4",0)>0)
        {
         if(Focstr>=1)
           {
            if(Focstr>1) Focstr--;
            else Focstr=1;
            ObjectSetString(0,stroki.At(22),OBJPROP_TEXT,(string)Focstr);
            //---
            ObjectSetString(0,stroki.At(32),OBJPROP_TEXT,"CRowType"
                            +(string)MintNEW[Focstr][0]);
            ObjectSetString(0,stroki.At(36),OBJPROP_TEXT,MstrNEW[Focstr][0]);
            ObjectSetString(0,stroki.At(38),OBJPROP_TEXT,MstrNEW[Focstr][1]);
            ObjectSetString(0,stroki.At(40),OBJPROP_TEXT,MstrNEW[Focstr][2]);
            ObjectSetString(0,stroki.At(42),OBJPROP_TEXT,(string)MintNEW[Focstr][1]);
            ObjectSetString(0,stroki.At(44),OBJPROP_TEXT,(string)MintNEW[Focstr][2]);
            //---
            ChartRedraw();
           }
        }
      //--- Plus button click in STR9
      if(id==CHARTEVENT_OBJECT_CLICK
         && StringFind(sparam,"STR9",0)>0
         && StringFind(sparam,".Button3",0)>0)
        {
         if(Focstr>=1)
           {
            if(Focstr<Nstr-1) Focstr++;
            else Focstr=Nstr-1;
            ObjectSetString(0,stroki.At(22),OBJPROP_TEXT,(string)Focstr);
            //---
            ObjectSetString(0,stroki.At(32),OBJPROP_TEXT,"CRowType"
                            +(string)MintNEW[Focstr][0]);
            ObjectSetString(0,stroki.At(36),OBJPROP_TEXT,MstrNEW[Focstr][0]);
            ObjectSetString(0,stroki.At(38),OBJPROP_TEXT,MstrNEW[Focstr][1]);
            ObjectSetString(0,stroki.At(40),OBJPROP_TEXT,MstrNEW[Focstr][2]);
            ObjectSetString(0,stroki.At(42),OBJPROP_TEXT,(string)MintNEW[Focstr][1]);
            ObjectSetString(0,stroki.At(44),OBJPROP_TEXT,(string)MintNEW[Focstr][2]);
            //---
            ChartRedraw();
           }
        }
      //--- Minus button click in STR7
      if(id==CHARTEVENT_OBJECT_CLICK
         && StringFind(sparam,"STR7",0)>0
         && StringFind(sparam,".Button4",0)>0)
        {
         if(buf_R_L>0) buf_R_L--;
         else buf_R_L=1;
         if(buf_R_L==0)ObjectSetString(0,stroki.At(17),OBJPROP_TEXT,"right corner");
         if(buf_R_L==1)ObjectSetString(0,stroki.At(17),OBJPROP_TEXT,"left corner");
         if(buf_R_L==0) corner=CORNER_RIGHT_UPPER; else corner=CORNER_LEFT_UPPER;
         ChartRedraw();
        }
      //--- Plus button click in STR7
      if(id==CHARTEVENT_OBJECT_CLICK
         && StringFind(sparam,"STR7",0)>0
         && StringFind(sparam,".Button3",0)>0)
        {
         if(buf_R_L<1) buf_R_L++;
         else buf_R_L=0;
         if(buf_R_L==0)ObjectSetString(0,stroki.At(17),OBJPROP_TEXT,"right corner");
         if(buf_R_L==1)ObjectSetString(0,stroki.At(17),OBJPROP_TEXT,"left corner");
         if(buf_R_L==0) corner=CORNER_RIGHT_UPPER; else corner=CORNER_LEFT_UPPER;
         ChartRedraw();
        }
      //--- Edit of STR6
      if(id==CHARTEVENT_OBJECT_ENDEDIT
         && StringFind(sparam,"STR6",0)>0)
        {
         string textedit=ObjectGetString(0,sparam,OBJPROP_TEXT);
         SetWin(name,w_xdelta,w_ydelta,(int)textedit,CORNER_LEFT_UPPER);
         Draw(MintNEW,MstrNEW,Nstr);
        }
      //--- Edit of STR5
      if(id==CHARTEVENT_OBJECT_ENDEDIT
         && StringFind(sparam,"STR5",0)>0)
        {
         string textedit=ObjectGetString(0,sparam,OBJPROP_TEXT);
         SetWin(name,w_xdelta,(int)textedit,w_bsize,CORNER_LEFT_UPPER);
         Draw(MintNEW,MstrNEW,Nstr);
        }
      //--- Edit of STR4
      if(id==CHARTEVENT_OBJECT_ENDEDIT
         && StringFind(sparam,"STR4",0)>0)
        {
         string textedit=ObjectGetString(0,sparam,OBJPROP_TEXT);
         SetWin(name,(int)textedit,w_ydelta,w_bsize,CORNER_LEFT_UPPER);
         Draw(MintNEW,MstrNEW,Nstr);
        }
      //--- Minus button click in STR3
      if(id==CHARTEVENT_OBJECT_CLICK
         && StringFind(sparam,"STR3",0)>0
         && StringFind(sparam,".Button4",0)>0)
        {
         if(buf_WinType>0) buf_WinType--;
         else buf_WinType=3;
         MintNEW[0][1]=buf_WinType;
         if(buf_WinType==0) ObjectSetString(0,stroki.At(7),OBJPROP_TEXT,"CRowType1(0)");
         if(buf_WinType==1) ObjectSetString(0,stroki.At(7),OBJPROP_TEXT,"CRowType1(1)");
         if(buf_WinType==2) ObjectSetString(0,stroki.At(7),OBJPROP_TEXT,"CRowType1(2)");
         if(buf_WinType==3) ObjectSetString(0,stroki.At(7),OBJPROP_TEXT,"CRowType1(3)");
         int n_str=strNEW.Total();
         for(int i=0; i<n_str; i++) ObjectDelete(0,strNEW.At(i));
         Draw(MintNEW,MstrNEW,Nstr);
        }
      //--- Plus button click in STR3
      if(id==CHARTEVENT_OBJECT_CLICK
         && StringFind(sparam,"STR3",0)>0
         && StringFind(sparam,".Button3",0)>0)
        {
         if(buf_WinType<3) buf_WinType++;
         else buf_WinType=0;
         MintNEW[0][1]=buf_WinType;
         if(buf_WinType==0) ObjectSetString(0,stroki.At(7),OBJPROP_TEXT,"CRowType1(0)");
         if(buf_WinType==1) ObjectSetString(0,stroki.At(7),OBJPROP_TEXT,"CRowType1(1)");
         if(buf_WinType==2) ObjectSetString(0,stroki.At(7),OBJPROP_TEXT,"CRowType1(2)");
         if(buf_WinType==3) ObjectSetString(0,stroki.At(7),OBJPROP_TEXT,"CRowType1(3)");
         int n_str=strNEW.Total();
         for(int i=0; i<n_str; i++) ObjectDelete(0,strNEW.At(i));
         Draw(MintNEW,MstrNEW,Nstr);
        }
      //--- Edit of STR2
      if(id==CHARTEVENT_OBJECT_ENDEDIT
         && StringFind(sparam,"STR2",0)>0)
        {
         string textedit=ObjectGetString(0,sparam,OBJPROP_TEXT);
         MstrNEW[0][0]=textedit;
         Draw(MintNEW,MstrNEW,Nstr);
        }
      //--- Hide button click in the main window
      if(id==CHARTEVENT_OBJECT_CLICK
         && StringFind(sparam,".Button0",0)>0)
        {
         Hide();
        }
     }
//+------------------------------------------------------------------+
//--- graphic object creation
   if(id==CHARTEVENT_OBJECT_CREATE)
     {
      if(StringFind(sparam,"CWin1",0)>=0) stroki.Add(sparam);
      if(StringFind(sparam,name,0)>=0)
        {
         strNEW.Sort();
         if(strNEW.SearchFirst(sparam)<0) strNEW.Add(sparam);
        }
     }
//--- graphic object deletion
   if(id==CHARTEVENT_OBJECT_DELETE)
     {
      if(StringFind(sparam,name,0)>=0)
        {
         if(strNEW.Total()>0)
           {
            strNEW.Clear();
           }
        }
     }
  }
//+------------------------------------------------------------------+
