//+------------------------------------------------------------------+
//|                                              ClassMasterFile.mqh |
//|                                                 Copyright DC2008 |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "DC2008"
#property link      "http://www.mql5.com"
//--- include files with classes
#include <Files\FileTxt.mqh>
#include <InitMasterWindows.mqh>
//+------------------------------------------------------------------+
///CMasterFile class
//+------------------------------------------------------------------+
class CMasterFile
  {
public:
   CFileTxt          Coder;
   void              Run(string g_file,
                         string g_name,
                         int g_X,
                         int g_Y,
                         int g_B,
                         int g_C,
                         int count);
  };
//+------------------------------------------------------------------+
///CMasterFile class Run method
//+------------------------------------------------------------------+
void CMasterFile::Run(string g_file,
                      string g_name,
                      int g_X,
                      int g_Y,
                      int g_B,
                      int g_C,
                      int count)
  {
   string s_C,E_name,I_name;
   E_name=g_name+".Exp";
   I_name=g_name+".Ind";
   if(g_C==CORNER_LEFT_UPPER) s_C="CORNER_LEFT_UPPER";
   if(g_C==CORNER_RIGHT_UPPER) s_C="CORNER_RIGHT_UPPER";
   if(g_C==CORNER_LEFT_LOWER) s_C="CORNER_LEFT_UPPER";
   if(g_C==CORNER_RIGHT_LOWER) s_C="CORNER_RIGHT_UPPER";
   Coder.Open(g_file+".mq5",2);
//---
   Coder.WriteString("//****** Project (Expert Advisor): "+g_file+".mq5\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("//|        Code has been generated by MasterWindows Copyright DC2008 |\n");
   Coder.WriteString("//|                                              http://www.mql5.com |\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("#property copyright \"DC2008\"\n");
   Coder.WriteString("//--- include files with classes\n");
   Coder.WriteString("#include <ClassWin.mqh>\n");
   Coder.WriteString("int Mint[][3]=\n");
   Coder.WriteString("  {\n");
   for(int i=0; i<count; i++)
     {
      Coder.WriteString("     {"+(string)MintNEW[i][0]+","+(string)MintNEW[i][1]+","+(string)MintNEW[i][2]+"},\n");
     }
   Coder.WriteString("     {}\n");
   Coder.WriteString("  };\n");
   Coder.WriteString("string Mstr[][3]=\n");
   Coder.WriteString("  {\n");
   for(int i=0; i<count; i++)
     {
      Coder.WriteString("     {\""+MstrNEW[i][0]+"\",\""+MstrNEW[i][1]+"\",\""+MstrNEW[i][2]+"\"},\n");
     }
   Coder.WriteString("     {}\n");
   Coder.WriteString("  };\n");
//---
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("//| CMasterWindows class (main unit)                                 |\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("class CMasterWindows:public CWin\n");
   Coder.WriteString("  {\n");
   Coder.WriteString("private:\n");
   Coder.WriteString("   long              Y_hide;          // Window shift vertical in hide mode\n");
   Coder.WriteString("   long              Y_obj;           // Window shift vertical\n");
   Coder.WriteString("   long              H_obj;           // Window shift horizontal\n");
   Coder.WriteString("public:\n");
   Coder.WriteString("   bool              on_hide;         // HIDE mode flag\n");
   Coder.WriteString("   CArrayString      units;           // Main window lines\n");
   Coder.WriteString("   void              CMasterWindows() {on_event=false; on_hide=false;}\n");
   Coder.WriteString("   void              Run();           // Run method\n");
   Coder.WriteString("   void              Hide();          // Hide method\n");
   Coder.WriteString("   void              Deinit()         {ObjectsDeleteAll(0,0,-1); Comment(\"\");}\n");
   Coder.WriteString("   virtual void      OnEvent(const int id,\n");
   Coder.WriteString("                             const long &lparam,\n");
   Coder.WriteString("                             const double &dparam,\n");
   Coder.WriteString("                             const string &sparam);\n");
   Coder.WriteString("  };\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("//| CMasterWindows class Run method                                  |\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("void CMasterWindows::Run()\n");
   Coder.WriteString("  {\n");
   Coder.WriteString("   ObjectsDeleteAll(0,0,-1);\n");
   Coder.WriteString("   Comment(\"Code generated by MasterWindows for MQL5  DC2008\");\n");
   Coder.WriteString("//--- creating main window and launch unit \n");
//---
   Coder.WriteString("   SetWin(\""+E_name+"\","+(string)g_X+","+(string)g_Y+","+(string)g_B+","+s_C+");\n");
//---
   Coder.WriteString("   Draw(Mint,Mstr,"+(string)count+");\n");
   Coder.WriteString("  }\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("//| CMasterWindows class Hide method                                 |\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("void CMasterWindows::Hide()\n");
   Coder.WriteString("  {\n");
   Coder.WriteString("   Y_obj=w_ydelta;\n");
   Coder.WriteString("   H_obj=Property.H;\n");
   Coder.WriteString("   Y_hide=ChartGetInteger(0,CHART_HEIGHT_IN_PIXELS,0)-Y_obj-H_obj;;\n");
   Coder.WriteString("//---\n");
   Coder.WriteString("   if(on_hide==false)\n");
   Coder.WriteString("     {\n");
   Coder.WriteString("      int n_str=units.Total();\n");
   Coder.WriteString("      for(int i=0; i<n_str; i++)\n");
   Coder.WriteString("        {\n");
   Coder.WriteString("         long y_obj=ObjectGetInteger(0,units.At(i),OBJPROP_YDISTANCE);\n");
   Coder.WriteString("         ObjectSetInteger(0,units.At(i),OBJPROP_YDISTANCE,(int)y_obj+(int)Y_hide);\n");
   Coder.WriteString("         if(StringFind(units.At(i),\".Button0\",0)>0)\n");
   Coder.WriteString("            ObjectSetString(0,units.At(i),OBJPROP_TEXT,CharToString(MAX_WIN));\n");
   Coder.WriteString("        }\n");
   Coder.WriteString("     }\n");
   Coder.WriteString("   else\n");
   Coder.WriteString("     {\n");
   Coder.WriteString("      int n_str=units.Total();\n");
   Coder.WriteString("      for(int i=0; i<n_str; i++)\n");
   Coder.WriteString("        {\n");
   Coder.WriteString("         long y_obj=ObjectGetInteger(0,units.At(i),OBJPROP_YDISTANCE);\n");
   Coder.WriteString("         ObjectSetInteger(0,units.At(i),OBJPROP_YDISTANCE,(int)y_obj-(int)Y_hide);\n");
   Coder.WriteString("         if(StringFind(units.At(i),\".Button0\",0)>0)\n");
   Coder.WriteString("            ObjectSetString(0,units.At(i),OBJPROP_TEXT,CharToString(MIN_WIN));\n");
   Coder.WriteString("        }\n");
   Coder.WriteString("     }\n");
   Coder.WriteString("//---\n");
   Coder.WriteString("   ChartRedraw();\n");
   Coder.WriteString("   on_hide=!on_hide;\n");
   Coder.WriteString("  }\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("//| CMasterWindows class OnChartEvent event processing method         |\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("void CMasterWindows::OnEvent(const int id,\n");
   Coder.WriteString("                             const long &lparam,\n");
   Coder.WriteString("                             const double &dparam,\n");
   Coder.WriteString("                             const string &sparam)\n");
   Coder.WriteString("  {\n");
   Coder.WriteString("   if(on_event // event handling is enabled\n");
   Coder.WriteString("      && StringFind(sparam,\""+E_name+"\",0)>=0)\n");
   Coder.WriteString("     {\n");
//---
   Coder.WriteString("      //--- call of OnChartEvent handlers\n");
   Coder.WriteString("      STR1.OnEvent(id,lparam,dparam,sparam);\n");
   Coder.WriteString("      STR2.OnEvent(id,lparam,dparam,sparam);\n");
   Coder.WriteString("      STR3.OnEvent(id,lparam,dparam,sparam);\n");
   Coder.WriteString("      STR4.OnEvent(id,lparam,dparam,sparam);\n");
   Coder.WriteString("      STR5.OnEvent(id,lparam,dparam,sparam);\n");
   Coder.WriteString("      STR6.OnEvent(id,lparam,dparam,sparam);\n");
//---
   Coder.WriteString("      //--- creating graphic object\n");
   Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CREATE)\n");
   Coder.WriteString("        {\n");
   Coder.WriteString("         if(StringFind(sparam,\""+E_name+"\",0)>=0) units.Add(sparam);\n");
   Coder.WriteString("        }\n");
//---
   for(int i=0; i<count; i++)
     {
      if(MintNEW[i][0]==2)
        {
         Coder.WriteString("      //--- edit of ["+MstrNEW[i][0]+"] in Edit STR"+(string)i+"\n");
         Coder.WriteString("      if(id==CHARTEVENT_OBJECT_ENDEDIT\n");
         Coder.WriteString("         && StringFind(sparam,\".STR"+(string)i+"\",0)>0)\n");
         Coder.WriteString("        {\n");
         Coder.WriteString("        //--- event processing...\n");
         Coder.WriteString("        }\n");
        }
      if(MintNEW[i][0]==3)
        {
         Coder.WriteString("      //--- ["+MstrNEW[i][0]+"] Plus button click in STR"+(string)i+"\n");
         Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CLICK\n");
         Coder.WriteString("         && StringFind(sparam,\".STR"+(string)i+"\",0)>0\n");
         Coder.WriteString("         && StringFind(sparam,\".Button3\",0)>0)\n");
         Coder.WriteString("        {\n");
         Coder.WriteString("        //--- event processing...\n");
         Coder.WriteString("        }\n");
         Coder.WriteString("      //--- ["+MstrNEW[i][0]+"] Minus button click in STR"+(string)i+"\n");
         Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CLICK\n");
         Coder.WriteString("         && StringFind(sparam,\".STR"+(string)i+"\",0)>0\n");
         Coder.WriteString("         && StringFind(sparam,\".Button4\",0)>0)\n");
         Coder.WriteString("        {\n");
         Coder.WriteString("        //--- event processing...\n");
         Coder.WriteString("        }\n");
        }
      if(MintNEW[i][0]==4)
        {
         Coder.WriteString("      //--- ["+MstrNEW[i][0]+"] Plus button click in STR"+(string)i+"\n");
         Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CLICK\n");
         Coder.WriteString("         && StringFind(sparam,\".STR"+(string)i+"\",0)>0\n");
         Coder.WriteString("         && StringFind(sparam,\".Button3\",0)>0)\n");
         Coder.WriteString("        {\n");
         Coder.WriteString("        //--- event processing...\n");
         Coder.WriteString("        }\n");
         Coder.WriteString("      //--- ["+MstrNEW[i][0]+"] Minus button click in STR"+(string)i+"\n");
         Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CLICK\n");
         Coder.WriteString("         && StringFind(sparam,\".STR"+(string)i+"\",0)>0\n");
         Coder.WriteString("         && StringFind(sparam,\".Button4\",0)>0)\n");
         Coder.WriteString("        {\n");
         Coder.WriteString("        //--- event processing...\n");
         Coder.WriteString("        }\n");
         Coder.WriteString("      //--- ["+MstrNEW[i][0]+"] Up button click in STR"+(string)i+"\n");
         Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CLICK\n");
         Coder.WriteString("         && StringFind(sparam,\".STR"+(string)i+"\",0)>0\n");
         Coder.WriteString("         && StringFind(sparam,\".Button5\",0)>0)\n");
         Coder.WriteString("        {\n");
         Coder.WriteString("        //--- event processing...\n");
         Coder.WriteString("        }\n");
         Coder.WriteString("      //--- ["+MstrNEW[i][0]+"] Down button click in STR"+(string)i+"\n");
         Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CLICK\n");
         Coder.WriteString("         && StringFind(sparam,\".STR"+(string)i+"\",0)>0\n");
         Coder.WriteString("         && StringFind(sparam,\".Button6\",0)>0)\n");
         Coder.WriteString("        {\n");
         Coder.WriteString("        //--- event processing...\n");
         Coder.WriteString("        }\n");
        }
      if(MintNEW[i][0]==5)
        {
         Coder.WriteString("      //--- ["+MstrNEW[i][1]+"] button click in STR"+(string)i+"\n");
         Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CLICK\n");
         Coder.WriteString("         && StringFind(sparam,\".STR"+(string)i+"\",0)>0\n");
         Coder.WriteString("         && StringFind(sparam,\".Button\",0)>0)\n");
         Coder.WriteString("        {\n");
         Coder.WriteString("        //--- event processing...\n");
         Coder.WriteString("        }\n");
        }
      if(MintNEW[i][0]==6)
        {
         Coder.WriteString("      //--- ["+MstrNEW[i][0]+"] button click in STR"+(string)i+"\n");
         Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CLICK\n");
         Coder.WriteString("         && StringFind(sparam,\".STR"+(string)i+"\",0)>0\n");
         Coder.WriteString("         && StringFind(sparam,\"(1)\",0)>0)\n");
         Coder.WriteString("        {\n");
         Coder.WriteString("        //--- event processing...\n");
         Coder.WriteString("        }\n");
         Coder.WriteString("      //--- ["+MstrNEW[i][1]+"] button click in STR"+(string)i+"\n");
         Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CLICK\n");
         Coder.WriteString("         && StringFind(sparam,\".STR"+(string)i+"\",0)>0\n");
         Coder.WriteString("         && StringFind(sparam,\"(2)\",0)>0)\n");
         Coder.WriteString("        {\n");
         Coder.WriteString("        //--- event processing...\n");
         Coder.WriteString("        }\n");
         Coder.WriteString("      //--- ["+MstrNEW[i][2]+"] button click in STR"+(string)i+"\n");
         Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CLICK\n");
         Coder.WriteString("         && StringFind(sparam,\".STR"+(string)i+"\",0)>0\n");
         Coder.WriteString("         && StringFind(sparam,\"(3)\",0)>0)\n");
         Coder.WriteString("        {\n");
         Coder.WriteString("        //--- event processing...\n");
         Coder.WriteString("        }\n");
        }
     }
//---
   if(MintNEW[0][1]==0 || MintNEW[0][1]==1)
     {
      Coder.WriteString("      //--- Close button click in the main window\n");
      Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CLICK\n");
      Coder.WriteString("         && StringFind(sparam,\".Button1\",0)>0)\n");
      Coder.WriteString("        {\n");
      Coder.WriteString("         ExpertRemove();\n");
      Coder.WriteString("        }\n");
     }
//---
   if(MintNEW[0][1]==0 || MintNEW[0][1]==2)
     {
      Coder.WriteString("      //--- Hide button click in the main window\n");
      Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CLICK\n");
      Coder.WriteString("         && StringFind(sparam,\".Button0\",0)>0)\n");
      Coder.WriteString("        {\n");
      Coder.WriteString("         Hide();\n");
      Coder.WriteString("        }\n");
     }
//---
   Coder.WriteString("     }\n");
   Coder.WriteString("  }\n");
   Coder.WriteString("//--- Main module declaration\n");
   Coder.WriteString("CMasterWindows MasterWin;\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("//| Expert initialization function                                   |\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("int OnInit()\n");
   Coder.WriteString("  {\n");
   Coder.WriteString("//--- launch main module\n");
   Coder.WriteString("   MasterWin.Run();\n");
   Coder.WriteString("   return(0);\n");
   Coder.WriteString("  }\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("//| Expert deinitialization function                                 |\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("void OnDeinit(const int reason)\n");
   Coder.WriteString("  {\n");
   Coder.WriteString("//--- main module deinitialization\n");
   Coder.WriteString("   MasterWin.Deinit();\n");
   Coder.WriteString("  }\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("//| Expert Event function                                            |\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("void OnChartEvent(const int id,\n");
   Coder.WriteString("                  const long &lparam,\n");
   Coder.WriteString("                  const double &dparam,\n");
   Coder.WriteString("                  const string &sparam)\n");
   Coder.WriteString("  {\n");
   Coder.WriteString("//--- call OnChartEvent event handler\n");
   Coder.WriteString("   MasterWin.OnEvent(id,lparam,dparam,sparam);\n");
   Coder.WriteString("  }\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("\n");
//---
   Coder.Close();
//--- generate indicator code 
   Coder.Open(g_file+"_ind.mq5",2);
//---
   Coder.WriteString("//****** Project (indicator): "+g_file+"_ind.mq5\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("//|        Code has been generated by MasterWindows Copyright DC2008 |\n");
   Coder.WriteString("//|                                              http://www.mql5.com |\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("#property copyright \"DC2008\"\n");
   Coder.WriteString("//--- include files with classes\n");
   Coder.WriteString("#include <ClassWin.mqh>\n");
   Coder.WriteString("#property indicator_chart_window\n");
   Coder.WriteString("int Mint[][3]=\n");
   Coder.WriteString("  {\n");
   for(int i=0; i<count; i++)
     {
      Coder.WriteString("     {"+(string)MintNEW[i][0]+","+(string)MintNEW[i][1]+","+(string)MintNEW[i][2]+"},\n");
     }
   Coder.WriteString("     {}\n");
   Coder.WriteString("  };\n");
   Coder.WriteString("string Mstr[][3]=\n");
   Coder.WriteString("  {\n");
   for(int i=0; i<count; i++)
     {
      Coder.WriteString("     {\""+MstrNEW[i][0]+"\",\""+MstrNEW[i][1]+"\",\""+MstrNEW[i][2]+"\"},\n");
     }
   Coder.WriteString("     {}\n");
   Coder.WriteString("  };\n");
//---
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("//| CMasterWindows class (main unit)                                 |\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("class CMasterWindows:public CWin\n");
   Coder.WriteString("  {\n");
   Coder.WriteString("private:\n");
   Coder.WriteString("   long              Y_hide;          // Window shift vertical in hide mode\n");
   Coder.WriteString("   long              Y_obj;           // Window shift vertical\n");
   Coder.WriteString("   long              H_obj;           // Window shift horizontal\n");
   Coder.WriteString("public:\n");
   Coder.WriteString("   bool              on_hide;         // Hide mode flag\n");
   Coder.WriteString("   CArrayString      units;           // Main window lines\n");
   Coder.WriteString("   void              CMasterWindows() {on_event=false; on_hide=false;}\n");
   Coder.WriteString("   void              Run();           // Run method\n");
   Coder.WriteString("   void              Hide();          // Hide method\n");
   Coder.WriteString("   void              Deinit()         {ObjectsDeleteAll(0,0,-1); Comment(\"\");}\n");
   Coder.WriteString("   virtual void      OnEvent(const int id,\n");
   Coder.WriteString("                             const long &lparam,\n");
   Coder.WriteString("                             const double &dparam,\n");
   Coder.WriteString("                             const string &sparam);\n");
   Coder.WriteString("  };\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("//| CMasterWindows class Run method                                  |\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("void CMasterWindows::Run()\n");
   Coder.WriteString("  {\n");
   Coder.WriteString("   ObjectsDeleteAll(0,0,-1);\n");
   Coder.WriteString("   Comment(\"Code has been generated by MasterWindows for MQL5  DC2008\");\n");
   Coder.WriteString("//--- creating main window and launch executable object\n");
//---
   Coder.WriteString("   SetWin(\""+I_name+"\","+(string)g_X+","+(string)g_Y+","+(string)g_B+","+s_C+");\n");
//---
   Coder.WriteString("   Draw(Mint,Mstr,"+(string)count+");\n");
   Coder.WriteString("  }\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("//| CMasterWindows class Hide method                                 |\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("void CMasterWindows::Hide()\n");
   Coder.WriteString("  {\n");
   Coder.WriteString("   Y_obj=w_ydelta;\n");
   Coder.WriteString("   H_obj=Property.H;\n");
   Coder.WriteString("   Y_hide=ChartGetInteger(0,CHART_HEIGHT_IN_PIXELS,0)-Y_obj-H_obj;;\n");
   Coder.WriteString("//---\n");
   Coder.WriteString("   if(on_hide==false)\n");
   Coder.WriteString("     {\n");
   Coder.WriteString("      int n_str=units.Total();\n");
   Coder.WriteString("      for(int i=0; i<n_str; i++)\n");
   Coder.WriteString("        {\n");
   Coder.WriteString("         long y_obj=ObjectGetInteger(0,units.At(i),OBJPROP_YDISTANCE);\n");
   Coder.WriteString("         ObjectSetInteger(0,units.At(i),OBJPROP_YDISTANCE,(int)y_obj+(int)Y_hide);\n");
   Coder.WriteString("         if(StringFind(units.At(i),\".Button0\",0)>0)\n");
   Coder.WriteString("            ObjectSetString(0,units.At(i),OBJPROP_TEXT,CharToString(MAX_WIN));\n");
   Coder.WriteString("        }\n");
   Coder.WriteString("     }\n");
   Coder.WriteString("   else\n");
   Coder.WriteString("     {\n");
   Coder.WriteString("      int n_str=units.Total();\n");
   Coder.WriteString("      for(int i=0; i<n_str; i++)\n");
   Coder.WriteString("        {\n");
   Coder.WriteString("         long y_obj=ObjectGetInteger(0,units.At(i),OBJPROP_YDISTANCE);\n");
   Coder.WriteString("         ObjectSetInteger(0,units.At(i),OBJPROP_YDISTANCE,(int)y_obj-(int)Y_hide);\n");
   Coder.WriteString("         if(StringFind(units.At(i),\".Button0\",0)>0)\n");
   Coder.WriteString("            ObjectSetString(0,units.At(i),OBJPROP_TEXT,CharToString(MIN_WIN));\n");
   Coder.WriteString("        }\n");
   Coder.WriteString("     }\n");
   Coder.WriteString("//---\n");
   Coder.WriteString("   ChartRedraw();\n");
   Coder.WriteString("   on_hide=!on_hide;\n");
   Coder.WriteString("  }\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("//| CMasterWindows class chart event processing method               |\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("void CMasterWindows::OnEvent(const int id,\n");
   Coder.WriteString("                             const long &lparam,\n");
   Coder.WriteString("                             const double &dparam,\n");
   Coder.WriteString("                             const string &sparam)\n");
   Coder.WriteString("  {\n");
   Coder.WriteString("   if(on_event // event processing is enabled\n");
   Coder.WriteString("      && StringFind(sparam,\""+I_name+"\",0)>=0)\n");
   Coder.WriteString("     {\n");
//---
   Coder.WriteString("      //--- any button click\n");
   Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CLICK && StringFind(sparam,\".Button\",0)>0)\n");
   Coder.WriteString("        {\n");
   Coder.WriteString("         if(ObjectGetInteger(0,sparam,OBJPROP_STATE)==1)\n");
   Coder.WriteString("           {\n");
   Coder.WriteString("            //--- sleep\n");
   Coder.WriteString("            for(int i=0; i<500000; i++) string timer=sparam;\n");
   Coder.WriteString("            //--- \n");
   Coder.WriteString("            ObjectSetInteger(0,sparam,OBJPROP_STATE,0);\n");
   Coder.WriteString("            ChartRedraw();\n");
   Coder.WriteString("           }\n");
   Coder.WriteString("        }\n");
//---
   Coder.WriteString("      //--- graphic object creation\n");
   Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CREATE)\n");
   Coder.WriteString("        {\n");
   Coder.WriteString("         if(StringFind(sparam,\""+I_name+"\",0)>=0) units.Add(sparam);\n");
   Coder.WriteString("        }\n");
//---
   for(int i=0; i<count; i++)
     {
      if(MintNEW[i][0]==2)
        {
         Coder.WriteString("      //--- edit of ["+MstrNEW[i][0]+"] in the Edit of STR"+(string)i+"\n");
         Coder.WriteString("      if(id==CHARTEVENT_OBJECT_ENDEDIT\n");
         Coder.WriteString("         && StringFind(sparam,\".STR"+(string)i+"\",0)>0)\n");
         Coder.WriteString("        {\n");
         Coder.WriteString("        //--- event processing....\n");
         Coder.WriteString("        }\n");
        }
      if(MintNEW[i][0]==3)
        {
         Coder.WriteString("      //--- edit of ["+MstrNEW[i][0]+"] : Plus button STR"+(string)i+"\n");
         Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CLICK\n");
         Coder.WriteString("         && StringFind(sparam,\".STR"+(string)i+"\",0)>0\n");
         Coder.WriteString("         && StringFind(sparam,\".Button3\",0)>0)\n");
         Coder.WriteString("        {\n");
         Coder.WriteString("        //--- event processing....\n");
         Coder.WriteString("        }\n");
         Coder.WriteString("      //--- edit of ["+MstrNEW[i][0]+"] : Minus button STR"+(string)i+"\n");
         Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CLICK\n");
         Coder.WriteString("         && StringFind(sparam,\".STR"+(string)i+"\",0)>0\n");
         Coder.WriteString("         && StringFind(sparam,\".Button4\",0)>0)\n");
         Coder.WriteString("        {\n");
         Coder.WriteString("        //--- event processing....\n");
         Coder.WriteString("        }\n");
        }
      if(MintNEW[i][0]==4)
        {
         Coder.WriteString("      //--- edit of ["+MstrNEW[i][0]+"] : Plus button STR"+(string)i+"\n");
         Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CLICK\n");
         Coder.WriteString("         && StringFind(sparam,\".STR"+(string)i+"\",0)>0\n");
         Coder.WriteString("         && StringFind(sparam,\".Button3\",0)>0)\n");
         Coder.WriteString("        {\n");
         Coder.WriteString("        //--- event processing....\n");
         Coder.WriteString("        }\n");
         Coder.WriteString("      //--- edit of ["+MstrNEW[i][0]+"] : Minus button STR"+(string)i+"\n");
         Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CLICK\n");
         Coder.WriteString("         && StringFind(sparam,\".STR"+(string)i+"\",0)>0\n");
         Coder.WriteString("         && StringFind(sparam,\".Button4\",0)>0)\n");
         Coder.WriteString("        {\n");
         Coder.WriteString("        //--- event processing....\n");
         Coder.WriteString("        }\n");
         Coder.WriteString("      //--- edit of ["+MstrNEW[i][0]+"] : Up button STR"+(string)i+"\n");
         Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CLICK\n");
         Coder.WriteString("         && StringFind(sparam,\".STR"+(string)i+"\",0)>0\n");
         Coder.WriteString("         && StringFind(sparam,\".Button5\",0)>0)\n");
         Coder.WriteString("        {\n");
         Coder.WriteString("        //--- event processing....\n");
         Coder.WriteString("        }\n");
         Coder.WriteString("      //--- edit of ["+MstrNEW[i][0]+"] : Down button STR"+(string)i+"\n");
         Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CLICK\n");
         Coder.WriteString("         && StringFind(sparam,\".STR"+(string)i+"\",0)>0\n");
         Coder.WriteString("         && StringFind(sparam,\".Button6\",0)>0)\n");
         Coder.WriteString("        {\n");
         Coder.WriteString("        //--- event processing....\n");
         Coder.WriteString("        }\n");
        }
      if(MintNEW[i][0]==5)
        {
         Coder.WriteString("      //--- edit of ["+MstrNEW[i][1]+"] STR"+(string)i+"\n");
         Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CLICK\n");
         Coder.WriteString("         && StringFind(sparam,\".STR"+(string)i+"\",0)>0\n");
         Coder.WriteString("         && StringFind(sparam,\".Button\",0)>0)\n");
         Coder.WriteString("        {\n");
         Coder.WriteString("        //--- event processing....\n");
         Coder.WriteString("        }\n");
        }
      if(MintNEW[i][0]==6)
        {
         Coder.WriteString("      //--- edit of ["+MstrNEW[i][0]+"] STR"+(string)i+"\n");
         Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CLICK\n");
         Coder.WriteString("         && StringFind(sparam,\".STR"+(string)i+"\",0)>0\n");
         Coder.WriteString("         && StringFind(sparam,\"(1)\",0)>0)\n");
         Coder.WriteString("        {\n");
         Coder.WriteString("        //--- event processing....\n");
         Coder.WriteString("        }\n");
         Coder.WriteString("      //--- ["+MstrNEW[i][1]+"] button click in STR"+(string)i+"\n");
         Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CLICK\n");
         Coder.WriteString("         && StringFind(sparam,\".STR"+(string)i+"\",0)>0\n");
         Coder.WriteString("         && StringFind(sparam,\"(2)\",0)>0)\n");
         Coder.WriteString("        {\n");
         Coder.WriteString("        //--- event processing....\n");
         Coder.WriteString("        }\n");
         Coder.WriteString("      //--- ["+MstrNEW[i][2]+"] STR"+(string)i+"\n");
         Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CLICK\n");
         Coder.WriteString("         && StringFind(sparam,\".STR"+(string)i+"\",0)>0\n");
         Coder.WriteString("         && StringFind(sparam,\"(3)\",0)>0)\n");
         Coder.WriteString("        {\n");
         Coder.WriteString("        //--- event processing....\n");
         Coder.WriteString("        }\n");
        }
     }
//---
   if(MintNEW[0][1]==0 || MintNEW[0][1]==1)
     {
      Coder.WriteString("      //--- Close button click in the main window\n");
      Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CLICK\n");
      Coder.WriteString("         && StringFind(sparam,\".Button1\",0)>0)\n");
      Coder.WriteString("        {\n");
      Coder.WriteString("         Deinit();\n");
      Coder.WriteString("        }\n");
     }
//---
   if(MintNEW[0][1]==0 || MintNEW[0][1]==2)
     {
      Coder.WriteString("      //--- Hide button click in the main window\n");
      Coder.WriteString("      if(id==CHARTEVENT_OBJECT_CLICK\n");
      Coder.WriteString("         && StringFind(sparam,\".Button0\",0)>0)\n");
      Coder.WriteString("        {\n");
      Coder.WriteString("         Hide();\n");
      Coder.WriteString("        }\n");
     }
//---
   Coder.WriteString("     }\n");
   Coder.WriteString("  }\n");
   Coder.WriteString("//--- declaration of main object\n");
   Coder.WriteString("CMasterWindows MasterWin;\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("//| Custom indicator initialization function                         |\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("int OnInit()\n");
   Coder.WriteString("  {\n");
   Coder.WriteString("//--- launch main unit\n");
   Coder.WriteString("   MasterWin.Run();\n");
   Coder.WriteString("   return(0);\n");
   Coder.WriteString("  }\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("//| Custom indicator deinitialization function                       |\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("void OnDeinit(const int reason)\n");
   Coder.WriteString("  {\n");
   Coder.WriteString("//--- deinitinalization\n");
   Coder.WriteString("   MasterWin.Deinit();\n");
   Coder.WriteString("  }\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("//| Custom indicator Event function                                  |\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("void OnChartEvent(const int id,\n");
   Coder.WriteString("                  const long &lparam,\n");
   Coder.WriteString("                  const double &dparam,\n");
   Coder.WriteString("                  const string &sparam)\n");
   Coder.WriteString("  {\n");
   Coder.WriteString("//--- call OnChartEvent event processing method\n");
   Coder.WriteString("   MasterWin.OnEvent(id,lparam,dparam,sparam);\n");
   Coder.WriteString("  }\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("//| Custom indicator iteration function                              |\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("int OnCalculate(const int rates_total,\n");
   Coder.WriteString("                const int prev_calculated,\n");
   Coder.WriteString("                const datetime& time[],\n");
   Coder.WriteString("                const double& open[],\n");
   Coder.WriteString("                const double& high[],\n");
   Coder.WriteString("                const double& low[],\n");
   Coder.WriteString("                const double& close[],\n");
   Coder.WriteString("                const long& tick_volume[],\n");
   Coder.WriteString("                const long& volume[],\n");
   Coder.WriteString("                const int& spread[])\n");
   Coder.WriteString("  {\n");
   Coder.WriteString("//---\n");
   Coder.WriteString("//--- return value of prev_calculated for next call\n");
   Coder.WriteString("   return(rates_total);\n");
   Coder.WriteString("  }\n");
   Coder.WriteString("//+------------------------------------------------------------------+\n");
   Coder.WriteString("\n");
//---
   Coder.Close();
  }
//+------------------------------------------------------------------+
