//+------------------------------------------------------------------+
//|                                            StepMA_NRTRSignal.mqh |
//|                             Copyright  2011,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2011, Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
//+------------------------------------------------------------------+
//| Included files                                                   |
//+------------------------------------------------------------------+
#property tester_indicator "StepMA_NRTR.ex5"
#include <Expert\ExpertSignal.mqh>
//--- wizard description start
//+------------------------------------------------------------------+ 
//|  Declaration of constants                                        |
//+------------------------------------------------------------------+ 
#define OPEN_LONG     80 // The constant for returning the buy command to the Expert Advisor
#define OPEN_SHORT    80 // The constant for returning the sell command to the Expert Advisor
#define CLOSE_LONG    40 // The constant for returning the command to close a long position to the Expert Advisor
#define CLOSE_SHORT   40 // The constant for returning the command to close a short position to the Expert Advisor
#define INVERT_LONG  100 // The constant for returning the command to reverse a long position to the Expert Advisor
#define INVERT_SHORT 100 // The constant for returning the command to reverse a short position to the Expert Advisor
#define NO_SIGNAL      0 // The constant for returning the absence of a signal to the Expert Advisor
//+----------------------------------------------------------------------+
//| Description of the class                                             |
//| Title=The signals based on StepMA_NRTR indicator                     |
//| Type=SignalAdvanced                                                  |
//| Name=StepMA_NRTR                                                     |
//| Class=CStepMA_NRTRSignal                                             |
//| Page=                                                                |
//| Parameter=BuyPosOpen,bool,true,Permission to buy                     |
//| Parameter=SellPosOpen,bool,true,Permission to sell                   |
//| Parameter=BuyPosClose,bool,true,Permission to exit a long position   |
//| Parameter=SellPosClose,bool,true,Permission to exit a short position |
//| Parameter=Ind_Timeframe,ENUM_TIMEFRAMES,PERIOD_H1,Timeframe          |
//| Parameter=Length,uint,10,Volty Length                                |
//| Parameter=Kv,double,1.0,Sensivity Factor                             |
//| Parameter=StepSize,uint,0,Constant Step Size (if need)               |
//| Parameter=MA_Mode,uint,1,Volty MA Mode : 0 - SMA, 1 - LWMA           |
//| Parameter=Percentage,double,0.0,Percentage of Up/Down Moving         |
//| Parameter=Switch,uint,0,High/Low Mode Switch (0 - 1)                 |
//| Parameter=SignalBar,uint,1,Bar index for entry signal                |
//+----------------------------------------------------------------------+
//--- wizard description end
//+----------------------------------------------------------------------+
//| CStepMA_NRTRSignal class.                                            |
//| Purpose: Class of generator of trade signals based on                |
//| StepMA_NRTR indicator values http://www.mql5.com/ru/code/draft/559/. |
//|             Is derived from the CExpertSignal class.                 |
//+----------------------------------------------------------------------+
class CStepMA_NRTRSignal : public CExpertSignal
  {
protected:
   CiCustom          m_indicator;        // the object for access to StepMA_NRTR values

   //--- adjusted parameters
   bool              m_BuyPosOpen;       // permission to buy
   bool              m_SellPosOpen;      // permission to sell
   bool              m_BuyPosClose;      // permission to exit a long position
   bool              m_SellPosClose;     // permission to exit a short position
   ENUM_TIMEFRAMES   m_Ind_Timeframe;    // indicator chart time frame
   uint              m_Length;           // Volty Length
   double            m_Kv;               // Sensivity Factor
   uint              m_StepSize;         // Constant Step Size (if need)
   uint              m_MA_Mode;          // Volty MA Mode : 0 - SMA, 1 - LWMA
   double            m_Percentage;       // Percentage of Up/Down Moving 
   uint              m_Switch;           // High/Low Mode Switch (more sensitive) (0 - 1) 
   uint              m_SignalBar;        // bar index for getting entry signal

public:
                     CStepMA_NRTRSignal();

   //--- methods of setting adjustable parameters
   void               BuyPosOpen(bool value)                  { m_BuyPosOpen=value;       }
   void               SellPosOpen(bool value)                 { m_SellPosOpen=value;      }
   void               BuyPosClose(bool value)                 { m_BuyPosClose=value;      }
   void               SellPosClose(bool value)                { m_SellPosClose=value;     }
   //--- indicator input parameters
   void               Ind_Timeframe(ENUM_TIMEFRAMES value)    { m_Ind_Timeframe=value;    }
   void               Length(uint value)                      { m_Length=value;           }
   void               Kv(double value)                        { m_Kv=value;               }
   void               StepSize(uint value)                    { m_StepSize=value;         }
   void               MA_Mode(uint value)                     { m_MA_Mode=value;          }
   void               Percentage(double value)                { m_Percentage=value;       }
   void               Switch(uint value)                      { m_Switch=value;           }
   //---
   void               SignalBar(uint value)                   { m_SignalBar=value;        }

   //--- adjustable parameters validation method
   virtual bool      ValidationSettings();
   //--- adjustable parameters validation method
   virtual bool      InitIndicators(CIndicators *indicators); // indicators initialization
   //--- market entry signals generation methods
   virtual int       LongCondition();
   virtual int       ShortCondition();

   bool              InitStepMA_NRTR(CIndicators *indicators);   // StepMA_NRTR indicator initializing method

protected:

  };
//+------------------------------------------------------------------+
//| CStepMA_NRTRSignal constructor.                                  |
//| INPUT:  no.                                                      |
//| OUTPUT: no.                                                      |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
void CStepMA_NRTRSignal::CStepMA_NRTRSignal()
  {
//--- setting default values
   m_BuyPosOpen=true;
   m_SellPosOpen=true;
   m_BuyPosClose=true;
   m_SellPosClose=true;

//--- indicator input parameters   
   m_Ind_Timeframe=PERIOD_H1;
   m_Length=10;
   m_Kv=1.0;
   m_StepSize=0;  
   m_MA_Mode=1;
   m_Percentage=0; 
   m_Switch=0;
//---  
   m_SignalBar=1;
   m_used_series=USE_SERIES_OPEN+USE_SERIES_HIGH+USE_SERIES_LOW+USE_SERIES_CLOSE;
  }
//+------------------------------------------------------------------+
//| Checking adjustable parameters.                                  |
//| INPUT:  no.                                                      |
//| OUTPUT: true, if the settings are valid, false - if not.         |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
bool CStepMA_NRTRSignal::ValidationSettings()
  {
//--- checking parameters
   if(m_Length<1)
     {
      printf(__FUNCTION__+": Smoothing method parameter cannot be less than 1!");
      printf(__FUNCTION__+": Default value equal to 1 will be used!");
      m_Length=1;
     }

   if(m_Kv<=0)
     {
      printf(__FUNCTION__+": Sensivity Factor indicator parameter must be above zero");
      printf(__FUNCTION__+": Default value equal to 1 will be used!");
      m_Kv=1;
     }
     
   if(m_MA_Mode>1)
     {
      printf(__FUNCTION__+": Volty MA Mode parameter cannot exceed 1!");
      printf(__FUNCTION__+": Default value equal to 1 will be used!");
      m_MA_Mode=1;
     }
     
   if(m_Switch>1)
     {
      printf(__FUNCTION__+": High/Low Mode Switch parameter cannot exceed 1!");
      printf(__FUNCTION__+": Default value equal to 1 will be used!");
      m_Switch=1;
     }
//--- successful completion
   return(true);
  }
//+------------------------------------------------------------------+
//| Initialization of indicators and time series.                    |
//| INPUT:  indicators - pointer to an object-collection             |
//|                      of indicators and time series.              |
//| OUTPUT: true - in case of successful, otherwise - false.         |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
bool CStepMA_NRTRSignal::InitIndicators(CIndicators *indicators)
  {
//--- check of pointer
   if(indicators==NULL) return(false);

//--- indicator initialization
   if(!InitStepMA_NRTR(indicators)) return(false);

//--- successful completion
   return(true);
  }
//+------------------------------------------------------------------+
//| StepMA_NRTR indicator initialization.                            |
//| INPUT:  indicators - pointer to an object-collection             |
//|                      of indicators and time series.              |
//| OUTPUT: true - in case of successful, otherwise - false.         |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
bool CStepMA_NRTRSignal::InitStepMA_NRTR(CIndicators *indicators)
  {
//--- check of pointer
   if(indicators==NULL) return(false);

//--- adding an object to the collection
   if(!indicators.Add(GetPointer(m_indicator)))
     {
      printf(__FUNCTION__+": error of adding the object");
      return(false);
     }

//--- setting the indicator parameters
   MqlParam parameters[8];
   parameters[0].type=TYPE_STRING;
   parameters[0].string_value="StepMA_NRTR.ex5";

   parameters[1].type=TYPE_UINT;
   parameters[1].integer_value=m_Length;

   parameters[2].type=TYPE_DOUBLE;
   parameters[2].double_value=m_Kv;

   parameters[3].type=TYPE_UINT;
   parameters[3].integer_value=m_StepSize;

   parameters[4].type=TYPE_UINT;
   parameters[4].integer_value=m_MA_Mode;

   parameters[5].type=TYPE_DOUBLE;
   parameters[5].double_value=m_Percentage;

   parameters[6].type=TYPE_UINT;
   parameters[6].double_value=m_Switch;
   
   parameters[7].type=TYPE_UINT;
   parameters[7].integer_value=0;
//---
   if(!m_indicator.Create(m_symbol.Name(),m_Ind_Timeframe,IND_CUSTOM,8,parameters))
     {
      printf(__FUNCTION__+": object initialization error");
      return(false);
     }

//--- number of buffers
   if(!m_indicator.NumBuffers(4))  return(false);
   
//--- StepMA_NRTR indicator initialized successfully
   return(true);
  }
//+------------------------------------------------------------------+
//| Checking conditions for opening a long position and              |
//| closing a short one                                              |
//| INPUT:  no                                                       |
//| OUTPUT: Vote weight from 0 to 100                                |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
int CStepMA_NRTRSignal::LongCondition()
  {
//--- buy signal is determined by buffer 2 of the StepMA_NRTR indicator
   double Signal=m_indicator.GetData(2,m_SignalBar);

//--- getting a trading signal 
   if(Signal && Signal!=EMPTY_VALUE)
     {
      if(m_BuyPosOpen)
        {
         if(m_SellPosClose) return(INVERT_SHORT);
         else return(OPEN_LONG);
        }
      else
        {
         if(m_SellPosClose) return(CLOSE_SHORT);
        }
     }

//--- searching for signals for closing a short position
   if(!m_SellPosClose) return(NO_SIGNAL);

//--- trend signal is determined by buffer 0 of the StepMA_NRTR indicator
   Signal=m_indicator.GetData(0,m_SignalBar);
   if(Signal && Signal!=EMPTY_VALUE) return(CLOSE_SHORT);

//--- no trading signal
   return(NO_SIGNAL);
  }
//+------------------------------------------------------------------+
//| Checking conditions for opening a short position and             |
//| closing a long one                                               |
//| INPUT:  no                                                       |
//| OUTPUT: Vote weight from 0 to 100                                |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
int CStepMA_NRTRSignal::ShortCondition()
  {
//---- sell signal is determined by buffer 3 of the StepMA_NRTR indicator
   double Signal=m_indicator.GetData(3,m_SignalBar);

//--- getting a trading signal 
   if(Signal && Signal!=EMPTY_VALUE)
     {
      if(m_SellPosOpen)
        {
         if(m_BuyPosClose) return(INVERT_LONG);
         else return(OPEN_SHORT);
        }
      else
        {
         if(m_BuyPosClose) return(CLOSE_LONG);
        }
     }

//--- searching for signals for closing a short position
   if(!m_BuyPosClose) return(NO_SIGNAL);

//--- trend signal is determined by buffer 1 of the StepMA_NRTR indicator
   Signal=m_indicator.GetData(1,m_SignalBar);
   if(Signal && Signal!=EMPTY_VALUE) return(CLOSE_LONG);

//--- no trading signal   
   return(NO_SIGNAL);
  }
//+------------------------------------------------------------------+
