//+------------------------------------------------------------------+
//|                                 BinaryOptionsStrategyExample.mq4 |
//|                                       Copyright 2016, __martin__ |
//|                         https://www.mql5.com/en/users/__martin__ |
//+------------------------------------------------------------------+
#property copyright "Copyright 2016, __martin__"
#property link      "https://www.mql5.com/en/users/__martin__"
#property version   "1.00"
#property strict
#property indicator_separate_window

#include <BinaryOptionsStrategyLibrary.mqh>

//+------------------------------------------------------------------+
//| Place your input parameters here - see example below             |
//+------------------------------------------------------------------+
//--- input parameters
input int                period_fast        =  5;           //Fast MA value
input int                period_slow        = 10;           //Slow MA value
input ENUM_MA_METHOD     method_both        = MODE_SMA;     //MA method
input ENUM_APPLIED_PRICE applied_price_both = PRICE_CLOSE;  //MA applied price

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping

//---
   return(INIT_SUCCEEDED);
  }

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---

   CallStrategy(); //Call the strategy, function is locatet in BinaryOptionsStrategyLibrary.mqh (included above)

//--- return value of prev_calculated for next call
   return(rates_total);
  }

//+------------------------------------------------------------------+
//| Place your Trading-Rules here - see example below.               |
//| StrategyTester will call this function to place trades.          |
//| DO NOT:                                                          |
//| - Rename function                                                |
//| - Add function paramaters, e.g. CheckMyRules(int a)              |
//| - Change function return type, e.g. int CheckMyRules()           |
//+------------------------------------------------------------------+
void CheckMyRules()
  {
  
   //Store MA values with shift=0 (current candle) -> current candle,
   //call helper function GetValueForMA() to get the value - see helper-functions below 
   double emaSlow_Current = GetValueForMA(period_slow, 0);
   double emaFast_Current = GetValueForMA(period_fast, 0);

   //Store MA values with shift=1 (past candle) -> last candle,
   //call helper function GetValueForMA() to get the value - see helper-functions below
   double emaSlow_Past = GetValueForMA(period_slow, 1);
   double emaFast_Past = GetValueForMA(period_fast, 1);
   
   //Store signal value (buffer 1) of KVO indicator from current candle (shift 0)
   double kvoSignal = GetValuesFromIndicator__KVO__(1,0);
   
   PrintDebugValue("emaSlow_Current: ",(string)emaSlow_Current,0); //Label and value in line 0
   PrintDebugValue("emaFast_Current: ",(string)emaFast_Current,1); //Label and value in line 1
   PrintDebugValue("emaSlow_Past: ",(string)emaSlow_Past,2);       //Label and value in line 2
   PrintDebugValue("emaFast_Past: ",(string)emaFast_Past,3);       //Label and value in line 3

   if(emaFast_Past > emaSlow_Past
   && emaFast_Current < emaSlow_Past    //Check if slow MA and fast MA crosses
   && kvoSignal < 0)                    //Check if signal value of KVO is under 0  
     {
      PlaceTrade(OP_SELL);              //Place SELL-Trade for Strategy-Tester, function is located in BinaryOptionsStrategyLibrary.mqh
     }
   
   if(emaFast_Past < emaSlow_Past
   && emaFast_Current > emaSlow_Past    //Check if slow MA and fast MA crosses
   && kvoSignal > 0)                    //Check if signal value of KVO is over 0
     {
      PlaceTrade(OP_BUY);               //Place BUY-Trade for Strategy-Tester, function is located in BinaryOptionsStrategyLibrary.mqh
     }
  
  }

//+------------------------------------------------------------------+
//| Place your Helper-Functions here, see example below              |
//+------------------------------------------------------------------+
//----

//+------------------------------------------------------------------+
//| Get MA values for period, method, applied price and shift.       |
//| For details of iMA() see https://docs.mql4.com/indicators/ima    |
//+------------------------------------------------------------------+
double GetValueForMA(int _period,int _shift)
  {
   return iMA(NULL,0,_period,0,method_both,applied_price_both,_shift);
  }

//+------------------------------------------------------------------+
//| Example how to get values from external indicators,              |
//| see https://docs.mql4.com/indicators/icustom                     |
//| Parameters:                                                      |
//| int _buffer - indicator-buffer (starts with 0)                   |
//| int _shift - value to shift; 0 = current candle, 1 = prev candle |
//+------------------------------------------------------------------+
double GetValuesFromIndicator__KVO__(int _buffer, int _shift=0) //Change "__KVO__" to indicator name
  {
   return ( 
            iCustom (
                      NULL,                      //NULL for current timeframe selected in tester - NO CHANGES NEEDED
                      0,                         //0 for current symbol selected in tester - NO CHANGES NEEDED
                   
                      //BEGIN EDIT
                      "\\Downloads\\KVO.ex4",    //Filepath and filename of the indicator (*.ex4 file)                   
                      //BEGIN INDCATORS INPUTS
                      34,
                      55,
                      13,
                      //END FOR INPUTS
                      //END EDIT
                   
                      _buffer,                   //Buffer index (begins with 0), _buffer is adressed over function parameter - NO CHANGES NEEDED
                      _shift                     //Shift (0 for current candle), _shift is adressed over function parameter - NO CHANGES NEEDED
                    )
          );
  }
//+-----------------------------------------------------------------+
