//+------------------------------------------------------------------+
//|                                            Information Decay.mq5 |
//|                                               Gamuchirai Ndawana |
//|                    https://www.mql5.com/en/users/gamuchiraindawa |
//+------------------------------------------------------------------+
#property copyright "Gamuchirai Ndawana"
#property link      "https://www.mql5.com/en/users/gamuchiraindawa"
#property version   "1.00"

//+------------------------------------------------------------------+
//| System definitions                                               |
//+------------------------------------------------------------------+
#define SYMBOL "EURUSD"
#define SYSTEM_TIMEFRAME PERIOD_D1
#define SYSTEM_DATA COPY_RATES_OHLC
#define TOTAL_MODEL_INPUTS 4
#define TOTAL_MODEL_OUTPUTS 1
#define ATR_PERIOD 14
#define PADDING 2

//+------------------------------------------------------------------+
//| System resources we need                                         |
//+------------------------------------------------------------------+
#resource "\\Files\\EURUSD Baseline LR.onnx" as const uchar onnx_buffer[];

//+------------------------------------------------------------------+
//| Libraries                                                        |
//+------------------------------------------------------------------+
#include <Trade\Trade.mqh>
#include <VolatilityDoctor\Trade\TradeInfo.mqh>
CTrade Trade;
TradeInfo *TradeHelper;

//+------------------------------------------------------------------+
//| Global variables                                                 |
//+------------------------------------------------------------------+
long         onnx_model;
vectorf      onnx_inputs,onnx_output;
MqlDateTime current_time,time_stamp;
int         atr_handler;
double      atr[];

//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {

//--- Create the ONNX model from its buffer
   onnx_model = OnnxCreateFromBuffer(onnx_buffer,ONNX_DATA_TYPE_FLOAT);

//--- Check for errors
   if(onnx_model == INVALID_HANDLE)
     {
      //--- User feedback
      Print("An error occured loading the ONNX model:\n",GetLastError());
      //--- Abort
      return(INIT_FAILED);
     }

//--- Setup the ONNX handler input shape
   else
     {
      //--- Define the I/O shapes
      ulong input_shape[] = {1,4};
      ulong output_shape[] = {1,1};

      //--- Attempt to set input shape
      if(!OnnxSetInputShape(onnx_model,0,input_shape))
        {
         //--- User feedback
         Print("Failed to specify the correct ONNX model input shape:\n",GetLastError());
         //--- Abort
         return(INIT_FAILED);
        }

      //--- Attempt to set output shape
      if(!OnnxSetOutputShape(onnx_model,0,output_shape))
        {
         //--- User feedback
         Print("Failed to specify the correct ONNX model output shape:\n",GetLastError());
         //--- Abort
         return(INIT_FAILED);
        }

      //--- Mark the current time
      TimeLocal(current_time);
      TimeLocal(time_stamp);

      //--- Setup the trade helper
      TradeHelper = new TradeInfo(SYMBOL,SYSTEM_TIMEFRAME);

      //--- Setup our technical indicators
      atr_handler = iATR(Symbol(),SYSTEM_TIMEFRAME,ATR_PERIOD);
      //--- Success
      return(INIT_SUCCEEDED);
     }

  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
   OnnxRelease(onnx_model);
   IndicatorRelease(atr_handler);
   delete(TradeHelper);
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//--- Check for updated candles
   TimeLocal(current_time);

//--- Periodic one day test
   if(current_time.day_of_year != time_stamp.day_of_year)
     {
      //--- Update the time stamp
      TimeLocal(time_stamp);

      //--- Update technical indicators
      CopyBuffer(atr_handler,0,0,1,atr);

      //--- Prepare a prediction from our model
      onnx_inputs = vectorf::Zeros(TOTAL_MODEL_INPUTS);
      onnx_inputs[0] = (float) iOpen(Symbol(),SYSTEM_TIMEFRAME,0);
      onnx_inputs[1] = (float) iHigh(Symbol(),SYSTEM_TIMEFRAME,0);
      onnx_inputs[2] = (float) iLow(Symbol(),SYSTEM_TIMEFRAME,0);
      onnx_inputs[3] = (float) iClose(Symbol(),SYSTEM_TIMEFRAME,0);

      //--- Also prepare the outputs
      onnx_output = vectorf::Zeros(TOTAL_MODEL_OUTPUTS);

      //--- Fetch a prediction from our model
      if(OnnxRun(onnx_model,ONNX_DATA_TYPE_FLOAT,onnx_inputs,onnx_output))
        {
         //--- Give user feedback
         Comment("Trading Day: ",time_stamp.year," ",time_stamp.mon," ",time_stamp.day_of_week,"\nForecast: ",onnx_output[0]);

         //--- Check if we have an open position
         if(PositionsTotal() == 0)
           {
            //--- Long condition
            if(onnx_output[0] > iClose(SYMBOL,SYSTEM_TIMEFRAME,0))
               Trade.Buy(TradeHelper.MinVolume(),SYMBOL,TradeHelper.GetAsk(),TradeHelper.GetBid()-(atr[0]*PADDING),TradeHelper.GetBid()+(atr[0]*PADDING),"");

            //--- Short condition
            if(onnx_output[0] < iClose(SYMBOL,SYSTEM_TIMEFRAME,0))
               Trade.Sell(TradeHelper.MinVolume(),SYMBOL,TradeHelper.GetBid(),TradeHelper.GetAsk()+(atr[0]*PADDING),TradeHelper.GetAsk()-(atr[0]*PADDING),"");
           }

         //--- Manage our open position
         else
           {
               //--- This control branch remains empty for now
           }
        }

      //--- Something went wrong
      else
        {
         Comment("Failed to obtain a prediction from our model. ",GetLastError());
        }
     }
  }
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| Undefine system constants                                        |
//+------------------------------------------------------------------+
#undef SYMBOL
#undef SYSTEM_DATA
#undef SYSTEM_TIMEFRAME
#undef ATR_PERIOD
#undef PADDING
#undef TOTAL_MODEL_INPUTS
#undef TOTAL_MODEL_OUTPUTS