//+------------------------------------------------------------------+
//|                                                     Database.mqh |
//|                                  Copyright 2023, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2023, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
//+------------------------------------------------------------------+
//| Import                                                           |
//+------------------------------------------------------------------+
#include "metadata/TableMetadata.mqh"
//+------------------------------------------------------------------+
//| Entity                                                           |
//+------------------------------------------------------------------+
#define ENTITY_FIELD(type,name,nullable,default_value,auto_inc,primary,unique) type name;
#define ENTITY_DEFAULT(type,name,nullable,default_value,auto_inc,primary,unique) name = default_value;
#define ENTITY_TO_STRING(type,name,nullable,default_val,auto_inc,primary,unique) _s += #name+"="+(string)name+", ";

#define ENTITY(name, COLUMN) \
class name \
  { \
public: \
                     COLUMN(ENTITY_FIELD) \
                     name(void){COLUMN(ENTITY_DEFAULT)}; \
                    ~name(void){}; \
   string            ToString(void) \
     { \
      string _s = ""; \
      COLUMN(ENTITY_TO_STRING) \
      _s = StringSubstr(_s,0,StringLen(_s)-2); \
      return(#name+ "["+_s+"]"); \
     } \
  };
//+------------------------------------------------------------------+
//| Metadata                                                         |
//+------------------------------------------------------------------+
#define MQL5_TO_SQL_int        "INTEGER"
#define MQL5_TO_SQL_double     "REAL"
#define MQL5_TO_SQL_float      "REAL"
#define MQL5_TO_SQL_long       "INTEGER"
#define MQL5_TO_SQL_ulong      "INTEGER"
#define MQL5_TO_SQL_datetime   "INTEGER"
#define MQL5_TO_SQL_string     "TEXT"
#define MQL5_TO_SQL_bool       "INTEGER" 
#define DB_TYPE_FROM_MQL5(type) MQL5_TO_SQL_##type

#define ENTITY_META_DATA_COLUMNS(type,name,nullable,default_value,auto_inc,primary,unique) \
   this.AddColumn(new IColumnMetadata(#name,#type,DB_TYPE_FROM_MQL5(type),nullable,auto_inc,primary,unique));

#define ENTITY_META_DATA(name, COLUMNS) \
class name##Metadata : public ITableMetadata \
  { \
public: \
                     name##Metadata(void) \
     { \
      COLUMNS(ENTITY_META_DATA_COLUMNS); \
     } \
                    ~name##Metadata(void){}; \
   string            TableName() { return(#name); }; \
   string            PrimaryKey(void) \
     { \
      int size = ArraySize(m_columns); \
      for(int i=0;i<size;i++) \
        { \
         if(m_columns[i].PrimaryKey()) \
           { \
            return(m_columns[i].Name()); \
           } \
        } \
      return(NULL); \
     } \
  };
//+------------------------------------------------------------------+
