//+------------------------------------------------------------------+
//|                                        SignalML_Gator_AD.mqh |
//|                             Copyright 2000-2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#include <Expert\ExpertSignal.mqh>

#resource "Python/79_0.onnx" as uchar __79_0[]
#resource "Python/79_3.onnx" as uchar __79_3[]
#resource "Python/79_4.onnx" as uchar __79_4[]
#define __PATTERNS 3
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Signals of ML with Gator and AD                             |
//| Type=SignalAdvanced                                              |
//| Name=Gator and AD                                                 |
//| ShortName=ML_Gator_AD                                             |
//| Class=CSignalML_Gator_AD                                          |
//| Page=signal_gator_ad                                              |
//| Parameter=Pattern_0,int,50,Pattern 0                             |
//| Parameter=Pattern_3,int,50,Pattern 3                             |
//| Parameter=Pattern_4,int,50,Pattern 4                             |
//| Parameter=PatternsUsed,int,255,Patterns Used BitMap              |
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+
//| Class CSignalML_Gator_AD.                                         |
//| Purpose: Class of generator of trade signals based on            |
//|          Signals of ML with Gator and AD                          |
//| Is derived from the CExpertSignal class.                         |
//+------------------------------------------------------------------+
#define __PERIOD 15
class CSignalML_Gator_AD : public CExpertSignal
{
protected:
   CiStdDev          m_stddev;
   CiMA              m_jaw;
   CiMA              m_teeth;
   CiMA              m_lips;
   CiGator           m_gator;
   CiAD              m_ad;
   int               m_patterns_used;

   long              m_handles[__PATTERNS];
   //--- adjusted parameters

   //--- "weights" of market models (0-100)
   int               m_pattern_0;      // model 0
   int               m_pattern_3;      // model 3
   int               m_pattern_4;      // model 4
   //
   //int               m_patterns_usage;   //

public:
   CSignalML_Gator_AD(void);
   ~CSignalML_Gator_AD(void);
   //--- methods of setting adjustable parameters
   //--- methods of adjusting "weights" of market models
   void              Pattern_0(int value)
   {  m_pattern_0 = value;
   }
   void              Pattern_3(int value)
   {  m_pattern_3 = value;
   }
   void              Pattern_4(int value)
   {  m_pattern_4 = value;
   }
   void              PatternsUsed(int value)
   {  m_patterns_used = value;
      PatternsUsage(value);
   }
   //--- method of verification of settings
   virtual bool      ValidationSettings(void);
   //--- method of creating the oscillator and timeseries
   virtual bool      InitIndicators(CIndicators *indicators);
   //--- methods of checking if the market models are formed
   virtual int       LongCondition(void) override;
   virtual int       ShortCondition(void) override;
   virtual double    Direction(void) override;

protected:
   //--- method of initialization of the oscillator
   bool              InitML_Gator_AD(CIndicators *indicators);
   //--- methods of getting data
   double            STD_DEV(int ind)
   {  //
      m_stddev.Refresh(-1);
      return(m_stddev.Main(ind));
   }
   double            Gator_UP(CiGator &Gator, int ind)
   {  //
      Gator.Refresh(-1);
      return(Gator.Upper(ind));
   }
   double            Gator_LO(CiGator &Gator, int ind)
   {  //
      Gator.Refresh(-1);
      return(Gator.Lower(ind));
   }
   //
   color             Color_UP(CiGator &Gator, int ind)
   {  //
      return(fabs(Jaw(ind)-Teeth(ind)) >= fabs(Jaw(ind + 1)-Teeth(ind + 1)) ? clrGreen : clrRed);
   }
   //
   color             Color_LO(CiGator &Gator, int ind)
   {  //
      return(fabs(Teeth(ind)-Lips(ind)) >= fabs(Teeth(ind + 1)-Lips(ind + 1)) ? clrGreen : clrRed);
   }
   double            AD(int ind)
   {  //
      m_ad.Refresh(-1);
      return(m_ad.Main(ind));
   }
   double            AD_Max(int ind, int Count)
   {  //
      m_ad.Refresh(-1);
      return(m_ad.MaxValue(0, 0, Count, ind));
   }
   double            AD_Min(int ind, int Count)
   {  //
      m_ad.Refresh(-1);
      return(m_ad.MinValue(0, 0, Count, ind));
   }
   double            Jaw(int ind)
   {  //
      m_jaw.Refresh(-1);
      return(m_jaw.Main(ind));
   }
   double            Teeth(int ind)
   {  //
      m_teeth.Refresh(-1);
      return(m_teeth.Main(ind));
   }
   double            Lips(int ind)
   {  //
      m_lips.Refresh(-1);
      return(m_lips.Main(ind));
   }
   double            Close(int ind)
   {  //
      m_close.Refresh(-1);
      return(m_symbol.Bid() + (m_close.GetData(ind) - m_close.GetData(X())));
   }
   double            High(int ind)
   {  //
      m_high.Refresh(-1);
      return(m_high.GetData(ind));
   }
   double            Low(int ind)
   {  //
      m_low.Refresh(-1);
      return(m_low.GetData(ind));
   }
   int               X()
   {  //
      return(StartIndex());
   }
   //--- methods to check for patterns
   bool              IsPattern_0(ENUM_POSITION_TYPE T);
   bool              IsPattern_3(ENUM_POSITION_TYPE T);
   bool              IsPattern_4(ENUM_POSITION_TYPE T);

   double            RunModel(int Index, ENUM_POSITION_TYPE T, vectorf &X);
};
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
CSignalML_Gator_AD::CSignalML_Gator_AD(void) : m_pattern_0(50),
   m_pattern_3(50),
   m_pattern_4(50)
//m_patterns_usage(255)
{
//--- initialization of protected data
   m_used_series = USE_SERIES_OPEN + USE_SERIES_HIGH + USE_SERIES_LOW + USE_SERIES_CLOSE + USE_SERIES_TICK_VOLUME;
   PatternsUsage(m_patterns_usage);
//--- create model from static buffer
   m_handles[0] = OnnxCreateFromBuffer(__79_0, ONNX_DEFAULT);
   m_handles[1] = OnnxCreateFromBuffer(__79_3, ONNX_DEFAULT);
   m_handles[2] = OnnxCreateFromBuffer(__79_4, ONNX_DEFAULT);
}
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
CSignalML_Gator_AD::~CSignalML_Gator_AD(void)
{
}
//+------------------------------------------------------------------+
//| Validation settings protected data.                              |
//+------------------------------------------------------------------+
bool CSignalML_Gator_AD::ValidationSettings(void)
{
//--- validation settings of additional filters
   if(!CExpertSignal::ValidationSettings())
      return(false);
//--- initial data checks
   const ulong _out_shape[] = {1, 1};
   for(int i = 0; i < __PATTERNS; i++)
   {  // Set input shapes
      const ulong _in_shape[] = {1, 2};
      if(!OnnxSetInputShape(m_handles[i], ONNX_DEFAULT, _in_shape))
      {  Print("OnnxSetInputShape error ", GetLastError(), " for feature: ", i);
         return(false);
      }
      // Set output shapes
      if(!OnnxSetOutputShape(m_handles[i], 0, _out_shape))
      {  Print("OnnxSetOutputShape error ", GetLastError(), " for feature: ", i);
         return(false);
      }
   }
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Create indicators.                                               |
//+------------------------------------------------------------------+
bool CSignalML_Gator_AD::InitIndicators(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- initialization of indicators and timeseries of additional filters
   if(!CExpertSignal::InitIndicators(indicators))
      return(false);
//--- create and initialize MA oscillator
   if(!InitML_Gator_AD(indicators))
      return(false);
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Initialize MA indicators.                                        |
//+------------------------------------------------------------------+
bool CSignalML_Gator_AD::InitML_Gator_AD(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- add object to collection
   if(!indicators.Add(GetPointer(m_stddev)))
   {  printf(__FUNCTION__ + ": error adding object");
      return(false);
   }
   if(!indicators.Add(GetPointer(m_gator)))
   {  printf(__FUNCTION__ + ": error adding object");
      return(false);
   }
   if(!indicators.Add(GetPointer(m_ad)))
   {  printf(__FUNCTION__ + ": error adding object");
      return(false);
   }
   if(!indicators.Add(GetPointer(m_jaw)))
   {  printf(__FUNCTION__ + ": error adding object");
      return(false);
   }
   if(!indicators.Add(GetPointer(m_teeth)))
   {  printf(__FUNCTION__ + ": error adding object");
      return(false);
   }
   if(!indicators.Add(GetPointer(m_lips)))
   {  printf(__FUNCTION__ + ": error adding object");
      return(false);
   }
//--- initialize object
   if(!m_stddev.Create(m_symbol.Name(), m_period, 8, 0, MODE_SMA, PRICE_CLOSE))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
   if(!m_gator.Create(m_symbol.Name(), m_period, 13, 0, 8, 0, 5, 0, MODE_SMA, PRICE_CLOSE))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
   if(!m_ad.Create(m_symbol.Name(), m_period, VOLUME_TICK))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
   if(!m_jaw.Create(m_symbol.Name(), m_period, 13, 8, MODE_SMA, PRICE_CLOSE))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
   if(!m_teeth.Create(m_symbol.Name(), m_period, 8, 5, MODE_SMA, PRICE_CLOSE))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
   if(!m_lips.Create(m_symbol.Name(), m_period, 5, 3, MODE_SMA, PRICE_CLOSE))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Detecting the "weighted" direction                               |
//+------------------------------------------------------------------+
double CSignalML_Gator_AD::Direction(void)
{  return(LongCondition() - ShortCondition());
}
//+------------------------------------------------------------------+
//| "Voting" that price will grow.                                   |
//+------------------------------------------------------------------+
int CSignalML_Gator_AD::LongCondition(void)
{  int result  = 0, results = 0;
   vectorf _x;
   _x.Init(2);
   _x.Fill(0.0);
//--- if the model 0 is used
   if(((m_patterns_usage & 0x01) != 0) && IsPattern_0(POSITION_TYPE_BUY))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_BUY, _x);
      if(_y > 0.0)
      {  result += m_pattern_0;
         results++;
      }
   }
//--- if the model 3 is used
   if(((m_patterns_usage & 0x08) != 0) && IsPattern_3(POSITION_TYPE_BUY))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_BUY, _x);
      if(_y > 0.0)
      {  result += m_pattern_3;
         results++;
      }
   }
//--- if the model 4 is used
   if(((m_patterns_usage & 0x10) != 0) && IsPattern_4(POSITION_TYPE_BUY))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_BUY, _x);
      if(_y > 0.0)
      {  result += m_pattern_4;
         results++;
      }
   }
//--- return the result
//if(result > 0)printf(__FUNCSIG__+" result is: %i",result);
   if(results > 0 && result > 0)
   {  return(int(round(result / results)));
   }
   return(0);
}
//+------------------------------------------------------------------+
//| "Voting" that price will fall.                                   |
//+------------------------------------------------------------------+
int CSignalML_Gator_AD::ShortCondition(void)
{  int result  = 0, results = 0;
   vectorf _x;
   _x.Init(2);
   _x.Fill(0.0);
//--- if the model 0 is used
   if(((m_patterns_usage & 0x01) != 0) && IsPattern_0(POSITION_TYPE_SELL))
   {  _x[1] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_SELL, _x);
      if(_y < 0.0)
      {  result += m_pattern_0;
         results++;
      }
   }
//--- if the model 3 is used
   if(((m_patterns_usage & 0x08) != 0) && IsPattern_3(POSITION_TYPE_SELL))
   {  _x[1] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_SELL, _x);
      if(_y < 0.0)
      {  result += m_pattern_3;
         results++;
      }
   }
//--- if the model 4 is used
   if(((m_patterns_usage & 0x10) != 0) && IsPattern_4(POSITION_TYPE_SELL))
   {  _x[1] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_SELL, _x);
      if(_y < 0.0)
      {  result += m_pattern_4;
         results++;
      }
   }
//--- return the result
//if(result > 0)printf(__FUNCSIG__+" result is: %i",result);
   if(results > 0 && result > 0)
   {  return(int(round(result / results)));
   }
   return(0);
}

//+------------------------------------------------------------------+
//| Check for Pattern 0.                                             |
//+------------------------------------------------------------------+
bool CSignalML_Gator_AD::IsPattern_0(ENUM_POSITION_TYPE T)
{  if
   (
      clrRed == Color_UP(m_gator, X()) &&
      clrGreen == Color_LO(m_gator, X())
   )
   {  if
      (
         T == POSITION_TYPE_BUY &&
         High(X() + 2) > High(X() + 3) &&
         High(X() + 1) >= High(X() + 2) &&
         Close(X()) >= High(X() + 1) &&
         AD(X() + 1) > AD(X() + 2) &&
         AD(X()) > AD(X() + 1)
      )
      {  return(true);
      }
      else if
      (
         T == POSITION_TYPE_SELL &&
         Low(X() + 2) < Low(X() + 3) &&
         Low(X() + 1) <= Low(X() + 2) &&
         Close(X()) <= Low(X() + 1) &&
         AD(X() + 1) < AD(X() + 2) &&
         AD(X()) < AD(X() + 1)
      )
      {  return(true);
      }
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 3.                                             |
//+------------------------------------------------------------------+
bool CSignalML_Gator_AD::IsPattern_3(ENUM_POSITION_TYPE T)
{  if
   (
      clrRed == Color_UP(m_gator, X() + 1) &&
      clrRed == Color_LO(m_gator, X() + 1) &&
      clrRed == Color_UP(m_gator, X()) &&
      clrGreen == Color_LO(m_gator, X())
   )
   {  if
      (
         T == POSITION_TYPE_BUY &&
         Close(X()) - Low(X() + 1) > 0.5 * (High(X() + 1) - Low(X() + 1)) &&
         AD(X() + 2) > AD(X()) &&
         AD(X()) > AD(X() + 1)
      )
      {  return(true);
      }
      else if
      (
         T == POSITION_TYPE_SELL &&
         High(X() + 1) - Close(X()) > 0.5 * (High(X() + 1) - Low(X() + 1)) &&
         AD(X() + 2) < AD(X()) &&
         AD(X()) < AD(X() + 1)
      )
      {  return(true);
      }
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 4.                                             |
//+------------------------------------------------------------------+
bool CSignalML_Gator_AD::IsPattern_4(ENUM_POSITION_TYPE T)
{  if
   (
      clrGreen == Color_UP(m_gator, X() + 1) &&
      clrRed == Color_LO(m_gator, X() + 1) &&
      clrRed == Color_UP(m_gator, X()) &&
      clrGreen == Color_LO(m_gator, X())
   )
   {  if
      (
         T == POSITION_TYPE_BUY &&
         Close(X()) > Close(X() + 1) &&
         Low(X() + 1) > Low(X()) &&
         AD(X()) > AD(X() + 1)
      )
      {  return(true);
      }
      else if
      (
         T == POSITION_TYPE_SELL &&
         Close(X()) < Close(X() + 1) &&
         High(X() + 1) < High(X()) &&
         AD(X()) < AD(X() + 1)
      )
      {  return(true);
      }
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Forward Feed Network, to Get Forecast State.                     |
//+------------------------------------------------------------------+
double CSignalML_Gator_AD::RunModel(int Index, ENUM_POSITION_TYPE T, vectorf &X)
{  vectorf _y(1);
   _y.Fill(0.0);
   Print(" x: ",__FUNCTION__,X);
   ResetLastError();
   if(!OnnxRun(m_handles[Index], ONNX_NO_CONVERSION, X, _y))
   {  printf(__FUNCSIG__ + " failed to get y forecast, err: %i", GetLastError());
      return(double(_y[0]));
   }
   //printf(__FUNCSIG__ + " pre y is: "+DoubleToString(_y[0],5));
   if(T == POSITION_TYPE_BUY && _y[0] > 0.5f)
   {  _y[0] = 2.0f * (_y[0] - 0.5f);
   }
   else if(T == POSITION_TYPE_SELL && _y[0] < 0.5f)
   {  _y[0] = 2.0f * (0.5f - _y[0]);
   }
   //printf(__FUNCSIG__ + " post y is: ", DoubleToString(_y[0],5));
   return(double(_y[0]));
}
//+------------------------------------------------------------------+
