//+------------------------------------------------------------------+
//|                                       DMD_Price_Decompostion.mq5 |
//|                                  Copyright 2025, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2025, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"
#property script_show_inputs
#include<dmd_utils.mqh>
//--- input parameters
input string   Symbol_="AUDUSD";
input ENUM_TIMEFRAMES   TimeFrame=PERIOD_D1;
input datetime StartDate=D'2025.06.02';
input ENUM_DMD_SCALE jobs = DMDSCALE_N;
input ENUM_DMD_EIGV jobz = DMDEIGV_V;
input ENUM_DMD_RESIDUALS jobr = DMDRESIDUALS_R;
input ENUM_DMD_REFINE jobf = DMDREFINE_R;
input ENUM_SVD_ALG whtsvd = SVDALG_1;
input long nrnk = 20;
input double tol_ = 1.e-9;//tol
input ulong Delay = 50;//apply time delay embedding
input ulong Num_Future_steps = 10;
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   vector prices;
   if(!prices.CopyRates(Symbol_,TimeFrame,COPY_RATES_CLOSE,StartDate,100+Num_Future_steps))
    {
     Print(" failed to get close prices for ", Symbol_,". Error ", GetLastError());
     return;
    }
//---
   matrix X = matrix::Zeros(1,100);
   vector input_series = np::sliceVector(prices,0,100);
   X.Row(input_series,0);
   np::matrix2csv("AUDUSD.csv",X.Transpose());
//---
   CDmd dmd;
   if(!dmd.fit(X,1,tol_,nrnk,Delay,jobs,whtsvd,jobz,jobr,jobf))
      return;
   else
      Print(" It worked! ");
   
   vectorc egs = dmd.dmd_eigs();  
   Print("DMD eigenvalues or Ritz values\n",egs);
   
   matrix forecast = dmd.reconstructed_data(Num_Future_steps);
   vector time = np::arange(prices.Size(),0.0,dmd.dmd_time_delta());
   plot_forecast(prices,forecast.Row(0),time,Num_Future_steps," Price forecast",0,0,0,0,750,400,true,30);
  }
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//| plot forecasts evaluation                                        |
//+------------------------------------------------------------------+
void plot_forecast(vector& actual,vector& forecast,vector& time,ulong num_forecasts,string plot_name, long chart_id=0, int sub_win=0,int x1=0, int y1=0, int x2=750, int y2=500, bool chart_show=true, int duration = 10)
  {
   if(time.Size()!=actual.Size() || forecast.Size() != time.Size())
     {
      Print(__FUNCTION__, " Invalid inputs ");
      return;
     }
   
   double xa[],ya[],yb[],xc[],yc[];

   if(!np::vecAsArray(time,xa) || !np::vecAsArray(actual,ya) || !np::vecAsArray(forecast,yb))
     {
      Print(__FUNCTION__," Failed to Create graphical object on the Main chart Err ", GetLastError());
      return;
     }
   for(ulong i = time.Size()-num_forecasts;i<time.Size(); i++)
     {
      xc.Push(time[i]);
      yc.Push(forecast[i]);
     }

   CGraphic graph;
   ChartRedraw();
   ChartSetInteger(chart_id, CHART_SHOW, chart_show);

   if(!graph.Create(chart_id, plot_name, sub_win, x1, y1, x2, y2))
     {
      Print(__FUNCTION__," Failed to Create graphical object on the Main chart Err ", GetLastError());
      return;
     }

   CColorGenerator generator;
   graph.HistoryNameWidth(100);
   graph.HistoryNameSize(13);
   CCurve* actual_curve = graph.CurveAdd(xa, ya, clrYellow,CURVE_LINES,"Actual");
   actual_curve.LinesWidth(6);
   actual_curve.LinesStyle(STYLE_SOLID);

   CCurve* forecast_curve = graph.CurveAdd(xa,yb,clrBlack,CURVE_LINES,"DMD Reconstruction");
   forecast_curve.LinesStyle(STYLE_DOT);
   forecast_curve.LinesWidth(4);
   
   CCurve* forecasts = graph.CurveAdd(xc,yc,clrBlue,CURVE_LINES,"DMD forecast");
   forecasts.LinesStyle(STYLE_DOT);
   forecasts.LinesWidth(4);

   graph.XAxis().Name("Time");
   graph.XAxis().NameSize(13);
   graph.YAxis().Name("Y values");
   graph.YAxis().NameSize(13);

   graph.FontSet("Lucida Console", 13);
   graph.CurvePlotAll();
   graph.Update();

   Sleep(duration*1000);
   graph.Destroy();
   ChartRedraw();
   return ;

  }