//+------------------------------------------------------------------+
//|                                                     Parafrac.mq4 |
//|                        Copyright 2023, MetaQuotes Software Corp. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Wamek EA"
#property link      "https://www.mql5.com/en/users/wamek"
#property version   "1.00"
#property strict

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 Lime      // UpLevel
#property indicator_color2 Red       // DownLevel
#property indicator_width1 2
#property indicator_width2 2

#property indicator_level1     2.5
#property indicator_level2    -2.5
#property indicator_level3     5.0
#property indicator_level4    -5.0
#property indicator_level5     7.5
#property indicator_level6    -7.5

#property indicator_maximum    10
#property indicator_minimum   -10


//---- indicator buffers
double UpLevelBuffer[];
double DownLevelBuffer[];

double fractalHigh;
double fractalLow;

//--Input parameter--
input double pstep =0.02;
input double pMax =0.2;
int lookback=20;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   SetIndexStyle(0, DRAW_HISTOGRAM);
   SetIndexBuffer(0, UpLevelBuffer);
   SetIndexLabel(0, "UpLevel");

   SetIndexStyle(1, DRAW_HISTOGRAM);
   SetIndexBuffer(1, DownLevelBuffer);
   SetIndexLabel(1, "DownLevel");

   return(0);
  }

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
 if(rates_total<lookback+50)return 0;
 
  int limit = prev_calculated==0? 
              rates_total-(lookback+50): rates_total-prev_calculated+1;

  for (int i = limit; i >=0; i--) // Ensure enough candles for fractals
    {
      double psar = iSAR(NULL, 0, pstep, pMax, i);
      
     int j =i; 
    for(j=i; j<=i+lookback ; j++ ){
       double fracHigh = iFractals(NULL, 0, MODE_UPPER, j);
     
       if( fracHigh>0 ){ fractalHigh=fracHigh; break; }
      }
      
    for(j=i; j<=i+lookback ; j++ ){  
       double fracLow = iFractals(NULL, 0, MODE_LOWER, j);
     
       if(fracLow>0){ fractalLow=fracLow; break; }
       }

      // Skip if fractals not available
    if (fractalHigh == 0 || fractalLow == 0)
        {
         UpLevelBuffer[i] = 0;
         DownLevelBuffer[i] = 0;
         continue;
        }

      double fractalDiff = MathAbs(fractalHigh - fractalLow);
      if (fractalDiff == 0)fractalDiff = Point; // avoid division by zero

      double minOC = MathMin(Open[i], Close[i]);
      double maxOC = MathMax(Open[i], Close[i]);

      double upLevel = (minOC - psar) / fractalDiff;
      double downLevel = (maxOC - psar) / fractalDiff;

      if (upLevel > 0)
        {
         UpLevelBuffer[i] = upLevel;
         DownLevelBuffer[i] = 0;
        }
      else if (downLevel < 0)
        {
         DownLevelBuffer[i] = downLevel;
         UpLevelBuffer[i] = 0;
        }
      else
        {
         // If neither condition met
         UpLevelBuffer[i] = 0;
         DownLevelBuffer[i] = 0;
        }
     }

   
//--- return value of prev_calculated for next call
   return(rates_total);
  }
  
//+------------------------------------------------------------------+
