//+------------------------------------------------------------------+
//|                                        SignalML_AO_Envelopes.mqh |
//|                             Copyright 2000-2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#include <Expert\ExpertSignal.mqh>

#resource "Python/76_4.onnx" as uchar __76_4[]
#resource "Python/76_8.onnx" as uchar __76_8[]
#resource "Python/76_9.onnx" as uchar __76_9[]
#define __PATTERNS 3
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Signals of ML with AO and Envelopes                             |
//| Type=SignalAdvanced                                              |
//| Name=AO and Envelopes                                                 |
//| ShortName=ML_AO_Envelopes                                             |
//| Class=CSignalML_AO_Envelopes                                          |
//| Page=signal_ao_envelopes                                              |
//| Parameter=Pattern_4,int,50,Pattern 4                             |
//| Parameter=Pattern_8,int,50,Pattern 8                             |
//| Parameter=Pattern_9,int,50,Pattern 9                             |
//| Parameter=PatternsUsed,int,255,Patterns Used BitMap              |
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+
//| Class CSignalML_AO_Envelopes.                                         |
//| Purpose: Class of generator of trade signals based on            |
//|          Signals of ML with AO and Envelopes                          |
//| Is derived from the CExpertSignal class.                         |
//+------------------------------------------------------------------+
#define __PERIOD 15
class CSignalML_AO_Envelopes : public CExpertSignal
{
protected:
   CiAO            m_ao;
   //CiEnvelopes             m_envelopes;
   CiMA              m_hi, m_lo;
   
   int               m_patterns_used;

   long              m_handles[__PATTERNS];
   //--- adjusted parameters

   //--- "weights" of market models (0-100)
   int               m_pattern_4;      // model 2
   int               m_pattern_8;      // model 3
   int               m_pattern_9;      // model 5
   //
   //int               m_patterns_usage;   //

public:
   CSignalML_AO_Envelopes(void);
   ~CSignalML_AO_Envelopes(void);
   //--- methods of setting adjustable parameters
   //--- methods of adjusting "weights" of market models
   void              Pattern_4(int value)
   {  m_pattern_4 = value;
   }
   void              Pattern_8(int value)
   {  m_pattern_8 = value;
   }
   void              Pattern_9(int value)
   {  m_pattern_9 = value;
   }
   void              PatternsUsed(int value)
   {  m_patterns_used = value;
      PatternsUsage(value);
   }
   //--- method of verification of settings
   virtual bool      ValidationSettings(void);
   //--- method of creating the oscillator and timeseries
   virtual bool      InitIndicators(CIndicators *indicators);
   //--- methods of checking if the market models are formed
   virtual int       LongCondition(void) override;
   virtual int       ShortCondition(void) override;
   virtual double    Direction(void) override;

protected:
   //--- method of initialization of the oscillator
   bool              InitML_AO_Envelopes(CIndicators *indicators);
   //--- methods of getting data
   double            AO(int ind)
   {  //
      m_ao.Refresh(-1);
      return(m_ao.Main(ind));
   }
   double            Envelopes_Up(int ind)
   {  //
      m_hi.Refresh(-1);
      return(m_hi.Main(ind));
   }
   double            Envelopes_Lo(int ind)
   {  //
      m_lo.Refresh(-1);
      return(m_lo.Main(ind));
   }
   double            Envelopes_Mid(int ind)
   {  //
      return(0.5 * (Envelopes_Up(ind) + Envelopes_Lo(ind)));
   }
   double            Close(int ind)
   {  //
      m_close.Refresh(-1);
      return(m_symbol.Bid() + (m_close.GetData(ind) - m_close.GetData(X())));
   }
   double            High(int ind)
   {  //
      m_high.Refresh(-1);
      return(m_high.GetData(ind));
   }
   double            Low(int ind)
   {  //
      m_low.Refresh(-1);
      return(m_low.GetData(ind));
   }
   int               X()
   {  //
      return(StartIndex());
   }
   //--- methods to check for patterns
   bool              IsPattern_4(ENUM_POSITION_TYPE T);
   bool              IsPattern_8(ENUM_POSITION_TYPE T);
   bool              IsPattern_9(ENUM_POSITION_TYPE T);

   double            RunModel(int Index, ENUM_POSITION_TYPE T, vectorf &X);
};
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
CSignalML_AO_Envelopes::CSignalML_AO_Envelopes(void) : m_pattern_4(50),
   m_pattern_8(50),
   m_pattern_9(50)
//m_patterns_usage(255)
{
//--- initialization of protected data
   m_used_series = USE_SERIES_OPEN + USE_SERIES_HIGH + USE_SERIES_LOW + USE_SERIES_CLOSE + USE_SERIES_TICK_VOLUME;
   PatternsUsage(m_patterns_usage);
//--- create model from static buffer
   m_handles[0] = OnnxCreateFromBuffer(__76_4, ONNX_DEFAULT);
   m_handles[1] = OnnxCreateFromBuffer(__76_8, ONNX_DEFAULT);
   m_handles[2] = OnnxCreateFromBuffer(__76_9, ONNX_DEFAULT);
}
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
CSignalML_AO_Envelopes::~CSignalML_AO_Envelopes(void)
{
}
//+------------------------------------------------------------------+
//| Validation settings protected data.                              |
//+------------------------------------------------------------------+
bool CSignalML_AO_Envelopes::ValidationSettings(void)
{
//--- validation settings of additional filters
   if(!CExpertSignal::ValidationSettings())
      return(false);
//--- initial data checks
   const ulong _out_shape[] = {1, 1};
   for(int i = 0; i < __PATTERNS; i++)
   {  // Set input shapes
      const ulong _in_shape[] = {1, 2};
      if(!OnnxSetInputShape(m_handles[i], ONNX_DEFAULT, _in_shape))
      {  Print("OnnxSetInputShape error ", GetLastError(), " for feature: ", i);
         return(false);
      }
      // Set output shapes
      if(!OnnxSetOutputShape(m_handles[i], 0, _out_shape))
      {  Print("OnnxSetOutputShape error ", GetLastError(), " for feature: ", i);
         return(false);
      }
   }
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Create indicators.                                               |
//+------------------------------------------------------------------+
bool CSignalML_AO_Envelopes::InitIndicators(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- initialization of indicators and timeseries of additional filters
   if(!CExpertSignal::InitIndicators(indicators))
      return(false);
//--- create and initialize MA oscillator
   if(!InitML_AO_Envelopes(indicators))
      return(false);
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Initialize MA indicators.                                        |
//+------------------------------------------------------------------+
bool CSignalML_AO_Envelopes::InitML_AO_Envelopes(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- add object to collection
//--- add object to collection
   if(!indicators.Add(GetPointer(m_ao)))
   {  printf(__FUNCTION__ + ": error adding object");
      return(false);
   }
   if(!indicators.Add(GetPointer(m_hi)))
   {  printf(__FUNCTION__ + ": error adding object");
      return(false);
   }
   if(!indicators.Add(GetPointer(m_lo)))
   {  printf(__FUNCTION__ + ": error adding object");
      return(false);
   }
//--- initialize object
   if(!m_ao.Create(m_symbol.Name(), m_period))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
   //if(!m_envelopes.Create(m_symbol.Name(), m_period, 14, 0, MODE_SMA, PRICE_TYPICAL, 0.02))
   //{  printf(__FUNCTION__ + ": error initializing object");
   //   return(false);
   //}
   if(!m_hi.Create(m_symbol.Name(), m_period, 14, 0, MODE_SMA, PRICE_HIGH))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
   if(!m_lo.Create(m_symbol.Name(), m_period, 14, 0, MODE_SMA, PRICE_LOW))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Detecting the "weighted" direction                               |
//+------------------------------------------------------------------+
double CSignalML_AO_Envelopes::Direction(void)
{  return(LongCondition() - ShortCondition());
}
//+------------------------------------------------------------------+
//| "Voting" that price will grow.                                   |
//+------------------------------------------------------------------+
int CSignalML_AO_Envelopes::LongCondition(void)
{  int result  = 0, results = 0;
   vectorf _x;
   _x.Init(2);
   _x.Fill(0.0);
//--- if the model 4 is used
   if(((m_patterns_usage & 0x10) != 0) && IsPattern_4(POSITION_TYPE_BUY))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_BUY, _x);
      if(_y > 0.0)
      {  result += m_pattern_4;
         results++;
      }
   }
//--- if the model 8 is used
   if(((m_patterns_usage & 0x100) != 0) && IsPattern_8(POSITION_TYPE_BUY))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_BUY, _x);
      if(_y > 0.0)
      {  result += m_pattern_8;
         results++;
      }
   }
//--- if the model 9 is used
   if(((m_patterns_usage & 0x200) != 0) && IsPattern_9(POSITION_TYPE_BUY))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_BUY, _x);
      if(_y > 0.0)
      {  result += m_pattern_9;
         results++;
      }
   }
//--- return the result
//if(result > 0)printf(__FUNCSIG__+" result is: %i",result);
   if(results > 0 && result > 0)
   {  return(int(round(result / results)));
   }
   return(0);
}
//+------------------------------------------------------------------+
//| "Voting" that price will fall.                                   |
//+------------------------------------------------------------------+
int CSignalML_AO_Envelopes::ShortCondition(void)
{  int result  = 0, results = 0;
   vectorf _x;
   _x.Init(2);
   _x.Fill(0.0);
//--- if the model 4 is used
   if(((m_patterns_usage & 0x10) != 0) && IsPattern_4(POSITION_TYPE_SELL))
   {  _x[1] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_SELL, _x);
      if(_y < 0.0)
      {  result += m_pattern_4;
         results++;
      }
   }
//--- if the model 8 is used
   if(((m_patterns_usage & 0x100) != 0) && IsPattern_8(POSITION_TYPE_SELL))
   {  _x[1] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_SELL, _x);
      if(_y < 0.0)
      {  result += m_pattern_8;
         results++;
      }
   }
//--- if the model 9 is used
   if(((m_patterns_usage & 0x200) != 0) && IsPattern_9(POSITION_TYPE_SELL))
   {  _x[1] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_SELL, _x);
      if(_y < 0.0)
      {  result += m_pattern_9;
         results++;
      }
   }
//--- return the result
//if(result > 0)printf(__FUNCSIG__+" result is: %i",result);
   if(results > 0 && result > 0)
   {  return(int(round(result / results)));
   }
   return(0);
}

//+------------------------------------------------------------------+
//| Check for Pattern 4.                                             |
//+------------------------------------------------------------------+
bool CSignalML_AO_Envelopes::IsPattern_4(ENUM_POSITION_TYPE T)
{  if
   (
      T == POSITION_TYPE_BUY &&
      AO(X() + 2) > AO(X() + 1) &&
      AO(X() + 1) < AO(X()) &&
      AO(X() + 1) > 0.0 &&
      Close(X() + 2) <= Envelopes_Mid(X() + 2) &&
      Close(X() + 2) >= Envelopes_Lo(X() + 2) &&
      Close(X() + 1) <= Envelopes_Mid(X() + 1) &&
      Close(X() + 1) >= Envelopes_Lo(X() + 1) &&
      Close(X()) <= Envelopes_Mid(X()) &&
      Close(X()) >= Envelopes_Lo(X())
   )
   {  return(true);
   }
   else if
   (
      T == POSITION_TYPE_SELL &&
      AO(X() + 2) > AO(X() + 1) &&
      AO(X() + 1) < AO(X()) &&
      AO(X() + 1) > 0.0 &&
      Close(X() + 2) >= Envelopes_Mid(X() + 2) &&
      Close(X() + 2) <= Envelopes_Up(X() + 2) &&
      Close(X() + 1) >= Envelopes_Mid(X() + 1) &&
      Close(X() + 1) <= Envelopes_Up(X() + 1) &&
      Close(X()) >= Envelopes_Mid(X()) &&
      Close(X()) <= Envelopes_Up(X())
   )
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 8.                                             |
//+------------------------------------------------------------------+
bool CSignalML_AO_Envelopes::IsPattern_8(ENUM_POSITION_TYPE T)
{  if
   (
      T == POSITION_TYPE_BUY &&
      AO(X() + 2) > 0.0 &&
      AO(X() + 1) > AO(X() + 2) &&
      AO(X()) > AO(X() + 1) &&
      Close(X() + 2) > Envelopes_Up(X() + 2) &&
      Close(X() + 1) > Close(X() + 2) &&
      Close(X()) > Close(X() + 1)
   )
   {  return(true);
   }
   else if
   (
      T == POSITION_TYPE_SELL &&
      AO(X() + 2) < 0.0 &&
      AO(X() + 1) < AO(X() + 2) &&
      AO(X()) < AO(X() + 1) &&
      Close(X() + 2) < Envelopes_Lo(X() + 2) &&
      Close(X() + 1) < Close(X() + 2) &&
      Close(X()) < Close(X() + 1)
   )
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 9.                                             |
//+------------------------------------------------------------------+
bool CSignalML_AO_Envelopes::IsPattern_9(ENUM_POSITION_TYPE T)
{  if
   (
      T == POSITION_TYPE_BUY &&
      AO(X() + 2) > AO(X() + 1) &&
      AO(X() + 1) > AO(X()) &&
      AO(X()) > 0.0 &&
      Close(X() + 2) > Envelopes_Mid(X() + 2) &&
      Close(X() + 1) <= Envelopes_Mid(X() + 1) &&
      Close(X()) > Envelopes_Mid(X())
   )
   {  return(true);
   }
   else if
   (
      T == POSITION_TYPE_SELL &&
      AO(X() + 2) < AO(X() + 1) &&
      AO(X() + 1) < AO(X()) &&
      AO(X()) < 0.0 &&
      Close(X() + 2) < Envelopes_Mid(X() + 2) &&
      Close(X() + 1) >= Envelopes_Mid(X() + 1) &&
      Close(X()) < Envelopes_Mid(X())
   )
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Forward Feed Network, to Get Forecast State.                     |
//+------------------------------------------------------------------+
double CSignalML_AO_Envelopes::RunModel(int Index, ENUM_POSITION_TYPE T, vectorf &X)
{  vectorf _y(1);
   _y.Fill(0.0);
   Print(" x: ",__FUNCTION__,X);
   ResetLastError();
   if(!OnnxRun(m_handles[Index], ONNX_NO_CONVERSION, X, _y))
   {  printf(__FUNCSIG__ + " failed to get y forecast, err: %i", GetLastError());
      return(double(_y[0]));
   }
   //printf(__FUNCSIG__ + " pre y is: "+DoubleToString(_y[0],5));
   if(T == POSITION_TYPE_BUY && _y[0] > 0.5f)
   {  _y[0] = 2.0f * (_y[0] - 0.5f);
   }
   else if(T == POSITION_TYPE_SELL && _y[0] < 0.5f)
   {  _y[0] = 2.0f * (0.5f - _y[0]);
   }
   //printf(__FUNCSIG__ + " post y is: ", DoubleToString(_y[0],5));
   return(double(_y[0]));
}
//+------------------------------------------------------------------+
