//+------------------------------------------------------------------+
//|                                     SignalAO_Envelopes.mqh |
//|                             Copyright 2000-2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#include <Expert\ExpertSignal.mqh>
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Signals of AO and Envelopes                                |
//| Type=SignalAdvanced                                              |
//| Name=AO and Envelopes                                            |
//| ShortName=AO_Envelopes                                               |
//| Class=CSignalAO_Envelopes                                            |
//| Page=signal_ao_envelopes                                             |
//| Parameter=Pattern_0,int,50,Pattern 0                             |
//| Parameter=Pattern_1,int,50,Pattern 1                             |
//| Parameter=Pattern_2,int,50,Pattern 2                             |
//| Parameter=Pattern_3,int,50,Pattern 3                             |
//| Parameter=Pattern_4,int,50,Pattern 4                             |
//| Parameter=Pattern_5,int,50,Pattern 5                             |
//| Parameter=Pattern_6,int,50,Pattern 6                             |
//| Parameter=Pattern_7,int,50,Pattern 7                             |
//| Parameter=Pattern_8,int,50,Pattern 8                             |
//| Parameter=Pattern_9,int,50,Pattern 9                             |
//| Parameter=PatternsUsed,int,255,Patterns Used BitMap              |
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+
//| Class CSignalAO_Envelopes.                                 |
//| Purpose: Class of generator of trade signals based on            |
//|          Signals of TRIX and Williams Percent Range.             |
//| Is derived from the CExpertSignal class.                         |
//+------------------------------------------------------------------+
#define __PERIOD 15
class CSignalAO_Envelopes : public CExpertSignal
{
protected:
   CiAO            m_ao;
   //CiEnvelopes             m_envelopes;
   CiMA              m_hi, m_lo;
   int               m_patterns_used;
   //--- adjusted parameters

   //--- "weights" of market models (0-100)
   int               m_pattern_0;      // model 0
   int               m_pattern_1;      // model 1
   int               m_pattern_2;      // model 2
   int               m_pattern_3;      // model 3
   int               m_pattern_4;      // model 4
   int               m_pattern_5;      // model 5
   int               m_pattern_6;      // model 6
   int               m_pattern_7;      // model 7
   int               m_pattern_8;      // model 8
   int               m_pattern_9;      // model 9
   //
   //int               m_patterns_usage;   //

public:
   CSignalAO_Envelopes(void);
   ~CSignalAO_Envelopes(void);
   //--- methods of setting adjustable parameters
   //--- methods of adjusting "weights" of market models
   void              Pattern_0(int value)
   {  m_pattern_0 = value;
   }
   void              Pattern_1(int value)
   {  m_pattern_1 = value;
   }
   void              Pattern_2(int value)
   {  m_pattern_2 = value;
   }
   void              Pattern_3(int value)
   {  m_pattern_3 = value;
   }
   void              Pattern_4(int value)
   {  m_pattern_4 = value;
   }
   void              Pattern_5(int value)
   {  m_pattern_5 = value;
   }
   void              Pattern_6(int value)
   {  m_pattern_6 = value;
   }
   void              Pattern_7(int value)
   {  m_pattern_7 = value;
   }
   void              Pattern_8(int value)
   {  m_pattern_8 = value;
   }
   void              Pattern_9(int value)
   {  m_pattern_9 = value;
   }
   void              PatternsUsed(int value)
   {  m_patterns_used = value;
      PatternsUsage(value);
   }
   //--- method of verification of settings
   virtual bool      ValidationSettings(void);
   //--- method of creating the oscillator and timeseries
   virtual bool      InitIndicators(CIndicators *indicators);
   //--- methods of checking if the market models are formed
   virtual int       LongCondition(void) override;
   virtual int       ShortCondition(void) override;
   virtual double    Direction(void) override;

protected:
   //--- method of initialization of the oscillator
   bool              InitAO_Envelopes(CIndicators *indicators);
   //--- methods of getting data
   double            AO(int ind)
   {  //
      m_ao.Refresh(-1);
      return(m_ao.Main(ind));
   }
   vector            AO_Last3(int ind)
   {  //
      vector _last(3);
      _last.Fill(0.0);
      int _count = 0, _index = ind;
      do
      {  if((AO(_index) > AO(_index + 1) && AO(_index + 1) < AO(_index + 2)) || (AO(_index) < AO(_index + 1) && AO(_index + 1) > AO(_index + 2)))
         {  _last[_count] = AO(_index + 1);
            _count++;
         }
         _index++;
         if(_index >= 14)
         {  break;
         }
      }
      while(_count < 3);
      return(_last);
   }
   double            Envelopes_Up(int ind)
   {  //
      m_hi.Refresh(-1);
      return(m_hi.Main(ind));
   }
   double            Envelopes_Lo(int ind)
   {  //
      m_lo.Refresh(-1);
      return(m_lo.Main(ind));
   }
   double            Envelopes_Mid(int ind)
   {  //
      return(0.5 * (Envelopes_Up(ind) + Envelopes_Lo(ind)));
   }
   double            Close(int ind)
   {  //
      m_close.Refresh(-1);
      return(m_symbol.Bid() + (m_close.GetData(ind) - m_close.GetData(X())));
   }
   double            High(int ind)
   {  //
      m_high.Refresh(-1);
      return(m_high.GetData(ind));
   }
   double            Low(int ind)
   {  //
      m_low.Refresh(-1);
      return(m_low.GetData(ind));
   }
   int               X()
   {  //
      return(StartIndex());
   }
   //--- methods to check for patterns
   bool              IsPattern_0(ENUM_POSITION_TYPE T);
   bool              IsPattern_1(ENUM_POSITION_TYPE T);
   bool              IsPattern_2(ENUM_POSITION_TYPE T);
   bool              IsPattern_3(ENUM_POSITION_TYPE T);
   bool              IsPattern_4(ENUM_POSITION_TYPE T);
   bool              IsPattern_5(ENUM_POSITION_TYPE T);
   bool              IsPattern_6(ENUM_POSITION_TYPE T);
   bool              IsPattern_7(ENUM_POSITION_TYPE T);
   bool              IsPattern_8(ENUM_POSITION_TYPE T);
   bool              IsPattern_9(ENUM_POSITION_TYPE T);
};
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
CSignalAO_Envelopes::CSignalAO_Envelopes(void) : m_pattern_0(50),
   m_pattern_1(50),
   m_pattern_2(50),
   m_pattern_3(50),
   m_pattern_4(50),
   m_pattern_5(50),
   m_pattern_6(50),
   m_pattern_7(50),
   m_pattern_8(50),
   m_pattern_9(50)
//m_patterns_usage(255)
{
//--- initialization of protected data
   m_used_series = USE_SERIES_OPEN + USE_SERIES_HIGH + USE_SERIES_LOW + USE_SERIES_CLOSE + USE_SERIES_TICK_VOLUME;
   PatternsUsage(m_patterns_usage);
}
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
CSignalAO_Envelopes::~CSignalAO_Envelopes(void)
{
}
//+------------------------------------------------------------------+
//| Validation settings protected data.                              |
//+------------------------------------------------------------------+
bool CSignalAO_Envelopes::ValidationSettings(void)
{
//--- validation settings of additional filters
   if(!CExpertSignal::ValidationSettings())
      return(false);
//--- initial data checks
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Create indicators.                                               |
//+------------------------------------------------------------------+
bool CSignalAO_Envelopes::InitIndicators(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- initialization of indicators and timeseries of additional filters
   if(!CExpertSignal::InitIndicators(indicators))
      return(false);
//--- create and initialize MA oscillator
   if(!InitAO_Envelopes(indicators))
      return(false);
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Initialize MA indicators.                                        |
//+------------------------------------------------------------------+
bool CSignalAO_Envelopes::InitAO_Envelopes(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- add object to collection
   if(!indicators.Add(GetPointer(m_ao)))
   {  printf(__FUNCTION__ + ": error adding object");
      return(false);
   }
   //if(!indicators.Add(GetPointer(m_envelopes)))
   //{  printf(__FUNCTION__ + ": error adding object");
   //   return(false);
   //}
   if(!indicators.Add(GetPointer(m_hi)))
   {  printf(__FUNCTION__ + ": error adding object");
      return(false);
   }
   if(!indicators.Add(GetPointer(m_lo)))
   {  printf(__FUNCTION__ + ": error adding object");
      return(false);
   }
//--- initialize object
   if(!m_ao.Create(m_symbol.Name(), m_period))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
   //if(!m_envelopes.Create(m_symbol.Name(), m_period, 14, 0, MODE_SMA, PRICE_TYPICAL, 0.02))
   //{  printf(__FUNCTION__ + ": error initializing object");
   //   return(false);
   //}
   if(!m_hi.Create(m_symbol.Name(), m_period, 14, 0, MODE_SMA, PRICE_HIGH))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
   if(!m_lo.Create(m_symbol.Name(), m_period, 14, 0, MODE_SMA, PRICE_LOW))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Detecting the "weighted" direction                               |
//+------------------------------------------------------------------+
double CSignalAO_Envelopes::Direction(void)
{  return(LongCondition() - ShortCondition());
}
//+------------------------------------------------------------------+
//| "Voting" that price will grow.                                   |
//+------------------------------------------------------------------+
int CSignalAO_Envelopes::LongCondition(void)
{  int result  = 0, results = 0;
//--- if the model 0 is used
   if(((m_patterns_usage & 0x01) != 0) && IsPattern_0(POSITION_TYPE_BUY))
   {  result += m_pattern_0;
      results++;
   }
//--- if the model 1 is used
   if(((m_patterns_usage & 0x02) != 0) && IsPattern_1(POSITION_TYPE_BUY))
   {  result += m_pattern_1;
      results++;
   }
//--- if the model 2 is used
   if(((m_patterns_usage & 0x04) != 0) && IsPattern_2(POSITION_TYPE_BUY))
   {  result += m_pattern_2;
      results++;
   }
//--- if the model 3 is used
   if(((m_patterns_usage & 0x08) != 0) && IsPattern_3(POSITION_TYPE_BUY))
   {  result += m_pattern_3;
      results++;
   }
//--- if the model 4 is used
   if(((m_patterns_usage & 0x10) != 0) && IsPattern_4(POSITION_TYPE_BUY))
   {  result += m_pattern_4;
      results++;
   }
//--- if the model 5 is used
   if(((m_patterns_usage & 0x20) != 0) && IsPattern_5(POSITION_TYPE_BUY))
   {  result += m_pattern_5;
      results++;
   }
//--- if the model 6 is used
   if(((m_patterns_usage & 0x40) != 0) && IsPattern_6(POSITION_TYPE_BUY))
   {  result += m_pattern_6;
      results++;
   }
//--- if the model 7 is used
   if(((m_patterns_usage & 0x80) != 0) && IsPattern_7(POSITION_TYPE_BUY))
   {  result += m_pattern_7;
      results++;
   }
//--- if the model 8 is used
   if(((m_patterns_usage & 0x100) != 0) && IsPattern_8(POSITION_TYPE_BUY))
   {  result += m_pattern_8;
      results++;
   }
//--- if the model 9 is used
   if(((m_patterns_usage & 0x200) != 0) && IsPattern_9(POSITION_TYPE_BUY))
   {  result += m_pattern_9;
      results++;
   }
//--- return the result
//if(result > 0)printf(__FUNCSIG__+" result is: %i",result);
   if(results > 0 && result > 0)
   {  return(int(round(result / results)));
   }
   return(0);
}
//+------------------------------------------------------------------+
//| "Voting" that price will fall.                                   |
//+------------------------------------------------------------------+
int CSignalAO_Envelopes::ShortCondition(void)
{  int result  = 0, results = 0;
//--- if the model 0 is used
   if(((m_patterns_used & 0x01) != 0) && IsPattern_0(POSITION_TYPE_SELL))
   {  result += m_pattern_0;
      results++;
   }
//--- if the model 1 is used
   if(((m_patterns_usage & 0x02) != 0) && IsPattern_1(POSITION_TYPE_SELL))
   {  result += m_pattern_1;
      results++;
   }
//--- if the model 2 is used
   if(((m_patterns_usage & 0x04) != 0) && IsPattern_2(POSITION_TYPE_SELL))
   {  result += m_pattern_2;
      results++;
   }
//--- if the model 3 is used
   if(((m_patterns_usage & 0x08) != 0) && IsPattern_3(POSITION_TYPE_SELL))
   {  result += m_pattern_3;
      results++;
   }
//--- if the model 4 is used
   if(((m_patterns_usage & 0x10) != 0) && IsPattern_4(POSITION_TYPE_SELL))
   {  result += m_pattern_4;
      results++;
   }
//--- if the model 5 is used
   if(((m_patterns_usage & 0x20) != 0) && IsPattern_5(POSITION_TYPE_SELL))
   {  result += m_pattern_5;
      results++;
   }
//--- if the model 6 is used
   if(((m_patterns_usage & 0x40) != 0) && IsPattern_6(POSITION_TYPE_SELL))
   {  result += m_pattern_6;
      results++;
   }
//--- if the model 7 is used
   if(((m_patterns_usage & 0x80) != 0) && IsPattern_7(POSITION_TYPE_SELL))
   {  result += m_pattern_7;
      results++;
   }
//--- if the model 8 is used
   if(((m_patterns_usage & 0x100) != 0) && IsPattern_8(POSITION_TYPE_SELL))
   {  result += m_pattern_8;
      results++;
   }
//--- if the model 9 is used
   if(((m_patterns_usage & 0x200) != 0) && IsPattern_9(POSITION_TYPE_SELL))
   {  result += m_pattern_9;
      results++;
   }
//--- return the result
//if(result > 0)printf(__FUNCSIG__+" result is: %i",result);
   if(results > 0 && result > 0)
   {  return(int(round(result / results)));
   }
   return(0);
}
//+------------------------------------------------------------------+
//| Check for Pattern 0.                                             |
//+------------------------------------------------------------------+
bool CSignalAO_Envelopes::IsPattern_0(ENUM_POSITION_TYPE T)
{  if
   (
      T == POSITION_TYPE_BUY &&
      AO(X()) > 0.0 &&
      AO(X() + 1) < 0.0 &&
      Close(X() + 2) > Envelopes_Lo(X() + 2) &&
      Close(X() + 1) <= Envelopes_Lo(X() + 1) &&
      Close(X()) > Envelopes_Lo(X()) //m_symbol.Bid()
   )
   {  return(true);
   }
   else if
   (
      T == POSITION_TYPE_SELL &&
      AO(X()) < 0.0 &&
      AO(X() + 1) > 0.0 &&
      Close(X() + 2) < Envelopes_Up(X() + 2) &&
      Close(X() + 1) >= Envelopes_Up(X() + 1) &&
      Close(X()) < Envelopes_Up(X())
   )
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 1.                                             |
//+------------------------------------------------------------------+
bool CSignalAO_Envelopes::IsPattern_1(ENUM_POSITION_TYPE T)
{  vector _last = AO_Last3(X());
   if
   (
      T == POSITION_TYPE_BUY &&
      _last[0] < 0.0 &&
      _last[2] < 0.0 &&
      _last[0] > _last[2] &&
      Close(X() + 2) > Envelopes_Mid(X() + 2) &&
      Close(X() + 1) <= Envelopes_Mid(X() + 1) &&
      Close(X()) > Envelopes_Mid(X())
   )
   {  return(true);
   }
   else if
   (
      T == POSITION_TYPE_SELL &&
      _last[0] > 0.0 &&
      _last[2] > 0.0 &&
      _last[0] < _last[2] &&
      Close(X() + 2) < Envelopes_Mid(X() + 2) &&
      Close(X() + 1) >= Envelopes_Mid(X() + 1) &&
      Close(X()) < Envelopes_Mid(X())
   )
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 2.                                             |
//+------------------------------------------------------------------+
bool CSignalAO_Envelopes::IsPattern_2(ENUM_POSITION_TYPE T)
{  if
   (
      T == POSITION_TYPE_BUY &&
      AO(X() + 2) > AO(X() + 1) &&
      AO(X() + 1) < AO(X()) &&
      Close(X() + 2) > Envelopes_Lo(X() + 2) &&
      Close(X() + 1) <= Envelopes_Lo(X() + 1) &&
      Close(X()) > Envelopes_Lo(X())
   )
   {  return(true);
   }
   else if
   (
      T == POSITION_TYPE_SELL &&
      AO(X() + 2) < AO(X() + 1) &&
      AO(X() + 1) > AO(X()) &&
      Close(X() + 2) < Envelopes_Up(X() + 2) &&
      Close(X() + 1) >= Envelopes_Up(X() + 1) &&
      Close(X()) < Envelopes_Up(X())
   )
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 3.                                             |
//+------------------------------------------------------------------+
bool CSignalAO_Envelopes::IsPattern_3(ENUM_POSITION_TYPE T)
{  if
   (
      T == POSITION_TYPE_BUY &&
      AO(X()) - AO(X() + 1) > AO(X() + 1) - AO(X() + 2) &&
      AO(X() + 1) > AO(X() + 2) &&
      AO(X() + 2) > 0.0 &&
      Close(X() + 1) < Envelopes_Up(X() + 1) &&
      Close(X()) > Envelopes_Up(X())
   )
   {  return(true);
   }
   else if
   (
      T == POSITION_TYPE_SELL &&
      AO(X() + 1) - AO(X()) > AO(X() + 2) - AO(X() + 1) &&
      AO(X() + 2) > AO(X() + 1) &&
      AO(X() + 2) < 0.0 &&
      Close(X() + 1) > Envelopes_Lo(X() + 1) &&
      Close(X()) < Envelopes_Lo(X())
   )
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 4.                                             |
//+------------------------------------------------------------------+
bool CSignalAO_Envelopes::IsPattern_4(ENUM_POSITION_TYPE T)
{  if
   (
      T == POSITION_TYPE_BUY &&
      AO(X() + 2) > AO(X() + 1) &&
      AO(X() + 1) < AO(X()) &&
      AO(X() + 1) > 0.0 &&
      Close(X() + 2) <= Envelopes_Mid(X() + 2) &&
      Close(X() + 2) >= Envelopes_Lo(X() + 2) &&
      Close(X() + 1) <= Envelopes_Mid(X() + 1) &&
      Close(X() + 1) >= Envelopes_Lo(X() + 1) &&
      Close(X()) <= Envelopes_Mid(X()) &&
      Close(X()) >= Envelopes_Lo(X())
   )
   {  return(true);
   }
   else if
   (
      T == POSITION_TYPE_SELL &&
      AO(X() + 2) > AO(X() + 1) &&
      AO(X() + 1) < AO(X()) &&
      AO(X() + 1) > 0.0 &&
      Close(X() + 2) >= Envelopes_Mid(X() + 2) &&
      Close(X() + 2) <= Envelopes_Up(X() + 2) &&
      Close(X() + 1) >= Envelopes_Mid(X() + 1) &&
      Close(X() + 1) <= Envelopes_Up(X() + 1) &&
      Close(X()) >= Envelopes_Mid(X()) &&
      Close(X()) <= Envelopes_Up(X())
   )
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 5.                                             |
//+------------------------------------------------------------------+
bool CSignalAO_Envelopes::IsPattern_5(ENUM_POSITION_TYPE T)
{  vector _last = AO_Last3(X());
   if
   (
      T == POSITION_TYPE_BUY &&
      _last[0] < 0.0 &&
      _last[2] < 0.0 &&
      _last[0] > _last[2] &&
      Low(X()) < Low(X() + 1) &&
      Envelopes_Up(X() + 1) - Envelopes_Lo(X() + 1) > Envelopes_Up(X()) - Envelopes_Lo(X())
   )
   {  return(true);
   }
   else if
   (
      T == POSITION_TYPE_SELL &&
      _last[0] > 0.0 &&
      _last[2] > 0.0 &&
      _last[0] < _last[2] &&
      High(X()) > High(X() + 1) &&
      Envelopes_Up(X() + 1) - Envelopes_Lo(X() + 1) > Envelopes_Up(X()) - Envelopes_Lo(X())
   )
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 6.                                             |
//+------------------------------------------------------------------+
bool CSignalAO_Envelopes::IsPattern_6(ENUM_POSITION_TYPE T)
{  if
   (
      T == POSITION_TYPE_BUY &&
      AO(X() + 2) > 0.0 &&
      AO(X() + 1) < 0.0 &&
      AO(X()) > 0.0 &&
      Close(X() + 2) > Envelopes_Lo(X() + 2) &&
      Close(X() + 1) <= Envelopes_Lo(X() + 1) &&
      Close(X()) > Envelopes_Lo(X())
   )
   {  return(true);
   }
   else if
   (
      T == POSITION_TYPE_SELL &&
      AO(X() + 2) < 0.0 &&
      AO(X() + 1) > 0.0 &&
      AO(X()) < 0.0 &&
      Close(X() + 2) < Envelopes_Up(X() + 2) &&
      Close(X() + 1) >= Envelopes_Up(X() + 1) &&
      Close(X()) < Envelopes_Up(X())
   )
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 7.                                             \
//+------------------------------------------------------------------+
bool CSignalAO_Envelopes::IsPattern_7(ENUM_POSITION_TYPE T)
{  if
   (
      T == POSITION_TYPE_BUY &&
      AO(X() + 2) > 0.0 &&
      AO(X() + 1) > AO(X() + 2) &&
      AO(X()) > AO(X() + 1) &&
      Close(X() + 2) <= Envelopes_Lo(X() + 2) &&
      Close(X() + 1) > Envelopes_Lo(X() + 1) &&
      Close(X()) > Close(X() + 1)
   )
   {  return(true);
   }
   else if
   (
      T == POSITION_TYPE_SELL &&
      AO(X() + 2) < 0.0 &&
      AO(X() + 1) < AO(X() + 2) &&
      AO(X()) < AO(X() + 1) &&
      Close(X() + 2) >= Envelopes_Up(X() + 2) &&
      Close(X() + 1) < Envelopes_Up(X() + 1) &&
      Close(X()) < Close(X() + 1)
   )
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 8.                                             |
//+------------------------------------------------------------------+
bool CSignalAO_Envelopes::IsPattern_8(ENUM_POSITION_TYPE T)
{  if
   (
      T == POSITION_TYPE_BUY &&
      AO(X() + 2) > 0.0 &&
      AO(X() + 1) > AO(X() + 2) &&
      AO(X()) > AO(X() + 1) &&
      Close(X() + 2) > Envelopes_Up(X() + 2) &&
      Close(X() + 1) > Close(X() + 2) &&
      Close(X()) > Close(X() + 1)
   )
   {  return(true);
   }
   else if
   (
      T == POSITION_TYPE_SELL &&
      AO(X() + 2) < 0.0 &&
      AO(X() + 1) < AO(X() + 2) &&
      AO(X()) < AO(X() + 1) &&
      Close(X() + 2) < Envelopes_Lo(X() + 2) &&
      Close(X() + 1) < Close(X() + 2) &&
      Close(X()) < Close(X() + 1)
   )
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 9.                                             |
//+------------------------------------------------------------------+
bool CSignalAO_Envelopes::IsPattern_9(ENUM_POSITION_TYPE T)
{  if
   (
      T == POSITION_TYPE_BUY &&
      AO(X() + 2) > AO(X() + 1) &&
      AO(X() + 1) > AO(X()) &&
      AO(X()) > 0.0 &&
      Close(X() + 2) > Envelopes_Mid(X() + 2) &&
      Close(X() + 1) <= Envelopes_Mid(X() + 1) &&
      Close(X()) > Envelopes_Mid(X())
   )
   {  return(true);
   }
   else if
   (
      T == POSITION_TYPE_SELL &&
      AO(X() + 2) < AO(X() + 1) &&
      AO(X() + 1) < AO(X()) &&
      AO(X()) < 0.0 &&
      Close(X() + 2) < Envelopes_Mid(X() + 2) &&
      Close(X() + 1) >= Envelopes_Mid(X() + 1) &&
      Close(X()) < Envelopes_Mid(X())
   )
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
