//+------------------------------------------------------------------+
//|                                     SignalIchimoku_ADXWilder.mqh |
//|                             Copyright 2000-2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#include <Expert\ExpertSignal.mqh>
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Signals of Ichimoku and ADX                                |
//| Type=SignalAdvanced                                              |
//| Name=Ichimoku and ADX                                            |
//| ShortName=Ichimoku_ADXWilder                                               |
//| Class=CSignalIchimoku_ADXWilder                                            |
//| Page=signal_ichimoku_adxwilder                                             |
//| Parameter=Pattern_0,int,50,Pattern 0                             |
//| Parameter=Pattern_1,int,50,Pattern 1                             |
//| Parameter=Pattern_2,int,50,Pattern 2                             |
//| Parameter=Pattern_3,int,50,Pattern 3                             |
//| Parameter=Pattern_4,int,50,Pattern 4                             |
//| Parameter=Pattern_5,int,50,Pattern 5                             |
//| Parameter=Pattern_6,int,50,Pattern 6                             |
//| Parameter=Pattern_7,int,50,Pattern 7                             |
//| Parameter=Pattern_8,int,50,Pattern 8                             |
//| Parameter=Pattern_9,int,50,Pattern 9                             |
//| Parameter=PatternsUsed,int,255,Patterns Used BitMap              |
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+
//| Class CSignalIchimoku_ADXWilder.                                 |
//| Purpose: Class of generator of trade signals based on            |
//|          Signals of TRIX and Williams Percent Range.             |
//| Is derived from the CExpertSignal class.                         |
//+------------------------------------------------------------------+
#define __PERIOD 15
class CSignalIchimoku_ADXWilder : public CExpertSignal
{
protected:
   CiIchimoku            m_ichimoku;
   CiADXWilder             m_adxwilder;
   CiStdDev          m_stddev;
   int               m_patterns_used;
   //--- adjusted parameters

   //--- "weights" of market models (0-100)
   int               m_pattern_0;      // model 0
   int               m_pattern_1;      // model 1
   int               m_pattern_2;      // model 2
   int               m_pattern_3;      // model 3
   int               m_pattern_4;      // model 4
   int               m_pattern_5;      // model 5
   int               m_pattern_6;      // model 6
   int               m_pattern_7;      // model 7
   int               m_pattern_8;      // model 8
   int               m_pattern_9;      // model 9
   //
   //int               m_patterns_usage;   //

public:
   CSignalIchimoku_ADXWilder(void);
   ~CSignalIchimoku_ADXWilder(void);
   //--- methods of setting adjustable parameters
   //--- methods of adjusting "weights" of market models
   void              Pattern_0(int value)
   {  m_pattern_0 = value;
   }
   void              Pattern_1(int value)
   {  m_pattern_1 = value;
   }
   void              Pattern_2(int value)
   {  m_pattern_2 = value;
   }
   void              Pattern_3(int value)
   {  m_pattern_3 = value;
   }
   void              Pattern_4(int value)
   {  m_pattern_4 = value;
   }
   void              Pattern_5(int value)
   {  m_pattern_5 = value;
   }
   void              Pattern_6(int value)
   {  m_pattern_6 = value;
   }
   void              Pattern_7(int value)
   {  m_pattern_7 = value;
   }
   void              Pattern_8(int value)
   {  m_pattern_8 = value;
   }
   void              Pattern_9(int value)
   {  m_pattern_9 = value;
   }
   void              PatternsUsed(int value)
   {  m_patterns_used = value;
      PatternsUsage(value);
   }
   //--- method of verification of settings
   virtual bool      ValidationSettings(void);
   //--- method of creating the oscillator and timeseries
   virtual bool      InitIndicators(CIndicators *indicators);
   //--- methods of checking if the market models are formed
   virtual int       LongCondition(void) override;
   virtual int       ShortCondition(void) override;
   virtual double    Direction(void) override;

protected:
   //--- method of initialization of the oscillator
   bool              InitIchimoku_ADXWilder(CIndicators *indicators);
   //--- methods of getting data
   double            Ichimoku_TenkanSen(int ind)
   {  //
      m_ichimoku.Refresh(-1);
      return(m_ichimoku.TenkanSen(ind));
   }
   double            Ichimoku_KijunSen(int ind)
   {  //
      m_ichimoku.Refresh(-1);
      return(m_ichimoku.KijunSen(ind));
   }
   double            Ichimoku_SenkouSpanA(int ind)
   {  //
      m_ichimoku.Refresh(-1);
      return(m_ichimoku.SenkouSpanA(ind));
   }
   double            Ichimoku_SenkouSpanB(int ind)
   {  //
      m_ichimoku.Refresh(-1);
      return(m_ichimoku.SenkouSpanB(ind));
   }
   double            Ichimoku_ChinkouSpan(int ind)
   {  //
      m_ichimoku.Refresh(-1);
      return(m_ichimoku.ChinkouSpan(ind));
   }
   double            ADX(int ind)
   {  //
      m_adxwilder.Refresh(-1);
      return(m_adxwilder.Main(ind));
   }
   double            ADX_Plus(int ind)
   {  //
      m_adxwilder.Refresh(-1);
      return(m_adxwilder.Plus(ind));
   }
   double            ADX_Minus(int ind)
   {  //
      m_adxwilder.Refresh(-1);
      return(m_adxwilder.Minus(ind));
   }
   double            Close(int ind)
   {  //
      m_close.Refresh(-1);
      return(m_close.GetData(ind));
   }
   double            High(int ind)
   {  //
      m_high.Refresh(-1);
      return(m_high.GetData(ind));
   }
   double            Low(int ind)
   {  //
      m_low.Refresh(-1);
      return(m_low.GetData(ind));
   }
   int               X()
   {  //
      return(StartIndex());
   }
   //--- methods to check for patterns
   bool              IsPattern_0(ENUM_POSITION_TYPE T);
   bool              IsPattern_1(ENUM_POSITION_TYPE T);
   bool              IsPattern_2(ENUM_POSITION_TYPE T);
   bool              IsPattern_3(ENUM_POSITION_TYPE T);
   bool              IsPattern_4(ENUM_POSITION_TYPE T);
   bool              IsPattern_5(ENUM_POSITION_TYPE T);
   bool              IsPattern_6(ENUM_POSITION_TYPE T);
   bool              IsPattern_7(ENUM_POSITION_TYPE T);
   bool              IsPattern_8(ENUM_POSITION_TYPE T);
   bool              IsPattern_9(ENUM_POSITION_TYPE T);
};
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
CSignalIchimoku_ADXWilder::CSignalIchimoku_ADXWilder(void) : m_pattern_0(50),
   m_pattern_1(50),
   m_pattern_2(50),
   m_pattern_3(50),
   m_pattern_4(50),
   m_pattern_5(50),
   m_pattern_6(50),
   m_pattern_7(50),
   m_pattern_8(50),
   m_pattern_9(50)
//m_patterns_usage(255)
{
//--- initialization of protected data
   m_used_series = USE_SERIES_OPEN + USE_SERIES_HIGH + USE_SERIES_LOW + USE_SERIES_CLOSE + USE_SERIES_TICK_VOLUME;
   PatternsUsage(m_patterns_usage);
}
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
CSignalIchimoku_ADXWilder::~CSignalIchimoku_ADXWilder(void)
{
}
//+------------------------------------------------------------------+
//| Validation settings protected data.                              |
//+------------------------------------------------------------------+
bool CSignalIchimoku_ADXWilder::ValidationSettings(void)
{
//--- validation settings of additional filters
   if(!CExpertSignal::ValidationSettings())
      return(false);
//--- initial data checks
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Create indicators.                                               |
//+------------------------------------------------------------------+
bool CSignalIchimoku_ADXWilder::InitIndicators(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- initialization of indicators and timeseries of additional filters
   if(!CExpertSignal::InitIndicators(indicators))
      return(false);
//--- create and initialize MA oscillator
   if(!InitIchimoku_ADXWilder(indicators))
      return(false);
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Initialize MA indicators.                                        |
//+------------------------------------------------------------------+
bool CSignalIchimoku_ADXWilder::InitIchimoku_ADXWilder(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- add object to collection
   if(!indicators.Add(GetPointer(m_ichimoku)))
   {  printf(__FUNCTION__ + ": error adding object");
      return(false);
   }
   if(!indicators.Add(GetPointer(m_adxwilder)))
   {  printf(__FUNCTION__ + ": error adding object");
      return(false);
   }
//--- initialize object
   if(!m_ichimoku.Create(m_symbol.Name(), m_period, 9, 26, 52))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
   if(!m_adxwilder.Create(m_symbol.Name(), m_period, 14))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Detecting the "weighted" direction                               |
//+------------------------------------------------------------------+
double CSignalIchimoku_ADXWilder::Direction(void)
{  return(LongCondition() - ShortCondition());
}
//+------------------------------------------------------------------+
//| "Voting" that price will grow.                                   |
//+------------------------------------------------------------------+
int CSignalIchimoku_ADXWilder::LongCondition(void)
{  int result  = 0, results = 0;
//--- if the model 0 is used
   if(((m_patterns_usage & 0x01) != 0) && IsPattern_0(POSITION_TYPE_BUY))
   {  result += m_pattern_0;
      results++;
   }
//--- if the model 1 is used
   if(((m_patterns_usage & 0x02) != 0) && IsPattern_1(POSITION_TYPE_BUY))
   {  result += m_pattern_1;
      results++;
   }
//--- if the model 2 is used
   if(((m_patterns_usage & 0x04) != 0) && IsPattern_2(POSITION_TYPE_BUY))
   {  result += m_pattern_2;
      results++;
   }
//--- if the model 3 is used
   if(((m_patterns_usage & 0x08) != 0) && IsPattern_3(POSITION_TYPE_BUY))
   {  result += m_pattern_3;
      results++;
   }
//--- if the model 4 is used
   if(((m_patterns_usage & 0x10) != 0) && IsPattern_4(POSITION_TYPE_BUY))
   {  result += m_pattern_4;
      results++;
   }
//--- if the model 5 is used
   if(((m_patterns_usage & 0x20) != 0) && IsPattern_5(POSITION_TYPE_BUY))
   {  result += m_pattern_5;
      results++;
   }
//--- if the model 6 is used
   if(((m_patterns_usage & 0x40) != 0) && IsPattern_6(POSITION_TYPE_BUY))
   {  result += m_pattern_6;
      results++;
   }
//--- if the model 7 is used
   if(((m_patterns_usage & 0x80) != 0) && IsPattern_7(POSITION_TYPE_BUY))
   {  result += m_pattern_7;
      results++;
   }
//--- if the model 8 is used
   if(((m_patterns_usage & 0x100) != 0) && IsPattern_8(POSITION_TYPE_BUY))
   {  result += m_pattern_8;
      results++;
   }
//--- if the model 9 is used
   if(((m_patterns_usage & 0x200) != 0) && IsPattern_9(POSITION_TYPE_BUY))
   {  result += m_pattern_9;
      results++;
   }
//--- return the result
//if(result > 0)printf(__FUNCSIG__+" result is: %i",result);
   if(results > 0 && result > 0)
   {  return(int(round(result / results)));
   }
   return(0);
}
//+------------------------------------------------------------------+
//| "Voting" that price will fall.                                   |
//+------------------------------------------------------------------+
int CSignalIchimoku_ADXWilder::ShortCondition(void)
{  int result  = 0, results = 0;
//--- if the model 0 is used
   if(((m_patterns_used & 0x01) != 0) && IsPattern_0(POSITION_TYPE_SELL))
   {  result += m_pattern_0;
      results++;
   }
//--- if the model 1 is used
   if(((m_patterns_usage & 0x02) != 0) && IsPattern_1(POSITION_TYPE_SELL))
   {  result += m_pattern_1;
      results++;
   }
//--- if the model 2 is used
   if(((m_patterns_usage & 0x04) != 0) && IsPattern_2(POSITION_TYPE_SELL))
   {  result += m_pattern_2;
      results++;
   }
//--- if the model 3 is used
   if(((m_patterns_usage & 0x08) != 0) && IsPattern_3(POSITION_TYPE_SELL))
   {  result += m_pattern_3;
      results++;
   }
//--- if the model 4 is used
   if(((m_patterns_usage & 0x10) != 0) && IsPattern_4(POSITION_TYPE_SELL))
   {  result += m_pattern_4;
      results++;
   }
//--- if the model 5 is used
   if(((m_patterns_usage & 0x20) != 0) && IsPattern_5(POSITION_TYPE_SELL))
   {  result += m_pattern_5;
      results++;
   }
//--- if the model 6 is used
   if(((m_patterns_usage & 0x40) != 0) && IsPattern_6(POSITION_TYPE_SELL))
   {  result += m_pattern_6;
      results++;
   }
//--- if the model 7 is used
   if(((m_patterns_usage & 0x80) != 0) && IsPattern_7(POSITION_TYPE_SELL))
   {  result += m_pattern_7;
      results++;
   }
//--- if the model 8 is used
   if(((m_patterns_usage & 0x100) != 0) && IsPattern_8(POSITION_TYPE_SELL))
   {  result += m_pattern_8;
      results++;
   }
//--- if the model 9 is used
   if(((m_patterns_usage & 0x200) != 0) && IsPattern_9(POSITION_TYPE_SELL))
   {  result += m_pattern_9;
      results++;
   }
//--- return the result
//if(result > 0)printf(__FUNCSIG__+" result is: %i",result);
   if(results > 0 && result > 0)
   {  return(int(round(result / results)));
   }
   return(0);
}
//+------------------------------------------------------------------+
//| Check for Pattern 0.                                             |
//+------------------------------------------------------------------+
bool CSignalIchimoku_ADXWilder::IsPattern_0(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && Close(X() + 1) < Ichimoku_SenkouSpanA(X() + 1) && Close(X()) > Ichimoku_SenkouSpanA(X()) && ADX(X()) >= 25.0)
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && Close(X() + 1) > Ichimoku_SenkouSpanA(X() + 1) && Close(X()) < Ichimoku_SenkouSpanA(X()) && ADX(X()) >= 25.0)
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 1.                                             |
//+------------------------------------------------------------------+
bool CSignalIchimoku_ADXWilder::IsPattern_1(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && Ichimoku_TenkanSen(X() + 1) < Ichimoku_KijunSen(X() + 1) && Ichimoku_TenkanSen(X()) > Ichimoku_KijunSen(X()) && ADX(X()) >= 20.0)
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && Ichimoku_TenkanSen(X() + 1) > Ichimoku_KijunSen(X() + 1) && Ichimoku_TenkanSen(X()) < Ichimoku_KijunSen(X()) && ADX(X()) >= 20.0)
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 2.                                             |
//+------------------------------------------------------------------+
bool CSignalIchimoku_ADXWilder::IsPattern_2(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && Ichimoku_SenkouSpanA(X() + 1) < Ichimoku_SenkouSpanB(X() + 1) && Ichimoku_SenkouSpanA(X()) > Ichimoku_SenkouSpanB(X()) && ADX(X()) >= 25.0)
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && Ichimoku_SenkouSpanA(X() + 1) > Ichimoku_SenkouSpanB(X() + 1) && Ichimoku_SenkouSpanA(X()) < Ichimoku_SenkouSpanB(X()) && ADX(X()) >= 25.0)
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 3.                                             |
//+------------------------------------------------------------------+
bool CSignalIchimoku_ADXWilder::IsPattern_3(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && 
      Close(X() + 2) > Close(X() + 1) && Close(X() + 1) < Close(X()) &&
      Close(X() + 2) > Ichimoku_SenkouSpanA(X() + 2) && Close(X()) > Ichimoku_SenkouSpanA(X()) && 
      Close(X() + 1) <= Ichimoku_SenkouSpanA(X() + 1) && 
      ADX_Plus(X()) > ADX_Minus(X()) && ADX(X()) >= 25.0
      )
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL &&  
      Close(X() + 2) < Close(X() + 1) && Close(X() + 1) > Close(X()) &&
      Close(X() + 2) < Ichimoku_SenkouSpanA(X() + 2) && Close(X()) < Ichimoku_SenkouSpanA(X()) && 
      Close(X() + 1) >= Ichimoku_SenkouSpanA(X() + 1) && 
      ADX_Plus(X()) < ADX_Minus(X()) && ADX(X()) >= 25.0
      )
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 4.                                             |
//+------------------------------------------------------------------+
bool CSignalIchimoku_ADXWilder::IsPattern_4(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && 
      Ichimoku_ChinkouSpan(X() + 26) > Ichimoku_SenkouSpanA(X()) &&  
      ADX(X()) >= 25.0
      )
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL &&  
      Ichimoku_ChinkouSpan(X() + 26) < Ichimoku_SenkouSpanA(X()) &&  
      ADX(X()) >= 25.0
      )
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 5.                                             |
//+------------------------------------------------------------------+
bool CSignalIchimoku_ADXWilder::IsPattern_5(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && 
      Close(X() + 2) > Close(X() + 1) && Close(X() + 1) < Close(X()) &&
      Close(X() + 2) > Ichimoku_TenkanSen(X() + 2) && Close(X()) > Ichimoku_TenkanSen(X()) && 
      Close(X() + 1) <= Ichimoku_TenkanSen(X() + 1) && 
      ADX_Plus(X()) > ADX_Minus(X()) && ADX(X()) >= 25.0
      )
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL &&  
      Close(X() + 2) < Close(X() + 1) && Close(X() + 1) > Close(X()) &&
      Close(X() + 2) < Ichimoku_TenkanSen(X() + 2) && Close(X()) < Ichimoku_TenkanSen(X()) && 
      Close(X() + 1) >= Ichimoku_TenkanSen(X() + 1) && 
      ADX_Plus(X()) < ADX_Minus(X()) && ADX(X()) >= 25.0
      )
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 6.                                             |
//+------------------------------------------------------------------+
bool CSignalIchimoku_ADXWilder::IsPattern_6(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && 
   Close(X() + 1) < Ichimoku_KijunSen(X() + 1) && 
   Close(X()) > Ichimoku_KijunSen(X()) && 
   ADX_Plus(X()) > ADX_Minus(X()) && ADX(X()) >= 25.0)
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && 
   Close(X() + 1) > Ichimoku_KijunSen(X() + 1) && 
   Close(X()) < Ichimoku_KijunSen(X()) && 
   ADX_Plus(X()) < ADX_Minus(X()) && ADX(X()) >= 25.0)
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 7.                                             \
//+------------------------------------------------------------------+
bool CSignalIchimoku_ADXWilder::IsPattern_7(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && 
      Close(X() + 2) > Close(X() + 1) && Close(X() + 1) < Close(X()) &&
      Close(X() + 2) > Ichimoku_SenkouSpanB(X() + 2) && Close(X()) > Ichimoku_SenkouSpanB(X()) && 
      Close(X() + 1) <= Ichimoku_SenkouSpanB(X() + 1) && Ichimoku_SenkouSpanA(X()) > Ichimoku_SenkouSpanB(X()) && 
      ADX(X()) >= 20.0
      )
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL &&  
      Close(X() + 2) < Close(X() + 1) && Close(X() + 1) > Close(X()) &&
      Close(X() + 2) < Ichimoku_SenkouSpanB(X() + 2) && Close(X()) < Ichimoku_SenkouSpanB(X()) && 
      Close(X() + 1) >= Ichimoku_SenkouSpanB(X() + 1) && Ichimoku_SenkouSpanA(X()) < Ichimoku_SenkouSpanB(X()) && 
      ADX(X()) >= 20.0
      )
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 8.                                             |
//+------------------------------------------------------------------+
bool CSignalIchimoku_ADXWilder::IsPattern_8(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && 
      Close(X() + 1) < Close(X()) &&
      Close(X() + 1) > Ichimoku_SenkouSpanA(X() + 1) && Close(X()) > Ichimoku_SenkouSpanA(X()) && 
      Ichimoku_SenkouSpanA(X()) > Ichimoku_SenkouSpanB(X()) && 
      ADX(X()) >= 25.0
      )
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL &&  
      Close(X() + 1) > Close(X()) &&
      Close(X() + 1) < Ichimoku_SenkouSpanA(X() + 1) && Close(X()) < Ichimoku_SenkouSpanA(X()) && 
      Ichimoku_SenkouSpanA(X()) > Ichimoku_SenkouSpanB(X()) && 
      ADX(X()) >= 25.0
      )
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 9.                                             |
//+------------------------------------------------------------------+
bool CSignalIchimoku_ADXWilder::IsPattern_9(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && 
      Ichimoku_ChinkouSpan(X() + 26) > Ichimoku_SenkouSpanA(X()) &&
      //Ichimoku_ChinkouSpan(X() + 26) > Close(X()) && 
      Ichimoku_SenkouSpanA(X()) > Ichimoku_SenkouSpanB(X()) && 
      ADX(X()) >= 25.0
      )
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL &&  
      Ichimoku_ChinkouSpan(X() + 26) < Ichimoku_SenkouSpanA(X()) &&
      //Ichimoku_ChinkouSpan(X() + 26) < Close(X()) && 
      Ichimoku_SenkouSpanA(X()) < Ichimoku_SenkouSpanB(X()) && 
      ADX(X()) >= 25.0
      )
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
